/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.api.protocolrecords.impl.pb;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.thirdparty.protobuf.MessageOrBuilder;
import org.apache.hadoop.thirdparty.protobuf.TextFormat;
import org.apache.hadoop.yarn.api.protocolrecords.UpdateApplicationTimeoutsRequest;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationTimeoutType;
import org.apache.hadoop.yarn.api.records.impl.pb.ApplicationIdPBImpl;
import org.apache.hadoop.yarn.api.records.impl.pb.ProtoUtils;
import org.apache.hadoop.yarn.proto.YarnProtos;
import org.apache.hadoop.yarn.proto.YarnServiceProtos;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class UpdateApplicationTimeoutsRequestPBImpl
extends UpdateApplicationTimeoutsRequest {
    YarnServiceProtos.UpdateApplicationTimeoutsRequestProto proto = YarnServiceProtos.UpdateApplicationTimeoutsRequestProto.getDefaultInstance();
    YarnServiceProtos.UpdateApplicationTimeoutsRequestProto.Builder builder = null;
    boolean viaProto = false;
    private ApplicationId applicationId = null;
    private Map<ApplicationTimeoutType, String> applicationTimeouts = null;

    public UpdateApplicationTimeoutsRequestPBImpl() {
        this.builder = YarnServiceProtos.UpdateApplicationTimeoutsRequestProto.newBuilder();
    }

    public UpdateApplicationTimeoutsRequestPBImpl(YarnServiceProtos.UpdateApplicationTimeoutsRequestProto proto) {
        this.proto = proto;
        this.viaProto = true;
    }

    public YarnServiceProtos.UpdateApplicationTimeoutsRequestProto getProto() {
        this.mergeLocalToProto();
        this.proto = this.viaProto ? this.proto : this.builder.build();
        this.viaProto = true;
        return this.proto;
    }

    private void mergeLocalToProto() {
        if (this.viaProto) {
            this.maybeInitBuilder();
        }
        this.mergeLocalToBuilder();
        this.proto = this.builder.build();
        this.viaProto = true;
    }

    private void maybeInitBuilder() {
        if (this.viaProto || this.builder == null) {
            this.builder = YarnServiceProtos.UpdateApplicationTimeoutsRequestProto.newBuilder((YarnServiceProtos.UpdateApplicationTimeoutsRequestProto)this.proto);
        }
        this.viaProto = false;
    }

    private void mergeLocalToBuilder() {
        if (this.applicationId != null) {
            this.builder.setApplicationId(this.convertToProtoFormat(this.applicationId));
        }
        if (this.applicationTimeouts != null) {
            this.addApplicationTimeouts();
        }
    }

    public ApplicationId getApplicationId() {
        YarnServiceProtos.UpdateApplicationTimeoutsRequestProto p;
        Object object = p = this.viaProto ? this.proto : this.builder;
        if (this.applicationId != null) {
            return this.applicationId;
        }
        if (!p.hasApplicationId()) {
            return null;
        }
        this.applicationId = this.convertFromProtoFormat(p.getApplicationId());
        return this.applicationId;
    }

    public void setApplicationId(ApplicationId applicationId) {
        this.maybeInitBuilder();
        if (applicationId == null) {
            this.builder.clearApplicationId();
        }
        this.applicationId = applicationId;
    }

    private ApplicationIdPBImpl convertFromProtoFormat(YarnProtos.ApplicationIdProto p) {
        return new ApplicationIdPBImpl(p);
    }

    private YarnProtos.ApplicationIdProto convertToProtoFormat(ApplicationId t2) {
        return ((ApplicationIdPBImpl)t2).getProto();
    }

    public int hashCode() {
        return this.getProto().hashCode();
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other.getClass().isAssignableFrom(((Object)((Object)this)).getClass())) {
            return this.getProto().equals((Object)((UpdateApplicationTimeoutsRequestPBImpl)((Object)((Object)((Object)this)).getClass().cast(other))).getProto());
        }
        return false;
    }

    public String toString() {
        return TextFormat.shortDebugString((MessageOrBuilder)this.getProto());
    }

    public Map<ApplicationTimeoutType, String> getApplicationTimeouts() {
        this.initApplicationTimeout();
        return this.applicationTimeouts;
    }

    private void initApplicationTimeout() {
        if (this.applicationTimeouts != null) {
            return;
        }
        YarnServiceProtos.UpdateApplicationTimeoutsRequestProto p = this.viaProto ? this.proto : this.builder;
        List lists = p.getApplicationTimeoutsList();
        this.applicationTimeouts = new HashMap<ApplicationTimeoutType, String>(lists.size());
        for (YarnProtos.ApplicationUpdateTimeoutMapProto timeoutProto : lists) {
            this.applicationTimeouts.put(ProtoUtils.convertFromProtoFormat(timeoutProto.getApplicationTimeoutType()), timeoutProto.getExpireTime());
        }
    }

    public void setApplicationTimeouts(Map<ApplicationTimeoutType, String> appTimeouts) {
        if (appTimeouts == null) {
            return;
        }
        this.initApplicationTimeout();
        this.applicationTimeouts.clear();
        this.applicationTimeouts.putAll(appTimeouts);
    }

    private void addApplicationTimeouts() {
        this.maybeInitBuilder();
        this.builder.clearApplicationTimeouts();
        if (this.applicationTimeouts == null) {
            return;
        }
        Iterable<YarnProtos.ApplicationUpdateTimeoutMapProto> values = new Iterable<YarnProtos.ApplicationUpdateTimeoutMapProto>(){

            @Override
            public Iterator<YarnProtos.ApplicationUpdateTimeoutMapProto> iterator() {
                return new Iterator<YarnProtos.ApplicationUpdateTimeoutMapProto>(){
                    private Iterator<ApplicationTimeoutType> iterator;
                    {
                        this.iterator = UpdateApplicationTimeoutsRequestPBImpl.this.applicationTimeouts.keySet().iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.iterator.hasNext();
                    }

                    @Override
                    public YarnProtos.ApplicationUpdateTimeoutMapProto next() {
                        ApplicationTimeoutType key = this.iterator.next();
                        return YarnProtos.ApplicationUpdateTimeoutMapProto.newBuilder().setExpireTime((String)UpdateApplicationTimeoutsRequestPBImpl.this.applicationTimeouts.get(key)).setApplicationTimeoutType(ProtoUtils.convertToProtoFormat(key)).build();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
        this.builder.addAllApplicationTimeouts((Iterable)values);
    }
}

