/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.protocol;

import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.util.StringUtils;

@InterfaceAudience.Private
public final class HdfsConstants {
    public static final long QUOTA_DONT_SET = Long.MAX_VALUE;
    public static final long QUOTA_RESET = -1L;
    public static final int BYTES_IN_INTEGER = 4;
    public static final String HDFS_URI_SCHEME = "hdfs";
    public static final byte MEMORY_STORAGE_POLICY_ID = 15;
    public static final String MEMORY_STORAGE_POLICY_NAME = "LAZY_PERSIST";
    public static final byte ALLNVDIMM_STORAGE_POLICY_ID = 14;
    public static final String ALLNVDIMM_STORAGE_POLICY_NAME = "ALL_NVDIMM";
    public static final byte ALLSSD_STORAGE_POLICY_ID = 12;
    public static final String ALLSSD_STORAGE_POLICY_NAME = "ALL_SSD";
    public static final byte ONESSD_STORAGE_POLICY_ID = 10;
    public static final String ONESSD_STORAGE_POLICY_NAME = "ONE_SSD";
    public static final byte HOT_STORAGE_POLICY_ID = 7;
    public static final String HOT_STORAGE_POLICY_NAME = "HOT";
    public static final byte WARM_STORAGE_POLICY_ID = 5;
    public static final String WARM_STORAGE_POLICY_NAME = "WARM";
    public static final byte COLD_STORAGE_POLICY_ID = 2;
    public static final String COLD_STORAGE_POLICY_NAME = "COLD";
    public static final byte PROVIDED_STORAGE_POLICY_ID = 1;
    public static final String PROVIDED_STORAGE_POLICY_NAME = "PROVIDED";
    public static final int DEFAULT_DATA_SOCKET_SIZE = 0;
    public static final String DOT_SNAPSHOT_DIR = ".snapshot";
    public static final String SEPARATOR_DOT_SNAPSHOT_DIR = "/.snapshot";
    public static final String DOT_SNAPSHOT_DIR_SEPARATOR = ".snapshot/";
    public static final String SEPARATOR_DOT_SNAPSHOT_DIR_SEPARATOR = "/.snapshot/";
    public static final String DOT_RESERVED_STRING = ".reserved";
    public static final String DOT_RESERVED_PATH_PREFIX = "/.reserved";
    public static final String DOT_INODES_STRING = ".inodes";
    public static final long GRANDFATHER_GENERATION_STAMP = 0L;
    public static final long GRANDFATHER_INODE_ID = 0L;
    public static final byte BLOCK_STORAGE_POLICY_ID_UNSPECIFIED = 0;
    public static final String HA_DT_SERVICE_PREFIX = "ha-";
    public static final String SAFEMODE_EXCEPTION_CLASS_NAME = "org.apache.hadoop.hdfs.server.namenode.SafeModeException";
    public static final String CLIENT_NAMENODE_PROTOCOL_NAME = "org.apache.hadoop.hdfs.protocol.ClientProtocol";
    public static final String ROUTER_ADMIN_PROTOCOL_NAME = "org.apache.hadoop.hdfs.protocolPB.RouterAdminProtocol";
    public static final int READ_TIMEOUT = 60000;
    public static final int READ_TIMEOUT_EXTENSION = 5000;
    public static final int WRITE_TIMEOUT = 480000;
    public static final int WRITE_TIMEOUT_EXTENSION = 5000;
    public static final long LEASE_SOFTLIMIT_PERIOD = 60000L;

    protected HdfsConstants() {
    }

    public static enum ReencryptAction {
        CANCEL,
        START;

    }

    public static enum DatanodeReportType {
        ALL,
        LIVE,
        DEAD,
        DECOMMISSIONING,
        ENTERING_MAINTENANCE,
        IN_MAINTENANCE;

    }

    public static enum UpgradeAction {
        QUERY,
        FINALIZE;

    }

    public static enum RollingUpgradeAction {
        QUERY,
        PREPARE,
        FINALIZE;

        private static final Map<String, RollingUpgradeAction> MAP;

        public static RollingUpgradeAction fromString(String s2) {
            return MAP.get(StringUtils.toUpperCase((String)s2));
        }

        static {
            MAP = new HashMap<String, RollingUpgradeAction>();
            MAP.put("", QUERY);
            for (RollingUpgradeAction a : RollingUpgradeAction.values()) {
                MAP.put(a.name(), a);
            }
        }
    }

    public static enum StoragePolicySatisfierMode {
        EXTERNAL,
        NONE;

        private static final Map<String, StoragePolicySatisfierMode> MAP;

        public static StoragePolicySatisfierMode fromString(String s2) {
            return MAP.get(StringUtils.toUpperCase((String)s2));
        }

        static {
            MAP = new HashMap<String, StoragePolicySatisfierMode>();
            for (StoragePolicySatisfierMode a : StoragePolicySatisfierMode.values()) {
                MAP.put(a.name(), a);
            }
        }
    }

    public static enum SafeModeAction {
        SAFEMODE_LEAVE,
        SAFEMODE_ENTER,
        SAFEMODE_GET,
        SAFEMODE_FORCE_EXIT;

    }

    public static enum StoragePolicy {
        PROVIDED(1),
        COLD(2),
        WARM(5),
        HOT(7),
        ONE_SSD(10),
        ALL_SSD(12),
        ALL_NVDIMM(14),
        LAZY_PERSIST(15);

        private byte value;

        private StoragePolicy(byte value) {
            this.value = value;
        }

        public static StoragePolicy valueOf(int value) {
            switch (value) {
                case 1: {
                    return PROVIDED;
                }
                case 2: {
                    return COLD;
                }
                case 5: {
                    return WARM;
                }
                case 7: {
                    return HOT;
                }
                case 10: {
                    return ONE_SSD;
                }
                case 12: {
                    return ALL_SSD;
                }
                case 14: {
                    return ALL_NVDIMM;
                }
                case 15: {
                    return LAZY_PERSIST;
                }
            }
            return null;
        }

        public byte value() {
            return this.value;
        }
    }
}

