/*
 * Decompiled with CFR 0.152.
 */
package org.sparkproject.jetty.websocket.common;

import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.sparkproject.jetty.util.annotation.ManagedAttribute;
import org.sparkproject.jetty.util.component.AbstractLifeCycle;
import org.sparkproject.jetty.util.component.Dumpable;
import org.sparkproject.jetty.util.component.LifeCycle;
import org.sparkproject.jetty.websocket.common.WebSocketSession;
import org.sparkproject.jetty.websocket.common.WebSocketSessionListener;

public class SessionTracker
extends AbstractLifeCycle
implements WebSocketSessionListener,
Dumpable {
    private final Set<WebSocketSession> sessions = Collections.newSetFromMap(new ConcurrentHashMap());

    public Set<WebSocketSession> getSessions() {
        return Collections.unmodifiableSet(new HashSet<WebSocketSession>(this.sessions));
    }

    @Override
    public void onSessionCreated(WebSocketSession session) {
        LifeCycle.start((Object)session);
        this.sessions.add(session);
    }

    @Override
    public void onSessionClosed(WebSocketSession session) {
        this.sessions.remove(session);
        LifeCycle.stop((Object)session);
    }

    protected void doStop() throws Exception {
        for (WebSocketSession session : this.sessions) {
            LifeCycle.stop((Object)session);
        }
        super.doStop();
    }

    @ManagedAttribute(value="Total number of active WebSocket Sessions")
    public int getNumSessions() {
        return this.sessions.size();
    }

    public void dump(Appendable out, String indent) throws IOException {
        Dumpable.dumpObjects((Appendable)out, (String)indent, (Object)this, (Object[])new Object[]{this.sessions});
    }
}

