/*
 * Decompiled with CFR 0.152.
 */
package org.sparkproject.jetty.websocket.client.io;

import java.util.concurrent.Executor;
import org.sparkproject.jetty.io.ByteBufferPool;
import org.sparkproject.jetty.io.EndPoint;
import org.sparkproject.jetty.util.thread.Scheduler;
import org.sparkproject.jetty.websocket.api.BatchMode;
import org.sparkproject.jetty.websocket.api.WebSocketPolicy;
import org.sparkproject.jetty.websocket.api.WriteCallback;
import org.sparkproject.jetty.websocket.api.extensions.Frame;
import org.sparkproject.jetty.websocket.client.masks.Masker;
import org.sparkproject.jetty.websocket.client.masks.RandomMasker;
import org.sparkproject.jetty.websocket.common.WebSocketFrame;
import org.sparkproject.jetty.websocket.common.io.AbstractWebSocketConnection;

public class WebSocketClientConnection
extends AbstractWebSocketConnection {
    private final Masker masker = new RandomMasker();

    public WebSocketClientConnection(EndPoint endp, Executor executor, Scheduler scheduler, WebSocketPolicy websocketPolicy, ByteBufferPool bufferPool) {
        super(endp, executor, scheduler, websocketPolicy, bufferPool);
    }

    @Override
    public void outgoingFrame(Frame frame, WriteCallback callback, BatchMode batchMode) {
        if (frame instanceof WebSocketFrame) {
            this.masker.setMask((WebSocketFrame)frame);
        }
        super.outgoingFrame(frame, callback, batchMode);
    }
}

