/*
 * Decompiled with CFR 0.152.
 */
package org.sparkproject.jetty.websocket.client;

import java.net.URL;
import org.sparkproject.jetty.client.HttpClient;
import org.sparkproject.jetty.util.log.Log;
import org.sparkproject.jetty.util.log.Logger;
import org.sparkproject.jetty.util.resource.Resource;
import org.sparkproject.jetty.websocket.common.scopes.WebSocketContainerScope;
import org.sparkproject.jetty.xml.XmlConfiguration;

class XmlBasedHttpClientProvider {
    public static final Logger LOG = Log.getLogger(XmlBasedHttpClientProvider.class);

    XmlBasedHttpClientProvider() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HttpClient get(WebSocketContainerScope scope) {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        if (contextClassLoader == null) {
            return null;
        }
        URL resource = contextClassLoader.getResource("jetty-websocket-httpclient.xml");
        if (resource == null) {
            return null;
        }
        try {
            Thread.currentThread().setContextClassLoader(HttpClient.class.getClassLoader());
            HttpClient httpClient = XmlBasedHttpClientProvider.newHttpClient(resource);
            return httpClient;
        }
        finally {
            Thread.currentThread().setContextClassLoader(contextClassLoader);
        }
    }

    private static HttpClient newHttpClient(URL resource) {
        try {
            XmlConfiguration configuration = new XmlConfiguration(Resource.newResource((URL)resource));
            return (HttpClient)configuration.configure();
        }
        catch (Throwable t2) {
            LOG.warn("Failure to load HttpClient from XML {}", new Object[]{resource, t2});
            return null;
        }
    }
}

