/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.fips;

import org.bouncycastle.crypto.fips.FipsAlgorithm;
import org.bouncycastle.crypto.fips.FipsConsistencyTestFailedError;
import org.bouncycastle.crypto.fips.FipsSelfTestFailedError;
import org.bouncycastle.crypto.fips.FipsStatus;
import org.bouncycastle.crypto.fips.VariantInternalKatTest;
import org.bouncycastle.crypto.fips.VariantKatTest;
import org.bouncycastle.crypto.internal.test.BasicKatTest;
import org.bouncycastle.crypto.internal.test.ConsistencyTest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SelfTestExecutor {
    SelfTestExecutor() {
    }

    static <T> T validate(FipsAlgorithm fipsAlgorithm, T t2, BasicKatTest<T> basicKatTest) {
        try {
            if (!basicKatTest.hasTestPassed(t2)) {
                FipsStatus.moveToErrorStatus(new FipsSelfTestFailedError("Self test failed", fipsAlgorithm));
            }
            return t2;
        }
        catch (Exception exception) {
            FipsStatus.moveToErrorStatus(new FipsSelfTestFailedError("Exception on self test: " + exception.getMessage(), fipsAlgorithm));
            return null;
        }
    }

    static <T> T validate(FipsAlgorithm fipsAlgorithm, T t2, VariantKatTest<T> variantKatTest) {
        try {
            variantKatTest.evaluate(t2);
            return t2;
        }
        catch (TestFailedException testFailedException) {
            FipsStatus.moveToErrorStatus(new FipsSelfTestFailedError(testFailedException.getMessage(), fipsAlgorithm));
        }
        catch (Exception exception) {
            FipsStatus.moveToErrorStatus(new FipsSelfTestFailedError("Exception on self test: " + exception.getMessage(), fipsAlgorithm));
        }
        return null;
    }

    static void validate(FipsAlgorithm fipsAlgorithm, VariantInternalKatTest variantInternalKatTest) {
        try {
            if (!fipsAlgorithm.equals(variantInternalKatTest.getAlgorithm())) {
                throw new TestFailedException("Inconsistent algorithm tag for " + fipsAlgorithm);
            }
            variantInternalKatTest.evaluate();
        }
        catch (TestFailedException testFailedException) {
            FipsStatus.moveToErrorStatus(new FipsSelfTestFailedError(testFailedException.getMessage(), fipsAlgorithm));
        }
        catch (Exception exception) {
            FipsStatus.moveToErrorStatus(new FipsSelfTestFailedError("Exception on self test: " + exception.getMessage(), fipsAlgorithm));
        }
    }

    static <T> T validate(FipsAlgorithm fipsAlgorithm, T t2, ConsistencyTest<T> consistencyTest) {
        try {
            if (!consistencyTest.hasTestPassed(t2)) {
                FipsStatus.moveToErrorStatus(new FipsConsistencyTestFailedError("Consistency test failed", fipsAlgorithm));
            }
            return t2;
        }
        catch (Exception exception) {
            FipsStatus.moveToErrorStatus(new FipsConsistencyTestFailedError("Exception on consistency test: " + exception.getMessage(), fipsAlgorithm));
            return null;
        }
    }

    static <T> T fail(FipsAlgorithm fipsAlgorithm, T t2, BasicKatTest<T> basicKatTest) {
        FipsStatus.moveToErrorStatus(new FipsSelfTestFailedError("Self test failed", fipsAlgorithm));
        return null;
    }

    static <T> T fail(FipsAlgorithm fipsAlgorithm, T t2, VariantKatTest<T> variantKatTest) {
        FipsStatus.moveToErrorStatus(new FipsSelfTestFailedError("Kat test failed", fipsAlgorithm));
        return null;
    }

    static void fail(FipsAlgorithm fipsAlgorithm, VariantInternalKatTest variantInternalKatTest) {
        FipsStatus.moveToErrorStatus(new FipsSelfTestFailedError("Internal kat test failed", fipsAlgorithm));
    }

    static <T> T fail(FipsAlgorithm fipsAlgorithm, T t2, ConsistencyTest<T> consistencyTest) {
        FipsStatus.moveToErrorStatus(new FipsConsistencyTestFailedError("Consistency test failed", fipsAlgorithm));
        return null;
    }

    static class TestFailedException
    extends RuntimeException {
        public TestFailedException(String string) {
            super(string);
        }
    }
}

