/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.kafka010;

import java.io.Serializable;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.common.TopicPartition;
import org.apache.spark.internal.Logging;
import org.apache.spark.kafka010.KafkaConfigUpdater;
import org.apache.spark.streaming.kafka010.InternalKafkaConsumer$;
import org.apache.spark.streaming.kafka010.KafkaUtils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Predef$;
import scala.collection.JavaConverters$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005}f!B\u0013'\u0001\u0019\u0002\u0004\u0002\u0003 \u0001\u0005\u000b\u0007I\u0011\u0001!\t\u0011%\u0003!\u0011!Q\u0001\n\u0005C\u0001B\u0013\u0001\u0003\u0006\u0004%\ta\u0013\u0005\tK\u0002\u0011\t\u0011)A\u0005\u0019\")a\r\u0001C\u0001O\"A!\u0010\u0001b\u0001\n\u000313\u0010\u0003\u0004}\u0001\u0001\u0006I\u0001\u0016\u0005\b{\u0002\u0011\r\u0011\"\u0003\u007f\u0011\u001d\ti\u0001\u0001Q\u0001\n}D\u0011\"a\u0004\u0001\u0001\u0004%\t!!\u0005\t\u0013\u0005e\u0001\u00011A\u0005\u0002\u0005m\u0001\u0002CA\u0014\u0001\u0001\u0006K!a\u0005\t\u0013\u0005%\u0002\u00011A\u0005\u0002\u0005E\u0001\"CA\u0016\u0001\u0001\u0007I\u0011AA\u0017\u0011!\t\t\u0004\u0001Q!\n\u0005M\u0001\"CA\u001a\u0001\u0001\u0007I\u0011BA\u001b\u0011%\t\u0019\u0005\u0001a\u0001\n\u0013\t)\u0005\u0003\u0005\u0002J\u0001\u0001\u000b\u0015BA\u001c\u0011%\t\u0019\u0006\u0001a\u0001\n\u0013\t)\u0006C\u0005\u0002^\u0001\u0001\r\u0011\"\u0003\u0002`!A\u00111\r\u0001!B\u0013\t9\u0006C\u0004\u0002h\u0001!\t%!\u001b\t\r\u0005-\u0004\u0001\"\u0003\u007f\u0011\u001d\ti\u0007\u0001C\u0001\u0003_Bq!!\u001d\u0001\t\u0003\t\u0019\bC\u0004\u0002~\u0001!I!a \t\u000f\u0005M\u0005\u0001\"\u0001\u0002\u0016\"9\u0011Q\u0014\u0001\u0005\u0002\u0005}\u0005bBAR\u0001\u0011\u0005\u0011Q\u0015\u0005\b\u0003O\u0003A\u0011BAU\u0011\u001d\ti\u000b\u0001C\u0005\u0003_;\u0001\"a-'\u0011\u00031\u0013Q\u0017\u0004\bK\u0019B\tAJA\\\u0011\u00191\u0017\u0005\"\u0001\u0002:\"I\u00111X\u0011C\u0002\u0013%\u0011Q\u000b\u0005\t\u0003{\u000b\u0003\u0015!\u0003\u0002X\t)\u0012J\u001c;fe:\fGnS1gW\u0006\u001cuN\\:v[\u0016\u0014(BA\u0014)\u0003!Y\u0017MZ6baE\u0002$BA\u0015+\u0003%\u0019HO]3b[&twM\u0003\u0002,Y\u0005)1\u000f]1sW*\u0011QFL\u0001\u0007CB\f7\r[3\u000b\u0003=\n1a\u001c:h+\r\tDN^\n\u0004\u0001IB\u0004CA\u001a7\u001b\u0005!$\"A\u001b\u0002\u000bM\u001c\u0017\r\\1\n\u0005]\"$AB!osJ+g\r\u0005\u0002:y5\t!H\u0003\u0002<U\u0005A\u0011N\u001c;fe:\fG.\u0003\u0002>u\t9Aj\\4hS:<\u0017A\u0004;pa&\u001c\u0007+\u0019:uSRLwN\\\u0002\u0001+\u0005\t\u0005C\u0001\"H\u001b\u0005\u0019%B\u0001#F\u0003\u0019\u0019w.\\7p]*\u0011a\tL\u0001\u0006W\u000647.Y\u0005\u0003\u0011\u000e\u0013a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g.A\bu_BL7\rU1si&$\u0018n\u001c8!\u0003-Y\u0017MZ6b!\u0006\u0014\u0018-\\:\u0016\u00031\u0003B!\u0014*U?6\taJ\u0003\u0002P!\u0006!Q\u000f^5m\u0015\u0005\t\u0016\u0001\u00026bm\u0006L!a\u0015(\u0003\u00075\u000b\u0007\u000f\u0005\u0002V9:\u0011aK\u0017\t\u0003/Rj\u0011\u0001\u0017\u0006\u00033~\na\u0001\u0010:p_Rt\u0014BA.5\u0003\u0019\u0001&/\u001a3fM&\u0011QL\u0018\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005m#\u0004C\u00011d\u001b\u0005\t'B\u00012Q\u0003\u0011a\u0017M\\4\n\u0005\u0011\f'AB(cU\u0016\u001cG/\u0001\u0007lC\u001a\\\u0017\rU1sC6\u001c\b%\u0001\u0004=S:LGO\u0010\u000b\u0004QbL\b\u0003B5\u0001UVl\u0011A\n\t\u0003W2d\u0001\u0001B\u0003n\u0001\t\u0007aNA\u0001L#\ty'\u000f\u0005\u00024a&\u0011\u0011\u000f\u000e\u0002\b\u001d>$\b.\u001b8h!\t\u00194/\u0003\u0002ui\t\u0019\u0011I\\=\u0011\u0005-4H!B<\u0001\u0005\u0004q'!\u0001,\t\u000by*\u0001\u0019A!\t\u000b)+\u0001\u0019\u0001'\u0002\u000f\u001d\u0014x.\u001e9JIV\tA+\u0001\u0005he>,\b/\u00133!\u0003!\u0019wN\\:v[\u0016\u0014X#A@\u0011\r\u0005\u0005\u0011\u0011\u00026v\u001b\t\t\u0019AC\u0002~\u0003\u000bQ1!a\u0002F\u0003\u001d\u0019G.[3oiNLA!a\u0003\u0002\u0004\ti1*\u00194lC\u000e{gn];nKJ\f\u0011bY8ogVlWM\u001d\u0011\u0002\u000b%tWk]3\u0016\u0005\u0005M\u0001cA\u001a\u0002\u0016%\u0019\u0011q\u0003\u001b\u0003\u000f\t{w\u000e\\3b]\u0006I\u0011N\\+tK~#S-\u001d\u000b\u0005\u0003;\t\u0019\u0003E\u00024\u0003?I1!!\t5\u0005\u0011)f.\u001b;\t\u0013\u0005\u00152\"!AA\u0002\u0005M\u0011a\u0001=%c\u00051\u0011N\\+tK\u0002\na\"\\1sW\u0016$gi\u001c:DY>\u001cX-\u0001\nnCJ\\W\r\u001a$pe\u000ecwn]3`I\u0015\fH\u0003BA\u000f\u0003_A\u0011\"!\n\u000f\u0003\u0003\u0005\r!a\u0005\u0002\u001f5\f'o[3e\r>\u00148\t\\8tK\u0002\naAY;gM\u0016\u0014XCAA\u001c!\u0015i\u0015\u0011HA\u001f\u0013\r\tYD\u0014\u0002\r\u0019&\u001cH/\u0013;fe\u0006$xN\u001d\t\u0007\u0003\u0003\tyD[;\n\t\u0005\u0005\u00131\u0001\u0002\u000f\u0007>t7/^7feJ+7m\u001c:e\u0003)\u0011WO\u001a4fe~#S-\u001d\u000b\u0005\u0003;\t9\u0005C\u0005\u0002&E\t\t\u00111\u0001\u00028\u00059!-\u001e4gKJ\u0004\u0003f\u0001\n\u0002NA\u00191'a\u0014\n\u0007\u0005ECG\u0001\u0005w_2\fG/\u001b7f\u0003)qW\r\u001f;PM\u001a\u001cX\r^\u000b\u0003\u0003/\u00022aMA-\u0013\r\tY\u0006\u000e\u0002\u0005\u0019>tw-\u0001\boKb$xJ\u001a4tKR|F%Z9\u0015\t\u0005u\u0011\u0011\r\u0005\n\u0003K!\u0012\u0011!a\u0001\u0003/\n1B\\3yi>3gm]3uA!\u001aQ#!\u0014\u0002\u0011Q|7\u000b\u001e:j]\u001e$\u0012\u0001V\u0001\u000fGJ,\u0017\r^3D_:\u001cX/\\3s\u0003\u0015\u0019Gn\\:f)\t\ti\"A\u0002hKR$b!!\u0010\u0002v\u0005e\u0004bBA<3\u0001\u0007\u0011qK\u0001\u0007_\u001a47/\u001a;\t\u000f\u0005m\u0014\u00041\u0001\u0002X\u00059A/[7f_V$\u0018aE:lSBtUmZ1uSZ,wJ\u001a4tKR\u001cH\u0003BA\u001f\u0003\u0003Cq!a!\u001b\u0001\u0004\ti$\u0001\u0004sK\u000e|'\u000f\u001a\u0015\u00045\u0005\u001d\u0005\u0003BAE\u0003\u001fk!!a#\u000b\u0007\u00055E'\u0001\u0006b]:|G/\u0019;j_:LA!!%\u0002\f\n9A/Y5me\u0016\u001c\u0017AD2p[B\f7\r^3e'R\f'\u000f\u001e\u000b\u0007\u0003;\t9*!'\t\u000f\u0005]4\u00041\u0001\u0002X!9\u00111T\u000eA\u0002\u0005]\u0013!\u00049pY2$\u0016.\\3pkRl5/A\u0007d_6\u0004\u0018m\u0019;fI:+\u0007\u0010\u001e\u000b\u0005\u0003{\t\t\u000bC\u0004\u0002\u001cr\u0001\r!a\u0016\u0002#\r|W\u000e]1di\u0016$\u0007K]3wS>,8\u000f\u0006\u0002\u0002>\u0005!1/Z3l)\u0011\ti\"a+\t\u000f\u0005]d\u00041\u0001\u0002X\u0005!\u0001o\u001c7m)\u0011\ti\"!-\t\u000f\u0005mt\u00041\u0001\u0002X\u0005)\u0012J\u001c;fe:\fGnS1gW\u0006\u001cuN\\:v[\u0016\u0014\bCA5\"'\t\t#\u0007\u0006\u0002\u00026\u0006qQKT&O\u001f^sul\u0014$G'\u0016#\u0016aD+O\u0017:{uKT0P\r\u001a\u001bV\t\u0016\u0011")
public class InternalKafkaConsumer<K, V>
implements Logging {
    private final TopicPartition topicPartition;
    private final java.util.Map<String, Object> kafkaParams;
    private final String groupId;
    private final KafkaConsumer<K, V> consumer;
    private boolean inUse;
    private boolean markedForClose;
    private volatile ListIterator<ConsumerRecord<K, V>> buffer;
    private volatile long nextOffset;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    public java.util.Map<String, Object> kafkaParams() {
        return this.kafkaParams;
    }

    public String groupId() {
        return this.groupId;
    }

    private KafkaConsumer<K, V> consumer() {
        return this.consumer;
    }

    public boolean inUse() {
        return this.inUse;
    }

    public void inUse_$eq(boolean x$1) {
        this.inUse = x$1;
    }

    public boolean markedForClose() {
        return this.markedForClose;
    }

    public void markedForClose_$eq(boolean x$1) {
        this.markedForClose = x$1;
    }

    private ListIterator<ConsumerRecord<K, V>> buffer() {
        return this.buffer;
    }

    private void buffer_$eq(ListIterator<ConsumerRecord<K, V>> x$1) {
        this.buffer = x$1;
    }

    private long nextOffset() {
        return this.nextOffset;
    }

    private void nextOffset_$eq(long x$1) {
        this.nextOffset = x$1;
    }

    public String toString() {
        return new StringBuilder(55).append("InternalKafkaConsumer(").append("hash=").append(Integer.toHexString(this.hashCode())).append(", ").append("groupId=").append(this.groupId()).append(", ").append("topicPartition=").append(this.topicPartition()).append(")").toString();
    }

    private KafkaConsumer<K, V> createConsumer() {
        java.util.Map<String, Object> updatedKafkaParams = new KafkaConfigUpdater("executor", (Map<String, Object>)((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(this.kafkaParams()).asScala()).toMap(Predef$.MODULE$.$conforms())).setAuthenticationConfigIfNeeded().build();
        KafkaConsumer c = new KafkaConsumer(updatedKafkaParams);
        List<Object> topics = Arrays.asList((Object[])new TopicPartition[]{this.topicPartition()});
        c.assign(topics);
        return c;
    }

    public void close() {
        this.consumer().close();
    }

    public ConsumerRecord<K, V> get(long offset, long timeout) {
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(28).append("Get ").append(this.groupId()).append(" ").append(this.topicPartition()).append(" nextOffset ").append(this.nextOffset()).append(" requested ").append(offset).toString());
        if (offset != this.nextOffset()) {
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(20).append("Initial fetch for ").append(this.groupId()).append(" ").append(this.topicPartition()).append(" ").append(offset).toString());
            this.seek(offset);
            this.poll(timeout);
        }
        if (!this.buffer().hasNext()) {
            this.poll(timeout);
        }
        Predef$.MODULE$.require(this.buffer().hasNext(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(47).append("Failed to get records for ").append(this.groupId()).append(" ").append(this.topicPartition()).append(" ").append(offset).append(" after polling for ").append(timeout).toString());
        ConsumerRecord<K, V> record = this.buffer().next();
        this.nextOffset_$eq(offset + 1L);
        return this.skipNegativeOffsets(record);
    }

    private ConsumerRecord<K, V> skipNegativeOffsets(ConsumerRecord<K, V> record) {
        while (record.offset() == (long)KafkaUtils$.MODULE$.eofOffset()) {
            this.log().debug("EOF message is received");
            if (this.buffer().hasNext()) {
                record = this.buffer().next();
                continue;
            }
            return null;
        }
        return record;
    }

    public void compactedStart(long offset, long pollTimeoutMs) {
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(27).append("compacted start ").append(this.groupId()).append(" ").append(this.topicPartition()).append(" starting ").append(offset).toString());
        if (offset != this.nextOffset()) {
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(30).append("Initial fetch for compacted ").append(this.groupId()).append(" ").append(this.topicPartition()).append(" ").append(offset).toString());
            this.seek(offset);
            this.poll(pollTimeoutMs);
            return;
        }
    }

    public ConsumerRecord<K, V> compactedNext(long pollTimeoutMs) {
        if (!this.buffer().hasNext()) {
            this.poll(pollTimeoutMs);
        }
        Predef$.MODULE$.require(this.buffer().hasNext(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(56).append("Failed to get records for compacted ").append(this.groupId()).append(" ").append(this.topicPartition()).append(" ").append("after polling for ").append(pollTimeoutMs).toString());
        ConsumerRecord<K, V> record = this.buffer().next();
        this.nextOffset_$eq(record.offset() + 1L);
        return record;
    }

    public ConsumerRecord<K, V> compactedPrevious() {
        return this.buffer().previous();
    }

    private void seek(long offset) {
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(12).append("Seeking to ").append(this.topicPartition()).append(" ").append(offset).toString());
        this.consumer().seek(this.topicPartition(), offset);
    }

    private void poll(long timeout) {
        ConsumerRecords p = this.consumer().poll(Duration.ofMillis(timeout));
        List r = p.records(this.topicPartition());
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(9).append("Polled ").append(p.partitions()).append("  ").append(r.size()).toString());
        this.buffer_$eq(r.listIterator());
    }

    public InternalKafkaConsumer(TopicPartition topicPartition, java.util.Map<String, Object> kafkaParams) {
        this.topicPartition = topicPartition;
        this.kafkaParams = kafkaParams;
        Logging.$init$((Logging)this);
        this.groupId = (String)kafkaParams.get("group.id");
        this.consumer = this.createConsumer();
        this.inUse = true;
        this.markedForClose = false;
        this.buffer = Collections.emptyListIterator();
        this.nextOffset = InternalKafkaConsumer$.MODULE$.org$apache$spark$streaming$kafka010$InternalKafkaConsumer$$UNKNOWN_OFFSET();
    }
}

