/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.client.cli;

import java.io.IOException;
import java.io.InputStream;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.commons.lang3.time.DurationFormatUtils;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.http.HttpConfig;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authentication.client.AuthenticatedURL;
import org.apache.hadoop.security.authentication.client.ConnectionConfigurator;
import org.apache.hadoop.security.ssl.SSLFactory;
import org.apache.hadoop.thirdparty.com.google.common.cache.Cache;
import org.apache.hadoop.thirdparty.com.google.common.cache.CacheBuilder;
import org.apache.hadoop.util.Time;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationsRequest;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.QueueInfo;
import org.apache.hadoop.yarn.api.records.QueueStatistics;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.apache.hadoop.yarn.api.records.YarnClusterMetrics;
import org.apache.hadoop.yarn.client.cli.YarnCLI;
import org.apache.hadoop.yarn.conf.HAUtil;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.webapp.util.WebAppUtils;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TopCLI
extends YarnCLI {
    private static final String CLUSTER_INFO_URL = "/ws/v1/cluster/info";
    private static final Logger LOG = LoggerFactory.getLogger(TopCLI.class);
    private String CLEAR = "\u001b[2J";
    private String CLEAR_LINE = "\u001b[2K";
    private String SET_CURSOR_HOME = "\u001b[H";
    private String CHANGE_BACKGROUND = "\u001b[7m";
    private String RESET_BACKGROUND = "\u001b[0m";
    private String SET_CURSOR_LINE_7_COLUMN_0 = "\u001b[7;0f";
    protected Cache<GetApplicationsRequest, List<ApplicationReport>> applicationReportsCache = CacheBuilder.newBuilder().maximumSize(1000L).expireAfterWrite(5L, TimeUnit.SECONDS).build();
    public static final Comparator<ApplicationInformation> AppIDComparator = new Comparator<ApplicationInformation>(){

        @Override
        public int compare(ApplicationInformation a1, ApplicationInformation a2) {
            return a1.appid.compareTo(a2.appid);
        }
    };
    public static final Comparator<ApplicationInformation> UserComparator = new Comparator<ApplicationInformation>(){

        @Override
        public int compare(ApplicationInformation a1, ApplicationInformation a2) {
            return a1.user.compareTo(a2.user);
        }
    };
    public static final Comparator<ApplicationInformation> AppTypeComparator = new Comparator<ApplicationInformation>(){

        @Override
        public int compare(ApplicationInformation a1, ApplicationInformation a2) {
            return a1.type.compareTo(a2.type);
        }
    };
    public static final Comparator<ApplicationInformation> QueueNameComparator = new Comparator<ApplicationInformation>(){

        @Override
        public int compare(ApplicationInformation a1, ApplicationInformation a2) {
            return a1.queue.compareTo(a2.queue);
        }
    };
    public static final Comparator<ApplicationInformation> UsedContainersComparator = new Comparator<ApplicationInformation>(){

        @Override
        public int compare(ApplicationInformation a1, ApplicationInformation a2) {
            return a1.usedContainers - a2.usedContainers;
        }
    };
    public static final Comparator<ApplicationInformation> ReservedContainersComparator = new Comparator<ApplicationInformation>(){

        @Override
        public int compare(ApplicationInformation a1, ApplicationInformation a2) {
            return a1.reservedContainers - a2.reservedContainers;
        }
    };
    public static final Comparator<ApplicationInformation> UsedMemoryComparator = new Comparator<ApplicationInformation>(){

        @Override
        public int compare(ApplicationInformation a1, ApplicationInformation a2) {
            return Long.compare(a1.usedMemory, a2.usedMemory);
        }
    };
    public static final Comparator<ApplicationInformation> ReservedMemoryComparator = new Comparator<ApplicationInformation>(){

        @Override
        public int compare(ApplicationInformation a1, ApplicationInformation a2) {
            return Long.compare(a1.reservedMemory, a2.reservedMemory);
        }
    };
    public static final Comparator<ApplicationInformation> UsedVCoresComparator = new Comparator<ApplicationInformation>(){

        @Override
        public int compare(ApplicationInformation a1, ApplicationInformation a2) {
            return a1.usedVirtualCores - a2.usedVirtualCores;
        }
    };
    public static final Comparator<ApplicationInformation> ReservedVCoresComparator = new Comparator<ApplicationInformation>(){

        @Override
        public int compare(ApplicationInformation a1, ApplicationInformation a2) {
            return a1.reservedVirtualCores - a2.reservedVirtualCores;
        }
    };
    public static final Comparator<ApplicationInformation> VCoreSecondsComparator = new Comparator<ApplicationInformation>(){

        @Override
        public int compare(ApplicationInformation a1, ApplicationInformation a2) {
            return Long.compare(a1.vcoreSeconds, a2.vcoreSeconds);
        }
    };
    public static final Comparator<ApplicationInformation> MemorySecondsComparator = new Comparator<ApplicationInformation>(){

        @Override
        public int compare(ApplicationInformation a1, ApplicationInformation a2) {
            return Long.compare(a1.memorySeconds, a2.memorySeconds);
        }
    };
    public static final Comparator<ApplicationInformation> ProgressComparator = new Comparator<ApplicationInformation>(){

        @Override
        public int compare(ApplicationInformation a1, ApplicationInformation a2) {
            return Float.compare(a1.progress, a2.progress);
        }
    };
    public static final Comparator<ApplicationInformation> RunningTimeComparator = new Comparator<ApplicationInformation>(){

        @Override
        public int compare(ApplicationInformation a1, ApplicationInformation a2) {
            return Long.compare(a1.runningTime, a2.runningTime);
        }
    };
    public static final Comparator<ApplicationInformation> AppNameComparator = new Comparator<ApplicationInformation>(){

        @Override
        public int compare(ApplicationInformation a1, ApplicationInformation a2) {
            return a1.name.compareTo(a2.name);
        }
    };
    public static final Comparator<ApplicationInformation> AppPriorityComparator = new Comparator<ApplicationInformation>(){

        @Override
        public int compare(ApplicationInformation a1, ApplicationInformation a2) {
            return a1.priority - a2.priority;
        }
    };
    long refreshPeriod = 3000L;
    int terminalWidth = -1;
    int terminalHeight = -1;
    String appsHeader;
    boolean ascendingSort = false;
    long rmStartTime;
    Comparator<ApplicationInformation> comparator;
    Options opts;
    CommandLine cliParser;
    Set<String> queues;
    Set<String> users;
    Set<String> types;
    DisplayScreen displayScreen;
    AtomicBoolean showingTopScreen;
    AtomicBoolean runMainLoop;
    AtomicBoolean runKeyboardMonitor;
    final Object lock = new Object();
    String currentSortField;
    Map<String, Columns> keyFieldsMap;
    List<String> sortedKeys;
    Thread displayThread;
    final EnumMap<Columns, ColumnInformation> columnInformationEnumMap;

    public TopCLI() throws IOException, InterruptedException {
        this.queues = new HashSet<String>();
        this.users = new HashSet<String>();
        this.types = new HashSet<String>();
        this.comparator = UsedContainersComparator;
        this.displayScreen = DisplayScreen.TOP;
        this.showingTopScreen = new AtomicBoolean();
        this.showingTopScreen.set(true);
        this.currentSortField = "c";
        this.keyFieldsMap = new HashMap<String, Columns>();
        this.runKeyboardMonitor = new AtomicBoolean();
        this.runMainLoop = new AtomicBoolean();
        this.runKeyboardMonitor.set(true);
        this.runMainLoop.set(true);
        this.displayThread = Thread.currentThread();
        this.columnInformationEnumMap = new EnumMap(Columns.class);
        this.generateColumnInformationMap();
        this.generateKeyFieldsMap();
        this.sortedKeys = new ArrayList<String>(this.keyFieldsMap.keySet());
        Collections.sort(this.sortedKeys);
        this.setTerminalSequences();
    }

    public static void main(String[] args) throws Exception {
        TopCLI topImp = new TopCLI();
        topImp.addShutdownHook();
        topImp.setSysOutPrintStream(System.out);
        topImp.setSysErrPrintStream(System.err);
        int res = ToolRunner.run((Tool)topImp, (String[])args);
        topImp.stop();
        System.exit(res);
    }

    public int run(String[] args) throws Exception {
        try {
            this.parseOptions(args);
            if (this.cliParser.hasOption("help")) {
                this.printUsage();
                return 0;
            }
        }
        catch (Exception e) {
            LOG.error("Unable to parse options", (Throwable)e);
            return 1;
        }
        this.createAndStartYarnClient();
        this.setAppsHeader();
        KeyboardMonitor keyboardMonitor = new KeyboardMonitor();
        keyboardMonitor.start();
        this.rmStartTime = this.getRMStartTime();
        this.clearScreen();
        while (this.runMainLoop.get()) {
            block10: {
                if (this.displayScreen == DisplayScreen.TOP) {
                    this.showTopScreen();
                    try {
                        Thread.sleep(this.refreshPeriod);
                        break block10;
                    }
                    catch (InterruptedException ie) {
                        break;
                    }
                }
                if (this.displayScreen == DisplayScreen.SORT) {
                    this.showSortScreen();
                    Thread.sleep(100L);
                } else if (this.displayScreen == DisplayScreen.FIELDS) {
                    this.showFieldsScreen();
                    Thread.sleep(100L);
                }
            }
            if (this.rmStartTime != -1L) continue;
            this.rmStartTime = this.getRMStartTime();
        }
        return 0;
    }

    private void parseOptions(String[] args) throws ParseException, IOException, InterruptedException {
        this.opts = new Options();
        this.opts.addOption("queues", true, "Comma separated list of queues to restrict applications");
        this.opts.addOption("users", true, "Comma separated list of users to restrict applications");
        this.opts.addOption("types", true, "Comma separated list of types to restrict applications, case sensitive(though the display is lower case)");
        this.opts.addOption("cols", true, "Number of columns on the terminal");
        this.opts.addOption("rows", true, "Number of rows on the terminal");
        this.opts.addOption("help", false, "Print usage; for help while the tool is running press 'h' + Enter");
        this.opts.addOption("delay", true, "The refresh delay(in seconds), default is 3 seconds");
        this.cliParser = new GnuParser().parse(this.opts, args);
        if (this.cliParser.hasOption("queues")) {
            String clqueues = this.cliParser.getOptionValue("queues");
            String[] queuesArray = clqueues.split(",");
            this.queues.addAll(Arrays.asList(queuesArray));
        }
        if (this.cliParser.hasOption("users")) {
            String clusers = this.cliParser.getOptionValue("users");
            this.users.addAll(Arrays.asList(clusers.split(",")));
        }
        if (this.cliParser.hasOption("types")) {
            String cltypes = this.cliParser.getOptionValue("types");
            this.types.addAll(Arrays.asList(cltypes.split(",")));
        }
        if (this.cliParser.hasOption("cols")) {
            this.terminalWidth = Integer.parseInt(this.cliParser.getOptionValue("cols"));
        } else {
            this.setTerminalWidth();
        }
        if (this.cliParser.hasOption("rows")) {
            this.terminalHeight = Integer.parseInt(this.cliParser.getOptionValue("rows"));
        } else {
            this.setTerminalHeight();
        }
        if (this.cliParser.hasOption("delay")) {
            int delay = Integer.parseInt(this.cliParser.getOptionValue("delay"));
            if (delay < 1) {
                LOG.warn("Delay set too low, using default");
            } else {
                this.refreshPeriod = delay * 1000;
            }
        }
    }

    private void printUsage() {
        new HelpFormatter().printHelp("yarn top", this.opts);
        System.out.println("");
        System.out.println("'yarn top' is a tool to help cluster administrators understand cluster usage better.");
        System.out.println("Some notes about the implementation:");
        System.out.println("  1. Fetching information for all the apps is an expensive call for the RM.");
        System.out.println("     To prevent a performance degradation, the results are cached for 5 seconds,");
        System.out.println("     irrespective of the delay value. Information about the NodeManager(s) and queue");
        System.out.println("     utilization stats are fetched at the specified delay interval. Once we have a");
        System.out.println("     better understanding of the performance impact, this might change.");
        System.out.println("  2. Since the tool is implemented in Java, you must hit Enter for key presses to");
        System.out.println("     be processed.");
    }

    private void setAppsHeader() {
        ArrayList<String> formattedStrings = new ArrayList<String>();
        for (Map.Entry<Columns, ColumnInformation> entry : this.columnInformationEnumMap.entrySet()) {
            if (!entry.getValue().display) continue;
            formattedStrings.add(String.format(entry.getValue().format, entry.getValue().header));
        }
        this.appsHeader = StringUtils.join((Object[])formattedStrings.toArray(), (String)" ");
        this.appsHeader = this.appsHeader.length() > this.terminalWidth ? this.appsHeader.substring(0, this.terminalWidth - System.lineSeparator().length()) : this.appsHeader + StringUtils.repeat((String)" ", (int)(this.terminalWidth - this.appsHeader.length() - System.lineSeparator().length()));
        this.appsHeader = this.appsHeader + System.lineSeparator();
    }

    private void setTerminalWidth() throws IOException, InterruptedException {
        if (this.terminalWidth != -1) {
            return;
        }
        String[] command = new String[]{"tput", "cols"};
        String op = this.getCommandOutput(command).trim();
        try {
            this.terminalWidth = Integer.parseInt(op);
        }
        catch (NumberFormatException ne) {
            LOG.warn("Couldn't determine terminal width, setting to 80", (Throwable)ne);
            this.terminalWidth = 80;
        }
    }

    private void setTerminalHeight() throws IOException, InterruptedException {
        if (this.terminalHeight != -1) {
            return;
        }
        String[] command = new String[]{"tput", "lines"};
        String op = this.getCommandOutput(command).trim();
        try {
            this.terminalHeight = Integer.parseInt(op);
        }
        catch (NumberFormatException ne) {
            LOG.warn("Couldn't determine terminal height, setting to 24", (Throwable)ne);
            this.terminalHeight = 24;
        }
    }

    protected void setTerminalSequences() throws IOException, InterruptedException {
        String[] tput_cursor_home = new String[]{"tput", "cup", "0", "0"};
        String[] tput_clear = new String[]{"tput", "clear"};
        String[] tput_clear_line = new String[]{"tput", "el"};
        String[] tput_set_cursor_line_7_column_0 = new String[]{"tput", "cup", "6", "0"};
        String[] tput_change_background = new String[]{"tput", "smso"};
        String[] tput_reset_background = new String[]{"tput", "rmso"};
        this.SET_CURSOR_HOME = this.getCommandOutput(tput_cursor_home);
        this.CLEAR = this.getCommandOutput(tput_clear);
        this.CLEAR_LINE = this.getCommandOutput(tput_clear_line);
        this.SET_CURSOR_LINE_7_COLUMN_0 = this.getCommandOutput(tput_set_cursor_line_7_column_0);
        this.CHANGE_BACKGROUND = this.getCommandOutput(tput_change_background);
        this.RESET_BACKGROUND = this.getCommandOutput(tput_reset_background);
    }

    private void generateColumnInformationMap() {
        this.columnInformationEnumMap.put(Columns.APPID, new ColumnInformation("APPLICATIONID", "%31s", true, "Application Id", "a"));
        this.columnInformationEnumMap.put(Columns.USER, new ColumnInformation("USER", "%-10s", true, "Username", "u"));
        this.columnInformationEnumMap.put(Columns.TYPE, new ColumnInformation("TYPE", "%10s", true, "Application type", "t"));
        this.columnInformationEnumMap.put(Columns.QUEUE, new ColumnInformation("QUEUE", "%10s", true, "Application queue", "q"));
        this.columnInformationEnumMap.put(Columns.PRIORITY, new ColumnInformation("PRIOR", "%5s", true, "Application priority", "l"));
        this.columnInformationEnumMap.put(Columns.CONT, new ColumnInformation("#CONT", "%7s", true, "Number of containers", "c"));
        this.columnInformationEnumMap.put(Columns.RCONT, new ColumnInformation("#RCONT", "%7s", true, "Number of reserved containers", "r"));
        this.columnInformationEnumMap.put(Columns.VCORES, new ColumnInformation("VCORES", "%7s", true, "Allocated vcores", "v"));
        this.columnInformationEnumMap.put(Columns.RVCORES, new ColumnInformation("RVCORES", "%7s", true, "Reserved vcores", "o"));
        this.columnInformationEnumMap.put(Columns.MEM, new ColumnInformation("MEM", "%7s", true, "Allocated memory", "m"));
        this.columnInformationEnumMap.put(Columns.RMEM, new ColumnInformation("RMEM", "%7s", true, "Reserved memory", "w"));
        this.columnInformationEnumMap.put(Columns.VCORESECS, new ColumnInformation("VCORESECS", "%10s", true, "Vcore seconds", "s"));
        this.columnInformationEnumMap.put(Columns.MEMSECS, new ColumnInformation("MEMSECS", "%10s", true, "Memory seconds(in GBseconds)", "y"));
        this.columnInformationEnumMap.put(Columns.PROGRESS, new ColumnInformation("%PROGR", "%6s", true, "Progress(percentage)", "p"));
        this.columnInformationEnumMap.put(Columns.TIME, new ColumnInformation("TIME", "%10s", true, "Running time", "i"));
        this.columnInformationEnumMap.put(Columns.NAME, new ColumnInformation("NAME", "%s", true, "Application name", "n"));
    }

    private void generateKeyFieldsMap() {
        for (Map.Entry<Columns, ColumnInformation> entry : this.columnInformationEnumMap.entrySet()) {
            this.keyFieldsMap.put(entry.getValue().key, entry.getKey());
        }
    }

    protected NodesInformation getNodesInfo() {
        YarnClusterMetrics yarnClusterMetrics;
        NodesInformation nodeInfo = new NodesInformation();
        try {
            yarnClusterMetrics = this.client.getYarnClusterMetrics();
        }
        catch (IOException ie) {
            LOG.error("Unable to fetch cluster metrics", (Throwable)ie);
            return nodeInfo;
        }
        catch (YarnException ye) {
            LOG.error("Unable to fetch cluster metrics", (Throwable)ye);
            return nodeInfo;
        }
        nodeInfo.decommissioningNodes = yarnClusterMetrics.getNumDecommissioningNodeManagers();
        nodeInfo.decommissionedNodes = yarnClusterMetrics.getNumDecommissionedNodeManagers();
        nodeInfo.totalNodes = yarnClusterMetrics.getNumNodeManagers();
        nodeInfo.runningNodes = yarnClusterMetrics.getNumActiveNodeManagers();
        nodeInfo.lostNodes = yarnClusterMetrics.getNumLostNodeManagers();
        nodeInfo.unhealthyNodes = yarnClusterMetrics.getNumUnhealthyNodeManagers();
        nodeInfo.rebootedNodes = yarnClusterMetrics.getNumRebootedNodeManagers();
        nodeInfo.shutdownNodes = yarnClusterMetrics.getNumShutdownNodeManagers();
        return nodeInfo;
    }

    protected QueueMetrics getQueueMetrics() {
        List<Object> queuesInfo;
        QueueMetrics queueMetrics = new QueueMetrics();
        if (this.queues.isEmpty()) {
            try {
                queuesInfo = this.client.getRootQueueInfos();
            }
            catch (Exception ie) {
                LOG.error("Unable to get queue information", (Throwable)ie);
                return queueMetrics;
            }
        } else {
            queuesInfo = new ArrayList();
            for (String string : this.queues) {
                try {
                    QueueInfo qInfo = this.client.getQueueInfo(string);
                    queuesInfo.add(qInfo);
                }
                catch (Exception ie) {
                    LOG.error("Unable to get queue information", (Throwable)ie);
                    return queueMetrics;
                }
            }
        }
        for (QueueInfo queueInfo : queuesInfo) {
            QueueStatistics stats = queueInfo.getQueueStatistics();
            if (stats == null) continue;
            queueMetrics.appsSubmitted += stats.getNumAppsSubmitted();
            queueMetrics.appsRunning += stats.getNumAppsRunning();
            queueMetrics.appsPending += stats.getNumAppsPending();
            queueMetrics.appsCompleted += stats.getNumAppsCompleted();
            queueMetrics.appsKilled += stats.getNumAppsKilled();
            queueMetrics.appsFailed += stats.getNumAppsFailed();
            queueMetrics.activeUsers += stats.getNumActiveUsers();
            queueMetrics.availableMemoryGB += stats.getAvailableMemoryMB();
            queueMetrics.allocatedMemoryGB += stats.getAllocatedMemoryMB();
            queueMetrics.pendingMemoryGB += stats.getPendingMemoryMB();
            queueMetrics.reservedMemoryGB += stats.getReservedMemoryMB();
            queueMetrics.availableVCores += stats.getAvailableVCores();
            queueMetrics.allocatedVCores += stats.getAllocatedVCores();
            queueMetrics.pendingVCores += stats.getPendingVCores();
            queueMetrics.reservedVCores += stats.getReservedVCores();
            queueMetrics.allocatedContainers += stats.getAllocatedContainers();
            queueMetrics.pendingContainers += stats.getPendingContainers();
            queueMetrics.reservedContainers += stats.getReservedContainers();
        }
        queueMetrics.availableMemoryGB /= 1024L;
        queueMetrics.allocatedMemoryGB /= 1024L;
        queueMetrics.pendingMemoryGB /= 1024L;
        queueMetrics.reservedMemoryGB /= 1024L;
        return queueMetrics;
    }

    long getRMStartTime() {
        try {
            URL url = this.getClusterUrl();
            if (null == url) {
                return -1L;
            }
            JSONObject clusterInfo = this.getJSONObject(this.connect(url));
            return clusterInfo.getLong("startedOn");
        }
        catch (Exception e) {
            LOG.error("Could not fetch RM start time", (Throwable)e);
            return -1L;
        }
    }

    private JSONObject getJSONObject(URLConnection conn) throws IOException, JSONException {
        try (InputStream in = conn.getInputStream();){
            JSONObject clusterInfo;
            String encoding = conn.getContentEncoding();
            encoding = encoding == null ? "UTF-8" : encoding;
            String body = IOUtils.toString(in, encoding);
            JSONObject obj = new JSONObject(body);
            JSONObject jSONObject = clusterInfo = obj.getJSONObject("clusterInfo");
            return jSONObject;
        }
    }

    private URL getClusterUrl() throws Exception {
        URL url = null;
        Configuration conf = this.getConf();
        if (HAUtil.isHAEnabled((Configuration)conf)) {
            Collection haids = HAUtil.getRMHAIds((Configuration)conf);
            for (String rmhid : haids) {
                try {
                    url = this.getHAClusterUrl(conf, rmhid);
                    if (!this.isActive(url)) continue;
                    break;
                }
                catch (ConnectException connectException) {
                }
            }
        } else {
            url = new URL(WebAppUtils.getRMWebAppURLWithScheme(conf) + CLUSTER_INFO_URL);
        }
        return url;
    }

    private boolean isActive(URL url) throws Exception {
        URLConnection connect = this.connect(url);
        JSONObject clusterInfo = this.getJSONObject(connect);
        return clusterInfo.getString("haState").equals("ACTIVE");
    }

    @VisibleForTesting
    public URL getHAClusterUrl(Configuration conf, String rmhid) throws MalformedURLException {
        return new URL(WebAppUtils.getHttpSchemePrefix(conf) + WebAppUtils.getResolvedRemoteRMWebAppURLWithoutScheme(conf, YarnConfiguration.useHttps((Configuration)conf) ? HttpConfig.Policy.HTTPS_ONLY : HttpConfig.Policy.HTTP_ONLY, rmhid) + CLUSTER_INFO_URL);
    }

    private URLConnection connect(URL url) throws Exception {
        HttpURLConnection connection;
        AuthenticatedURL.Token token = new AuthenticatedURL.Token();
        if (YarnConfiguration.useHttps((Configuration)this.getConf())) {
            SSLFactory clientSslFactory = new SSLFactory(SSLFactory.Mode.CLIENT, this.getConf());
            clientSslFactory.init();
            SSLSocketFactory sslSocktFact = clientSslFactory.createSSLSocketFactory();
            AuthenticatedURL authUrl = new AuthenticatedURL(SecurityUtil.getMaprAuthenticator(), (ConnectionConfigurator)clientSslFactory);
            connection = authUrl.openConnection(url, token);
            HttpsURLConnection httpsConn = (HttpsURLConnection)connection;
            httpsConn.setSSLSocketFactory(sslSocktFact);
        } else {
            AuthenticatedURL authUrl = new AuthenticatedURL(SecurityUtil.getMaprAuthenticator());
            connection = authUrl.openConnection(url, token);
        }
        connection.connect();
        return connection;
    }

    String getHeader(QueueMetrics queueMetrics, NodesInformation nodes) {
        StringBuilder ret = new StringBuilder();
        String queue = "root";
        if (!this.queues.isEmpty()) {
            queue = StringUtils.join(this.queues, (String)",");
        }
        long now = Time.now();
        long uptime = 0L;
        if (this.rmStartTime != -1L) {
            uptime = now - this.rmStartTime;
        }
        long days = TimeUnit.MILLISECONDS.toDays(uptime);
        long hours = TimeUnit.MILLISECONDS.toHours(uptime) - TimeUnit.DAYS.toHours(TimeUnit.MILLISECONDS.toDays(uptime));
        long minutes = TimeUnit.MILLISECONDS.toMinutes(uptime) - TimeUnit.HOURS.toMinutes(TimeUnit.MILLISECONDS.toHours(uptime));
        String uptimeStr = String.format("%dd, %d:%d", days, hours, minutes);
        String currentTime = DateFormatUtils.ISO_8601_EXTENDED_TIME_FORMAT.format(now);
        ret.append(this.CLEAR_LINE).append(this.limitLineLength(String.format("YARN top - %s, up %s, %d active users, queue(s): %s%n", currentTime, uptimeStr, queueMetrics.activeUsers, queue), this.terminalWidth, true));
        ret.append(this.CLEAR_LINE).append(this.limitLineLength(String.format("NodeManager(s): %d total, %d active, %d unhealthy, %d decommissioning, %d decommissioned, %d lost, %d rebooted, %d shutdown%n", nodes.totalNodes, nodes.runningNodes, nodes.unhealthyNodes, nodes.decommissioningNodes, nodes.decommissionedNodes, nodes.lostNodes, nodes.rebootedNodes, nodes.shutdownNodes), this.terminalWidth, true));
        ret.append(this.CLEAR_LINE).append(this.limitLineLength(String.format("Queue(s) Applications: %d running, %d submitted, %d pending, %d completed, %d killed, %d failed%n", queueMetrics.appsRunning, queueMetrics.appsSubmitted, queueMetrics.appsPending, queueMetrics.appsCompleted, queueMetrics.appsKilled, queueMetrics.appsFailed), this.terminalWidth, true));
        ret.append(this.CLEAR_LINE).append(this.limitLineLength(String.format("Queue(s) Mem(GB): %d available, %d allocated, %d pending, %d reserved%n", queueMetrics.availableMemoryGB, queueMetrics.allocatedMemoryGB, queueMetrics.pendingMemoryGB, queueMetrics.reservedMemoryGB), this.terminalWidth, true));
        ret.append(this.CLEAR_LINE).append(this.limitLineLength(String.format("Queue(s) VCores: %d available, %d allocated, %d pending, %d reserved%n", queueMetrics.availableVCores, queueMetrics.allocatedVCores, queueMetrics.pendingVCores, queueMetrics.reservedVCores), this.terminalWidth, true));
        ret.append(this.CLEAR_LINE).append(this.limitLineLength(String.format("Queue(s) Containers: %d allocated, %d pending, %d reserved%n", queueMetrics.allocatedContainers, queueMetrics.pendingContainers, queueMetrics.reservedContainers), this.terminalWidth, true));
        return ret.toString();
    }

    String getPrintableAppInformation(List<ApplicationInformation> appsInfo) {
        StringBuilder ret = new StringBuilder();
        int limit = this.terminalHeight - 9;
        ArrayList<String> columns = new ArrayList<String>();
        for (int i = 0; i < limit; ++i) {
            ret.append(this.CLEAR_LINE);
            if (i < appsInfo.size()) {
                ApplicationInformation appInfo = appsInfo.get(i);
                columns.clear();
                for (Map.Entry<Columns, ColumnInformation> entry : this.columnInformationEnumMap.entrySet()) {
                    if (!entry.getValue().display) continue;
                    String value = "";
                    if (appInfo.displayStringsMap.containsKey((Object)entry.getKey())) {
                        value = appInfo.displayStringsMap.get((Object)entry.getKey());
                    }
                    columns.add(String.format(entry.getValue().format, value));
                }
                ret.append(this.limitLineLength(StringUtils.join((Object[])columns.toArray(), (String)" ") + System.lineSeparator(), this.terminalWidth, true));
                continue;
            }
            ret.append(System.lineSeparator());
        }
        return ret.toString();
    }

    protected void clearScreen() {
        System.out.print(this.CLEAR);
        System.out.flush();
    }

    protected void clearScreenWithoutScroll() {
        System.out.print(this.SET_CURSOR_HOME);
        for (int i = 0; i < this.terminalHeight; ++i) {
            System.out.println(this.CLEAR_LINE);
        }
    }

    protected void printHeader(String header) {
        System.out.print(this.SET_CURSOR_HOME);
        System.out.print(header);
        System.out.println("");
    }

    protected void printApps(String appInfo) {
        System.out.print(this.CLEAR_LINE);
        System.out.print(this.CHANGE_BACKGROUND + this.appsHeader + this.RESET_BACKGROUND);
        System.out.print(appInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showHelpScreen() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.showingTopScreen.get()) {
                return;
            }
            this.showingTopScreen.set(false);
            this.clearScreenWithoutScroll();
            System.out.print(this.SET_CURSOR_HOME);
            System.out.println("Help for yarn top.");
            System.out.println("Delay: " + this.refreshPeriod / 1000L + " secs; Secure mode: " + UserGroupInformation.isSecurityEnabled());
            System.out.println("");
            System.out.println("  s + Enter: Select sort field");
            System.out.println("  f + Enter: Select fields to display");
            System.out.println("  R + Enter: Reverse current sort order");
            System.out.println("  h + Enter: Display this screen");
            System.out.println("  q + Enter: Quit");
            System.out.println("");
            System.out.println("Press any key followed by Enter to continue");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showSortScreen() {
        Object object = this.lock;
        synchronized (object) {
            this.showingTopScreen.set(false);
            System.out.print(this.SET_CURSOR_HOME);
            System.out.println(this.CLEAR_LINE + "Current Sort Field: " + this.currentSortField);
            System.out.println(this.CLEAR_LINE + "Select sort field via letter followed by Enter, type any other key followed by Enter to return");
            System.out.println(this.CLEAR_LINE);
            for (String key : this.sortedKeys) {
                String prefix = " ";
                if (key.equals(this.currentSortField)) {
                    prefix = "*";
                }
                ColumnInformation value = this.columnInformationEnumMap.get((Object)this.keyFieldsMap.get(key));
                System.out.print(this.CLEAR_LINE);
                System.out.println(String.format("%s %s: %-15s = %s", prefix, key, value.header, value.description));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void showFieldsScreen() {
        Object object = this.lock;
        synchronized (object) {
            this.showingTopScreen.set(false);
            System.out.print(this.SET_CURSOR_HOME);
            System.out.println(this.CLEAR_LINE + "Current Fields: ");
            System.out.println(this.CLEAR_LINE + "Toggle fields via field letter followed by Enter, type any other key followed by Enter to return");
            for (String key : this.sortedKeys) {
                ColumnInformation info = this.columnInformationEnumMap.get((Object)this.keyFieldsMap.get(key));
                String prefix = " ";
                String letter = key;
                if (info.display) {
                    prefix = "*";
                    letter = key.toUpperCase();
                }
                System.out.print(this.CLEAR_LINE);
                System.out.println(String.format("%s %s: %-15s = %s", prefix, letter, info.header, info.description));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    void showTopScreen() {
        List<ApplicationReport> apps;
        ArrayList<ApplicationInformation> appsInfo = new ArrayList<ApplicationInformation>();
        try {
            apps = this.fetchAppReports();
        }
        catch (Exception e) {
            LOG.error("Unable to get application information", (Throwable)e);
            return;
        }
        for (ApplicationReport appReport : apps) {
            ApplicationInformation appInfo = new ApplicationInformation(appReport);
            appsInfo.add(appInfo);
        }
        if (this.ascendingSort) {
            Collections.sort(appsInfo, this.comparator);
        } else {
            Collections.sort(appsInfo, Collections.reverseOrder(this.comparator));
        }
        NodesInformation nodesInfo = this.getNodesInfo();
        QueueMetrics queueMetrics = this.getQueueMetrics();
        String header = this.getHeader(queueMetrics, nodesInfo);
        String appsStr = this.getPrintableAppInformation(appsInfo);
        Object object = this.lock;
        synchronized (object) {
            this.printHeader(header);
            this.printApps(appsStr);
            System.out.print(this.SET_CURSOR_LINE_7_COLUMN_0);
            System.out.print(this.CLEAR_LINE);
        }
    }

    private void handleSortScreenKeyPress(String input) {
        String f = this.currentSortField;
        this.currentSortField = input.toLowerCase();
        switch (input.toLowerCase()) {
            case "a": {
                this.comparator = AppIDComparator;
                break;
            }
            case "u": {
                this.comparator = UserComparator;
                break;
            }
            case "t": {
                this.comparator = AppTypeComparator;
                break;
            }
            case "q": {
                this.comparator = QueueNameComparator;
                break;
            }
            case "c": {
                this.comparator = UsedContainersComparator;
                break;
            }
            case "r": {
                this.comparator = ReservedContainersComparator;
                break;
            }
            case "v": {
                this.comparator = UsedVCoresComparator;
                break;
            }
            case "o": {
                this.comparator = ReservedVCoresComparator;
                break;
            }
            case "m": {
                this.comparator = UsedMemoryComparator;
                break;
            }
            case "w": {
                this.comparator = ReservedMemoryComparator;
                break;
            }
            case "s": {
                this.comparator = VCoreSecondsComparator;
                break;
            }
            case "y": {
                this.comparator = MemorySecondsComparator;
                break;
            }
            case "p": {
                this.comparator = ProgressComparator;
                break;
            }
            case "i": {
                this.comparator = RunningTimeComparator;
                break;
            }
            case "n": {
                this.comparator = AppNameComparator;
                break;
            }
            case "l": {
                this.comparator = AppPriorityComparator;
                break;
            }
            default: {
                this.currentSortField = f;
                this.showTopScreen();
                this.showingTopScreen.set(true);
                this.displayScreen = DisplayScreen.TOP;
            }
        }
    }

    private void handleFieldsScreenKeyPress(String input) {
        if (this.keyFieldsMap.containsKey(input.toLowerCase())) {
            this.toggleColumn(this.keyFieldsMap.get(input.toLowerCase()));
            this.setAppsHeader();
        } else {
            this.showTopScreen();
            this.showingTopScreen.set(true);
            this.displayScreen = DisplayScreen.TOP;
        }
    }

    private void handleTopScreenKeyPress(String input) {
        switch (input.toLowerCase()) {
            case "q": {
                this.runMainLoop.set(false);
                this.runKeyboardMonitor.set(false);
                this.displayThread.interrupt();
                break;
            }
            case "s": {
                this.displayScreen = DisplayScreen.SORT;
                this.showSortScreen();
                break;
            }
            case "f": {
                this.displayScreen = DisplayScreen.FIELDS;
                this.showFieldsScreen();
                break;
            }
            case "r": {
                this.ascendingSort = !this.ascendingSort;
                break;
            }
            case "h": {
                this.displayScreen = DisplayScreen.HELP;
                this.showHelpScreen();
                break;
            }
        }
    }

    private void handleHelpScreenKeyPress() {
        this.showTopScreen();
        this.showingTopScreen.set(true);
        this.displayScreen = DisplayScreen.TOP;
    }

    String limitLineLength(String line, int length, boolean addNewline) {
        if (line.length() > length) {
            String tmp;
            if (addNewline) {
                tmp = line.substring(0, length - System.lineSeparator().length());
                tmp = tmp + System.lineSeparator();
            } else {
                tmp = line.substring(0, length);
            }
            return tmp;
        }
        return line;
    }

    void toggleColumn(Columns col) {
        this.columnInformationEnumMap.get((Object)((Object)col)).display = !this.columnInformationEnumMap.get((Object)((Object)col)).display;
    }

    protected List<ApplicationReport> fetchAppReports() throws YarnException, IOException {
        EnumSet<YarnApplicationState> states = EnumSet.of(YarnApplicationState.ACCEPTED, YarnApplicationState.RUNNING);
        GetApplicationsRequest req = GetApplicationsRequest.newInstance(this.types, states);
        req.setQueues(this.queues);
        req.setUsers(this.users);
        List<ApplicationReport> ret = this.applicationReportsCache.getIfPresent(req);
        if (ret != null) {
            return ret;
        }
        ret = this.client.getApplications(this.queues, this.users, this.types, states);
        this.applicationReportsCache.put(req, ret);
        return ret;
    }

    private String getCommandOutput(String[] command) throws IOException, InterruptedException {
        Process p = Runtime.getRuntime().exec(command);
        p.waitFor();
        byte[] output = IOUtils.toByteArray(p.getInputStream());
        return new String(output, "ASCII");
    }

    private void addShutdownHook() {
        Runtime.getRuntime().addShutdownHook(new Thread(() -> this.clearScreen()));
    }

    private class KeyboardMonitor
    extends Thread {
        private KeyboardMonitor() {
        }

        @Override
        public void run() {
            Scanner keyboard = new Scanner(System.in, "UTF-8");
            while (TopCLI.this.runKeyboardMonitor.get()) {
                String in = keyboard.next();
                try {
                    if (TopCLI.this.displayScreen == DisplayScreen.SORT) {
                        TopCLI.this.handleSortScreenKeyPress(in);
                        continue;
                    }
                    if (TopCLI.this.displayScreen == DisplayScreen.TOP) {
                        TopCLI.this.handleTopScreenKeyPress(in);
                        continue;
                    }
                    if (TopCLI.this.displayScreen == DisplayScreen.FIELDS) {
                        TopCLI.this.handleFieldsScreenKeyPress(in);
                        continue;
                    }
                    TopCLI.this.handleHelpScreenKeyPress();
                }
                catch (Exception e) {
                    LOG.error("Caught exception", (Throwable)e);
                }
            }
        }
    }

    private static class QueueMetrics {
        long appsSubmitted;
        long appsRunning;
        long appsPending;
        long appsCompleted;
        long appsKilled;
        long appsFailed;
        long activeUsers;
        long availableMemoryGB;
        long allocatedMemoryGB;
        long pendingMemoryGB;
        long reservedMemoryGB;
        long availableVCores;
        long allocatedVCores;
        long pendingVCores;
        long reservedVCores;
        long allocatedContainers;
        long reservedContainers;
        long pendingContainers;

        private QueueMetrics() {
        }
    }

    private static class NodesInformation {
        int totalNodes;
        int runningNodes;
        int unhealthyNodes;
        int decommissioningNodes;
        int decommissionedNodes;
        int lostNodes;
        int rebootedNodes;
        int shutdownNodes;

        private NodesInformation() {
        }
    }

    private static class ApplicationInformation {
        final String appid;
        final String user;
        final String type;
        final int priority;
        final int usedContainers;
        final int reservedContainers;
        final long usedMemory;
        final long reservedMemory;
        final int usedVirtualCores;
        final int reservedVirtualCores;
        final int attempts;
        final float progress;
        final String state;
        long runningTime;
        final String time;
        final String name;
        final int nodes;
        final String queue;
        final long memorySeconds;
        final long vcoreSeconds;
        final EnumMap<Columns, String> displayStringsMap = new EnumMap(Columns.class);

        ApplicationInformation(ApplicationReport appReport) {
            this.appid = appReport.getApplicationId().toString();
            this.displayStringsMap.put(Columns.APPID, this.appid);
            this.user = appReport.getUser();
            this.displayStringsMap.put(Columns.USER, this.user);
            this.type = appReport.getApplicationType().toLowerCase();
            this.displayStringsMap.put(Columns.TYPE, this.type);
            this.state = appReport.getYarnApplicationState().toString().toLowerCase();
            this.name = appReport.getName();
            this.displayStringsMap.put(Columns.NAME, this.name);
            this.queue = appReport.getQueue();
            this.displayStringsMap.put(Columns.QUEUE, this.queue);
            Priority appPriority = appReport.getPriority();
            this.priority = null != appPriority ? appPriority.getPriority() : 0;
            this.displayStringsMap.put(Columns.PRIORITY, String.valueOf(this.priority));
            this.usedContainers = appReport.getApplicationResourceUsageReport().getNumUsedContainers();
            this.displayStringsMap.put(Columns.CONT, String.valueOf(this.usedContainers));
            this.reservedContainers = appReport.getApplicationResourceUsageReport().getNumReservedContainers();
            this.displayStringsMap.put(Columns.RCONT, String.valueOf(this.reservedContainers));
            this.usedVirtualCores = appReport.getApplicationResourceUsageReport().getUsedResources().getVirtualCores();
            this.displayStringsMap.put(Columns.VCORES, String.valueOf(this.usedVirtualCores));
            this.usedMemory = appReport.getApplicationResourceUsageReport().getUsedResources().getMemorySize() / 1024L;
            this.displayStringsMap.put(Columns.MEM, String.valueOf(this.usedMemory) + "G");
            this.reservedVirtualCores = appReport.getApplicationResourceUsageReport().getReservedResources().getVirtualCores();
            this.displayStringsMap.put(Columns.RVCORES, String.valueOf(this.reservedVirtualCores));
            this.reservedMemory = appReport.getApplicationResourceUsageReport().getReservedResources().getMemorySize() / 1024L;
            this.displayStringsMap.put(Columns.RMEM, String.valueOf(this.reservedMemory) + "G");
            this.attempts = appReport.getCurrentApplicationAttemptId().getAttemptId();
            this.nodes = 0;
            this.runningTime = Time.now() - appReport.getStartTime();
            this.time = DurationFormatUtils.formatDuration((long)this.runningTime, (String)"dd:HH:mm");
            this.displayStringsMap.put(Columns.TIME, String.valueOf(this.time));
            this.progress = appReport.getProgress() * 100.0f;
            this.displayStringsMap.put(Columns.PROGRESS, String.format("%.2f", Float.valueOf(this.progress)));
            this.memorySeconds = appReport.getApplicationResourceUsageReport().getMemorySeconds() / 1024L;
            this.displayStringsMap.put(Columns.MEMSECS, String.valueOf(this.memorySeconds));
            this.vcoreSeconds = appReport.getApplicationResourceUsageReport().getVcoreSeconds();
            this.displayStringsMap.put(Columns.VCORESECS, String.valueOf(this.vcoreSeconds));
        }
    }

    static class ColumnInformation {
        String header;
        String format;
        boolean display;
        String description;
        String key;

        public ColumnInformation(String header, String format, boolean display, String description, String key) {
            this.header = header;
            this.format = format;
            this.display = display;
            this.description = description;
            this.key = key;
        }
    }

    static enum Columns {
        APPID,
        USER,
        TYPE,
        QUEUE,
        PRIORITY,
        CONT,
        RCONT,
        VCORES,
        RVCORES,
        MEM,
        RMEM,
        VCORESECS,
        MEMSECS,
        PROGRESS,
        TIME,
        NAME;

    }

    static enum DisplayScreen {
        TOP,
        HELP,
        SORT,
        FIELDS;

    }
}

