/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.api.records.impl.pb;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.api.records.ReservationRequest;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.impl.pb.ProtoUtils;
import org.apache.hadoop.yarn.api.records.impl.pb.ResourcePBImpl;
import org.apache.hadoop.yarn.proto.YarnProtos;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class ReservationRequestPBImpl
extends ReservationRequest {
    YarnProtos.ReservationRequestProto proto = YarnProtos.ReservationRequestProto.getDefaultInstance();
    YarnProtos.ReservationRequestProto.Builder builder = null;
    boolean viaProto = false;
    private Resource capability = null;

    public ReservationRequestPBImpl() {
        this.builder = YarnProtos.ReservationRequestProto.newBuilder();
    }

    public ReservationRequestPBImpl(YarnProtos.ReservationRequestProto proto) {
        this.proto = proto;
        this.viaProto = true;
    }

    public YarnProtos.ReservationRequestProto getProto() {
        this.mergeLocalToProto();
        this.proto = this.viaProto ? this.proto : this.builder.build();
        this.viaProto = true;
        return this.proto;
    }

    private void mergeLocalToBuilder() {
        if (this.capability != null) {
            this.builder.setCapability(this.convertToProtoFormat(this.capability));
        }
    }

    private void mergeLocalToProto() {
        if (this.viaProto) {
            this.maybeInitBuilder();
        }
        this.mergeLocalToBuilder();
        this.proto = this.builder.build();
        this.viaProto = true;
    }

    private void maybeInitBuilder() {
        if (this.viaProto || this.builder == null) {
            this.builder = YarnProtos.ReservationRequestProto.newBuilder((YarnProtos.ReservationRequestProto)this.proto);
        }
        this.viaProto = false;
    }

    public Resource getCapability() {
        YarnProtos.ReservationRequestProto p;
        Object object = p = this.viaProto ? this.proto : this.builder;
        if (this.capability != null) {
            return this.capability;
        }
        if (!p.hasCapability()) {
            return null;
        }
        this.capability = this.convertFromProtoFormat(p.getCapability());
        return this.capability;
    }

    public void setCapability(Resource capability) {
        this.maybeInitBuilder();
        if (capability == null) {
            this.builder.clearCapability();
        }
        this.capability = capability;
    }

    public int getNumContainers() {
        YarnProtos.ReservationRequestProto p = this.viaProto ? this.proto : this.builder;
        return p.getNumContainers();
    }

    public void setNumContainers(int numContainers) {
        this.maybeInitBuilder();
        this.builder.setNumContainers(numContainers);
    }

    public int getConcurrency() {
        YarnProtos.ReservationRequestProto p;
        Object object = p = this.viaProto ? this.proto : this.builder;
        if (!p.hasConcurrency()) {
            return 1;
        }
        return p.getConcurrency();
    }

    public void setConcurrency(int numContainers) {
        this.maybeInitBuilder();
        this.builder.setConcurrency(numContainers);
    }

    public long getDuration() {
        YarnProtos.ReservationRequestProto p;
        Object object = p = this.viaProto ? this.proto : this.builder;
        if (!p.hasDuration()) {
            return 0L;
        }
        return p.getDuration();
    }

    public void setDuration(long duration) {
        this.maybeInitBuilder();
        this.builder.setDuration(duration);
    }

    private ResourcePBImpl convertFromProtoFormat(YarnProtos.ResourceProto p) {
        return new ResourcePBImpl(p);
    }

    private YarnProtos.ResourceProto convertToProtoFormat(Resource t2) {
        return ProtoUtils.convertToProtoFormat(t2);
    }

    public String toString() {
        return "{Capability: " + this.getCapability() + ", # Containers: " + this.getNumContainers() + ", Concurrency: " + this.getConcurrency() + ", Lease Duration: " + this.getDuration() + "}";
    }
}

