/*
 * Decompiled with CFR 0.152.
 */
package org.sparkproject.jetty.websocket.common;

import java.net.URI;
import org.sparkproject.jetty.websocket.common.LogicalConnection;
import org.sparkproject.jetty.websocket.common.SessionFactory;
import org.sparkproject.jetty.websocket.common.WebSocketSession;
import org.sparkproject.jetty.websocket.common.events.EventDriver;
import org.sparkproject.jetty.websocket.common.events.JettyAnnotatedEventDriver;
import org.sparkproject.jetty.websocket.common.events.JettyListenerEventDriver;
import org.sparkproject.jetty.websocket.common.scopes.WebSocketContainerScope;

public class WebSocketSessionFactory
implements SessionFactory {
    private final WebSocketContainerScope containerScope;

    public WebSocketSessionFactory(WebSocketContainerScope containerScope) {
        this.containerScope = containerScope;
    }

    @Override
    public boolean supports(EventDriver websocket) {
        return websocket instanceof JettyAnnotatedEventDriver || websocket instanceof JettyListenerEventDriver;
    }

    @Override
    public WebSocketSession createSession(URI requestURI, EventDriver websocket, LogicalConnection connection) {
        return new WebSocketSession(this.containerScope, requestURI, websocket, connection);
    }
}

