/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kerby.util;

public class IPAddressParser {
    public static byte[] parseIPv4Literal(String s2) {
        s2 = s2 != null ? s2.trim() : "";
        String[] toks = s2.split("\\.");
        byte[] ip = new byte[4];
        if (toks.length == 4) {
            for (int i = 0; i < ip.length; ++i) {
                try {
                    int val = Integer.parseInt(toks[i]);
                    if (val < 0 || val > 255) {
                        return null;
                    }
                    ip[i] = (byte)val;
                    continue;
                }
                catch (NumberFormatException nfe) {
                    return null;
                }
            }
            return ip;
        }
        return null;
    }

    public static byte[] parseIPv6Literal(String s2) {
        String string = s2 = s2 != null ? s2.trim() : "";
        if (s2.length() > 0 && s2.charAt(0) == '[' && s2.charAt(s2.length() - 1) == ']') {
            s2 = s2.substring(1, s2.length() - 1).trim();
        }
        int x = s2.lastIndexOf(58);
        int y = s2.indexOf(46);
        if (x >= 0 && y > x) {
            byte[] ip4Suffix = IPAddressParser.parseIPv4Literal(s2.substring(x + 1));
            if (ip4Suffix == null) {
                return null;
            }
            s2 = s2.substring(0, x) + ":" + IPAddressParser.ip4ToHex(ip4Suffix);
        }
        if ((x = s2.indexOf("::")) >= 0 && s2.indexOf("::", x + 1) >= 0) {
            return null;
        }
        String[] raw = new String[]{"0000", "0000", "0000", "0000", "0000", "0000", "0000", "0000"};
        if (s2.indexOf("::") >= 0) {
            String[] suffix;
            String[] split = s2.split("::", -1);
            String[] prefix = IPAddressParser.splitOnColon(split[0]);
            if (prefix.length + (suffix = IPAddressParser.splitOnColon(split[1])).length > 7) {
                return null;
            }
            for (int i = 0; i < prefix.length; ++i) {
                raw[i] = IPAddressParser.prependZeroes(prefix[i]);
            }
            int startPos = raw.length - suffix.length;
            for (int i = 0; i < suffix.length; ++i) {
                raw[startPos + i] = IPAddressParser.prependZeroes(suffix[i]);
            }
        } else {
            raw = IPAddressParser.splitOnColon(s2);
            if (raw.length != 8) {
                return null;
            }
            for (int i = 0; i < raw.length; ++i) {
                raw[i] = IPAddressParser.prependZeroes(raw[i]);
            }
        }
        byte[] ip6 = new byte[16];
        int i = 0;
        for (String tok : raw) {
            if (tok.length() > 4) {
                return null;
            }
            String prefix = tok.substring(0, 2);
            String suffix = tok.substring(2, 4);
            try {
                ip6[i++] = (byte)Integer.parseInt(prefix, 16);
                ip6[i++] = (byte)Integer.parseInt(suffix, 16);
            }
            catch (NumberFormatException nfe) {
                return null;
            }
        }
        return ip6;
    }

    private static String prependZeroes(String s2) {
        switch (s2.length()) {
            case 0: {
                return "0000";
            }
            case 1: {
                return "000" + s2;
            }
            case 2: {
                return "00" + s2;
            }
            case 3: {
                return "0" + s2;
            }
        }
        return s2;
    }

    private static String[] splitOnColon(String s2) {
        if ("".equals(s2)) {
            return new String[0];
        }
        return s2.split(":");
    }

    private static String ip4ToHex(byte[] b) {
        return IPAddressParser.b2s(b[0]) + IPAddressParser.b2s(b[1]) + ":" + IPAddressParser.b2s(b[2]) + IPAddressParser.b2s(b[3]);
    }

    private static String b2s(byte b) {
        String s2 = Integer.toHexString(b >= 0 ? b : 256 + b);
        if (s2.length() < 2) {
            s2 = "0" + s2;
        }
        return s2;
    }
}

