/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.logaggregation.filecontroller.nodelocal;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeLocalMetadataReader {
    private static final Logger LOG = LoggerFactory.getLogger(NodeLocalMetadataReader.class);
    private final String prefixPath;
    private final String logMetaDir;
    private final String containersFile;
    private final Configuration conf;
    private FileSystem fs;

    public NodeLocalMetadataReader(Configuration conf) {
        this.conf = conf;
        this.prefixPath = conf.get("yarn.nodemanager.remote-app-log-dir", "/tmp/logs");
        this.logMetaDir = conf.get("yarn.node-local-log-aggregation.metadata-path", "logsMeta");
        this.containersFile = conf.get("yarn.node-local-log-aggregation.metadata-filename", "containers.seq");
        this.init(conf);
    }

    private void init(Configuration conf) {
        try {
            this.fs = FileSystem.get((Configuration)conf);
        }
        catch (IOException e) {
            LOG.error("Cannot create filesystem instance", (Throwable)e);
        }
    }

    public Map<String, List<String>> getLogMetadataForApplication(String applicationId, String appOwner) throws IOException {
        FileStatus[] nodeLogsMetadata;
        Path applicationDir = this.getPathForApp(applicationId, appOwner);
        if (!this.fs.exists(applicationDir)) {
            LOG.info("No metadata found for application: " + applicationId);
            return new HashMap<String, List<String>>();
        }
        HashMap<String, List<String>> nodeToContainersMap = new HashMap<String, List<String>>();
        for (FileStatus nodeLogs : nodeLogsMetadata = this.fs.listStatus(applicationDir)) {
            Path metadataFile = new Path(nodeLogs.getPath(), this.containersFile);
            try (SequenceFile.Reader reader = new SequenceFile.Reader(this.conf, new SequenceFile.Reader.Option[]{SequenceFile.Reader.file((Path)metadataFile), SequenceFile.Reader.bufferSize((int)4096)});){
                Text container = new Text();
                NullWritable dummy = NullWritable.get();
                ArrayList<String> containers = new ArrayList<String>();
                while (reader.next((Writable)container, (Writable)dummy)) {
                    String containerId = container.toString();
                    containers.add(containerId);
                }
                nodeToContainersMap.put(nodeLogs.getPath().getName(), containers);
            }
        }
        return nodeToContainersMap;
    }

    public List<FileStatus> getLogsDirsFileStatusListForApp(ApplicationId appId, String appOwner) throws IOException {
        Map<String, List<String>> nodeToContainersMetadata = this.getLogMetadataForApplication(appId.toString(), appOwner);
        Path rootLocalVolumePath = new Path("/var/mapr/local");
        String logsPathForLocalVolume = "/mapred/nodeManager/logs/";
        FileSystem fs = FileSystem.get((Configuration)this.conf);
        ArrayList<FileStatus> fileStatusList = new ArrayList<FileStatus>();
        for (Map.Entry<String, List<String>> e : nodeToContainersMetadata.entrySet()) {
            Path finalPath = new Path(rootLocalVolumePath, e.getKey() + logsPathForLocalVolume + appOwner + "/" + appId + "/logs");
            try {
                fileStatusList.add(fs.getFileStatus(finalPath));
            }
            catch (IOException ex) {
                LOG.warn(ex.toString());
            }
        }
        return fileStatusList;
    }

    public List<FileStatus> getAppLogsDirsFileStatusListForApp(ApplicationId appId, String appOwner) throws IOException {
        Map<String, List<String>> nodeToContainersMetadata = this.getLogMetadataForApplication(appId.toString(), appOwner);
        Path rootLocalVolumePath = new Path("/var/mapr/local");
        String logsPathForLocalVolume = "/mapred/nodeManager/logs/";
        FileSystem fs = FileSystem.get((Configuration)this.conf);
        ArrayList<FileStatus> fileStatusList = new ArrayList<FileStatus>();
        for (Map.Entry<String, List<String>> e : nodeToContainersMetadata.entrySet()) {
            Path finalPath = new Path(rootLocalVolumePath, e.getKey() + logsPathForLocalVolume + appOwner + "/" + appId);
            try {
                fileStatusList.add(fs.getFileStatus(finalPath));
            }
            catch (IOException ex) {
                LOG.warn(ex.toString());
            }
        }
        return fileStatusList;
    }

    public Path getPathForApp(String applicationId, String appOwner) {
        return new Path(this.prefixPath, appOwner + "/" + this.logMetaDir + "/" + applicationId);
    }

    public String getNodeFromFilePath(FileStatus filePath) {
        int end;
        int begin;
        String filePathString = filePath.getPath().toUri().getRawPath();
        String nodeName = new String(filePathString.substring(begin = "/var/mapr/local".length() + 1, end = filePathString.indexOf("/mapred/nodeManager/logs/")));
        if (nodeName.contains("/")) {
            nodeName = nodeName.replaceAll("/", "");
        }
        return nodeName;
    }
}

