/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.api.records.impl.pb;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.util.Preconditions;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.impl.pb.ApplicationIdPBImpl;
import org.apache.hadoop.yarn.proto.YarnProtos;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class ApplicationAttemptIdPBImpl
extends ApplicationAttemptId {
    YarnProtos.ApplicationAttemptIdProto proto = null;
    YarnProtos.ApplicationAttemptIdProto.Builder builder = null;
    private ApplicationId applicationId = null;

    public ApplicationAttemptIdPBImpl() {
        this.builder = YarnProtos.ApplicationAttemptIdProto.newBuilder();
    }

    public ApplicationAttemptIdPBImpl(YarnProtos.ApplicationAttemptIdProto proto) {
        this.proto = proto;
        this.applicationId = this.convertFromProtoFormat(proto.getApplicationId());
    }

    public YarnProtos.ApplicationAttemptIdProto getProto() {
        return this.proto;
    }

    public int getAttemptId() {
        Preconditions.checkNotNull((Object)this.proto);
        return this.proto.getAttemptId();
    }

    protected void setAttemptId(int attemptId) {
        Preconditions.checkNotNull((Object)this.builder);
        this.builder.setAttemptId(attemptId);
    }

    public ApplicationId getApplicationId() {
        return this.applicationId;
    }

    public void setApplicationId(ApplicationId appId) {
        if (appId != null) {
            Preconditions.checkNotNull((Object)this.builder);
            this.builder.setApplicationId(this.convertToProtoFormat(appId));
        }
        this.applicationId = appId;
    }

    private ApplicationIdPBImpl convertFromProtoFormat(YarnProtos.ApplicationIdProto p) {
        return new ApplicationIdPBImpl(p);
    }

    private YarnProtos.ApplicationIdProto convertToProtoFormat(ApplicationId t2) {
        return ((ApplicationIdPBImpl)t2).getProto();
    }

    protected void build() {
        this.proto = this.builder.build();
        this.builder = null;
    }
}

