/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.api.protocolrecords.impl.pb;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.yarn.api.protocolrecords.GetClusterNodeLabelsResponse;
import org.apache.hadoop.yarn.api.records.NodeLabel;
import org.apache.hadoop.yarn.api.records.impl.pb.NodeLabelPBImpl;
import org.apache.hadoop.yarn.proto.YarnProtos;
import org.apache.hadoop.yarn.proto.YarnServiceProtos;

public class GetClusterNodeLabelsResponsePBImpl
extends GetClusterNodeLabelsResponse {
    YarnServiceProtos.GetClusterNodeLabelsResponseProto proto = YarnServiceProtos.GetClusterNodeLabelsResponseProto.getDefaultInstance();
    YarnServiceProtos.GetClusterNodeLabelsResponseProto.Builder builder = null;
    private List<NodeLabel> updatedNodeLabels;
    boolean viaProto = false;

    public GetClusterNodeLabelsResponsePBImpl() {
        this.builder = YarnServiceProtos.GetClusterNodeLabelsResponseProto.newBuilder();
    }

    public GetClusterNodeLabelsResponsePBImpl(YarnServiceProtos.GetClusterNodeLabelsResponseProto proto) {
        this.proto = proto;
        this.viaProto = true;
    }

    public synchronized YarnServiceProtos.GetClusterNodeLabelsResponseProto getProto() {
        this.mergeLocalToProto();
        this.proto = this.viaProto ? this.proto : this.builder.build();
        this.viaProto = true;
        return this.proto;
    }

    private void mergeLocalToProto() {
        if (this.viaProto) {
            this.maybeInitBuilder();
        }
        this.mergeLocalToBuilder();
        this.proto = this.builder.build();
        this.viaProto = true;
    }

    private void mergeLocalToBuilder() {
        if (this.updatedNodeLabels != null) {
            this.addNodeLabelsToProto();
        }
    }

    private void addNodeLabelsToProto() {
        this.maybeInitBuilder();
        this.builder.clearNodeLabels();
        this.builder.clearDeprecatedNodeLabels();
        ArrayList<YarnProtos.NodeLabelProto> protoList = new ArrayList<YarnProtos.NodeLabelProto>();
        ArrayList<String> protoListString = new ArrayList<String>();
        for (NodeLabel r : this.updatedNodeLabels) {
            protoList.add(this.convertToProtoFormat(r));
            protoListString.add(r.getName());
        }
        this.builder.addAllNodeLabels(protoList);
        this.builder.addAllDeprecatedNodeLabels(protoListString);
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other.getClass().isAssignableFrom(((Object)((Object)this)).getClass())) {
            return this.getProto().equals((Object)((GetClusterNodeLabelsResponsePBImpl)((Object)((Object)((Object)this)).getClass().cast(other))).getProto());
        }
        return false;
    }

    public int hashCode() {
        assert (false) : "hashCode not designed";
        return 0;
    }

    private void maybeInitBuilder() {
        if (this.viaProto || this.builder == null) {
            this.builder = YarnServiceProtos.GetClusterNodeLabelsResponseProto.newBuilder((YarnServiceProtos.GetClusterNodeLabelsResponseProto)this.proto);
        }
        this.viaProto = false;
    }

    public synchronized void setNodeLabelList(List<NodeLabel> nodeLabels) {
        this.maybeInitBuilder();
        this.updatedNodeLabels = new ArrayList<NodeLabel>();
        if (nodeLabels == null) {
            this.builder.clearNodeLabels();
            return;
        }
        this.updatedNodeLabels.addAll(nodeLabels);
    }

    @Deprecated
    public synchronized Set<String> getNodeLabels() {
        HashSet<String> set = new HashSet<String>();
        List<NodeLabel> labelList = this.getNodeLabelList();
        if (labelList != null) {
            for (NodeLabel label : labelList) {
                set.add(label.getName());
            }
        }
        return set;
    }

    @Deprecated
    public void setNodeLabels(Set<String> labels) {
        ArrayList<NodeLabel> list = new ArrayList<NodeLabel>();
        for (String s2 : labels) {
            list.add(NodeLabel.newInstance((String)s2));
        }
        this.setNodeLabelList(list);
    }

    private void initLocalNodeLabels() {
        YarnServiceProtos.GetClusterNodeLabelsResponseProto p = this.viaProto ? this.proto : this.builder;
        List attributesProtoList = p.getNodeLabelsList();
        this.updatedNodeLabels = new ArrayList<NodeLabel>();
        for (YarnProtos.NodeLabelProto r : attributesProtoList) {
            this.updatedNodeLabels.add(this.convertFromProtoFormat(r));
        }
    }

    public synchronized List<NodeLabel> getNodeLabelList() {
        if (this.updatedNodeLabels != null) {
            return this.updatedNodeLabels;
        }
        this.initLocalNodeLabels();
        return this.updatedNodeLabels;
    }

    private NodeLabel convertFromProtoFormat(YarnProtos.NodeLabelProto p) {
        return new NodeLabelPBImpl(p);
    }

    private YarnProtos.NodeLabelProto convertToProtoFormat(NodeLabel t2) {
        return ((NodeLabelPBImpl)t2).getProto();
    }

    public String toString() {
        return this.getProto().toString();
    }
}

