/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.web.oauth2;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.web.oauth2.AccessTokenProvider;
import org.apache.hadoop.hdfs.web.oauth2.AccessTokenTimer;
import org.apache.hadoop.hdfs.web.oauth2.Utils;
import org.apache.hadoop.util.JsonSerialization;
import org.apache.hadoop.util.Timer;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class ConfRefreshTokenBasedAccessTokenProvider
extends AccessTokenProvider {
    public static final String OAUTH_REFRESH_TOKEN_KEY = "dfs.webhdfs.oauth2.refresh.token";
    public static final String OAUTH_REFRESH_TOKEN_EXPIRES_KEY = "dfs.webhdfs.oauth2.refresh.token.expires.ms.since.epoch";
    private AccessTokenTimer accessTokenTimer;
    private String accessToken;
    private String refreshToken;
    private String clientId;
    private String refreshURL;

    public ConfRefreshTokenBasedAccessTokenProvider() {
        this.accessTokenTimer = new AccessTokenTimer();
    }

    public ConfRefreshTokenBasedAccessTokenProvider(Timer timer) {
        this.accessTokenTimer = new AccessTokenTimer(timer);
    }

    @Override
    public void setConf(Configuration conf) {
        super.setConf(conf);
        this.refreshToken = Utils.notNull(conf, OAUTH_REFRESH_TOKEN_KEY);
        this.accessTokenTimer.setExpiresInMSSinceEpoch(Utils.notNull(conf, OAUTH_REFRESH_TOKEN_EXPIRES_KEY));
        this.clientId = Utils.notNull(conf, "dfs.webhdfs.oauth2.client.id");
        this.refreshURL = Utils.notNull(conf, "dfs.webhdfs.oauth2.refresh.url");
    }

    @Override
    public synchronized String getAccessToken() throws IOException {
        if (this.accessTokenTimer.shouldRefresh()) {
            this.refresh();
        }
        return this.accessToken;
    }

    void refresh() throws IOException {
        ArrayList<BasicNameValuePair> pairs = new ArrayList<BasicNameValuePair>();
        pairs.add(new BasicNameValuePair("grant_type", "refresh_token"));
        pairs.add(new BasicNameValuePair("refresh_token", this.refreshToken));
        pairs.add(new BasicNameValuePair("client_id", this.clientId));
        RequestConfig config = RequestConfig.custom().setConnectTimeout(60000).setConnectionRequestTimeout(60000).setSocketTimeout(60000).build();
        try (CloseableHttpClient client = HttpClientBuilder.create().setDefaultRequestConfig(config).build();){
            HttpPost httpPost = new HttpPost(this.refreshURL);
            httpPost.setEntity(new UrlEncodedFormEntity(pairs, StandardCharsets.UTF_8));
            httpPost.setHeader("Content-Type", "application/x-www-form-urlencoded; charset=utf-8");
            try (CloseableHttpResponse response = client.execute(httpPost);){
                int statusCode = response.getStatusLine().getStatusCode();
                if (statusCode != 200) {
                    throw new IllegalArgumentException("Received invalid http response: " + statusCode + ", text = " + EntityUtils.toString(response.getEntity()));
                }
                Map responseBody = (Map)JsonSerialization.mapReader().readValue(EntityUtils.toString(response.getEntity()));
                String newExpiresIn = responseBody.get("expires_in").toString();
                this.accessTokenTimer.setExpiresIn(newExpiresIn);
                this.accessToken = responseBody.get("access_token").toString();
            }
        }
        catch (RuntimeException e) {
            throw new IOException("Exception while refreshing access token", e);
        }
        catch (Exception e) {
            throw new IOException("Exception while refreshing access token", e);
        }
    }

    public String getRefreshToken() {
        return this.refreshToken;
    }
}

