/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.kafka010;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.consumer.OffsetCommitCallback;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.apache.spark.SparkEnv$;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.streaming.StreamingContext;
import org.apache.spark.streaming.Time;
import org.apache.spark.streaming.Time$;
import org.apache.spark.streaming.dstream.DStream;
import org.apache.spark.streaming.dstream.DStreamCheckpointData;
import org.apache.spark.streaming.dstream.InputDStream;
import org.apache.spark.streaming.kafka010.CanCommitOffsets;
import org.apache.spark.streaming.kafka010.ConsumerStrategy;
import org.apache.spark.streaming.kafka010.KafkaRDD;
import org.apache.spark.streaming.kafka010.KafkaUtils$;
import org.apache.spark.streaming.kafka010.LocationStrategy;
import org.apache.spark.streaming.kafka010.OffsetRange;
import org.apache.spark.streaming.kafka010.OffsetRange$;
import org.apache.spark.streaming.kafka010.PerPartitionConfig;
import org.apache.spark.streaming.kafka010.PreferBrokers$;
import org.apache.spark.streaming.kafka010.PreferConsistent$;
import org.apache.spark.streaming.kafka010.PreferFixed;
import org.apache.spark.streaming.kafka010.package$;
import org.apache.spark.streaming.scheduler.RateController;
import org.apache.spark.streaming.scheduler.RateController$;
import org.apache.spark.streaming.scheduler.StreamInputInfo;
import org.apache.spark.streaming.scheduler.StreamInputInfo$;
import org.apache.spark.streaming.scheduler.rate.RateEstimator;
import org.apache.spark.streaming.scheduler.rate.RateEstimator$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.GenSet;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Set$;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\r]a!\u0002\u001d:\u0001u\u001a\u0005\u0002C9\u0001\u0005\u0003\u0005\u000b\u0011\u0002:\t\u0011Y\u0004!\u0011!Q\u0001\n]D\u0001B\u001f\u0001\u0003\u0002\u0003\u0006Ia\u001f\u0005\t}\u0002\u0011\t\u0011)A\u0005\u007f\"9\u0011Q\u0001\u0001\u0005\u0002\u0005\u001d\u0001\"CA\n\u0001\u0001\u0007I\u0011AA\u000b\u0011%\ti\u0002\u0001a\u0001\n\u0003\ty\u0002\u0003\u0005\u0002,\u0001\u0001\u000b\u0015BA\f\u0011%\ti\u0003\u0001b\u0001\n\u0003\ty\u0003\u0003\u0005\u0002d\u0001\u0001\u000b\u0011BA\u0019\u0011%\t)\u0007\u0001a\u0001\n#\t9\u0007C\u0005\u0002\f\u0002\u0001\r\u0011\"\u0005\u0002\u000e\"A\u0011\u0011\u0013\u0001!B\u0013\tI\u0007C\u0005\u0002\u0014\u0002\u0001\r\u0011\"\u0003\u0002\u0016\"I\u0011Q\u0014\u0001A\u0002\u0013%\u0011q\u0014\u0005\t\u0003G\u0003\u0001\u0015)\u0003\u0002\u0018\"1a\n\u0001C\u0001\u0003[C\u0011\"a,\u0001\u0001\u0004%I!!&\t\u0013\u0005E\u0006\u00011A\u0005\n\u0005M\u0006\u0002CA\\\u0001\u0001\u0006K!a&\t\u000f\u0005m\u0006\u0001\"\u0001\u0002\u0016\"9\u0011Q\u0018\u0001\u0005B\u0005}\u0006bBAl\u0001\u0011E\u0011\u0011\u001c\u0005\b\u0003;\u0004A\u0011CAp\u0011!\t)\u000f\u0001C!w\u0005\u001d\bBCAu\u0001\t\u0007I\u0011K\u001e\u0002l\"A!Q\u0007\u0001!\u0002\u0013\ti\u000f\u0003\u0006\u00038\u0001\u0011\r\u0011\"\u0015<\u0005sA\u0001B!\u0014\u0001A\u0003%!1\b\u0005\t\u0005\u001f\u0002A\u0011C\u001e\u0003R!9!Q\f\u0001\u0005\n\t}\u0003b\u0002B3\u0001\u0011%!q\r\u0005\b\u0005\u001f\u0003A\u0011\u0003BI\u0011\u001d\u0011\u0019\n\u0001C\t\u0005+CqA!'\u0001\t\u0003\u0012Y\nC\u0004\u0003*\u0002!\tEa\r\t\u000f\t-\u0006\u0001\"\u0011\u00034!I!Q\u0016\u0001C\u0002\u0013E!q\u0016\u0005\t\u0005\u0007\u0004\u0001\u0015!\u0003\u00032\"I!Q\u0019\u0001C\u0002\u0013E!q\u0019\u0005\t\u00057\u0004\u0001\u0015!\u0003\u0003J\"9!Q\u001c\u0001\u0005\u0002\t}\u0007b\u0002Bo\u0001\u0011\u0005!q\u001d\u0005\b\u0005_\u0004A\u0011\u0003B\u001a\r\u001d\t\t\u0010\u0001\u0001<\u0003gDq!!\u0002.\t\u0003\tY\u0010C\u0004\u0002~6\"\t!a@\t\u000f\t\rR\u0006\"\u0011\u0003&!9!1F\u0017\u0005B\t5\u0002b\u0002B\u0019[\u0011\u0005#1\u0007\u0004\b\u0005c\u0004\u0001a\u000fBz\u00111\u0011)p\rB\u0001B\u0003%!Q\u0004B|\u0011)\u0011Yp\rB\u0001B\u0003%!Q \u0005\b\u0003\u000b\u0019D\u0011AB\u0005\u0011\u001d\u0019\tb\rC!\u0007'\u0011q\u0003R5sK\u000e$8*\u00194lC&s\u0007/\u001e;E'R\u0014X-Y7\u000b\u0005iZ\u0014\u0001C6bM.\f\u0007'\r\u0019\u000b\u0005qj\u0014!C:ue\u0016\fW.\u001b8h\u0015\tqt(A\u0003ta\u0006\u00148N\u0003\u0002A\u0003\u00061\u0011\r]1dQ\u0016T\u0011AQ\u0001\u0004_J<Wc\u0001#XKN!\u0001!R4n!\r1\u0015jS\u0007\u0002\u000f*\u0011\u0001jO\u0001\bIN$(/Z1n\u0013\tQuI\u0001\u0007J]B,H\u000fR*ue\u0016\fW\u000e\u0005\u0003M'V#W\"A'\u000b\u00059{\u0015\u0001C2p]N,X.\u001a:\u000b\u0005A\u000b\u0016aB2mS\u0016tGo\u001d\u0006\u0003%~\nQa[1gW\u0006L!\u0001V'\u0003\u001d\r{gn];nKJ\u0014VmY8sIB\u0011ak\u0016\u0007\u0001\t\u0015A\u0006A1\u0001[\u0005\u0005Y5\u0001A\t\u00037\u0006\u0004\"\u0001X0\u000e\u0003uS\u0011AX\u0001\u0006g\u000e\fG.Y\u0005\u0003Av\u0013qAT8uQ&tw\r\u0005\u0002]E&\u00111-\u0018\u0002\u0004\u0003:L\bC\u0001,f\t\u00151\u0007A1\u0001[\u0005\u00051\u0006C\u00015l\u001b\u0005I'B\u00016>\u0003!Ig\u000e^3s]\u0006d\u0017B\u00017j\u0005\u001daunZ4j]\u001e\u0004\"A\\8\u000e\u0003eJ!\u0001]\u001d\u0003!\r\u000bgnQ8n[&$xJ\u001a4tKR\u001c\u0018\u0001B0tg\u000e\u0004\"a\u001d;\u000e\u0003mJ!!^\u001e\u0003!M#(/Z1nS:<7i\u001c8uKb$\u0018\u0001\u00057pG\u0006$\u0018n\u001c8TiJ\fG/Z4z!\tq\u00070\u0003\u0002zs\t\u0001Bj\\2bi&|gn\u0015;sCR,w-_\u0001\u0011G>t7/^7feN#(/\u0019;fOf\u0004BA\u001c?VI&\u0011Q0\u000f\u0002\u0011\u0007>t7/^7feN#(/\u0019;fOf\f1\u0001\u001d9d!\rq\u0017\u0011A\u0005\u0004\u0003\u0007I$A\u0005)feB\u000b'\u000f^5uS>t7i\u001c8gS\u001e\fa\u0001P5oSRtDCCA\u0005\u0003\u0017\ti!a\u0004\u0002\u0012A!a\u000eA+e\u0011\u0015\tX\u00011\u0001s\u0011\u00151X\u00011\u0001x\u0011\u0015QX\u00011\u0001|\u0011\u0015qX\u00011\u0001\u0000\u00039I7OR5sgR\u001cu.\u001c9vi\u0016,\"!a\u0006\u0011\u0007q\u000bI\"C\u0002\u0002\u001cu\u0013qAQ8pY\u0016\fg.\u0001\njg\u001aK'o\u001d;D_6\u0004X\u000f^3`I\u0015\fH\u0003BA\u0011\u0003O\u00012\u0001XA\u0012\u0013\r\t)#\u0018\u0002\u0005+:LG\u000fC\u0005\u0002*\u001d\t\t\u00111\u0001\u0002\u0018\u0005\u0019\u0001\u0010J\u0019\u0002\u001f%\u001ch)\u001b:ti\u000e{W\u000e];uK\u0002\n1#\u001a=fGV$xN]&bM.\f\u0007+\u0019:b[N,\"!!\r\u0011\u0011\u0005M\u0012QHA!\u0003/j!!!\u000e\u000b\t\u0005]\u0012\u0011H\u0001\u0005kRLGN\u0003\u0002\u0002<\u0005!!.\u0019<b\u0013\u0011\ty$!\u000e\u0003\u000f!\u000b7\u000f['baB!\u00111IA)\u001d\u0011\t)%!\u0014\u0011\u0007\u0005\u001dS,\u0004\u0002\u0002J)\u0019\u00111J-\u0002\rq\u0012xn\u001c;?\u0013\r\ty%X\u0001\u0007!J,G-\u001a4\n\t\u0005M\u0013Q\u000b\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005=S\f\u0005\u0003\u0002Z\u0005}SBAA.\u0015\u0011\ti&!\u000f\u0002\t1\fgnZ\u0005\u0005\u0003C\nYF\u0001\u0004PE*,7\r^\u0001\u0015Kb,7-\u001e;pe.\u000bgm[1QCJ\fWn\u001d\u0011\u0002\u001d\r,(O]3oi>3gm]3ugV\u0011\u0011\u0011\u000e\t\t\u0003W\n)(!\u001f\u0002\u00066\u0011\u0011Q\u000e\u0006\u0005\u0003_\n\t(A\u0005j[6,H/\u00192mK*\u0019\u00111O/\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002x\u00055$aA'baB!\u00111PAA\u001b\t\tiHC\u0002\u0002\u0000E\u000baaY8n[>t\u0017\u0002BAB\u0003{\u0012a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g\u000eE\u0002]\u0003\u000fK1!!#^\u0005\u0011auN\\4\u0002%\r,(O]3oi>3gm]3ug~#S-\u001d\u000b\u0005\u0003C\ty\tC\u0005\u0002*1\t\t\u00111\u0001\u0002j\u0005y1-\u001e:sK:$xJ\u001a4tKR\u001c\b%\u0001\u0002lGV\u0011\u0011q\u0013\t\u0006\u0019\u0006eU\u000bZ\u0005\u0004\u00037k%\u0001C\"p]N,X.\u001a:\u0002\r-\u001cw\fJ3r)\u0011\t\t#!)\t\u0013\u0005%r\"!AA\u0002\u0005]\u0015aA6dA!\u001a\u0001#a*\u0011\u0007q\u000bI+C\u0002\u0002,v\u0013\u0011\u0002\u001e:b]NLWM\u001c;\u0015\u0005\u0005]\u0015AA:d\u0003\u0019\u00198m\u0018\u0013fcR!\u0011\u0011EA[\u0011%\tIcEA\u0001\u0002\u0004\t9*A\u0002tG\u0002B3\u0001FAT\u0003=\u0019XM\u001d<jG\u0016\u001cuN\\:v[\u0016\u0014\u0018a\u00029feNL7\u000f\u001e\u000b\u0005\u0003\u0003\f9\r\u0005\u0003G\u0003\u0007\\\u0015bAAc\u000f\n9Ai\u0015;sK\u0006l\u0007bBAe-\u0001\u0007\u00111Z\u0001\t]\u0016<H*\u001a<fYB!\u0011QZAj\u001b\t\tyMC\u0002\u0002Rv\nqa\u001d;pe\u0006<W-\u0003\u0003\u0002V\u0006='\u0001D*u_J\fw-\u001a'fm\u0016d\u0017AC4fi\n\u0013xn[3sgV\u0011\u00111\u001c\t\t\u0003g\ti$!\u001f\u0002B\u0005\tr-\u001a;Qe\u00164WM\u001d:fI\"{7\u000f^:\u0016\u0005\u0005\u0005\b\u0003CA\u001a\u0003G\fI(!\u0011\n\t\u0005]\u0014QG\u0001\u0005]\u0006lW-\u0006\u0002\u0002B\u0005q1\r[3dWB|\u0017N\u001c;ECR\fWCAAw!\r\ty/L\u0007\u0002\u0001\t)C)\u001b:fGR\\\u0015MZ6b\u0013:\u0004X\u000f\u001e#TiJ,\u0017-\\\"iK\u000e\\\u0007o\\5oi\u0012\u000bG/Y\n\u0004[\u0005U\b\u0003\u0002$\u0002x.K1!!?H\u0005U!5\u000b\u001e:fC6\u001c\u0005.Z2la>Lg\u000e\u001e#bi\u0006$\"!!<\u0002\u0019\t\fGo\u00195G_J$\u0016.\\3\u0016\u0005\t\u0005\u0001\u0003\u0003B\u0002\u0005\u0013\u0011YA!\u0005\u000e\u0005\t\u0015!\u0002\u0002B\u0004\u0003c\nq!\\;uC\ndW-\u0003\u0003\u0002@\t\u0015\u0001cA:\u0003\u000e%\u0019!qB\u001e\u0003\tQKW.\u001a\t\u00069\nM!qC\u0005\u0004\u0005+i&!B!se\u0006L\bc\u0003/\u0003\u001a\u0005\u0005#QDAC\u0003\u000bK1Aa\u0007^\u0005\u0019!V\u000f\u001d7fiA\u0019ALa\b\n\u0007\t\u0005RLA\u0002J]R\fa!\u001e9eCR,G\u0003BA\u0011\u0005OAqA!\u000b1\u0001\u0004\u0011Y!\u0001\u0003uS6,\u0017aB2mK\u0006tW\u000f\u001d\u000b\u0005\u0003C\u0011y\u0003C\u0004\u0003*E\u0002\rAa\u0003\u0002\u000fI,7\u000f^8sKR\u0011\u0011\u0011E\u0001\u0010G\",7m\u001b9pS:$H)\u0019;bA\u0005q!/\u0019;f\u0007>tGO]8mY\u0016\u0014XC\u0001B\u001e!\u0015a&Q\bB!\u0013\r\u0011y$\u0018\u0002\u0007\u001fB$\u0018n\u001c8\u0011\t\t\r#\u0011J\u0007\u0003\u0005\u000bR1Aa\u0012<\u0003%\u00198\r[3ek2,'/\u0003\u0003\u0003L\t\u0015#A\u0004*bi\u0016\u001cuN\u001c;s_2dWM]\u0001\u0010e\u0006$XmQ8oiJ|G\u000e\\3sA\u00059R.\u0019=NKN\u001c\u0018mZ3t!\u0016\u0014\b+\u0019:uSRLwN\u001c\u000b\u0005\u0005'\u0012I\u0006E\u0003]\u0005{\u0011)\u0006\u0005\u0005\u0002D\t]\u0013\u0011PAC\u0013\u0011\t9(!\u0016\t\u000f\tmc\u00041\u0001\u0003V\u00059qN\u001a4tKR\u001c\u0018\u0001\u00049be\u0006tw.\u001b3Q_2dG\u0003BA\u0011\u0005CBqAa\u0019 \u0001\u0004\t9*A\u0001d\u0003-9\u0018\u000e\u001e5SKR\u0014\u0018.Z:\u0016\t\t%$q\u000e\u000b\u0005\u0005W\u0012i\b\u0006\u0003\u0003n\tM\u0004c\u0001,\u0003p\u00111!\u0011\u000f\u0011C\u0002i\u0013\u0011\u0001\u0016\u0005\t\u0005k\u0002C\u00111\u0001\u0003x\u0005\ta\rE\u0003]\u0005s\u0012i'C\u0002\u0003|u\u0013\u0001\u0002\u00102z]\u0006lWM\u0010\u0005\b\u0005\u007f\u0002\u0003\u0019AAC\u0003\u0005!\bf\u0001\u0011\u0003\u0004B!!Q\u0011BF\u001b\t\u00119IC\u0002\u0003\nv\u000b!\"\u00198o_R\fG/[8o\u0013\u0011\u0011iIa\"\u0003\u000fQ\f\u0017\u000e\u001c:fG\u0006iA.\u0019;fgR|eMZ:fiN$\"A!\u0016\u0002\u000b\rd\u0017-\u001c9\u0015\t\tU#q\u0013\u0005\b\u00057\u0012\u0003\u0019\u0001B+\u0003\u001d\u0019w.\u001c9vi\u0016$BA!(\u0003&B)AL!\u0010\u0003 B)aN!)VI&\u0019!1U\u001d\u0003\u0011-\u000bgm[1S\t\u0012CqAa*$\u0001\u0004\u0011Y!A\u0005wC2LG\rV5nK\u0006)1\u000f^1si\u0006!1\u000f^8q\u0003-\u0019w.\\7jiF+X-^3\u0016\u0005\tE\u0006C\u0002BZ\u0005s\u0013i,\u0004\u0002\u00036*!!qWA\u001b\u0003)\u0019wN\\2veJ,g\u000e^\u0005\u0005\u0005w\u0013)LA\u000bD_:\u001cWO\u001d:f]Rd\u0015N\\6fIF+X-^3\u0011\u00079\u0014y,C\u0002\u0003Bf\u00121b\u00144gg\u0016$(+\u00198hK\u0006a1m\\7nSR\fV/Z;fA\u0005q1m\\7nSR\u001c\u0015\r\u001c7cC\u000e\\WC\u0001Be!\u0019\u0011YM!5\u0003V6\u0011!Q\u001a\u0006\u0005\u0005\u001f\u0014),\u0001\u0004bi>l\u0017nY\u0005\u0005\u0005'\u0014iMA\bBi>l\u0017n\u0019*fM\u0016\u0014XM\\2f!\ra%q[\u0005\u0004\u00053l%\u0001F(gMN,GoQ8n[&$8)\u00197mE\u0006\u001c7.A\bd_6l\u0017\u000e^\"bY2\u0014\u0017mY6!\u0003-\u0019w.\\7ji\u0006\u001b\u0018P\\2\u0015\t\u0005\u0005\"\u0011\u001d\u0005\b\u0005GT\u0003\u0019\u0001Bs\u00031ygMZ:fiJ\u000bgnZ3t!\u0015a&1\u0003B_)\u0019\t\tC!;\u0003l\"9!1]\u0016A\u0002\t\u0015\bb\u0002BwW\u0001\u0007!Q[\u0001\tG\u0006dGNY1dW\u0006I1m\\7nSR\fE\u000e\u001c\u0002\u001a\t&\u0014Xm\u0019;LC\u001a\\\u0017MU1uK\u000e{g\u000e\u001e:pY2,'oE\u00024\u0005\u0003\n!!\u001b3\n\t\te(\u0011J\u0001\ngR\u0014X-Y7V\u0013\u0012\u000b\u0011\"Z:uS6\fGo\u001c:\u0011\t\t}8QA\u0007\u0003\u0007\u0003QAaa\u0001\u0003F\u0005!!/\u0019;f\u0013\u0011\u00199a!\u0001\u0003\u001bI\u000bG/Z#ti&l\u0017\r^8s)\u0019\u0019Ya!\u0004\u0004\u0010A\u0019\u0011q^\u001a\t\u000f\tUh\u00071\u0001\u0003\u001e!9!1 \u001cA\u0002\tu\u0018a\u00029vE2L7\u000f\u001b\u000b\u0005\u0003C\u0019)\u0002C\u0004\u0004\u0004]\u0002\r!!\"")
public class DirectKafkaInputDStream<K, V>
extends InputDStream<ConsumerRecord<K, V>>
implements CanCommitOffsets {
    private final LocationStrategy locationStrategy;
    private final ConsumerStrategy<K, V> consumerStrategy;
    private final PerPartitionConfig ppc;
    private boolean isFirstCompute;
    private final HashMap<String, Object> executorKafkaParams;
    private scala.collection.immutable.Map<TopicPartition, Object> currentOffsets;
    private transient Consumer<K, V> kc;
    private transient Consumer<K, V> sc;
    private final DirectKafkaInputDStreamCheckpointData checkpointData;
    private final Option<RateController> rateController;
    private final ConcurrentLinkedQueue<OffsetRange> commitQueue;
    private final AtomicReference<OffsetCommitCallback> commitCallback;

    public boolean isFirstCompute() {
        return this.isFirstCompute;
    }

    public void isFirstCompute_$eq(boolean x$1) {
        this.isFirstCompute = x$1;
    }

    public HashMap<String, Object> executorKafkaParams() {
        return this.executorKafkaParams;
    }

    public scala.collection.immutable.Map<TopicPartition, Object> currentOffsets() {
        return this.currentOffsets;
    }

    public void currentOffsets_$eq(scala.collection.immutable.Map<TopicPartition, Object> x$1) {
        this.currentOffsets = x$1;
    }

    private Consumer<K, V> kc() {
        return this.kc;
    }

    private void kc_$eq(Consumer<K, V> x$1) {
        this.kc = x$1;
    }

    public synchronized Consumer<K, V> consumer() {
        block0: {
            if (this.kc() != null) break block0;
            this.kc_$eq(this.consumerStrategy.onStart((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)this.currentOffsets().mapValues((Function1 & Serializable & scala.Serializable)l -> BoxesRunTime.unboxToLong((Object)l)).toMap(Predef$.MODULE$.$conforms())).asJava()));
        }
        return this.kc();
    }

    private Consumer<K, V> sc() {
        return this.sc;
    }

    private void sc_$eq(Consumer<K, V> x$1) {
        this.sc = x$1;
    }

    public synchronized Consumer<K, V> serviceConsumer() {
        block0: {
            if (this.sc() != null) break block0;
            this.sc_$eq(this.consumerStrategy.serviceConsumer());
        }
        return this.sc();
    }

    public DStream<ConsumerRecord<K, V>> persist(StorageLevel newLevel) {
        this.logError((Function0 & Serializable & scala.Serializable)() -> "Kafka ConsumerRecord is not serializable. Use .map to extract fields before calling .persist or .window");
        return super.persist(newLevel);
    }

    public HashMap<TopicPartition, String> getBrokers() {
        Consumer<K, V> c = this.consumer();
        HashMap<TopicPartition, String> result = new HashMap<TopicPartition, String>();
        HashMap<TopicPartition, String> hosts = new HashMap<TopicPartition, String>();
        for (TopicPartition tp : c.assignment()) {
            if (hosts.get(tp) == null) {
                for (PartitionInfo i : c.partitionsFor(tp.topic())) {
                    hosts.put(new TopicPartition(i.topic(), i.partition()), i.leader().host());
                }
            }
            result.put(tp, (String)hosts.get(tp));
        }
        return result;
    }

    public java.util.Map<TopicPartition, String> getPreferredHosts() {
        LocationStrategy locationStrategy = this.locationStrategy;
        if (PreferBrokers$.MODULE$.equals(locationStrategy)) {
            return this.getBrokers();
        }
        if (PreferConsistent$.MODULE$.equals(locationStrategy)) {
            return Collections.emptyMap();
        }
        if (locationStrategy instanceof PreferFixed) {
            PreferFixed preferFixed = (PreferFixed)locationStrategy;
            java.util.Map<TopicPartition, String> hostMap = preferFixed.hostMap();
            return hostMap;
        }
        throw new MatchError((Object)locationStrategy);
    }

    public String name() {
        return new StringBuilder(27).append("Kafka 0.10 direct stream [").append(this.id()).append("]").toString();
    }

    public DirectKafkaInputDStreamCheckpointData checkpointData() {
        return this.checkpointData;
    }

    public Option<RateController> rateController() {
        return this.rateController;
    }

    public Option<scala.collection.immutable.Map<TopicPartition, Object>> maxMessagesPerPartition(scala.collection.immutable.Map<TopicPartition, Object> offsets) {
        scala.collection.immutable.Map map;
        Option estimatedRateLimit = this.rateController().map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToLong((long)x$1.getLatestRate()));
        Option option = estimatedRateLimit.filter((Function1)(JFunction1.mcZJ.sp & Serializable & scala.Serializable)x$2 -> x$2 > 0L);
        if (option instanceof Some) {
            Some some = (Some)option;
            long rate = BoxesRunTime.unboxToLong((Object)some.value());
            scala.collection.immutable.Map lagPerPartition = (scala.collection.immutable.Map)offsets.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    TopicPartition tp = (TopicPartition)tuple2._1();
                    long offset = tuple2._2$mcJ$sp();
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)BoxesRunTime.boxToLong((long)Math.max(offset - BoxesRunTime.unboxToLong((Object)this.currentOffsets().apply((Object)tp)), 0L)));
                }
                throw new MatchError((Object)tuple2);
            }, Map$.MODULE$.canBuildFrom());
            long totalLag = BoxesRunTime.unboxToLong((Object)lagPerPartition.values().sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
            map = (scala.collection.immutable.Map)lagPerPartition.map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                Tuple2 tuple2 = x0$2;
                if (tuple2 != null) {
                    TopicPartition tp = (TopicPartition)tuple2._1();
                    long lag = tuple2._2$mcJ$sp();
                    long maxRateLimitPerPartition = $this.ppc.maxRatePerPartition(tp);
                    int backpressureRate = Math.round((float)lag / (float)totalLag * (float)rate);
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)(maxRateLimitPerPartition > 0L ? BoxesRunTime.boxToLong((long)Math.min((long)backpressureRate, maxRateLimitPerPartition)) : BoxesRunTime.boxToLong((long)backpressureRate)));
                }
                throw new MatchError((Object)tuple2);
            }, Map$.MODULE$.canBuildFrom());
        } else if (None$.MODULE$.equals(option)) {
            map = (scala.collection.immutable.Map)offsets.map((Function1 & Serializable & scala.Serializable)x0$3 -> {
                Tuple2 tuple2 = x0$3;
                if (tuple2 != null) {
                    TopicPartition tp = (TopicPartition)tuple2._1();
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)BoxesRunTime.boxToLong((long)$this.ppc.maxRatePerPartition(tp)));
                }
                throw new MatchError((Object)tuple2);
            }, Map$.MODULE$.canBuildFrom());
        } else {
            throw new MatchError((Object)option);
        }
        scala.collection.immutable.Map effectiveRateLimitPerPartition = map;
        if (BoxesRunTime.unboxToLong((Object)effectiveRateLimitPerPartition.values().sum((Numeric)Numeric.LongIsIntegral$.MODULE$)) > 0L) {
            double secsPerBatch = (double)this.context().graph().batchDuration().milliseconds() / (double)1000;
            return new Some(effectiveRateLimitPerPartition.map((Function1 & Serializable & scala.Serializable)x0$4 -> {
                Tuple2 tuple2 = x0$4;
                if (tuple2 != null) {
                    TopicPartition tp = (TopicPartition)tuple2._1();
                    long limit = tuple2._2$mcJ$sp();
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)BoxesRunTime.boxToLong((long)((long)(secsPerBatch * (double)limit))));
                }
                throw new MatchError((Object)tuple2);
            }, Map$.MODULE$.canBuildFrom()));
        }
        return None$.MODULE$;
    }

    private void paranoidPoll(Consumer<K, V> c) {
        java.util.Set parts;
        ConsumerRecords<K, V> msgs = c.poll(0L);
        java.util.Set newAssignment = c.assignment();
        java.util.Set set = parts = this.currentOffsets().size() < newAssignment.size() ? newAssignment : (java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)this.currentOffsets().keySet()).asJava();
        if (this.serviceConsumer().assignment().size() < parts.size()) {
            this.serviceConsumer().assign(parts);
        }
        if (!msgs.isEmpty()) {
            long waitingForAssigmentTimeout = SparkEnv$.MODULE$.get().conf().getLong("spark.mapr.WaitingForAssignmentTimeout", 600000L);
            ((IterableLike)((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(msgs).asScala()).foldLeft((Object)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$), (Function2 & Serializable & scala.Serializable)(acc, m4) -> {
                TopicPartition tp = new TopicPartition(m4.topic(), m4.partition());
                long off = BoxesRunTime.unboxToLong((Object)acc.get((Object)tp).map((Function1)(JFunction1.mcJJ.sp & Serializable & scala.Serializable)o -> Math.min(o, m4.offset())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> m4.offset()));
                return acc.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)BoxesRunTime.boxToLong((long)off)));
            })).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                DirectKafkaInputDStream.$anonfun$paranoidPoll$4(this, waitingForAssigmentTimeout, c, x0$1);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    private <T> T withRetries(long t2, Function0<T> f) {
        Try try_;
        while (true) {
            if ((try_ = Try$.MODULE$.apply(f)) instanceof Success) {
                Success success = (Success)try_;
                Object v = success.value();
                return (T)v;
            }
            if (t2 <= 0L) break;
            Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> Thread.sleep(500L));
            t2 -= 500L;
        }
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable e = failure.exception();
            throw e;
        }
        throw new MatchError((Object)try_);
    }

    public scala.collection.immutable.Map<TopicPartition, Object> latestOffsets() {
        scala.collection.mutable.Set parts;
        block3: {
            Consumer<K, V> c = this.consumer();
            this.paranoidPoll(c);
            parts = (scala.collection.mutable.Set)JavaConverters$.MODULE$.asScalaSetConverter(KafkaUtils$.MODULE$.waitForConsumerAssignment(c, (java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)this.currentOffsets().keySet()).asJava())).asScala();
            if (parts.size() < this.currentOffsets().keySet().size()) {
                this.logWarning((Function0 & Serializable & scala.Serializable)() -> "Assignment() returned fewer partitions than the previous call");
            }
            if (this.serviceConsumer().assignment().size() < parts.size()) {
                this.serviceConsumer().assign((Collection)JavaConverters$.MODULE$.mutableSetAsJavaSetConverter(parts).asJava());
            }
            scala.collection.mutable.Set newPartitions = (scala.collection.mutable.Set)parts.diff((GenSet)this.currentOffsets().keySet());
            scala.collection.immutable.Set revokedPartitions = (scala.collection.immutable.Set)this.currentOffsets().keySet().diff((GenSet)parts);
            if (revokedPartitions.nonEmpty()) {
                throw new IllegalStateException(new StringBuilder(300).append("Previously tracked partitions ").append(revokedPartitions.mkString("[", ",", "]")).append(" been revoked by Kafka because of consumer ").append("rebalance. This is mostly due to another stream with same group id joined, ").append("please check if there're different streaming application misconfigure to use same ").append("group id. Fundamentally different stream should use different group id").toString());
            }
            this.currentOffsets_$eq((scala.collection.immutable.Map<TopicPartition, Object>)this.currentOffsets().$plus$plus((GenTraversableOnce)((TraversableOnce)newPartitions.map((Function1 & Serializable & scala.Serializable)tp -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(tp), (Object)BoxesRunTime.boxToLong((long)this.serviceConsumer().position((TopicPartition)tp))), Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms())));
            c.pause((Collection)JavaConverters$.MODULE$.mutableSetAsJavaSetConverter(newPartitions).asJava());
            if (this.serviceConsumer().assignment().isEmpty()) break block3;
            this.serviceConsumer().seekToEnd((Collection)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)this.currentOffsets().keySet()).asJava());
        }
        return ((TraversableOnce)parts.map((Function1 & Serializable & scala.Serializable)tp -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(tp), (Object)BoxesRunTime.boxToLong((long)this.serviceConsumer().position((TopicPartition)tp))), Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public scala.collection.immutable.Map<TopicPartition, Object> clamp(scala.collection.immutable.Map<TopicPartition, Object> offsets) {
        return (scala.collection.immutable.Map)this.maxMessagesPerPartition(offsets).map((Function1 & Serializable & scala.Serializable)mmp -> (scala.collection.immutable.Map)mmp.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                TopicPartition tp = (TopicPartition)tuple2._1();
                long messages = tuple2._2$mcJ$sp();
                long uo = BoxesRunTime.unboxToLong((Object)offsets.apply((Object)tp));
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)BoxesRunTime.boxToLong((long)Math.min(BoxesRunTime.unboxToLong((Object)this.currentOffsets().apply((Object)tp)) + messages, uo)));
            }
            throw new MatchError((Object)tuple2);
        }, Map$.MODULE$.canBuildFrom())).getOrElse((Function0 & Serializable & scala.Serializable)() -> offsets);
    }

    public Option<KafkaRDD<K, V>> compute(Time validTime) {
        scala.collection.immutable.Map<TopicPartition, Object> untilOffsets = this.clamp(this.latestOffsets());
        Iterable offsetRanges = (Iterable)untilOffsets.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                TopicPartition tp = (TopicPartition)tuple2._1();
                long uo = tuple2._2$mcJ$sp();
                long fo = BoxesRunTime.unboxToLong((Object)this.currentOffsets().apply((Object)tp));
                if (this.isFirstCompute() && KafkaUtils$.MODULE$.isStreams(untilOffsets) && uo - fo == 1L && $this.consumerStrategy.executorKafkaParams().get("auto.offset.reset").toString().equals("latest")) {
                    fo = uo;
                    this.isFirstCompute_$eq(false);
                }
                return OffsetRange$.MODULE$.apply(tp.topic(), tp.partition(), fo, uo);
            }
            throw new MatchError((Object)tuple2);
        }, Iterable$.MODULE$.canBuildFrom());
        boolean useConsumerCache = BoxesRunTime.unboxToBoolean((Object)this.context().conf().get(package$.MODULE$.CONSUMER_CACHE_ENABLED()));
        KafkaRDD rdd = new KafkaRDD(this.context().sparkContext(), this.executorKafkaParams(), (OffsetRange[])offsetRanges.toArray(ClassTag$.MODULE$.apply(OffsetRange.class)), this.getPreferredHosts(), useConsumerCache);
        String description = ((TraversableOnce)((TraversableLike)((TraversableOnce)offsetRanges.filter((Function1 & Serializable & scala.Serializable)offsetRange -> BoxesRunTime.boxToBoolean((boolean)DirectKafkaInputDStream.$anonfun$compute$2(offsetRange)))).toSeq().sortBy((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToLong((long)DirectKafkaInputDStream.$anonfun$compute$3(x$3)), (Ordering)Ordering.Long$.MODULE$)).map((Function1 & Serializable & scala.Serializable)offsetRange -> new StringBuilder(41).append("topic: ").append(offsetRange.topic()).append("\tpartition: ").append(offsetRange.partition()).append("\t").append("offsets: ").append(offsetRange.fromOffset()).append(" to ").append(offsetRange.untilOffset()).append("\t").append("count: ").append(offsetRange.count()).toString(), Seq$.MODULE$.canBuildFrom())).mkString("\n");
        scala.collection.immutable.Map metadata = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"offsets"), (Object)offsetRanges.toList()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)StreamInputInfo$.MODULE$.METADATA_KEY_DESCRIPTION()), (Object)description)}));
        StreamInputInfo inputInfo = new StreamInputInfo(this.id(), rdd.count(), metadata);
        this.ssc().scheduler().inputInfoTracker().reportInfo(validTime, inputInfo);
        this.currentOffsets_$eq(untilOffsets);
        this.commitAll();
        return new Some(rdd);
    }

    public void start() {
        Consumer c = this.consumer();
        this.paranoidPoll(c);
        if (this.currentOffsets().isEmpty()) {
            this.currentOffsets_$eq((scala.collection.immutable.Map<TopicPartition, Object>)((TraversableOnce)((SetLike)JavaConverters$.MODULE$.asScalaSetConverter(c.assignment()).asScala()).map((Function1 & Serializable & scala.Serializable)tp -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(tp), (Object)BoxesRunTime.boxToLong((long)c.position((TopicPartition)tp))), Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms()));
        }
        c.pause((Collection)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)this.currentOffsets().keySet()).asJava());
    }

    public synchronized void stop() {
        if (this.kc() != null) {
            this.kc().close();
        }
        this.serviceConsumer().close();
    }

    public ConcurrentLinkedQueue<OffsetRange> commitQueue() {
        return this.commitQueue;
    }

    public AtomicReference<OffsetCommitCallback> commitCallback() {
        return this.commitCallback;
    }

    @Override
    public void commitAsync(OffsetRange[] offsetRanges) {
        this.commitAsync(offsetRanges, null);
    }

    @Override
    public void commitAsync(OffsetRange[] offsetRanges, OffsetCommitCallback callback) {
        this.commitCallback().set(callback);
        this.commitQueue().addAll(Arrays.asList((Object[])offsetRanges));
    }

    public void commitAll() {
        HashMap<TopicPartition, OffsetAndMetadata> m4 = new HashMap<TopicPartition, OffsetAndMetadata>();
        OffsetRange osr = this.commitQueue().poll();
        while (osr != null) {
            TopicPartition tp = osr.topicPartition();
            OffsetAndMetadata x = (OffsetAndMetadata)m4.get(tp);
            long offset = x == null ? osr.untilOffset() : Math.max(x.offset(), osr.untilOffset());
            m4.put(tp, new OffsetAndMetadata(offset));
            osr = this.commitQueue().poll();
        }
        if (!m4.isEmpty()) {
            if (KafkaUtils$.MODULE$.isStreams(this.currentOffsets())) {
                this.serviceConsumer().commitAsync(m4, this.commitCallback().get());
                return;
            }
            this.consumer().commitAsync(m4, this.commitCallback().get());
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$paranoidPoll$4(DirectKafkaInputDStream $this, long waitingForAssigmentTimeout$1, Consumer c$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            TopicPartition tp = (TopicPartition)tuple2._1();
            long off = tuple2._2$mcJ$sp();
            $this.logInfo((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(53).append("poll(0) returned messages, seeking ").append(tp).append(" to ").append(off).append(" to compensate").toString());
            $this.serviceConsumer().seek(tp, off);
            BoxedUnit cfr_ignored_0 = (BoxedUnit)$this.withRetries(waitingForAssigmentTimeout$1, (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> c$1.seek(tp, off));
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$compute$2(OffsetRange offsetRange) {
        return offsetRange.fromOffset() != offsetRange.untilOffset();
    }

    public static final /* synthetic */ long $anonfun$compute$3(OffsetRange x$3) {
        return -x$3.count();
    }

    public DirectKafkaInputDStream(StreamingContext _ssc, LocationStrategy locationStrategy, ConsumerStrategy<K, V> consumerStrategy, PerPartitionConfig ppc) {
        this.locationStrategy = locationStrategy;
        this.consumerStrategy = consumerStrategy;
        this.ppc = ppc;
        super(_ssc, ClassTag$.MODULE$.apply(ConsumerRecord.class));
        this.isFirstCompute = true;
        HashMap<String, Object> ekp = new HashMap<String, Object>(consumerStrategy.executorKafkaParams());
        KafkaUtils$.MODULE$.fixKafkaParams(ekp);
        this.executorKafkaParams = ekp;
        this.currentOffsets = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
        this.kc = null;
        this.sc = null;
        this.checkpointData = new DirectKafkaInputDStreamCheckpointData();
        this.rateController = RateController$.MODULE$.isBackPressureEnabled(this.ssc().conf()) ? new Some((Object)new DirectKafkaRateController(this.id(), RateEstimator$.MODULE$.create(this.ssc().conf(), this.context().graph().batchDuration()))) : None$.MODULE$;
        this.commitQueue = new ConcurrentLinkedQueue();
        this.commitCallback = new AtomicReference();
    }

    public class DirectKafkaInputDStreamCheckpointData
    extends DStreamCheckpointData<ConsumerRecord<K, V>> {
        public scala.collection.mutable.HashMap<Time, Tuple4<String, Object, Object, Object>[]> batchForTime() {
            return this.data();
        }

        public void update(Time time) {
            this.batchForTime().clear();
            this.org$apache$spark$streaming$kafka010$DirectKafkaInputDStream$DirectKafkaInputDStreamCheckpointData$$$outer().generatedRDDs().foreach((Function1 & Serializable & scala.Serializable)kv -> {
                Tuple4[] a = (Tuple4[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])((KafkaRDD)kv._2()).offsetRanges())).map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.toTuple(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple4.class)));
                return this.batchForTime().$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(kv._1()), (Object)a));
            });
        }

        public void cleanup(Time time) {
        }

        public void restore() {
            ((IterableLike)this.batchForTime().toSeq().sortBy((Function1 & Serializable & scala.Serializable)x$5 -> (Time)x$5._1(), Time$.MODULE$.ordering())).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    Time t2 = (Time)tuple2._1();
                    Tuple4[] b = (Tuple4[])tuple2._2();
                    this.logInfo((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(29).append("Restoring KafkaRDD for time ").append(t2).append(" ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])b)).mkString("[", ", ", "]")).toString());
                    return this.org$apache$spark$streaming$kafka010$DirectKafkaInputDStream$DirectKafkaInputDStreamCheckpointData$$$outer().generatedRDDs().$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)t2), new KafkaRDD(this.org$apache$spark$streaming$kafka010$DirectKafkaInputDStream$DirectKafkaInputDStreamCheckpointData$$$outer().context().sparkContext(), this.org$apache$spark$streaming$kafka010$DirectKafkaInputDStream$DirectKafkaInputDStreamCheckpointData$$$outer().executorKafkaParams(), (OffsetRange[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])b)).map((Function1 & Serializable & scala.Serializable)x$6 -> OffsetRange$.MODULE$.apply((Tuple4<String, Object, Object, Object>)x$6), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(OffsetRange.class))), this.org$apache$spark$streaming$kafka010$DirectKafkaInputDStream$DirectKafkaInputDStreamCheckpointData$$$outer().getPreferredHosts(), false)));
                }
                throw new MatchError((Object)tuple2);
            });
        }

        public /* synthetic */ DirectKafkaInputDStream org$apache$spark$streaming$kafka010$DirectKafkaInputDStream$DirectKafkaInputDStreamCheckpointData$$$outer() {
            return DirectKafkaInputDStream.this;
        }

        public DirectKafkaInputDStreamCheckpointData() {
            if (DirectKafkaInputDStream.this == null) {
                throw null;
            }
            super((DStream)DirectKafkaInputDStream.this, ClassTag$.MODULE$.apply(ConsumerRecord.class));
        }
    }

    public class DirectKafkaRateController
    extends RateController {
        public void publish(long rate) {
        }

        public /* synthetic */ DirectKafkaInputDStream org$apache$spark$streaming$kafka010$DirectKafkaInputDStream$DirectKafkaRateController$$$outer() {
            return DirectKafkaInputDStream.this;
        }

        public DirectKafkaRateController(int id, RateEstimator estimator) {
            if (DirectKafkaInputDStream.this == null) {
                throw null;
            }
            super(id, estimator);
        }
    }
}

