/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kerby.kerberos.kerb.client;

import org.apache.kerby.KOptions;
import org.apache.kerby.kerberos.kerb.client.KrbConfig;
import org.apache.kerby.kerberos.kerb.client.KrbSetting;
import org.apache.kerby.kerberos.kerb.client.preauth.PreauthHandler;
import org.apache.kerby.kerberos.kerb.crypto.util.Nonce;

public class KrbContext {
    private KrbSetting krbSetting;
    private PreauthHandler preauthHandler;

    public void init(KrbSetting krbSetting) {
        this.krbSetting = krbSetting;
        this.preauthHandler = new PreauthHandler();
        this.preauthHandler.init(this);
    }

    public KrbSetting getKrbSetting() {
        return this.krbSetting;
    }

    public KrbConfig getConfig() {
        return this.krbSetting.getKrbConfig();
    }

    public int generateNonce() {
        return Nonce.value();
    }

    public long getTicketValidTime() {
        String ticketValidTimeStr = this.getConfig().getTicketLifetime();
        long ticketValidTime = KOptions.parseDuration(ticketValidTimeStr);
        return ticketValidTime * 1000L;
    }

    public PreauthHandler getPreauthHandler() {
        return this.preauthHandler;
    }
}

