/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.mapr.util;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.errors.InvalidTopicException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapRTopicUtils {
    private static final Logger LOG = LoggerFactory.getLogger(MapRTopicUtils.class);
    private static final boolean IS_OS_WINDOWS = System.getProperty("os.name").toLowerCase().startsWith("windows");
    public static final String MAPR_HOME = MapRTopicUtils.findMapRHome();
    public static final String MAPR_CLUSTERS_FILE = MAPR_HOME + "/conf/mapr-clusters.conf";
    private static List<String> clusterNames = null;
    public static final String LEGAL_CHARS = "[a-zA-Z0-9._-]";
    public static final String LEAGAL_FULLTOPICNAME_PATTERN = String.format("(\\/%s+)+\\:%s+", "[a-zA-Z0-9._-]", "[a-zA-Z0-9._-]");

    public static void validateFullTopicName(String fullTopicName) {
        if (!fullTopicName.matches(LEAGAL_FULLTOPICNAME_PATTERN)) {
            throw new InvalidTopicException(String.format("Full topic name %s is invalid. It should be %s", fullTopicName, LEAGAL_FULLTOPICNAME_PATTERN));
        }
    }

    public static boolean isFullTopicName(String fullTopicName) {
        return fullTopicName.startsWith("/") && fullTopicName.contains(":");
    }

    public static String buildFullTopicName(String streamName, String shortTopicName) {
        return String.format("%s:%s", streamName, shortTopicName);
    }

    public static List<String> decorateTopicsWithDefaultStreamIfNeeded(List<String> topics, String defaultStream) {
        ArrayList<String> res = new ArrayList<String>(topics.size());
        Iterator<String> iterator = topics.iterator();
        while (iterator.hasNext()) {
            String topic;
            String decoratedTopic = topic = iterator.next();
            if (!topic.contains(":")) {
                if (defaultStream.isEmpty()) {
                    throw new InvalidTopicException(String.format("Default stream is not specified. Short topic name %s is invalid.", topic));
                }
                decoratedTopic = String.format("%s:%s", defaultStream, topic);
            }
            MapRTopicUtils.validateFullTopicName(decoratedTopic);
            res.add(decoratedTopic);
        }
        return res;
    }

    public static List<String> addStreamNameToTopics(List<String> topics, String stream) {
        LinkedList<String> res = new LinkedList<String>();
        for (String topic : topics) {
            res.add(MapRTopicUtils.buildFullTopicName(stream, topic));
        }
        return res;
    }

    public static Map<String, Set<String>> groupTopicsByStreamName(List<String> topics) {
        HashMap<String, Set<String>> res = new HashMap<String, Set<String>>();
        for (String topic : topics) {
            String[] parts = topic.split(":");
            String streamName = parts[0];
            String shortTopicName = parts[1];
            HashSet<String> groupedTopics = (HashSet<String>)res.get(streamName);
            if (groupedTopics == null) {
                groupedTopics = new HashSet<String>();
                res.put(streamName, groupedTopics);
            }
            groupedTopics.add(shortTopicName);
        }
        return res;
    }

    public static Map<String, Set<String>> allTopicsForStreamSet(Set<String> streamSet) {
        return MapRTopicUtils.allTopicsForStreamSet(streamSet, AdminClient.create(new Properties()));
    }

    public static Map<String, Set<String>> allTopicsForStreamSet(Set<String> streamSet, AdminClient adminClient) {
        HashMap<String, Set<String>> res = new HashMap<String, Set<String>>();
        try {
            for (String streamName : streamSet) {
                res.put(streamName, adminClient.listTopics(streamName).names().get(60L, TimeUnit.SECONDS));
            }
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            throw new KafkaException(e);
        }
        finally {
            adminClient.close();
        }
        return res;
    }

    public static String findMapRHome() {
        String maprHome = System.getenv("MAPR_HOME");
        if (maprHome == null) {
            LOG.warn("Environment variable MAPR_HOME is null");
            maprHome = System.getProperty("mapr.home.dir");
            if (maprHome == null) {
                LOG.warn("System property mapr.home.dir is null");
                maprHome = IS_OS_WINDOWS ? "C:/opt/mapr" : "/opt/mapr";
                LOG.warn("Setting MapR home as {} by default", (Object)maprHome);
            }
        }
        return maprHome;
    }

    public static List<String> listClusterNames() {
        try {
            if (clusterNames == null) {
                clusterNames = Files.lines(Paths.get(MAPR_CLUSTERS_FILE, new String[0])).map(l -> l.split("\\s")[0]).collect(Collectors.toList());
            }
            return clusterNames;
        }
        catch (IOException e) {
            throw new KafkaException("Could not listClusterNames from " + MAPR_CLUSTERS_FILE, e);
        }
    }
}

