/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.security;

import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.thirdparty.protobuf.InvalidProtocolBufferException;
import org.apache.hadoop.thirdparty.protobuf.TextFormat;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.impl.pb.ApplicationAttemptIdPBImpl;
import org.apache.hadoop.yarn.proto.YarnSecurityTokenProtos;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class AMRMTokenIdentifier
extends TokenIdentifier {
    private static final Logger LOG = LoggerFactory.getLogger(AMRMTokenIdentifier.class);
    public static final Text KIND_NAME = new Text("YARN_AM_RM_TOKEN");
    private YarnSecurityTokenProtos.AMRMTokenIdentifierProto proto;

    public AMRMTokenIdentifier() {
    }

    public AMRMTokenIdentifier(ApplicationAttemptId appAttemptId, int masterKeyId) {
        YarnSecurityTokenProtos.AMRMTokenIdentifierProto.Builder builder = YarnSecurityTokenProtos.AMRMTokenIdentifierProto.newBuilder();
        if (appAttemptId != null) {
            builder.setAppAttemptId(((ApplicationAttemptIdPBImpl)appAttemptId).getProto());
        }
        builder.setKeyId(masterKeyId);
        this.proto = builder.build();
    }

    @InterfaceAudience.Private
    public ApplicationAttemptId getApplicationAttemptId() {
        if (!this.proto.hasAppAttemptId()) {
            return null;
        }
        return new ApplicationAttemptIdPBImpl(this.proto.getAppAttemptId());
    }

    public void write(DataOutput out) throws IOException {
        out.write(this.proto.toByteArray());
    }

    public void readFields(DataInput in) throws IOException {
        byte[] data = IOUtils.readFullyToByteArray((DataInput)in);
        try {
            this.proto = YarnSecurityTokenProtos.AMRMTokenIdentifierProto.parseFrom(data);
        }
        catch (InvalidProtocolBufferException e) {
            LOG.warn("Recovering old formatted token");
            this.readFieldsInOldFormat(new DataInputStream(new ByteArrayInputStream(data)));
        }
    }

    private void readFieldsInOldFormat(DataInputStream in) throws IOException {
        YarnSecurityTokenProtos.AMRMTokenIdentifierProto.Builder builder = YarnSecurityTokenProtos.AMRMTokenIdentifierProto.newBuilder();
        long clusterTimeStamp = in.readLong();
        int appId = in.readInt();
        int attemptId = in.readInt();
        ApplicationId applicationId = ApplicationId.newInstance(clusterTimeStamp, appId);
        ApplicationAttemptId appAttemptId = ApplicationAttemptId.newInstance(applicationId, attemptId);
        builder.setAppAttemptId(((ApplicationAttemptIdPBImpl)appAttemptId).getProto());
        builder.setKeyId(in.readInt());
        this.proto = builder.build();
    }

    public Text getKind() {
        return KIND_NAME;
    }

    public UserGroupInformation getUser() {
        String appAttemptId = null;
        if (this.proto.hasAppAttemptId()) {
            appAttemptId = new ApplicationAttemptIdPBImpl(this.proto.getAppAttemptId()).toString();
        }
        return UserGroupInformation.createRemoteUser(appAttemptId);
    }

    public int getKeyId() {
        return this.proto.getKeyId();
    }

    public YarnSecurityTokenProtos.AMRMTokenIdentifierProto getProto() {
        return this.proto;
    }

    public int hashCode() {
        return this.getProto().hashCode();
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other.getClass().isAssignableFrom(((Object)((Object)this)).getClass())) {
            return this.getProto().equals(((AMRMTokenIdentifier)((Object)((Object)((Object)this)).getClass().cast(other))).getProto());
        }
        return false;
    }

    public String toString() {
        return TextFormat.shortDebugString(this.getProto());
    }

    @InterfaceAudience.Private
    public static class Renewer
    extends Token.TrivialRenewer {
        protected Text getKind() {
            return KIND_NAME;
        }
    }
}

