/*
 * Decompiled with CFR 0.152.
 */
package org.sparkproject.jetty.websocket.common.extensions;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Calendar;
import java.util.concurrent.atomic.AtomicInteger;
import org.sparkproject.jetty.util.IO;
import org.sparkproject.jetty.util.StringUtil;
import org.sparkproject.jetty.util.log.Log;
import org.sparkproject.jetty.util.log.Logger;
import org.sparkproject.jetty.websocket.api.BatchMode;
import org.sparkproject.jetty.websocket.api.WebSocketPolicy;
import org.sparkproject.jetty.websocket.api.WriteCallback;
import org.sparkproject.jetty.websocket.api.extensions.ExtensionConfig;
import org.sparkproject.jetty.websocket.api.extensions.Frame;
import org.sparkproject.jetty.websocket.common.Generator;
import org.sparkproject.jetty.websocket.common.WebSocketFrame;
import org.sparkproject.jetty.websocket.common.extensions.AbstractExtension;

public class FrameCaptureExtension
extends AbstractExtension {
    private static final Logger LOG = Log.getLogger(FrameCaptureExtension.class);
    private static final int BUFSIZE = 32768;
    private Generator generator;
    private Path outputDir;
    private String prefix = "frame";
    private Path incomingFramesPath;
    private Path outgoingFramesPath;
    private AtomicInteger incomingCount = new AtomicInteger(0);
    private AtomicInteger outgoingCount = new AtomicInteger(0);
    private SeekableByteChannel incomingChannel;
    private SeekableByteChannel outgoingChannel;

    @Override
    public String getName() {
        return "@frame-capture";
    }

    @Override
    public void incomingFrame(Frame frame) {
        this.saveFrame(frame, false);
        try {
            this.nextIncomingFrame(frame);
        }
        catch (Throwable t2) {
            IO.close((Closeable)this.incomingChannel);
            this.incomingChannel = null;
            throw t2;
        }
    }

    @Override
    public void outgoingFrame(Frame frame, WriteCallback callback, BatchMode batchMode) {
        this.saveFrame(frame, true);
        try {
            this.nextOutgoingFrame(frame, callback, batchMode);
        }
        catch (Throwable t2) {
            IO.close((Closeable)this.outgoingChannel);
            this.outgoingChannel = null;
            throw t2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveFrame(Frame frame, boolean outgoing) {
        SeekableByteChannel channel;
        if (this.outputDir == null || this.generator == null) {
            return;
        }
        SeekableByteChannel seekableByteChannel = channel = outgoing ? this.outgoingChannel : this.incomingChannel;
        if (channel == null) {
            return;
        }
        ByteBuffer buf = this.getBufferPool().acquire(32768, false);
        try {
            WebSocketFrame f = WebSocketFrame.copy(frame);
            f.setMasked(false);
            this.generator.generateHeaderBytes(f, buf);
            channel.write(buf);
            if (frame.hasPayload()) {
                channel.write(frame.getPayload().slice());
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Saved {} frame #{}", new Object[]{outgoing ? "outgoing" : "incoming", outgoing ? this.outgoingCount.incrementAndGet() : this.incomingCount.incrementAndGet()});
            }
        }
        catch (IOException e) {
            LOG.warn("Unable to save frame: " + frame, (Throwable)e);
        }
        finally {
            this.getBufferPool().release(buf);
        }
    }

    @Override
    public void setConfig(ExtensionConfig config) {
        String cfgPrefix;
        super.setConfig(config);
        String cfgOutputDir = config.getParameter("output-dir", null);
        if (StringUtil.isNotBlank((String)cfgOutputDir)) {
            Path path = new File(cfgOutputDir).toPath();
            if (Files.isDirectory(path, new LinkOption[0]) && Files.exists(path, new LinkOption[0]) && Files.isWritable(path)) {
                this.outputDir = path;
            } else {
                LOG.warn("Unable to configure {}: not a valid output directory", new Object[]{path.toAbsolutePath().toString()});
            }
        }
        if (StringUtil.isNotBlank((String)(cfgPrefix = config.getParameter("prefix", "frame")))) {
            this.prefix = cfgPrefix;
        }
        if (this.outputDir != null) {
            try {
                Path dir = this.outputDir.toRealPath(new LinkOption[0]);
                String tstamp = String.format("%1$tY%1$tm%1$td-%1$tH%1$tM%1$tS", Calendar.getInstance());
                this.incomingFramesPath = dir.resolve(String.format("%s-%s-incoming.dat", this.prefix, tstamp));
                this.outgoingFramesPath = dir.resolve(String.format("%s-%s-outgoing.dat", this.prefix, tstamp));
                this.incomingChannel = Files.newByteChannel(this.incomingFramesPath, StandardOpenOption.CREATE, StandardOpenOption.WRITE);
                this.outgoingChannel = Files.newByteChannel(this.outgoingFramesPath, StandardOpenOption.CREATE, StandardOpenOption.WRITE);
                this.generator = new Generator(WebSocketPolicy.newServerPolicy(), this.getBufferPool(), false, true);
            }
            catch (IOException e) {
                LOG.warn("Unable to create capture file(s)", (Throwable)e);
            }
        }
    }
}

