/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kerby.kerberos.kerb.client.preauth.pkinit;

import java.io.IOException;
import java.math.BigInteger;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.crypto.interfaces.DHPublicKey;
import javax.crypto.spec.DHParameterSpec;
import org.apache.kerby.KOptions;
import org.apache.kerby.asn1.type.Asn1Integer;
import org.apache.kerby.asn1.type.Asn1ObjectIdentifier;
import org.apache.kerby.cms.type.CertificateChoices;
import org.apache.kerby.cms.type.CertificateSet;
import org.apache.kerby.cms.type.ContentInfo;
import org.apache.kerby.cms.type.SignedData;
import org.apache.kerby.kerberos.kerb.KrbCodec;
import org.apache.kerby.kerberos.kerb.KrbErrorCode;
import org.apache.kerby.kerberos.kerb.KrbException;
import org.apache.kerby.kerberos.kerb.client.KrbContext;
import org.apache.kerby.kerberos.kerb.client.PkinitOption;
import org.apache.kerby.kerberos.kerb.client.preauth.AbstractPreauthPlugin;
import org.apache.kerby.kerberos.kerb.client.preauth.pkinit.PkinitContext;
import org.apache.kerby.kerberos.kerb.client.preauth.pkinit.PkinitRequestContext;
import org.apache.kerby.kerberos.kerb.client.request.KdcRequest;
import org.apache.kerby.kerberos.kerb.common.CheckSumUtil;
import org.apache.kerby.kerberos.kerb.common.KrbUtil;
import org.apache.kerby.kerberos.kerb.crypto.dh.DhGroup;
import org.apache.kerby.kerberos.kerb.crypto.dh.DiffieHellmanClient;
import org.apache.kerby.kerberos.kerb.preauth.PaFlag;
import org.apache.kerby.kerberos.kerb.preauth.PaFlags;
import org.apache.kerby.kerberos.kerb.preauth.PluginRequestContext;
import org.apache.kerby.kerberos.kerb.preauth.pkinit.CertificateHelper;
import org.apache.kerby.kerberos.kerb.preauth.pkinit.CmsMessageType;
import org.apache.kerby.kerberos.kerb.preauth.pkinit.PkinitCrypto;
import org.apache.kerby.kerberos.kerb.preauth.pkinit.PkinitIdentity;
import org.apache.kerby.kerberos.kerb.preauth.pkinit.PkinitPlgCryptoContext;
import org.apache.kerby.kerberos.kerb.preauth.pkinit.PkinitPreauthMeta;
import org.apache.kerby.kerberos.kerb.type.KerberosTime;
import org.apache.kerby.kerberos.kerb.type.base.CheckSum;
import org.apache.kerby.kerberos.kerb.type.base.CheckSumType;
import org.apache.kerby.kerberos.kerb.type.base.EncryptionKey;
import org.apache.kerby.kerberos.kerb.type.base.EncryptionType;
import org.apache.kerby.kerberos.kerb.type.base.PrincipalName;
import org.apache.kerby.kerberos.kerb.type.pa.PaData;
import org.apache.kerby.kerberos.kerb.type.pa.PaDataEntry;
import org.apache.kerby.kerberos.kerb.type.pa.PaDataType;
import org.apache.kerby.kerberos.kerb.type.pa.pkinit.AuthPack;
import org.apache.kerby.kerberos.kerb.type.pa.pkinit.DhRepInfo;
import org.apache.kerby.kerberos.kerb.type.pa.pkinit.KdcDhKeyInfo;
import org.apache.kerby.kerberos.kerb.type.pa.pkinit.PaPkAsRep;
import org.apache.kerby.kerberos.kerb.type.pa.pkinit.PaPkAsReq;
import org.apache.kerby.kerberos.kerb.type.pa.pkinit.PkAuthenticator;
import org.apache.kerby.kerberos.kerb.type.pa.pkinit.TrustedCertifiers;
import org.apache.kerby.x509.type.AlgorithmIdentifier;
import org.apache.kerby.x509.type.Certificate;
import org.apache.kerby.x509.type.DhParameter;
import org.apache.kerby.x509.type.SubjectPublicKeyInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PkinitPreauth
extends AbstractPreauthPlugin {
    private static final Logger LOG = LoggerFactory.getLogger(PkinitPreauth.class);
    private PkinitContext pkinitContext;

    public PkinitPreauth() {
        super(new PkinitPreauthMeta());
    }

    @Override
    public void init(KrbContext context) {
        super.init(context);
        this.pkinitContext = new PkinitContext();
    }

    @Override
    public PluginRequestContext initRequestContext(KdcRequest kdcRequest) {
        PkinitRequestContext reqCtx = new PkinitRequestContext();
        reqCtx.updateRequestOpts(this.pkinitContext.getPluginOpts());
        return reqCtx;
    }

    @Override
    public void setPreauthOptions(KdcRequest kdcRequest, PluginRequestContext requestContext, KOptions options) {
        if (options.contains(PkinitOption.X509_IDENTITY)) {
            this.pkinitContext.getIdentityOpts().setIdentity(options.getStringOption(PkinitOption.X509_IDENTITY));
        }
        if (options.contains(PkinitOption.X509_ANCHORS)) {
            String anchorsString = options.getStringOption(PkinitOption.X509_ANCHORS);
            List<String> anchors = anchorsString == null ? kdcRequest.getContext().getConfig().getPkinitAnchors() : Arrays.asList(anchorsString);
            this.pkinitContext.getIdentityOpts().getAnchors().addAll(anchors);
        }
        if (options.contains(PkinitOption.USING_RSA)) {
            this.pkinitContext.getPluginOpts().setUsingRsa(options.getBooleanOption(PkinitOption.USING_RSA, true));
        }
    }

    @Override
    public void prepareQuestions(KdcRequest kdcRequest, PluginRequestContext requestContext) {
        PkinitRequestContext reqCtx = (PkinitRequestContext)requestContext;
        if (!reqCtx.isIdentityInitialized()) {
            PkinitIdentity.initialize(reqCtx.getIdentityOpts(), kdcRequest.getClientPrincipal());
            reqCtx.setIdentityInitialized(true);
        }
    }

    @Override
    public void tryFirst(KdcRequest kdcRequest, PluginRequestContext requestContext, PaData outPadata) throws KrbException {
        int nonce = kdcRequest.getChosenNonce();
        long now = System.currentTimeMillis();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date(now));
        int cusec = calendar.get(13);
        KerberosTime ctime = new KerberosTime(now);
        CheckSum checkSum = null;
        try {
            checkSum = CheckSumUtil.makeCheckSum(CheckSumType.NIST_SHA, KrbCodec.encode(kdcRequest.getKdcReq().getReqBody()));
        }
        catch (KrbException e) {
            throw new KrbException("Fail to encode checksum.", (Throwable)e);
        }
        PaPkAsReq paPkAsReq = this.makePaPkAsReq(kdcRequest, (PkinitRequestContext)requestContext, cusec, ctime, nonce, checkSum);
        outPadata.addElement(this.makeEntry(paPkAsReq));
    }

    @Override
    public boolean process(KdcRequest kdcRequest, PluginRequestContext requestContext, PaDataEntry inPadata, PaData outPadata) throws KrbException {
        PkinitRequestContext reqCtx = (PkinitRequestContext)requestContext;
        if (inPadata == null) {
            return false;
        }
        boolean processingRequest = false;
        switch (inPadata.getPaDataType()) {
            case PK_AS_REQ: {
                processingRequest = true;
                break;
            }
        }
        if (processingRequest) {
            this.generateRequest(reqCtx, kdcRequest, outPadata);
            return true;
        }
        EncryptionType encType = kdcRequest.getEncType();
        this.processReply(kdcRequest, reqCtx, inPadata, encType);
        return true;
    }

    private void generateRequest(PkinitRequestContext reqCtx, KdcRequest kdcRequest, PaData outPadata) {
    }

    private PaPkAsReq makePaPkAsReq(KdcRequest kdcRequest, PkinitRequestContext reqCtx, int cusec, KerberosTime ctime, int nonce, CheckSum checkSum) throws KrbException {
        LOG.info("Making the PK_AS_REQ.");
        PaPkAsReq paPkAsReq = new PaPkAsReq();
        AuthPack authPack = new AuthPack();
        PkAuthenticator pkAuthen = new PkAuthenticator();
        boolean usingRsa = this.pkinitContext.getPluginOpts().isUsingRsa();
        reqCtx.setPaType(PaDataType.PK_AS_REQ);
        pkAuthen.setCusec(cusec);
        pkAuthen.setCtime(ctime);
        pkAuthen.setNonce(nonce);
        pkAuthen.setPaChecksum(checkSum.getChecksum());
        authPack.setPkAuthenticator(pkAuthen);
        authPack.setsupportedCmsTypes(this.pkinitContext.getPluginOpts().createSupportedCMSTypes());
        if (!usingRsa) {
            LOG.info("DH key transport algorithm.");
            String content = "0x06 07 2A 86 48 ce 3e 02 01";
            Asn1ObjectIdentifier dhOid = PkinitCrypto.createOid(content);
            AlgorithmIdentifier dhAlg = new AlgorithmIdentifier();
            dhAlg.setAlgorithm((String)dhOid.getValue());
            DiffieHellmanClient client = new DiffieHellmanClient();
            DHPublicKey clientPubKey = null;
            try {
                clientPubKey = client.init(DhGroup.MODP_GROUP2);
            }
            catch (Exception e) {
                LOG.error("DiffieHellmanClient init with failure. " + e);
            }
            reqCtx.setDhClient(client);
            DHParameterSpec type = null;
            try {
                type = clientPubKey.getParams();
            }
            catch (Exception e) {
                LOG.error("Fail to get params from client public key. " + e);
            }
            BigInteger q = type.getP().shiftRight(1);
            DhParameter dhParameter = new DhParameter();
            dhParameter.setP(type.getP());
            dhParameter.setG(type.getG());
            dhParameter.setQ(q);
            dhAlg.setParameters(dhParameter);
            SubjectPublicKeyInfo pubInfo = new SubjectPublicKeyInfo();
            pubInfo.setAlgorithm(dhAlg);
            Asn1Integer publickey = new Asn1Integer(clientPubKey.getY());
            pubInfo.setSubjectPubKey(KrbCodec.encode(publickey));
            authPack.setClientPublicValue(pubInfo);
            byte[] signedAuthPack = this.signAuthPack(authPack);
            paPkAsReq.setSignedAuthPack(signedAuthPack);
        } else {
            LOG.info("RSA key transport algorithm");
        }
        TrustedCertifiers trustedCertifiers = this.pkinitContext.getPluginOpts().createTrustedCertifiers();
        paPkAsReq.setTrustedCertifiers(trustedCertifiers);
        return paPkAsReq;
    }

    private byte[] signAuthPack(AuthPack authPack) throws KrbException {
        String oid = PkinitPlgCryptoContext.getIdPkinitAuthDataOID();
        byte[] signedDataBytes = PkinitCrypto.eContentInfoCreate(KrbCodec.encode(authPack), oid);
        return signedDataBytes;
    }

    private void processReply(KdcRequest kdcRequest, PkinitRequestContext reqCtx, PaDataEntry paEntry, EncryptionType encType) throws KrbException {
        if (paEntry.getPaDataType() == PaDataType.PK_AS_REP) {
            LOG.info("processing PK_AS_REP");
            PaPkAsRep paPkAsRep = KrbCodec.decode(paEntry.getPaDataValue(), PaPkAsRep.class);
            DhRepInfo dhRepInfo = paPkAsRep.getDHRepInfo();
            byte[] dhSignedData = dhRepInfo.getDHSignedData();
            ContentInfo contentInfo = new ContentInfo();
            try {
                contentInfo.decode(dhSignedData);
            }
            catch (IOException e) {
                LOG.error("Fail to decode dhSignedData. " + e);
            }
            SignedData signedData = contentInfo.getContentAs(SignedData.class);
            PkinitCrypto.verifyCmsSignedData(CmsMessageType.CMS_SIGN_SERVER, signedData);
            if (kdcRequest.getContext().getConfig().getPkinitAnchors().isEmpty()) {
                LOG.error("No PKINIT anchors specified");
                throw new KrbException("No PKINIT anchors specified");
            }
            String anchorFileName = kdcRequest.getContext().getConfig().getPkinitAnchors().get(0);
            X509Certificate x509Certificate = null;
            try {
                List<java.security.cert.Certificate> certs = CertificateHelper.loadCerts(anchorFileName);
                if (certs != null && !certs.isEmpty()) {
                    x509Certificate = (X509Certificate)certs.iterator().next();
                }
            }
            catch (KrbException e) {
                LOG.error("Fail to load certs from archor file. " + e);
            }
            if (x509Certificate == null) {
                LOG.error("Failed to load PKINIT anchor");
                throw new KrbException("Failed to load PKINIT anchor");
            }
            CertificateSet certificateSet = signedData.getCertificates();
            if (certificateSet == null || certificateSet.getElements().isEmpty()) {
                throw new KrbException("No PKINIT Certs");
            }
            ArrayList<Certificate> certificates = new ArrayList<Certificate>();
            List certificateChoicesList = certificateSet.getElements();
            for (CertificateChoices certificateChoices : certificateChoicesList) {
                certificates.add(certificateChoices.getCertificate());
            }
            try {
                PkinitCrypto.validateChain(certificates, x509Certificate);
            }
            catch (Exception e) {
                throw new KrbException(KrbErrorCode.KDC_ERR_INVALID_CERTIFICATE, (Throwable)e);
            }
            PrincipalName kdcPrincipal = KrbUtil.makeTgsPrincipal(kdcRequest.getContext().getConfig().getKdcRealm());
            boolean validSan = PkinitCrypto.verifyKdcSan(kdcRequest.getContext().getConfig().getPkinitKdcHostName(), kdcPrincipal, certificates);
            if (!validSan) {
                LOG.error("Did not find an acceptable SAN in KDC certificate");
            }
            LOG.info("skipping EKU check");
            LOG.info("as_rep: DH key transport algorithm");
            KdcDhKeyInfo kdcDhKeyInfo = new KdcDhKeyInfo();
            try {
                kdcDhKeyInfo.decode(signedData.getEncapContentInfo().getContent());
            }
            catch (IOException e) {
                String errMessage = "failed to decode KdcDhKeyInfo " + e.getMessage();
                LOG.error(errMessage);
                throw new KrbException(errMessage);
            }
            byte[] subjectPublicKey = (byte[])kdcDhKeyInfo.getSubjectPublicKey().getValue();
            Asn1Integer clientPubKey = KrbCodec.decode(subjectPublicKey, Asn1Integer.class);
            BigInteger y = (BigInteger)clientPubKey.getValue();
            DiffieHellmanClient client = reqCtx.getDhClient();
            BigInteger p = client.getDhParam().getP();
            BigInteger g2 = client.getDhParam().getG();
            DHPublicKey dhPublicKey = PkinitCrypto.createDHPublicKey(p, g2, y);
            EncryptionKey secretKey = null;
            try {
                client.doPhase(dhPublicKey.getEncoded());
                secretKey = client.generateKey(null, null, encType);
            }
            catch (Exception e) {
                LOG.error("DiffieHellmanClient do parse failed. " + e);
            }
            if (secretKey == null) {
                throw new KrbException("Fail to create client key.");
            }
            kdcRequest.setAsKey(secretKey);
        }
    }

    @Override
    public boolean tryAgain(KdcRequest kdcRequest, PluginRequestContext requestContext, PaDataType preauthType, PaData errPadata, PaData outPadata) {
        PkinitRequestContext reqCtx = (PkinitRequestContext)requestContext;
        if (reqCtx.getPaType() != preauthType && errPadata == null) {
            return false;
        }
        boolean doAgain = false;
        for (PaDataEntry pde : errPadata.getElements()) {
            System.out.println(pde.getPaDataType());
        }
        if (doAgain) {
            this.generateRequest(reqCtx, kdcRequest, outPadata);
        }
        return false;
    }

    @Override
    public PaFlags getFlags(PaDataType paType) {
        PaFlags paFlags = new PaFlags(0);
        paFlags.setFlag(PaFlag.PA_REAL);
        return paFlags;
    }

    private PaDataEntry makeEntry(PaPkAsReq paPkAsReq) throws KrbException {
        PaDataEntry paDataEntry = new PaDataEntry();
        paDataEntry.setPaDataType(PaDataType.PK_AS_REQ);
        paDataEntry.setPaDataValue(KrbCodec.encode(paPkAsReq));
        return paDataEntry;
    }
}

