/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kerby.kerberos.kerb.admin.kadmin.remote;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.security.auth.Subject;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslException;
import org.apache.kerby.KOptions;
import org.apache.kerby.kerberos.kerb.KrbException;
import org.apache.kerby.kerberos.kerb.admin.kadmin.Kadmin;
import org.apache.kerby.kerberos.kerb.admin.kadmin.local.AdminHelper;
import org.apache.kerby.kerberos.kerb.admin.kadmin.remote.AdminHandler;
import org.apache.kerby.kerberos.kerb.admin.kadmin.remote.AdminUtil;
import org.apache.kerby.kerberos.kerb.admin.kadmin.remote.NegotiationStatus;
import org.apache.kerby.kerberos.kerb.admin.kadmin.remote.impl.DefaultAdminHandler;
import org.apache.kerby.kerberos.kerb.admin.kadmin.remote.impl.InternalAdminClient;
import org.apache.kerby.kerberos.kerb.admin.kadmin.remote.request.AddPrincipalRequest;
import org.apache.kerby.kerberos.kerb.admin.kadmin.remote.request.ChangePasswordRequest;
import org.apache.kerby.kerberos.kerb.admin.kadmin.remote.request.DeletePrincipalRequest;
import org.apache.kerby.kerberos.kerb.admin.kadmin.remote.request.ExportKeytabRequest;
import org.apache.kerby.kerberos.kerb.admin.kadmin.remote.request.GetPrincipalRequest;
import org.apache.kerby.kerberos.kerb.admin.kadmin.remote.request.GetprincsRequest;
import org.apache.kerby.kerberos.kerb.admin.kadmin.remote.request.RenamePrincipalRequest;
import org.apache.kerby.kerberos.kerb.admin.message.KadminCode;
import org.apache.kerby.kerberos.kerb.common.KrbUtil;
import org.apache.kerby.kerberos.kerb.keytab.Keytab;
import org.apache.kerby.kerberos.kerb.request.KrbIdentity;
import org.apache.kerby.kerberos.kerb.transport.KrbNetwork;
import org.apache.kerby.kerberos.kerb.transport.KrbTransport;
import org.apache.kerby.kerberos.kerb.transport.TransportPair;
import org.apache.kerby.kerberos.kerb.type.base.PrincipalName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnio.sasl.SaslUtils;
import org.xnio.sasl.SaslWrapper;

public class RemoteKadminImpl
implements Kadmin {
    private static final Logger LOG = LoggerFactory.getLogger(RemoteKadminImpl.class);
    private static final String MECHANISM = "GSSAPI";
    private static final byte[] EMPTY_BYTES = new byte[0];
    private InternalAdminClient innerClient;
    private KrbTransport transport;
    private SaslClient saslClient = null;
    private SaslWrapper saslClientWrapper = null;
    private final Subject subject;

    public RemoteKadminImpl(InternalAdminClient innerClient, Subject subject) throws KrbException {
        this.innerClient = innerClient;
        this.subject = subject;
        TransportPair tpair = null;
        try {
            tpair = AdminUtil.getTransportPair(innerClient.getSetting());
        }
        catch (KrbException e) {
            LOG.error("Fail to get transport pair. " + e);
        }
        KrbNetwork network = new KrbNetwork();
        network.setSocketTimeout(innerClient.getSetting().getTimeout());
        try {
            this.transport = network.connect(tpair);
        }
        catch (IOException e) {
            throw new KrbException("Failed to create transport", (Throwable)e);
        }
        try {
            this.doSaslHandshake();
        }
        catch (Exception e) {
            throw new KrbException("Failed to do SASL handshake. " + e);
        }
    }

    public InternalAdminClient getInnerClient() {
        return this.innerClient;
    }

    @Override
    public String getKadminPrincipal() {
        return KrbUtil.makeKadminPrincipal(this.innerClient.getSetting().getKdcRealm()).getName();
    }

    @Override
    public void addPrincipal(String principal) throws KrbException {
        AddPrincipalRequest adRequest = new AddPrincipalRequest(principal);
        adRequest.setTransport(this.transport);
        DefaultAdminHandler adminHandler = new DefaultAdminHandler();
        ((AdminHandler)adminHandler).handleRequest(adRequest, this.saslClientWrapper);
    }

    @Override
    public void addPrincipal(String principal, KOptions kOptions) throws KrbException {
        AddPrincipalRequest adRequest = new AddPrincipalRequest(principal, kOptions);
        adRequest.setTransport(this.transport);
        DefaultAdminHandler adminHandler = new DefaultAdminHandler();
        ((AdminHandler)adminHandler).handleRequest(adRequest, this.saslClientWrapper);
    }

    @Override
    public void addPrincipal(String principal, String password) throws KrbException {
        AddPrincipalRequest addPrincipalRequest = new AddPrincipalRequest(principal, password);
        addPrincipalRequest.setTransport(this.transport);
        DefaultAdminHandler adminHandler = new DefaultAdminHandler();
        ((AdminHandler)adminHandler).handleRequest(addPrincipalRequest, this.saslClientWrapper);
    }

    @Override
    public void addPrincipal(String principal, String password, KOptions kOptions) throws KrbException {
    }

    @Override
    public void exportKeytab(File keytabFile, String principal) throws KrbException {
        this.exportKeytab(keytabFile, Collections.singletonList(principal));
    }

    @Override
    public void exportKeytab(File keytabFile, List<String> principals) throws KrbException {
        String principalsStr = this.listToString(principals);
        ExportKeytabRequest exportKeytabRequest = new ExportKeytabRequest(principalsStr);
        exportKeytabRequest.setTransport(this.transport);
        DefaultAdminHandler adminHandler = new DefaultAdminHandler();
        byte[] keytabFileBytes = ((AdminHandler)adminHandler).handleRequestForBytes(exportKeytabRequest, this.saslClientWrapper);
        Keytab keytab = AdminHelper.loadKeytab(new ByteArrayInputStream(keytabFileBytes));
        Keytab outputKeytab = AdminHelper.createOrLoadKeytab(keytabFile);
        for (PrincipalName principal : keytab.getPrincipals()) {
            outputKeytab.addKeytabEntries(keytab.getKeytabEntries(principal));
        }
        AdminHelper.storeKeytab(outputKeytab, keytabFile);
    }

    @Override
    public void exportKeytab(File keytabFile) throws KrbException {
    }

    @Override
    public void removeKeytabEntriesOf(File keytabFile, String principal) throws KrbException {
    }

    @Override
    public void removeKeytabEntriesOf(File keytabFile, String principal, int kvno) throws KrbException {
    }

    @Override
    public void removeOldKeytabEntriesOf(File keytabFile, String principal) throws KrbException {
    }

    @Override
    public void deletePrincipal(String principal) throws KrbException {
        DeletePrincipalRequest deletePrincipalRequest = new DeletePrincipalRequest(principal);
        deletePrincipalRequest.setTransport(this.transport);
        DefaultAdminHandler adminHandler = new DefaultAdminHandler();
        ((AdminHandler)adminHandler).handleRequest(deletePrincipalRequest, this.saslClientWrapper);
    }

    @Override
    public void modifyPrincipal(String principal, KOptions kOptions) throws KrbException {
    }

    @Override
    public void renamePrincipal(String oldPrincipalName, String newPrincipalName) throws KrbException {
        RenamePrincipalRequest renamePrincipalRequest = new RenamePrincipalRequest(oldPrincipalName, newPrincipalName);
        renamePrincipalRequest.setTransport(this.transport);
        DefaultAdminHandler adminHandler = new DefaultAdminHandler();
        ((AdminHandler)adminHandler).handleRequest(renamePrincipalRequest, this.saslClientWrapper);
    }

    @Override
    public List<String> getPrincipals() throws KrbException {
        GetprincsRequest getPrincsRequest = new GetprincsRequest();
        getPrincsRequest.setTransport(this.transport);
        DefaultAdminHandler adminHandler = new DefaultAdminHandler();
        return ((AdminHandler)adminHandler).handleRequestForList(getPrincsRequest, this.saslClientWrapper);
    }

    @Override
    public List<String> getPrincipals(String globString) throws KrbException {
        GetprincsRequest getPrincsRequest = new GetprincsRequest(globString);
        getPrincsRequest.setTransport(this.transport);
        DefaultAdminHandler adminHandler = new DefaultAdminHandler();
        return ((AdminHandler)adminHandler).handleRequestForList(getPrincsRequest, this.saslClientWrapper);
    }

    @Override
    public void changePassword(String principal, String newPassword) throws KrbException {
        ChangePasswordRequest changePwdRequest = new ChangePasswordRequest(principal, newPassword);
        changePwdRequest.setTransport(this.transport);
        DefaultAdminHandler adminHandler = new DefaultAdminHandler();
        ((AdminHandler)adminHandler).handleRequest(changePwdRequest, this.saslClientWrapper);
    }

    @Override
    public void updateKeys(String principal) throws KrbException {
    }

    @Override
    public void release() throws KrbException {
    }

    public KrbIdentity getPrincipal(String principalName) throws KrbException {
        GetPrincipalRequest getPrincipalRequest = new GetPrincipalRequest(principalName);
        getPrincipalRequest.setTransport(this.transport);
        DefaultAdminHandler adminHandler = new DefaultAdminHandler();
        return ((AdminHandler)adminHandler).handleRequestForIdentity(getPrincipalRequest, this.saslClientWrapper);
    }

    private String listToString(List<String> list) {
        if (list.isEmpty()) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        for (String l : list) {
            result.append(l).append(" ");
        }
        return result.toString();
    }

    private void doSaslHandshake() throws Exception {
        Subject.doAs(this.subject, () -> {
            boolean success = false;
            try {
                byte[] response;
                HashMap<String, String> saslProps = new HashMap<String, String>();
                saslProps.put("javax.security.sasl.qop", "auth-conf");
                saslProps.put("javax.security.sasl.server.authentication", "true");
                try {
                    String protocol = this.innerClient.getSetting().getAdminConfig().getProtocol();
                    String serverName = this.innerClient.getSetting().getAdminConfig().getServerName();
                    this.saslClient = Sasl.createSaslClient(new String[]{MECHANISM}, null, protocol, serverName, saslProps, null);
                    this.saslClientWrapper = SaslWrapper.create((SaslClient)this.saslClient);
                }
                catch (SaslException e) {
                    throw new KrbException("Fail to create SASL client. " + e);
                }
                if (this.saslClient == null) {
                    throw new KrbException("Unable to find client implementation for: GSSAPI");
                }
                try {
                    response = this.saslClient.hasInitialResponse() ? this.saslClient.evaluateChallenge(EMPTY_BYTES) : EMPTY_BYTES;
                }
                catch (SaslException e) {
                    throw new KrbException("Sasl client evaluate challenge failed." + e);
                }
                this.sendSaslMessage(response);
                ByteBuffer message = this.transport.receiveMessage();
                while (!this.saslClient.isComplete()) {
                    int ssComplete = message.getInt();
                    if (ssComplete == NegotiationStatus.SUCCESS.getValue()) {
                        LOG.info("Sasl Server completed");
                    }
                    this.sendSaslMessage(SaslUtils.evaluateChallenge((SaslClient)this.saslClient, (ByteBuffer)message));
                    if (this.saslClient.isComplete()) continue;
                    message = this.transport.receiveMessage();
                }
                success = true;
            }
            finally {
                if (!success) {
                    this.transport.release();
                }
            }
            return null;
        });
    }

    private void sendSaslMessage(byte[] response) {
        NegotiationStatus status = this.saslClient.isComplete() ? NegotiationStatus.SUCCESS : NegotiationStatus.CONTINUE;
        ByteBuffer buffer = KadminCode.encodeSaslMessage(response, status);
        try {
            this.transport.sendMessage(buffer);
        }
        catch (IOException e) {
            LOG.error("Failed to send message to server. ", (Throwable)e);
        }
    }
}

