/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.conf;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Collection;
import org.apache.hadoop.HadoopIllegalArgumentException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.yarn.conf.CustomRMAddressFinder;
import org.apache.hadoop.yarn.conf.RMAddressFinderLoader;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class HAUtil {
    private static Logger LOG = LoggerFactory.getLogger(HAUtil.class);
    @VisibleForTesting
    public static final String BAD_CONFIG_MESSAGE_PREFIX = "Invalid configuration! ";
    @VisibleForTesting
    static final String NO_LEADER_ELECTION_MESSAGE = "The yarn.resourcemanager.ha.automatic-failover.embedded and yarn.resourcemanager.ha.curator-leader-elector.enabled properties are both false. One of these two properties must be true when yarn.resourcemanager.ha.automatic-failover.enabled is true";

    private HAUtil() {
    }

    private static void throwBadConfigurationException(String msg) {
        throw new YarnRuntimeException(BAD_CONFIG_MESSAGE_PREFIX + msg);
    }

    public static boolean isFederationEnabled(Configuration conf) {
        return conf.getBoolean("yarn.federation.enabled", false);
    }

    public static boolean isFederationFailoverEnabled(Configuration conf) {
        return conf.getBoolean("yarn.federation.failover.enabled", true);
    }

    public static boolean isHAEnabled(Configuration conf) {
        return conf.getBoolean("yarn.resourcemanager.ha.enabled", false);
    }

    public static boolean isCustomRMHAEnabled(Configuration conf) {
        return conf.getBoolean("yarn.resourcemanager.ha.custom-ha-enabled", false);
    }

    public static String getCurrentRMAddress(Configuration conf, String address, String defaultAddr, int defaultPort) {
        CustomRMAddressFinder finder = RMAddressFinderLoader.getInstance().getCustomRMAddressFinder(conf);
        if (finder != null) {
            return finder.getRMAddress(conf, address, defaultAddr, defaultPort);
        }
        return defaultAddr;
    }

    public static boolean isAutomaticFailoverEnabled(Configuration conf) {
        return conf.getBoolean("yarn.resourcemanager.ha.automatic-failover.enabled", true);
    }

    public static boolean isAutomaticFailoverEnabledAndEmbedded(Configuration conf) {
        return HAUtil.isAutomaticFailoverEnabled(conf) && HAUtil.isAutomaticFailoverEmbedded(conf);
    }

    public static boolean isAutomaticFailoverEmbedded(Configuration conf) {
        return conf.getBoolean("yarn.resourcemanager.ha.automatic-failover.embedded", true);
    }

    public static void verifyAndSetConfiguration(Configuration conf) throws YarnRuntimeException {
        HAUtil.verifyAndSetRMHAIdsList(conf);
        HAUtil.verifyAndSetCurrentRMHAId(conf);
        HAUtil.verifyLeaderElection(conf);
        HAUtil.verifyAndSetAllServiceAddresses(conf);
    }

    private static void verifyAndSetRMHAIdsList(Configuration conf) {
        Collection ids = conf.getTrimmedStringCollection("yarn.resourcemanager.ha.rm-ids");
        if (ids.size() < 2) {
            HAUtil.throwBadConfigurationException(HAUtil.getInvalidValueMessage("yarn.resourcemanager.ha.rm-ids", conf.get("yarn.resourcemanager.ha.rm-ids") + "\nHA mode requires atleast two RMs"));
        }
        StringBuilder setValue = new StringBuilder();
        for (String id : ids) {
            for (String prefix : YarnConfiguration.getServiceAddressConfKeys(conf)) {
                HAUtil.checkAndSetRMRPCAddress(prefix, id, conf);
            }
            setValue.append(id).append(",");
        }
        conf.set("yarn.resourcemanager.ha.rm-ids", setValue.substring(0, setValue.length() - 1));
    }

    private static void verifyAndSetCurrentRMHAId(Configuration conf) {
        String rmId = HAUtil.getRMHAId(conf);
        if (rmId == null) {
            StringBuilder msg = new StringBuilder();
            msg.append("Can not find valid RM_HA_ID. None of ");
            for (String id : conf.getTrimmedStringCollection("yarn.resourcemanager.ha.rm-ids")) {
                msg.append(HAUtil.addSuffix("yarn.resourcemanager.address", id)).append(" ");
            }
            msg.append(" are matching the local address OR yarn.resourcemanager.ha.id is not specified in HA Configuration");
            HAUtil.throwBadConfigurationException(msg.toString());
        } else {
            Collection<String> ids = HAUtil.getRMHAIds(conf);
            if (!ids.contains(rmId)) {
                HAUtil.throwBadConfigurationException(HAUtil.getRMHAIdNeedToBeIncludedMessage(ids.toString(), rmId));
            }
        }
        conf.set("yarn.resourcemanager.ha.id", rmId);
    }

    private static void verifyLeaderElection(Configuration conf) {
        if (HAUtil.isAutomaticFailoverEnabled(conf) && !conf.getBoolean("yarn.resourcemanager.ha.curator-leader-elector.enabled", false) && !HAUtil.isAutomaticFailoverEmbedded(conf)) {
            HAUtil.throwBadConfigurationException(NO_LEADER_ELECTION_MESSAGE);
        }
    }

    private static void verifyAndSetConfValue(String prefix, Configuration conf) {
        String confKey = null;
        String confValue = null;
        try {
            confKey = HAUtil.getConfKeyForRMInstance(prefix, conf);
            confValue = HAUtil.getConfValueForRMInstance(prefix, conf);
            conf.set(prefix, confValue);
        }
        catch (YarnRuntimeException yre) {
            throw yre;
        }
        catch (IllegalArgumentException iae) {
            String errmsg = confKey == null ? HAUtil.getInvalidValueMessage("yarn.resourcemanager.ha.id", HAUtil.getRMHAId(conf)) : HAUtil.getNeedToSetValueMessage(confKey);
            HAUtil.throwBadConfigurationException(errmsg);
        }
    }

    public static void verifyAndSetAllServiceAddresses(Configuration conf) {
        for (String confKey : YarnConfiguration.getServiceAddressConfKeys(conf)) {
            HAUtil.verifyAndSetConfValue(confKey, conf);
        }
    }

    public static Collection<String> getRMHAIds(Configuration conf) {
        return conf.getStringCollection("yarn.resourcemanager.ha.rm-ids");
    }

    public static String getRMHAId(Configuration conf) {
        int found = 0;
        String currentRMId = conf.getTrimmed("yarn.resourcemanager.ha.id");
        if (currentRMId == null) {
            for (String rmId : HAUtil.getRMHAIds(conf)) {
                InetSocketAddress s2;
                String key = HAUtil.addSuffix("yarn.resourcemanager.address", rmId);
                String addr = conf.get(key);
                if (addr == null) continue;
                try {
                    s2 = NetUtils.createSocketAddr((String)addr);
                }
                catch (Exception e) {
                    LOG.warn("Exception in creating socket address " + addr, (Throwable)e);
                    continue;
                }
                if (s2.isUnresolved() || !NetUtils.isLocalAddress((InetAddress)s2.getAddress())) continue;
                currentRMId = rmId.trim();
                ++found;
            }
        }
        if (found > 1) {
            String msg = "The HA Configuration has multiple addresses that match local node's address.";
            throw new HadoopIllegalArgumentException(msg);
        }
        return currentRMId;
    }

    @VisibleForTesting
    static String getNeedToSetValueMessage(String confKey) {
        return confKey + " needs to be set in an HA configuration.";
    }

    @VisibleForTesting
    static String getInvalidValueMessage(String confKey, String invalidValue) {
        return "Invalid value of " + confKey + ". Current value is " + invalidValue;
    }

    @VisibleForTesting
    static String getRMHAIdNeedToBeIncludedMessage(String ids, String rmId) {
        return "yarn.resourcemanager.ha.rm-ids(" + ids + ") need to contain " + "yarn.resourcemanager.ha.id" + "(" + rmId + ") in an HA configuration.";
    }

    @VisibleForTesting
    static String getRMHAIdsWarningMessage(String ids) {
        return "Resource Manager HA is enabled, but yarn.resourcemanager.ha.rm-ids has only one id(" + ids.toString() + ")";
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    static String getConfKeyForRMInstance(String prefix, Configuration conf) {
        if (!YarnConfiguration.getServiceAddressConfKeys(conf).contains(prefix)) {
            return prefix;
        }
        String RMId = HAUtil.getRMHAId(conf);
        HAUtil.checkAndSetRMRPCAddress(prefix, RMId, conf);
        return HAUtil.addSuffix(prefix, RMId);
    }

    public static String getConfValueForRMInstance(String prefix, Configuration conf) {
        String confKey = HAUtil.getConfKeyForRMInstance(prefix, conf);
        String retVal = conf.getTrimmed(confKey);
        if (LOG.isTraceEnabled()) {
            LOG.trace("getConfValueForRMInstance: prefix = {}; confKey being looked up = {}; value being set to = {}", new Object[]{prefix, confKey, retVal});
        }
        return retVal;
    }

    public static String getConfValueForRMInstance(String prefix, String defaultValue, Configuration conf) {
        String value = HAUtil.getConfValueForRMInstance(prefix, conf);
        return value == null ? defaultValue : value;
    }

    public static String addSuffix(String key, String suffix) {
        if (suffix == null || suffix.isEmpty()) {
            return key;
        }
        if (suffix.startsWith(".")) {
            throw new IllegalArgumentException("suffix '" + suffix + "' should not already have '.' prepended.");
        }
        return key + "." + suffix;
    }

    private static void checkAndSetRMRPCAddress(String prefix, String RMId, Configuration conf) {
        String rpcAddressConfKey = null;
        try {
            rpcAddressConfKey = HAUtil.addSuffix(prefix, RMId);
            if (conf.getTrimmed(rpcAddressConfKey) == null) {
                String hostNameConfKey = HAUtil.addSuffix("yarn.resourcemanager.hostname", RMId);
                String confVal = conf.getTrimmed(hostNameConfKey);
                if (confVal == null) {
                    HAUtil.throwBadConfigurationException(HAUtil.getNeedToSetValueMessage(hostNameConfKey + " or " + HAUtil.addSuffix(prefix, RMId)));
                } else {
                    conf.set(HAUtil.addSuffix(prefix, RMId), confVal + ":" + YarnConfiguration.getRMDefaultPortNumber(prefix, conf));
                }
            }
        }
        catch (IllegalArgumentException iae) {
            String errmsg = iae.getMessage();
            if (rpcAddressConfKey == null) {
                errmsg = HAUtil.getInvalidValueMessage("yarn.resourcemanager.ha.id", RMId);
            }
            HAUtil.throwBadConfigurationException(errmsg);
        }
    }
}

