/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.client.cli;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.MissingArgumentException;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.UnrecognizedOptionException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.thirdparty.com.google.common.base.Preconditions;
import org.apache.hadoop.thirdparty.com.google.common.collect.Lists;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.hadoop.yarn.api.ApplicationClientProtocol;
import org.apache.hadoop.yarn.api.protocolrecords.GetAttributesToNodesRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetAttributesToNodesResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetClusterNodeAttributesRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetClusterNodeAttributesResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetNodesToAttributesRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetNodesToAttributesResponse;
import org.apache.hadoop.yarn.api.records.NodeAttribute;
import org.apache.hadoop.yarn.api.records.NodeAttributeInfo;
import org.apache.hadoop.yarn.api.records.NodeAttributeKey;
import org.apache.hadoop.yarn.api.records.NodeAttributeType;
import org.apache.hadoop.yarn.client.ClientRMProxy;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.api.ResourceManagerAdministrationProtocol;
import org.apache.hadoop.yarn.server.api.protocolrecords.AttributeMappingOperationType;
import org.apache.hadoop.yarn.server.api.protocolrecords.NodeToAttributes;
import org.apache.hadoop.yarn.server.api.protocolrecords.NodesToAttributesMappingRequest;

public class NodeAttributesCLI
extends Configured
implements Tool {
    protected static final String INVALID_MAPPING_ERR_MSG = "Invalid Node to attribute mapping : ";
    protected static final String USAGE_YARN_NODE_ATTRIBUTES = "Usage: yarn nodeattributes ";
    protected static final String MISSING_ARGUMENT = "Missing argument for command";
    protected static final String NO_MAPPING_ERR_MSG = "No node-to-attributes mappings are specified";
    private static final String DEFAULT_SEPARATOR = System.lineSeparator();
    public static final String INVALID_COMMAND_USAGE = "Invalid Command Usage : ";
    private PrintStream errOut = System.err;

    protected void setErrOut(PrintStream errOut) {
        this.errOut = errOut;
    }

    protected AdminCommandHandler getAdminCommandHandler() {
        return new AdminCommandHandler();
    }

    protected ClientCommandHandler getClientCommandHandler() {
        return new ClientCommandHandler();
    }

    void printUsage(String cmd, boolean desc, CommandHandler ... handlers) throws UnsupportedEncodingException {
        StringBuilder usageBuilder = new StringBuilder();
        usageBuilder.append(USAGE_YARN_NODE_ATTRIBUTES);
        boolean satisfied = false;
        for (CommandHandler cmdHandlers : handlers) {
            satisfied |= cmdHandlers.getHelp(cmd, usageBuilder, desc);
        }
        if (!satisfied) {
            this.printUsage(desc, handlers);
        } else {
            this.print(usageBuilder);
        }
    }

    private void printUsage(boolean desc, CommandHandler ... handlers) throws UnsupportedEncodingException {
        StringBuilder usageBuilder = new StringBuilder();
        usageBuilder.append(USAGE_YARN_NODE_ATTRIBUTES);
        for (CommandHandler cmdHandlers : handlers) {
            cmdHandlers.getHelp(usageBuilder, desc);
        }
        usageBuilder.append(DEFAULT_SEPARATOR).append(" -help [cmd] List help of commands");
        this.print(usageBuilder);
    }

    private void print(StringBuilder usageBuilder) throws UnsupportedEncodingException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintWriter pw = new PrintWriter(new OutputStreamWriter((OutputStream)baos, Charset.forName("UTF-8")));
        pw.write(usageBuilder.toString());
        pw.close();
        this.errOut.println(baos.toString("UTF-8"));
    }

    private Options buildOptions(CommandHandler ... handlers) {
        Options opts = new Options();
        for (CommandHandler handler : handlers) {
            Options handlerOpts = handler.getOptions();
            handlerOpts.getOptions().iterator().forEachRemaining(option -> opts.addOption((Option)option));
        }
        return opts;
    }

    public int run(String[] args) throws Exception {
        int exitCode = -1;
        AdminCommandHandler adminCmdHandler = this.getAdminCommandHandler();
        ClientCommandHandler clientCmdHandler = this.getClientCommandHandler();
        Options opts = this.buildOptions(adminCmdHandler, clientCmdHandler);
        if (args.length < 1) {
            this.printUsage(false, adminCmdHandler, clientCmdHandler);
            return -1;
        }
        if (this.handleHelpCommand(args, adminCmdHandler, clientCmdHandler)) {
            return 0;
        }
        AdminCommandHandler handler = null;
        try {
            CommandLine cliParser = new GnuParser().parse(opts, args);
            CommandHandler commandHandler = adminCmdHandler.canHandleCommand(cliParser) ? adminCmdHandler : (handler = clientCmdHandler.canHandleCommand(cliParser) ? clientCmdHandler : null);
            if (handler == null) {
                this.errOut.println(INVALID_COMMAND_USAGE);
                this.printUsage(false, adminCmdHandler, clientCmdHandler);
                return exitCode;
            }
            return ((CommandHandler)handler).handleCommand(cliParser);
        }
        catch (UnrecognizedOptionException e) {
            this.errOut.println(INVALID_COMMAND_USAGE);
            this.printUsage(false, adminCmdHandler, clientCmdHandler);
            return exitCode;
        }
        catch (MissingArgumentException ex) {
            this.errOut.println(MISSING_ARGUMENT);
            this.printUsage(true, adminCmdHandler, clientCmdHandler);
            return exitCode;
        }
        catch (IllegalArgumentException arge) {
            this.errOut.println(arge.getLocalizedMessage());
            this.printUsage(true, handler);
            return exitCode;
        }
        catch (YarnException e) {
            this.errOut.println(e.toString());
            return exitCode;
        }
        catch (Exception e) {
            this.errOut.println(e.toString());
            this.printUsage(true, handler);
            return exitCode;
        }
    }

    private boolean handleHelpCommand(String[] args, CommandHandler ... handlers) throws UnsupportedEncodingException {
        if (args[0].equals("-help")) {
            if (args.length == 2) {
                this.printUsage(args[1], true, handlers);
            } else {
                this.printUsage(true, handlers);
            }
            return true;
        }
        return false;
    }

    public static void main(String[] args) throws Exception {
        int result = ToolRunner.run((Tool)new NodeAttributesCLI(), (String[])args);
        System.exit(result);
    }

    public static class AdminCommandHandler
    extends CommandHandler {
        private static final String ADD = "add";
        private static final String REMOVE = "remove";
        private static final String REPLACE = "replace";
        private static final String FAILUNKNOWNNODES = "failOnUnknownNodes";

        AdminCommandHandler() {
            super("Admin Commands:");
        }

        @Override
        public Options buildOptions() {
            Options adminOptions = new Options();
            Option replace = new Option(REPLACE, true, "Replace the node to attributes mapping information at the ResourceManager with the new mapping. Currently supported attribute type. And string is the default type too. Attribute value if not specified for string type value will be considered as empty string. Replaced node-attributes should not violate the existing attribute to attribute type mapping.");
            replace.setArgName("\"node1:attribute[(type)][=value],attribute1[=value],attribute2  node2:attribute2[=value],attribute3\"");
            replace.setArgs(1);
            adminOptions.addOption(replace);
            Option add = new Option(ADD, true, "Adds or updates the node to attributes mapping information at the ResourceManager. Currently supported attribute type is string. And string is the default type too. Attribute value if not specified for string type value will be considered as empty string. Added or updated node-attributes should not violate the existing attribute to attribute type mapping.");
            add.setArgName("\"node1:attribute[(type)][=value],attribute1[=value],attribute2  node2:attribute2[=value],attribute3\"");
            add.setArgs(1);
            adminOptions.addOption(add);
            Option remove = new Option(REMOVE, true, "Removes the specified node to attributes mapping information at the ResourceManager");
            remove.setArgName("\"node1:attribute,attribute1 node2:attribute2\"");
            remove.setArgs(1);
            adminOptions.addOption(remove);
            adminOptions.addOption(new Option(FAILUNKNOWNNODES, false, "Can be used optionally along with [add,remove,replace] options. When set, command will fail if specified nodes are unknown."));
            this.addOrder(REPLACE);
            this.addOrder(ADD);
            this.addOrder(REMOVE);
            this.addOrder(FAILUNKNOWNNODES);
            return adminOptions;
        }

        protected ResourceManagerAdministrationProtocol createAdminProtocol() throws IOException {
            YarnConfiguration conf = new YarnConfiguration(this.getConf());
            return ClientRMProxy.createRMProxy(conf, ResourceManagerAdministrationProtocol.class);
        }

        @Override
        public int handleCommand(CommandLine cliParser) throws IOException, YarnException {
            String operation = null;
            if (cliParser.hasOption(ADD)) {
                operation = ADD;
            } else if (cliParser.hasOption(REMOVE)) {
                operation = REMOVE;
            } else if (cliParser.hasOption(REPLACE)) {
                operation = REPLACE;
            }
            if (operation == null) {
                throw new IllegalArgumentException(this.getOptions().getOption(FAILUNKNOWNNODES).getDescription());
            }
            List<NodeToAttributes> buildNodeLabelsListFromStr = this.buildNodeLabelsListFromStr(cliParser.getOptionValue(operation), !operation.equals(REPLACE), operation);
            NodesToAttributesMappingRequest request = NodesToAttributesMappingRequest.newInstance(AttributeMappingOperationType.valueOf(operation.toUpperCase()), buildNodeLabelsListFromStr, cliParser.hasOption(FAILUNKNOWNNODES));
            ResourceManagerAdministrationProtocol adminProtocol = this.createAdminProtocol();
            adminProtocol.mapAttributesToNodes(request);
            return 0;
        }

        private List<NodeToAttributes> buildNodeLabelsListFromStr(String args, boolean validateForAttributes, String operation) {
            HashMap<String, NodeToAttributes> nodeToAttributesMap = new HashMap<String, NodeToAttributes>();
            for (String nodeToAttributesStr : args.split("[ \n]")) {
                if ((nodeToAttributesStr = nodeToAttributesStr.trim()).isEmpty() || nodeToAttributesStr.startsWith("#")) continue;
                if (nodeToAttributesStr.indexOf(":") == -1) {
                    throw new IllegalArgumentException(NodeAttributesCLI.INVALID_MAPPING_ERR_MSG + nodeToAttributesStr);
                }
                String[] nodeToAttributes = nodeToAttributesStr.split(":");
                Preconditions.checkArgument(!nodeToAttributes[0].trim().isEmpty(), "Node name cannot be empty");
                String node = nodeToAttributes[0];
                String[] attributeNameValueType = null;
                ArrayList<NodeAttribute> attributesList = new ArrayList<NodeAttribute>();
                NodeAttributeType attributeType = NodeAttributeType.STRING;
                HashSet attributeNamesMapped = new HashSet();
                if (nodeToAttributes.length == 2) {
                    String[] attributesStr;
                    for (String attributeStr : attributesStr = nodeToAttributes[1].split(",")) {
                        String attributeName;
                        attributeNameValueType = attributeStr.split("=");
                        Preconditions.checkArgument(attributeNameValueType[0] != null && !attributeNameValueType[0].isEmpty(), "Attribute name cannot be null or empty");
                        String attributeValue = attributeNameValueType.length > 1 ? attributeNameValueType[1] : "";
                        int indexOfOpenBracket = attributeNameValueType[0].indexOf("(");
                        if (indexOfOpenBracket == -1) {
                            attributeName = attributeNameValueType[0];
                        } else {
                            if (indexOfOpenBracket == 0) {
                                throw new IllegalArgumentException("Attribute for node " + node + " is not properly configured : " + attributeStr);
                            }
                            int indexOfCloseBracket = attributeNameValueType[0].indexOf(")");
                            if (indexOfCloseBracket == -1 || indexOfCloseBracket < indexOfOpenBracket) {
                                throw new IllegalArgumentException("Attribute for node " + node + " is not properly Configured : " + attributeStr);
                            }
                            attributeName = attributeNameValueType[0].substring(0, indexOfOpenBracket);
                            String attributeTypeStr = attributeNameValueType[0].substring(indexOfOpenBracket + 1, indexOfCloseBracket);
                            try {
                                attributeType = NodeAttributeType.valueOf(attributeTypeStr.trim().toUpperCase());
                            }
                            catch (IllegalArgumentException e) {
                                throw new IllegalArgumentException("Invalid Attribute type configuration : " + attributeTypeStr + " in " + attributeStr);
                            }
                        }
                        if (attributeNamesMapped.contains(attributeName)) {
                            throw new IllegalArgumentException("Attribute " + attributeName + " has been mapped more than once in  : " + nodeToAttributesStr);
                        }
                        attributesList.add(NodeAttribute.newInstance("rm.yarn.io", attributeName.trim(), attributeType, attributeValue.trim()));
                    }
                }
                if (validateForAttributes) {
                    Preconditions.checkArgument(attributesList.size() > 0, "Attributes cannot be null or empty for Operation [" + operation + "] on the node " + node);
                }
                nodeToAttributesMap.put(node, NodeToAttributes.newInstance(node, attributesList));
            }
            if (nodeToAttributesMap.isEmpty()) {
                throw new IllegalArgumentException(NodeAttributesCLI.NO_MAPPING_ERR_MSG);
            }
            return Lists.newArrayList(nodeToAttributesMap.values());
        }

        public void setConf(Configuration conf) {
            if (conf != null) {
                conf = this.addSecurityConfiguration(conf);
            }
            super.setConf(conf);
        }

        private Configuration addSecurityConfiguration(Configuration conf) {
            conf = new YarnConfiguration(conf);
            conf.set("hadoop.security.service.user.name.key", conf.get("yarn.resourcemanager.principal", ""));
            return conf;
        }
    }

    public static class ClientCommandHandler
    extends CommandHandler {
        private static final String LIST_ALL_ATTRS = "list";
        private static final String NODESTOATTR = "nodestoattributes";
        private static final String NODES = "nodes";
        private static final String ATTRTONODES = "attributestonodes";
        private static final String ATTRIBUTES = "attributes";
        public static final String SPLITPATTERN = "/";
        private static final String NODEATTRIBUTE = "%40s\t%10s\t%20s" + NodeAttributesCLI.access$000();
        private static final String NODEATTRIBUTEINFO = "%40s\t%15s" + NodeAttributesCLI.access$000();
        private static final String HOSTNAMEVAL = "%40s\t%15s" + NodeAttributesCLI.access$000();
        private PrintStream sysOut = System.out;

        public ClientCommandHandler() {
            super("Client Commands:");
        }

        public void setSysOut(PrintStream out) {
            this.sysOut = out;
        }

        @Override
        public int handleCommand(CommandLine parse) throws IOException, YarnException {
            if (parse.hasOption(LIST_ALL_ATTRS)) {
                return this.printClusterAttributes();
            }
            if (parse.hasOption(NODESTOATTR)) {
                String[] nodes = new String[]{};
                if (parse.hasOption(NODES)) {
                    nodes = parse.getOptionValues(NODES);
                }
                return this.printAttributesByNode(nodes);
            }
            if (parse.hasOption(ATTRTONODES)) {
                String[] attrKeys = new String[]{};
                if (parse.hasOption(ATTRIBUTES)) {
                    attrKeys = parse.getOptionValues(ATTRIBUTES);
                }
                return this.printNodesByAttributes(attrKeys);
            }
            return 0;
        }

        protected ApplicationClientProtocol createApplicationProtocol() throws IOException {
            YarnConfiguration conf = new YarnConfiguration(this.getConf());
            return ClientRMProxy.createRMProxy(conf, ApplicationClientProtocol.class);
        }

        public int printNodesByAttributes(String[] attrs) throws YarnException, IOException {
            ApplicationClientProtocol protocol = this.createApplicationProtocol();
            HashSet<NodeAttributeKey> set = new HashSet<NodeAttributeKey>();
            for (String attr : attrs) {
                String[] attrFields = attr.split(SPLITPATTERN);
                if (attrFields.length == 1) {
                    set.add(NodeAttributeKey.newInstance(attrFields[0]));
                    continue;
                }
                if (attrFields.length == 2) {
                    set.add(NodeAttributeKey.newInstance(attrFields[0], attrFields[1]));
                    continue;
                }
                throw new IllegalArgumentException(" Attribute format not correct. Should be <[prefix]/[name]> :" + attr);
            }
            GetAttributesToNodesRequest request = GetAttributesToNodesRequest.newInstance(set);
            GetAttributesToNodesResponse response = protocol.getAttributesToNodes(request);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            PrintWriter writer = new PrintWriter(new OutputStreamWriter((OutputStream)baos, Charset.forName("UTF-8")));
            writer.format(HOSTNAMEVAL, "Hostname", "Attribute-value");
            response.getAttributesToNodes().forEach((attributeKey, v) -> {
                writer.println(this.getKeyString((NodeAttributeKey)attributeKey) + " :");
                v.iterator().forEachRemaining(attrVal -> writer.format(HOSTNAMEVAL, attrVal.getHostname(), attrVal.getAttributeValue()));
            });
            writer.close();
            this.sysOut.println(baos.toString("UTF-8"));
            return 0;
        }

        private int printAttributesByNode(String[] nodeArray) throws YarnException, IOException {
            ApplicationClientProtocol protocol = this.createApplicationProtocol();
            HashSet<String> nodes = new HashSet<String>(Arrays.asList(nodeArray));
            GetNodesToAttributesRequest request = GetNodesToAttributesRequest.newInstance(nodes);
            GetNodesToAttributesResponse response = protocol.getNodesToAttributes(request);
            Map<String, Set<NodeAttribute>> nodeToAttrs = response.getNodeToAttributes();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            PrintWriter writer = new PrintWriter(new OutputStreamWriter((OutputStream)baos, Charset.forName("UTF-8")));
            writer.printf(NODEATTRIBUTE, "Attribute", "Type", "Value");
            nodeToAttrs.forEach((node, v) -> {
                writer.println(node + ":");
                v.iterator().forEachRemaining(attr -> writer.format(NODEATTRIBUTE, this.getKeyString(attr.getAttributeKey()), attr.getAttributeType().name(), attr.getAttributeValue()));
            });
            writer.close();
            this.sysOut.println(baos.toString("UTF-8"));
            return 0;
        }

        private int printClusterAttributes() throws IOException, YarnException {
            ApplicationClientProtocol protocol = this.createApplicationProtocol();
            GetClusterNodeAttributesRequest request = GetClusterNodeAttributesRequest.newInstance();
            GetClusterNodeAttributesResponse response = protocol.getClusterNodeAttributes(request);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            PrintWriter writer = new PrintWriter(new OutputStreamWriter((OutputStream)baos, Charset.forName("UTF-8")));
            writer.format(NODEATTRIBUTEINFO, "Attribute", "Type");
            for (NodeAttributeInfo attr : response.getNodeAttributes()) {
                writer.format(NODEATTRIBUTEINFO, this.getKeyString(attr.getAttributeKey()), attr.getAttributeType().name());
            }
            writer.close();
            this.sysOut.println(baos.toString("UTF-8"));
            return 0;
        }

        private String getKeyString(NodeAttributeKey key) {
            StringBuilder sb = new StringBuilder();
            sb.append(key.getAttributePrefix()).append(SPLITPATTERN).append(key.getAttributeName());
            return sb.toString();
        }

        @Override
        public Options buildOptions() {
            Options clientOptions = new Options();
            clientOptions.addOption(new Option(LIST_ALL_ATTRS, false, "List all attributes in cluster"));
            OptionGroup nodeToAttr = new OptionGroup();
            Option attrtonodes = new Option(NODESTOATTR, false, "Lists all mapping to nodes to attributes");
            Option nodes = new Option(NODES, "Works with [list] to specify node hostnames whose mappings are required to be displayed.");
            nodes.setValueSeparator(',');
            nodes.setArgName("Host Names");
            nodes.setArgs(-2);
            nodeToAttr.addOption(attrtonodes);
            nodeToAttr.addOption(nodes);
            clientOptions.addOptionGroup(nodeToAttr);
            OptionGroup attrToNodes = new OptionGroup();
            attrToNodes.addOption(new Option(ATTRTONODES, false, "Displays mapping of attributes to nodes and attribute values grouped by attributes"));
            Option attrs = new Option(ATTRIBUTES, "Works with [attributestonodes] to specify attributes whose mapping are required to be displayed.");
            attrs.setValueSeparator(',');
            attrs.setArgName("Attributes");
            attrs.setArgs(-2);
            attrToNodes.addOption(attrs);
            clientOptions.addOptionGroup(attrToNodes);
            this.addOrder(LIST_ALL_ATTRS);
            this.addOrder(NODESTOATTR);
            this.addOrder(NODES);
            this.addOrder(ATTRTONODES);
            this.addOrder(ATTRIBUTES);
            return clientOptions;
        }
    }

    public static abstract class CommandHandler
    extends Configured {
        private Options options;
        private LinkedList<String> order = new LinkedList();
        private String header;

        protected CommandHandler(String header) {
            this(new YarnConfiguration());
            this.header = header;
        }

        protected CommandHandler(Configuration conf) {
            super(conf);
            this.options = this.buildOptions();
        }

        public boolean canHandleCommand(CommandLine parse) {
            ArrayList<Option> arrayList = new ArrayList<Option>(this.options.getOptions());
            return arrayList.stream().anyMatch(opt -> parse.hasOption(opt.getOpt()));
        }

        public abstract int handleCommand(CommandLine var1) throws IOException, YarnException;

        public abstract Options buildOptions();

        public Options getOptions() {
            return this.options;
        }

        public boolean getHelp(String cmd, StringBuilder strcnd, boolean addDesc) {
            Option opt = this.options.getOption(cmd);
            if (opt != null) {
                strcnd.append(DEFAULT_SEPARATOR).append(" -").append(opt.getOpt());
                if (opt.hasArg()) {
                    strcnd.append(" <").append(opt.getArgName()).append(">");
                }
                if (addDesc) {
                    strcnd.append(DEFAULT_SEPARATOR).append("\t").append(opt.getDescription());
                }
            }
            return opt == null;
        }

        public void getHelp(StringBuilder builder, boolean description) {
            builder.append(DEFAULT_SEPARATOR).append(DEFAULT_SEPARATOR).append(this.header);
            for (String option : this.order) {
                this.getHelp(option, builder, description);
            }
        }

        protected void addOrder(String key) {
            this.order.add(key);
        }
    }
}

