/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.client.api.impl;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.util.MinimalPrettyPrinter;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.fasterxml.jackson.module.jaxb.JaxbAnnotationIntrospector;
import com.sun.jersey.api.client.Client;
import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.Time;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.timeline.TimelineDomain;
import org.apache.hadoop.yarn.api.records.timeline.TimelineEntity;
import org.apache.hadoop.yarn.api.records.timeline.TimelineEntityGroupId;
import org.apache.hadoop.yarn.api.records.timeline.TimelinePutResponse;
import org.apache.hadoop.yarn.client.api.impl.TimelineWriter;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class FileSystemTimelineWriter
extends TimelineWriter {
    private static final Logger LOG = LoggerFactory.getLogger(FileSystemTimelineWriter.class);
    private static final short APP_LOG_DIR_PERMISSIONS = 504;
    private static final short FILE_LOG_PERMISSIONS = 416;
    private static final String DOMAIN_LOG_PREFIX = "domainlog-";
    private static final String SUMMARY_LOG_PREFIX = "summarylog-";
    private static final String ENTITY_LOG_PREFIX = "entitylog-";
    private Path activePath = null;
    private FileSystem fs = null;
    private Set<String> summaryEntityTypes;
    private ObjectMapper objMapper = null;
    private long flushIntervalSecs;
    private long cleanIntervalSecs;
    private long ttl;
    private LogFDsCache logFDsCache = null;
    private boolean isAppendSupported;
    private final AttemptDirCache attemptDirCache;

    public FileSystemTimelineWriter(Configuration conf, UserGroupInformation authUgi, Client client, URI resURI) throws IOException {
        super(authUgi, client, resURI);
        Configuration fsConf = new Configuration(conf);
        this.activePath = new Path(fsConf.get("yarn.timeline-service.entity-group-fs-store.active-dir", "/tmp/entity-file-history/active"));
        this.fs = FileSystem.newInstance((URI)this.activePath.toUri(), (Configuration)fsConf);
        this.fs.getFileStatus(this.activePath);
        this.summaryEntityTypes = new HashSet<String>(conf.getStringCollection("yarn.timeline-service.entity-group-fs-store.summary-entity-types"));
        this.flushIntervalSecs = conf.getLong("yarn.timeline-service.client.fd-flush-interval-secs", 10L);
        this.cleanIntervalSecs = conf.getLong("yarn.timeline-service.client.fd-clean-interval-secs", 60L);
        this.ttl = conf.getLong("yarn.timeline-service.client.fd-retain-secs", 300L);
        long timerTaskTTL = conf.getLong("yarn.timeline-service.client.internal-timers-ttl-secs", 420L);
        this.logFDsCache = new LogFDsCache(this.flushIntervalSecs, this.cleanIntervalSecs, this.ttl, timerTaskTTL);
        this.isAppendSupported = conf.getBoolean("yarn.timeline-service.entity-file.fs-support-append", true);
        boolean storeInsideUserDir = conf.getBoolean("yarn.timeline-service.entity-group-fs-store.with-user-dir", false);
        this.objMapper = this.createObjectMapper();
        int attemptDirCacheSize = conf.getInt("yarn.timeline-service.client.internal-attempt-dir-cache-size", 1000);
        this.attemptDirCache = new AttemptDirCache(attemptDirCacheSize, this.fs, this.activePath, authUgi, storeInsideUserDir);
        if (LOG.isDebugEnabled()) {
            StringBuilder debugMSG = new StringBuilder();
            debugMSG.append("yarn.timeline-service.client.fd-flush-interval-secs=" + this.flushIntervalSecs + ", " + "yarn.timeline-service.client.fd-clean-interval-secs" + "=" + this.cleanIntervalSecs + ", " + "yarn.timeline-service.client.fd-retain-secs" + "=" + this.ttl + ", " + "yarn.timeline-service.entity-file.fs-support-append" + "=" + this.isAppendSupported + ", " + "yarn.timeline-service.entity-group-fs-store.with-user-dir" + "=" + storeInsideUserDir + ", " + "yarn.timeline-service.entity-group-fs-store.active-dir" + "=" + this.activePath);
            if (this.summaryEntityTypes != null && !this.summaryEntityTypes.isEmpty()) {
                debugMSG.append(", yarn.timeline-service.entity-group-fs-store.summary-entity-types = " + this.summaryEntityTypes);
            }
            LOG.debug(debugMSG.toString());
        }
    }

    @Override
    public String toString() {
        return "FileSystemTimelineWriter writing to " + this.activePath;
    }

    @Override
    public TimelinePutResponse putEntities(ApplicationAttemptId appAttemptId, TimelineEntityGroupId groupId, TimelineEntity ... entities) throws IOException, YarnException {
        if (appAttemptId == null) {
            return this.putEntities(entities);
        }
        ArrayList<TimelineEntity> entitiesToDBStore = new ArrayList<TimelineEntity>();
        ArrayList<TimelineEntity> entitiesToSummaryCache = new ArrayList<TimelineEntity>();
        ArrayList<TimelineEntity> entitiesToEntityCache = new ArrayList<TimelineEntity>();
        Path attemptDir = this.attemptDirCache.getAppAttemptDir(appAttemptId);
        for (TimelineEntity entity : entities) {
            if (this.summaryEntityTypes.contains(entity.getEntityType())) {
                entitiesToSummaryCache.add(entity);
                continue;
            }
            if (groupId != null) {
                entitiesToEntityCache.add(entity);
                continue;
            }
            entitiesToDBStore.add(entity);
        }
        if (!entitiesToSummaryCache.isEmpty()) {
            Path summaryLogPath = new Path(attemptDir, SUMMARY_LOG_PREFIX + appAttemptId.toString());
            LOG.debug("Writing summary log for {} to {}", (Object)appAttemptId, (Object)summaryLogPath);
            this.logFDsCache.writeSummaryEntityLogs(this.fs, summaryLogPath, this.objMapper, appAttemptId, entitiesToSummaryCache, this.isAppendSupported);
        }
        if (!entitiesToEntityCache.isEmpty()) {
            Path entityLogPath = new Path(attemptDir, ENTITY_LOG_PREFIX + groupId.toString());
            LOG.debug("Writing entity log for {} to {}", (Object)groupId, (Object)entityLogPath);
            this.logFDsCache.writeEntityLogs(this.fs, entityLogPath, this.objMapper, appAttemptId, groupId, entitiesToEntityCache, this.isAppendSupported);
        }
        if (!entitiesToDBStore.isEmpty()) {
            this.putEntities(entitiesToDBStore.toArray(new TimelineEntity[entitiesToDBStore.size()]));
        }
        return new TimelinePutResponse();
    }

    @Override
    public void putDomain(ApplicationAttemptId appAttemptId, TimelineDomain domain) throws IOException, YarnException {
        if (appAttemptId == null) {
            this.putDomain(domain);
        } else {
            this.writeDomain(appAttemptId, domain);
        }
    }

    @Override
    public synchronized void close() throws Exception {
        if (this.logFDsCache != null) {
            LOG.debug("Closing cache");
            this.logFDsCache.flush();
        }
        IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{this.logFDsCache, this.fs});
    }

    @Override
    public void flush() throws IOException {
        if (this.logFDsCache != null) {
            LOG.debug("Flushing cache");
            this.logFDsCache.flush();
        }
    }

    private ObjectMapper createObjectMapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.setAnnotationIntrospector(new JaxbAnnotationIntrospector(TypeFactory.defaultInstance()));
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        mapper.configure(SerializationFeature.FLUSH_AFTER_WRITE_VALUE, false);
        return mapper;
    }

    private void writeDomain(ApplicationAttemptId appAttemptId, TimelineDomain domain) throws IOException {
        Path domainLogPath = new Path(this.attemptDirCache.getAppAttemptDir(appAttemptId), DOMAIN_LOG_PREFIX + appAttemptId.toString());
        LOG.debug("Writing domains for {} to {}", (Object)appAttemptId, (Object)domainLogPath);
        this.logFDsCache.writeDomainLog(this.fs, domainLogPath, this.objMapper, domain, this.isAppendSupported);
    }

    private static class AttemptDirCache {
        private final int attemptDirCacheSize;
        private final Map<ApplicationAttemptId, Path> attemptDirCache;
        private final FileSystem fs;
        private final Path activePath;
        private final UserGroupInformation authUgi;
        private final boolean storeInsideUserDir;

        public AttemptDirCache(int cacheSize, FileSystem fs, Path activePath, UserGroupInformation ugi, boolean storeInsideUserDir) {
            this.attemptDirCacheSize = cacheSize;
            this.attemptDirCache = new LinkedHashMap<ApplicationAttemptId, Path>(this.attemptDirCacheSize, 0.75f, true){
                private static final long serialVersionUID = 1L;

                @Override
                protected boolean removeEldestEntry(Map.Entry<ApplicationAttemptId, Path> eldest) {
                    return this.size() > attemptDirCacheSize;
                }
            };
            this.fs = fs;
            this.activePath = activePath;
            this.authUgi = ugi;
            this.storeInsideUserDir = storeInsideUserDir;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Path getAppAttemptDir(ApplicationAttemptId attemptId) throws IOException {
            Path attemptDir = this.attemptDirCache.get(attemptId);
            if (attemptDir == null) {
                AttemptDirCache attemptDirCache = this;
                synchronized (attemptDirCache) {
                    attemptDir = this.attemptDirCache.get(attemptId);
                    if (attemptDir == null) {
                        attemptDir = this.createAttemptDir(attemptId);
                        this.attemptDirCache.put(attemptId, attemptDir);
                    }
                }
            }
            return attemptDir;
        }

        private Path createAttemptDir(ApplicationAttemptId appAttemptId) throws IOException {
            Path appDir = this.createApplicationDir(appAttemptId.getApplicationId());
            Path attemptDir = new Path(appDir, appAttemptId.toString());
            if (FileSystem.mkdirs((FileSystem)this.fs, (Path)attemptDir, (FsPermission)new FsPermission(504))) {
                LOG.debug("New attempt directory created - {}", (Object)attemptDir);
            }
            return attemptDir;
        }

        private Path createApplicationDir(ApplicationId appId) throws IOException {
            Path appRootDir = this.getAppRootDir(this.authUgi.getShortUserName());
            Path appDir = new Path(appRootDir, appId.toString());
            if (FileSystem.mkdirs((FileSystem)this.fs, (Path)appDir, (FsPermission)new FsPermission(504))) {
                LOG.debug("New app directory created - {}", (Object)appDir);
            }
            return appDir;
        }

        private Path getAppRootDir(String user) throws IOException {
            if (!this.storeInsideUserDir) {
                return this.activePath;
            }
            Path userDir = new Path(this.activePath, user);
            if (FileSystem.mkdirs((FileSystem)this.fs, (Path)userDir, (FsPermission)new FsPermission(504))) {
                LOG.debug("New user directory created - {}", (Object)userDir);
            }
            return userDir;
        }
    }

    private static class LogFDsCache
    implements Closeable,
    Flushable {
        private DomainLogFD domainLogFD = null;
        private Map<ApplicationAttemptId, EntityLogFD> summanyLogFDs;
        private Map<ApplicationAttemptId, HashMap<TimelineEntityGroupId, EntityLogFD>> entityLogFDs;
        private Timer flushTimer = null;
        private Timer cleanInActiveFDsTimer = null;
        private Timer monitorTaskTimer = null;
        private final long ttl;
        private final ReentrantLock domainFDLocker = new ReentrantLock();
        private final ReentrantLock summaryTableLocker = new ReentrantLock();
        private final ReentrantLock entityTableLocker = new ReentrantLock();
        private final ReentrantLock summaryTableCopyLocker = new ReentrantLock();
        private final ReentrantLock entityTableCopyLocker = new ReentrantLock();
        private volatile boolean serviceStopped = false;
        private volatile boolean timerTaskStarted = false;
        private final ReentrantLock timerTaskLocker = new ReentrantLock();
        private final long flushIntervalSecs;
        private final long cleanIntervalSecs;
        private final long timerTaskRetainTTL;
        private volatile long timeStampOfLastWrite = Time.monotonicNow();
        private final ReentrantReadWriteLock.ReadLock timerTasksMonitorReadLock;
        private final ReentrantReadWriteLock.WriteLock timerTasksMonitorWriteLock;

        public LogFDsCache(long flushIntervalSecs, long cleanIntervalSecs, long ttl, long timerTaskRetainTTL) {
            this.summanyLogFDs = new HashMap<ApplicationAttemptId, EntityLogFD>();
            this.entityLogFDs = new HashMap<ApplicationAttemptId, HashMap<TimelineEntityGroupId, EntityLogFD>>();
            this.ttl = ttl * 1000L;
            this.flushIntervalSecs = flushIntervalSecs;
            this.cleanIntervalSecs = cleanIntervalSecs;
            long timerTaskRetainTTLVar = timerTaskRetainTTL * 1000L;
            if (timerTaskRetainTTLVar > this.ttl) {
                this.timerTaskRetainTTL = timerTaskRetainTTLVar;
            } else {
                this.timerTaskRetainTTL = this.ttl + 120000L;
                LOG.warn("The specific yarn.timeline-service.client.internal-timers-ttl-secs : " + timerTaskRetainTTL + " is invalid, because it is less than or equal to " + "yarn.timeline-service.client.fd-retain-secs" + " : " + ttl + ". Use " + "yarn.timeline-service.client.fd-retain-secs" + " : " + ttl + " + 120s instead.");
            }
            ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
            this.timerTasksMonitorReadLock = lock.readLock();
            this.timerTasksMonitorWriteLock = lock.writeLock();
        }

        @Override
        public void flush() throws IOException {
            this.domainFDLocker.lock();
            try {
                if (this.domainLogFD != null) {
                    this.domainLogFD.flush();
                }
            }
            finally {
                this.domainFDLocker.unlock();
            }
            this.flushSummaryFDMap(this.copySummaryLogFDs(this.summanyLogFDs));
            this.flushEntityFDMap(this.copyEntityLogFDs(this.entityLogFDs));
        }

        private Map<ApplicationAttemptId, EntityLogFD> copySummaryLogFDs(Map<ApplicationAttemptId, EntityLogFD> summanyLogFDsToCopy) {
            this.summaryTableCopyLocker.lock();
            try {
                HashMap<ApplicationAttemptId, EntityLogFD> hashMap = new HashMap<ApplicationAttemptId, EntityLogFD>(summanyLogFDsToCopy);
                return hashMap;
            }
            finally {
                this.summaryTableCopyLocker.unlock();
            }
        }

        private Map<ApplicationAttemptId, HashMap<TimelineEntityGroupId, EntityLogFD>> copyEntityLogFDs(Map<ApplicationAttemptId, HashMap<TimelineEntityGroupId, EntityLogFD>> entityLogFDsToCopy) {
            this.entityTableCopyLocker.lock();
            try {
                HashMap<ApplicationAttemptId, HashMap<TimelineEntityGroupId, EntityLogFD>> hashMap = new HashMap<ApplicationAttemptId, HashMap<TimelineEntityGroupId, EntityLogFD>>(entityLogFDsToCopy);
                return hashMap;
            }
            finally {
                this.entityTableCopyLocker.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void flushSummaryFDMap(Map<ApplicationAttemptId, EntityLogFD> logFDs) throws IOException {
            if (!logFDs.isEmpty()) {
                for (Map.Entry<ApplicationAttemptId, EntityLogFD> logFDEntry : logFDs.entrySet()) {
                    EntityLogFD logFD = logFDEntry.getValue();
                    logFD.lock();
                    try {
                        logFD.flush();
                    }
                    finally {
                        logFD.unlock();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void flushEntityFDMap(Map<ApplicationAttemptId, HashMap<TimelineEntityGroupId, EntityLogFD>> logFDs) throws IOException {
            if (!logFDs.isEmpty()) {
                for (Map.Entry<ApplicationAttemptId, HashMap<TimelineEntityGroupId, EntityLogFD>> logFDMapEntry : logFDs.entrySet()) {
                    HashMap<TimelineEntityGroupId, EntityLogFD> logFDMap = logFDMapEntry.getValue();
                    for (Map.Entry<TimelineEntityGroupId, EntityLogFD> logFDEntry : logFDMap.entrySet()) {
                        EntityLogFD logFD = logFDEntry.getValue();
                        logFD.lock();
                        try {
                            logFD.flush();
                        }
                        finally {
                            logFD.unlock();
                        }
                    }
                }
            }
        }

        private void cleanInActiveFDs() {
            long currentTimeStamp = Time.monotonicNow();
            this.domainFDLocker.lock();
            try {
                if (this.domainLogFD != null && currentTimeStamp - this.domainLogFD.getLastModifiedTime() >= this.ttl) {
                    this.domainLogFD.close();
                    this.domainLogFD = null;
                }
            }
            finally {
                this.domainFDLocker.unlock();
            }
            this.cleanInActiveSummaryFDsforMap(this.copySummaryLogFDs(this.summanyLogFDs), currentTimeStamp);
            this.cleanInActiveEntityFDsforMap(this.copyEntityLogFDs(this.entityLogFDs), currentTimeStamp);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void cleanInActiveSummaryFDsforMap(Map<ApplicationAttemptId, EntityLogFD> logFDs, long currentTimeStamp) {
            if (!logFDs.isEmpty()) {
                for (Map.Entry<ApplicationAttemptId, EntityLogFD> logFDEntry : logFDs.entrySet()) {
                    EntityLogFD logFD = logFDEntry.getValue();
                    logFD.lock();
                    try {
                        if (currentTimeStamp - logFD.getLastModifiedTime() < this.ttl) continue;
                        logFD.close();
                    }
                    finally {
                        logFD.unlock();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void cleanInActiveEntityFDsforMap(Map<ApplicationAttemptId, HashMap<TimelineEntityGroupId, EntityLogFD>> logFDs, long currentTimeStamp) {
            if (!logFDs.isEmpty()) {
                for (Map.Entry<ApplicationAttemptId, HashMap<TimelineEntityGroupId, EntityLogFD>> logFDMapEntry : logFDs.entrySet()) {
                    HashMap<TimelineEntityGroupId, EntityLogFD> logFDMap = logFDMapEntry.getValue();
                    for (Map.Entry<TimelineEntityGroupId, EntityLogFD> logFDEntry : logFDMap.entrySet()) {
                        EntityLogFD logFD = logFDEntry.getValue();
                        logFD.lock();
                        try {
                            if (currentTimeStamp - logFD.getLastModifiedTime() < this.ttl) continue;
                            logFD.close();
                        }
                        finally {
                            logFD.unlock();
                        }
                    }
                }
            }
        }

        private void monitorTimerTasks() {
            if (Time.monotonicNow() - this.timeStampOfLastWrite >= this.timerTaskRetainTTL) {
                this.cancelAndCloseTimerTasks();
                this.timerTaskStarted = false;
            } else if (this.monitorTaskTimer != null) {
                this.monitorTaskTimer.schedule((TimerTask)new TimerMonitorTask(), this.timerTaskRetainTTL);
            }
        }

        @Override
        public void close() throws IOException {
            this.serviceStopped = true;
            this.cancelAndCloseTimerTasks();
        }

        private void cancelAndCloseTimerTasks() {
            if (this.flushTimer != null) {
                this.flushTimer.cancel();
                this.flushTimer = null;
            }
            if (this.cleanInActiveFDsTimer != null) {
                this.cleanInActiveFDsTimer.cancel();
                this.cleanInActiveFDsTimer = null;
            }
            if (this.monitorTaskTimer != null) {
                this.monitorTaskTimer.cancel();
                this.monitorTaskTimer = null;
            }
            this.domainFDLocker.lock();
            try {
                if (this.domainLogFD != null) {
                    this.domainLogFD.close();
                    this.domainLogFD = null;
                }
            }
            finally {
                this.domainFDLocker.unlock();
            }
            this.closeSummaryFDs(this.summanyLogFDs);
            this.closeEntityFDs(this.entityLogFDs);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void closeEntityFDs(Map<ApplicationAttemptId, HashMap<TimelineEntityGroupId, EntityLogFD>> logFDs) {
            this.entityTableLocker.lock();
            try {
                if (!logFDs.isEmpty()) {
                    for (Map.Entry<ApplicationAttemptId, HashMap<TimelineEntityGroupId, EntityLogFD>> logFDMapEntry : logFDs.entrySet()) {
                        HashMap<TimelineEntityGroupId, EntityLogFD> logFDMap = logFDMapEntry.getValue();
                        for (Map.Entry<TimelineEntityGroupId, EntityLogFD> logFDEntry : logFDMap.entrySet()) {
                            EntityLogFD logFD = logFDEntry.getValue();
                            try {
                                logFD.lock();
                                logFD.close();
                            }
                            finally {
                                logFD.unlock();
                            }
                        }
                    }
                }
            }
            finally {
                this.entityTableLocker.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void closeSummaryFDs(Map<ApplicationAttemptId, EntityLogFD> logFDs) {
            this.summaryTableLocker.lock();
            try {
                if (!logFDs.isEmpty()) {
                    for (Map.Entry<ApplicationAttemptId, EntityLogFD> logFDEntry : logFDs.entrySet()) {
                        EntityLogFD logFD = logFDEntry.getValue();
                        try {
                            logFD.lock();
                            logFD.close();
                        }
                        finally {
                            logFD.unlock();
                        }
                    }
                }
            }
            finally {
                this.summaryTableLocker.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void writeDomainLog(FileSystem fs, Path logPath, ObjectMapper objMapper, TimelineDomain domain, boolean isAppendSupported) throws IOException {
            this.checkAndStartTimeTasks();
            this.domainFDLocker.lock();
            try {
                if (this.domainLogFD != null) {
                    this.domainLogFD.writeDomain(domain);
                } else {
                    this.domainLogFD = new DomainLogFD(fs, logPath, objMapper, isAppendSupported);
                    this.domainLogFD.writeDomain(domain);
                }
            }
            finally {
                this.domainFDLocker.unlock();
            }
        }

        public void writeEntityLogs(FileSystem fs, Path entityLogPath, ObjectMapper objMapper, ApplicationAttemptId appAttemptId, TimelineEntityGroupId groupId, List<TimelineEntity> entitiesToEntity, boolean isAppendSupported) throws IOException {
            this.checkAndStartTimeTasks();
            this.writeEntityLogs(fs, entityLogPath, objMapper, appAttemptId, groupId, entitiesToEntity, isAppendSupported, this.entityLogFDs);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void writeEntityLogs(FileSystem fs, Path logPath, ObjectMapper objMapper, ApplicationAttemptId attemptId, TimelineEntityGroupId groupId, List<TimelineEntity> entities, boolean isAppendSupported, Map<ApplicationAttemptId, HashMap<TimelineEntityGroupId, EntityLogFD>> logFDs) throws IOException {
            HashMap<TimelineEntityGroupId, EntityLogFD> logMapFD = logFDs.get(attemptId);
            if (logMapFD != null) {
                EntityLogFD logFD = logMapFD.get(groupId);
                if (logFD != null) {
                    logFD.lock();
                    try {
                        if (this.serviceStopped) {
                            return;
                        }
                        logFD.writeEntities(entities);
                    }
                    finally {
                        logFD.unlock();
                    }
                } else {
                    this.createEntityFDandWrite(fs, logPath, objMapper, attemptId, groupId, entities, isAppendSupported, logFDs);
                }
            } else {
                this.createEntityFDandWrite(fs, logPath, objMapper, attemptId, groupId, entities, isAppendSupported, logFDs);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void createEntityFDandWrite(FileSystem fs, Path logPath, ObjectMapper objMapper, ApplicationAttemptId attemptId, TimelineEntityGroupId groupId, List<TimelineEntity> entities, boolean isAppendSupported, Map<ApplicationAttemptId, HashMap<TimelineEntityGroupId, EntityLogFD>> logFDs) throws IOException {
            this.entityTableLocker.lock();
            try {
                EntityLogFD logFD;
                if (this.serviceStopped) {
                    return;
                }
                HashMap<TimelineEntityGroupId, EntityLogFD> logFDMap = logFDs.get(attemptId);
                if (logFDMap == null) {
                    logFDMap = new HashMap();
                }
                if ((logFD = logFDMap.get(groupId)) == null) {
                    logFD = new EntityLogFD(fs, logPath, objMapper, isAppendSupported);
                }
                logFD.lock();
                try {
                    logFD.writeEntities(entities);
                    this.entityTableCopyLocker.lock();
                    try {
                        logFDMap.put(groupId, logFD);
                        logFDs.put(attemptId, logFDMap);
                    }
                    finally {
                        this.entityTableCopyLocker.unlock();
                    }
                }
                finally {
                    logFD.unlock();
                }
            }
            finally {
                this.entityTableLocker.unlock();
            }
        }

        public void writeSummaryEntityLogs(FileSystem fs, Path logPath, ObjectMapper objMapper, ApplicationAttemptId attemptId, List<TimelineEntity> entities, boolean isAppendSupported) throws IOException {
            this.checkAndStartTimeTasks();
            this.writeSummmaryEntityLogs(fs, logPath, objMapper, attemptId, entities, isAppendSupported, this.summanyLogFDs);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void writeSummmaryEntityLogs(FileSystem fs, Path logPath, ObjectMapper objMapper, ApplicationAttemptId attemptId, List<TimelineEntity> entities, boolean isAppendSupported, Map<ApplicationAttemptId, EntityLogFD> logFDs) throws IOException {
            EntityLogFD logFD = null;
            logFD = logFDs.get(attemptId);
            if (logFD != null) {
                logFD.lock();
                try {
                    if (this.serviceStopped) {
                        return;
                    }
                    logFD.writeEntities(entities);
                }
                finally {
                    logFD.unlock();
                }
            } else {
                this.createSummaryFDAndWrite(fs, logPath, objMapper, attemptId, entities, isAppendSupported, logFDs);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void createSummaryFDAndWrite(FileSystem fs, Path logPath, ObjectMapper objMapper, ApplicationAttemptId attemptId, List<TimelineEntity> entities, boolean isAppendSupported, Map<ApplicationAttemptId, EntityLogFD> logFDs) throws IOException {
            this.summaryTableLocker.lock();
            try {
                if (this.serviceStopped) {
                    return;
                }
                EntityLogFD logFD = logFDs.get(attemptId);
                if (logFD == null) {
                    logFD = new EntityLogFD(fs, logPath, objMapper, isAppendSupported);
                }
                logFD.lock();
                try {
                    logFD.writeEntities(entities);
                    this.summaryTableCopyLocker.lock();
                    try {
                        logFDs.put(attemptId, logFD);
                    }
                    finally {
                        this.summaryTableCopyLocker.unlock();
                    }
                }
                finally {
                    logFD.unlock();
                }
            }
            finally {
                this.summaryTableLocker.unlock();
            }
        }

        private void createAndStartTimerTasks() {
            this.flushTimer = new Timer(LogFDsCache.class.getSimpleName() + "FlushTimer", true);
            this.flushTimer.schedule((TimerTask)new FlushTimerTask(), this.flushIntervalSecs * 1000L, this.flushIntervalSecs * 1000L);
            this.cleanInActiveFDsTimer = new Timer(LogFDsCache.class.getSimpleName() + "cleanInActiveFDsTimer", true);
            this.cleanInActiveFDsTimer.schedule((TimerTask)new CleanInActiveFDsTask(), this.cleanIntervalSecs * 1000L, this.cleanIntervalSecs * 1000L);
            this.monitorTaskTimer = new Timer(LogFDsCache.class.getSimpleName() + "MonitorTimer", true);
            this.monitorTaskTimer.schedule((TimerTask)new TimerMonitorTask(), this.timerTaskRetainTTL);
        }

        private void checkAndStartTimeTasks() {
            block7: {
                this.timerTasksMonitorReadLock.lock();
                try {
                    this.timeStampOfLastWrite = Time.monotonicNow();
                    if (this.timerTaskStarted) break block7;
                    this.timerTaskLocker.lock();
                    try {
                        if (!this.timerTaskStarted) {
                            this.createAndStartTimerTasks();
                            this.timerTaskStarted = true;
                        }
                    }
                    finally {
                        this.timerTaskLocker.unlock();
                    }
                }
                finally {
                    this.timerTasksMonitorReadLock.unlock();
                }
            }
        }

        private class TimerMonitorTask
        extends TimerTask {
            private TimerMonitorTask() {
            }

            @Override
            public void run() {
                LogFDsCache.this.timerTasksMonitorWriteLock.lock();
                try {
                    LogFDsCache.this.monitorTimerTasks();
                }
                finally {
                    LogFDsCache.this.timerTasksMonitorWriteLock.unlock();
                }
            }
        }

        private class CleanInActiveFDsTask
        extends TimerTask {
            private CleanInActiveFDsTask() {
            }

            @Override
            public void run() {
                try {
                    LogFDsCache.this.cleanInActiveFDs();
                }
                catch (Exception e) {
                    LOG.warn(e.toString());
                }
            }
        }

        private class FlushTimerTask
        extends TimerTask {
            private FlushTimerTask() {
            }

            @Override
            public void run() {
                try {
                    LogFDsCache.this.flush();
                }
                catch (Exception e) {
                    LOG.debug("{}", (Throwable)e);
                }
            }
        }
    }

    private static class LogFD {
        private FSDataOutputStream stream;
        private ObjectMapper objMapper;
        private JsonGenerator jsonGenerator;
        private long lastModifiedTime;
        private final boolean isAppendSupported;
        private final ReentrantLock fdLock = new ReentrantLock();
        private final FileSystem fs;
        private final Path logPath;

        public LogFD(FileSystem fs, Path logPath, ObjectMapper objMapper, boolean isAppendSupported) throws IOException {
            this.fs = fs;
            this.logPath = logPath;
            this.isAppendSupported = isAppendSupported;
            this.objMapper = objMapper;
            this.prepareForWrite();
        }

        public void close() {
            if (this.stream != null) {
                IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{this.jsonGenerator});
                IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{this.stream});
                this.stream = null;
                this.jsonGenerator = null;
            }
        }

        public void flush() throws IOException {
            if (this.stream != null) {
                this.jsonGenerator.flush();
                this.stream.hflush();
            }
        }

        public long getLastModifiedTime() {
            return this.lastModifiedTime;
        }

        protected void prepareForWrite() throws IOException {
            this.stream = this.createLogFileStream(this.fs, this.logPath);
            this.jsonGenerator = new JsonFactory().createGenerator((OutputStream)this.stream);
            this.jsonGenerator.setPrettyPrinter(new MinimalPrettyPrinter("\n"));
            this.lastModifiedTime = Time.monotonicNow();
        }

        protected boolean writerClosed() {
            return this.stream == null;
        }

        private FSDataOutputStream createLogFileStream(FileSystem fileSystem, Path logPathToCreate) throws IOException {
            FSDataOutputStream streamToCreate;
            if (!this.isAppendSupported) {
                logPathToCreate = new Path(logPathToCreate.getParent(), logPathToCreate.getName() + "_" + Time.monotonicNow());
            }
            if (!fileSystem.exists(logPathToCreate)) {
                streamToCreate = fileSystem.create(logPathToCreate, false);
                fileSystem.setPermission(logPathToCreate, new FsPermission(416));
            } else {
                streamToCreate = fileSystem.append(logPathToCreate);
            }
            return streamToCreate;
        }

        public void lock() {
            this.fdLock.lock();
        }

        public void unlock() {
            this.fdLock.unlock();
        }

        protected JsonGenerator getJsonGenerator() {
            return this.jsonGenerator;
        }

        protected ObjectMapper getObjectMapper() {
            return this.objMapper;
        }

        protected void updateLastModifiedTime(long updatedTime) {
            this.lastModifiedTime = updatedTime;
        }
    }

    private static class EntityLogFD
    extends LogFD {
        public EntityLogFD(FileSystem fs, Path logPath, ObjectMapper objMapper, boolean isAppendSupported) throws IOException {
            super(fs, logPath, objMapper, isAppendSupported);
        }

        public void writeEntities(List<TimelineEntity> entities) throws IOException {
            if (this.writerClosed()) {
                this.prepareForWrite();
            }
            LOG.debug("Writing entity list of size {}", (Object)entities.size());
            for (TimelineEntity entity : entities) {
                this.getObjectMapper().writeValue(this.getJsonGenerator(), (Object)entity);
            }
            this.updateLastModifiedTime(Time.monotonicNow());
        }
    }

    private static class DomainLogFD
    extends LogFD {
        public DomainLogFD(FileSystem fs, Path logPath, ObjectMapper objMapper, boolean isAppendSupported) throws IOException {
            super(fs, logPath, objMapper, isAppendSupported);
        }

        public void writeDomain(TimelineDomain domain) throws IOException {
            this.getObjectMapper().writeValue(this.getJsonGenerator(), (Object)domain);
            this.updateLastModifiedTime(Time.monotonicNow());
        }
    }
}

