/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.client.api;

import java.io.IOException;
import java.nio.charset.Charset;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.jline.reader.LineReader;
import org.jline.reader.LineReaderBuilder;
import org.jline.reader.impl.LineReaderImpl;
import org.jline.terminal.Terminal;
import org.jline.terminal.TerminalBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sparkproject.jetty.websocket.api.Session;
import org.sparkproject.jetty.websocket.api.annotations.OnWebSocketClose;
import org.sparkproject.jetty.websocket.api.annotations.OnWebSocketConnect;
import org.sparkproject.jetty.websocket.api.annotations.OnWebSocketMessage;
import org.sparkproject.jetty.websocket.api.annotations.WebSocket;

@InterfaceAudience.LimitedPrivate(value={"HDFS", "MapReduce", "YARN"})
@InterfaceStability.Unstable
@WebSocket
public class ContainerShellWebSocket {
    private static final Logger LOG = LoggerFactory.getLogger(ContainerShellWebSocket.class);
    private Session mySession;
    private Terminal terminal;
    private LineReader reader;
    private boolean sttySet = false;

    @OnWebSocketMessage
    public void onText(Session session, String message) throws IOException {
        if (!this.sttySet) {
            session.getRemote().sendString("stty -echo");
            session.getRemote().sendString("\r");
            session.getRemote().flush();
            this.sttySet = true;
        }
        this.terminal.output().write(message.getBytes(Charset.forName("UTF-8")));
        this.terminal.output().flush();
    }

    @OnWebSocketConnect
    public void onConnect(Session s2) {
        this.initTerminal(s2);
        LOG.info(s2.getRemoteAddress().getHostString() + " connected!");
    }

    @OnWebSocketClose
    public void onClose(Session session, int status, String reason) {
        if (status == 1000) {
            LOG.info(session.getRemoteAddress().getHostString() + " closed, status: " + status);
        } else {
            LOG.warn(session.getRemoteAddress().getHostString() + " closed, status: " + status + " Reason: " + reason);
        }
    }

    public void run() {
        try {
            Reader consoleReader = new Reader();
            Thread inputThread = new Thread((Runnable)consoleReader, "consoleReader");
            inputThread.start();
            while (this.mySession.isOpen()) {
                String message;
                this.mySession.getRemote().flush();
                if (consoleReader.hasData()) {
                    message = consoleReader.read();
                    this.mySession.getRemote().sendString(message);
                    this.mySession.getRemote().sendString("\r");
                }
                message = "1{}";
                this.mySession.getRemote().sendString(message);
                Thread.sleep(100L);
                this.mySession.getRemote().flush();
            }
            inputThread.join();
        }
        catch (IOException | InterruptedException e) {
            try {
                this.mySession.disconnect();
            }
            catch (IOException e1) {
                LOG.error("Error closing connection: ", (Throwable)e1);
            }
        }
    }

    protected void initTerminal(Session session) {
        try {
            this.mySession = session;
            try {
                this.terminal = TerminalBuilder.builder().system(true).build();
            }
            catch (IOException t2) {
                this.terminal = TerminalBuilder.builder().system(false).streams(System.in, System.out).build();
            }
            this.reader = LineReaderBuilder.builder().terminal(this.terminal).build();
        }
        catch (IOException e) {
            session.close(1002, e.getMessage());
        }
    }

    class Reader
    implements Runnable {
        private StringBuilder sb = new StringBuilder();
        private boolean hasData = false;

        Reader() {
        }

        public String read() {
            try {
                String string = this.sb.toString();
                return string;
            }
            finally {
                this.hasData = false;
                this.sb.setLength(0);
            }
        }

        public boolean hasData() {
            return this.hasData;
        }

        @Override
        public void run() {
            while (true) {
                int c;
                if ((c = ((LineReaderImpl)ContainerShellWebSocket.this.reader).readCharacter()) == 10 || c == 13) {
                    this.hasData = true;
                    continue;
                }
                this.sb.append(new String(Character.toChars(c)));
            }
        }
    }
}

