/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.api.impl.pb.client;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import javax.net.SocketFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ipc.ProtobufRpcEngine2;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.thirdparty.protobuf.ServiceException;
import org.apache.hadoop.yarn.api.ContainerManagementProtocol;
import org.apache.hadoop.yarn.api.ContainerManagementProtocolPB;
import org.apache.hadoop.yarn.api.protocolrecords.CommitResponse;
import org.apache.hadoop.yarn.api.protocolrecords.ContainerUpdateRequest;
import org.apache.hadoop.yarn.api.protocolrecords.ContainerUpdateResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetContainerStatusesRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetContainerStatusesResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetLocalizationStatusesRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetLocalizationStatusesResponse;
import org.apache.hadoop.yarn.api.protocolrecords.IncreaseContainersResourceRequest;
import org.apache.hadoop.yarn.api.protocolrecords.IncreaseContainersResourceResponse;
import org.apache.hadoop.yarn.api.protocolrecords.ReInitializeContainerRequest;
import org.apache.hadoop.yarn.api.protocolrecords.ReInitializeContainerResponse;
import org.apache.hadoop.yarn.api.protocolrecords.ResourceLocalizationRequest;
import org.apache.hadoop.yarn.api.protocolrecords.ResourceLocalizationResponse;
import org.apache.hadoop.yarn.api.protocolrecords.RestartContainerResponse;
import org.apache.hadoop.yarn.api.protocolrecords.RollbackResponse;
import org.apache.hadoop.yarn.api.protocolrecords.SignalContainerRequest;
import org.apache.hadoop.yarn.api.protocolrecords.SignalContainerResponse;
import org.apache.hadoop.yarn.api.protocolrecords.StartContainersRequest;
import org.apache.hadoop.yarn.api.protocolrecords.StartContainersResponse;
import org.apache.hadoop.yarn.api.protocolrecords.StopContainersRequest;
import org.apache.hadoop.yarn.api.protocolrecords.StopContainersResponse;
import org.apache.hadoop.yarn.api.protocolrecords.impl.pb.CommitResponsePBImpl;
import org.apache.hadoop.yarn.api.protocolrecords.impl.pb.ContainerUpdateRequestPBImpl;
import org.apache.hadoop.yarn.api.protocolrecords.impl.pb.ContainerUpdateResponsePBImpl;
import org.apache.hadoop.yarn.api.protocolrecords.impl.pb.GetContainerStatusesRequestPBImpl;
import org.apache.hadoop.yarn.api.protocolrecords.impl.pb.GetContainerStatusesResponsePBImpl;
import org.apache.hadoop.yarn.api.protocolrecords.impl.pb.GetLocalizationStatusesRequestPBImpl;
import org.apache.hadoop.yarn.api.protocolrecords.impl.pb.GetLocalizationStatusesResponsePBImpl;
import org.apache.hadoop.yarn.api.protocolrecords.impl.pb.ReInitializeContainerRequestPBImpl;
import org.apache.hadoop.yarn.api.protocolrecords.impl.pb.ReInitializeContainerResponsePBImpl;
import org.apache.hadoop.yarn.api.protocolrecords.impl.pb.ResourceLocalizationRequestPBImpl;
import org.apache.hadoop.yarn.api.protocolrecords.impl.pb.ResourceLocalizationResponsePBImpl;
import org.apache.hadoop.yarn.api.protocolrecords.impl.pb.RestartContainerResponsePBImpl;
import org.apache.hadoop.yarn.api.protocolrecords.impl.pb.RollbackResponsePBImpl;
import org.apache.hadoop.yarn.api.protocolrecords.impl.pb.SignalContainerRequestPBImpl;
import org.apache.hadoop.yarn.api.protocolrecords.impl.pb.SignalContainerResponsePBImpl;
import org.apache.hadoop.yarn.api.protocolrecords.impl.pb.StartContainersRequestPBImpl;
import org.apache.hadoop.yarn.api.protocolrecords.impl.pb.StartContainersResponsePBImpl;
import org.apache.hadoop.yarn.api.protocolrecords.impl.pb.StopContainersRequestPBImpl;
import org.apache.hadoop.yarn.api.protocolrecords.impl.pb.StopContainersResponsePBImpl;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.impl.pb.ProtoUtils;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.ipc.RPCUtil;
import org.apache.hadoop.yarn.proto.YarnProtos;
import org.apache.hadoop.yarn.proto.YarnServiceProtos;

@InterfaceAudience.Private
public class ContainerManagementProtocolPBClientImpl
implements ContainerManagementProtocol,
Closeable {
    static final String NM_COMMAND_TIMEOUT = "yarn.rpc.nm-command-timeout";
    static final int DEFAULT_COMMAND_TIMEOUT = 60000;
    private ContainerManagementProtocolPB proxy;

    public ContainerManagementProtocolPBClientImpl(long clientVersion, InetSocketAddress addr, Configuration conf) throws IOException {
        RPC.setProtocolEngine((Configuration)conf, ContainerManagementProtocolPB.class, ProtobufRpcEngine2.class);
        UserGroupInformation ugi = UserGroupInformation.getCurrentUser();
        int expireIntvl = conf.getInt(NM_COMMAND_TIMEOUT, 60000);
        this.proxy = (ContainerManagementProtocolPB)RPC.getProxy(ContainerManagementProtocolPB.class, (long)clientVersion, (InetSocketAddress)addr, (UserGroupInformation)ugi, (Configuration)conf, (SocketFactory)NetUtils.getDefaultSocketFactory((Configuration)conf), (int)expireIntvl);
    }

    @Override
    public void close() {
        if (this.proxy != null) {
            RPC.stopProxy((Object)this.proxy);
        }
    }

    @Override
    public StartContainersResponse startContainers(StartContainersRequest requests) throws YarnException, IOException {
        YarnServiceProtos.StartContainersRequestProto requestProto = ((StartContainersRequestPBImpl)requests).getProto();
        try {
            return new StartContainersResponsePBImpl(this.proxy.startContainers(null, requestProto));
        }
        catch (ServiceException e) {
            RPCUtil.unwrapAndThrowException(e);
            return null;
        }
    }

    @Override
    public StopContainersResponse stopContainers(StopContainersRequest requests) throws YarnException, IOException {
        YarnServiceProtos.StopContainersRequestProto requestProto = ((StopContainersRequestPBImpl)requests).getProto();
        try {
            return new StopContainersResponsePBImpl(this.proxy.stopContainers(null, requestProto));
        }
        catch (ServiceException e) {
            RPCUtil.unwrapAndThrowException(e);
            return null;
        }
    }

    @Override
    public GetContainerStatusesResponse getContainerStatuses(GetContainerStatusesRequest request) throws YarnException, IOException {
        YarnServiceProtos.GetContainerStatusesRequestProto requestProto = ((GetContainerStatusesRequestPBImpl)request).getProto();
        try {
            return new GetContainerStatusesResponsePBImpl(this.proxy.getContainerStatuses(null, requestProto));
        }
        catch (ServiceException e) {
            RPCUtil.unwrapAndThrowException(e);
            return null;
        }
    }

    @Override
    @Deprecated
    public IncreaseContainersResourceResponse increaseContainersResource(IncreaseContainersResourceRequest request) throws YarnException, IOException {
        try {
            ContainerUpdateRequest req = ContainerUpdateRequest.newInstance(request.getContainersToIncrease());
            YarnServiceProtos.ContainerUpdateRequestProto reqProto = ((ContainerUpdateRequestPBImpl)req).getProto();
            ContainerUpdateResponsePBImpl resp = new ContainerUpdateResponsePBImpl(this.proxy.updateContainer(null, reqProto));
            return IncreaseContainersResourceResponse.newInstance(((ContainerUpdateResponse)resp).getSuccessfullyUpdatedContainers(), ((ContainerUpdateResponse)resp).getFailedRequests());
        }
        catch (ServiceException e) {
            RPCUtil.unwrapAndThrowException(e);
            return null;
        }
    }

    @Override
    public ContainerUpdateResponse updateContainer(ContainerUpdateRequest request) throws YarnException, IOException {
        YarnServiceProtos.ContainerUpdateRequestProto requestProto = ((ContainerUpdateRequestPBImpl)request).getProto();
        try {
            return new ContainerUpdateResponsePBImpl(this.proxy.updateContainer(null, requestProto));
        }
        catch (ServiceException e) {
            RPCUtil.unwrapAndThrowException(e);
            return null;
        }
    }

    @Override
    public SignalContainerResponse signalToContainer(SignalContainerRequest request) throws YarnException, IOException {
        YarnServiceProtos.SignalContainerRequestProto requestProto = ((SignalContainerRequestPBImpl)request).getProto();
        try {
            return new SignalContainerResponsePBImpl(this.proxy.signalToContainer(null, requestProto));
        }
        catch (ServiceException e) {
            RPCUtil.unwrapAndThrowException(e);
            return null;
        }
    }

    @Override
    public ResourceLocalizationResponse localize(ResourceLocalizationRequest request) throws YarnException, IOException {
        YarnServiceProtos.ResourceLocalizationRequestProto requestProto = ((ResourceLocalizationRequestPBImpl)request).getProto();
        try {
            return new ResourceLocalizationResponsePBImpl(this.proxy.localize(null, requestProto));
        }
        catch (ServiceException e) {
            RPCUtil.unwrapAndThrowException(e);
            return null;
        }
    }

    @Override
    public ReInitializeContainerResponse reInitializeContainer(ReInitializeContainerRequest request) throws YarnException, IOException {
        YarnServiceProtos.ReInitializeContainerRequestProto requestProto = ((ReInitializeContainerRequestPBImpl)request).getProto();
        try {
            return new ReInitializeContainerResponsePBImpl(this.proxy.reInitializeContainer(null, requestProto));
        }
        catch (ServiceException e) {
            RPCUtil.unwrapAndThrowException(e);
            return null;
        }
    }

    @Override
    public RestartContainerResponse restartContainer(ContainerId containerId) throws YarnException, IOException {
        YarnProtos.ContainerIdProto containerIdProto = ProtoUtils.convertToProtoFormat(containerId);
        try {
            return new RestartContainerResponsePBImpl(this.proxy.restartContainer(null, containerIdProto));
        }
        catch (ServiceException e) {
            RPCUtil.unwrapAndThrowException(e);
            return null;
        }
    }

    @Override
    public RollbackResponse rollbackLastReInitialization(ContainerId containerId) throws YarnException, IOException {
        YarnProtos.ContainerIdProto containerIdProto = ProtoUtils.convertToProtoFormat(containerId);
        try {
            return new RollbackResponsePBImpl(this.proxy.rollbackLastReInitialization(null, containerIdProto));
        }
        catch (ServiceException e) {
            RPCUtil.unwrapAndThrowException(e);
            return null;
        }
    }

    @Override
    public CommitResponse commitLastReInitialization(ContainerId containerId) throws YarnException, IOException {
        YarnProtos.ContainerIdProto containerIdProto = ProtoUtils.convertToProtoFormat(containerId);
        try {
            return new CommitResponsePBImpl(this.proxy.commitLastReInitialization(null, containerIdProto));
        }
        catch (ServiceException e) {
            RPCUtil.unwrapAndThrowException(e);
            return null;
        }
    }

    @Override
    public GetLocalizationStatusesResponse getLocalizationStatuses(GetLocalizationStatusesRequest request) throws YarnException, IOException {
        YarnServiceProtos.GetLocalizationStatusesRequestProto requestProto = ((GetLocalizationStatusesRequestPBImpl)request).getProto();
        try {
            return new GetLocalizationStatusesResponsePBImpl(this.proxy.getLocalizationStatuses(null, requestProto));
        }
        catch (ServiceException e) {
            RPCUtil.unwrapAndThrowException(e);
            return null;
        }
    }
}

