/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.parquet;

import java.io.Serializable;
import java.util.Locale;
import org.apache.hadoop.conf.Configuration;
import org.apache.parquet.column.ColumnDescriptor;
import org.apache.parquet.io.ColumnIO;
import org.apache.parquet.io.ColumnIOFactory;
import org.apache.parquet.io.GroupColumnIO;
import org.apache.parquet.io.MessageColumnIO;
import org.apache.parquet.io.PrimitiveColumnIO;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.LogicalTypeAnnotation;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.execution.datasources.parquet.ParquetColumn;
import org.apache.spark.sql.execution.datasources.parquet.ParquetColumn$;
import org.apache.spark.sql.execution.datasources.parquet.ParquetSchemaConverter$;
import org.apache.spark.sql.execution.datasources.parquet.ParquetToSparkSchemaConverter$;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.TimestampNTZType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.sql.types.UserDefinedType;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005me\u0001\u0002\u0010 \u00019B\u0001\"\u000e\u0001\u0003\u0002\u0003\u0006IA\u000e\u0005\ts\u0001\u0011\t\u0011)A\u0005m!A!\b\u0001B\u0001B\u0003%a\u0007\u0003\u0005<\u0001\t\u0005\t\u0015!\u00037\u0011!a\u0004A!A!\u0002\u00131\u0004\"B\u001f\u0001\t\u0003q\u0004\"B\u001f\u0001\t\u00031\u0005\"B\u001f\u0001\t\u0003y\u0005\"\u0002-\u0001\t\u0003I\u0006\"B5\u0001\t\u0003Q\u0007b\u0002;\u0001#\u0003%\t!\u001e\u0005\b\u0003\u0003\u0001A\u0011BA\u0002\u0011!\t9\u0002AI\u0001\n\u0013)\bbBA\r\u0001\u0011%\u00111\u0004\u0005\b\u0003o\u0001A\u0011AA\u001d\u0011%\t\t\u0006AI\u0001\n\u0003\t\u0019\u0006C\u0004\u0002X\u0001!I!!\u0017\t\u0013\u0005\u001d\u0004!%A\u0005\n\u0005M\u0003bBA5\u0001\u0011%\u00111\u000e\u0005\n\u0003c\u0002\u0011\u0013!C\u0005\u0003'B\u0001\"a\u001d\u0001\t\u0003y\u0012QO\u0004\n\u0003\u000b{\u0012\u0011!E\u0001\u0003\u000f3\u0001BH\u0010\u0002\u0002#\u0005\u0011\u0011\u0012\u0005\u0007{]!\t!a#\t\u0013\u00055u#%A\u0005\u0002\u0005=\u0005\"CAJ/E\u0005I\u0011AAH\u0011%\t)jFI\u0001\n\u0003\ty\tC\u0005\u0002\u0018^\t\n\u0011\"\u0001\u0002\u0010\"I\u0011\u0011T\f\u0012\u0002\u0013\u0005\u0011q\u0012\u0002\u001e!\u0006\u0014\u0018/^3u)>\u001c\u0006/\u0019:l'\u000eDW-\\1D_:4XM\u001d;fe*\u0011\u0001%I\u0001\ba\u0006\u0014\u0018/^3u\u0015\t\u00113%A\u0006eCR\f7o\\;sG\u0016\u001c(B\u0001\u0013&\u0003%)\u00070Z2vi&|gN\u0003\u0002'O\u0005\u00191/\u001d7\u000b\u0005!J\u0013!B:qCJ\\'B\u0001\u0016,\u0003\u0019\t\u0007/Y2iK*\tA&A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001_A\u0011\u0001gM\u0007\u0002c)\t!'A\u0003tG\u0006d\u0017-\u0003\u00025c\t1\u0011I\\=SK\u001a\fA#Y:tk6,')\u001b8befL5o\u0015;sS:<\u0007C\u0001\u00198\u0013\tA\u0014GA\u0004C_>dW-\u00198\u0002-\u0005\u001c8/^7f\u0013:$\u0018HN%t)&lWm\u001d;b[B\fQbY1tKN+gn]5uSZ,\u0017!E5oM\u0016\u0014H+[7fgR\fW\u000e\u001d(U5\u0006Ya.\u00198pg\u0006\u001bHj\u001c8h\u0003\u0019a\u0014N\\5u}Q1q(\u0011\"D\t\u0016\u0003\"\u0001\u0011\u0001\u000e\u0003}Aq!\u000e\u0004\u0011\u0002\u0003\u0007a\u0007C\u0004:\rA\u0005\t\u0019\u0001\u001c\t\u000fi2\u0001\u0013!a\u0001m!91H\u0002I\u0001\u0002\u00041\u0004b\u0002\u001f\u0007!\u0003\u0005\rA\u000e\u000b\u0003\u007f\u001dCQ\u0001S\u0004A\u0002%\u000bAaY8oMB\u0011!*T\u0007\u0002\u0017*\u0011A*J\u0001\tS:$XM\u001d8bY&\u0011aj\u0013\u0002\b'Fc5i\u001c8g)\ty\u0004\u000bC\u0003I\u0011\u0001\u0007\u0011\u000b\u0005\u0002S-6\t1K\u0003\u0002I)*\u0011Q+K\u0001\u0007Q\u0006$wn\u001c9\n\u0005]\u001b&!D\"p]\u001aLw-\u001e:bi&|g.A\u0004d_:4XM\u001d;\u0015\u0005i\u0003\u0007CA._\u001b\u0005a&BA/&\u0003\u0015!\u0018\u0010]3t\u0013\tyFL\u0001\u0006TiJ,8\r\u001e+za\u0016DQ!Y\u0005A\u0002\t\fQ\u0002]1scV,GoU2iK6\f\u0007CA2h\u001b\u0005!'BA3g\u0003\u0019\u00198\r[3nC*\u0011\u0001%K\u0005\u0003Q\u0012\u00141\"T3tg\u0006<W\rV=qK\u0006!2m\u001c8wKJ$\b+\u0019:rk\u0016$8i\u001c7v[:$2a\u001b8p!\t\u0001E.\u0003\u0002n?\ti\u0001+\u0019:rk\u0016$8i\u001c7v[:DQ!\u0019\u0006A\u0002\tDq\u0001\u001d\u0006\u0011\u0002\u0003\u0007\u0011/A\bta\u0006\u00148NU3bIN\u001b\u0007.Z7b!\r\u0001$OW\u0005\u0003gF\u0012aa\u00149uS>t\u0017AH2p]Z,'\u000f\u001e)beF,X\r^\"pYVlg\u000e\n3fM\u0006,H\u000e\u001e\u00133+\u00051(FA9xW\u0005A\bCA=\u007f\u001b\u0005Q(BA>}\u0003%)hn\u00195fG.,GM\u0003\u0002~c\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\u0005}T(!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006y1m\u001c8wKJ$\u0018J\u001c;fe:\fG\u000eF\u0003l\u0003\u000b\t)\u0002C\u0004\u0002\b1\u0001\r!!\u0003\u0002\u0017\u001d\u0014x.\u001e9D_2,XN\u001c\t\u0005\u0003\u0017\t\t\"\u0004\u0002\u0002\u000e)\u0019\u0011q\u00024\u0002\u0005%|\u0017\u0002BA\n\u0003\u001b\u0011Qb\u0012:pkB\u001cu\u000e\\;n]&{\u0005b\u00029\r!\u0003\u0005\r!]\u0001\u001aG>tg/\u001a:u\u0013:$XM\u001d8bY\u0012\"WMZ1vYR$#'\u0001\no_Jl\u0017\r\\5{K\u001aKW\r\u001c3OC6,G\u0003BA\u000f\u0003g\u0001B!a\b\u0002.9!\u0011\u0011EA\u0015!\r\t\u0019#M\u0007\u0003\u0003KQ1!a\n.\u0003\u0019a$o\\8u}%\u0019\u00111F\u0019\u0002\rA\u0013X\rZ3g\u0013\u0011\ty#!\r\u0003\rM#(/\u001b8h\u0015\r\tY#\r\u0005\b\u0003kq\u0001\u0019AA\u000f\u0003\u0011q\u0017-\\3\u0002\u0019\r|gN^3si\u001aKW\r\u001c3\u0015\u000b-\fY$!\u0012\t\u000f\u0005ur\u00021\u0001\u0002@\u0005)a-[3mIB!\u00111BA!\u0013\u0011\t\u0019%!\u0004\u0003\u0011\r{G.^7o\u0013>C\u0011\"a\u0012\u0010!\u0003\u0005\r!!\u0013\u0002\u001bM\u0004\u0018M]6SK\u0006$G+\u001f9f!\u0011\u0001$/a\u0013\u0011\u0007m\u000bi%C\u0002\u0002Pq\u0013\u0001\u0002R1uCRK\b/Z\u0001\u0017G>tg/\u001a:u\r&,G\u000e\u001a\u0013eK\u001a\fW\u000f\u001c;%eU\u0011\u0011Q\u000b\u0016\u0004\u0003\u0013:\u0018!F2p]Z,'\u000f\u001e)sS6LG/\u001b<f\r&,G\u000e\u001a\u000b\u0006W\u0006m\u0013Q\r\u0005\b\u0003;\n\u0002\u0019AA0\u0003=\u0001(/[7ji&4XmQ8mk6t\u0007\u0003BA\u0006\u0003CJA!a\u0019\u0002\u000e\t\t\u0002K]5nSRLg/Z\"pYVlg.S(\t\u0013\u0005\u001d\u0013\u0003%AA\u0002\u0005%\u0013aH2p]Z,'\u000f\u001e)sS6LG/\u001b<f\r&,G\u000e\u001a\u0013eK\u001a\fW\u000f\u001c;%e\u0005\t2m\u001c8wKJ$xI]8va\u001aKW\r\u001c3\u0015\u000b-\fi'a\u001c\t\u000f\u0005\u001d1\u00031\u0001\u0002\n!I\u0011qI\n\u0011\u0002\u0003\u0007\u0011\u0011J\u0001\u001cG>tg/\u001a:u\u000fJ|W\u000f\u001d$jK2$G\u0005Z3gCVdG\u000f\n\u001a\u0002\u001b%\u001cX\t\\3nK:$H+\u001f9f)\u00151\u0014qOAA\u0011\u001d\tI(\u0006a\u0001\u0003w\nAB]3qK\u0006$X\r\u001a+za\u0016\u00042aYA?\u0013\r\ty\b\u001a\u0002\u0005)f\u0004X\rC\u0004\u0002\u0004V\u0001\r!!\b\u0002\u0015A\f'/\u001a8u\u001d\u0006lW-A\u000fQCJ\fX/\u001a;U_N\u0003\u0018M]6TG\",W.Y\"p]Z,'\u000f^3s!\t\u0001uc\u0005\u0002\u0018_Q\u0011\u0011qQ\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u0005E%F\u0001\u001cx\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%e\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIM\n1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\"\u0014a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$S\u0007")
public class ParquetToSparkSchemaConverter {
    private final boolean assumeBinaryIsString;
    private final boolean assumeInt96IsTimestamp;
    private final boolean caseSensitive;
    private final boolean inferTimestampNTZ;
    private final boolean nanosAsLong;

    public static boolean $lessinit$greater$default$5() {
        return ParquetToSparkSchemaConverter$.MODULE$.$lessinit$greater$default$5();
    }

    public static boolean $lessinit$greater$default$4() {
        return ParquetToSparkSchemaConverter$.MODULE$.$lessinit$greater$default$4();
    }

    public static boolean $lessinit$greater$default$3() {
        return ParquetToSparkSchemaConverter$.MODULE$.$lessinit$greater$default$3();
    }

    public static boolean $lessinit$greater$default$2() {
        return ParquetToSparkSchemaConverter$.MODULE$.$lessinit$greater$default$2();
    }

    public static boolean $lessinit$greater$default$1() {
        return ParquetToSparkSchemaConverter$.MODULE$.$lessinit$greater$default$1();
    }

    public StructType convert(MessageType parquetSchema) {
        MessageColumnIO column = new ColumnIOFactory().getColumnIO(parquetSchema);
        ParquetColumn converted = this.convertInternal((GroupColumnIO)column, this.convertInternal$default$2());
        return (StructType)converted.sparkType();
    }

    public ParquetColumn convertParquetColumn(MessageType parquetSchema, Option<StructType> sparkReadSchema) {
        MessageColumnIO column = new ColumnIOFactory().getColumnIO(parquetSchema);
        return this.convertInternal((GroupColumnIO)column, sparkReadSchema);
    }

    public Option<StructType> convertParquetColumn$default$2() {
        return None$.MODULE$;
    }

    private ParquetColumn convertInternal(GroupColumnIO groupColumn, Option<StructType> sparkReadSchema) {
        Option schemaMapOpt = sparkReadSchema.map((Function1 & Serializable & scala.Serializable)schema -> ((TraversableOnce)schema.map((Function1 & Serializable & scala.Serializable)f -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.normalizeFieldName(f.name())), f), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms()));
        IndexedSeq converted = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), groupColumn.getChildrenCount()).map((Function1 & Serializable & scala.Serializable)i -> ParquetToSparkSchemaConverter.$anonfun$convertInternal$3(this, groupColumn, schemaMapOpt, BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom());
        return ParquetColumn$.MODULE$.apply((DataType)StructType$.MODULE$.apply((Seq)converted.map((Function1 & Serializable & scala.Serializable)x$3 -> (StructField)x$3._1(), IndexedSeq$.MODULE$.canBuildFrom())), groupColumn, (Seq<ParquetColumn>)((Seq)converted.map((Function1 & Serializable & scala.Serializable)x$4 -> (ParquetColumn)x$4._2(), IndexedSeq$.MODULE$.canBuildFrom())));
    }

    private Option<StructType> convertInternal$default$2() {
        return None$.MODULE$;
    }

    private String normalizeFieldName(String name) {
        if (this.caseSensitive) {
            return name;
        }
        return name.toLowerCase(Locale.ROOT);
    }

    public ParquetColumn convertField(ColumnIO field, Option<DataType> sparkReadType) {
        Option targetType = sparkReadType.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            DataType dataType = x0$1;
            if (dataType instanceof UserDefinedType) {
                UserDefinedType userDefinedType = (UserDefinedType)dataType;
                return userDefinedType.sqlType();
            }
            return dataType;
        });
        ColumnIO columnIO = field;
        if (columnIO instanceof PrimitiveColumnIO) {
            PrimitiveColumnIO primitiveColumnIO = (PrimitiveColumnIO)columnIO;
            return this.convertPrimitiveField(primitiveColumnIO, (Option<DataType>)targetType);
        }
        if (columnIO instanceof GroupColumnIO) {
            GroupColumnIO groupColumnIO = (GroupColumnIO)columnIO;
            return this.convertGroupField(groupColumnIO, (Option<DataType>)targetType);
        }
        throw new MatchError((Object)columnIO);
    }

    public Option<DataType> convertField$default$2() {
        return None$.MODULE$;
    }

    private ParquetColumn convertPrimitiveField(PrimitiveColumnIO primitiveColumn, Option<DataType> sparkReadType) {
        PrimitiveType parquetType = primitiveColumn.getType().asPrimitiveType();
        LogicalTypeAnnotation typeAnnotation = primitiveColumn.getType().getLogicalTypeAnnotation();
        PrimitiveType.PrimitiveTypeName typeName = primitiveColumn.getPrimitive();
        DataType sparkType = (DataType)sparkReadType.getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            PrimitiveType.PrimitiveTypeName primitiveTypeName;
            block51: {
                LogicalTypeAnnotation.TimestampLogicalTypeAnnotation timestampLogicalTypeAnnotation;
                boolean bl;
                block52: {
                    block53: {
                        primitiveTypeName = typeName;
                        if (PrimitiveType.PrimitiveTypeName.BOOLEAN.equals(primitiveTypeName)) {
                            return BooleanType$.MODULE$;
                        }
                        if (PrimitiveType.PrimitiveTypeName.FLOAT.equals(primitiveTypeName)) {
                            return FloatType$.MODULE$;
                        }
                        if (PrimitiveType.PrimitiveTypeName.DOUBLE.equals(primitiveTypeName)) {
                            return DoubleType$.MODULE$;
                        }
                        if (PrimitiveType.PrimitiveTypeName.INT32.equals(primitiveTypeName)) {
                            boolean bl2 = false;
                            LogicalTypeAnnotation.IntLogicalTypeAnnotation intLogicalTypeAnnotation = null;
                            LogicalTypeAnnotation logicalTypeAnnotation = typeAnnotation;
                            if (logicalTypeAnnotation instanceof LogicalTypeAnnotation.IntLogicalTypeAnnotation) {
                                bl2 = true;
                                intLogicalTypeAnnotation = (LogicalTypeAnnotation.IntLogicalTypeAnnotation)logicalTypeAnnotation;
                                if (intLogicalTypeAnnotation.isSigned()) {
                                    int n = intLogicalTypeAnnotation.getBitWidth();
                                    switch (n) {
                                        case 8: {
                                            return ByteType$.MODULE$;
                                        }
                                        case 16: {
                                            return ShortType$.MODULE$;
                                        }
                                        case 32: {
                                            return IntegerType$.MODULE$;
                                        }
                                    }
                                    throw ParquetToSparkSchemaConverter.illegalType$1(typeAnnotation, typeName);
                                }
                            }
                            if (logicalTypeAnnotation == null) {
                                return IntegerType$.MODULE$;
                            }
                            if (logicalTypeAnnotation instanceof LogicalTypeAnnotation.DateLogicalTypeAnnotation) {
                                return DateType$.MODULE$;
                            }
                            if (logicalTypeAnnotation instanceof LogicalTypeAnnotation.DecimalLogicalTypeAnnotation) {
                                return ParquetToSparkSchemaConverter.makeDecimalType$1(Decimal$.MODULE$.MAX_INT_DIGITS(), typeAnnotation, typeName);
                            }
                            if (bl2 && !intLogicalTypeAnnotation.isSigned()) {
                                int n = intLogicalTypeAnnotation.getBitWidth();
                                switch (n) {
                                    case 8: {
                                        return ShortType$.MODULE$;
                                    }
                                    case 16: {
                                        return IntegerType$.MODULE$;
                                    }
                                    case 32: {
                                        return LongType$.MODULE$;
                                    }
                                }
                                throw ParquetToSparkSchemaConverter.illegalType$1(typeAnnotation, typeName);
                            }
                            if (logicalTypeAnnotation instanceof LogicalTypeAnnotation.TimestampLogicalTypeAnnotation) {
                                LogicalTypeAnnotation.TimestampLogicalTypeAnnotation timestampLogicalTypeAnnotation2 = (LogicalTypeAnnotation.TimestampLogicalTypeAnnotation)logicalTypeAnnotation;
                                LogicalTypeAnnotation.TimeUnit timeUnit = timestampLogicalTypeAnnotation2.getUnit();
                                LogicalTypeAnnotation.TimeUnit timeUnit2 = LogicalTypeAnnotation.TimeUnit.MILLIS;
                                if (!(timeUnit != null ? !timeUnit.equals(timeUnit2) : timeUnit2 != null)) {
                                    throw ParquetToSparkSchemaConverter.typeNotImplemented$1(typeAnnotation, typeName);
                                }
                            }
                            throw ParquetToSparkSchemaConverter.illegalType$1(typeAnnotation, typeName);
                        }
                        if (!PrimitiveType.PrimitiveTypeName.INT64.equals(primitiveTypeName)) break block51;
                        boolean bl3 = false;
                        LogicalTypeAnnotation.IntLogicalTypeAnnotation intLogicalTypeAnnotation = null;
                        bl = false;
                        timestampLogicalTypeAnnotation = null;
                        LogicalTypeAnnotation logicalTypeAnnotation = typeAnnotation;
                        if (logicalTypeAnnotation instanceof LogicalTypeAnnotation.IntLogicalTypeAnnotation) {
                            bl3 = true;
                            intLogicalTypeAnnotation = (LogicalTypeAnnotation.IntLogicalTypeAnnotation)logicalTypeAnnotation;
                            if (intLogicalTypeAnnotation.isSigned()) {
                                int n = intLogicalTypeAnnotation.getBitWidth();
                                switch (n) {
                                    case 64: {
                                        return LongType$.MODULE$;
                                    }
                                }
                                throw ParquetToSparkSchemaConverter.illegalType$1(typeAnnotation, typeName);
                            }
                        }
                        if (logicalTypeAnnotation == null) {
                            return LongType$.MODULE$;
                        }
                        if (logicalTypeAnnotation instanceof LogicalTypeAnnotation.DecimalLogicalTypeAnnotation) {
                            return ParquetToSparkSchemaConverter.makeDecimalType$1(Decimal$.MODULE$.MAX_LONG_DIGITS(), typeAnnotation, typeName);
                        }
                        if (bl3 && !intLogicalTypeAnnotation.isSigned()) {
                            int n = intLogicalTypeAnnotation.getBitWidth();
                            switch (n) {
                                case 64: {
                                    return new DecimalType(20, 0);
                                }
                            }
                            throw ParquetToSparkSchemaConverter.illegalType$1(typeAnnotation, typeName);
                        }
                        if (!(logicalTypeAnnotation instanceof LogicalTypeAnnotation.TimestampLogicalTypeAnnotation)) break block52;
                        bl = true;
                        timestampLogicalTypeAnnotation = (LogicalTypeAnnotation.TimestampLogicalTypeAnnotation)logicalTypeAnnotation;
                        LogicalTypeAnnotation.TimeUnit timeUnit = timestampLogicalTypeAnnotation.getUnit();
                        LogicalTypeAnnotation.TimeUnit timeUnit3 = LogicalTypeAnnotation.TimeUnit.MICROS;
                        if (!(timeUnit == null ? timeUnit3 != null : !timeUnit.equals(timeUnit3))) break block53;
                        LogicalTypeAnnotation.TimeUnit timeUnit4 = timestampLogicalTypeAnnotation.getUnit();
                        LogicalTypeAnnotation.TimeUnit timeUnit5 = LogicalTypeAnnotation.TimeUnit.MILLIS;
                        if (timeUnit4 != null ? !timeUnit4.equals(timeUnit5) : timeUnit5 != null) break block52;
                    }
                    if (timestampLogicalTypeAnnotation.isAdjustedToUTC() || !$this.inferTimestampNTZ) {
                        return TimestampType$.MODULE$;
                    }
                    return TimestampNTZType$.MODULE$;
                }
                if (bl) {
                    LogicalTypeAnnotation.TimeUnit timeUnit = timestampLogicalTypeAnnotation.getUnit();
                    LogicalTypeAnnotation.TimeUnit timeUnit6 = LogicalTypeAnnotation.TimeUnit.NANOS;
                    if (!(timeUnit != null ? !timeUnit.equals(timeUnit6) : timeUnit6 != null) && $this.nanosAsLong) {
                        return LongType$.MODULE$;
                    }
                }
                throw ParquetToSparkSchemaConverter.illegalType$1(typeAnnotation, typeName);
            }
            if (PrimitiveType.PrimitiveTypeName.INT96.equals(primitiveTypeName)) {
                ParquetSchemaConverter$.MODULE$.checkConversionRequirement((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> $this.assumeInt96IsTimestamp, new StringBuilder(88).append("INT96 is not supported unless it's interpreted as timestamp. ").append("Please try to set ").append(SQLConf$.MODULE$.PARQUET_INT96_AS_TIMESTAMP().key()).append(" to true.").toString());
                return TimestampType$.MODULE$;
            }
            if (PrimitiveType.PrimitiveTypeName.BINARY.equals(primitiveTypeName)) {
                boolean bl = false;
                LogicalTypeAnnotation logicalTypeAnnotation = null;
                LogicalTypeAnnotation logicalTypeAnnotation2 = typeAnnotation;
                if (logicalTypeAnnotation2 instanceof LogicalTypeAnnotation.StringLogicalTypeAnnotation ? true : (logicalTypeAnnotation2 instanceof LogicalTypeAnnotation.EnumLogicalTypeAnnotation ? true : logicalTypeAnnotation2 instanceof LogicalTypeAnnotation.JsonLogicalTypeAnnotation)) {
                    return StringType$.MODULE$;
                }
                if (logicalTypeAnnotation2 == null) {
                    bl = true;
                    logicalTypeAnnotation = logicalTypeAnnotation2;
                    if ($this.assumeBinaryIsString) {
                        return StringType$.MODULE$;
                    }
                }
                if (bl) {
                    return BinaryType$.MODULE$;
                }
                if (logicalTypeAnnotation2 instanceof LogicalTypeAnnotation.BsonLogicalTypeAnnotation) {
                    return BinaryType$.MODULE$;
                }
                if (logicalTypeAnnotation2 instanceof LogicalTypeAnnotation.DecimalLogicalTypeAnnotation) {
                    return ParquetToSparkSchemaConverter.makeDecimalType$1(ParquetToSparkSchemaConverter.makeDecimalType$default$1$1(), typeAnnotation, typeName);
                }
                throw ParquetToSparkSchemaConverter.illegalType$1(typeAnnotation, typeName);
            }
            if (PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY.equals(primitiveTypeName)) {
                LogicalTypeAnnotation logicalTypeAnnotation = typeAnnotation;
                if (logicalTypeAnnotation instanceof LogicalTypeAnnotation.DecimalLogicalTypeAnnotation) {
                    return ParquetToSparkSchemaConverter.makeDecimalType$1(Decimal$.MODULE$.maxPrecisionForBytes(parquetType.getTypeLength()), typeAnnotation, typeName);
                }
                if (logicalTypeAnnotation instanceof LogicalTypeAnnotation.IntervalLogicalTypeAnnotation) {
                    throw ParquetToSparkSchemaConverter.typeNotImplemented$1(typeAnnotation, typeName);
                }
                if (logicalTypeAnnotation == null) {
                    return BinaryType$.MODULE$;
                }
                throw ParquetToSparkSchemaConverter.illegalType$1(typeAnnotation, typeName);
            }
            throw ParquetToSparkSchemaConverter.illegalType$1(typeAnnotation, typeName);
        });
        return ParquetColumn$.MODULE$.apply(sparkType, primitiveColumn);
    }

    private Option<DataType> convertPrimitiveField$default$2() {
        return None$.MODULE$;
    }

    private ParquetColumn convertGroupField(GroupColumnIO groupColumn, Option<DataType> sparkReadType) {
        GroupType field = groupColumn.getType().asGroupType();
        return (ParquetColumn)Option$.MODULE$.apply((Object)field.getLogicalTypeAnnotation()).fold((Function0 & Serializable & scala.Serializable)() -> this.convertInternal(groupColumn, (Option<StructType>)sparkReadType.map((Function1 & Serializable & scala.Serializable)x$5 -> (StructType)x$5)), (Function1 & Serializable & scala.Serializable)x0$1 -> {
            LogicalTypeAnnotation logicalTypeAnnotation = x0$1;
            if (logicalTypeAnnotation instanceof LogicalTypeAnnotation.ListLogicalTypeAnnotation) {
                ParquetSchemaConverter$.MODULE$.checkConversionRequirement((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> field.getFieldCount() == 1, new StringBuilder(18).append("Invalid list type ").append(field).toString());
                ParquetSchemaConverter$.MODULE$.checkConversionRequirement((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> sparkReadType.forall((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)ParquetToSparkSchemaConverter.$anonfun$convertGroupField$6(x$6))), new StringBuilder(61).append("Invalid Spark read type: expected ").append(field).append(" to be list type but found ").append(sparkReadType).toString());
                ColumnIO repeated = groupColumn.getChild(0);
                Type repeatedType = repeated.getType();
                ParquetSchemaConverter$.MODULE$.checkConversionRequirement((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> repeatedType.isRepetition(Type.Repetition.REPEATED), new StringBuilder(18).append("Invalid list type ").append(field).toString());
                Option sparkReadElementType = sparkReadType.map((Function1 & Serializable & scala.Serializable)x$7 -> ((ArrayType)x$7).elementType());
                if (this.isElementType(repeatedType, field.getName())) {
                    ObjectRef converted = ObjectRef.create((Object)this.convertField(repeated, (Option<DataType>)sparkReadElementType));
                    DataType convertedType = (DataType)sparkReadElementType.getOrElse((Function0 & Serializable & scala.Serializable)() -> ((ParquetColumn)converted$1.elem).sparkType());
                    if (repeatedType.isPrimitive()) {
                        ParquetColumn qual$1 = (ParquetColumn)converted.elem;
                        boolean x$1 = true;
                        DataType x$2 = qual$1.copy$default$1();
                        Option<ColumnDescriptor> x$3 = qual$1.copy$default$2();
                        int x$4 = qual$1.copy$default$3();
                        int x$5 = qual$1.copy$default$4();
                        Seq<String> x$6 = qual$1.copy$default$6();
                        Seq<ParquetColumn> x$72 = qual$1.copy$default$7();
                        converted.elem = qual$1.copy(x$2, x$3, x$4, x$5, x$1, x$6, x$72);
                    }
                    return ParquetColumn$.MODULE$.apply((DataType)new ArrayType(convertedType, false), groupColumn, (Seq<ParquetColumn>)((Seq)new .colon.colon((Object)((ParquetColumn)converted.elem), (List)Nil$.MODULE$)));
                }
                ColumnIO element = ((GroupColumnIO)repeated).getChild(0);
                ParquetColumn converted = this.convertField(element, (Option<DataType>)sparkReadElementType);
                DataType convertedType = (DataType)sparkReadElementType.getOrElse((Function0 & Serializable & scala.Serializable)() -> converted.sparkType());
                boolean optional = element.getType().isRepetition(Type.Repetition.OPTIONAL);
                return ParquetColumn$.MODULE$.apply((DataType)new ArrayType(convertedType, optional), groupColumn, (Seq<ParquetColumn>)((Seq)new .colon.colon((Object)converted, (List)Nil$.MODULE$)));
            }
            if (logicalTypeAnnotation instanceof LogicalTypeAnnotation.MapLogicalTypeAnnotation ? true : logicalTypeAnnotation instanceof LogicalTypeAnnotation.MapKeyValueTypeAnnotation) {
                ParquetSchemaConverter$.MODULE$.checkConversionRequirement((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> field.getFieldCount() == 1 && !field.getType(0).isPrimitive(), new StringBuilder(18).append("Invalid map type: ").append(field).toString());
                ParquetSchemaConverter$.MODULE$.checkConversionRequirement((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> sparkReadType.forall((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)ParquetToSparkSchemaConverter.$anonfun$convertGroupField$13(x$8))), new StringBuilder(60).append("Invalid Spark read type: expected ").append(field).append(" to be map type but found ").append(sparkReadType).toString());
                GroupColumnIO keyValue = (GroupColumnIO)groupColumn.getChild(0);
                GroupType keyValueType = keyValue.getType().asGroupType();
                ParquetSchemaConverter$.MODULE$.checkConversionRequirement((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> keyValueType.isRepetition(Type.Repetition.REPEATED) && keyValueType.getFieldCount() == 2, new StringBuilder(18).append("Invalid map type: ").append(field).toString());
                ColumnIO key = keyValue.getChild(0);
                ColumnIO value = keyValue.getChild(1);
                Option sparkReadKeyType = sparkReadType.map((Function1 & Serializable & scala.Serializable)x$9 -> ((MapType)x$9).keyType());
                Option sparkReadValueType = sparkReadType.map((Function1 & Serializable & scala.Serializable)x$10 -> ((MapType)x$10).valueType());
                ParquetColumn convertedKey = this.convertField(key, (Option<DataType>)sparkReadKeyType);
                ParquetColumn convertedValue = this.convertField(value, (Option<DataType>)sparkReadValueType);
                DataType convertedKeyType = (DataType)sparkReadKeyType.getOrElse((Function0 & Serializable & scala.Serializable)() -> convertedKey.sparkType());
                DataType convertedValueType = (DataType)sparkReadValueType.getOrElse((Function0 & Serializable & scala.Serializable)() -> convertedValue.sparkType());
                boolean valueOptional = value.getType().isRepetition(Type.Repetition.OPTIONAL);
                return ParquetColumn$.MODULE$.apply((DataType)new MapType(convertedKeyType, convertedValueType, valueOptional), groupColumn, (Seq<ParquetColumn>)((Seq)new .colon.colon((Object)convertedKey, (List)new .colon.colon((Object)convertedValue, (List)Nil$.MODULE$))));
            }
            throw QueryCompilationErrors$.MODULE$.unrecognizedParquetTypeError(field.toString());
        });
    }

    private Option<DataType> convertGroupField$default$2() {
        return None$.MODULE$;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isElementType(Type repeatedType, String parentName) {
        if (repeatedType.isPrimitive()) return true;
        if (repeatedType.asGroupType().getFieldCount() > 1) return true;
        String string = repeatedType.getName();
        String string2 = "array";
        if (string == null) {
            if (string2 == null) return true;
        } else if (string.equals(string2)) return true;
        String string3 = repeatedType.getName();
        String string4 = new StringBuilder(6).append(parentName).append("_tuple").toString();
        if (string3 != null) {
            if (!string3.equals(string4)) return false;
            return true;
        }
        if (string4 == null) return true;
        return false;
    }

    public static final /* synthetic */ Tuple2 $anonfun$convertInternal$3(ParquetToSparkSchemaConverter $this, GroupColumnIO groupColumn$1, Option schemaMapOpt$1, int i) {
        ColumnIO field = groupColumn$1.getChild(i);
        Option fieldFromReadSchema = schemaMapOpt$1.flatMap((Function1 & Serializable & scala.Serializable)schemaMap -> schemaMap.get((Object)$this.normalizeFieldName(field.getName())));
        Option fieldReadType = fieldFromReadSchema.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.dataType());
        Type.Repetition repetition = field.getType().getRepetition();
        Type.Repetition repetition2 = Type.Repetition.REPEATED;
        if (!(repetition != null ? !repetition.equals(repetition2) : repetition2 != null)) {
            fieldReadType = fieldReadType.flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
                DataType dataType = x0$1;
                if (dataType instanceof ArrayType) {
                    ArrayType arrayType = (ArrayType)dataType;
                    return new Some((Object)arrayType.elementType());
                }
                throw QueryCompilationErrors$.MODULE$.illegalParquetTypeError(groupColumn$1.toString());
            });
        }
        ParquetColumn convertedField = $this.convertField(field, (Option<DataType>)fieldReadType);
        String fieldName = (String)fieldFromReadSchema.map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.name()).getOrElse((Function0 & Serializable & scala.Serializable)() -> field.getType().getName());
        Type.Repetition repetition3 = field.getType().getRepetition();
        if (Type.Repetition.OPTIONAL.equals(repetition3) ? true : Type.Repetition.REQUIRED.equals(repetition3)) {
            Type.Repetition repetition4 = field.getType().getRepetition();
            Type.Repetition repetition5 = Type.Repetition.OPTIONAL;
            boolean nullable = !(repetition4 != null ? !repetition4.equals(repetition5) : repetition5 != null);
            return new Tuple2((Object)new StructField(fieldName, convertedField.sparkType(), nullable, StructField$.MODULE$.apply$default$4()), (Object)convertedField);
        }
        if (Type.Repetition.REPEATED.equals(repetition3)) {
            ArrayType arrayType = new ArrayType(convertedField.sparkType(), false);
            boolean x$12 = true;
            DataType x$22 = convertedField.copy$default$1();
            Option<ColumnDescriptor> x$3 = convertedField.copy$default$2();
            int x$4 = convertedField.copy$default$3();
            int x$5 = convertedField.copy$default$4();
            Seq<String> x$6 = convertedField.copy$default$6();
            Seq<ParquetColumn> x$7 = convertedField.copy$default$7();
            return new Tuple2((Object)new StructField(fieldName, (DataType)arrayType, false, StructField$.MODULE$.apply$default$4()), (Object)new ParquetColumn((DataType)arrayType, (Option<ColumnDescriptor>)None$.MODULE$, convertedField.repetitionLevel() - 1, convertedField.definitionLevel() - 1, true, convertedField.path(), (Seq<ParquetColumn>)((Seq)new .colon.colon((Object)convertedField.copy(x$22, x$3, x$4, x$5, x$12, x$6, x$7), (List)Nil$.MODULE$))));
        }
        throw new MatchError((Object)repetition3);
    }

    private static final String typeString$1(LogicalTypeAnnotation typeAnnotation$1, PrimitiveType.PrimitiveTypeName typeName$1) {
        if (typeAnnotation$1 == null) {
            return String.valueOf(typeName$1);
        }
        return new StringBuilder(3).append(typeName$1).append(" (").append(typeAnnotation$1).append(")").toString();
    }

    private static final Nothing$ typeNotImplemented$1(LogicalTypeAnnotation typeAnnotation$1, PrimitiveType.PrimitiveTypeName typeName$1) {
        throw QueryCompilationErrors$.MODULE$.parquetTypeUnsupportedYetError(ParquetToSparkSchemaConverter.typeString$1(typeAnnotation$1, typeName$1));
    }

    private static final Nothing$ illegalType$1(LogicalTypeAnnotation typeAnnotation$1, PrimitiveType.PrimitiveTypeName typeName$1) {
        throw QueryCompilationErrors$.MODULE$.illegalParquetTypeError(ParquetToSparkSchemaConverter.typeString$1(typeAnnotation$1, typeName$1));
    }

    private static final DecimalType makeDecimalType$1(int maxPrecision, LogicalTypeAnnotation typeAnnotation$1, PrimitiveType.PrimitiveTypeName typeName$1) {
        LogicalTypeAnnotation.DecimalLogicalTypeAnnotation decimalLogicalTypeAnnotation = (LogicalTypeAnnotation.DecimalLogicalTypeAnnotation)typeAnnotation$1;
        int precision = decimalLogicalTypeAnnotation.getPrecision();
        int scale = decimalLogicalTypeAnnotation.getScale();
        ParquetSchemaConverter$.MODULE$.checkConversionRequirement((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> maxPrecision == -1 || 1 <= precision && precision <= maxPrecision, new StringBuilder(55).append("Invalid decimal precision: ").append(typeName$1).append(" cannot store ").append(precision).append(" digits (max ").append(maxPrecision).append(")").toString());
        return new DecimalType(precision, scale);
    }

    private static final int makeDecimalType$default$1$1() {
        return -1;
    }

    public static final /* synthetic */ boolean $anonfun$convertGroupField$6(DataType x$6) {
        return x$6 instanceof ArrayType;
    }

    public static final /* synthetic */ boolean $anonfun$convertGroupField$13(DataType x$8) {
        return x$8 instanceof MapType;
    }

    public ParquetToSparkSchemaConverter(boolean assumeBinaryIsString, boolean assumeInt96IsTimestamp, boolean caseSensitive, boolean inferTimestampNTZ, boolean nanosAsLong) {
        this.assumeBinaryIsString = assumeBinaryIsString;
        this.assumeInt96IsTimestamp = assumeInt96IsTimestamp;
        this.caseSensitive = caseSensitive;
        this.inferTimestampNTZ = inferTimestampNTZ;
        this.nanosAsLong = nanosAsLong;
    }

    public ParquetToSparkSchemaConverter(SQLConf conf) {
        this(conf.isParquetBinaryAsString(), conf.isParquetINT96AsTimestamp(), conf.caseSensitiveAnalysis(), conf.parquetInferTimestampNTZEnabled(), conf.legacyParquetNanosAsLong());
    }

    public ParquetToSparkSchemaConverter(Configuration conf) {
        this(new StringOps(Predef$.MODULE$.augmentString(conf.get(SQLConf$.MODULE$.PARQUET_BINARY_AS_STRING().key()))).toBoolean(), new StringOps(Predef$.MODULE$.augmentString(conf.get(SQLConf$.MODULE$.PARQUET_INT96_AS_TIMESTAMP().key()))).toBoolean(), new StringOps(Predef$.MODULE$.augmentString(conf.get(SQLConf$.MODULE$.CASE_SENSITIVE().key()))).toBoolean(), new StringOps(Predef$.MODULE$.augmentString(conf.get(SQLConf$.MODULE$.PARQUET_INFER_TIMESTAMP_NTZ_ENABLED().key()))).toBoolean(), new StringOps(Predef$.MODULE$.augmentString(conf.get(SQLConf$.MODULE$.LEGACY_PARQUET_NANOS_AS_LONG().key()))).toBoolean());
    }
}

