/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.api.python;

import java.io.Serializable;
import java.util.Locale;
import net.razorvine.pickle.Pickler;
import net.razorvine.pickle.Unpickler;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Column$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.CatalystTypeConverters$;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.FunctionRegistry$;
import org.apache.spark.sql.catalyst.encoders.ExpressionEncoder;
import org.apache.spark.sql.catalyst.expressions.CastTimestampNTZToLong;
import org.apache.spark.sql.catalyst.expressions.EWM;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionInfo;
import org.apache.spark.sql.catalyst.expressions.GenericRowWithSchema;
import org.apache.spark.sql.catalyst.expressions.LastNonNull;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.MakeInterval;
import org.apache.spark.sql.catalyst.expressions.MakeInterval$;
import org.apache.spark.sql.catalyst.expressions.NullIndex;
import org.apache.spark.sql.catalyst.expressions.TimestampDiff;
import org.apache.spark.sql.catalyst.expressions.TimestampDiff$;
import org.apache.spark.sql.catalyst.expressions.aggregate.PandasCovar;
import org.apache.spark.sql.catalyst.expressions.aggregate.PandasKurtosis;
import org.apache.spark.sql.catalyst.expressions.aggregate.PandasMode;
import org.apache.spark.sql.catalyst.expressions.aggregate.PandasMode$;
import org.apache.spark.sql.catalyst.expressions.aggregate.PandasProduct;
import org.apache.spark.sql.catalyst.expressions.aggregate.PandasSkewness;
import org.apache.spark.sql.catalyst.expressions.aggregate.PandasStddev;
import org.apache.spark.sql.catalyst.expressions.aggregate.PandasVariance;
import org.apache.spark.sql.catalyst.parser.CatalystSqlParser$;
import org.apache.spark.sql.execution.ExplainMode$;
import org.apache.spark.sql.execution.QueryExecution;
import org.apache.spark.sql.execution.arrow.ArrowConverters$;
import org.apache.spark.sql.execution.python.EvaluatePython$;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampNTZType$;
import org.apache.spark.util.MutableURLClassLoader;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Tuple4;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Set$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class PythonSQLUtils$
implements Logging {
    public static PythonSQLUtils$ MODULE$;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new PythonSQLUtils$();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private byte[] withInternalRowPickler(Function1<Pickler, byte[]> f) {
        byte[] byArray;
        EvaluatePython$.MODULE$.registerPicklers();
        try (Pickler pickler = new Pickler(true, false);){
            byArray = (byte[])f.apply((Object)pickler);
        }
        byte[] ret = byArray;
        return ret;
    }

    private Object withInternalRowUnpickler(Function1<Unpickler, Object> f) {
        Object object;
        EvaluatePython$.MODULE$.registerPicklers();
        try (Unpickler unpickler = new Unpickler();){
            object = f.apply((Object)unpickler);
        }
        Object ret = object;
        return ret;
    }

    public DataType parseDataType(String typeText) {
        return CatalystSqlParser$.MODULE$.parseDataType(typeText);
    }

    public ExpressionInfo[] listBuiltinFunctionInfos() {
        return (ExpressionInfo[])((TraversableOnce)FunctionRegistry$.MODULE$.functionSet().flatMap((Function1 & Serializable & scala.Serializable)f -> Option$.MODULE$.option2Iterable(FunctionRegistry$.MODULE$.builtin().lookupFunction(f)), Set$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(ExpressionInfo.class));
    }

    private Seq<Tuple4<String, String, String, String>> listAllSQLConfigs() {
        SQLConf conf = new SQLConf();
        return conf.getAllDefinedConfs();
    }

    public Tuple4<String, String, String, String>[] listRuntimeSQLConfigs() {
        return (Tuple4[])((TraversableOnce)this.listAllSQLConfigs().filterNot((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)SQLConf$.MODULE$.isStaticConfigKey((String)p._1())))).toArray(ClassTag$.MODULE$.apply(Tuple4.class));
    }

    public Tuple4<String, String, String, String>[] listStaticSQLConfigs() {
        return (Tuple4[])((TraversableOnce)this.listAllSQLConfigs().filter((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)SQLConf$.MODULE$.isStaticConfigKey((String)p._1())))).toArray(ClassTag$.MODULE$.apply(Tuple4.class));
    }

    public boolean isTimestampNTZPreferred() {
        AtomicType atomicType = SQLConf$.MODULE$.get().timestampType();
        TimestampNTZType$ timestampNTZType$ = TimestampNTZType$.MODULE$;
        return !(atomicType != null ? !atomicType.equals(timestampNTZType$) : timestampNTZType$ != null);
    }

    public Iterator<byte[]> readArrowStreamFromFile(String filename) {
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])ArrowConverters$.MODULE$.readArrowStreamFromFile(filename))).iterator();
    }

    public Dataset<Row> toDataFrame(Iterator<byte[]> arrowBatches, String schemaString, SparkSession session) {
        return ArrowConverters$.MODULE$.toDataFrame(arrowBatches, schemaString, session);
    }

    public String explainString(QueryExecution queryExecution, String mode) {
        return queryExecution.explainString(ExplainMode$.MODULE$.fromString(mode));
    }

    public byte[] toPyRow(Row row) {
        Predef$.MODULE$.assert(row instanceof GenericRowWithSchema);
        return this.withInternalRowPickler((Function1<Pickler, byte[]>)(Function1 & Serializable & scala.Serializable)x$1 -> x$1.dumps(EvaluatePython$.MODULE$.toJava(CatalystTypeConverters$.MODULE$.convertToCatalyst((Object)row), (DataType)row.schema())));
    }

    public Row toJVMRow(byte[] arr, StructType returnType, ExpressionEncoder.Deserializer<Row> deserializer) {
        Function1<Object, Object> fromJava = EvaluatePython$.MODULE$.makeFromJava((DataType)returnType);
        InternalRow internalRow = (InternalRow)fromJava.apply(this.withInternalRowUnpickler((Function1<Unpickler, Object>)(Function1 & Serializable & scala.Serializable)x$2 -> x$2.loads(arr)));
        return (Row)deserializer.apply(internalRow);
    }

    public void addJarToCurrentClassLoader(String path) {
        ClassLoader classLoader = Utils$.MODULE$.getContextOrSparkClassLoader();
        if (classLoader instanceof MutableURLClassLoader) {
            MutableURLClassLoader mutableURLClassLoader = (MutableURLClassLoader)classLoader;
            mutableURLClassLoader.addURL(Utils$.MODULE$.resolveURI(path).toURL());
            return;
        }
        this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(74).append("Unsupported class loader ").append(classLoader).append(" will not update jars in the thread class loader.").toString());
    }

    public Column castTimestampNTZToLong(Column c) {
        return Column$.MODULE$.apply((Expression)new CastTimestampNTZToLong(c.expr()));
    }

    public Column ewm(Column e, double alpha, boolean ignoreNA) {
        return Column$.MODULE$.apply((Expression)new EWM(e.expr(), alpha, ignoreNA));
    }

    public Column lastNonNull(Column e) {
        return Column$.MODULE$.apply((Expression)new LastNonNull(e.expr()));
    }

    public Column nullIndex(Column e) {
        return Column$.MODULE$.apply((Expression)new NullIndex(e.expr()));
    }

    public Column makeInterval(String unit, Column e) {
        MakeInterval zero = new MakeInterval((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)0)), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)0)), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)0)), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)0)), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)0)), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)0)), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)0)), MakeInterval$.MODULE$.apply$default$8());
        String string = unit.toUpperCase(Locale.ROOT);
        if ("YEAR".equals(string)) {
            return Column$.MODULE$.apply((Expression)zero.copy(e.expr(), zero.copy$default$2(), zero.copy$default$3(), zero.copy$default$4(), zero.copy$default$5(), zero.copy$default$6(), zero.copy$default$7(), zero.copy$default$8()));
        }
        if ("MONTH".equals(string)) {
            Expression x$1 = e.expr();
            Expression x$2 = zero.copy$default$1();
            Expression x$3 = zero.copy$default$3();
            Expression x$4 = zero.copy$default$4();
            Expression x$5 = zero.copy$default$5();
            Expression x$6 = zero.copy$default$6();
            Expression x$7 = zero.copy$default$7();
            boolean x$8 = zero.copy$default$8();
            return Column$.MODULE$.apply((Expression)zero.copy(x$2, x$1, x$3, x$4, x$5, x$6, x$7, x$8));
        }
        if ("WEEK".equals(string)) {
            Expression x$9 = e.expr();
            Expression x$10 = zero.copy$default$1();
            Expression x$11 = zero.copy$default$2();
            Expression x$12 = zero.copy$default$4();
            Expression x$13 = zero.copy$default$5();
            Expression x$14 = zero.copy$default$6();
            Expression x$15 = zero.copy$default$7();
            boolean x$16 = zero.copy$default$8();
            return Column$.MODULE$.apply((Expression)zero.copy(x$10, x$11, x$9, x$12, x$13, x$14, x$15, x$16));
        }
        if ("DAY".equals(string)) {
            Expression x$17 = e.expr();
            Expression x$18 = zero.copy$default$1();
            Expression x$19 = zero.copy$default$2();
            Expression x$20 = zero.copy$default$3();
            Expression x$21 = zero.copy$default$5();
            Expression x$22 = zero.copy$default$6();
            Expression x$23 = zero.copy$default$7();
            boolean x$24 = zero.copy$default$8();
            return Column$.MODULE$.apply((Expression)zero.copy(x$18, x$19, x$20, x$17, x$21, x$22, x$23, x$24));
        }
        if ("HOUR".equals(string)) {
            Expression x$25 = e.expr();
            Expression x$26 = zero.copy$default$1();
            Expression x$27 = zero.copy$default$2();
            Expression x$28 = zero.copy$default$3();
            Expression x$29 = zero.copy$default$4();
            Expression x$30 = zero.copy$default$6();
            Expression x$31 = zero.copy$default$7();
            boolean x$32 = zero.copy$default$8();
            return Column$.MODULE$.apply((Expression)zero.copy(x$26, x$27, x$28, x$29, x$25, x$30, x$31, x$32));
        }
        if ("MINUTE".equals(string)) {
            Expression x$33 = e.expr();
            Expression x$34 = zero.copy$default$1();
            Expression x$35 = zero.copy$default$2();
            Expression x$36 = zero.copy$default$3();
            Expression x$37 = zero.copy$default$4();
            Expression x$38 = zero.copy$default$5();
            Expression x$39 = zero.copy$default$7();
            boolean x$40 = zero.copy$default$8();
            return Column$.MODULE$.apply((Expression)zero.copy(x$34, x$35, x$36, x$37, x$38, x$33, x$39, x$40));
        }
        if ("SECOND".equals(string)) {
            Expression x$41 = e.expr();
            Expression x$42 = zero.copy$default$1();
            Expression x$43 = zero.copy$default$2();
            Expression x$44 = zero.copy$default$3();
            Expression x$45 = zero.copy$default$4();
            Expression x$46 = zero.copy$default$5();
            Expression x$47 = zero.copy$default$6();
            boolean x$48 = zero.copy$default$8();
            return Column$.MODULE$.apply((Expression)zero.copy(x$42, x$43, x$44, x$45, x$46, x$47, x$41, x$48));
        }
        throw new IllegalStateException(new StringBuilder(27).append("Got the unexpected unit '").append(unit).append("'.").toString());
    }

    public Column timestampDiff(String unit, Column start, Column end) {
        return Column$.MODULE$.apply((Expression)new TimestampDiff(unit, start.expr(), end.expr(), TimestampDiff$.MODULE$.apply$default$4()));
    }

    public Column pandasProduct(Column e, boolean ignoreNA) {
        PandasProduct qual$1 = new PandasProduct(e.expr(), ignoreNA);
        boolean x$1 = false;
        Option x$2 = qual$1.toAggregateExpression$default$2();
        return Column$.MODULE$.apply((Expression)qual$1.toAggregateExpression(x$1, x$2));
    }

    public Column pandasStddev(Column e, int ddof) {
        PandasStddev qual$1 = new PandasStddev(e.expr(), ddof);
        boolean x$1 = false;
        Option x$2 = qual$1.toAggregateExpression$default$2();
        return Column$.MODULE$.apply((Expression)qual$1.toAggregateExpression(x$1, x$2));
    }

    public Column pandasVariance(Column e, int ddof) {
        PandasVariance qual$1 = new PandasVariance(e.expr(), ddof);
        boolean x$1 = false;
        Option x$2 = qual$1.toAggregateExpression$default$2();
        return Column$.MODULE$.apply((Expression)qual$1.toAggregateExpression(x$1, x$2));
    }

    public Column pandasSkewness(Column e) {
        PandasSkewness qual$1 = new PandasSkewness(e.expr());
        boolean x$1 = false;
        Option x$2 = qual$1.toAggregateExpression$default$2();
        return Column$.MODULE$.apply((Expression)qual$1.toAggregateExpression(x$1, x$2));
    }

    public Column pandasKurtosis(Column e) {
        PandasKurtosis qual$1 = new PandasKurtosis(e.expr());
        boolean x$1 = false;
        Option x$2 = qual$1.toAggregateExpression$default$2();
        return Column$.MODULE$.apply((Expression)qual$1.toAggregateExpression(x$1, x$2));
    }

    public Column pandasMode(Column e, boolean ignoreNA) {
        PandasMode qual$1 = new PandasMode(e.expr(), ignoreNA, PandasMode$.MODULE$.apply$default$3(), PandasMode$.MODULE$.apply$default$4());
        boolean x$1 = false;
        Option x$2 = qual$1.toAggregateExpression$default$2();
        return Column$.MODULE$.apply((Expression)qual$1.toAggregateExpression(x$1, x$2));
    }

    public Column pandasCovar(Column col1, Column col2, int ddof) {
        PandasCovar qual$1 = new PandasCovar(col1.expr(), col2.expr(), ddof);
        boolean x$1 = false;
        Option x$2 = qual$1.toAggregateExpression$default$2();
        return Column$.MODULE$.apply((Expression)qual$1.toAggregateExpression(x$1, x$2));
    }

    private PythonSQLUtils$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
    }
}

