/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.streaming;

import java.io.Serializable;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.concurrent.GuardedBy;
import org.apache.spark.annotation.Evolving;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.config.ConfigEntry;
import org.apache.spark.scheduler.LiveListenerBus;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.streaming.WriteToStream;
import org.apache.spark.sql.catalyst.streaming.WriteToStreamStatement;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.SupportsWrite;
import org.apache.spark.sql.connector.catalog.Table;
import org.apache.spark.sql.connector.catalog.TableCatalog;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.execution.streaming.AsyncProgressTrackingMicroBatchExecution;
import org.apache.spark.sql.execution.streaming.AsyncProgressTrackingMicroBatchExecution$;
import org.apache.spark.sql.execution.streaming.ContinuousTrigger;
import org.apache.spark.sql.execution.streaming.MicroBatchExecution;
import org.apache.spark.sql.execution.streaming.StreamExecution;
import org.apache.spark.sql.execution.streaming.StreamingQueryListenerBus;
import org.apache.spark.sql.execution.streaming.StreamingQueryWrapper;
import org.apache.spark.sql.execution.streaming.continuous.ContinuousExecution;
import org.apache.spark.sql.execution.streaming.state.StateStoreCoordinatorRef;
import org.apache.spark.sql.execution.streaming.state.StateStoreCoordinatorRef$;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.internal.StaticSQLConf$;
import org.apache.spark.sql.streaming.OutputMode;
import org.apache.spark.sql.streaming.StreamingQuery;
import org.apache.spark.sql.streaming.StreamingQueryException;
import org.apache.spark.sql.streaming.StreamingQueryListener;
import org.apache.spark.sql.streaming.Trigger;
import org.apache.spark.util.Clock;
import org.apache.spark.util.SystemClock;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.HashMap;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@Evolving
@ScalaSignature(bytes="\u0006\u0001\reb\u0001\u0002\u0015*\u0001QB\u0001\"\u0011\u0001\u0003\u0002\u0003\u0006IA\u0011\u0005\t\r\u0002\u0011\t\u0011)A\u0005\u000f\"1A\n\u0001C\u0001W5C\u0001B\u0015\u0001C\u0002\u0013\u00051f\u0015\u0005\u0007;\u0002\u0001\u000b\u0011\u0002+\t\u000fy\u0003!\u0019!C\u0005?\"1A\r\u0001Q\u0001\n\u0001Dq!\u001a\u0001C\u0002\u0013%a\r\u0003\u0004{\u0001\u0001\u0006Ia\u001a\u0005\n\u0003#\u0001!\u0019!C\u0005\u0003'A\u0001\"!\t\u0001A\u0003%\u0011Q\u0003\u0005\n\u0003G\u0001!\u0019!C\u0005\u0003'A\u0001\"!\n\u0001A\u0003%\u0011Q\u0003\u0005\n\u0003O\u0001\u0001\u0019!C\u0005\u0003SA\u0011\"a\u000e\u0001\u0001\u0004%I!!\u000f\t\u0011\u0005\u0015\u0003\u0001)Q\u0005\u0003WAq!a\u0013\u0001\t\u0003\ti\u0005C\u0004\u0002V\u0001!\t!a\u0016\t\u000f\u0005U\u0003\u0001\"\u0001\u0002^!9\u0011q\u000f\u0001\u0005\u0002\u0005e\u0004bBA<\u0001\u0011\u0005\u0011\u0011\u0018\u0005\b\u0003/\u0004A\u0011AA=\u0011\u001d\tI\u000e\u0001C\u0001\u00037Dq!a:\u0001\t\u0003\tI\u000fC\u0004\u0002n\u0002!\t!a<\t\u0011\u0005M\b\u0001\"\u0001,\u0003kDqA!\u0003\u0001\t\u0013\u0011Y\u0001C\u0004\u0003\u0018\u0001!IA!\u0007\t\u0013\t]\u0006!%A\u0005\n\te\u0006\"\u0003Bg\u0001E\u0005I\u0011\u0002Bh\u0011!\u0011\u0019\u000e\u0001C\u0001W\tU\u0007BCB\u0004\u0001E\u0005I\u0011A\u0016\u0004\n!Q1Q\u0002\u0001\u0012\u0002\u0013\u00051f!\u0003\t\u0015\r=\u0001!%A\u0005\u0002-\u001a\t\u0002\u0003\u0006\u0004\u0016\u0001\t\n\u0011\"\u0001,\u0007/A!ba\u0007\u0001#\u0003%\ta\u000bB]\u0011)\u0019i\u0002AI\u0001\n\u0003Y#q\u001a\u0005\t\u0007?\u0001A\u0011A\u0016\u0004\"!91q\u0005\u0001\u0005\n\r%\"!F*ue\u0016\fW.\u001b8h#V,'/_'b]\u0006<WM\u001d\u0006\u0003U-\n\u0011b\u001d;sK\u0006l\u0017N\\4\u000b\u00051j\u0013aA:rY*\u0011afL\u0001\u0006gB\f'o\u001b\u0006\u0003aE\na!\u00199bG\",'\"\u0001\u001a\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001)4\b\u0005\u00027s5\tqGC\u00019\u0003\u0015\u00198-\u00197b\u0013\tQtG\u0001\u0004B]f\u0014VM\u001a\t\u0003y}j\u0011!\u0010\u0006\u0003}5\n\u0001\"\u001b8uKJt\u0017\r\\\u0005\u0003\u0001v\u0012q\u0001T8hO&tw-\u0001\u0007ta\u0006\u00148nU3tg&|g\u000e\u0005\u0002D\t6\t1&\u0003\u0002FW\ta1\u000b]1sWN+7o]5p]\u000691/\u001d7D_:4\u0007C\u0001%K\u001b\u0005I%B\u0001 ,\u0013\tY\u0015JA\u0004T#2\u001buN\u001c4\u0002\rqJg.\u001b;?)\rq\u0005+\u0015\t\u0003\u001f\u0002i\u0011!\u000b\u0005\u0006\u0003\u000e\u0001\rA\u0011\u0005\u0006\r\u000e\u0001\raR\u0001\u0016gR\fG/Z*u_J,7i\\8sI&t\u0017\r^8s+\u0005!\u0006CA+\\\u001b\u00051&BA,Y\u0003\u0015\u0019H/\u0019;f\u0015\tQ\u0013L\u0003\u0002[W\u0005IQ\r_3dkRLwN\\\u0005\u00039Z\u0013\u0001d\u0015;bi\u0016\u001cFo\u001c:f\u0007>|'\u000fZ5oCR|'OU3g\u0003Y\u0019H/\u0019;f'R|'/Z\"p_J$\u0017N\\1u_J\u0004\u0013a\u00037jgR,g.\u001a:CkN,\u0012\u0001\u0019\t\u0003C\nl\u0011\u0001W\u0005\u0003Gb\u0013\u0011d\u0015;sK\u0006l\u0017N\\4Rk\u0016\u0014\u0018\u0010T5ti\u0016tWM\u001d\"vg\u0006aA.[:uK:,'OQ;tA\u0005i\u0011m\u0019;jm\u0016\fV/\u001a:jKN,\u0012a\u001a\t\u0005Q6|w/D\u0001j\u0015\tQ7.A\u0004nkR\f'\r\\3\u000b\u00051<\u0014AC2pY2,7\r^5p]&\u0011a.\u001b\u0002\b\u0011\u0006\u001c\b.T1q!\t\u0001X/D\u0001r\u0015\t\u00118/\u0001\u0003vi&d'\"\u0001;\u0002\t)\fg/Y\u0005\u0003mF\u0014A!V+J\tB\u0011q\n_\u0005\u0003s&\u0012ab\u0015;sK\u0006l\u0017N\\4Rk\u0016\u0014\u00180\u0001\bbGRLg/Z)vKJLWm\u001d\u0011)\r%a\u0018QBA\b!\ri\u0018\u0011B\u0007\u0002}*\u0019q0!\u0001\u0002\u0015\r|gnY;se\u0016tGO\u0003\u0003\u0002\u0004\u0005\u0015\u0011AC1o]>$\u0018\r^5p]*\u0011\u0011qA\u0001\u0006U\u00064\u0018\r_\u0005\u0004\u0003\u0017q(!C$vCJ$W\r\u001a\"z\u0003\u00151\u0018\r\\;fC\t\t\t\"A\fbGRLg/Z)vKJLWm]*iCJ,G\rT8dWV\u0011\u0011Q\u0003\t\u0005\u0003/\ti\"\u0004\u0002\u0002\u001a)\u0019\u00111D:\u0002\t1\fgnZ\u0005\u0005\u0003?\tIB\u0001\u0004PE*,7\r^\u0001\u0019C\u000e$\u0018N^3Rk\u0016\u0014\u0018.Z:TQ\u0006\u0014X\r\u001a'pG.\u0004\u0013\u0001F1xC&$H+\u001a:nS:\fG/[8o\u0019>\u001c7.A\u000bbo\u0006LG\u000fV3s[&t\u0017\r^5p]2{7m\u001b\u0011\u000291\f7\u000f\u001e+fe6Lg.\u0019;fIF+XM]=Fq\u000e,\u0007\u000f^5p]V\u0011\u00111\u0006\t\u0006m\u00055\u0012\u0011G\u0005\u0004\u0003_9$AB(qi&|g\u000eE\u0002P\u0003gI1!!\u000e*\u0005]\u0019FO]3b[&tw-U;fef,\u0005pY3qi&|g.\u0001\u0011mCN$H+\u001a:nS:\fG/\u001a3Rk\u0016\u0014\u00180\u0012=dKB$\u0018n\u001c8`I\u0015\fH\u0003BA\u001e\u0003\u0003\u00022ANA\u001f\u0013\r\tyd\u000e\u0002\u0005+:LG\u000fC\u0005\u0002D=\t\t\u00111\u0001\u0002,\u0005\u0019\u0001\u0010J\u0019\u0002;1\f7\u000f\u001e+fe6Lg.\u0019;fIF+XM]=Fq\u000e,\u0007\u000f^5p]\u0002Bc\u0001\u0005?\u0002\u000e\u0005%\u0013EAA\u0012\u0003\u0019\t7\r^5wKV\u0011\u0011q\n\t\u0005m\u0005Es/C\u0002\u0002T]\u0012Q!\u0011:sCf\f1aZ3u)\r9\u0018\u0011\f\u0005\u0007\u00037\u0012\u0002\u0019A8\u0002\u0005%$GcA<\u0002`!9\u00111L\nA\u0002\u0005\u0005\u0004\u0003BA2\u0003crA!!\u001a\u0002nA\u0019\u0011qM\u001c\u000e\u0005\u0005%$bAA6g\u00051AH]8pizJ1!a\u001c8\u0003\u0019\u0001&/\u001a3fM&!\u00111OA;\u0005\u0019\u0019FO]5oO*\u0019\u0011qN\u001c\u0002'\u0005<\u0018-\u001b;B]f$VM]7j]\u0006$\u0018n\u001c8\u0015\u0005\u0005m\u0002&\u0002\u000b\u0002~\u0005\r\u0005#\u0002\u001c\u0002\u0000\u0005E\u0012bAAAo\t1A\u000f\u001b:poN\ftAHA1\u0003\u000b\u000b9,M\u0005$\u0003\u000f\u000by)!,\u0002\u0012V!\u0011\u0011RAF+\t\t\t\u0007B\u0004\u0002\u000eN\u0012\r!a&\u0003\u0003QKA!!%\u0002\u0014\u0006YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIER1!!&8\u0003\u0019!\bN]8xgF!\u0011\u0011TAP!\r1\u00141T\u0005\u0004\u0003;;$a\u0002(pi\"Lgn\u001a\t\u0005\u0003C\u000b9KD\u00027\u0003GK1!!*8\u0003\u001d\u0001\u0018mY6bO\u0016LA!!+\u0002,\nIA\u000b\u001b:po\u0006\u0014G.\u001a\u0006\u0004\u0003K;\u0014'C\u0012\u00020\u0006E\u00161WAK\u001d\r1\u0014\u0011W\u0005\u0004\u0003+;\u0014'\u0002\u00127o\u0005U&!B:dC2\f\u0017g\u0001\u0014\u00022Q!\u00111XAa!\r1\u0014QX\u0005\u0004\u0003\u007f;$a\u0002\"p_2,\u0017M\u001c\u0005\b\u0003\u0007,\u0002\u0019AAc\u0003%!\u0018.\\3pkRl5\u000fE\u00027\u0003\u000fL1!!38\u0005\u0011auN\\4)\u000bU\ti(!42\u000fy\t\t'a4\u0002VFJ1%a\"\u0002\u0010\u0006E\u0017\u0011S\u0019\nG\u0005=\u0016\u0011WAj\u0003+\u000bTA\t\u001c8\u0003k\u000b4AJA\u0019\u0003=\u0011Xm]3u)\u0016\u0014X.\u001b8bi\u0016$\u0017aC1eI2K7\u000f^3oKJ$B!a\u000f\u0002^\"9\u0011q\\\fA\u0002\u0005\u0005\u0018\u0001\u00037jgR,g.\u001a:\u0011\u0007=\u000b\u0019/C\u0002\u0002f&\u0012ac\u0015;sK\u0006l\u0017N\\4Rk\u0016\u0014\u0018\u0010T5ti\u0016tWM]\u0001\u000fe\u0016lwN^3MSN$XM\\3s)\u0011\tY$a;\t\u000f\u0005}\u0007\u00041\u0001\u0002b\u0006iA.[:u\u0019&\u001cH/\u001a8feN$\"!!=\u0011\u000bY\n\t&!9\u0002#A|7\u000f\u001e'jgR,g.\u001a:Fm\u0016tG\u000f\u0006\u0003\u0002<\u0005]\bbBA}5\u0001\u0007\u00111`\u0001\u0006KZ,g\u000e\u001e\t\u0005\u0003{\u0014\u0019AD\u0002P\u0003\u007fL1A!\u0001*\u0003Y\u0019FO]3b[&tw-U;fefd\u0015n\u001d;f]\u0016\u0014\u0018\u0002\u0002B\u0003\u0005\u000f\u0011Q!\u0012<f]RT1A!\u0001*\u0003a)8/Z!ts:\u001c\u0007K]8he\u0016\u001c8\u000f\u0016:bG.Lgn\u001a\u000b\u0005\u0003w\u0013i\u0001C\u0004\u0003\u0010m\u0001\rA!\u0005\u0002\u0019\u0015DHO]1PaRLwN\\:\u0011\u0011\u0005\r$1CA1\u0003CJAA!\u0006\u0002v\t\u0019Q*\u00199\u0002\u0017\r\u0014X-\u0019;f#V,'/\u001f\u000b\u001b\u00057\u0011\tCa\n\u0003,\t-#Q\nB1\u0005W\u0012yGa\u001d\u0003~\t-%1\u0015\t\u0004C\nu\u0011b\u0001B\u00101\n)2\u000b\u001e:fC6LgnZ)vKJLxK]1qa\u0016\u0014\bb\u0002B\u00129\u0001\u0007!QE\u0001\u0012kN,'o\u00159fG&4\u0017.\u001a3OC6,\u0007#\u0002\u001c\u0002.\u0005\u0005\u0004b\u0002B\u00159\u0001\u0007!QE\u0001 kN,'o\u00159fG&4\u0017.\u001a3DQ\u0016\u001c7\u000e]8j]RdunY1uS>t\u0007b\u0002B\u00179\u0001\u0007!qF\u0001\u0003I\u001a\u0004BA!\r\u0003F9!!1\u0007B\"\u001d\u0011\u0011)D!\u0011\u000f\t\t]\"q\b\b\u0005\u0005s\u0011iD\u0004\u0003\u0002h\tm\u0012\"\u0001\u001a\n\u0005A\n\u0014B\u0001\u00180\u0013\taS&C\u0002\u0002&.JAAa\u0012\u0003J\tIA)\u0019;b\rJ\fW.\u001a\u0006\u0004\u0003K[\u0003b\u0002B\b9\u0001\u0007!\u0011\u0003\u0005\b\u0005\u001fb\u0002\u0019\u0001B)\u0003\u0011\u0019\u0018N\\6\u0011\t\tM#QL\u0007\u0003\u0005+RAAa\u0016\u0003Z\u000591-\u0019;bY><'b\u0001B.W\u0005I1m\u001c8oK\u000e$xN]\u0005\u0005\u0005?\u0012)FA\u0003UC\ndW\rC\u0004\u0003dq\u0001\rA!\u001a\u0002\u0015=,H\u000f];u\u001b>$W\rE\u0002P\u0005OJ1A!\u001b*\u0005)yU\u000f\u001e9vi6{G-\u001a\u0005\b\u0005[b\u0002\u0019AA^\u0003e)8/\u001a+f[B\u001c\u0005.Z2la>Lg\u000e\u001e'pG\u0006$\u0018n\u001c8\t\u000f\tED\u00041\u0001\u0002<\u0006i\"/Z2pm\u0016\u0014hI]8n\u0007\",7m\u001b9pS:$Hj\\2bi&|g\u000eC\u0004\u0003vq\u0001\rAa\u001e\u0002\u000fQ\u0014\u0018nZ4feB\u0019qJ!\u001f\n\u0007\tm\u0014FA\u0004Ue&<w-\u001a:\t\u000f\t}D\u00041\u0001\u0003\u0002\u0006aAO]5hO\u0016\u00148\t\\8dWB!!1\u0011BD\u001b\t\u0011)I\u0003\u0002s[%!!\u0011\u0012BC\u0005\u0015\u0019En\\2l\u0011%\u0011i\t\bI\u0001\u0002\u0004\u0011y)A\bdCR\fGn\\4B]\u0012LE-\u001a8u!\u00151\u0014Q\u0006BI!\u001d1$1\u0013BL\u0005;K1A!&8\u0005\u0019!V\u000f\u001d7feA!!1\u000bBM\u0013\u0011\u0011YJ!\u0016\u0003\u0019Q\u000b'\r\\3DCR\fGn\\4\u0011\t\tM#qT\u0005\u0005\u0005C\u0013)F\u0001\u0006JI\u0016tG/\u001b4jKJD\u0011B!*\u001d!\u0003\u0005\rAa*\u0002\u0019\r\fG/\u00197pOR\u000b'\r\\3\u0011\u000bY\niC!+\u0011\t\t-&1W\u0007\u0003\u0005[SAAa\u0016\u00030*\u0019!\u0011W\u0016\u0002\u0011\r\fG/\u00197zgRLAA!.\u0003.\na1)\u0019;bY><G+\u00192mK\u000612M]3bi\u0016\fV/\u001a:zI\u0011,g-Y;mi\u0012\n\u0014'\u0006\u0002\u0003<*\"!q\u0012B_W\t\u0011y\f\u0005\u0003\u0003B\n%WB\u0001Bb\u0015\u0011\u0011)Ma2\u0002\u0013Ut7\r[3dW\u0016$'bAA\u0002o%!!1\u001aBb\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u0017GJ,\u0017\r^3Rk\u0016\u0014\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132eU\u0011!\u0011\u001b\u0016\u0005\u0005O\u0013i,\u0001\u0006ti\u0006\u0014H/U;fef$\u0012d\u001eBl\u00053\u0014YN!8\u0003`\n\u0005(1\u001dBs\u0005O\u0014IOa;\u0003n\"9!1E\u0010A\u0002\t\u0015\u0002b\u0002B\u0015?\u0001\u0007!Q\u0005\u0005\b\u0005[y\u0002\u0019\u0001B\u0018\u0011\u001d\u0011ya\ba\u0001\u0005#AqAa\u0014 \u0001\u0004\u0011\t\u0006C\u0004\u0003d}\u0001\rA!\u001a\t\u0013\t5t\u0004%AA\u0002\u0005m\u0006\"\u0003B9?A\u0005\t\u0019AA^\u0011%\u0011)h\bI\u0001\u0002\u0004\u00119\bC\u0005\u0003\u0000}\u0001\n\u00111\u0001\u0003\u0002\"I!QR\u0010\u0011\u0002\u0003\u0007!q\u0012\u0005\n\u0005K{\u0002\u0013!a\u0001\u0005OCSa\bBy\u0005{\u0004RANA@\u0005g\u0004BA!>\u0003z6\u0011!q\u001f\u0006\u0003\u007fFLAAa?\u0003x\n\u0001B+[7f_V$X\t_2faRLwN\\\u0019\b=\u0005\u0005$q`B\u0003c%\u0019\u0013qQAH\u0007\u0003\t\t*M\u0005$\u0003_\u000b\tla\u0001\u0002\u0016F*!EN\u001c\u00026F\u001aaEa=\u0002)M$\u0018M\u001d;Rk\u0016\u0014\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00138+\t\u0019YA\u000b\u0003\u0002<\nu\u0016\u0001F:uCJ$\u0018+^3ss\u0012\"WMZ1vYR$\u0003(\u0001\u000bti\u0006\u0014H/U;fef$C-\u001a4bk2$H%O\u000b\u0003\u0007'QCAa\u001e\u0003>\u0006)2\u000f^1siF+XM]=%I\u00164\u0017-\u001e7uIE\u0002TCAB\rU\u0011\u0011\tI!0\u0002+M$\u0018M\u001d;Rk\u0016\u0014\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132c\u0005)2\u000f^1siF+XM]=%I\u00164\u0017-\u001e7uIE\u0012\u0014A\u00068pi&4\u00170U;fef$VM]7j]\u0006$\u0018n\u001c8\u0015\t\u0005m21\u0005\u0005\u0007\u0007K1\u0003\u0019A<\u0002\u001fQ,'/\\5oCR,G-U;fef\f!$\u001e8sK\u001eL7\u000f^3s)\u0016\u0014X.\u001b8bi\u0016$7\u000b\u001e:fC6$B!a\u000f\u0004,!11QE\u0014A\u0002]D3\u0001AB\u0018!\u0011\u0019\td!\u000e\u000e\u0005\rM\"bAA\u0002[%!1qGB\u001a\u0005!)eo\u001c7wS:<\u0007")
public class StreamingQueryManager
implements Logging {
    private final SparkSession sparkSession;
    private final SQLConf sqlConf;
    private final StateStoreCoordinatorRef stateStoreCoordinator;
    private final StreamingQueryListenerBus listenerBus;
    @GuardedBy(value="activeQueriesSharedLock")
    private final HashMap<UUID, StreamingQuery> activeQueries;
    private final Object activeQueriesSharedLock;
    private final Object awaitTerminationLock;
    @GuardedBy(value="awaitTerminationLock")
    private Option<StreamingQueryException> lastTerminatedQueryException;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public StateStoreCoordinatorRef stateStoreCoordinator() {
        return this.stateStoreCoordinator;
    }

    private StreamingQueryListenerBus listenerBus() {
        return this.listenerBus;
    }

    private HashMap<UUID, StreamingQuery> activeQueries() {
        return this.activeQueries;
    }

    private Object activeQueriesSharedLock() {
        return this.activeQueriesSharedLock;
    }

    private Object awaitTerminationLock() {
        return this.awaitTerminationLock;
    }

    private Option<StreamingQueryException> lastTerminatedQueryException() {
        return this.lastTerminatedQueryException;
    }

    private void lastTerminatedQueryException_$eq(Option<StreamingQueryException> x$1) {
        this.lastTerminatedQueryException = x$1;
    }

    public StreamingQuery[] active() {
        StreamingQuery[] streamingQueryArray;
        Object object = this.activeQueriesSharedLock();
        synchronized (object) {
            streamingQueryArray = (StreamingQuery[])this.activeQueries().values().toArray(ClassTag$.MODULE$.apply(StreamingQuery.class));
        }
        return streamingQueryArray;
    }

    public StreamingQuery get(UUID id) {
        StreamingQuery streamingQuery;
        Object object = this.activeQueriesSharedLock();
        synchronized (object) {
            streamingQuery = (StreamingQuery)this.activeQueries().get((Object)id).orNull(Predef$.MODULE$.$conforms());
        }
        return streamingQuery;
    }

    public StreamingQuery get(String id) {
        return this.get(UUID.fromString(id));
    }

    public void awaitAnyTermination() throws StreamingQueryException {
        Object object = this.awaitTerminationLock();
        synchronized (object) {
            while (this.lastTerminatedQueryException() == null) {
                this.awaitTerminationLock().wait(10L);
            }
            if (this.lastTerminatedQueryException() != null && this.lastTerminatedQueryException().nonEmpty()) {
                throw (Throwable)this.lastTerminatedQueryException().get();
            }
        }
    }

    public boolean awaitAnyTermination(long timeoutMs) throws StreamingQueryException {
        boolean bl;
        long startTime = System.nanoTime();
        Object object = this.awaitTerminationLock();
        synchronized (object) {
            while (!StreamingQueryManager.isTimedout$1(startTime, timeoutMs) && this.lastTerminatedQueryException() == null) {
                this.awaitTerminationLock().wait(10L);
            }
            if (this.lastTerminatedQueryException() != null && this.lastTerminatedQueryException().nonEmpty()) {
                throw (Throwable)this.lastTerminatedQueryException().get();
            }
            bl = this.lastTerminatedQueryException() != null;
        }
        return bl;
    }

    public void resetTerminated() {
        Object object = this.awaitTerminationLock();
        synchronized (object) {
            this.lastTerminatedQueryException_$eq(null);
        }
    }

    public void addListener(StreamingQueryListener listener) {
        this.listenerBus().addListener(listener);
    }

    public void removeListener(StreamingQueryListener listener) {
        this.listenerBus().removeListener(listener);
    }

    public StreamingQueryListener[] listListeners() {
        return (StreamingQueryListener[])((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(this.listenerBus().listeners()).asScala()).toArray(ClassTag$.MODULE$.apply(StreamingQueryListener.class));
    }

    public void postListenerEvent(StreamingQueryListener.Event event) {
        this.listenerBus().post(event);
    }

    private boolean useAsyncProgressTracking(Map<String, String> extraOptions) {
        return new StringOps(Predef$.MODULE$.augmentString((String)extraOptions.getOrElse((Object)AsyncProgressTrackingMicroBatchExecution$.MODULE$.ASYNC_PROGRESS_TRACKING_ENABLED(), (Function0 & Serializable & scala.Serializable)() -> "false"))).toBoolean();
    }

    private StreamingQueryWrapper createQuery(Option<String> userSpecifiedName, Option<String> userSpecifiedCheckpointLocation, Dataset<Row> df, Map<String, String> extraOptions, Table sink, OutputMode outputMode, boolean useTempCheckpointLocation, boolean recoverFromCheckpointLocation, Trigger trigger, Clock triggerClock, Option<Tuple2<TableCatalog, Identifier>> catalogAndIdent, Option<CatalogTable> catalogTable) {
        LogicalPlan analyzedPlan = df.queryExecution().analyzed();
        df.queryExecution().assertAnalyzed();
        WriteToStreamStatement dataStreamWritePlan = new WriteToStreamStatement(userSpecifiedName, userSpecifiedCheckpointLocation, useTempCheckpointLocation, recoverFromCheckpointLocation, sink, outputMode, df.sparkSession().sessionState().newHadoopConf(), trigger instanceof ContinuousTrigger, analyzedPlan, catalogAndIdent, catalogTable);
        WriteToStream analyzedStreamWritePlan = (WriteToStream)this.sparkSession.sessionState().executePlan((LogicalPlan)dataStreamWritePlan, this.sparkSession.sessionState().executePlan$default$2()).analyzed();
        Tuple2 tuple2 = new Tuple2((Object)sink, (Object)trigger);
        if (tuple2 != null) {
            Trigger trigger2 = (Trigger)tuple2._2();
            if (tuple2._1() instanceof SupportsWrite && trigger2 instanceof ContinuousTrigger) {
                ContinuousTrigger continuousTrigger = (ContinuousTrigger)trigger2;
                return new StreamingQueryWrapper(new ContinuousExecution(this.sparkSession, (Trigger)continuousTrigger, triggerClock, extraOptions, analyzedStreamWritePlan));
            }
        }
        MicroBatchExecution microBatchExecution = this.useAsyncProgressTracking(extraOptions) ? new AsyncProgressTrackingMicroBatchExecution(this.sparkSession, trigger, triggerClock, extraOptions, analyzedStreamWritePlan) : new MicroBatchExecution(this.sparkSession, trigger, triggerClock, extraOptions, analyzedStreamWritePlan);
        return new StreamingQueryWrapper(microBatchExecution);
    }

    private Option<Tuple2<TableCatalog, Identifier>> createQuery$default$11() {
        return None$.MODULE$;
    }

    private Option<CatalogTable> createQuery$default$12() {
        return None$.MODULE$;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public StreamingQuery startQuery(Option<String> userSpecifiedName, Option<String> userSpecifiedCheckpointLocation, Dataset<Row> df, Map<String, String> extraOptions, Table sink, OutputMode outputMode, boolean useTempCheckpointLocation, boolean recoverFromCheckpointLocation, Trigger trigger, Clock triggerClock, Option<Tuple2<TableCatalog, Identifier>> catalogAndIdent, Option<CatalogTable> catalogTable) throws TimeoutException {
        None$ none$;
        StreamingQueryWrapper query = this.createQuery(userSpecifiedName, userSpecifiedCheckpointLocation, df, extraOptions, sink, outputMode, useTempCheckpointLocation, recoverFromCheckpointLocation, trigger, triggerClock, catalogAndIdent, catalogTable);
        Object object = this.activeQueriesSharedLock();
        synchronized (object) {
            None$ none$2;
            userSpecifiedName.foreach((Function1 & Serializable & scala.Serializable)name -> {
                StreamingQueryManager.$anonfun$startQuery$1(this, name);
                return BoxedUnit.UNIT;
            });
            Option activeOption = Option$.MODULE$.apply((Object)this.sparkSession.sharedState().activeStreamingQueries().get(query.id())).orElse((Function0 & Serializable & scala.Serializable)() -> this.activeQueries().get((Object)query.id()));
            boolean shouldStopActiveRun = BoxesRunTime.unboxToBoolean(this.sparkSession.conf().get(SQLConf$.MODULE$.STREAMING_STOP_ACTIVE_RUN_ON_RESTART()));
            if (activeOption.isDefined()) {
                if (!shouldStopActiveRun) throw new IllegalStateException(new StringBuilder(259).append("Cannot start query with id ").append(query.id()).append(" as another query with same id is ").append("already active. Perhaps you are attempting to restart a query from checkpoint ").append("that is already active. You may stop the old query by setting the SQL ").append("configuration: ").append("spark.conf.set(\"").append(SQLConf$.MODULE$.STREAMING_STOP_ACTIVE_RUN_ON_RESTART().key()).append("\", true) ").append("and retry.").toString());
                StreamingQuery oldQuery = (StreamingQuery)activeOption.get();
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(79).append("Stopping existing streaming query [id=").append(query.id()).append(", ").append("runId=").append(oldQuery.runId()).append("], as a new run is being started.").toString());
                none$2 = new Some((Object)oldQuery);
            } else {
                none$2 = None$.MODULE$;
            }
            none$ = none$2;
        }
        None$ activeRunOpt = none$;
        activeRunOpt.foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
            x$2.stop();
            return BoxedUnit.UNIT;
        });
        Object object2 = this.activeQueriesSharedLock();
        synchronized (object2) {
            StreamExecution oldActiveQuery = this.sparkSession.sharedState().activeStreamingQueries().put(query.id(), query.streamingQuery());
            if (oldActiveQuery != null) {
                throw QueryExecutionErrors$.MODULE$.concurrentQueryInstanceError();
            }
            this.activeQueries().put((Object)query.id(), (Object)query);
        }
        try {
            query.streamingQuery().start();
            return query;
        }
        catch (Throwable e) {
            this.unregisterTerminatedStream(query);
            throw e;
        }
    }

    public boolean startQuery$default$7() {
        return false;
    }

    public boolean startQuery$default$8() {
        return true;
    }

    public Trigger startQuery$default$9() {
        return Trigger.ProcessingTime((long)0L);
    }

    public Clock startQuery$default$10() {
        return new SystemClock();
    }

    public Option<Tuple2<TableCatalog, Identifier>> startQuery$default$11() {
        return None$.MODULE$;
    }

    public Option<CatalogTable> startQuery$default$12() {
        return None$.MODULE$;
    }

    public void notifyQueryTermination(StreamingQuery terminatedQuery) {
        this.unregisterTerminatedStream(terminatedQuery);
        Object object = this.awaitTerminationLock();
        synchronized (object) {
            if (this.lastTerminatedQueryException() == null || terminatedQuery.exception().nonEmpty()) {
                this.lastTerminatedQueryException_$eq(terminatedQuery.exception());
            }
            this.awaitTerminationLock().notifyAll();
        }
        this.stateStoreCoordinator().deactivateInstances(terminatedQuery.runId());
    }

    private void unregisterTerminatedStream(StreamingQuery terminatedQuery) {
        Object object = this.activeQueriesSharedLock();
        synchronized (object) {
            this.sparkSession.sharedState().activeStreamingQueries().remove(terminatedQuery.id(), terminatedQuery);
            this.activeQueries().$minus$eq((Object)terminatedQuery.id());
        }
    }

    public static final /* synthetic */ void $anonfun$new$3(StreamingQueryManager $this, StreamingQueryListener listener) {
        $this.addListener(listener);
        $this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(20).append("Registered listener ").append(listener.getClass().getName()).toString());
    }

    private static final boolean isTimedout$1(long startTime$1, long timeoutMs$1) {
        return System.nanoTime() - startTime$1 >= TimeUnit.MILLISECONDS.toNanos(timeoutMs$1);
    }

    public static final /* synthetic */ boolean $anonfun$startQuery$2(String name$1, StreamingQuery x$1) {
        String string = x$1.name();
        String string2 = name$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$startQuery$1(StreamingQueryManager $this, String name) {
        if ($this.activeQueries().values().exists((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)StreamingQueryManager.$anonfun$startQuery$2(name, x$1)))) {
            throw new IllegalArgumentException(new StringBuilder(94).append("Cannot start query with name ").append(name).append(" as a query ").append("with that name is already active in this SparkSession").toString());
        }
    }

    public StreamingQueryManager(SparkSession sparkSession, SQLConf sqlConf) {
        this.sparkSession = sparkSession;
        this.sqlConf = sqlConf;
        Logging.$init$((Logging)this);
        this.stateStoreCoordinator = StateStoreCoordinatorRef$.MODULE$.forDriver(sparkSession.sparkContext().env());
        this.listenerBus = new StreamingQueryListenerBus((Option<LiveListenerBus>)new Some((Object)sparkSession.sparkContext().listenerBus()));
        this.activeQueries = new HashMap();
        this.activeQueriesSharedLock = sparkSession.sharedState().activeQueriesLock();
        this.awaitTerminationLock = new Object();
        this.lastTerminatedQueryException = null;
        try {
            ((Option)sparkSession.sparkContext().conf().get((ConfigEntry)StaticSQLConf$.MODULE$.STREAMING_QUERY_LISTENERS())).foreach((Function1 & Serializable & scala.Serializable)classNames -> {
                SQLConf$.MODULE$.withExistingConf(this.sqlConf, (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> Utils$.MODULE$.loadExtensions(StreamingQueryListener.class, classNames, this.sparkSession.sparkContext().conf()).foreach((Function1 & Serializable & scala.Serializable)listener -> {
                    StreamingQueryManager.$anonfun$new$3($this, listener);
                    return BoxedUnit.UNIT;
                }));
                return BoxedUnit.UNIT;
            });
            sparkSession.sharedState().streamingQueryStatusListener().foreach((Function1 & Serializable & scala.Serializable)listener -> {
                this.addListener(listener);
                return BoxedUnit.UNIT;
            });
        }
        catch (Exception e) {
            throw QueryExecutionErrors$.MODULE$.registeringStreamingQueryListenerError(e);
        }
    }
}

