/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.parquet;

import java.io.Serializable;
import java.time.ZoneId;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.TaskID;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.mapreduce.task.TaskAttemptContextImpl;
import org.apache.parquet.filter2.compat.FilterCompat;
import org.apache.parquet.filter2.predicate.FilterApi;
import org.apache.parquet.filter2.predicate.FilterPredicate;
import org.apache.parquet.hadoop.Footer;
import org.apache.parquet.hadoop.ParquetInputFormat;
import org.apache.parquet.hadoop.ParquetRecordReader;
import org.apache.parquet.hadoop.api.ReadSupport;
import org.apache.parquet.hadoop.metadata.FileMetaData;
import org.apache.parquet.hadoop.metadata.ParquetMetadata;
import org.apache.parquet.schema.MessageType;
import org.apache.spark.TaskContext$;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.JoinedRow;
import org.apache.spark.sql.catalyst.expressions.UnsafeProjection;
import org.apache.spark.sql.catalyst.expressions.codegen.GenerateUnsafeProjection$;
import org.apache.spark.sql.catalyst.types.DataTypeUtils$;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.catalyst.util.RebaseDateTime;
import org.apache.spark.sql.execution.datasources.DataSourceUtils$;
import org.apache.spark.sql.execution.datasources.FileFormat;
import org.apache.spark.sql.execution.datasources.FileFormat$;
import org.apache.spark.sql.execution.datasources.OutputWriterFactory;
import org.apache.spark.sql.execution.datasources.PartitionedFile;
import org.apache.spark.sql.execution.datasources.RecordReaderIterator;
import org.apache.spark.sql.execution.datasources.parquet.ParquetFileFormat$;
import org.apache.spark.sql.execution.datasources.parquet.ParquetFilters;
import org.apache.spark.sql.execution.datasources.parquet.ParquetFooterReader;
import org.apache.spark.sql.execution.datasources.parquet.ParquetOptions;
import org.apache.spark.sql.execution.datasources.parquet.ParquetReadSupport;
import org.apache.spark.sql.execution.datasources.parquet.ParquetReadSupport$;
import org.apache.spark.sql.execution.datasources.parquet.ParquetRowIndexUtil$;
import org.apache.spark.sql.execution.datasources.parquet.ParquetToSparkSchemaConverter;
import org.apache.spark.sql.execution.datasources.parquet.ParquetUtils$;
import org.apache.spark.sql.execution.datasources.parquet.ParquetWriteSupport$;
import org.apache.spark.sql.execution.datasources.parquet.VectorizedParquetRecordReader;
import org.apache.spark.sql.execution.vectorized.ConstantColumnVector;
import org.apache.spark.sql.execution.vectorized.OffHeapColumnVector;
import org.apache.spark.sql.execution.vectorized.OnHeapColumnVector;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.sources.DataSourceRegister;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.UserDefinedType;
import org.apache.spark.util.SerializableConfiguration;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\t\u0005d\u0001B\u000f\u001f\u00015BQa\u0012\u0001\u0005\u0002!CQa\u0013\u0001\u0005B1CQ\u0001\u0017\u0001\u0005B1CQ!\u0017\u0001\u0005BiCQA\u0018\u0001\u0005B}CQ\u0001\u001b\u0001\u0005B%Dq!!\u0006\u0001\t\u0003\n9\u0002C\u0004\u0002H\u0001!\t%!\u0013\t\u000f\u0005E\u0003\u0001\"\u0011\u0002T!9\u0011q\u000e\u0001\u0005B\u0005E\u0004bBAA\u0001\u0011\u0005\u00131\u0011\u0005\b\u0003\u0013\u0004A\u0011IAf\u0011\u001d\t9\u000e\u0001C!\u00033<q!a9\u001f\u0011\u0003\t)O\u0002\u0004\u001e=!\u0005\u0011q\u001d\u0005\u0007\u000f>!\t!!;\t\u0013\u0005-xB1A\u0005\u0002\u00055\b\u0002CA\u007f\u001f\u0001\u0006I!a<\t\u0013\u0005}xB1A\u0005\u0002\t\u0005\u0001b\u0002B\u0002\u001f\u0001\u0006I!\u0014\u0005\n\u0005\u000by!\u0019!C\u0001\u0005\u000fA\u0001B!\u0003\u0010A\u0003%\u0011Q\u001c\u0005\t\u0005\u0017yA\u0011\u0001\u0010\u0003\u000e!A!1E\b\u0005\u0002y\u0011)\u0003C\u0004\u00032=!\tAa\r\t\u000f\tur\u0002\"\u0001\u0003@!9!qJ\b\u0005\n\tE\u0003\"\u0003B,\u001f\u0005\u0005I\u0011\u0002B-\u0005E\u0001\u0016M]9vKR4\u0015\u000e\\3G_Jl\u0017\r\u001e\u0006\u0003?\u0001\nq\u0001]1scV,GO\u0003\u0002\"E\u0005YA-\u0019;bg>,(oY3t\u0015\t\u0019C%A\u0005fq\u0016\u001cW\u000f^5p]*\u0011QEJ\u0001\u0004gFd'BA\u0014)\u0003\u0015\u0019\b/\u0019:l\u0015\tI#&\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002W\u0005\u0019qN]4\u0004\u0001M1\u0001A\f\u001b9}\u0011\u0003\"a\f\u001a\u000e\u0003AR\u0011!M\u0001\u0006g\u000e\fG.Y\u0005\u0003gA\u0012a!\u00118z%\u00164\u0007CA\u001b7\u001b\u0005\u0001\u0013BA\u001c!\u0005)1\u0015\u000e\\3G_Jl\u0017\r\u001e\t\u0003sqj\u0011A\u000f\u0006\u0003w\u0011\nqa]8ve\u000e,7/\u0003\u0002>u\t\u0011B)\u0019;b'>,(oY3SK\u001eL7\u000f^3s!\ty$)D\u0001A\u0015\t\te%\u0001\u0005j]R,'O\\1m\u0013\t\u0019\u0005IA\u0004M_\u001e<\u0017N\\4\u0011\u0005=*\u0015B\u0001$1\u00051\u0019VM]5bY&T\u0018M\u00197f\u0003\u0019a\u0014N\\5u}Q\t\u0011\n\u0005\u0002K\u00015\ta$A\u0005tQ>\u0014HOT1nKR\tQ\n\u0005\u0002O+:\u0011qj\u0015\t\u0003!Bj\u0011!\u0015\u0006\u0003%2\na\u0001\u0010:p_Rt\u0014B\u0001+1\u0003\u0019\u0001&/\u001a3fM&\u0011ak\u0016\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005Q\u0003\u0014\u0001\u0003;p'R\u0014\u0018N\\4\u0002\u0011!\f7\u000f[\"pI\u0016$\u0012a\u0017\t\u0003_qK!!\u0018\u0019\u0003\u0007%sG/\u0001\u0004fcV\fGn\u001d\u000b\u0003A\u000e\u0004\"aL1\n\u0005\t\u0004$a\u0002\"p_2,\u0017M\u001c\u0005\u0006I\u0016\u0001\r!Z\u0001\u0006_RDWM\u001d\t\u0003_\u0019L!a\u001a\u0019\u0003\u0007\u0005s\u00170\u0001\u0007qe\u0016\u0004\u0018M]3Xe&$X\r\u0006\u0004k[Nl\u0018Q\u0001\t\u0003k-L!\u0001\u001c\u0011\u0003'=+H\u000f];u/JLG/\u001a:GC\u000e$xN]=\t\u000b94\u0001\u0019A8\u0002\u0019M\u0004\u0018M]6TKN\u001c\u0018n\u001c8\u0011\u0005A\fX\"\u0001\u0013\n\u0005I$#\u0001D*qCJ\\7+Z:tS>t\u0007\"\u0002;\u0007\u0001\u0004)\u0018a\u00016pEB\u0011ao_\u0007\u0002o*\u0011\u00010_\u0001\n[\u0006\u0004(/\u001a3vG\u0016T!A\u001f\u0015\u0002\r!\fGm\\8q\u0013\taxOA\u0002K_\nDQA \u0004A\u0002}\fqa\u001c9uS>t7\u000fE\u0003O\u0003\u0003iU*C\u0002\u0002\u0004]\u00131!T1q\u0011\u001d\t9A\u0002a\u0001\u0003\u0013\t!\u0002Z1uCN\u001b\u0007.Z7b!\u0011\tY!!\u0005\u000e\u0005\u00055!bAA\bI\u0005)A/\u001f9fg&!\u00111CA\u0007\u0005)\u0019FO];diRK\b/Z\u0001\fS:4WM]*dQ\u0016l\u0017\r\u0006\u0005\u0002\u001a\u0005}\u0011\u0011EA\u0013!\u0015y\u00131DA\u0005\u0013\r\ti\u0002\r\u0002\u0007\u001fB$\u0018n\u001c8\t\u000b9<\u0001\u0019A8\t\r\u0005\rr\u00011\u0001\u0000\u0003)\u0001\u0018M]1nKR,'o\u001d\u0005\b\u0003O9\u0001\u0019AA\u0015\u0003\u00151\u0017\u000e\\3t!\u0019\tY#!\u000e\u0002<9!\u0011QFA\u0019\u001d\r\u0001\u0016qF\u0005\u0002c%\u0019\u00111\u0007\u0019\u0002\u000fA\f7m[1hK&!\u0011qGA\u001d\u0005\r\u0019V-\u001d\u0006\u0004\u0003g\u0001\u0004\u0003BA\u001f\u0003\u0007j!!a\u0010\u000b\u0007\u0005\u0005\u00130\u0001\u0002gg&!\u0011QIA \u0005)1\u0015\u000e\\3Ti\u0006$Xo]\u0001\rgV\u0004\bo\u001c:u\u0005\u0006$8\r\u001b\u000b\u0006A\u0006-\u0013Q\n\u0005\u0006]\"\u0001\ra\u001c\u0005\b\u0003\u001fB\u0001\u0019AA\u0005\u0003\u0019\u00198\r[3nC\u0006Ya/Z2u_J$\u0016\u0010]3t)!\t)&!\u0017\u0002^\u0005\u0005\u0004#B\u0018\u0002\u001c\u0005]\u0003#BA\u0016\u0003ki\u0005bBA.\u0013\u0001\u0007\u0011\u0011B\u0001\u000fe\u0016\fX/\u001b:fIN\u001b\u0007.Z7b\u0011\u001d\ty&\u0003a\u0001\u0003\u0013\tq\u0002]1si&$\u0018n\u001c8TG\",W.\u0019\u0005\b\u0003GJ\u0001\u0019AA3\u0003\u001d\u0019\u0018\u000f\\\"p]\u001a\u0004B!a\u001a\u0002l5\u0011\u0011\u0011\u000e\u0006\u0003\u0003\u0012JA!!\u001c\u0002j\t91+\u0015'D_:4\u0017aC5t'Bd\u0017\u000e^1cY\u0016$r\u0001YA:\u0003k\n9\bC\u0003o\u0015\u0001\u0007q\u000eC\u0003\u007f\u0015\u0001\u0007q\u0010C\u0004\u0002z)\u0001\r!a\u001f\u0002\tA\fG\u000f\u001b\t\u0005\u0003{\ti(\u0003\u0003\u0002\u0000\u0005}\"\u0001\u0002)bi\"\faDY;jY\u0012\u0014V-\u00193fe^KG\u000f\u001b)beRLG/[8o-\u0006dW/Z:\u0015!\u0005\u0015\u00151UAS\u0003O\u000bI+a+\u00028\u0006e\u0006cB\u0018\u0002\b\u0006-\u0015\u0011S\u0005\u0004\u0003\u0013\u0003$!\u0003$v]\u000e$\u0018n\u001c82!\r)\u0014QR\u0005\u0004\u0003\u001f\u0003#a\u0004)beRLG/[8oK\u00124\u0015\u000e\\3\u0011\r\u0005-\u00121SAL\u0013\u0011\t)*!\u000f\u0003\u0011%#XM]1u_J\u0004B!!'\u0002 6\u0011\u00111\u0014\u0006\u0004\u0003;#\u0013\u0001C2bi\u0006d\u0017p\u001d;\n\t\u0005\u0005\u00161\u0014\u0002\f\u0013:$XM\u001d8bYJ{w\u000fC\u0003o\u0017\u0001\u0007q\u000eC\u0004\u0002\b-\u0001\r!!\u0003\t\u000f\u0005}3\u00021\u0001\u0002\n!9\u00111L\u0006A\u0002\u0005%\u0001bBAW\u0017\u0001\u0007\u0011qV\u0001\bM&dG/\u001a:t!\u0019\tY#!\u000e\u00022B\u0019\u0011(a-\n\u0007\u0005U&H\u0001\u0004GS2$XM\u001d\u0005\u0006}.\u0001\ra \u0005\b\u0003w[\u0001\u0019AA_\u0003)A\u0017\rZ8pa\u000e{gN\u001a\t\u0005\u0003\u007f\u000b)-\u0004\u0002\u0002B*\u0019\u00111Y=\u0002\t\r|gNZ\u0005\u0005\u0003\u000f\f\tMA\u0007D_:4\u0017nZ;sCRLwN\\\u0001\u0010gV\u0004\bo\u001c:u\t\u0006$\u0018\rV=qKR\u0019\u0001-!4\t\u000f\u0005=G\u00021\u0001\u0002R\u0006AA-\u0019;b)f\u0004X\r\u0005\u0003\u0002\f\u0005M\u0017\u0002BAk\u0003\u001b\u0011\u0001\u0002R1uCRK\b/Z\u0001\u0015[\u0016$\u0018\rZ1uCN\u001b\u0007.Z7b\r&,G\u000eZ:\u0016\u0005\u0005m\u0007CBA\u0016\u0003k\ti\u000e\u0005\u0003\u0002\f\u0005}\u0017\u0002BAq\u0003\u001b\u00111b\u0015;sk\u000e$h)[3mI\u0006\t\u0002+\u0019:rk\u0016$h)\u001b7f\r>\u0014X.\u0019;\u0011\u0005){1\u0003B\b/}\u0011#\"!!:\u0002\u0013I{ukX%O\t\u0016CVCAAx!\u0011\t\t0a?\u000e\u0005\u0005M(\u0002BA{\u0003o\fA\u0001\\1oO*\u0011\u0011\u0011`\u0001\u0005U\u00064\u0018-C\u0002W\u0003g\f!BU(X?&sE)\u0012-!\u0003}\u0011vjV0J\u001d\u0012+\u0005l\u0018+F\u001bB{%+\u0011*Z?\u000e{E*V'O?:\u000bU*R\u000b\u0002\u001b\u0006\u0001#kT,`\u0013:#U\tW0U\u000b6\u0003vJU!S3~\u001bu\nT+N\u001d~s\u0015)T#!\u0003=\u0011vjV0J\u001d\u0012+\u0005l\u0018$J\u000b2#UCAAo\u0003A\u0011vjV0J\u001d\u0012+\u0005l\u0018$J\u000b2#\u0005%\u0001\u0006sK\u0006$7k\u00195f[\u0006$b!!\u0007\u0003\u0010\t\u0005\u0002b\u0002B\t/\u0001\u0007!1C\u0001\bM>|G/\u001a:t!\u0019\tY#!\u000e\u0003\u0016A!!q\u0003B\u000f\u001b\t\u0011IBC\u0002{\u00057Q!a\b\u0015\n\t\t}!\u0011\u0004\u0002\u0007\r>|G/\u001a:\t\u000b9<\u0002\u0019A8\u00029I,\u0017\r\u001a)beF,X\r\u001e$p_R,'o]%o!\u0006\u0014\u0018\r\u001c7fYRA!1\u0003B\u0014\u0005S\u0011i\u0003C\u0004\u0002Db\u0001\r!!0\t\u000f\t-\u0002\u00041\u0001\u0002*\u0005I\u0001/\u0019:u\r&dWm\u001d\u0005\u0007\u0005_A\u0002\u0019\u00011\u0002%%<gn\u001c:f\u0007>\u0014(/\u001e9u\r&dWm]\u0001\u0017[\u0016\u0014x-Z*dQ\u0016l\u0017m]%o!\u0006\u0014\u0018\r\u001c7fYRA\u0011\u0011\u0004B\u001b\u0005o\u0011Y\u0004\u0003\u0004\u0002$e\u0001\ra \u0005\b\u0005sI\u0002\u0019AA\u0015\u000311\u0017\u000e\\3t)>$v.^2i\u0011\u0015q\u0017\u00041\u0001p\u0003Q\u0011X-\u00193TG\",W.\u0019$s_64un\u001c;feR1\u0011\u0011\u0002B!\u0005\u000bBqAa\u0011\u001b\u0001\u0004\u0011)\"\u0001\u0004g_>$XM\u001d\u0005\b\u0005\u000fR\u0002\u0019\u0001B%\u0003%\u0019wN\u001c<feR,'\u000fE\u0002K\u0005\u0017J1A!\u0014\u001f\u0005u\u0001\u0016M]9vKR$vn\u00159be.\u001c6\r[3nC\u000e{gN^3si\u0016\u0014\u0018a\u00063fg\u0016\u0014\u0018.\u00197ju\u0016\u001c6\r[3nCN#(/\u001b8h)\u0011\tIBa\u0015\t\r\tU3\u00041\u0001N\u00031\u00198\r[3nCN#(/\u001b8h\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\tm\u0003\u0003BAy\u0005;JAAa\u0018\u0002t\n1qJ\u00196fGR\u0004")
public class ParquetFileFormat
implements FileFormat,
DataSourceRegister,
Logging,
scala.Serializable {
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static StructType readSchemaFromFooter(Footer footer, ParquetToSparkSchemaConverter parquetToSparkSchemaConverter) {
        return ParquetFileFormat$.MODULE$.readSchemaFromFooter(footer, parquetToSparkSchemaConverter);
    }

    public static Option<StructType> mergeSchemasInParallel(scala.collection.immutable.Map<String, String> map, Seq<FileStatus> seq, SparkSession sparkSession) {
        return ParquetFileFormat$.MODULE$.mergeSchemasInParallel(map, seq, sparkSession);
    }

    public static StructField ROW_INDEX_FIELD() {
        return ParquetFileFormat$.MODULE$.ROW_INDEX_FIELD();
    }

    public static String ROW_INDEX_TEMPORARY_COLUMN_NAME() {
        return ParquetFileFormat$.MODULE$.ROW_INDEX_TEMPORARY_COLUMN_NAME();
    }

    public static String ROW_INDEX() {
        return ParquetFileFormat$.MODULE$.ROW_INDEX();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    @Override
    public Function1<PartitionedFile, Iterator<InternalRow>> buildReader(SparkSession sparkSession, StructType dataSchema, StructType partitionSchema, StructType requiredSchema, Seq<Filter> filters, scala.collection.immutable.Map<String, String> options, Configuration hadoopConf) {
        return FileFormat.buildReader$(this, sparkSession, dataSchema, partitionSchema, requiredSchema, filters, options, hadoopConf);
    }

    @Override
    public AttributeReference createFileMetadataCol() {
        return FileFormat.createFileMetadataCol$(this);
    }

    @Override
    public boolean supportFieldName(String name) {
        return FileFormat.supportFieldName$(this, name);
    }

    @Override
    public scala.collection.immutable.Map<String, Function1<PartitionedFile, Object>> fileConstantMetadataExtractors() {
        return FileFormat.fileConstantMetadataExtractors$(this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    @Override
    public String shortName() {
        return "parquet";
    }

    public String toString() {
        return "Parquet";
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    public boolean equals(Object other) {
        return other instanceof ParquetFileFormat;
    }

    @Override
    public OutputWriterFactory prepareWrite(SparkSession sparkSession, Job job, scala.collection.immutable.Map<String, String> options, StructType dataSchema) {
        SQLConf sqlConf = sparkSession.sessionState().conf();
        ParquetOptions parquetOptions = new ParquetOptions(options, sqlConf);
        return ParquetUtils$.MODULE$.prepareWrite(sqlConf, job, dataSchema, parquetOptions);
    }

    @Override
    public Option<StructType> inferSchema(SparkSession sparkSession, scala.collection.immutable.Map<String, String> parameters, Seq<FileStatus> files) {
        return ParquetUtils$.MODULE$.inferSchema(sparkSession, parameters, files);
    }

    @Override
    public boolean supportBatch(SparkSession sparkSession, StructType schema) {
        SQLConf conf = sparkSession.sessionState().conf();
        return ParquetUtils$.MODULE$.isBatchReadSupportedForSchema(conf, schema);
    }

    @Override
    public Option<Seq<String>> vectorTypes(StructType requiredSchema, StructType partitionSchema, SQLConf sqlConf) {
        return Option$.MODULE$.apply(((TraversableLike)Seq$.MODULE$.fill(requiredSchema.fields().length, (Function0 & Serializable & scala.Serializable)() -> {
            if (!sqlConf.offHeapColumnVectorEnabled()) {
                return OnHeapColumnVector.class.getName();
            }
            return OffHeapColumnVector.class.getName();
        })).$plus$plus((GenTraversableOnce)Seq$.MODULE$.fill(partitionSchema.fields().length, (Function0 & Serializable & scala.Serializable)() -> ConstantColumnVector.class.getName()), Seq$.MODULE$.canBuildFrom()));
    }

    @Override
    public boolean isSplitable(SparkSession sparkSession, scala.collection.immutable.Map<String, String> options, Path path) {
        return true;
    }

    @Override
    public Function1<PartitionedFile, Iterator<InternalRow>> buildReaderWithPartitionValues(SparkSession sparkSession, StructType dataSchema, StructType partitionSchema, StructType requiredSchema, Seq<Filter> filters, scala.collection.immutable.Map<String, String> options, Configuration hadoopConf) {
        boolean returningBatch;
        String int96RebaseModeInRead;
        String datetimeRebaseModeInRead;
        boolean isCaseSensitive;
        int pushDownInFilterThreshold;
        boolean pushDownStringPredicate;
        boolean pushDownDecimal;
        boolean pushDownTimestamp;
        boolean pushDownDate;
        boolean enableParquetFilterPushDown;
        int capacity;
        boolean timestampConversion;
        boolean enableRecordFilter;
        boolean enableVectorizedReader;
        boolean enableOffHeapColumnVector;
        Broadcast broadcastedHadoopConf;
        block0: {
            hadoopConf.set("parquet.read.support.class", ParquetReadSupport.class.getName());
            hadoopConf.set(ParquetReadSupport$.MODULE$.SPARK_ROW_REQUESTED_SCHEMA(), requiredSchema.json());
            hadoopConf.set(ParquetWriteSupport$.MODULE$.SPARK_ROW_SCHEMA(), requiredSchema.json());
            hadoopConf.set(SQLConf$.MODULE$.SESSION_LOCAL_TIMEZONE().key(), sparkSession.sessionState().conf().sessionLocalTimeZone());
            hadoopConf.setBoolean(SQLConf$.MODULE$.NESTED_SCHEMA_PRUNING_ENABLED().key(), sparkSession.sessionState().conf().nestedSchemaPruningEnabled());
            hadoopConf.setBoolean(SQLConf$.MODULE$.CASE_SENSITIVE().key(), sparkSession.sessionState().conf().caseSensitiveAnalysis());
            hadoopConf.setBoolean(SQLConf$.MODULE$.PARQUET_BINARY_AS_STRING().key(), sparkSession.sessionState().conf().isParquetBinaryAsString());
            hadoopConf.setBoolean(SQLConf$.MODULE$.PARQUET_INT96_AS_TIMESTAMP().key(), sparkSession.sessionState().conf().isParquetINT96AsTimestamp());
            hadoopConf.setBoolean(SQLConf$.MODULE$.PARQUET_INFER_TIMESTAMP_NTZ_ENABLED().key(), sparkSession.sessionState().conf().parquetInferTimestampNTZEnabled());
            hadoopConf.setBoolean(SQLConf$.MODULE$.LEGACY_PARQUET_NANOS_AS_LONG().key(), sparkSession.sessionState().conf().legacyParquetNanosAsLong());
            broadcastedHadoopConf = sparkSession.sparkContext().broadcast((Object)new SerializableConfiguration(hadoopConf), ClassTag$.MODULE$.apply(SerializableConfiguration.class));
            StructType resultSchema = new StructType((StructField[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])partitionSchema.fields())).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])requiredSchema.fields())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(StructField.class))));
            SQLConf sqlConf = sparkSession.sessionState().conf();
            enableOffHeapColumnVector = sqlConf.offHeapColumnVectorEnabled();
            enableVectorizedReader = ParquetUtils$.MODULE$.isBatchReadSupportedForSchema(sqlConf, resultSchema);
            enableRecordFilter = sqlConf.parquetRecordFilterEnabled();
            timestampConversion = sqlConf.isParquetINT96TimestampConversion();
            capacity = sqlConf.parquetVectorizedReaderBatchSize();
            enableParquetFilterPushDown = sqlConf.parquetFilterPushDown();
            pushDownDate = sqlConf.parquetFilterPushDownDate();
            pushDownTimestamp = sqlConf.parquetFilterPushDownTimestamp();
            pushDownDecimal = sqlConf.parquetFilterPushDownDecimal();
            pushDownStringPredicate = sqlConf.parquetFilterPushDownStringPredicate();
            pushDownInFilterThreshold = sqlConf.parquetFilterPushDownInFilterThreshold();
            isCaseSensitive = sqlConf.caseSensitiveAnalysis();
            ParquetOptions parquetOptions = new ParquetOptions(options, sparkSession.sessionState().conf());
            datetimeRebaseModeInRead = parquetOptions.datetimeRebaseModeInRead();
            int96RebaseModeInRead = parquetOptions.int96RebaseModeInRead();
            boolean bl = returningBatch = sparkSession.sessionState().conf().parquetVectorizedReaderEnabled() && ((String)options.getOrElse((Object)FileFormat$.MODULE$.OPTION_RETURNING_BATCH(), (Function0 & Serializable & scala.Serializable)() -> {
                throw new IllegalArgumentException("OPTION_RETURNING_BATCH should always be set for ParquetFileFormat. To workaround this issue, set spark.sql.parquet.enableVectorizedReader=false.");
            })).equals("true");
            if (!returningBatch) break block0;
            Predef$.MODULE$.assert(this.supportBatch(sparkSession, resultSchema));
        }
        return (Function1 & Serializable & scala.Serializable)file -> {
            Iterator iterator;
            ParquetRecordReader parquetRecordReader;
            None$ none$;
            Predef$.MODULE$.assert(file.partitionValues().numFields() == partitionSchema.size());
            Path filePath = file.toPath();
            FileSplit split = new FileSplit(filePath, file.start(), file.length(), (String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class)));
            Configuration sharedConf = ((SerializableConfiguration)broadcastedHadoopConf.value()).value();
            ParquetMetadata fileFooter = enableVectorizedReader ? ParquetFooterReader.readFooter(sharedConf, file, false) : ParquetFooterReader.readFooter(sharedConf, file, true);
            FileMetaData footerFileMetaData = fileFooter.getFileMetaData();
            Map map = footerFileMetaData.getKeyValueMetaData();
            RebaseDateTime.RebaseSpec datetimeRebaseSpec = DataSourceUtils$.MODULE$.datetimeRebaseSpec((Function1<String, String>)(Function1 & Serializable & scala.Serializable)x$1 -> (String)map.get(x$1), datetimeRebaseModeInRead);
            Map map2 = footerFileMetaData.getKeyValueMetaData();
            RebaseDateTime.RebaseSpec int96RebaseSpec = DataSourceUtils$.MODULE$.int96RebaseSpec((Function1<String, String>)(Function1 & Serializable & scala.Serializable)x$1 -> (String)map2.get(x$1), int96RebaseModeInRead);
            if (enableParquetFilterPushDown) {
                MessageType parquetSchema = footerFileMetaData.getSchema();
                ParquetFilters parquetFilters = new ParquetFilters(parquetSchema, pushDownDate, pushDownTimestamp, pushDownDecimal, pushDownStringPredicate, pushDownInFilterThreshold, isCaseSensitive, datetimeRebaseSpec);
                none$ = ((TraversableOnce)filters.flatMap((Function1 & Serializable & scala.Serializable)x$1 -> Option$.MODULE$.option2Iterable(parquetFilters.createFilter((Filter)x$1)), Seq$.MODULE$.canBuildFrom())).reduceOption((Function2 & Serializable & scala.Serializable)(x$1, x$2) -> FilterApi.and((FilterPredicate)x$1, (FilterPredicate)x$2));
            } else {
                none$ = None$.MODULE$;
            }
            None$ pushed = none$;
            None$ convertTz = timestampConversion && !ParquetFileFormat.isCreatedByParquetMr$1(footerFileMetaData) ? new Some((Object)DateTimeUtils$.MODULE$.getZoneId(sharedConf.get(SQLConf$.MODULE$.SESSION_LOCAL_TIMEZONE().key()))) : None$.MODULE$;
            TaskAttemptID attemptId = new TaskAttemptID(new TaskID(new JobID(), TaskType.MAP, 0), 0);
            TaskAttemptContextImpl hadoopAttemptContext = new TaskAttemptContextImpl(((SerializableConfiguration)broadcastedHadoopConf.value()).value(), attemptId);
            if (pushed.isDefined()) {
                ParquetInputFormat.setFilterPredicate((Configuration)hadoopAttemptContext.getConfiguration(), (FilterPredicate)((FilterPredicate)pushed.get()));
            }
            Option taskContext = Option$.MODULE$.apply((Object)TaskContext$.MODULE$.get());
            if (enableVectorizedReader) {
                RecordReaderIterator<Object> recordReaderIterator;
                VectorizedParquetRecordReader vectorizedReader = new VectorizedParquetRecordReader((ZoneId)convertTz.orNull(Predef$.MODULE$.$conforms()), datetimeRebaseSpec.mode().toString(), datetimeRebaseSpec.timeZone(), int96RebaseSpec.mode().toString(), int96RebaseSpec.timeZone(), enableOffHeapColumnVector && taskContext.isDefined(), capacity);
                RecordReaderIterator<Object> iter = new RecordReaderIterator<Object>(vectorizedReader);
                try {
                    vectorizedReader.initialize((InputSplit)split, (TaskAttemptContext)hadoopAttemptContext, (Option<ParquetMetadata>)Option$.MODULE$.apply((Object)fileFooter));
                    this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(11).append("Appending ").append(partitionSchema).append(" ").append(file.partitionValues()).toString());
                    vectorizedReader.initBatch(partitionSchema, file.partitionValues());
                    if (returningBatch) {
                        vectorizedReader.enableReturningBatches();
                    }
                    recordReaderIterator = iter;
                }
                catch (Throwable e) {
                    iter.close();
                    throw e;
                }
                return recordReaderIterator;
            }
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Falling back to parquet-mr");
            ParquetReadSupport readSupport = new ParquetReadSupport((Option<ZoneId>)convertTz, false, datetimeRebaseSpec, int96RebaseSpec);
            if (pushed.isDefined() && enableRecordFilter) {
                FilterCompat.Filter parquetFilter = FilterCompat.get((FilterPredicate)((FilterPredicate)pushed.get()), null);
                parquetRecordReader = new ParquetRecordReader((ReadSupport)readSupport, parquetFilter);
            } else {
                parquetRecordReader = new ParquetRecordReader((ReadSupport)readSupport);
            }
            ParquetRecordReader reader = parquetRecordReader;
            RecordReader<Void, InternalRow> readerWithRowIndexes = ParquetRowIndexUtil$.MODULE$.addRowIndexToRecordReaderIfNeeded((ParquetRecordReader<InternalRow>)reader, requiredSchema);
            RecordReaderIterator<InternalRow> iter = new RecordReaderIterator<InternalRow>(readerWithRowIndexes);
            try {
                readerWithRowIndexes.initialize((InputSplit)split, (TaskAttemptContext)hadoopAttemptContext);
                Seq fullSchema = (Seq)DataTypeUtils$.MODULE$.toAttributes(requiredSchema).$plus$plus((GenTraversableOnce)DataTypeUtils$.MODULE$.toAttributes(partitionSchema), Seq$.MODULE$.canBuildFrom());
                UnsafeProjection unsafeProjection = (UnsafeProjection)GenerateUnsafeProjection$.MODULE$.generate((Object)fullSchema, fullSchema);
                if (partitionSchema.length() == 0) {
                    iterator = iter.map(unsafeProjection);
                } else {
                    JoinedRow joinedRow = new JoinedRow();
                    iterator = iter.map((Function1 & Serializable & scala.Serializable)d -> unsafeProjection.apply((InternalRow)joinedRow.apply(d, file.partitionValues())));
                }
            }
            catch (Throwable e) {
                iter.close();
                throw e;
            }
            return iterator;
        };
    }

    @Override
    public boolean supportDataType(DataType dataType) {
        DataType dataType2 = dataType;
        if (dataType2 instanceof AtomicType) {
            return true;
        }
        if (dataType2 instanceof StructType) {
            StructType structType = (StructType)dataType2;
            return structType.forall((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)this.supportDataType(f.dataType())));
        }
        if (dataType2 instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)dataType2;
            DataType elementType = arrayType.elementType();
            return this.supportDataType(elementType);
        }
        if (dataType2 instanceof MapType) {
            MapType mapType = (MapType)dataType2;
            DataType keyType = mapType.keyType();
            DataType valueType = mapType.valueType();
            return this.supportDataType(keyType) && this.supportDataType(valueType);
        }
        if (dataType2 instanceof UserDefinedType) {
            UserDefinedType userDefinedType = (UserDefinedType)dataType2;
            return this.supportDataType(userDefinedType.sqlType());
        }
        return false;
    }

    @Override
    public Seq<StructField> metadataSchemaFields() {
        return (Seq)FileFormat.metadataSchemaFields$(this).$colon$plus((Object)ParquetFileFormat$.MODULE$.ROW_INDEX_FIELD(), Seq$.MODULE$.canBuildFrom());
    }

    private static final boolean isCreatedByParquetMr$1(FileMetaData footerFileMetaData$1) {
        return footerFileMetaData$1.getCreatedBy().startsWith("parquet-mr");
    }

    public ParquetFileFormat() {
        FileFormat.$init$(this);
        Logging.$init$((Logging)this);
    }
}

