/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.vectorized;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.apache.spark.sql.types.CalendarIntervalType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.vectorized.ColumnVector;
import org.apache.spark.sql.vectorized.ColumnarArray;
import org.apache.spark.sql.vectorized.ColumnarMap;
import org.apache.spark.unsafe.types.CalendarInterval;
import org.apache.spark.unsafe.types.UTF8String;

public class ConstantColumnVector
extends ColumnVector {
    private byte nullData;
    private byte byteData;
    private short shortData;
    private int intData;
    private long longData;
    private float floatData;
    private double doubleData;
    private UTF8String stringData;
    private byte[] byteArrayData;
    private ConstantColumnVector[] childData;
    private ColumnarArray arrayData;
    private ColumnarMap mapData;
    private final int numRows;

    public ConstantColumnVector(int numRows, DataType type) {
        super(type);
        this.numRows = numRows;
        if (type instanceof StructType) {
            this.childData = new ConstantColumnVector[((StructType)type).fields().length];
        } else if (type instanceof CalendarIntervalType) {
            this.childData = new ConstantColumnVector[3];
            this.childData[0] = new ConstantColumnVector(1, DataTypes.IntegerType);
            this.childData[1] = new ConstantColumnVector(1, DataTypes.IntegerType);
            this.childData[2] = new ConstantColumnVector(1, DataTypes.LongType);
        } else {
            this.childData = null;
        }
    }

    public void close() {
        this.stringData = null;
        this.byteArrayData = null;
        if (this.childData != null) {
            for (int i = 0; i < this.childData.length; ++i) {
                if (this.childData[i] == null) continue;
                this.childData[i].close();
                this.childData[i] = null;
            }
            this.childData = null;
        }
        this.arrayData = null;
        this.mapData = null;
    }

    public boolean hasNull() {
        return this.nullData == 1;
    }

    public int numNulls() {
        return this.hasNull() ? this.numRows : 0;
    }

    public boolean isNullAt(int rowId) {
        return this.nullData == 1;
    }

    public void setNull() {
        this.nullData = 1;
    }

    public void setNotNull() {
        this.nullData = 0;
    }

    public boolean getBoolean(int rowId) {
        return this.byteData == 1;
    }

    public void setBoolean(boolean value) {
        this.byteData = (byte)(value ? 1 : 0);
    }

    public byte getByte(int rowId) {
        return this.byteData;
    }

    public void setByte(byte value) {
        this.byteData = value;
    }

    public short getShort(int rowId) {
        return this.shortData;
    }

    public void setShort(short value) {
        this.shortData = value;
    }

    public int getInt(int rowId) {
        return this.intData;
    }

    public void setInt(int value) {
        this.intData = value;
    }

    public long getLong(int rowId) {
        return this.longData;
    }

    public void setLong(long value) {
        this.longData = value;
    }

    public float getFloat(int rowId) {
        return this.floatData;
    }

    public void setFloat(float value) {
        this.floatData = value;
    }

    public double getDouble(int rowId) {
        return this.doubleData;
    }

    public void setDouble(double value) {
        this.doubleData = value;
    }

    public ColumnarArray getArray(int rowId) {
        return this.arrayData;
    }

    public void setArray(ColumnarArray value) {
        this.arrayData = value;
    }

    public ColumnarMap getMap(int ordinal) {
        return this.mapData;
    }

    public void setMap(ColumnarMap value) {
        this.mapData = value;
    }

    public Decimal getDecimal(int rowId, int precision, int scale) {
        if (precision <= Decimal.MAX_INT_DIGITS()) {
            return Decimal.createUnsafe((long)this.getInt(rowId), (int)precision, (int)scale);
        }
        if (precision <= Decimal.MAX_LONG_DIGITS()) {
            return Decimal.createUnsafe((long)this.getLong(rowId), (int)precision, (int)scale);
        }
        byte[] bytes = this.getBinary(rowId);
        BigInteger bigInteger = new BigInteger(bytes);
        BigDecimal javaDecimal = new BigDecimal(bigInteger, scale);
        return Decimal.apply((BigDecimal)javaDecimal, (int)precision, (int)scale);
    }

    public void setDecimal(Decimal value, int precision) {
        if (precision <= Decimal.MAX_INT_DIGITS()) {
            this.setInt((int)value.toUnscaledLong());
        } else if (precision <= Decimal.MAX_LONG_DIGITS()) {
            this.setLong(value.toUnscaledLong());
        } else {
            BigInteger bigInteger = value.toJavaBigDecimal().unscaledValue();
            this.setByteArray(bigInteger.toByteArray());
        }
    }

    public UTF8String getUTF8String(int rowId) {
        return this.stringData;
    }

    public void setUtf8String(UTF8String value) {
        this.stringData = value;
    }

    private void setByteArray(byte[] value) {
        this.byteArrayData = value;
    }

    public byte[] getBinary(int rowId) {
        return this.byteArrayData;
    }

    public void setBinary(byte[] value) {
        this.setByteArray(value);
    }

    public ColumnVector getChild(int ordinal) {
        return this.childData[ordinal];
    }

    public void setChild(int ordinal, ConstantColumnVector value) {
        this.childData[ordinal] = value;
    }

    public void setCalendarInterval(CalendarInterval value) {
        this.childData[0].setInt(value.months);
        this.childData[1].setInt(value.days);
        this.childData[2].setLong(value.microseconds);
    }
}

