/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution;

import java.io.Serializable;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.spark.ErrorMessageFormat$;
import org.apache.spark.JobArtifactSet$;
import org.apache.spark.JobArtifactState;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkContext$;
import org.apache.spark.SparkThrowable;
import org.apache.spark.SparkThrowableHelper$;
import org.apache.spark.internal.config.Tests$;
import org.apache.spark.internal.config.package$;
import org.apache.spark.scheduler.SparkListenerEvent;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.execution.ExplainMode;
import org.apache.spark.sql.execution.ExplainMode$;
import org.apache.spark.sql.execution.QueryExecution;
import org.apache.spark.sql.execution.SparkPlanInfo$;
import org.apache.spark.sql.execution.ui.SparkListenerSQLExecutionEnd;
import org.apache.spark.sql.execution.ui.SparkListenerSQLExecutionStart;
import org.apache.spark.sql.internal.StaticSQLConf$;
import org.apache.spark.util.CallSite;
import org.apache.spark.util.Utils$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class SQLExecution$ {
    public static SQLExecution$ MODULE$;
    private final String EXECUTION_ID_KEY;
    private final String EXECUTION_ROOT_ID_KEY;
    private final AtomicLong _nextExecutionId;
    private final ConcurrentHashMap<Object, QueryExecution> executionIdToQueryExecution;
    private final boolean testing;

    static {
        new SQLExecution$();
    }

    public String EXECUTION_ID_KEY() {
        return this.EXECUTION_ID_KEY;
    }

    public String EXECUTION_ROOT_ID_KEY() {
        return this.EXECUTION_ROOT_ID_KEY;
    }

    private AtomicLong _nextExecutionId() {
        return this._nextExecutionId;
    }

    private long nextExecutionId() {
        return this._nextExecutionId().getAndIncrement();
    }

    private ConcurrentHashMap<Object, QueryExecution> executionIdToQueryExecution() {
        return this.executionIdToQueryExecution;
    }

    public QueryExecution getQueryExecution(long executionId) {
        return this.executionIdToQueryExecution().get(BoxesRunTime.boxToLong((long)executionId));
    }

    private boolean testing() {
        return this.testing;
    }

    public void checkSQLExecutionId(SparkSession sparkSession) {
        SparkContext sc = sparkSession.sparkContext();
        if (this.testing() && sc.getLocalProperty(this.EXECUTION_ID_KEY()) == null) {
            throw new IllegalStateException("Execution ID should be set");
        }
    }

    public <T> T withNewExecutionId(QueryExecution queryExecution, Option<String> name, Function0<T> body) {
        return queryExecution.sparkSession().withActive((Function0 & Serializable & scala.Serializable)() -> {
            Object t;
            SparkSession sparkSession = queryExecution.sparkSession();
            SparkContext sc = sparkSession.sparkContext();
            String oldExecutionId = sc.getLocalProperty(MODULE$.EXECUTION_ID_KEY());
            long executionId = MODULE$.nextExecutionId();
            sc.setLocalProperty(MODULE$.EXECUTION_ID_KEY(), Long.toString(executionId));
            if (sc.getLocalProperty(MODULE$.EXECUTION_ROOT_ID_KEY()) == null) {
                sc.setLocalProperty(MODULE$.EXECUTION_ROOT_ID_KEY(), Long.toString(executionId));
            }
            long rootExecutionId = new StringOps(Predef$.MODULE$.augmentString(sc.getLocalProperty(MODULE$.EXECUTION_ROOT_ID_KEY()))).toLong();
            MODULE$.executionIdToQueryExecution().put(BoxesRunTime.boxToLong((long)executionId), queryExecution);
            try {
                CallSite callSite = sc.getCallSite();
                int truncateLength = BoxesRunTime.unboxToInt((Object)sc.conf().get(StaticSQLConf$.MODULE$.SQL_EVENT_TRUNCATE_LENGTH()));
                String desc = (String)Option$.MODULE$.apply((Object)sc.getLocalProperty(SparkContext$.MODULE$.SPARK_JOB_DESCRIPTION())).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)SQLExecution$.$anonfun$withNewExecutionId$2(truncateLength, x$1))).map((Function1 & Serializable & scala.Serializable)sqlStr -> {
                    String redactedStr = Utils$.MODULE$.redact(sparkSession.sessionState().conf().stringRedactionPattern(), sqlStr);
                    return redactedStr.substring(0, Math.min(truncateLength, redactedStr.length()));
                }).getOrElse((Function0 & Serializable & scala.Serializable)() -> callSite.shortForm());
                ExplainMode planDescriptionMode = ExplainMode$.MODULE$.fromString(sparkSession.sessionState().conf().uiExplainMode());
                Map globalConfigs = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])sparkSession.sharedState().conf().getAll())).toMap(Predef$.MODULE$.$conforms());
                Map modifiedConfigs = (Map)sparkSession.sessionState().conf().getAllConfs().filterNot((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)SQLExecution$.$anonfun$withNewExecutionId$5(globalConfigs, x0$1)));
                Map redactedConfigs = sparkSession.sessionState().conf().redactOptions(modifiedConfigs);
                t = MODULE$.withSQLConfPropagated(sparkSession, (Function0 & Serializable & scala.Serializable)() -> {
                    Object object;
                    None$ ex = None$.MODULE$;
                    long startTime = System.nanoTime();
                    try {
                        try {
                            sc.listenerBus().post((SparkListenerEvent)new SparkListenerSQLExecutionStart(executionId, (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)rootExecutionId)), desc, callSite.longForm(), queryExecution.explainString(planDescriptionMode), SparkPlanInfo$.MODULE$.fromSparkPlan(queryExecution.executedPlan()), System.currentTimeMillis(), (Map<String, String>)redactedConfigs, (Set<String>)sc.getJobTags()));
                            object = body.apply();
                        }
                        catch (Throwable e) {
                            ex = new Some((Object)e);
                            throw e;
                        }
                    }
                    finally {
                        long endTime = System.nanoTime();
                        Option errorMessage = ex.map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                            Throwable throwable = x0$2;
                            if (throwable instanceof SparkThrowable) {
                                Throwable throwable2 = throwable;
                                return SparkThrowableHelper$.MODULE$.getMessage(throwable2, ErrorMessageFormat$.MODULE$.PRETTY());
                            }
                            return Utils$.MODULE$.exceptionString(throwable);
                        });
                        SparkListenerSQLExecutionEnd event = new SparkListenerSQLExecutionEnd(executionId, System.currentTimeMillis(), (Option<String>)errorMessage.orElse((Function0 & Serializable & scala.Serializable)() -> new Some((Object)"")));
                        event.executionName_$eq(name);
                        event.duration_$eq(endTime - startTime);
                        event.qe_$eq(queryExecution);
                        event.executionFailure_$eq((Option<Throwable>)ex);
                        sc.listenerBus().post((SparkListenerEvent)event);
                    }
                    return object;
                });
            }
            finally {
                MODULE$.executionIdToQueryExecution().remove(BoxesRunTime.boxToLong((long)executionId));
                sc.setLocalProperty(MODULE$.EXECUTION_ID_KEY(), oldExecutionId);
                String string = sc.getLocalProperty(MODULE$.EXECUTION_ROOT_ID_KEY());
                String string2 = Long.toString(executionId);
                if (!(string != null ? !string.equals(string2) : string2 != null)) {
                    sc.setLocalProperty(MODULE$.EXECUTION_ROOT_ID_KEY(), null);
                }
            }
            return t;
        });
    }

    public <T> Option<String> withNewExecutionId$default$2() {
        return None$.MODULE$;
    }

    public <T> T withExecutionId(SparkSession sparkSession, String executionId, Function0<T> body) {
        SparkContext sc = sparkSession.sparkContext();
        String oldExecutionId = sc.getLocalProperty(this.EXECUTION_ID_KEY());
        return this.withSQLConfPropagated(sparkSession, (Function0 & Serializable & scala.Serializable)() -> {
            Object object;
            try {
                sc.setLocalProperty(MODULE$.EXECUTION_ID_KEY(), executionId);
                object = body.apply();
            }
            finally {
                sc.setLocalProperty(MODULE$.EXECUTION_ID_KEY(), oldExecutionId);
            }
            return object;
        });
    }

    public <T> T withSQLConfPropagated(SparkSession sparkSession, Function0<T> body) {
        Object object;
        SparkContext sc = sparkSession.sparkContext();
        Map allConfigs = sparkSession.sessionState().conf().getAllConfs();
        Map originalLocalProps = (Map)allConfigs.collect((PartialFunction)new scala.Serializable(sc){
            public static final long serialVersionUID = 0L;
            private final SparkContext sc$3;

            public final <A1 extends Tuple2<String, String>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 != null) {
                    String key = (String)A1._1();
                    String value = (String)A1._2();
                    if (key.startsWith("spark")) {
                        String originalValue = this.sc$3.getLocalProperty(key);
                        this.sc$3.setLocalProperty(key, value);
                        return (B1)new Tuple2((Object)key, (Object)originalValue);
                    }
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Tuple2<String, String> x1) {
                String key;
                Tuple2<String, String> tuple2 = x1;
                return tuple2 != null && (key = (String)tuple2._1()).startsWith("spark");
            }
            {
                this.sc$3 = sc$3;
            }
        }, Map$.MODULE$.canBuildFrom());
        try {
            object = body.apply();
        }
        finally {
            originalLocalProps.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)SQLExecution$.$anonfun$withSQLConfPropagated$1(check$ifrefutable$1))).foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
                SQLExecution$.$anonfun$withSQLConfPropagated$2(sc, x$2);
                return BoxedUnit.UNIT;
            });
        }
        return (T)object;
    }

    public <T> Future<T> withThreadLocalCaptured(SparkSession sparkSession, ExecutorService exec, Function0<T> body) {
        SparkSession activeSession = sparkSession;
        SparkContext sc = sparkSession.sparkContext();
        Properties localProps = Utils$.MODULE$.cloneProperties(sc.getLocalProperties());
        JobArtifactState artifactState = (JobArtifactState)JobArtifactSet$.MODULE$.getCurrentJobArtifactState().orNull(Predef$.MODULE$.$conforms());
        return exec.submit(() -> JobArtifactSet$.MODULE$.withActiveJobArtifactState(artifactState, (Function0 & Serializable & scala.Serializable)() -> {
            Option<SparkSession> originalSession = SparkSession$.MODULE$.getActiveSession();
            Properties originalLocalProps = sc.getLocalProperties();
            SparkSession$.MODULE$.setActiveSession(activeSession);
            sc.setLocalProperties(localProps);
            Object res = body.apply();
            sc.setLocalProperties(originalLocalProps);
            if (originalSession.nonEmpty()) {
                SparkSession$.MODULE$.setActiveSession((SparkSession)originalSession.get());
            } else {
                SparkSession$.MODULE$.clearActiveSession();
            }
            return res;
        }));
    }

    public static final /* synthetic */ boolean $anonfun$withNewExecutionId$2(int truncateLength$1, String x$1) {
        return truncateLength$1 > 0;
    }

    public static final /* synthetic */ boolean $anonfun$withNewExecutionId$5(Map globalConfigs$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String key = (String)tuple2._1();
            String value = (String)tuple2._2();
            return key.startsWith(package$.MODULE$.SPARK_DRIVER_PREFIX()) || key.startsWith(package$.MODULE$.SPARK_EXECUTOR_PREFIX()) || globalConfigs$1.get((Object)key).contains((Object)value);
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$withSQLConfPropagated$1(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        return tuple2 != null;
    }

    public static final /* synthetic */ void $anonfun$withSQLConfPropagated$2(SparkContext sc$3, Tuple2 x$2) {
        Tuple2 tuple2 = x$2;
        if (tuple2 != null) {
            String key = (String)tuple2._1();
            String value = (String)tuple2._2();
            sc$3.setLocalProperty(key, value);
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    private SQLExecution$() {
        MODULE$ = this;
        this.EXECUTION_ID_KEY = "spark.sql.execution.id";
        this.EXECUTION_ROOT_ID_KEY = "spark.sql.execution.root.id";
        this._nextExecutionId = new AtomicLong(0L);
        this.executionIdToQueryExecution = new ConcurrentHashMap();
        this.testing = scala.sys.package$.MODULE$.props().contains(Tests$.MODULE$.IS_TESTING().key());
    }
}

