/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.orc;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.io.sarg.SearchArgument;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.TaskID;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.apache.hadoop.mapreduce.task.TaskAttemptContextImpl;
import org.apache.orc.OrcConf;
import org.apache.orc.OrcFile;
import org.apache.orc.TypeDescription;
import org.apache.orc.mapred.OrcOutputFormat;
import org.apache.orc.mapred.OrcStruct;
import org.apache.orc.mapreduce.OrcInputFormat;
import org.apache.spark.TaskContext$;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.JoinedRow;
import org.apache.spark.sql.catalyst.expressions.UnsafeProjection;
import org.apache.spark.sql.catalyst.expressions.codegen.GenerateUnsafeProjection$;
import org.apache.spark.sql.catalyst.types.DataTypeUtils$;
import org.apache.spark.sql.execution.datasources.FileFormat;
import org.apache.spark.sql.execution.datasources.FileFormat$;
import org.apache.spark.sql.execution.datasources.OutputWriter;
import org.apache.spark.sql.execution.datasources.OutputWriterFactory;
import org.apache.spark.sql.execution.datasources.PartitionedFile;
import org.apache.spark.sql.execution.datasources.RecordReaderIterator;
import org.apache.spark.sql.execution.datasources.orc.OrcColumnarBatchReader;
import org.apache.spark.sql.execution.datasources.orc.OrcDeserializer;
import org.apache.spark.sql.execution.datasources.orc.OrcFilters$;
import org.apache.spark.sql.execution.datasources.orc.OrcOptions;
import org.apache.spark.sql.execution.datasources.orc.OrcOutputWriter;
import org.apache.spark.sql.execution.datasources.orc.OrcUtils$;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.sources.DataSourceRegister;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.UserDefinedType;
import org.apache.spark.sql.vectorized.ColumnarBatch;
import org.apache.spark.util.SerializableConfiguration;
import org.apache.spark.util.Utils$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005]e\u0001\u0002\u0007\u000e\u0001qAQ!\u000e\u0001\u0005\u0002YBQ!\u000f\u0001\u0005BiBQA\u0012\u0001\u0005BiBQa\u0012\u0001\u0005B!CQ\u0001\u0014\u0001\u0005B5CQA\u0016\u0001\u0005B]Caa \u0001\u0005B\u0005\u0005\u0001bBA\u0011\u0001\u0011\u0005\u00131\u0005\u0005\b\u0003W\u0001A\u0011IA\u0017\u0011\u001d\ti\u0004\u0001C!\u0003\u007fAq!!#\u0001\t\u0003\nYIA\u0007Pe\u000e4\u0015\u000e\\3G_Jl\u0017\r\u001e\u0006\u0003\u001d=\t1a\u001c:d\u0015\t\u0001\u0012#A\u0006eCR\f7o\\;sG\u0016\u001c(B\u0001\n\u0014\u0003%)\u00070Z2vi&|gN\u0003\u0002\u0015+\u0005\u00191/\u001d7\u000b\u0005Y9\u0012!B:qCJ\\'B\u0001\r\u001a\u0003\u0019\t\u0007/Y2iK*\t!$A\u0002pe\u001e\u001c\u0001aE\u0003\u0001;\r:S\u0006\u0005\u0002\u001fC5\tqDC\u0001!\u0003\u0015\u00198-\u00197b\u0013\t\u0011sD\u0001\u0004B]f\u0014VM\u001a\t\u0003I\u0015j\u0011aD\u0005\u0003M=\u0011!BR5mK\u001a{'/\\1u!\tA3&D\u0001*\u0015\tQ3#A\u0004t_V\u00148-Z:\n\u00051J#A\u0005#bi\u0006\u001cv.\u001e:dKJ+w-[:uKJ\u0004\"AL\u001a\u000e\u0003=R!\u0001M\u0019\u0002\u0005%|'\"\u0001\u001a\u0002\t)\fg/Y\u0005\u0003i=\u0012AbU3sS\u0006d\u0017N_1cY\u0016\fa\u0001P5oSRtD#A\u001c\u0011\u0005a\u0002Q\"A\u0007\u0002\u0013MDwN\u001d;OC6,G#A\u001e\u0011\u0005q\u001aeBA\u001fB!\tqt$D\u0001@\u0015\t\u00015$\u0001\u0004=e>|GOP\u0005\u0003\u0005~\ta\u0001\u0015:fI\u00164\u0017B\u0001#F\u0005\u0019\u0019FO]5oO*\u0011!iH\u0001\ti>\u001cFO]5oO\u0006A\u0001.Y:i\u0007>$W\rF\u0001J!\tq\"*\u0003\u0002L?\t\u0019\u0011J\u001c;\u0002\r\u0015\fX/\u00197t)\tq\u0015\u000b\u0005\u0002\u001f\u001f&\u0011\u0001k\b\u0002\b\u0005>|G.Z1o\u0011\u0015\u0011V\u00011\u0001T\u0003\u0015yG\u000f[3s!\tqB+\u0003\u0002V?\t\u0019\u0011I\\=\u0002\u0017%tg-\u001a:TG\",W.\u0019\u000b\u00051\u0006<G\u000eE\u0002\u001f3nK!AW\u0010\u0003\r=\u0003H/[8o!\tav,D\u0001^\u0015\tq6#A\u0003usB,7/\u0003\u0002a;\nQ1\u000b\u001e:vGR$\u0016\u0010]3\t\u000b\t4\u0001\u0019A2\u0002\u0019M\u0004\u0018M]6TKN\u001c\u0018n\u001c8\u0011\u0005\u0011,W\"A\n\n\u0005\u0019\u001c\"\u0001D*qCJ\\7+Z:tS>t\u0007\"\u00025\u0007\u0001\u0004I\u0017aB8qi&|gn\u001d\t\u0005y)\\4(\u0003\u0002l\u000b\n\u0019Q*\u00199\t\u000b54\u0001\u0019\u00018\u0002\u000b\u0019LG.Z:\u0011\u0007=$xO\u0004\u0002qe:\u0011a(]\u0005\u0002A%\u00111oH\u0001\ba\u0006\u001c7.Y4f\u0013\t)hOA\u0002TKFT!a]\u0010\u0011\u0005alX\"A=\u000b\u0005i\\\u0018A\u00014t\u0015\tax#\u0001\u0004iC\u0012|w\u000e]\u0005\u0003}f\u0014!BR5mKN#\u0018\r^;t\u00031\u0001(/\u001a9be\u0016<&/\u001b;f))\t\u0019!!\u0003\u0002\f\u0005m\u0011Q\u0004\t\u0004I\u0005\u0015\u0011bAA\u0004\u001f\t\u0019r*\u001e;qkR<&/\u001b;fe\u001a\u000b7\r^8ss\")!m\u0002a\u0001G\"9\u0011QB\u0004A\u0002\u0005=\u0011a\u00016pEB!\u0011\u0011CA\f\u001b\t\t\u0019BC\u0002\u0002\u0016m\f\u0011\"\\1qe\u0016$WoY3\n\t\u0005e\u00111\u0003\u0002\u0004\u0015>\u0014\u0007\"\u00025\b\u0001\u0004I\u0007BBA\u0010\u000f\u0001\u00071,\u0001\u0006eCR\f7k\u00195f[\u0006\fAb];qa>\u0014HOQ1uG\"$RATA\u0013\u0003OAQA\u0019\u0005A\u0002\rDa!!\u000b\t\u0001\u0004Y\u0016AB:dQ\u0016l\u0017-A\u0006jgN\u0003H.\u001b;bE2,Gc\u0002(\u00020\u0005E\u00121\u0007\u0005\u0006E&\u0001\ra\u0019\u0005\u0006Q&\u0001\r!\u001b\u0005\b\u0003kI\u0001\u0019AA\u001c\u0003\u0011\u0001\u0018\r\u001e5\u0011\u0007a\fI$C\u0002\u0002<e\u0014A\u0001U1uQ\u0006q\"-^5mIJ+\u0017\rZ3s/&$\b\u000eU1si&$\u0018n\u001c8WC2,Xm\u001d\u000b\u0011\u0003\u0003\ny&!\u0019\u0002d\u0005\u001d\u00141NA<\u0003s\u0002rAHA\"\u0003\u000f\ni%C\u0002\u0002F}\u0011\u0011BR;oGRLwN\\\u0019\u0011\u0007\u0011\nI%C\u0002\u0002L=\u0011q\u0002U1si&$\u0018n\u001c8fI\u001aKG.\u001a\t\u0006_\u0006=\u00131K\u0005\u0004\u0003#2(\u0001C%uKJ\fGo\u001c:\u0011\t\u0005U\u00131L\u0007\u0003\u0003/R1!!\u0017\u0014\u0003!\u0019\u0017\r^1msN$\u0018\u0002BA/\u0003/\u00121\"\u00138uKJt\u0017\r\u001c*po\")!M\u0003a\u0001G\"1\u0011q\u0004\u0006A\u0002mCa!!\u001a\u000b\u0001\u0004Y\u0016a\u00049beRLG/[8o'\u000eDW-\\1\t\r\u0005%$\u00021\u0001\\\u00039\u0011X-];je\u0016$7k\u00195f[\u0006Dq!!\u001c\u000b\u0001\u0004\ty'A\u0004gS2$XM]:\u0011\t=$\u0018\u0011\u000f\t\u0004Q\u0005M\u0014bAA;S\t1a)\u001b7uKJDQ\u0001\u001b\u0006A\u0002%Dq!a\u001f\u000b\u0001\u0004\ti(\u0001\u0006iC\u0012|w\u000e]\"p]\u001a\u0004B!a \u0002\u00066\u0011\u0011\u0011\u0011\u0006\u0004\u0003\u0007[\u0018\u0001B2p]\u001aLA!a\"\u0002\u0002\ni1i\u001c8gS\u001e,(/\u0019;j_:\fqb];qa>\u0014H\u000fR1uCRK\b/\u001a\u000b\u0004\u001d\u00065\u0005bBAH\u0017\u0001\u0007\u0011\u0011S\u0001\tI\u0006$\u0018\rV=qKB\u0019A,a%\n\u0007\u0005UUL\u0001\u0005ECR\fG+\u001f9f\u0001")
public class OrcFileFormat
implements FileFormat,
DataSourceRegister,
Serializable {
    @Override
    public Option<Seq<String>> vectorTypes(StructType requiredSchema, StructType partitionSchema, SQLConf sqlConf) {
        return FileFormat.vectorTypes$(this, requiredSchema, partitionSchema, sqlConf);
    }

    @Override
    public Function1<PartitionedFile, Iterator<InternalRow>> buildReader(SparkSession sparkSession, StructType dataSchema, StructType partitionSchema, StructType requiredSchema, Seq<Filter> filters, Map<String, String> options, Configuration hadoopConf) {
        return FileFormat.buildReader$(this, sparkSession, dataSchema, partitionSchema, requiredSchema, filters, options, hadoopConf);
    }

    @Override
    public AttributeReference createFileMetadataCol() {
        return FileFormat.createFileMetadataCol$(this);
    }

    @Override
    public boolean supportFieldName(String name) {
        return FileFormat.supportFieldName$(this, name);
    }

    @Override
    public Seq<StructField> metadataSchemaFields() {
        return FileFormat.metadataSchemaFields$(this);
    }

    @Override
    public Map<String, Function1<PartitionedFile, Object>> fileConstantMetadataExtractors() {
        return FileFormat.fileConstantMetadataExtractors$(this);
    }

    @Override
    public String shortName() {
        return "orc";
    }

    public String toString() {
        return "ORC";
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    public boolean equals(Object other) {
        return other instanceof OrcFileFormat;
    }

    @Override
    public Option<StructType> inferSchema(SparkSession sparkSession, Map<String, String> options, Seq<FileStatus> files) {
        return OrcUtils$.MODULE$.inferSchema(sparkSession, files, options);
    }

    @Override
    public OutputWriterFactory prepareWrite(SparkSession sparkSession, Job job, Map<String, String> options, StructType dataSchema) {
        OrcOptions orcOptions = new OrcOptions(options, sparkSession.sessionState().conf());
        Configuration conf = job.getConfiguration();
        conf.set(OrcConf.COMPRESS.getAttribute(), orcOptions.compressionCodec());
        ((JobConf)conf).setOutputFormat(OrcOutputFormat.class);
        int batchSize = sparkSession.sessionState().conf().orcVectorizedWriterBatchSize();
        return new OutputWriterFactory(null, batchSize){
            private final int batchSize$1;

            public OutputWriter newInstance(String path, StructType dataSchema, TaskAttemptContext context) {
                return new OrcOutputWriter(path, dataSchema, context, this.batchSize$1);
            }

            public String getFileExtension(TaskAttemptContext context) {
                String name = context.getConfiguration().get(OrcConf.COMPRESS.getAttribute());
                String compressionExtension = (String)OrcUtils$.MODULE$.extensionsForCompressionCodecNames().getOrElse((Object)name, (Function0 & Serializable & scala.Serializable)() -> "");
                return new StringBuilder(4).append(compressionExtension).append(".orc").toString();
            }
            {
                this.batchSize$1 = batchSize$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$getFileExtension$1()}, serializedLambda);
            }
        };
    }

    @Override
    public boolean supportBatch(SparkSession sparkSession, StructType schema) {
        SQLConf conf = sparkSession.sessionState().conf();
        return conf.orcVectorizedReaderEnabled() && schema.forall((Function1 & Serializable & scala.Serializable)s -> BoxesRunTime.boxToBoolean((boolean)OrcUtils$.MODULE$.supportColumnarReads(s.dataType(), sparkSession.sessionState().conf().orcVectorizedReaderNestedColumnEnabled())));
    }

    @Override
    public boolean isSplitable(SparkSession sparkSession, Map<String, String> options, Path path) {
        return true;
    }

    @Override
    public Function1<PartitionedFile, Iterator<InternalRow>> buildReaderWithPartitionValues(SparkSession sparkSession, StructType dataSchema, StructType partitionSchema, StructType requiredSchema, Seq<Filter> filters, Map<String, String> options, Configuration hadoopConf) {
        boolean enableVectorizedReader;
        StructType resultSchema = new StructType((StructField[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])requiredSchema.fields())).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])partitionSchema.fields())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(StructField.class))));
        SQLConf sqlConf = sparkSession.sessionState().conf();
        int capacity = sqlConf.orcVectorizedReaderBatchSize();
        boolean bl = enableVectorizedReader = sqlConf.orcVectorizedReaderEnabled() && ((String)options.getOrElse((Object)FileFormat$.MODULE$.OPTION_RETURNING_BATCH(), (Function0 & Serializable & scala.Serializable)() -> {
            throw new IllegalArgumentException("OPTION_RETURNING_BATCH should always be set for OrcFileFormat. To workaround this issue, set spark.sql.orc.enableVectorizedReader=false.");
        })).equals("true");
        if (enableVectorizedReader) {
            Predef$.MODULE$.assert(this.supportBatch(sparkSession, resultSchema));
        }
        OrcConf.IS_SCHEMA_EVOLUTION_CASE_SENSITIVE.setBoolean(hadoopConf, sqlConf.caseSensitiveAnalysis());
        Broadcast broadcastedConf = sparkSession.sparkContext().broadcast((Object)new SerializableConfiguration(hadoopConf), ClassTag$.MODULE$.apply(SerializableConfiguration.class));
        boolean isCaseSensitive = sparkSession.sessionState().conf().caseSensitiveAnalysis();
        boolean orcFilterPushDown = sparkSession.sessionState().conf().orcFilterPushDown();
        return (Function1 & Serializable & scala.Serializable)file -> {
            Tuple2 tuple2;
            Configuration conf = ((SerializableConfiguration)broadcastedConf.value()).value();
            Path filePath = file.toPath();
            FileSystem fs = filePath.getFileSystem(conf);
            OrcFile.ReaderOptions readerOptions = OrcFile.readerOptions(conf).filesystem(fs);
            TypeDescription orcSchema = (TypeDescription)Utils$.MODULE$.tryWithResource((Function0 & Serializable & scala.Serializable)() -> OrcFile.createReader(filePath, readerOptions), (Function1 & Serializable & scala.Serializable)x$1 -> x$1.getSchema());
            Option<Tuple2<int[], Object>> resultedColPruneInfo = OrcUtils$.MODULE$.requestedColumnIds(isCaseSensitive, dataSchema, requiredSchema, orcSchema, conf);
            if (resultedColPruneInfo.isEmpty()) {
                return package$.MODULE$.Iterator().empty();
            }
            if (orcFilterPushDown && filters.nonEmpty()) {
                StructType fileSchema = OrcUtils$.MODULE$.toCatalystSchema(orcSchema);
                OrcFilters$.MODULE$.createFilter(fileSchema, filters).foreach((Function1 & Serializable & scala.Serializable)f -> {
                    OrcFileFormat.$anonfun$buildReaderWithPartitionValues$5(conf, fileSchema, f);
                    return BoxedUnit.UNIT;
                });
            }
            if ((tuple2 = (Tuple2)resultedColPruneInfo.get()) == null) {
                throw new MatchError((Object)tuple2);
            }
            int[] requestedColIds = (int[])tuple2._1();
            boolean canPruneCols = tuple2._2$mcZ$sp();
            Tuple2 tuple22 = new Tuple2((Object)requestedColIds, (Object)BoxesRunTime.boxToBoolean((boolean)canPruneCols));
            int[] requestedColIds2 = (int[])tuple22._1();
            boolean canPruneCols2 = tuple22._2$mcZ$sp();
            String resultSchemaString = OrcUtils$.MODULE$.orcResultSchemaString(canPruneCols2, dataSchema, resultSchema, partitionSchema, conf);
            Predef$.MODULE$.assert(requestedColIds2.length == requiredSchema.length(), (Function0 & Serializable & scala.Serializable)() -> "[BUG] requested column IDs do not match required schema");
            Configuration taskConf = new Configuration(conf);
            String includeColumns = new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps((int[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps((int[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(requestedColIds2)).filter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$3 -> x$3 != -1))).sorted((Ordering)Ordering.Int$.MODULE$))).mkString(",");
            taskConf.set(OrcConf.INCLUDE_COLUMNS.getAttribute(), includeColumns);
            FileSplit fileSplit = new FileSplit(filePath, file.start(), file.length(), (String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class)));
            TaskAttemptID attemptId = new TaskAttemptID(new TaskID(new JobID(), TaskType.MAP, 0), 0);
            TaskAttemptContextImpl taskAttemptContext = new TaskAttemptContextImpl(taskConf, attemptId);
            if (enableVectorizedReader) {
                OrcColumnarBatchReader batchReader = new OrcColumnarBatchReader(capacity);
                RecordReaderIterator<ColumnarBatch> iter = new RecordReaderIterator<ColumnarBatch>(batchReader);
                Option$.MODULE$.apply((Object)TaskContext$.MODULE$.get()).foreach((Function1 & Serializable & scala.Serializable)x$4 -> x$4.addTaskCompletionListener((Function1 & Serializable & scala.Serializable)x$5 -> {
                    iter.close();
                    return BoxedUnit.UNIT;
                }));
                int[] requestedDataColIds = (int[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(requestedColIds2)).$plus$plus((GenTraversableOnce)new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps((int[])Array$.MODULE$.fill(partitionSchema.length(), (Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> -1, ClassTag$.MODULE$.Int()))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()));
                int[] requestedPartitionColIds = (int[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps((int[])Array$.MODULE$.fill(requiredSchema.length(), (Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> -1, ClassTag$.MODULE$.Int()))).$plus$plus((GenTraversableOnce)package$.MODULE$.Range().apply(0, partitionSchema.length()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()));
                batchReader.initialize((InputSplit)fileSplit, (TaskAttemptContext)taskAttemptContext);
                batchReader.initBatch(TypeDescription.fromString(resultSchemaString), resultSchema.fields(), requestedDataColIds, requestedPartitionColIds, file.partitionValues());
                return iter;
            }
            RecordReader orcRecordReader = new OrcInputFormat().createRecordReader((InputSplit)fileSplit, (TaskAttemptContext)taskAttemptContext);
            RecordReaderIterator iter = new RecordReaderIterator(orcRecordReader);
            Option$.MODULE$.apply((Object)TaskContext$.MODULE$.get()).foreach((Function1 & Serializable & scala.Serializable)x$6 -> x$6.addTaskCompletionListener((Function1 & Serializable & scala.Serializable)x$7 -> {
                iter.close();
                return BoxedUnit.UNIT;
            }));
            Seq fullSchema = (Seq)DataTypeUtils$.MODULE$.toAttributes(requiredSchema).$plus$plus((GenTraversableOnce)DataTypeUtils$.MODULE$.toAttributes(partitionSchema), Seq$.MODULE$.canBuildFrom());
            UnsafeProjection unsafeProjection = (UnsafeProjection)GenerateUnsafeProjection$.MODULE$.generate((Object)fullSchema, fullSchema);
            OrcDeserializer deserializer = new OrcDeserializer(requiredSchema, requestedColIds2);
            if (partitionSchema.length() == 0) {
                return iter.map((Function1 & Serializable & scala.Serializable)value -> unsafeProjection.apply(deserializer.deserialize((OrcStruct)value)));
            }
            JoinedRow joinedRow = new JoinedRow();
            return iter.map((Function1 & Serializable & scala.Serializable)value -> unsafeProjection.apply((InternalRow)joinedRow.apply(deserializer.deserialize((OrcStruct)value), file.partitionValues())));
        };
    }

    @Override
    public boolean supportDataType(DataType dataType) {
        DataType dataType2 = dataType;
        if (dataType2 instanceof AtomicType) {
            return true;
        }
        if (dataType2 instanceof StructType) {
            StructType structType = (StructType)dataType2;
            return structType.forall((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)this.supportDataType(f.dataType())));
        }
        if (dataType2 instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)dataType2;
            DataType elementType = arrayType.elementType();
            return this.supportDataType(elementType);
        }
        if (dataType2 instanceof MapType) {
            MapType mapType = (MapType)dataType2;
            DataType keyType = mapType.keyType();
            DataType valueType = mapType.valueType();
            return this.supportDataType(keyType) && this.supportDataType(valueType);
        }
        if (dataType2 instanceof UserDefinedType) {
            UserDefinedType userDefinedType = (UserDefinedType)dataType2;
            return this.supportDataType(userDefinedType.sqlType());
        }
        return false;
    }

    public static final /* synthetic */ void $anonfun$buildReaderWithPartitionValues$5(Configuration conf$1, StructType fileSchema$1, SearchArgument f) {
        OrcInputFormat.setSearchArgument(conf$1, f, fileSchema$1.fieldNames());
    }

    public OrcFileFormat() {
        FileFormat.$init$(this);
    }
}

