/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming.state;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkEnv$;
import org.apache.spark.internal.Logging;
import org.apache.spark.io.CompressionCodec;
import org.apache.spark.io.CompressionCodec$;
import org.apache.spark.sql.execution.streaming.CheckpointFileManager;
import org.apache.spark.sql.execution.streaming.CheckpointFileManager$;
import org.apache.spark.sql.execution.streaming.state.RocksDBCheckpointMetadata;
import org.apache.spark.sql.execution.streaming.state.RocksDBCheckpointMetadata$;
import org.apache.spark.sql.execution.streaming.state.RocksDBFileManager$;
import org.apache.spark.sql.execution.streaming.state.RocksDBFileManagerMetrics;
import org.apache.spark.sql.execution.streaming.state.RocksDBFileManagerMetrics$;
import org.apache.spark.sql.execution.streaming.state.RocksDBImmutableFile;
import org.apache.spark.sql.execution.streaming.state.RocksDBImmutableFile$;
import org.apache.spark.sql.execution.streaming.state.StateStoreChangelogReader;
import org.apache.spark.sql.execution.streaming.state.StateStoreChangelogWriter;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.HashMap;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LazyRef;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.runtime.java8.JFunction2;

@ScalaSignature(bytes="\u0006\u0001\t\u001dg\u0001B\u001b7\u0001\u0015C\u0001B\u0015\u0001\u0003\u0002\u0003\u0006Ia\u0015\u0005\t=\u0002\u0011\t\u0011)A\u0005?\"Aq\r\u0001B\u0001B\u0003%\u0001\u000e\u0003\u0005q\u0001\t\u0005\t\u0015!\u0003T\u0011!\t\bA!A!\u0002\u0013\u0019\u0006\"\u0002:\u0001\t\u0003\u0019\bbB>\u0001\u0005\u0004%I\u0001 \u0005\b\u0003S\u0001\u0001\u0015!\u0003~\u0011)\tY\u0003\u0001EC\u0002\u0013%\u0011Q\u0006\u0005\n\u0003o\u0001!\u0019!C\u0005\u0003sA\u0001\"!\u0012\u0001A\u0003%\u00111\b\u0005\n\u0003\u000f\u0002!\u0019!C\u0005\u0003\u0013B\u0001\"!\u0015\u0001A\u0003%\u00111\n\u0005\n\u0003K\u0002!\u0019!C\u0005\u0003OB\u0001\"!\u001c\u0001A\u0003%\u0011\u0011\u000e\u0005\u000b\u0003_\u0002\u0001R1A\u0005\n\u0005E\u0004bBA>\u0001\u0011%\u0011Q\u0010\u0005\b\u0003\u0013\u0003A\u0011AAF\u0011\u001d\t9\n\u0001C\u0001\u00033C\u0011\"a)\u0001\u0001\u0004%I!!*\t\u0013\u00055\u0006\u00011A\u0005\n\u0005=\u0006\u0002CA^\u0001\u0001\u0006K!a*\t\u0013\u0005\u0015\u0007\u00011A\u0005\n\u0005\u0015\u0006\"CAd\u0001\u0001\u0007I\u0011BAe\u0011!\ti\r\u0001Q!\n\u0005\u001d\u0006bBAi\u0001\u0011\u0005\u0011Q\u0015\u0005\b\u0003'\u0004A\u0011AAS\u0011\u001d\t)\u000e\u0001C\u0001\u0003/Dq!a9\u0001\t\u0003\t)\u000fC\u0004\u0002t\u0002!\t!!>\t\u000f\u0005e\b\u0001\"\u0001\u0002|\"9\u0011Q \u0001\u0005\u0002\u0005}\bb\u0002B\n\u0001\u0011%!Q\u0003\u0005\b\u0005C\u0001A\u0011\u0001B\u0012\u0011\u001d\u0011y\u0003\u0001C\u0005\u0005cAqAa\u000f\u0001\t\u0013\u0011i\u0004C\u0004\u0003F\u0001!IAa\u0012\t\u000f\t-\u0003\u0001\"\u0003\u0003N!9!Q\f\u0001\u0005\n\t}\u0003b\u0002B5\u0001\u0011%!1\u000e\u0005\b\u0005c\u0002A\u0011\u0002B:\u0011\u001d\u00119\b\u0001C\u0005\u0005sBqA! \u0001\t\u0013\u0011y\bC\u0004\u0003\u0006\u0002!\tFa\"\t\u000f\t%\u0005\u0001\"\u0003\u0003\f\"9!\u0011\u0013\u0001\u0005\n\tM\u0005b\u0002BM\u0001\u0011%!1T\u0004\n\u0005K3\u0014\u0011!E\u0001\u0005O3\u0001\"\u000e\u001c\u0002\u0002#\u0005!\u0011\u0016\u0005\u0007eF\"\tAa+\t\u0013\t5\u0016'%A\u0005\u0002\t=\u0006\"\u0003BccE\u0005I\u0011\u0001BX\u0005I\u0011vnY6t\t\n3\u0015\u000e\\3NC:\fw-\u001a:\u000b\u0005]B\u0014!B:uCR,'BA\u001d;\u0003%\u0019HO]3b[&twM\u0003\u0002<y\u0005IQ\r_3dkRLwN\u001c\u0006\u0003{y\n1a]9m\u0015\ty\u0004)A\u0003ta\u0006\u00148N\u0003\u0002B\u0005\u00061\u0011\r]1dQ\u0016T\u0011aQ\u0001\u0004_J<7\u0001A\n\u0004\u0001\u0019c\u0005CA$K\u001b\u0005A%\"A%\u0002\u000bM\u001c\u0017\r\\1\n\u0005-C%AB!osJ+g\r\u0005\u0002N!6\taJ\u0003\u0002P}\u0005A\u0011N\u001c;fe:\fG.\u0003\u0002R\u001d\n9Aj\\4hS:<\u0017A\u00033ggJ{w\u000e\u001e#jeB\u0011Ak\u0017\b\u0003+f\u0003\"A\u0016%\u000e\u0003]S!\u0001\u0017#\u0002\rq\u0012xn\u001c;?\u0013\tQ\u0006*\u0001\u0004Qe\u0016$WMZ\u0005\u00039v\u0013aa\u0015;sS:<'B\u0001.I\u00031awnY1m)\u0016l\u0007\u000fR5s!\t\u0001W-D\u0001b\u0015\t\u00117-\u0001\u0002j_*\tA-\u0001\u0003kCZ\f\u0017B\u00014b\u0005\u00111\u0015\u000e\\3\u0002\u0015!\fGm\\8q\u0007>tg\r\u0005\u0002j]6\t!N\u0003\u0002lY\u0006!1m\u001c8g\u0015\ti\u0007)\u0001\u0004iC\u0012|w\u000e]\u0005\u0003_*\u0014QbQ8oM&<WO]1uS>t\u0017!C2pI\u0016\u001cg*Y7f\u0003%awnZ4j]\u001eLE-\u0001\u0004=S:LGO\u0010\u000b\u0007iZ<\b0\u001f>\u0011\u0005U\u0004Q\"\u0001\u001c\t\u000bI3\u0001\u0019A*\t\u000by3\u0001\u0019A0\t\u000b\u001d4\u0001\u0019\u00015\t\u000fA4\u0001\u0013!a\u0001'\"9\u0011O\u0002I\u0001\u0002\u0004\u0019\u0016!\u0006<feNLwN\u001c+p%>\u001c7n\u001d#C\r&dWm]\u000b\u0002{B9a0a\u0002\u0002\f\u0005EQ\"A@\u000b\t\u0005\u0005\u00111A\u0001\u000bG>t7-\u001e:sK:$(bAA\u0003G\u0006!Q\u000f^5m\u0013\r\tIa \u0002\u0012\u0007>t7-\u001e:sK:$\b*Y:i\u001b\u0006\u0004\bcA$\u0002\u000e%\u0019\u0011q\u0002%\u0003\t1{gn\u001a\t\u0007\u0003'\ti\"a\t\u000f\t\u0005U\u0011\u0011\u0004\b\u0004-\u0006]\u0011\"A%\n\u0007\u0005m\u0001*A\u0004qC\u000e\\\u0017mZ3\n\t\u0005}\u0011\u0011\u0005\u0002\u0004'\u0016\f(bAA\u000e\u0011B\u0019Q/!\n\n\u0007\u0005\u001dbG\u0001\u000bS_\u000e\\7\u000f\u0012\"J[6,H/\u00192mK\u001aKG.Z\u0001\u0017m\u0016\u00148/[8o)>\u0014vnY6t\t\n3\u0015\u000e\\3tA\u0005\u0011a-\\\u000b\u0003\u0003_\u0001B!!\r\u000245\t\u0001(C\u0002\u00026a\u0012Qc\u00115fG.\u0004x.\u001b8u\r&dW-T1oC\u001e,'/\u0001\u0002ggV\u0011\u00111\b\t\u0005\u0003{\t\t%\u0004\u0002\u0002@)\u0019\u0011q\u00077\n\t\u0005\r\u0013q\b\u0002\u000b\r&dWmU=ti\u0016l\u0017a\u00014tA\u0005aqN\u001c7z5&\u0004h)\u001b7fgV\u0011\u00111\n\n\u0007\u0003\u001b\n\u0019&a\u0018\u0007\r\u0005=S\u0002AA&\u00051a$/\u001a4j]\u0016lWM\u001c;?\u00035yg\u000e\\=[SB4\u0015\u000e\\3tAA!\u0011QKA.\u001b\t\t9FC\u0002\u0002Z\r\fA\u0001\\1oO&!\u0011QLA,\u0005\u0019y%M[3diB!\u0011QHA1\u0013\u0011\t\u0019'a\u0010\u0003\u0015A\u000bG\u000f\u001b$jYR,'/\u0001\np]2L8\t[1oO\u0016dwn\u001a$jY\u0016\u001cXCAA5%\u0019\tY'a\u0015\u0002`\u00191\u0011qJ\b\u0001\u0003S\n1c\u001c8ms\u000eC\u0017M\\4fY><g)\u001b7fg\u0002\n\u0011b\u001d9be.\u001cuN\u001c4\u0016\u0005\u0005M\u0004\u0003BA;\u0003oj\u0011AP\u0005\u0004\u0003sr$!C*qCJ\\7i\u001c8g\u0003\u0015\u0019w\u000eZ3d+\t\ty\b\u0005\u0003\u0002\u0002\u0006\u0015UBAAB\u0015\t\u0011g(\u0003\u0003\u0002\b\u0006\r%\u0001E\"p[B\u0014Xm]:j_:\u001cu\u000eZ3d\u0003I9W\r^\"iC:<W\rT8h/JLG/\u001a:\u0015\t\u00055\u00151\u0013\t\u0004k\u0006=\u0015bAAIm\tI2\u000b^1uKN#xN]3DQ\u0006tw-\u001a7pO^\u0013\u0018\u000e^3s\u0011\u001d\t)J\u0005a\u0001\u0003\u0017\tqA^3sg&|g.\u0001\nhKR\u001c\u0005.\u00198hK2|wMU3bI\u0016\u0014H\u0003BAN\u0003C\u00032!^AO\u0013\r\tyJ\u000e\u0002\u001a'R\fG/Z*u_J,7\t[1oO\u0016dwn\u001a*fC\u0012,'\u000fC\u0004\u0002\u0016N\u0001\r!a\u0003\u0002+1|\u0017\rZ\"iK\u000e\\\u0007o\\5oi6+GO]5dgV\u0011\u0011q\u0015\t\u0004k\u0006%\u0016bAAVm\tI\"k\\2lg\u0012\u0013e)\u001b7f\u001b\u0006t\u0017mZ3s\u001b\u0016$(/[2t\u0003eaw.\u00193DQ\u0016\u001c7\u000e]8j]RlU\r\u001e:jGN|F%Z9\u0015\t\u0005E\u0016q\u0017\t\u0004\u000f\u0006M\u0016bAA[\u0011\n!QK\\5u\u0011%\tI,FA\u0001\u0002\u0004\t9+A\u0002yIE\na\u0003\\8bI\u000eCWmY6q_&tG/T3ue&\u001c7\u000f\t\u0015\u0004-\u0005}\u0006cA$\u0002B&\u0019\u00111\u0019%\u0003\u0011Y|G.\u0019;jY\u0016\fQc]1wK\u000eCWmY6q_&tG/T3ue&\u001c7/A\rtCZ,7\t[3dWB|\u0017N\u001c;NKR\u0014\u0018nY:`I\u0015\fH\u0003BAY\u0003\u0017D\u0011\"!/\u0019\u0003\u0003\u0005\r!a*\u0002-M\fg/Z\"iK\u000e\\\u0007o\\5oi6+GO]5dg\u0002B3!GA`\u0003ma\u0017\r^3ti2{\u0017\rZ\"iK\u000e\\\u0007o\\5oi6+GO]5dg\u0006YB.\u0019;fgR\u001c\u0016M^3DQ\u0016\u001c7\u000e]8j]RlU\r\u001e:jGN\f1c]1wK\u000eCWmY6q_&tG\u000fV8EMN$\u0002\"!-\u0002Z\u0006u\u0017q\u001c\u0005\u0007\u00037d\u0002\u0019A0\u0002\u001b\rDWmY6q_&tG\u000fR5s\u0011\u001d\t)\n\ba\u0001\u0003\u0017Aq!!9\u001d\u0001\u0004\tY!A\u0004ok6\\U-_:\u0002+1|\u0017\rZ\"iK\u000e\\\u0007o\\5oi\u001a\u0013x.\u001c#ggR1\u0011q]Aw\u0003_\u00042!^Au\u0013\r\tYO\u000e\u0002\u001a%>\u001c7n\u001d#C\u0007\",7m\u001b9pS:$X*\u001a;bI\u0006$\u0018\rC\u0004\u0002\u0016v\u0001\r!a\u0003\t\r\u0005EX\u00041\u0001`\u0003!awnY1m\t&\u0014\u0018\u0001G4fi2\u000bG/Z:u':\f\u0007o\u001d5piZ+'o]5p]R!\u00111BA|\u0011\u001d\t)J\ba\u0001\u0003\u0017\t\u0001cZ3u\u0019\u0006$Xm\u001d;WKJ\u001c\u0018n\u001c8\u0015\u0005\u0005-\u0011a\u00044j]\u0012|%\u000f\u001d5b]\u001aKG.Z:\u0015\r\t\u0005!1\u0001B\u0004!\u0015\t\u0019\"!\bT\u0011\u001d\u0011)\u0001\ta\u0001\u0005\u0003\tA\u0002\u001e:bG.,GMR5mKNDqA!\u0003!\u0001\u0004\u0011Y!\u0001\u0005bY24\u0015\u000e\\3t!\u0019\t\u0019\"!\b\u0003\u000eA!\u0011Q\bB\b\u0013\u0011\u0011\t\"a\u0010\u0003\u0015\u0019KG.Z*uCR,8/\u0001\u000beK2,G/Z\"iC:<W\r\\8h\r&dWm\u001d\u000b\u0005\u0003c\u00139\u0002C\u0004\u0003\u001a\u0005\u0002\rAa\u0007\u0002!Y,'o]5p]N$v\u000eR3mKR,\u0007#B$\u0003\u001e\u0005-\u0011b\u0001B\u0010\u0011\n)\u0011I\u001d:bs\u0006\tB-\u001a7fi\u0016|E\u000e\u001a,feNLwN\\:\u0015\t\u0005E&Q\u0005\u0005\b\u0005O\u0011\u0003\u0019\u0001B\u0015\u0003MqW/\u001c,feNLwN\\:U_J+G/Y5o!\r9%1F\u0005\u0004\u0005[A%aA%oi\u000692/\u0019<f\u00136lW\u000f^1cY\u00164\u0015\u000e\\3t)>$em\u001d\u000b\u0007\u0003#\u0011\u0019D!\u000e\t\u000f\u0005U5\u00051\u0001\u0002\f!9!qG\u0012A\u0002\te\u0012A\u00037pG\u0006dg)\u001b7fgB)\u00111CA\u000f?\u0006IBn\\1e\u00136lW\u000f^1cY\u00164\u0015\u000e\\3t\rJ|W\u000e\u00124t)\u0019\t\tLa\u0010\u0003D!9!\u0011\t\u0013A\u0002\u0005E\u0011AD5n[V$\u0018M\u00197f\r&dWm\u001d\u0005\u0007\u0003c$\u0003\u0019A0\u0002?\u001d,G/S7nkR\f'\r\\3GS2,7O\u0012:p[Z+'o]5p]jK\u0007\u000f\u0006\u0003\u0002\u0012\t%\u0003bBAKK\u0001\u0007\u00111B\u0001\ru&\u0004Hk\u001c#gg\u001aKG.\u001a\u000b\u0007\u0003c\u0013yEa\u0015\t\u000f\tEc\u00051\u0001\u0003:\u0005)a-\u001b7fg\"9!Q\u000b\u0014A\u0002\t]\u0013A\u00033ggjK\u0007OR5mKB!\u0011Q\bB-\u0013\u0011\u0011Y&a\u0010\u0003\tA\u000bG\u000f[\u0001\u000eY><g)\u001b7fg&sG)\u001b:\u0015\r\u0005E&\u0011\rB3\u0011\u0019\u0011\u0019g\na\u0001?\u0006\u0019A-\u001b:\t\r\t\u001dt\u00051\u0001T\u0003\ri7oZ\u0001\u000f]\u0016<HIR*GS2,g*Y7f)\r\u0019&Q\u000e\u0005\u0007\u0005_B\u0003\u0019A*\u0002\u001b1|7-\u00197GS2,g*Y7f\u0003=!gm\u001d\"bi\u000eD',\u001b9GS2,G\u0003\u0002B,\u0005kBq!!&*\u0001\u0004\tY!\u0001\teMN\u001c\u0005.\u00198hK2|wMR5mKR!!q\u000bB>\u0011\u001d\t)J\u000ba\u0001\u0003\u0017\t\u0011\u0003\\8dC2lU\r^1eCR\fg)\u001b7f)\ry&\u0011\u0011\u0005\u0007\u0005\u0007[\u0003\u0019A0\u0002\u0013A\f'/\u001a8u\t&\u0014\u0018a\u00027pO:\u000bW.Z\u000b\u0002'\u0006YAMZ:GS2,\u0007+\u0019;i)\u0011\u00119F!$\t\r\t=U\u00061\u0001T\u0003!1\u0017\u000e\\3OC6,\u0017!\u00047pG\u0006dg)\u001b7f!\u0006$\b\u000eF\u0003`\u0005+\u00139\n\u0003\u0004\u0002r:\u0002\ra\u0018\u0005\u0007\u0005\u001fs\u0003\u0019A*\u0002!1L7\u000f\u001e*pG.\u001cHI\u0011$jY\u0016\u001cH\u0003\u0002BO\u0005G\u0003ra\u0012BP\u0005s\u0011I$C\u0002\u0003\"\"\u0013a\u0001V;qY\u0016\u0014\u0004BBAy_\u0001\u0007q,\u0001\nS_\u000e\\7\u000f\u0012\"GS2,W*\u00198bO\u0016\u0014\bCA;2'\t\td\t\u0006\u0002\u0003(\u0006YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIQ*\"A!-+\u0007M\u0013\u0019l\u000b\u0002\u00036B!!q\u0017Ba\u001b\t\u0011IL\u0003\u0003\u0003<\nu\u0016!C;oG\",7m[3e\u0015\r\u0011y\fS\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002\u0002Bb\u0005s\u0013\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%k\u0001")
public class RocksDBFileManager
implements Logging {
    private CheckpointFileManager fm;
    private SparkConf sparkConf;
    private final String dfsRootDir;
    private final File localTempDir;
    private Configuration hadoopConf;
    private final String codecName;
    private final String loggingId;
    private final ConcurrentHashMap<Object, Seq<RocksDBImmutableFile>> versionToRocksDBFiles;
    private final FileSystem fs;
    private final PathFilter onlyZipFiles;
    private final PathFilter onlyChangelogFiles;
    private volatile RocksDBFileManagerMetrics loadCheckpointMetrics;
    private volatile RocksDBFileManagerMetrics saveCheckpointMetrics;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private volatile byte bitmap$0;

    public static String $lessinit$greater$default$5() {
        return RocksDBFileManager$.MODULE$.$lessinit$greater$default$5();
    }

    public static String $lessinit$greater$default$4() {
        return RocksDBFileManager$.MODULE$.$lessinit$greater$default$4();
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private ConcurrentHashMap<Object, Seq<RocksDBImmutableFile>> versionToRocksDBFiles() {
        return this.versionToRocksDBFiles;
    }

    private CheckpointFileManager fm$lzycompute() {
        RocksDBFileManager rocksDBFileManager = this;
        synchronized (rocksDBFileManager) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.fm = CheckpointFileManager$.MODULE$.create(new Path(this.dfsRootDir), this.hadoopConf);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        this.hadoopConf = null;
        return this.fm;
    }

    private CheckpointFileManager fm() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.fm$lzycompute();
        }
        return this.fm;
    }

    private FileSystem fs() {
        return this.fs;
    }

    private PathFilter onlyZipFiles() {
        return this.onlyZipFiles;
    }

    private PathFilter onlyChangelogFiles() {
        return this.onlyChangelogFiles;
    }

    private SparkConf sparkConf$lzycompute() {
        RocksDBFileManager rocksDBFileManager = this;
        synchronized (rocksDBFileManager) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.sparkConf = (SparkConf)Option$.MODULE$.apply((Object)SparkEnv$.MODULE$.get()).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.conf()).getOrElse((Function0 & Serializable & scala.Serializable)() -> new SparkConf());
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.sparkConf;
    }

    private SparkConf sparkConf() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.sparkConf$lzycompute();
        }
        return this.sparkConf;
    }

    private CompressionCodec codec() {
        return CompressionCodec$.MODULE$.createCodec(this.sparkConf(), this.codecName);
    }

    public StateStoreChangelogWriter getChangeLogWriter(long version) {
        Path rootDir = new Path(this.dfsRootDir);
        Path changelogFile = this.dfsChangelogFile(version);
        if (!this.fm().exists(rootDir)) {
            this.fm().mkdirs(rootDir);
        }
        StateStoreChangelogWriter changelogWriter = new StateStoreChangelogWriter(this.fm(), changelogFile, this.codec());
        return changelogWriter;
    }

    public StateStoreChangelogReader getChangelogReader(long version) {
        Path changelogFile = this.dfsChangelogFile(version);
        return new StateStoreChangelogReader(this.fm(), changelogFile, this.codec());
    }

    private RocksDBFileManagerMetrics loadCheckpointMetrics() {
        return this.loadCheckpointMetrics;
    }

    private void loadCheckpointMetrics_$eq(RocksDBFileManagerMetrics x$1) {
        this.loadCheckpointMetrics = x$1;
    }

    private RocksDBFileManagerMetrics saveCheckpointMetrics() {
        return this.saveCheckpointMetrics;
    }

    private void saveCheckpointMetrics_$eq(RocksDBFileManagerMetrics x$1) {
        this.saveCheckpointMetrics = x$1;
    }

    public RocksDBFileManagerMetrics latestLoadCheckpointMetrics() {
        return this.loadCheckpointMetrics();
    }

    public RocksDBFileManagerMetrics latestSaveCheckpointMetrics() {
        return this.saveCheckpointMetrics();
    }

    public void saveCheckpointToDfs(File checkpointDir, long version, long numKeys) {
        this.logFilesInDir(checkpointDir, new StringBuilder(36).append("Saving checkpoint files for version ").append(version).toString());
        Tuple2<Seq<File>, Seq<File>> tuple2 = this.listRocksDBFiles(checkpointDir);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Seq localImmutableFiles = (Seq)tuple2._1();
        Seq localOtherFiles = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)localImmutableFiles, (Object)localOtherFiles);
        Seq localImmutableFiles2 = (Seq)tuple22._1();
        Seq localOtherFiles2 = (Seq)tuple22._2();
        Seq<RocksDBImmutableFile> rocksDBFiles = this.saveImmutableFilesToDfs(version, (Seq<File>)localImmutableFiles2);
        RocksDBCheckpointMetadata metadata = RocksDBCheckpointMetadata$.MODULE$.apply(rocksDBFiles, numKeys);
        File metadataFile = this.localMetadataFile(checkpointDir);
        metadata.writeToFile(metadataFile);
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(31).append("Written metadata for version ").append(version).append(":\n").append(metadata.prettyJson()).toString());
        if (version <= 1L && numKeys <= 0L) {
            Path path = new Path(this.dfsRootDir);
            if (!this.fm().exists(path)) {
                this.fm().mkdirs(path);
            }
        }
        this.zipToDfsFile((Seq<File>)((Seq)localOtherFiles2.$colon$plus((Object)metadataFile, Seq$.MODULE$.canBuildFrom())), this.dfsBatchZipFile(version));
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(34).append("Saved checkpoint file for version ").append(version).toString());
    }

    public RocksDBCheckpointMetadata loadCheckpointFromDfs(long version, File localDir) {
        RocksDBCheckpointMetadata rocksDBCheckpointMetadata;
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(37).append("Loading checkpoint files for version ").append(version).toString());
        if (version == 0L) {
            if (localDir.exists()) {
                Utils$.MODULE$.deleteRecursively(localDir);
            }
            localDir.mkdirs();
            rocksDBCheckpointMetadata = RocksDBCheckpointMetadata$.MODULE$.apply((Seq<RocksDBImmutableFile>)((Seq)Nil$.MODULE$), 0L);
        } else {
            ((IterableLike)this.listRocksDBFiles(localDir)._2()).foreach((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.delete()));
            Utils$.MODULE$.unzipFilesFromFile(this.fs(), this.dfsBatchZipFile(version), localDir);
            File metadataFile = this.localMetadataFile(localDir);
            RocksDBCheckpointMetadata metadata = RocksDBCheckpointMetadata$.MODULE$.readFromFile(metadataFile);
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(28).append("Read metadata for version ").append(version).append(":\n").append(metadata.prettyJson()).toString());
            this.loadImmutableFilesFromDfs(metadata.immutableFiles(), localDir);
            this.versionToRocksDBFiles().put(BoxesRunTime.boxToLong((long)version), metadata.immutableFiles());
            metadataFile.delete();
            rocksDBCheckpointMetadata = metadata;
        }
        RocksDBCheckpointMetadata metadata = rocksDBCheckpointMetadata;
        this.logFilesInDir(localDir, new StringBuilder(36).append("Loaded checkpoint files for version ").append(version).toString());
        return metadata;
    }

    public long getLatestSnapshotVersion(long version) {
        Path path = new Path(this.dfsRootDir);
        if (this.fm().exists(path)) {
            if (this.fm().exists(this.dfsBatchZipFile(version))) {
                return version;
            }
            return BoxesRunTime.unboxToLong((Object)new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps((long[])new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps((long[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.fm().list(path, this.onlyZipFiles()))).map((Function1 & Serializable & scala.Serializable)x$4 -> new StringOps(Predef$.MODULE$.augmentString(x$4.getPath().getName())).stripSuffix(".zip"), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).map((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToLong((long)RocksDBFileManager.$anonfun$getLatestSnapshotVersion$2(x$5)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Long())))).filter((Function1)(JFunction1.mcZJ.sp & Serializable & scala.Serializable)x$6 -> x$6 <= version))).foldLeft((Object)BoxesRunTime.boxToLong((long)0L), (Function2)(JFunction2.mcJJJ.sp & Serializable & scala.Serializable)(x, y) -> package$.MODULE$.max(x, y)));
        }
        return 0L;
    }

    public long getLatestVersion() {
        Path path = new Path(this.dfsRootDir);
        if (this.fm().exists(path)) {
            Path[] files = (Path[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.fm().list(path))).map((Function1 & Serializable & scala.Serializable)x$7 -> x$7.getPath(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Path.class)));
            long[] changelogFileVersions = (long[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])files)).filter((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)RocksDBFileManager.$anonfun$getLatestVersion$2(this, x$8))))).map((Function1 & Serializable & scala.Serializable)x$9 -> new StringOps(Predef$.MODULE$.augmentString(x$9.getName())).stripSuffix(".changelog"), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).map((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToLong((long)RocksDBFileManager.$anonfun$getLatestVersion$4(x$10)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Long()));
            long[] snapshotFileVersions = (long[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])files)).filter((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)RocksDBFileManager.$anonfun$getLatestVersion$5(this, x$11))))).map((Function1 & Serializable & scala.Serializable)x$12 -> new StringOps(Predef$.MODULE$.augmentString(x$12.getName())).stripSuffix(".zip"), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).map((Function1 & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToLong((long)RocksDBFileManager.$anonfun$getLatestVersion$7(x$13)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Long()));
            long[] versions = (long[])new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(changelogFileVersions)).$plus$plus((GenTraversableOnce)new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(snapshotFileVersions)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Long()));
            return BoxesRunTime.unboxToLong((Object)new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(versions)).foldLeft((Object)BoxesRunTime.boxToLong((long)0L), (Function2)(JFunction2.mcJJJ.sp & Serializable & scala.Serializable)(x, y) -> package$.MODULE$.max(x, y)));
        }
        return 0L;
    }

    public Seq<String> findOrphanFiles(Seq<String> trackedFiles, Seq<FileStatus> allFiles) {
        Map fileModificationTimes = ((TraversableOnce)allFiles.map((Function1 & Serializable & scala.Serializable)file -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)file.getPath().getName()), (Object)BoxesRunTime.boxToLong((long)file.getModificationTime())), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        if (trackedFiles.nonEmpty() && allFiles.size() > trackedFiles.size()) {
            long oldestTrackedFileModificationTime = BoxesRunTime.unboxToLong((Object)((TraversableOnce)trackedFiles.flatMap((Function1 & Serializable & scala.Serializable)x$14 -> Option$.MODULE$.option2Iterable(fileModificationTimes.get(x$14)), Seq$.MODULE$.canBuildFrom())).min((Ordering)Ordering.Long$.MODULE$));
            Seq orphanFiles = ((MapLike)fileModificationTimes.filter((Function1 & Serializable & scala.Serializable)x$15 -> BoxesRunTime.boxToBoolean((boolean)RocksDBFileManager.$anonfun$findOrphanFiles$3(oldestTrackedFileModificationTime, x$15)))).keys().toSeq();
            if (orphanFiles.nonEmpty()) {
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(79).append("Found ").append(orphanFiles.size()).append(" orphan files: ").append(((TraversableOnce)orphanFiles.take(20)).mkString(", ")).append("... (display at most 20 filenames) that should be deleted.").toString());
            }
            return orphanFiles;
        }
        return (Seq)Nil$.MODULE$;
    }

    private void deleteChangelogFiles(long[] versionsToDelete) {
        new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(versionsToDelete)).foreach((Function1)(JFunction1.mcVJ.sp & Serializable & scala.Serializable)version -> {
            try {
                this.fm().delete(this.dfsChangelogFile(version));
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(23).append("Deleted changelog file ").append(version).toString());
            }
            catch (Exception e) {
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(42).append("Error deleting changelog file for version ").append(version).toString(), e);
            }
        });
    }

    public void deleteOldVersions(int numVersionsToRetain) {
        Path path = new Path(this.dfsRootDir);
        Path[] allFiles = (Path[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.fm().list(path))).map((Function1 & Serializable & scala.Serializable)x$16 -> x$16.getPath(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Path.class)));
        Path[] snapshotFiles = (Path[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])allFiles)).filter((Function1 & Serializable & scala.Serializable)file -> BoxesRunTime.boxToBoolean((boolean)RocksDBFileManager.$anonfun$deleteOldVersions$2(this, file)));
        Path[] changelogFiles = (Path[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])allFiles)).filter((Function1 & Serializable & scala.Serializable)file -> BoxesRunTime.boxToBoolean((boolean)RocksDBFileManager.$anonfun$deleteOldVersions$3(this, file)));
        long[] sortedSnapshotVersions = (long[])new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps((long[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])snapshotFiles)).map((Function1 & Serializable & scala.Serializable)x$17 -> new StringOps(Predef$.MODULE$.augmentString(x$17.getName())).stripSuffix(".zip"), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).map((Function1 & Serializable & scala.Serializable)x$18 -> BoxesRunTime.boxToLong((long)RocksDBFileManager.$anonfun$deleteOldVersions$5(x$18)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Long())))).sorted((Ordering)Ordering.Long$.MODULE$);
        if (new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(sortedSnapshotVersions)).isEmpty()) {
            return;
        }
        long maxSnapshotVersionPresent = BoxesRunTime.unboxToLong((Object)new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(sortedSnapshotVersions)).last());
        long minVersionToRetain = BoxesRunTime.unboxToLong((Object)new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps((long[])new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(sortedSnapshotVersions)).filter((Function1)(JFunction1.mcZJ.sp & Serializable & scala.Serializable)x$19 -> x$19 <= maxSnapshotVersionPresent - (long)numVersionsToRetain + 1L))).foldLeft((Object)BoxesRunTime.boxToLong((long)0L), (Function2)(JFunction2.mcJJJ.sp & Serializable & scala.Serializable)(x, y) -> package$.MODULE$.max(x, y)));
        long[] snapshotVersionsToDelete = (long[])new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(sortedSnapshotVersions)).filter((Function1)(JFunction1.mcZJ.sp & Serializable & scala.Serializable)x$20 -> x$20 < minVersionToRetain);
        if (new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(snapshotVersionsToDelete)).isEmpty()) {
            return;
        }
        HashMap fileToMaxUsedVersion = new HashMap();
        new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(sortedSnapshotVersions)).foreach((Function1)(JFunction1.mcVJ.sp & Serializable & scala.Serializable)version -> {
            Seq files = (Seq)Option$.MODULE$.apply(this.versionToRocksDBFiles().get(BoxesRunTime.boxToLong((long)version))).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                Seq<RocksDBImmutableFile> newResolvedFiles = this.getImmutableFilesFromVersionZip(version);
                this.versionToRocksDBFiles().put(BoxesRunTime.boxToLong((long)version), newResolvedFiles);
                return newResolvedFiles;
            });
            files.foreach((Function1 & Serializable & scala.Serializable)f -> {
                fileToMaxUsedVersion.update((Object)f.dfsFileName(), (Object)BoxesRunTime.boxToLong((long)package$.MODULE$.max(version, BoxesRunTime.unboxToLong((Object)fileToMaxUsedVersion.getOrElse((Object)f.dfsFileName(), (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> version$5)))));
                return BoxedUnit.UNIT;
            });
        });
        HashMap filesToDelete = (HashMap)fileToMaxUsedVersion.filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)RocksDBFileManager.$anonfun$deleteOldVersions$13(snapshotVersionsToDelete, x0$1)));
        Path sstDir = new Path(this.dfsRootDir, RocksDBImmutableFile$.MODULE$.SST_FILES_DFS_SUBDIR());
        Path logDir = new Path(this.dfsRootDir, RocksDBImmutableFile$.MODULE$.LOG_FILES_DFS_SUBDIR());
        Seq allSstFiles = this.fm().exists(sstDir) ? new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.fm().list(sstDir))).toSeq() : (Seq)Nil$.MODULE$;
        Seq allLogFiles = this.fm().exists(logDir) ? new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.fm().list(logDir))).toSeq() : (Seq)Nil$.MODULE$;
        filesToDelete.$plus$plus$eq((TraversableOnce)this.findOrphanFiles((Seq<String>)fileToMaxUsedVersion.keys().toSeq(), (Seq<FileStatus>)((Seq)allSstFiles.$plus$plus((GenTraversableOnce)allLogFiles, Seq$.MODULE$.canBuildFrom()))).map((Function1 & Serializable & scala.Serializable)x$21 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(x$21), (Object)BoxesRunTime.boxToLong((long)-1L)), Seq$.MODULE$.canBuildFrom()));
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(40).append("Deleting ").append(filesToDelete.size()).append(" files not used in versions >= ").append(minVersionToRetain).toString());
        IntRef failedToDelete = IntRef.create((int)0);
        filesToDelete.foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
            RocksDBFileManager.$anonfun$deleteOldVersions$16(this, failedToDelete, x0$2);
            return BoxedUnit.UNIT;
        });
        new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(snapshotVersionsToDelete)).foreach((Function1)(JFunction1.mcVJ.sp & Serializable & scala.Serializable)version -> {
            Path versionFile = this.dfsBatchZipFile(version);
            try {
                this.fm().delete(versionFile);
                this.versionToRocksDBFiles().remove(BoxesRunTime.boxToLong((long)version));
                this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(16).append("Deleted version ").append(version).toString());
            }
            catch (Exception e) {
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(41).append("Error deleting version file ").append(versionFile).append(" for version ").append(version).toString(), e);
            }
        });
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(64).append("Deleted ").append(filesToDelete.size() - failedToDelete$1.elem).append(" files (failed to delete").append(failedToDelete$1.elem).append(" files) not used in versions >= ").append(minVersionToRetain).toString());
        long[] changelogVersionsToDelete = (long[])new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps((long[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])changelogFiles)).map((Function1 & Serializable & scala.Serializable)x$22 -> new StringOps(Predef$.MODULE$.augmentString(x$22.getName())).stripSuffix(".changelog"), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).map((Function1 & Serializable & scala.Serializable)x$23 -> BoxesRunTime.boxToLong((long)RocksDBFileManager.$anonfun$deleteOldVersions$26(x$23)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Long())))).filter((Function1)(JFunction1.mcZJ.sp & Serializable & scala.Serializable)x$24 -> x$24 < minVersionToRetain);
        this.deleteChangelogFiles(changelogVersionsToDelete);
    }

    private Seq<RocksDBImmutableFile> saveImmutableFilesToDfs(long version, Seq<File> localFiles) {
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(32).append("Saving RocksDB files to DFS for ").append(version).toString());
        Map prevFilesToSizes = ((TraversableOnce)((TraversableLike)((MapLike)JavaConverters$.MODULE$.mapAsScalaConcurrentMapConverter(this.versionToRocksDBFiles()).asScala()).filterKeys((Function1)(JFunction1.mcZJ.sp & Serializable & scala.Serializable)x$25 -> x$25 < version).values().flatten((Function1)Predef$.MODULE$.$conforms())).map((Function1 & Serializable & scala.Serializable)f -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)f.localFileName()), f), Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        LongRef bytesCopied = LongRef.create((long)0L);
        LongRef filesCopied = LongRef.create((long)0L);
        LongRef filesReused = LongRef.create((long)0L);
        Seq immutableFiles = (Seq)localFiles.map((Function1 & Serializable & scala.Serializable)localFile -> (RocksDBImmutableFile)prevFilesToSizes.get((Object)localFile.getName()).filter((Function1 & Serializable & scala.Serializable)x$26 -> BoxesRunTime.boxToBoolean((boolean)x$26.isSameFile(localFile))).map((Function1 & Serializable & scala.Serializable)reusable -> {
            ++filesReused$1.elem;
            return reusable;
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            String localFileName = localFile.getName();
            String dfsFileName = this.newDFSFileName(localFileName);
            Path dfsFile = this.dfsFilePath(dfsFileName);
            this.fs().copyFromLocalFile(new Path(localFile.getAbsoluteFile().toURI()), dfsFile);
            long localFileSize = localFile.length();
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(20).append("Copied ").append(localFile).append(" to ").append(dfsFile).append(" - ").append(localFileSize).append(" bytes").toString());
            ++filesCopied$1.elem;
            bytesCopied$1.elem += localFileSize;
            return RocksDBImmutableFile$.MODULE$.apply(localFile.getName(), dfsFileName, localFileSize);
        }), Seq$.MODULE$.canBuildFrom());
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(85).append("Copied ").append(filesCopied$1.elem).append(" files (").append(bytesCopied$1.elem).append(" bytes) from local to").append(" DFS for version ").append(version).append(". ").append(filesReused$1.elem).append(" files reused without copying.").toString());
        this.versionToRocksDBFiles().put(BoxesRunTime.boxToLong((long)version), (Seq<RocksDBImmutableFile>)immutableFiles);
        long x$1 = bytesCopied.elem;
        long x$2 = filesCopied.elem;
        long x$3 = filesReused.elem;
        Option<Object> x$4 = RocksDBFileManagerMetrics$.MODULE$.apply$default$4();
        this.saveCheckpointMetrics_$eq(new RocksDBFileManagerMetrics(x$2, x$1, x$3, x$4));
        return immutableFiles;
    }

    private void loadImmutableFilesFromDfs(Seq<RocksDBImmutableFile> immutableFiles, File localDir) {
        Map requiredFileNameToFileDetails = ((TraversableOnce)immutableFiles.map((Function1 & Serializable & scala.Serializable)f -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)f.localFileName()), f), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        ((IterableLike)this.listRocksDBFiles(localDir)._1()).foreach((Function1 & Serializable & scala.Serializable)existingFile -> {
            RocksDBFileManager.$anonfun$loadImmutableFilesFromDfs$2(this, requiredFileNameToFileDetails, existingFile);
            return BoxedUnit.UNIT;
        });
        LongRef filesCopied = LongRef.create((long)0L);
        LongRef bytesCopied = LongRef.create((long)0L);
        LongRef filesReused = LongRef.create((long)0L);
        immutableFiles.foreach((Function1 & Serializable & scala.Serializable)file -> {
            RocksDBFileManager.$anonfun$loadImmutableFilesFromDfs$5(this, localDir, filesCopied, bytesCopied, filesReused, file);
            return BoxedUnit.UNIT;
        });
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(60).append("Copied ").append(filesCopied$2.elem).append(" files (").append(bytesCopied$2.elem).append(" bytes) from DFS to local with ").append(filesReused$2.elem).append(" files reused.").toString());
        long x$1 = bytesCopied.elem;
        long x$2 = filesCopied.elem;
        long x$3 = filesReused.elem;
        Option<Object> x$4 = RocksDBFileManagerMetrics$.MODULE$.apply$default$4();
        this.loadCheckpointMetrics_$eq(new RocksDBFileManagerMetrics(x$2, x$1, x$3, x$4));
    }

    private Seq<RocksDBImmutableFile> getImmutableFilesFromVersionZip(long version) {
        Utils$.MODULE$.deleteRecursively(this.localTempDir);
        this.localTempDir.mkdirs();
        Utils$.MODULE$.unzipFilesFromFile(this.fs(), this.dfsBatchZipFile(version), this.localTempDir);
        File metadataFile = this.localMetadataFile(this.localTempDir);
        RocksDBCheckpointMetadata metadata = RocksDBCheckpointMetadata$.MODULE$.readFromFile(metadataFile);
        return metadata.immutableFiles();
    }

    private void zipToDfsFile(Seq<File> files, Path dfsZipFile) {
        LazyRef filesStr$lzy = new LazyRef();
        ObjectRef in = ObjectRef.create(null);
        CheckpointFileManager.CancellableFSDataOutputStream out = this.fm().createAtomic(dfsZipFile, true);
        LongRef totalBytes = LongRef.create((long)0L);
        ZipOutputStream zout = new ZipOutputStream((OutputStream)((Object)out));
        try {
            try {
                files.foreach((Function1 & Serializable & scala.Serializable)file -> {
                    RocksDBFileManager.$anonfun$zipToDfsFile$1(zout, in, totalBytes, file);
                    return BoxedUnit.UNIT;
                });
                zout.close();
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(38).append("Zipped ").append(totalBytes$1.elem).append(" bytes (before compression) to ").append(RocksDBFileManager.filesStr$1(filesStr$lzy, dfsZipFile, files)).toString());
                RocksDBFileManagerMetrics qual$1 = this.saveCheckpointMetrics();
                Some x$1 = new Some((Object)BoxesRunTime.boxToLong((long)totalBytes.elem));
                long x$2 = qual$1.copy$default$1();
                long x$3 = qual$1.copy$default$2();
                long x$4 = qual$1.copy$default$3();
                this.saveCheckpointMetrics_$eq(qual$1.copy(x$2, x$3, x$4, (Option<Object>)x$1));
            }
            catch (Exception e) {
                out.cancel();
                this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(17).append("Error zipping to ").append(RocksDBFileManager.filesStr$1(filesStr$lzy, dfsZipFile, files)).toString(), e);
                throw e;
            }
        }
        finally {
            IOUtils.closeQuietly((InputStream)((InputStream)in.elem));
            IOUtils.closeQuietly((OutputStream)zout);
        }
    }

    private void logFilesInDir(File dir, String msg) {
        LazyRef files$lzy = new LazyRef();
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(11).append(msg).append(" - ").append(RocksDBFileManager.files$2(files$lzy, dir).length).append(" files\n\t").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])RocksDBFileManager.files$2(files$lzy, dir))).mkString("\n\t")).toString());
    }

    private String newDFSFileName(String localFileName) {
        String baseName = FilenameUtils.getBaseName((String)localFileName);
        String extension = FilenameUtils.getExtension((String)localFileName);
        return new StringBuilder(2).append(baseName).append("-").append(UUID.randomUUID()).append(".").append(extension).toString();
    }

    private Path dfsBatchZipFile(long version) {
        return new Path(new StringBuilder(5).append(this.dfsRootDir).append("/").append(version).append(".zip").toString());
    }

    private Path dfsChangelogFile(long version) {
        return new Path(new StringBuilder(11).append(this.dfsRootDir).append("/").append(version).append(".changelog").toString());
    }

    private File localMetadataFile(File parentDir) {
        return new File(parentDir, "metadata");
    }

    public String logName() {
        return new StringBuilder(1).append(Logging.logName$((Logging)this)).append(" ").append(this.loggingId).toString();
    }

    private Path dfsFilePath(String fileName) {
        if (RocksDBImmutableFile$.MODULE$.isSstFile(fileName)) {
            return new Path(new Path(this.dfsRootDir, RocksDBImmutableFile$.MODULE$.SST_FILES_DFS_SUBDIR()), fileName);
        }
        if (RocksDBImmutableFile$.MODULE$.isLogFile(fileName)) {
            return new Path(new Path(this.dfsRootDir, RocksDBImmutableFile$.MODULE$.LOG_FILES_DFS_SUBDIR()), fileName);
        }
        return new Path(this.dfsRootDir, fileName);
    }

    private File localFilePath(File localDir, String fileName) {
        if (RocksDBImmutableFile$.MODULE$.isLogFile(fileName)) {
            return new File(new File(localDir, RocksDBImmutableFile$.MODULE$.LOG_FILES_LOCAL_SUBDIR()), fileName);
        }
        return new File(localDir, fileName);
    }

    private Tuple2<Seq<File>, Seq<File>> listRocksDBFiles(File localDir) {
        File[] topLevelFiles = (File[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])localDir.listFiles())).filter((Function1 & Serializable & scala.Serializable)x$28 -> BoxesRunTime.boxToBoolean((boolean)RocksDBFileManager.$anonfun$listRocksDBFiles$1(x$28)));
        File[] archivedLogFiles = (File[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])Option$.MODULE$.apply((Object)new File(localDir, RocksDBImmutableFile$.MODULE$.LOG_FILES_LOCAL_SUBDIR()).listFiles()).getOrElse((Function0 & Serializable & scala.Serializable)() -> (File[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(File.class))))).filter((Function1 & Serializable & scala.Serializable)file -> BoxesRunTime.boxToBoolean((boolean)RocksDBImmutableFile$.MODULE$.isLogFile(file.getName())));
        Tuple2 tuple2 = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])topLevelFiles)).partition((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)RocksDBImmutableFile$.MODULE$.isSstFile(f.getName())));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        File[] topLevelSstFiles = (File[])tuple2._1();
        File[] topLevelOtherFiles = (File[])tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)topLevelSstFiles, (Object)topLevelOtherFiles);
        File[] topLevelSstFiles2 = (File[])tuple22._1();
        File[] topLevelOtherFiles2 = (File[])tuple22._2();
        return new Tuple2(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])topLevelSstFiles2)).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])archivedLogFiles)), Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit())), (Object)Predef$.MODULE$.wrapRefArray((Object[])topLevelOtherFiles2));
    }

    public static final /* synthetic */ long $anonfun$getLatestSnapshotVersion$2(String x$5) {
        return new StringOps(Predef$.MODULE$.augmentString(x$5)).toLong();
    }

    public static final /* synthetic */ boolean $anonfun$getLatestVersion$2(RocksDBFileManager $this, Path x$8) {
        return $this.onlyChangelogFiles().accept(x$8);
    }

    public static final /* synthetic */ long $anonfun$getLatestVersion$4(String x$10) {
        return new StringOps(Predef$.MODULE$.augmentString(x$10)).toLong();
    }

    public static final /* synthetic */ boolean $anonfun$getLatestVersion$5(RocksDBFileManager $this, Path x$11) {
        return $this.onlyZipFiles().accept(x$11);
    }

    public static final /* synthetic */ long $anonfun$getLatestVersion$7(String x$13) {
        return new StringOps(Predef$.MODULE$.augmentString(x$13)).toLong();
    }

    public static final /* synthetic */ boolean $anonfun$findOrphanFiles$3(long oldestTrackedFileModificationTime$1, Tuple2 x$15) {
        return x$15._2$mcJ$sp() < oldestTrackedFileModificationTime$1;
    }

    public static final /* synthetic */ boolean $anonfun$deleteOldVersions$2(RocksDBFileManager $this, Path file) {
        return $this.onlyZipFiles().accept(file);
    }

    public static final /* synthetic */ boolean $anonfun$deleteOldVersions$3(RocksDBFileManager $this, Path file) {
        return $this.onlyChangelogFiles().accept(file);
    }

    public static final /* synthetic */ long $anonfun$deleteOldVersions$5(String x$18) {
        return new StringOps(Predef$.MODULE$.augmentString(x$18)).toLong();
    }

    public static final /* synthetic */ boolean $anonfun$deleteOldVersions$13(long[] snapshotVersionsToDelete$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            long v = tuple2._2$mcJ$sp();
            return new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(snapshotVersionsToDelete$1)).contains((Object)BoxesRunTime.boxToLong((long)v));
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$deleteOldVersions$16(RocksDBFileManager $this, IntRef failedToDelete$1, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 != null) {
            BoxedUnit boxedUnit;
            String dfsFileName = (String)tuple2._1();
            long maxUsedVersion = tuple2._2$mcJ$sp();
            try {
                Path dfsFile = $this.dfsFilePath(dfsFileName);
                $this.fm().delete(dfsFile);
                if (maxUsedVersion == -1L) {
                    $this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(20).append("Deleted orphan file ").append(dfsFileName).toString());
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    $this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(44).append("Deleted file ").append(dfsFileName).append(" that was last used in version ").append(maxUsedVersion).toString());
                    boxedUnit = BoxedUnit.UNIT;
                }
            }
            catch (Exception e) {
                ++failedToDelete$1.elem;
                if (maxUsedVersion == -1L) {
                    $this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(27).append("Error deleting orphan file ").append(dfsFileName).toString(), e);
                    boxedUnit = BoxedUnit.UNIT;
                }
                $this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(43).append("Error deleting file ").append(dfsFileName).append(", last used in version ").append(maxUsedVersion).toString(), e);
                boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ long $anonfun$deleteOldVersions$26(String x$23) {
        return new StringOps(Predef$.MODULE$.augmentString(x$23)).toLong();
    }

    public static final /* synthetic */ void $anonfun$loadImmutableFilesFromDfs$2(RocksDBFileManager $this, Map requiredFileNameToFileDetails$1, File existingFile) {
        boolean isSameFile = requiredFileNameToFileDetails$1.get((Object)existingFile.getName()).exists((Function1 & Serializable & scala.Serializable)x$27 -> BoxesRunTime.boxToBoolean((boolean)x$27.isSameFile(existingFile)));
        if (!isSameFile) {
            existingFile.delete();
            $this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(19).append("Deleted local file ").append(existingFile).toString());
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$loadImmutableFilesFromDfs$5(RocksDBFileManager $this, File localDir$1, LongRef filesCopied$2, LongRef bytesCopied$2, LongRef filesReused$2, RocksDBImmutableFile file) {
        String localFileName = file.localFileName();
        File localFile = $this.localFilePath(localDir$1, localFileName);
        if (!localFile.exists()) {
            Path dfsFile = $this.dfsFilePath(file.dfsFileName());
            $this.fs().copyToLocalFile(dfsFile, new Path(localFile.getAbsoluteFile().toURI()));
            long localFileSize = localFile.length();
            long expectedSize = file.sizeBytes();
            if (localFileSize != expectedSize) {
                throw new IllegalStateException(new StringBuilder(43).append("Copied ").append(dfsFile).append(" to ").append(localFile).append(",").append(" expected ").append(expectedSize).append(" bytes, found ").append(localFileSize).append(" bytes ").toString());
            }
            ++filesCopied$2.elem;
            bytesCopied$2.elem += localFileSize;
            $this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(20).append("Copied ").append(dfsFile).append(" to ").append(localFile).append(" - ").append(localFileSize).append(" bytes").toString());
            return;
        }
        ++filesReused$2.elem;
    }

    private static final /* synthetic */ String filesStr$lzycompute$1(LazyRef filesStr$lzy$1, Path dfsZipFile$1, Seq files$1) {
        String string;
        LazyRef lazyRef = filesStr$lzy$1;
        synchronized (lazyRef) {
            string = filesStr$lzy$1.initialized() ? (String)filesStr$lzy$1.value() : (String)filesStr$lzy$1.initialize((Object)new StringBuilder(2).append(dfsZipFile$1).append("\n\t").append(files$1.mkString("\n\t")).toString());
        }
        return string;
    }

    private static final String filesStr$1(LazyRef filesStr$lzy$1, Path dfsZipFile$1, Seq files$1) {
        if (filesStr$lzy$1.initialized()) {
            return (String)filesStr$lzy$1.value();
        }
        return RocksDBFileManager.filesStr$lzycompute$1(filesStr$lzy$1, dfsZipFile$1, files$1);
    }

    public static final /* synthetic */ void $anonfun$zipToDfsFile$1(ZipOutputStream zout$1, ObjectRef in$1, LongRef totalBytes$1, File file) {
        zout$1.putNextEntry(new ZipEntry(file.getName()));
        in$1.elem = new FileInputStream(file);
        int bytes = IOUtils.copy((InputStream)((InputStream)in$1.elem), (OutputStream)zout$1);
        ((InputStream)in$1.elem).close();
        zout$1.closeEntry();
        totalBytes$1.elem += (long)bytes;
    }

    private static final /* synthetic */ String[] files$lzycompute$1(LazyRef files$lzy$1, File dir$1) {
        String[] stringArray;
        LazyRef lazyRef = files$lzy$1;
        synchronized (lazyRef) {
            stringArray = files$lzy$1.initialized() ? (String[])files$lzy$1.value() : (String[])files$lzy$1.initialize(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])Option$.MODULE$.apply((Object)Utils$.MODULE$.recursiveList(dir$1)).getOrElse((Function0 & Serializable & scala.Serializable)() -> (File[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(File.class))))).map((Function1 & Serializable & scala.Serializable)f -> new StringBuilder(9).append(f.getAbsolutePath()).append(" - ").append(f.length()).append(" bytes").toString(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))));
        }
        return stringArray;
    }

    private static final String[] files$2(LazyRef files$lzy$1, File dir$1) {
        if (files$lzy$1.initialized()) {
            return (String[])files$lzy$1.value();
        }
        return RocksDBFileManager.files$lzycompute$1(files$lzy$1, dir$1);
    }

    public static final /* synthetic */ boolean $anonfun$listRocksDBFiles$1(File x$28) {
        return !x$28.isDirectory();
    }

    public RocksDBFileManager(String dfsRootDir, File localTempDir, Configuration hadoopConf, String codecName, String loggingId) {
        this.dfsRootDir = dfsRootDir;
        this.localTempDir = localTempDir;
        this.hadoopConf = hadoopConf;
        this.codecName = codecName;
        this.loggingId = loggingId;
        Logging.$init$((Logging)this);
        this.versionToRocksDBFiles = new ConcurrentHashMap();
        this.fs = new Path(dfsRootDir).getFileSystem(hadoopConf);
        this.onlyZipFiles = new PathFilter(null){

            public boolean accept(Path path) {
                return path.toString().endsWith(".zip");
            }
        };
        this.onlyChangelogFiles = new PathFilter(null){

            public boolean accept(Path path) {
                return path.toString().endsWith(".changelog");
            }
        };
        this.loadCheckpointMetrics = RocksDBFileManagerMetrics$.MODULE$.EMPTY_METRICS();
        this.saveCheckpointMetrics = RocksDBFileManagerMetrics$.MODULE$.EMPTY_METRICS();
    }
}

