/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.streaming;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.net.URL;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.LinkedHashMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.util.Progressable;
import org.apache.spark.SparkContext;
import org.apache.spark.deploy.SparkHadoopUtil$;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.util.package$;
import org.apache.spark.sql.connector.read.streaming.Offset;
import org.apache.spark.sql.connector.read.streaming.ReadLimit;
import org.apache.spark.sql.execution.streaming.CleanSourceMode$;
import org.apache.spark.sql.execution.streaming.CompactibleFileStreamLog$;
import org.apache.spark.sql.execution.streaming.FileStreamOptions;
import org.apache.spark.sql.execution.streaming.FileStreamSink$;
import org.apache.spark.sql.execution.streaming.FileStreamSinkLog;
import org.apache.spark.sql.execution.streaming.FileStreamSinkLog$;
import org.apache.spark.sql.execution.streaming.FileStreamSource;
import org.apache.spark.sql.execution.streaming.FileStreamSourceLog;
import org.apache.spark.sql.execution.streaming.FileStreamSourceLog$;
import org.apache.spark.sql.execution.streaming.FileStreamSourceOffset;
import org.apache.spark.sql.execution.streaming.FileStreamSourceOffset$;
import org.apache.spark.sql.execution.streaming.MemoryStream;
import org.apache.spark.sql.execution.streaming.MemoryStream$;
import org.apache.spark.sql.execution.streaming.SerializedOffset;
import org.apache.spark.sql.execution.streaming.StreamExecution;
import org.apache.spark.sql.execution.streaming.StreamingQueryWrapper;
import org.apache.spark.sql.execution.streaming.StreamingRelation;
import org.apache.spark.sql.execution.streaming.sources.MemorySink;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.streaming.CountListingLocalFileSystem;
import org.apache.spark.sql.streaming.CountListingLocalFileSystem$;
import org.apache.spark.sql.streaming.DataStreamReader;
import org.apache.spark.sql.streaming.DataStreamWriter;
import org.apache.spark.sql.streaming.ExistsThrowsExceptionFileSystem;
import org.apache.spark.sql.streaming.ExistsThrowsExceptionFileSystem$;
import org.apache.spark.sql.streaming.FileStreamSourceSuite$;
import org.apache.spark.sql.streaming.FileStreamSourceTest;
import org.apache.spark.sql.streaming.OutputMode;
import org.apache.spark.sql.streaming.StreamTest;
import org.apache.spark.sql.streaming.StreamingQuery;
import org.apache.spark.sql.streaming.StreamingQueryException;
import org.apache.spark.sql.streaming.StreamingQueryProgress;
import org.apache.spark.sql.streaming.Trigger;
import org.apache.spark.sql.streaming.util.StreamManualClock;
import org.apache.spark.sql.streaming.util.StreamManualClock$;
import org.apache.spark.sql.test.SharedSparkSession;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.util.Clock;
import org.apache.spark.util.Utils$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.PrivateMethodTester;
import org.scalatest.Tag;
import org.scalatest.compatible.Assertion;
import org.scalatest.enablers.Retrying$;
import org.scalatest.enablers.Timed$;
import org.scalatest.time.Span;
import org.scalatest.time.Span$;
import org.scalatest.time.SpanSugar$;
import scala.Array$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.NotImplementedError;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Symbol;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.MapLike;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.io.Codec$;
import scala.io.Source$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\tEg\u0001B\u0013'\u0001EBQA\u000e\u0001\u0005\u0002]Bq!\u000f\u0001C\u0002\u0013\u0005#\b\u0003\u0004D\u0001\u0001\u0006Ia\u000f\u0005\u0006\t\u0002!I!\u0012\u0005\bU\u0002\t\n\u0011\"\u0003l\u0011\u00151\b\u0001\"\u0003x\u0011\u001da\b!%A\u0005\n-DQ! \u0001\u0005ByDa!!\u0002\u0001\t\u0003r\bbBA\u0004\u0001\u0011%\u0011\u0011\u0002\u0005\b\u0003\u000f\u0002A\u0011BA%\u0011\u001d\t)\u0006\u0001C\u0005\u0003/B\u0011\"a'\u0001#\u0003%I!!(\t\u0013\u0005\u0005\u0006!%A\u0005\n\u0005\r\u0006\"CAT\u0001E\u0005I\u0011BAO\r\u0019\tI\u000b\u0001\u0001\u0002,\"I\u0011Q\u0018\t\u0003\u0002\u0003\u0006Ia\u0014\u0005\u0007mA!\t!a0\t\u000f\u0005\u001d\u0007\u0003\"\u0011\u0002J\"9\u0011Q\u001b\t\u0005B\u0005]\u0007bBAu!\u0011\u0005\u00131\u001e\u0005\b\u0003g\u0004B\u0011IA{\u0011\u001d\u0011\u0019\u0001\u0005C!\u0005\u000bAqA!\u0007\u0011\t\u0003\u0012Y\u0002C\u0004\u0003RA!\tEa\u0015\t\u000f\tm\u0003\u0003\"\u0011\u0003^!9!Q\r\t\u0005B\t\u001d\u0004b\u0002B<!\u0011\u0005#\u0011\u0010\u0005\b\u0005\u007f\u0002B\u0011\tBA\u0011\u001d\u0011\u0019\t\u0005C!\u0005\u000bCqA!#\u0001\t\u0013\u0011Y\tC\u0004\u0003\u0016\u0002!IAa&\t\u000f\tu\u0005\u0001\"\u0003\u0003 \"9!1\u0016\u0001\u0005\n\t5\u0006b\u0002B[\u0001\u0011%!q\u0017\u0005\b\u0005\u0007\u0004A\u0011\u0002Bc\u0005U1\u0015\u000e\\3TiJ,\u0017-\\*pkJ\u001cWmU;ji\u0016T!a\n\u0015\u0002\u0013M$(/Z1nS:<'BA\u0015+\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003W1\nQa\u001d9be.T!!\f\u0018\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005y\u0013aA8sO\u000e\u00011C\u0001\u00013!\t\u0019D'D\u0001'\u0013\t)dE\u0001\u000bGS2,7\u000b\u001e:fC6\u001cv.\u001e:dKR+7\u000f^\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003a\u0002\"a\r\u0001\u0002!M$(/Z1nS:<G+[7f_V$X#A\u001e\u0011\u0005q\nU\"A\u001f\u000b\u0005yz\u0014\u0001\u0002;j[\u0016T!\u0001\u0011\u0018\u0002\u0013M\u001c\u0017\r\\1uKN$\u0018B\u0001\">\u0005\u0011\u0019\u0006/\u00198\u0002#M$(/Z1nS:<G+[7f_V$\b%\u0001\fde\u0016\fG/\u001a$jY\u0016\u001cFO]3b[N{WO]2f)\u00111U\n\u00180\u0011\u0005\u001d[U\"\u0001%\u000b\u0005\u001dJ%B\u0001&)\u0003%)\u00070Z2vi&|g.\u0003\u0002M\u0011\n\u0001b)\u001b7f'R\u0014X-Y7T_V\u00148-\u001a\u0005\u0006\u001d\u0012\u0001\raT\u0001\u0007M>\u0014X.\u0019;\u0011\u0005AKfBA)X!\t\u0011V+D\u0001T\u0015\t!\u0006'\u0001\u0004=e>|GO\u0010\u0006\u0002-\u0006)1oY1mC&\u0011\u0001,V\u0001\u0007!J,G-\u001a4\n\u0005i[&AB*ue&twM\u0003\u0002Y+\")Q\f\u0002a\u0001\u001f\u0006!\u0001/\u0019;i\u0011\u001dyF\u0001%AA\u0002\u0001\faa]2iK6\f\u0007cA1cI6\tQ+\u0003\u0002d+\n1q\n\u001d;j_:\u0004\"!\u001a5\u000e\u0003\u0019T!a\u001a\u0015\u0002\u000bQL\b/Z:\n\u0005%4'AC*ueV\u001cG\u000fV=qK\u0006\u00013M]3bi\u00164\u0015\u000e\\3TiJ,\u0017-\\*pkJ\u001cW\r\n3fM\u0006,H\u000e\u001e\u00134+\u0005a'F\u00011nW\u0005q\u0007CA8u\u001b\u0005\u0001(BA9s\u0003%)hn\u00195fG.,GM\u0003\u0002t+\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\u0005U\u0004(!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006\u00113M]3bi\u00164\u0015\u000e\\3TiJ,\u0017-\\*pkJ\u001cW-\u00118e\u000f\u0016$8k\u00195f[\u0006$B\u0001\u001a={w\")aJ\u0002a\u0001sB\u0019\u0011MY(\t\u000bu3\u0001\u0019A=\t\u000f}3\u0001\u0013!a\u0001A\u0006a3M]3bi\u00164\u0015\u000e\\3TiJ,\u0017-\\*pkJ\u001cW-\u00118e\u000f\u0016$8k\u00195f[\u0006$C-\u001a4bk2$HeM\u0001\nE\u00164wN]3BY2$\u0012a \t\u0004C\u0006\u0005\u0011bAA\u0002+\n!QK\\5u\u0003!\tg\r^3s\u00032d\u0017a\u0005:fC\u0012dun\u001a$s_6\u0014Vm]8ve\u000e,G\u0003BA\u0006\u0003\u0007\u0002b!!\u0004\u0002\u0018\u0005ua\u0002BA\b\u0003'q1AUA\t\u0013\u00051\u0016bAA\u000b+\u00069\u0001/Y2lC\u001e,\u0017\u0002BA\r\u00037\u00111aU3r\u0015\r\t)\"\u0016\t\u0005\u0003?\tiD\u0004\u0003\u0002\"\u0005eb\u0002BA\u0012\u0003oqA!!\n\u000269!\u0011qEA\u001a\u001d\u0011\tI#!\r\u000f\t\u0005-\u0012q\u0006\b\u0004%\u00065\u0012\"A\u0018\n\u00055r\u0013BA\u0016-\u0013\tI#&\u0003\u0002KQ%\u0011q%S\u0005\u0004\u0003wA\u0015\u0001\u0005$jY\u0016\u001cFO]3b[N{WO]2f\u0013\u0011\ty$!\u0011\u0003\u0013\u0019KG.Z#oiJL(bAA\u001e\u0011\"1\u0011Q\t\u0006A\u0002=\u000b1\u0001Z5s\u0003Y\u0011X-\u00193PM\u001a\u001cX\r\u001e$s_6\u0014Vm]8ve\u000e,G\u0003BA&\u0003#\u00022aRA'\u0013\r\ty\u0005\u0013\u0002\u0011'\u0016\u0014\u0018.\u00197ju\u0016$wJ\u001a4tKRDa!a\u0015\f\u0001\u0004y\u0015\u0001\u00024jY\u0016\fQD];o)^|')\u0019;dQ\u0016\u001c\u0018I\u001c3WKJLg-\u001f*fgVdGo\u001d\u000b\u0010\u007f\u0006e\u0013QNA<\u0003w\ny(a!\u0002\u0018\"9\u00111\f\u0007A\u0002\u0005u\u0013aA:sGB!\u0011qLA5\u001b\t\t\tG\u0003\u0003\u0002d\u0005\u0015\u0014AA5p\u0015\t\t9'\u0001\u0003kCZ\f\u0017\u0002BA6\u0003C\u0012AAR5mK\"9\u0011q\u000e\u0007A\u0002\u0005E\u0014a\u00037bi\u0016\u001cHOR5sgR\u00042!YA:\u0013\r\t)(\u0016\u0002\b\u0005>|G.Z1o\u0011\u0019\tI\b\u0004a\u0001\u001f\u0006Qa-\u001b:ti\n\u000bGo\u00195\t\r\u0005uD\u00021\u0001P\u0003-\u0019XmY8oI\n\u000bGo\u00195\t\u0011\u0005\u0005E\u0002%AA\u0002e\f!\"\\1y\r&dW-Q4f\u0011%\t)\t\u0004I\u0001\u0002\u0004\t9)A\u0006dY\u0016\fgnU8ve\u000e,\u0007\u0003BAE\u0003\u001fs1aRAF\u0013\r\ti\tS\u0001\u0010\u00072,\u0017M\\*pkJ\u001cW-T8eK&!\u0011\u0011SAJ\u0005\u00151\u0016\r\\;f\u0013\r\t)*\u0016\u0002\f\u000b:,X.\u001a:bi&|g\u000e\u0003\u0005\u0002\u001a2\u0001\n\u00111\u0001z\u0003)\t'o\u00195jm\u0016$\u0015N]\u0001(eVtGk^8CCR\u001c\u0007.Z:B]\u00124VM]5gsJ+7/\u001e7ug\u0012\"WMZ1vYR$S'\u0006\u0002\u0002 *\u0012\u00110\\\u0001(eVtGk^8CCR\u001c\u0007.Z:B]\u00124VM]5gsJ+7/\u001e7ug\u0012\"WMZ1vYR$c'\u0006\u0002\u0002&*\u001a\u0011qQ7\u0002OI,h\u000eV<p\u0005\u0006$8\r[3t\u0003:$g+\u001a:jMf\u0014Vm];miN$C-\u001a4bk2$He\u000e\u0002\u000f\r\u0006\\WMR5mKNK8\u000f^3n'\r\u0001\u0012Q\u0016\t\u0005\u0003_\u000bI,\u0004\u0002\u00022*!\u00111WA[\u0003\t17OC\u0002\u000282\na\u0001[1e_>\u0004\u0018\u0002BA^\u0003c\u0013!BR5mKNK8\u000f^3n\u0003\u0019\u00198\r[3nKR!\u0011\u0011YAc!\r\t\u0019\rE\u0007\u0002\u0001!1\u0011Q\u0018\nA\u0002=\u000ba!\u001a=jgR\u001cH\u0003BA9\u0003\u0017Dq!!4\u0014\u0001\u0004\ty-A\u0001g!\u0011\ty+!5\n\t\u0005M\u0017\u0011\u0017\u0002\u0005!\u0006$\b.\u0001\u0004nW\u0012L'o\u001d\u000b\u0007\u0003c\nI.a7\t\u000f\u00055G\u00031\u0001\u0002P\"9\u0011Q\u001c\u000bA\u0002\u0005}\u0017A\u00039fe6L7o]5p]B!\u0011\u0011]As\u001b\t\t\u0019O\u0003\u0003\u0002^\u0006E\u0016\u0002BAt\u0003G\u0014ABR:QKJl\u0017n]:j_:\faA]3oC6,GCBA9\u0003[\fy\u000fC\u0004\u0002\\U\u0001\r!a4\t\u000f\u0005EX\u00031\u0001\u0002P\u0006\u0019Am\u001d;\u0002\r\u001d,G/\u0016:j)\t\t9\u0010\u0005\u0003\u0002z\u0006}XBAA~\u0015\u0011\ti0!\u001a\u0002\u00079,G/\u0003\u0003\u0003\u0002\u0005m(aA+S\u0013\u0006!q\u000e]3o)\u0019\u00119A!\u0004\u0003\u0010A!\u0011q\u0016B\u0005\u0013\u0011\u0011Y!!-\u0003#\u0019\u001bF)\u0019;b\u0013:\u0004X\u000f^*ue\u0016\fW\u000eC\u0004\u0002N^\u0001\r!a4\t\u000f\tEq\u00031\u0001\u0003\u0014\u0005Q!-\u001e4gKJ\u001c\u0016N_3\u0011\u0007\u0005\u0014)\"C\u0002\u0003\u0018U\u00131!\u00138u\u0003\u0019\u0019'/Z1uKR\u0001\"Q\u0004B\u0012\u0005K\u00119Ca\u000b\u0003.\t]\"\u0011\t\t\u0005\u0003_\u0013y\"\u0003\u0003\u0003\"\u0005E&A\u0005$T\t\u0006$\u0018mT;uaV$8\u000b\u001e:fC6Dq!!4\u0019\u0001\u0004\ty\rC\u0004\u0002^b\u0001\r!a8\t\u000f\t%\u0002\u00041\u0001\u0002r\u0005IqN^3soJLG/\u001a\u0005\b\u0005#A\u0002\u0019\u0001B\n\u0011\u001d\u0011y\u0003\u0007a\u0001\u0005c\t1B]3qY&\u001c\u0017\r^5p]B\u0019\u0011Ma\r\n\u0007\tURKA\u0003TQ>\u0014H\u000fC\u0004\u0003:a\u0001\rAa\u000f\u0002\u0013\tdwnY6TSj,\u0007cA1\u0003>%\u0019!qH+\u0003\t1{gn\u001a\u0005\b\u0005\u0007B\u0002\u0019\u0001B#\u0003!\u0001(o\\4sKN\u001c\b\u0003\u0002B$\u0005\u001bj!A!\u0013\u000b\t\t-\u0013QW\u0001\u0005kRLG.\u0003\u0003\u0003P\t%#\u0001\u0004)s_\u001e\u0014Xm]:bE2,\u0017AB1qa\u0016tG\r\u0006\u0005\u0003\u001e\tU#q\u000bB-\u0011\u001d\ti-\u0007a\u0001\u0003\u001fDqA!\u0005\u001a\u0001\u0004\u0011\u0019\u0002C\u0004\u0003De\u0001\rA!\u0012\u0002\r\u0011,G.\u001a;f)\u0019\t\tHa\u0018\u0003b!9\u0011Q\u001a\u000eA\u0002\u0005=\u0007b\u0002B25\u0001\u0007\u0011\u0011O\u0001\ne\u0016\u001cWO]:jm\u0016\f!\u0002\\5tiN#\u0018\r^;t)\u0011\u0011IG!\u001e\u0011\u000b\u0005\u0014YGa\u001c\n\u0007\t5TKA\u0003BeJ\f\u0017\u0010\u0005\u0003\u00020\nE\u0014\u0002\u0002B:\u0003c\u0013!BR5mKN#\u0018\r^;t\u0011\u001d\tim\u0007a\u0001\u0003\u001f\f1c]3u/>\u00148.\u001b8h\t&\u0014Xm\u0019;pef$2a B>\u0011\u001d\u0011i\b\ba\u0001\u0003\u001f\fqA\\3x?\u0012L'/A\nhKR<vN]6j]\u001e$\u0015N]3di>\u0014\u0018\u0010\u0006\u0002\u0002P\u0006iq-\u001a;GS2,7\u000b^1ukN$BAa\u001c\u0003\b\"9\u0011Q\u001a\u0010A\u0002\u0005=\u0017aE1tg\u0016\u0014HOR5mK&\u001b(+Z7pm\u0016$G#B@\u0003\u000e\nE\u0005b\u0002BH?\u0001\u0007\u0011QL\u0001\ng>,(oY3ESJDaAa% \u0001\u0004y\u0015\u0001\u00034jY\u0016t\u0015-\\3\u0002-\u0005\u001c8/\u001a:u\r&dW-S:O_R\u0014V-\\8wK\u0012$Ra BM\u00057CqAa$!\u0001\u0004\ti\u0006\u0003\u0004\u0003\u0014\u0002\u0002\raT\u0001\u0015CN\u001cXM\u001d;GS2,\u0017j\u001d(pi6{g/\u001a3\u0015\u000f}\u0014\tKa)\u0003(\"9!qR\u0011A\u0002\u0005u\u0003b\u0002BSC\u0001\u0007\u0011QL\u0001\fKb\u0004Xm\u0019;fI\u0012K'\u000f\u0003\u0004\u0003*\u0006\u0002\raT\u0001\u000bM&dW\r\u0015:fM&D\u0018!E1tg\u0016\u0014HOR5mK&\u001bXj\u001c<fIR9qPa,\u00032\nM\u0006b\u0002BHE\u0001\u0007\u0011Q\f\u0005\b\u0005K\u0013\u0003\u0019AA/\u0011\u0019\u0011IK\ta\u0001\u001f\u0006\u0001t/\u001b;i\u0007>,h\u000e\u001e'jgRLgn\u001a'pG\u0006dg)\u001b7f'f\u001cH/Z7Bg2{7-\u00197GS2,7+_:uK6$2a B]\u0011!\u0011Yl\tCA\u0002\tu\u0016\u0001\u00022pIf\u0004B!\u0019B`\u007f&\u0019!\u0011Y+\u0003\u0011q\u0012\u0017P\\1nKz\n!b\u0019:fCR,g)\u001b7f)!\tiFa2\u0003L\n5\u0007B\u0002BeI\u0001\u0007q*A\u0004d_:$XM\u001c;\t\u000f\u0005mC\u00051\u0001\u0002^!9!q\u001a\u0013A\u0002\u0005u\u0013a\u0001;na\u0002")
public class FileStreamSourceSuite
extends FileStreamSourceTest {
    private final Span streamingTimeout = SpanSugar$.MODULE$.convertIntToGrainOfTime(80).seconds();

    @Override
    public Span streamingTimeout() {
        return this.streamingTimeout;
    }

    private FileStreamSource createFileStreamSource(String format, String path, Option<StructType> schema) {
        return this.getSourceFromFileStream(this.createFileStream(format, path, schema, this.createFileStream$default$4()));
    }

    private StructType createFileStreamSourceAndGetSchema(Option<String> format, Option<String> path, Option<StructType> schema2) {
        DataStreamReader reader = this.spark().readStream();
        format.foreach((Function1 & Serializable & scala.Serializable)source -> reader.format(source));
        schema2.foreach((Function1 & Serializable & scala.Serializable)schema -> reader.schema(schema));
        Dataset df = path.isDefined() ? reader.load((String)path.get()) : reader.load();
        return (StructType)df.queryExecution().analyzed().collect((PartialFunction)new scala.Serializable(null){
            public static final long serialVersionUID = 0L;

            public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof StreamingRelation) {
                    StreamingRelation streamingRelation = (StreamingRelation)A1;
                    object = streamingRelation.schema();
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(LogicalPlan x1) {
                LogicalPlan logicalPlan = x1;
                boolean bl = logicalPlan instanceof StreamingRelation;
                return bl;
            }
        }).head();
    }

    @Override
    public void beforeAll() {
        SharedSparkSession.beforeAll$(this);
        this.spark().sessionState().conf().setConf(SQLConf$.MODULE$.ORC_IMPLEMENTATION(), (Object)"native");
    }

    @Override
    public void afterAll() {
        try {
            this.spark().sessionState().conf().unsetConf(SQLConf$.MODULE$.ORC_IMPLEMENTATION());
        }
        finally {
            StreamTest.afterAll$(this);
        }
    }

    private Seq<FileStreamSource.FileEntry> readLogFromResource(String dir) {
        URL input = this.getClass().getResource(new StringBuilder(22).append("/structured-streaming/").append(dir).toString());
        FileStreamSourceLog log = new FileStreamSourceLog(FileStreamSourceLog$.MODULE$.VERSION(), this.spark(), input.toString());
        return Predef$.MODULE$.wrapRefArray(log.allFiles());
    }

    private SerializedOffset readOffsetFromResource(String file) {
        return (SerializedOffset)Utils$.MODULE$.tryWithResource((Function0 & Serializable & scala.Serializable)() -> Source$.MODULE$.fromFile(this.getClass().getResource(new StringBuilder(22).append("/structured-streaming/").append(file).toString()).toURI(), Codec$.MODULE$.fallbackSystemCodec()), (Function1 & Serializable & scala.Serializable)source -> new SerializedOffset(source.mkString().trim()));
    }

    private void runTwoBatchesAndVerifyResults(File src, boolean latestFirst, String firstBatch, String secondBatch, Option<String> maxFileAge, Enumeration.Value cleanSource, Option<String> archiveDir) {
        Map srcOptions = ((MapLike)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"latestFirst"), (Object)Boolean.toString(latestFirst)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"maxFilesPerTrigger"), (Object)"1")}))).$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable(maxFileAge.map((Function1 & Serializable & scala.Serializable)x$35 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"maxFileAge"), x$35)))).$plus$plus((GenTraversableOnce)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"cleanSource"), (Object)cleanSource.toString()), (List)Nil$.MODULE$)).$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable(archiveDir.map((Function1 & Serializable & scala.Serializable)x$36 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sourceArchiveDir"), x$36))));
        String x$1 = "text";
        String x$2 = src.getCanonicalPath();
        Map x$3 = srcOptions;
        Option<StructType> x$4 = this.createFileStream$default$3();
        Dataset<Row> fileStream = this.createFileStream(x$1, x$2, x$4, (Map<String, String>)x$3);
        StreamManualClock clock = new StreamManualClock(StreamManualClock$.MODULE$.$lessinit$greater$default$1());
        this.testStream(fileStream, this.testStream$default$2(), (Seq<StreamTest.StreamAction>)Predef$.MODULE$.wrapRefArray((Object[])new StreamTest.StreamAction[]{new StreamTest.StartStream(this, Trigger.ProcessingTime((long)10L), (Clock)clock, this.StartStream().apply$default$3(), this.StartStream().apply$default$4()), this.AssertOnQuery().apply((Function1<StreamExecution, Object>)(Function1 & Serializable & scala.Serializable)x$37 -> BoxesRunTime.boxToBoolean((boolean)FileStreamSourceSuite.$anonfun$runTwoBatchesAndVerifyResults$3(this, clock, x$37)), this.AssertOnQuery().apply$default$2()), this.CheckLastBatch().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{firstBatch}), this.testImplicits().newStringEncoder()), new StreamTest.AdvanceManualClock(this, 10L), this.AssertOnQuery().apply((Function1<StreamExecution, Object>)(Function1 & Serializable & scala.Serializable)x$38 -> BoxesRunTime.boxToBoolean((boolean)FileStreamSourceSuite.$anonfun$runTwoBatchesAndVerifyResults$5(this, clock, x$38)), this.AssertOnQuery().apply$default$2()), this.CheckLastBatch().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{secondBatch}), this.testImplicits().newStringEncoder())}));
    }

    private Option<String> runTwoBatchesAndVerifyResults$default$5() {
        return None$.MODULE$;
    }

    private Enumeration.Value runTwoBatchesAndVerifyResults$default$6() {
        return CleanSourceMode$.MODULE$.OFF();
    }

    private Option<String> runTwoBatchesAndVerifyResults$default$7() {
        return None$.MODULE$;
    }

    private void assertFileIsRemoved(File sourceDir, String fileName) {
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])sourceDir.list())).exists((Function1 & Serializable & scala.Serializable)x$47 -> BoxesRunTime.boxToBoolean((boolean)x$47.startsWith(fileName))), "scala.Predef.refArrayOps[String](sourceDir.list()).exists(((x$47: String) => x$47.startsWith(fileName)))", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2138));
    }

    private void assertFileIsNotRemoved(File sourceDir, String fileName) {
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])sourceDir.list())).exists((Function1 & Serializable & scala.Serializable)x$48 -> BoxesRunTime.boxToBoolean((boolean)x$48.startsWith(fileName))), "scala.Predef.refArrayOps[String](sourceDir.list()).exists(((x$48: String) => x$48.startsWith(fileName)))", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2142));
    }

    private void assertFileIsNotMoved(File sourceDir, File expectedDir, String filePrefix) {
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(sourceDir.exists(), "sourceDir.exists()", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2146));
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])sourceDir.list())).exists((Function1 & Serializable & scala.Serializable)x$49 -> BoxesRunTime.boxToBoolean((boolean)x$49.startsWith(filePrefix))), "scala.Predef.refArrayOps[String](sourceDir.list()).exists(((x$49: String) => x$49.startsWith(filePrefix)))", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2147));
        if (expectedDir.exists()) {
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])expectedDir.list())).exists((Function1 & Serializable & scala.Serializable)x$50 -> BoxesRunTime.boxToBoolean((boolean)x$50.startsWith(filePrefix))), "scala.Predef.refArrayOps[String](expectedDir.list()).exists(((x$50: String) => x$50.startsWith(filePrefix)))", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2151));
        }
    }

    private void assertFileIsMoved(File sourceDir, File expectedDir, String filePrefix) {
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(sourceDir.exists(), "sourceDir.exists()", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2156));
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])sourceDir.list())).exists((Function1 & Serializable & scala.Serializable)x$51 -> BoxesRunTime.boxToBoolean((boolean)x$51.startsWith(filePrefix))), "scala.Predef.refArrayOps[String](sourceDir.list()).exists(((x$51: String) => x$51.startsWith(filePrefix)))", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2157));
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(expectedDir.exists(), "expectedDir.exists()", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2158));
        Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])expectedDir.list())).exists((Function1 & Serializable & scala.Serializable)x$52 -> BoxesRunTime.boxToBoolean((boolean)x$52.startsWith(filePrefix))), "scala.Predef.refArrayOps[String](expectedDir.list()).exists(((x$52: String) => x$52.startsWith(filePrefix)))", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2159));
    }

    private void withCountListingLocalFileSystemAsLocalFileSystem(Function0<BoxedUnit> body) {
        String optionKey = new StringBuilder(8).append("fs.").append(CountListingLocalFileSystem$.MODULE$.scheme()).append(".impl").toString();
        Option originClassForLocalFileSystem = this.spark().conf().getOption(optionKey);
        try {
            this.spark().conf().set(optionKey, CountListingLocalFileSystem.class.getName());
            body.apply$mcV$sp();
        }
        finally {
            Option option = originClassForLocalFileSystem;
            if (option instanceof Some) {
                Some some = (Some)option;
                String fsClazz = (String)some.value();
                this.spark().conf().set(optionKey, fsClazz);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                this.spark().conf().unset(optionKey);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
        }
    }

    private File createFile(String content, File src, File tmp) {
        File tempFile = Utils$.MODULE$.tempFileWith(new File(tmp, "text"));
        File finalFile = new File(src, tempFile.getName());
        Predef$.MODULE$.require(!src.exists(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(22).append(src).append(" exists, dir: ").append(src.isDirectory()).append(", file: ").append(src.isFile()).toString());
        Predef$.MODULE$.require(src.mkdirs(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(14).append("Cannot create ").append(src).toString());
        Predef$.MODULE$.require(src.isDirectory(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(19).append(src).append(" is not a directory").toString());
        Predef$.MODULE$.require(package$.MODULE$.stringToFile(tempFile, content).renameTo(finalFile));
        return finalFile;
    }

    private Option<StructType> createFileStreamSource$default$3() {
        return None$.MODULE$;
    }

    private Option<StructType> createFileStreamSourceAndGetSchema$default$3() {
        return None$.MODULE$;
    }

    private final void testError$1() {
        IllegalArgumentException e = (IllegalArgumentException)this.intercept((Function0 & Serializable & scala.Serializable)() -> this.createFileStreamSourceAndGetSchema((Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$, (Option<StructType>)None$.MODULE$), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 275));
        String $org_scalatest_assert_macro_left = e.getMessage();
        String $org_scalatest_assert_macro_right = "path";
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 278));
    }

    public static final /* synthetic */ void $anonfun$new$12(FileStreamSourceSuite $this, File src) {
        StructType schema = $this.createFileStreamSourceAndGetSchema((Option<String>)new Some((Object)"text"), (Option<String>)new Some((Object)src.getCanonicalPath()), (Option<StructType>)None$.MODULE$);
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(schema);
        StructType $org_scalatest_assert_macro_right = new StructType().add("value", (DataType)StringType$.MODULE$);
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 311));
    }

    public static final /* synthetic */ void $anonfun$new$14(FileStreamSourceSuite $this, File src) {
        package$.MODULE$.stringToFile(new File(src, "1"), "a\nb\nc");
        StructType schema = $this.createFileStreamSourceAndGetSchema((Option<String>)new Some((Object)"text"), (Option<String>)new Some((Object)src.getCanonicalPath()), (Option<StructType>)None$.MODULE$);
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(schema);
        StructType $org_scalatest_assert_macro_right = new StructType().add("value", (DataType)StringType$.MODULE$);
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 320));
    }

    public static final /* synthetic */ void $anonfun$new$16(FileStreamSourceSuite $this, File src) {
        package$.MODULE$.stringToFile(new File(src, "1"), "a\nb\nc");
        StructType userSchema = new StructType().add("userColumn", (DataType)StringType$.MODULE$);
        StructType schema = $this.createFileStreamSourceAndGetSchema((Option<String>)new Some((Object)"text"), (Option<String>)new Some((Object)src.getCanonicalPath()), (Option<StructType>)new Some((Object)userSchema));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(schema);
        StructType $org_scalatest_assert_macro_right = userSchema;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 330));
    }

    public static final /* synthetic */ void $anonfun$new$18(FileStreamSourceSuite $this, File src) {
        $this.testImplicits().localSeqToDatasetHolder((Seq)new .colon.colon((Object)"a", (List)new .colon.colon((Object)"b", (List)new .colon.colon((Object)"c", (List)Nil$.MODULE$))), $this.testImplicits().newStringEncoder()).toDS().as("userColumn").toDF().write().mode(SaveMode.Overwrite).orc(src.getCanonicalPath());
        $this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.STREAMING_SCHEMA_INFERENCE().key()), (Object)"false")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.intercept((Function0 & Serializable & scala.Serializable)() -> $this.createFileStreamSourceAndGetSchema((Option<String>)new Some((Object)"orc"), (Option<String>)new Some((Object)src.getCanonicalPath()), (Option<StructType>)None$.MODULE$), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 344)));
        $this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.STREAMING_SCHEMA_INFERENCE().key()), (Object)"true")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            StructType schema = $this.createFileStreamSourceAndGetSchema((Option<String>)new Some((Object)"orc"), (Option<String>)new Some((Object)src.getCanonicalPath()), (Option<StructType>)None$.MODULE$);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(schema);
            StructType $org_scalatest_assert_macro_right = new StructType().add("value", (DataType)StringType$.MODULE$);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 354));
        });
    }

    public static final /* synthetic */ void $anonfun$new$23(FileStreamSourceSuite $this, File src) {
        $this.testImplicits().localSeqToDatasetHolder((Seq)new .colon.colon((Object)"a", (List)new .colon.colon((Object)"b", (List)new .colon.colon((Object)"c", (List)Nil$.MODULE$))), $this.testImplicits().newStringEncoder()).toDS().as("oldUserColumn").toDF().write().orc(new File(src, "1").getCanonicalPath());
        StructType userSchema = new StructType().add("userColumn", (DataType)StringType$.MODULE$);
        StructType schema = $this.createFileStreamSourceAndGetSchema((Option<String>)new Some((Object)"orc"), (Option<String>)new Some((Object)src.getCanonicalPath()), (Option<StructType>)new Some((Object)userSchema));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(schema);
        StructType $org_scalatest_assert_macro_right = userSchema;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 366));
    }

    public static final /* synthetic */ void $anonfun$new$25(FileStreamSourceSuite $this, File src) {
        $this.testImplicits().localSeqToDatasetHolder((Seq)new .colon.colon((Object)"a", (List)new .colon.colon((Object)"b", (List)new .colon.colon((Object)"c", (List)Nil$.MODULE$))), $this.testImplicits().newStringEncoder()).toDS().as("userColumn").toDF().write().mode(SaveMode.Overwrite).parquet(src.getCanonicalPath());
        $this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.STREAMING_SCHEMA_INFERENCE().key()), (Object)"false")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.intercept((Function0 & Serializable & scala.Serializable)() -> $this.createFileStreamSourceAndGetSchema((Option<String>)new Some((Object)"parquet"), (Option<String>)new Some((Object)src.getCanonicalPath()), (Option<StructType>)None$.MODULE$), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 380)));
        $this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.STREAMING_SCHEMA_INFERENCE().key()), (Object)"true")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            StructType schema = $this.createFileStreamSourceAndGetSchema((Option<String>)new Some((Object)"parquet"), (Option<String>)new Some((Object)src.getCanonicalPath()), (Option<StructType>)None$.MODULE$);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(schema);
            StructType $org_scalatest_assert_macro_right = new StructType().add("value", (DataType)StringType$.MODULE$);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 390));
        });
    }

    public static final /* synthetic */ void $anonfun$new$30(FileStreamSourceSuite $this, File src) {
        $this.testImplicits().localSeqToDatasetHolder((Seq)new .colon.colon((Object)"a", (List)new .colon.colon((Object)"b", (List)new .colon.colon((Object)"c", (List)Nil$.MODULE$))), $this.testImplicits().newStringEncoder()).toDS().as("oldUserColumn").toDF().write().parquet(new File(src, "1").getCanonicalPath());
        StructType userSchema = new StructType().add("userColumn", (DataType)StringType$.MODULE$);
        StructType schema = $this.createFileStreamSourceAndGetSchema((Option<String>)new Some((Object)"parquet"), (Option<String>)new Some((Object)src.getCanonicalPath()), (Option<StructType>)new Some((Object)userSchema));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(schema);
        StructType $org_scalatest_assert_macro_right = userSchema;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 402));
    }

    public static final /* synthetic */ void $anonfun$new$36(FileStreamSourceSuite $this, File src) {
        $this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.STREAMING_SCHEMA_INFERENCE().key()), (Object)"false")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.intercept((Function0 & Serializable & scala.Serializable)() -> $this.createFileStreamSourceAndGetSchema((Option<String>)new Some((Object)"json"), (Option<String>)new Some((Object)src.getCanonicalPath()), (Option<StructType>)None$.MODULE$), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 426)));
        $this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.STREAMING_SCHEMA_INFERENCE().key()), (Object)"true")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            package$.MODULE$.stringToFile(new File(src, "1"), "{'c': '1'}\n{'c': '2'}\n{'c': '3'}");
            StructType schema = $this.createFileStreamSourceAndGetSchema((Option<String>)new Some((Object)"json"), (Option<String>)new Some((Object)src.getCanonicalPath()), (Option<StructType>)None$.MODULE$);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(schema);
            StructType $org_scalatest_assert_macro_right = new StructType().add("c", (DataType)StringType$.MODULE$);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 437));
        });
    }

    public static final /* synthetic */ void $anonfun$new$41(FileStreamSourceSuite $this, File src) {
        package$.MODULE$.stringToFile(new File(src, "1"), "{'c': '1'}\n{'c': '2'}\n{'c', '3'}");
        StructType userSchema = new StructType().add("userColumn", (DataType)StringType$.MODULE$);
        StructType schema = $this.createFileStreamSourceAndGetSchema((Option<String>)new Some((Object)"json"), (Option<String>)new Some((Object)src.getCanonicalPath()), (Option<StructType>)new Some((Object)userSchema));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(schema);
        StructType $org_scalatest_assert_macro_right = userSchema;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 448));
    }

    public static final /* synthetic */ void $anonfun$new$43(FileStreamSourceSuite $this, File x0$1, File x1$1) {
        Tuple2 tuple2 = new Tuple2((Object)x0$1, (Object)x1$1);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        File src = (File)tuple2._1();
        File tmp = (File)tuple2._2();
        Dataset<Row> textStream = $this.createFileStream("text", src.getCanonicalPath(), $this.createFileStream$default$3(), $this.createFileStream$default$4());
        Dataset filtered = textStream.filter($this.testImplicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value"}))).$((Seq)Nil$.MODULE$).contains((Object)"keep"));
        $this.testStream(filtered, $this.testStream$default$2(), (Seq<StreamTest.StreamAction>)Predef$.MODULE$.wrapRefArray((Object[])new StreamTest.StreamAction[]{new FileStreamSourceTest.AddTextFileData($this, "drop1\nkeep2\nkeep3", src, tmp, $this.AddTextFileData().apply$default$4()), $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"keep2", "keep3"}), $this.testImplicits().newStringEncoder()), $this.StopStream(), new FileStreamSourceTest.AddTextFileData($this, "drop4\nkeep5\nkeep6", src, tmp, $this.AddTextFileData().apply$default$4()), new StreamTest.StartStream($this, $this.StartStream().apply$default$1(), $this.StartStream().apply$default$2(), $this.StartStream().apply$default$3(), $this.StartStream().apply$default$4()), $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"keep2", "keep3", "keep5", "keep6"}), $this.testImplicits().newStringEncoder()), new FileStreamSourceTest.AddTextFileData($this, "drop7\nkeep8\nkeep9", src, tmp, $this.AddTextFileData().apply$default$4()), $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"keep2", "keep3", "keep5", "keep6", "keep8", "keep9"}), $this.testImplicits().newStringEncoder())}));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$new$45(FileStreamSourceSuite $this, File x0$2, File x1$2) {
        Tuple2 tuple2 = new Tuple2((Object)x0$2, (Object)x1$2);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        File src = (File)tuple2._1();
        File tmp = (File)tuple2._2();
        Dataset<Row> textStream = $this.createFileStream("text", src.getCanonicalPath(), $this.createFileStream$default$3(), $this.createFileStream$default$4());
        Dataset filtered = textStream.filter($this.testImplicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value"}))).$((Seq)Nil$.MODULE$).contains((Object)"keep"));
        $this.testStream(filtered, $this.testStream$default$2(), (Seq<StreamTest.StreamAction>)Predef$.MODULE$.wrapRefArray((Object[])new StreamTest.StreamAction[]{new FileStreamSourceTest.AddTextFileData($this, "drop1\nkeep2\nkeep3", src, tmp, "text text"), $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"keep2", "keep3"}), $this.testImplicits().newStringEncoder())}));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$new$48(FileStreamSourceSuite $this, String testTableName$1, File x0$3, File x1$3) {
        BoxedUnit boxedUnit;
        Tuple2 tuple2 = new Tuple2((Object)x0$3, (Object)x1$3);
        if (tuple2 != null) {
            File src = (File)tuple2._1();
            File checkpoint = (File)tuple2._2();
            File output = new File(src, "text text");
            MemoryStream inputData = MemoryStream$.MODULE$.apply($this.testImplicits().newStringEncoder(), $this.sqlContext());
            Dataset ds = inputData.toDS();
            StreamingQuery query = ds.writeStream().option("checkpointLocation", checkpoint.getCanonicalPath()).format("text").start(output.getCanonicalPath());
            try {
                inputData.addData((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo"}));
                $this.failAfter($this.streamingTimeout(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> query.processAllAvailable(), $this.defaultSignaler(), Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 499), Timed$.MODULE$.timed());
            }
            finally {
                query.stop();
            }
            Dataset df2 = $this.spark().readStream().format("text").load(output.getCanonicalPath());
            StreamingQuery query2 = df2.writeStream().format("memory").queryName(testTableName$1).start();
            try {
                query2.processAllAvailable();
                $this.checkDatasetUnorderly((Function0 & Serializable & scala.Serializable)() -> $this.spark().table(testTableName$1).as($this.testImplicits().newStringEncoder()), Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo"}), Ordering.String$.MODULE$);
                boxedUnit = BoxedUnit.UNIT;
            }
            finally {
                query2.stop();
            }
        }
        throw new MatchError((Object)tuple2);
        BoxedUnit boxedUnit2 = boxedUnit;
    }

    public static final /* synthetic */ void $anonfun$new$53(FileStreamSourceSuite $this, String testTableName$2, File output) {
        $this.testImplicits().localSeqToDatasetHolder((Seq)new .colon.colon((Object)"foo", (List)Nil$.MODULE$), $this.testImplicits().newStringEncoder()).toDS().write().text(output.getCanonicalPath());
        $this.testImplicits().localSeqToDatasetHolder((Seq)new .colon.colon((Object)"bar", (List)Nil$.MODULE$), $this.testImplicits().newStringEncoder()).toDS().write().mode("append").orc(output.getCanonicalPath());
        Dataset df = $this.spark().readStream().option("pathGlobFilter", "*.txt").format("text").load(output.getCanonicalPath());
        StreamingQuery query = df.writeStream().format("memory").queryName(testTableName$2).start();
        try {
            query.processAllAvailable();
            $this.checkDatasetUnorderly((Function0 & Serializable & scala.Serializable)() -> $this.spark().table(testTableName$2).as($this.testImplicits().newStringEncoder()), Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo"}), Ordering.String$.MODULE$);
        }
        finally {
            query.stop();
        }
    }

    public static final /* synthetic */ void $anonfun$new$56(FileStreamSourceSuite $this, File dir) {
        String path = dir.getCanonicalPath();
        String defaultFs = "nonexistFS://nonexistFS";
        String expectMessage = "No FileSystem for scheme nonexistFS";
        String message = ((Throwable)$this.intercept((Function0 & Serializable & scala.Serializable)() -> $this.spark().readStream().option("fs.defaultFS", defaultFs).text(path), ClassTag$.MODULE$.apply(IOException.class), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 542))).getMessage();
        Set set = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapCharArray(new char[]{':', '\"'}));
        String $org_scalatest_assert_macro_left = (String)new StringOps(Predef$.MODULE$.augmentString(message)).filterNot((Function1 & Serializable & scala.Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)set.contains((Object)BoxesRunTime.boxToCharacter((char)BoxesRunTime.unboxToChar((Object)elem)))));
        String $org_scalatest_assert_macro_right = expectMessage;
        String string = $org_scalatest_assert_macro_left;
        String string2 = $org_scalatest_assert_macro_right;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 545));
    }

    public static final /* synthetic */ void $anonfun$new$60(FileStreamSourceSuite $this, File x0$4, File x1$4) {
        Tuple2 tuple2 = new Tuple2((Object)x0$4, (Object)x1$4);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        File src = (File)tuple2._1();
        File tmp = (File)tuple2._2();
        Dataset textStream = $this.spark().readStream().textFile(src.getCanonicalPath());
        Dataset filtered = textStream.filter((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.contains("keep")));
        $this.testStream(filtered, $this.testStream$default$2(), (Seq<StreamTest.StreamAction>)Predef$.MODULE$.wrapRefArray((Object[])new StreamTest.StreamAction[]{new FileStreamSourceTest.AddTextFileData($this, "drop1\nkeep2\nkeep3", src, tmp, $this.AddTextFileData().apply$default$4()), $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"keep2", "keep3"}), $this.testImplicits().newStringEncoder()), $this.StopStream(), new FileStreamSourceTest.AddTextFileData($this, "drop4\nkeep5\nkeep6", src, tmp, $this.AddTextFileData().apply$default$4()), new StreamTest.StartStream($this, $this.StartStream().apply$default$1(), $this.StartStream().apply$default$2(), $this.StartStream().apply$default$3(), $this.StartStream().apply$default$4()), $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"keep2", "keep3", "keep5", "keep6"}), $this.testImplicits().newStringEncoder()), new FileStreamSourceTest.AddTextFileData($this, "drop7\nkeep8\nkeep9", src, tmp, $this.AddTextFileData().apply$default$4()), $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"keep2", "keep3", "keep5", "keep6", "keep8", "keep9"}), $this.testImplicits().newStringEncoder())}));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$new$64(StreamExecution x$4) {
        Thread.sleep(1000L);
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$new$65(FileStreamSourceSuite $this, StreamExecution streamExecution) {
        FileStreamSource source = (FileStreamSource)$this.getSourcesFromStreamingQuery(streamExecution).head();
        FileStreamSource.SeenFilesMap $org_scalatest_assert_macro_left = source.seenFiles();
        int $org_scalatest_assert_macro_right = 1;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 594));
        return true;
    }

    public static final /* synthetic */ void $anonfun$new$63(FileStreamSourceSuite $this, File x0$5, File x1$5) {
        Tuple2 tuple2 = new Tuple2((Object)x0$5, (Object)x1$5);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        File src = (File)tuple2._1();
        File tmp = (File)tuple2._2();
        String x$1 = "text";
        String x$2 = src.getCanonicalPath();
        Map x$3 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"maxFileAge"), (Object)"5ms")}));
        Option<StructType> x$42 = $this.createFileStream$default$3();
        Dataset<Row> textStream = $this.createFileStream(x$1, x$2, x$42, (Map<String, String>)x$3);
        $this.testStream(textStream, $this.testStream$default$2(), (Seq<StreamTest.StreamAction>)Predef$.MODULE$.wrapRefArray((Object[])new StreamTest.StreamAction[]{new FileStreamSourceTest.AddTextFileData($this, "a\nb", src, tmp, $this.AddTextFileData().apply$default$4()), $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b"}), $this.testImplicits().newStringEncoder()), $this.AssertOnQuery().apply((Function1<StreamExecution, Object>)(Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)FileStreamSourceSuite.$anonfun$new$64(x$4)), $this.AssertOnQuery().apply$default$2()), new FileStreamSourceTest.AddTextFileData($this, "c\nd", src, tmp, $this.AddTextFileData().apply$default$4()), $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b", "c", "d"}), $this.testImplicits().newStringEncoder()), $this.AssertOnQuery().apply("seen files should contain only one entry", (Function1<StreamExecution, Object>)(Function1 & Serializable & scala.Serializable)streamExecution -> BoxesRunTime.boxToBoolean((boolean)FileStreamSourceSuite.$anonfun$new$65($this, streamExecution)))}));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$new$67(FileStreamSourceSuite $this, File x0$6, File x1$6) {
        Tuple2 tuple2 = new Tuple2((Object)x0$6, (Object)x1$6);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        File src = (File)tuple2._1();
        File tmp = (File)tuple2._2();
        Dataset<Row> fileStream = $this.createFileStream("json", src.getCanonicalPath(), (Option<StructType>)new Some((Object)$this.valueSchema()), $this.createFileStream$default$4());
        Dataset filtered = fileStream.filter($this.testImplicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value"}))).$((Seq)Nil$.MODULE$).contains((Object)"keep"));
        $this.testStream(filtered, $this.testStream$default$2(), (Seq<StreamTest.StreamAction>)Predef$.MODULE$.wrapRefArray((Object[])new StreamTest.StreamAction[]{new FileStreamSourceTest.AddTextFileData($this, "{'value': 'drop1'}\n{'value': 'keep2'}\n{'value': 'keep3'}", src, tmp, $this.AddTextFileData().apply$default$4()), $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"keep2", "keep3"}), $this.testImplicits().newStringEncoder()), $this.StopStream(), new FileStreamSourceTest.AddTextFileData($this, "{'value': 'drop4'}\n{'value': 'keep5'}\n{'value': 'keep6'}", src, tmp, $this.AddTextFileData().apply$default$4()), new StreamTest.StartStream($this, $this.StartStream().apply$default$1(), $this.StartStream().apply$default$2(), $this.StartStream().apply$default$3(), $this.StartStream().apply$default$4()), $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"keep2", "keep3", "keep5", "keep6"}), $this.testImplicits().newStringEncoder()), new FileStreamSourceTest.AddTextFileData($this, "{'value': 'drop7'}\n{'value': 'keep8'}\n{'value': 'keep9'}", src, tmp, $this.AddTextFileData().apply$default$4()), $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"keep2", "keep3", "keep5", "keep6", "keep8", "keep9"}), $this.testImplicits().newStringEncoder())}));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$new$69(FileStreamSourceSuite $this, File x0$7, File x1$7) {
        Tuple2 tuple2 = new Tuple2((Object)x0$7, (Object)x1$7);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        File src = (File)tuple2._1();
        File tmp = (File)tuple2._2();
        $this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.STREAMING_SCHEMA_INFERENCE().key()), (Object)"true")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            package$.MODULE$.stringToFile(new File(src, "existing"), "{'c': 'drop1'}\n{'c': 'keep2'}\n{'c': 'keep3'}");
            Dataset<Row> fileStream = $this.createFileStream("json", src.getCanonicalPath(), $this.createFileStream$default$3(), $this.createFileStream$default$4());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(fileStream.schema());
            StructType $org_scalatest_assert_macro_right = StructType$.MODULE$.apply((Seq)new .colon.colon((Object)new StructField("c", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 638));
            Dataset filtered = fileStream.filter($this.testImplicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"c"}))).$((Seq)Nil$.MODULE$).contains((Object)"keep"));
            $this.testStream(filtered, $this.testStream$default$2(), (Seq<StreamTest.StreamAction>)Predef$.MODULE$.wrapRefArray((Object[])new StreamTest.StreamAction[]{new FileStreamSourceTest.AddTextFileData($this, "{'c': 'drop4'}\n{'c': 'keep5'}\n{'c': 'keep6'}", src, tmp, $this.AddTextFileData().apply$default$4()), $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"keep2", "keep3", "keep5", "keep6"}), $this.testImplicits().newStringEncoder())}));
        });
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$new$72(FileStreamSourceSuite $this, File x0$8, File x1$8) {
        Tuple2 tuple2 = new Tuple2((Object)x0$8, (Object)x1$8);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        File baseSrc = (File)tuple2._1();
        File tmp = (File)tuple2._2();
        $this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.STREAMING_SCHEMA_INFERENCE().key()), (Object)"true")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            File src = new File(baseSrc, "type=X");
            src.mkdirs();
            package$.MODULE$.stringToFile(new File(src, "existing"), "{'c': 'drop1'}\n{'c': 'keep2'}\n{'c': 'keep3'}");
            Dataset<Row> fileStream = $this.createFileStream("json", src.getCanonicalPath(), $this.createFileStream$default$3(), $this.createFileStream$default$4());
            Dataset filtered = fileStream.filter($this.testImplicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"c"}))).$((Seq)Nil$.MODULE$).contains((Object)"keep"));
            $this.testStream(filtered, $this.testStream$default$2(), (Seq<StreamTest.StreamAction>)Predef$.MODULE$.wrapRefArray((Object[])new StreamTest.StreamAction[]{new FileStreamSourceTest.AddTextFileData($this, "{'c': 'drop4'}\n{'c': 'keep5'}\n{'c': 'keep6'}", src, tmp, $this.AddTextFileData().apply$default$4()), $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"keep2", "keep3", "keep5", "keep6"}), $this.testImplicits().newStringEncoder())}));
        });
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$new$75(FileStreamSourceSuite $this, File x0$9, File x1$9) {
        Tuple2 tuple2 = new Tuple2((Object)x0$9, (Object)x1$9);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        File src = (File)tuple2._1();
        File tmp = (File)tuple2._2();
        $this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.STREAMING_SCHEMA_INFERENCE().key()), (Object)"true")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            package$.MODULE$.stringToFile(new File(src, "existing"), "{'k': 'value0'}");
            Dataset<Row> fileStream = $this.createFileStream("json", src.getCanonicalPath(), $this.createFileStream$default$3(), $this.createFileStream$default$4());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(fileStream.schema());
            StructType $org_scalatest_assert_macro_right = StructType$.MODULE$.apply((Seq)new .colon.colon((Object)new StructField("k", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 683));
            package$.MODULE$.stringToFile(new File(src, "existing2"), "{'k': 'value1', 'v': 'new'}");
            $this.testStream(fileStream, $this.testStream$default$2(), (Seq<StreamTest.StreamAction>)Predef$.MODULE$.wrapRefArray((Object[])new StreamTest.StreamAction[]{new FileStreamSourceTest.AddTextFileData($this, "{'k': 'value2'}", src, tmp, $this.AddTextFileData().apply$default$4()), $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value0", "value1", "value2"}), $this.testImplicits().newStringEncoder()), new FileStreamSourceTest.AddTextFileData($this, "{'k': 'value3', 'v': 'new'}", src, tmp, $this.AddTextFileData().apply$default$4()), $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value0", "value1", "value2", "value3"}), $this.testImplicits().newStringEncoder()), new FileStreamSourceTest.AddTextFileData($this, "{'v': 'value4'}", src, tmp, $this.AddTextFileData().apply$default$4()), $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value0", "value1", "value2", "value3", null}), $this.testImplicits().newStringEncoder())}));
        });
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$new$78(FileStreamSourceSuite $this, File x0$10, File x1$10) {
        Tuple2 tuple2 = new Tuple2((Object)x0$10, (Object)x1$10);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        File src = (File)tuple2._1();
        File tmp = (File)tuple2._2();
        Dataset<Row> fileStream = $this.createFileStream("orc", src.getCanonicalPath(), (Option<StructType>)new Some((Object)$this.valueSchema()), $this.createFileStream$default$4());
        Dataset filtered = fileStream.filter($this.testImplicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value"}))).$((Seq)Nil$.MODULE$).contains((Object)"keep"));
        $this.testStream(filtered, $this.testStream$default$2(), (Seq<StreamTest.StreamAction>)Predef$.MODULE$.wrapRefArray((Object[])new StreamTest.StreamAction[]{$this.AddOrcFileData().apply((Seq<String>)((Seq)new .colon.colon((Object)"drop1", (List)new .colon.colon((Object)"keep2", (List)new .colon.colon((Object)"keep3", (List)Nil$.MODULE$)))), src, tmp), $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"keep2", "keep3"}), $this.testImplicits().newStringEncoder()), $this.StopStream(), $this.AddOrcFileData().apply((Seq<String>)((Seq)new .colon.colon((Object)"drop4", (List)new .colon.colon((Object)"keep5", (List)new .colon.colon((Object)"keep6", (List)Nil$.MODULE$)))), src, tmp), new StreamTest.StartStream($this, $this.StartStream().apply$default$1(), $this.StartStream().apply$default$2(), $this.StartStream().apply$default$3(), $this.StartStream().apply$default$4()), $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"keep2", "keep3", "keep5", "keep6"}), $this.testImplicits().newStringEncoder()), $this.AddOrcFileData().apply((Seq<String>)((Seq)new .colon.colon((Object)"drop7", (List)new .colon.colon((Object)"keep8", (List)new .colon.colon((Object)"keep9", (List)Nil$.MODULE$)))), src, tmp), $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"keep2", "keep3", "keep5", "keep6", "keep8", "keep9"}), $this.testImplicits().newStringEncoder())}));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$new$80(FileStreamSourceSuite $this, File x0$11, File x1$11) {
        Tuple2 tuple2 = new Tuple2((Object)x0$11, (Object)x1$11);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        File src = (File)tuple2._1();
        File tmp = (File)tuple2._2();
        $this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.STREAMING_SCHEMA_INFERENCE().key()), (Object)"true")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            $this.AddOrcFileData().writeToFile((Dataset<Row>)$this.testImplicits().localSeqToDatasetHolder((Seq)new .colon.colon((Object)"value0", (List)Nil$.MODULE$), $this.testImplicits().newStringEncoder()).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"k"})), src, tmp);
            Dataset<Row> fileStream = $this.createFileStream("orc", src.getCanonicalPath(), $this.createFileStream$default$3(), $this.createFileStream$default$4());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(fileStream.schema());
            StructType $org_scalatest_assert_macro_right = StructType$.MODULE$.apply((Seq)new .colon.colon((Object)new StructField("k", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 736));
            JavaUniverse $u = scala.reflect.runtime.package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(FileStreamSourceSuite.class.getClassLoader());
            public final class Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator154$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
                }

                public Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator154$1(FileStreamSourceSuite $outer) {
                }
            }
            $this.AddOrcFileData().writeToFile((Dataset<Row>)$this.testImplicits().localSeqToDatasetHolder((Seq)new .colon.colon((Object)new Tuple2((Object)"value1", (Object)BoxesRunTime.boxToInteger((int)0)), (List)Nil$.MODULE$), $this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator154$1(null)))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"k", "v"})), src, tmp);
            StreamTest.StreamAction[] streamActionArray = new StreamTest.StreamAction[6];
            streamActionArray[0] = new FileStreamSourceTest.AddOrcFileData($this, (Dataset<Row>)$this.testImplicits().localSeqToDatasetHolder((Seq)new .colon.colon((Object)"value2", (List)Nil$.MODULE$), $this.testImplicits().newStringEncoder()).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"k"})), src, tmp);
            streamActionArray[1] = $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value0", "value1", "value2"}), $this.testImplicits().newStringEncoder());
            JavaUniverse $u2 = scala.reflect.runtime.package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m2 = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(FileStreamSourceSuite.class.getClassLoader());
            public final class Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator176$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
                }

                public Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator176$1(FileStreamSourceSuite $outer) {
                }
            }
            streamActionArray[2] = new FileStreamSourceTest.AddOrcFileData($this, (Dataset<Row>)$this.testImplicits().localSeqToDatasetHolder((Seq)new .colon.colon((Object)new Tuple2((Object)"value3", (Object)BoxesRunTime.boxToInteger((int)1)), (List)Nil$.MODULE$), $this.testImplicits().newProductEncoder(((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator176$1(null)))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"k", "v"})), src, tmp);
            streamActionArray[3] = $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value0", "value1", "value2", "value3"}), $this.testImplicits().newStringEncoder());
            streamActionArray[4] = new FileStreamSourceTest.AddOrcFileData($this, (Dataset<Row>)$this.testImplicits().localSeqToDatasetHolder((Seq)new .colon.colon((Object)"value5", (List)Nil$.MODULE$), $this.testImplicits().newStringEncoder()).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"v"})), src, tmp);
            streamActionArray[5] = $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value0", "value1", "value2", "value3", null}), $this.testImplicits().newStringEncoder());
            $this.testStream(fileStream, $this.testStream$default$2(), (Seq<StreamTest.StreamAction>)Predef$.MODULE$.wrapRefArray((Object[])streamActionArray));
        });
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$new$83(FileStreamSourceSuite $this, File x0$12, File x1$12) {
        Tuple2 tuple2 = new Tuple2((Object)x0$12, (Object)x1$12);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        File src = (File)tuple2._1();
        File tmp = (File)tuple2._2();
        Dataset<Row> fileStream = $this.createFileStream("parquet", src.getCanonicalPath(), (Option<StructType>)new Some((Object)$this.valueSchema()), $this.createFileStream$default$4());
        Dataset filtered = fileStream.filter($this.testImplicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value"}))).$((Seq)Nil$.MODULE$).contains((Object)"keep"));
        $this.testStream(filtered, $this.testStream$default$2(), (Seq<StreamTest.StreamAction>)Predef$.MODULE$.wrapRefArray((Object[])new StreamTest.StreamAction[]{$this.AddParquetFileData().apply((Seq<String>)((Seq)new .colon.colon((Object)"drop1", (List)new .colon.colon((Object)"keep2", (List)new .colon.colon((Object)"keep3", (List)Nil$.MODULE$)))), src, tmp), $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"keep2", "keep3"}), $this.testImplicits().newStringEncoder()), $this.StopStream(), $this.AddParquetFileData().apply((Seq<String>)((Seq)new .colon.colon((Object)"drop4", (List)new .colon.colon((Object)"keep5", (List)new .colon.colon((Object)"keep6", (List)Nil$.MODULE$)))), src, tmp), new StreamTest.StartStream($this, $this.StartStream().apply$default$1(), $this.StartStream().apply$default$2(), $this.StartStream().apply$default$3(), $this.StartStream().apply$default$4()), $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"keep2", "keep3", "keep5", "keep6"}), $this.testImplicits().newStringEncoder()), $this.AddParquetFileData().apply((Seq<String>)((Seq)new .colon.colon((Object)"drop7", (List)new .colon.colon((Object)"keep8", (List)new .colon.colon((Object)"keep9", (List)Nil$.MODULE$)))), src, tmp), $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"keep2", "keep3", "keep5", "keep6", "keep8", "keep9"}), $this.testImplicits().newStringEncoder())}));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$new$85(FileStreamSourceSuite $this, File x0$13, File x1$13) {
        Tuple2 tuple2 = new Tuple2((Object)x0$13, (Object)x1$13);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        File src = (File)tuple2._1();
        File tmp = (File)tuple2._2();
        $this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.STREAMING_SCHEMA_INFERENCE().key()), (Object)"true")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            $this.AddParquetFileData().writeToFile((Dataset<Row>)$this.testImplicits().localSeqToDatasetHolder((Seq)new .colon.colon((Object)"value0", (List)Nil$.MODULE$), $this.testImplicits().newStringEncoder()).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"k"})), src, tmp);
            Dataset<Row> fileStream = $this.createFileStream("parquet", src.getCanonicalPath(), $this.createFileStream$default$3(), $this.createFileStream$default$4());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(fileStream.schema());
            StructType $org_scalatest_assert_macro_right = StructType$.MODULE$.apply((Seq)new .colon.colon((Object)new StructField("k", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 790));
            JavaUniverse $u = scala.reflect.runtime.package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(FileStreamSourceSuite.class.getClassLoader());
            public final class Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator222$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
                }

                public Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator222$1(FileStreamSourceSuite $outer) {
                }
            }
            $this.AddParquetFileData().writeToFile((Dataset<Row>)$this.testImplicits().localSeqToDatasetHolder((Seq)new .colon.colon((Object)new Tuple2((Object)"value1", (Object)BoxesRunTime.boxToInteger((int)0)), (List)Nil$.MODULE$), $this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator222$1(null)))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"k", "v"})), src, tmp);
            StreamTest.StreamAction[] streamActionArray = new StreamTest.StreamAction[6];
            streamActionArray[0] = new FileStreamSourceTest.AddParquetFileData($this, (Dataset<Row>)$this.testImplicits().localSeqToDatasetHolder((Seq)new .colon.colon((Object)"value2", (List)Nil$.MODULE$), $this.testImplicits().newStringEncoder()).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"k"})), src, tmp);
            streamActionArray[1] = $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value0", "value1", "value2"}), $this.testImplicits().newStringEncoder());
            JavaUniverse $u2 = scala.reflect.runtime.package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m2 = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(FileStreamSourceSuite.class.getClassLoader());
            public final class Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator244$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
                }

                public Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator244$1(FileStreamSourceSuite $outer) {
                }
            }
            streamActionArray[2] = new FileStreamSourceTest.AddParquetFileData($this, (Dataset<Row>)$this.testImplicits().localSeqToDatasetHolder((Seq)new .colon.colon((Object)new Tuple2((Object)"value3", (Object)BoxesRunTime.boxToInteger((int)1)), (List)Nil$.MODULE$), $this.testImplicits().newProductEncoder(((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator244$1(null)))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"k", "v"})), src, tmp);
            streamActionArray[3] = $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value0", "value1", "value2", "value3"}), $this.testImplicits().newStringEncoder());
            streamActionArray[4] = new FileStreamSourceTest.AddParquetFileData($this, (Dataset<Row>)$this.testImplicits().localSeqToDatasetHolder((Seq)new .colon.colon((Object)"value5", (List)Nil$.MODULE$), $this.testImplicits().newStringEncoder()).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"v"})), src, tmp);
            streamActionArray[5] = $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value0", "value1", "value2", "value3", null}), $this.testImplicits().newStringEncoder());
            $this.testStream(fileStream, $this.testStream$default$2(), (Seq<StreamTest.StreamAction>)Predef$.MODULE$.wrapRefArray((Object[])streamActionArray));
        });
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$new$88(FileStreamSourceSuite $this, File x0$14, File x1$14) {
        Tuple2 tuple2 = new Tuple2((Object)x0$14, (Object)x1$14);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        File dir = (File)tuple2._1();
        File tmp = (File)tuple2._2();
        Dataset<Row> fileStream = $this.createFileStream("text", new StringBuilder(4).append(dir.getCanonicalPath()).append("/*/*").toString(), $this.createFileStream$default$3(), $this.createFileStream$default$4());
        Dataset filtered = fileStream.filter($this.testImplicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value"}))).$((Seq)Nil$.MODULE$).contains((Object)"keep"));
        File subDir = new File(dir, "subdir");
        File subSubDir = new File(subDir, "subsubdir");
        File subSubSubDir = new File(subSubDir, "subsubsubdir");
        Predef$.MODULE$.require(!subDir.exists());
        Predef$.MODULE$.require(!subSubDir.exists());
        $this.testStream(filtered, $this.testStream$default$2(), (Seq<StreamTest.StreamAction>)Predef$.MODULE$.wrapRefArray((Object[])new StreamTest.StreamAction[]{new FileStreamSourceTest.AddTextFileData($this, "drop1\nkeep2", subDir, tmp, $this.AddTextFileData().apply$default$4()), $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"keep2"}), $this.testImplicits().newStringEncoder()), new FileStreamSourceTest.AddTextFileData($this, "keep3", subDir, tmp, $this.AddTextFileData().apply$default$4()), $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"keep2", "keep3"}), $this.testImplicits().newStringEncoder()), new FileStreamSourceTest.AddTextFileData($this, "keep4", subSubDir, tmp, $this.AddTextFileData().apply$default$4()), $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"keep2", "keep3", "keep4"}), $this.testImplicits().newStringEncoder()), new FileStreamSourceTest.AddTextFileData($this, "keep5", subSubDir, tmp, $this.AddTextFileData().apply$default$4()), $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"keep2", "keep3", "keep4", "keep5"}), $this.testImplicits().newStringEncoder()), new FileStreamSourceTest.AddTextFileData($this, "keep6", dir, tmp, $this.AddTextFileData().apply$default$4()), new FileStreamSourceTest.AddTextFileData($this, "keep7", subSubSubDir, tmp, $this.AddTextFileData().apply$default$4()), new FileStreamSourceTest.AddTextFileData($this, "keep8", subDir, tmp, $this.AddTextFileData().apply$default$4()), $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"keep2", "keep3", "keep4", "keep5", "keep8"}), $this.testImplicits().newStringEncoder())}));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$new$90(FileStreamSourceSuite $this, File x0$15, File x1$15) {
        Tuple2 tuple2 = new Tuple2((Object)x0$15, (Object)x1$15);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        File dir = (File)tuple2._1();
        File tmp = (File)tuple2._2();
        File partitionFooSubDir = new File(dir, "partition=foo");
        File partitionBarSubDir = new File(dir, "partition=bar");
        StructType schema = new StructType().add("value", (DataType)StringType$.MODULE$).add("partition", (DataType)StringType$.MODULE$);
        Dataset<Row> fileStream = $this.createFileStream("json", new StringBuilder(4).append(dir.getCanonicalPath()).append("/*/*").toString(), (Option<StructType>)new Some((Object)schema), $this.createFileStream$default$4());
        Dataset filtered = fileStream.filter($this.testImplicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value"}))).$((Seq)Nil$.MODULE$).contains((Object)"keep"));
        Object nullStr = null;
        StreamTest.StreamAction[] streamActionArray = new StreamTest.StreamAction[8];
        streamActionArray[0] = new FileStreamSourceTest.AddTextFileData($this, "{'value': 'drop1'}\n{'value': 'keep2'}", partitionFooSubDir, tmp, $this.AddTextFileData().apply$default$4());
        JavaUniverse $u = scala.reflect.runtime.package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(FileStreamSourceSuite.class.getClassLoader());
        public final class Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator285$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$), (List)Nil$.MODULE$)));
            }

            public Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator285$1(FileStreamSourceSuite $outer) {
            }
        }
        streamActionArray[1] = $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"keep2", nullStr)}), $this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator285$1(null))));
        streamActionArray[2] = new FileStreamSourceTest.AddTextFileData($this, "{'value': 'keep3'}", partitionFooSubDir, tmp, $this.AddTextFileData().apply$default$4());
        JavaUniverse $u2 = scala.reflect.runtime.package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m2 = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(FileStreamSourceSuite.class.getClassLoader());
        public final class Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator290$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
            }

            public Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator290$1(FileStreamSourceSuite $outer) {
            }
        }
        streamActionArray[3] = $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"keep2", nullStr), new Tuple2((Object)"keep3", nullStr)}), $this.testImplicits().newProductEncoder(((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator290$1(null))));
        streamActionArray[4] = new FileStreamSourceTest.AddTextFileData($this, "{'value': 'keep4'}", partitionBarSubDir, tmp, $this.AddTextFileData().apply$default$4());
        JavaUniverse $u3 = scala.reflect.runtime.package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m3 = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(FileStreamSourceSuite.class.getClassLoader());
        public final class Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator295$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
            }

            public Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator295$1(FileStreamSourceSuite $outer) {
            }
        }
        streamActionArray[5] = $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"keep2", nullStr), new Tuple2((Object)"keep3", nullStr), new Tuple2((Object)"keep4", nullStr)}), $this.testImplicits().newProductEncoder(((TypeTags)$u3).TypeTag().apply((Mirror)$m3, (TypeCreator)new Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator295$1(null))));
        streamActionArray[6] = new FileStreamSourceTest.AddTextFileData($this, "{'value': 'keep5'}", partitionBarSubDir, tmp, $this.AddTextFileData().apply$default$4());
        JavaUniverse $u4 = scala.reflect.runtime.package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m4 = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(FileStreamSourceSuite.class.getClassLoader());
        public final class Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator300$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
            }

            public Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator300$1(FileStreamSourceSuite $outer) {
            }
        }
        streamActionArray[7] = $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"keep2", nullStr), new Tuple2((Object)"keep3", nullStr), new Tuple2((Object)"keep4", nullStr), new Tuple2((Object)"keep5", nullStr)}), $this.testImplicits().newProductEncoder(((TypeTags)$u4).TypeTag().apply((Mirror)$m4, (TypeCreator)new Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator300$1(null))));
        $this.testStream(filtered, $this.testStream$default$2(), (Seq<StreamTest.StreamAction>)Predef$.MODULE$.wrapRefArray((Object[])streamActionArray));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$new$92(FileStreamSourceSuite $this, File x0$16, File x1$16) {
        Tuple2 tuple2 = new Tuple2((Object)x0$16, (Object)x1$16);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        File dir = (File)tuple2._1();
        File tmp = (File)tuple2._2();
        File partitionFooSubDir = new File(dir, "partition=foo");
        File partitionBarSubDir = new File(dir, "partition=bar");
        StructType schema = new StructType().add("value", (DataType)StringType$.MODULE$).add("partition", (DataType)StringType$.MODULE$);
        Dataset<Row> fileStream = $this.createFileStream("json", String.valueOf(dir.getCanonicalPath()), (Option<StructType>)new Some((Object)schema), $this.createFileStream$default$4());
        Dataset filtered = fileStream.filter($this.testImplicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value"}))).$((Seq)Nil$.MODULE$).contains((Object)"keep"));
        StreamTest.StreamAction[] streamActionArray = new StreamTest.StreamAction[8];
        streamActionArray[0] = new FileStreamSourceTest.AddTextFileData($this, "{'value': 'drop1'}\n{'value': 'keep2'}", partitionFooSubDir, tmp, $this.AddTextFileData().apply$default$4());
        JavaUniverse $u = scala.reflect.runtime.package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(FileStreamSourceSuite.class.getClassLoader());
        public final class Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator305$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
            }

            public Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator305$1(FileStreamSourceSuite $outer) {
            }
        }
        streamActionArray[1] = $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"keep2", (Object)"foo")}), $this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator305$1(null))));
        streamActionArray[2] = new FileStreamSourceTest.AddTextFileData($this, "{'value': 'keep3'}", partitionFooSubDir, tmp, $this.AddTextFileData().apply$default$4());
        JavaUniverse $u2 = scala.reflect.runtime.package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m2 = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(FileStreamSourceSuite.class.getClassLoader());
        public final class Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator310$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
            }

            public Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator310$1(FileStreamSourceSuite $outer) {
            }
        }
        streamActionArray[3] = $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"keep2", (Object)"foo"), new Tuple2((Object)"keep3", (Object)"foo")}), $this.testImplicits().newProductEncoder(((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator310$1(null))));
        streamActionArray[4] = new FileStreamSourceTest.AddTextFileData($this, "{'value': 'keep4'}", partitionBarSubDir, tmp, $this.AddTextFileData().apply$default$4());
        JavaUniverse $u3 = scala.reflect.runtime.package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m3 = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(FileStreamSourceSuite.class.getClassLoader());
        public final class Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator315$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
            }

            public Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator315$1(FileStreamSourceSuite $outer) {
            }
        }
        streamActionArray[5] = $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"keep2", (Object)"foo"), new Tuple2((Object)"keep3", (Object)"foo"), new Tuple2((Object)"keep4", (Object)"bar")}), $this.testImplicits().newProductEncoder(((TypeTags)$u3).TypeTag().apply((Mirror)$m3, (TypeCreator)new Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator315$1(null))));
        streamActionArray[6] = new FileStreamSourceTest.AddTextFileData($this, "{'value': 'keep5'}", partitionBarSubDir, tmp, $this.AddTextFileData().apply$default$4());
        JavaUniverse $u4 = scala.reflect.runtime.package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m4 = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(FileStreamSourceSuite.class.getClassLoader());
        public final class Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator320$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
            }

            public Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator320$1(FileStreamSourceSuite $outer) {
            }
        }
        streamActionArray[7] = $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"keep2", (Object)"foo"), new Tuple2((Object)"keep3", (Object)"foo"), new Tuple2((Object)"keep4", (Object)"bar"), new Tuple2((Object)"keep5", (Object)"bar")}), $this.testImplicits().newProductEncoder(((TypeTags)$u4).TypeTag().apply((Mirror)$m4, (TypeCreator)new Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator320$1(null))));
        $this.testStream(filtered, $this.testStream$default$2(), (Seq<StreamTest.StreamAction>)Predef$.MODULE$.wrapRefArray((Object[])streamActionArray));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$new$96(MemoryStream q1Source$1, Seq data$1, StreamingQuery q1$1, StreamExecution x$5) {
        q1Source$1.addData((TraversableOnce)data$1);
        q1$1.processAllAvailable();
    }

    private final StreamTest.StreamAction q1AddData$1(Seq data, MemoryStream q1Source$1, StreamingQuery q1$1) {
        return this.Execute().apply((Function1<StreamExecution, Object>)(Function1 & Serializable & scala.Serializable)x$5 -> {
            FileStreamSourceSuite.$anonfun$new$96(q1Source$1, data, q1$1, x$5);
            return BoxedUnit.UNIT;
        });
    }

    private final StreamTest.StreamAction q2ProcessAllAvailable$1() {
        return this.Execute().apply((Function1<StreamExecution, Object>)(Function1 & Serializable & scala.Serializable)q2 -> {
            q2.processAllAvailable();
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$new$95(FileStreamSourceSuite $this, File x0$17, File x1$17) {
        Tuple2 tuple2 = new Tuple2((Object)x0$17, (Object)x1$17);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        File outputDir = (File)tuple2._1();
        File checkpointDir = (File)tuple2._2();
        MemoryStream q1Source = MemoryStream$.MODULE$.apply($this.testImplicits().newStringEncoder(), $this.sqlContext());
        StreamingQuery q1 = q1Source.toDF().writeStream().option("checkpointLocation", checkpointDir.getCanonicalPath()).format("text").start(outputDir.getCanonicalPath());
        Dataset q2 = $this.createFileStream("text", outputDir.getCanonicalPath(), $this.createFileStream$default$3(), $this.createFileStream$default$4()).filter($this.testImplicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value"}))).$((Seq)Nil$.MODULE$).contains((Object)"keep"));
        $this.testStream(q2, $this.testStream$default$2(), (Seq<StreamTest.StreamAction>)Predef$.MODULE$.wrapRefArray((Object[])new StreamTest.StreamAction[]{$this.q1AddData$1((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"drop1", "keep2"}), q1Source, q1), $this.q2ProcessAllAvailable$1(), $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"keep2"}), $this.testImplicits().newStringEncoder()), $this.Assert().apply((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            File shouldNotKeep = new File(outputDir, "should_not_keep.txt");
            package$.MODULE$.stringToFile(shouldNotKeep, "should_not_keep!!!");
            return shouldNotKeep.exists();
        }, $this.Assert().apply$default$2()), $this.q1AddData$1((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"keep3"}), q1Source, q1), $this.q2ProcessAllAvailable$1(), $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"keep2", "keep3"}), $this.testImplicits().newStringEncoder()), $this.q1AddData$1((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"keep4"}), q1Source, q1), $this.Assert().apply((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> new File(outputDir, new StringBuilder(10).append(FileStreamSink$.MODULE$.metadataDir()).append("/2.compact").toString()).exists(), $this.Assert().apply$default$2()), $this.q2ProcessAllAvailable$1(), $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"keep2", "keep3", "keep4"}), $this.testImplicits().newStringEncoder()), $this.Execute().apply((Function1<StreamExecution, Object>)(Function1 & Serializable & scala.Serializable)x$6 -> {
            q1.stop();
            return BoxedUnit.UNIT;
        })}));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$new$105(MemoryStream q1Source$2, Seq data$2, StreamingQuery q1$2, StreamExecution x$7) {
        q1Source$2.addData((TraversableOnce)data$2);
        q1$2.processAllAvailable();
    }

    private final StreamTest.StreamAction q1AddData$2(Seq data, MemoryStream q1Source$2, StreamingQuery q1$2) {
        return this.Execute().apply((Function1<StreamExecution, Object>)(Function1 & Serializable & scala.Serializable)x$7 -> {
            FileStreamSourceSuite.$anonfun$new$105(q1Source$2, data, q1$2, x$7);
            return BoxedUnit.UNIT;
        });
    }

    private final StreamTest.StreamAction q2ProcessAllAvailable$2() {
        return this.Execute().apply((Function1<StreamExecution, Object>)(Function1 & Serializable & scala.Serializable)q2 -> {
            q2.processAllAvailable();
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$new$104(FileStreamSourceSuite $this, File outputDir$2, File checkpointDir2) {
        MemoryStream q1Source = MemoryStream$.MODULE$.apply($this.testImplicits().newStringEncoder(), $this.sqlContext());
        StreamingQuery q1 = q1Source.toDF().writeStream().option("checkpointLocation", checkpointDir2.getCanonicalPath()).format("text").start(outputDir$2.getCanonicalPath());
        Dataset q2 = $this.createFileStream("text", outputDir$2.getCanonicalPath(), $this.createFileStream$default$3(), $this.createFileStream$default$4()).filter($this.testImplicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value"}))).$((Seq)Nil$.MODULE$).contains((Object)"keep"));
        $this.testStream(q2, $this.testStream$default$2(), (Seq<StreamTest.StreamAction>)Predef$.MODULE$.wrapRefArray((Object[])new StreamTest.StreamAction[]{$this.q1AddData$2((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"drop1", "keep2"}), q1Source, q1), $this.q2ProcessAllAvailable$2(), $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"keep0", "keep2"}), $this.testImplicits().newStringEncoder()), $this.q1AddData$2((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"keep3"}), q1Source, q1), $this.q2ProcessAllAvailable$2(), $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"keep0", "keep2", "keep3"}), $this.testImplicits().newStringEncoder()), $this.q1AddData$2((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"keep4"}), q1Source, q1), $this.Assert().apply((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> new File(outputDir$2, new StringBuilder(10).append(FileStreamSink$.MODULE$.metadataDir()).append("/2.compact").toString()).exists(), $this.Assert().apply$default$2()), $this.q2ProcessAllAvailable$2(), $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"keep0", "keep2", "keep3", "keep4"}), $this.testImplicits().newStringEncoder()), $this.Execute().apply((Function1<StreamExecution, Object>)(Function1 & Serializable & scala.Serializable)x$8 -> {
            q1.stop();
            return BoxedUnit.UNIT;
        })}));
    }

    public static final /* synthetic */ void $anonfun$new$103(FileStreamSourceSuite $this, File x0$18, File x1$18) {
        Tuple2 tuple2 = new Tuple2((Object)x0$18, (Object)x1$18);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        File outputDir = (File)tuple2._1();
        File checkpointDir1 = (File)tuple2._2();
        MemoryStream q0Source = MemoryStream$.MODULE$.apply($this.testImplicits().newStringEncoder(), $this.sqlContext());
        StreamingQuery q0 = q0Source.toDF().writeStream().option("checkpointLocation", checkpointDir1.getCanonicalPath()).format("text").start(outputDir.getCanonicalPath());
        q0Source.addData((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"keep0"}));
        q0.processAllAvailable();
        q0.stop();
        Utils$.MODULE$.deleteRecursively(new File(new StringBuilder(1).append(outputDir.getCanonicalPath()).append("/").append(FileStreamSink$.MODULE$.metadataDir()).toString()));
        $this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)checkpointDir2 -> {
            FileStreamSourceSuite.$anonfun$new$104($this, outputDir, checkpointDir2);
            return BoxedUnit.UNIT;
        });
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$new$111(FileStreamSourceSuite $this, StreamExecution q2) {
        FileStreamSource fileSource = (FileStreamSource)$this.getSourcesFromStreamingQuery(q2).head();
        return $this.convertToEqualizer(fileSource.sourceHasMetadata()).$eq$eq$eq((Object)None$.MODULE$, Equality$.MODULE$.default());
    }

    public static final /* synthetic */ void $anonfun$new$112(ObjectRef q1$3, DataStreamWriter q1Write$1, File outputDir$3, MemoryStream q1Source$3, StreamExecution x$9) {
        q1$3.elem = q1Write$1.start(outputDir$3.getCanonicalPath());
        q1Source$3.addData((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"drop1", "keep2"}));
        ((StreamingQuery)q1$3.elem).processAllAvailable();
    }

    public static final /* synthetic */ boolean $anonfun$new$113(FileStreamSourceSuite $this, StreamExecution q2) {
        q2.processAllAvailable();
        FileStreamSource fileSource = (FileStreamSource)$this.getSourcesFromStreamingQuery(q2).head();
        return $this.convertToEqualizer(fileSource.sourceHasMetadata()).$eq$eq$eq((Object)new Some((Object)BoxesRunTime.boxToBoolean((boolean)true)), Equality$.MODULE$.default());
    }

    public static final /* synthetic */ void $anonfun$new$114(ObjectRef q1$3, StreamExecution x$10) {
        ((StreamingQuery)q1$3.elem).stop();
    }

    public static final /* synthetic */ void $anonfun$new$110(FileStreamSourceSuite $this, File x0$19, File x1$19) {
        Tuple2 tuple2 = new Tuple2((Object)x0$19, (Object)x1$19);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        File outputDir = (File)tuple2._1();
        File checkpointDir = (File)tuple2._2();
        MemoryStream q1Source = MemoryStream$.MODULE$.apply($this.testImplicits().newStringEncoder(), $this.sqlContext());
        DataStreamWriter q1Write = q1Source.toDF().writeStream().option("checkpointLocation", checkpointDir.getCanonicalPath()).format("text");
        ObjectRef q1 = ObjectRef.create(null);
        Dataset q22 = $this.createFileStream("text", outputDir.getCanonicalPath(), $this.createFileStream$default$3(), $this.createFileStream$default$4()).filter($this.testImplicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value"}))).$((Seq)Nil$.MODULE$).contains((Object)"keep"));
        $this.testStream(q22, $this.testStream$default$2(), (Seq<StreamTest.StreamAction>)Predef$.MODULE$.wrapRefArray((Object[])new StreamTest.StreamAction[]{$this.AssertOnQuery().apply((Function1<StreamExecution, Object>)(Function1 & Serializable & scala.Serializable)q2 -> BoxesRunTime.boxToBoolean((boolean)FileStreamSourceSuite.$anonfun$new$111($this, q2)), $this.AssertOnQuery().apply$default$2()), $this.Execute().apply((Function1<StreamExecution, Object>)(Function1 & Serializable & scala.Serializable)x$9 -> {
            FileStreamSourceSuite.$anonfun$new$112(q1, q1Write, outputDir, q1Source, x$9);
            return BoxedUnit.UNIT;
        }), $this.AssertOnQuery().apply((Function1<StreamExecution, Object>)(Function1 & Serializable & scala.Serializable)q2 -> BoxesRunTime.boxToBoolean((boolean)FileStreamSourceSuite.$anonfun$new$113($this, q2)), $this.AssertOnQuery().apply$default$2()), $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"keep2"}), $this.testImplicits().newStringEncoder()), $this.Execute().apply((Function1<StreamExecution, Object>)(Function1 & Serializable & scala.Serializable)x$10 -> {
            FileStreamSourceSuite.$anonfun$new$114(q1, x$10);
            return BoxedUnit.UNIT;
        })}));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$new$117(FileStreamSourceSuite $this, File x0$20, File x1$20) {
        Tuple2 tuple2 = new Tuple2((Object)x0$20, (Object)x1$20);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        File dir = (File)tuple2._1();
        File tmp = (File)tuple2._2();
        File partitionFooSubDir = new File(dir, "partition=foo");
        File partitionBarSubDir = new File(dir, "partition=bar");
        $this.createFile("{'value': 'drop0'}", partitionFooSubDir, tmp);
        Dataset<Row> fileStream = $this.createFileStream("json", String.valueOf(dir.getCanonicalPath()), $this.createFileStream$default$3(), $this.createFileStream$default$4());
        Dataset filtered = fileStream.filter($this.testImplicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value"}))).$((Seq)Nil$.MODULE$).contains((Object)"keep"));
        StreamTest.StreamAction[] streamActionArray = new StreamTest.StreamAction[10];
        streamActionArray[0] = new FileStreamSourceTest.AddTextFileData($this, "{'value': 'drop1'}\n{'value': 'keep2'}", partitionFooSubDir, tmp, $this.AddTextFileData().apply$default$4());
        JavaUniverse $u = scala.reflect.runtime.package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(FileStreamSourceSuite.class.getClassLoader());
        public final class Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator369$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
            }

            public Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator369$1(FileStreamSourceSuite $outer) {
            }
        }
        streamActionArray[1] = $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"keep2", (Object)"foo")}), $this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator369$1(null))));
        streamActionArray[2] = new FileStreamSourceTest.AddTextFileData($this, "{'value': 'keep3'}", partitionFooSubDir, tmp, $this.AddTextFileData().apply$default$4());
        JavaUniverse $u2 = scala.reflect.runtime.package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m2 = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(FileStreamSourceSuite.class.getClassLoader());
        public final class Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator374$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
            }

            public Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator374$1(FileStreamSourceSuite $outer) {
            }
        }
        streamActionArray[3] = $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"keep2", (Object)"foo"), new Tuple2((Object)"keep3", (Object)"foo")}), $this.testImplicits().newProductEncoder(((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator374$1(null))));
        streamActionArray[4] = new FileStreamSourceTest.AddTextFileData($this, "{'value': 'keep4'}", partitionBarSubDir, tmp, $this.AddTextFileData().apply$default$4());
        JavaUniverse $u3 = scala.reflect.runtime.package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m3 = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(FileStreamSourceSuite.class.getClassLoader());
        public final class Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator379$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
            }

            public Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator379$1(FileStreamSourceSuite $outer) {
            }
        }
        streamActionArray[5] = $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"keep2", (Object)"foo"), new Tuple2((Object)"keep3", (Object)"foo"), new Tuple2((Object)"keep4", (Object)"bar")}), $this.testImplicits().newProductEncoder(((TypeTags)$u3).TypeTag().apply((Mirror)$m3, (TypeCreator)new Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator379$1(null))));
        streamActionArray[6] = new FileStreamSourceTest.AddTextFileData($this, "{'value': 'keep5'}", partitionBarSubDir, tmp, $this.AddTextFileData().apply$default$4());
        JavaUniverse $u4 = scala.reflect.runtime.package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m4 = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(FileStreamSourceSuite.class.getClassLoader());
        public final class Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator384$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
            }

            public Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator384$1(FileStreamSourceSuite $outer) {
            }
        }
        streamActionArray[7] = $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"keep2", (Object)"foo"), new Tuple2((Object)"keep3", (Object)"foo"), new Tuple2((Object)"keep4", (Object)"bar"), new Tuple2((Object)"keep5", (Object)"bar")}), $this.testImplicits().newProductEncoder(((TypeTags)$u4).TypeTag().apply((Mirror)$m4, (TypeCreator)new Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator384$1(null))));
        streamActionArray[8] = new FileStreamSourceTest.AddTextFileData($this, "{'value': 'keep6'}", partitionBarSubDir, tmp, $this.AddTextFileData().apply$default$4());
        JavaUniverse $u5 = scala.reflect.runtime.package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m5 = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(FileStreamSourceSuite.class.getClassLoader());
        public final class Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator389$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
            }

            public Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator389$1(FileStreamSourceSuite $outer) {
            }
        }
        streamActionArray[9] = $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"keep2", (Object)"foo"), new Tuple2((Object)"keep3", (Object)"foo"), new Tuple2((Object)"keep4", (Object)"bar"), new Tuple2((Object)"keep5", (Object)"bar"), new Tuple2((Object)"keep6", (Object)"bar")}), $this.testImplicits().newProductEncoder(((TypeTags)$u5).TypeTag().apply((Mirror)$m5, (TypeCreator)new Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator389$1(null))));
        $this.testStream(filtered, $this.testStream$default$2(), (Seq<StreamTest.StreamAction>)Predef$.MODULE$.wrapRefArray((Object[])streamActionArray));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$new$119(FileStreamSourceSuite $this, File x0$21, File x1$21) {
        Tuple2 tuple2 = new Tuple2((Object)x0$21, (Object)x1$21);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        File src = (File)tuple2._1();
        File tmp = (File)tuple2._2();
        Dataset<Row> fileStream = $this.createFileStream("text", src.getCanonicalPath(), $this.createFileStream$default$3(), $this.createFileStream$default$4());
        Dataset filtered = fileStream.filter($this.testImplicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value"}))).$((Seq)Nil$.MODULE$).contains((Object)"keep"));
        $this.testStream(filtered, $this.testStream$default$2(), (Seq<StreamTest.StreamAction>)Predef$.MODULE$.wrapRefArray((Object[])new StreamTest.StreamAction[]{new FileStreamSourceTest.AddTextFileData($this, "drop1\nkeep2\nkeep3", src, tmp, $this.AddTextFileData().apply$default$4()), $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"keep2", "keep3"}), $this.testImplicits().newStringEncoder()), $this.StopStream(), new FileStreamSourceTest.AddTextFileData($this, "drop4\nkeep5\nkeep6", src, tmp, $this.AddTextFileData().apply$default$4()), new StreamTest.StartStream($this, $this.StartStream().apply$default$1(), $this.StartStream().apply$default$2(), $this.StartStream().apply$default$3(), $this.StartStream().apply$default$4()), $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"keep2", "keep3", "keep5", "keep6"}), $this.testImplicits().newStringEncoder()), new FileStreamSourceTest.AddTextFileData($this, "drop7\nkeep8\nkeep9", src, tmp, $this.AddTextFileData().apply$default$4()), $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"keep2", "keep3", "keep5", "keep6", "keep8", "keep9"}), $this.testImplicits().newStringEncoder())}));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    /*
     * WARNING - void declaration
     */
    private static final File createFile$1(int data, File x1$1, ObjectRef lastFileModTime$1) {
        void var3_3;
        File file = package$.MODULE$.stringToFile(new File(x1$1, new StringBuilder(4).append(data).append(".txt").toString()), Integer.toString(data));
        Object object = ((Option)lastFileModTime$1.elem).nonEmpty() ? BoxesRunTime.boxToBoolean((boolean)file.setLastModified(BoxesRunTime.unboxToLong((Object)((Option)lastFileModTime$1.elem).get()) + 1000L)) : BoxedUnit.UNIT;
        lastFileModTime$1.elem = new Some((Object)BoxesRunTime.boxToLong((long)file.lastModified()));
        return var3_3;
    }

    public static final /* synthetic */ String $anonfun$new$123(int x$11) {
        return Integer.toString(x$11);
    }

    private final void checkLastBatchData$1(Seq data, MemorySink memorySink$1) {
        StructType schema = StructType$.MODULE$.apply((Seq)new .colon.colon((Object)new StructField("value", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$));
        SparkContext qual$1 = this.spark().sparkContext();
        Seq x$1 = memorySink$1.latestBatchData();
        int x$2 = qual$1.makeRDD$default$2();
        Dataset df = this.spark().createDataFrame(qual$1.makeRDD(x$1, x$2, ClassTag$.MODULE$.apply(Row.class)), schema);
        this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> df, (Dataset<Row>)this.testImplicits().localSeqToDatasetHolder((Seq)data.map((Function1 & Serializable & scala.Serializable)x$11 -> FileStreamSourceSuite.$anonfun$new$123(BoxesRunTime.unboxToInt((Object)x$11)), Seq$.MODULE$.canBuildFrom()), this.testImplicits().newStringEncoder()).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value"})));
    }

    public static final /* synthetic */ String $anonfun$new$125(int x$12) {
        return Integer.toString(x$12);
    }

    private final void checkAllData$1(Seq data, MemorySink memorySink$1) {
        StructType schema = StructType$.MODULE$.apply((Seq)new .colon.colon((Object)new StructField("value", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$));
        SparkContext qual$1 = this.spark().sparkContext();
        Seq x$1 = memorySink$1.allData();
        int x$2 = qual$1.makeRDD$default$2();
        Dataset df = this.spark().createDataFrame(qual$1.makeRDD(x$1, x$2, ClassTag$.MODULE$.apply(Row.class)), schema);
        this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> df, (Dataset<Row>)this.testImplicits().localSeqToDatasetHolder((Seq)data.map((Function1 & Serializable & scala.Serializable)x$12 -> FileStreamSourceSuite.$anonfun$new$125(BoxesRunTime.unboxToInt((Object)x$12)), Seq$.MODULE$.canBuildFrom()), this.testImplicits().newStringEncoder()).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value"})));
    }

    private final void checkNumBatchesSinceLastCheck$1(int numBatches, LongRef lastBatchId$1, MemorySink memorySink$1) {
        Predef$.MODULE$.require(lastBatchId$1.elem >= 0L);
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(memorySink$1.latestBatchId().get());
        long $org_scalatest_assert_macro_right = lastBatchId$1.elem + (long)numBatches;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1187));
        lastBatchId$1.elem = BoxesRunTime.unboxToLong((Object)memorySink$1.latestBatchId().get());
    }

    public static final /* synthetic */ void $anonfun$new$121(FileStreamSourceSuite $this, File x0$22) {
        File file = x0$22;
        ObjectRef lastFileModTime = ObjectRef.create((Object)None$.MODULE$);
        FileStreamSourceSuite.createFile$1(1, file, lastFileModTime);
        FileStreamSourceSuite.createFile$1(2, file, lastFileModTime);
        FileStreamSourceSuite.createFile$1(3, file, lastFileModTime);
        Dataset df = $this.spark().readStream().option("maxFilesPerTrigger", 2L).text(file.getCanonicalPath());
        StreamExecution q = ((StreamingQueryWrapper)df.writeStream().format("memory").queryName("file_data").start()).streamingQuery();
        q.processAllAvailable();
        MemorySink memorySink = (MemorySink)q.sink();
        FileStreamSource fileSource = (FileStreamSource)$this.getSourcesFromStreamingQuery(q).head();
        LongRef lastBatchId = LongRef.create((long)-1L);
        $this.checkLastBatchData$1((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3}), memorySink);
        $this.checkAllData$1((Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 3), memorySink);
        lastBatchId.elem = BoxesRunTime.unboxToLong((Object)memorySink.latestBatchId().get());
        fileSource.withBatchingLocked((Function0 & Serializable & scala.Serializable)() -> {
            FileStreamSourceSuite.createFile$1(4, file, lastFileModTime);
            FileStreamSourceSuite.createFile$1(5, file, lastFileModTime);
            FileStreamSourceSuite.createFile$1(6, file, lastFileModTime);
            return FileStreamSourceSuite.createFile$1(7, file, lastFileModTime);
        });
        q.processAllAvailable();
        $this.checkNumBatchesSinceLastCheck$1(2, lastBatchId, memorySink);
        $this.checkLastBatchData$1((Seq)Predef$.MODULE$.wrapIntArray(new int[]{6, 7}), memorySink);
        $this.checkAllData$1((Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 7), memorySink);
        fileSource.withBatchingLocked((Function0 & Serializable & scala.Serializable)() -> {
            FileStreamSourceSuite.createFile$1(8, file, lastFileModTime);
            FileStreamSourceSuite.createFile$1(9, file, lastFileModTime);
            FileStreamSourceSuite.createFile$1(10, file, lastFileModTime);
            FileStreamSourceSuite.createFile$1(11, file, lastFileModTime);
            return FileStreamSourceSuite.createFile$1(12, file, lastFileModTime);
        });
        q.processAllAvailable();
        $this.checkNumBatchesSinceLastCheck$1(3, lastBatchId, memorySink);
        $this.checkLastBatchData$1((Seq)Predef$.MODULE$.wrapIntArray(new int[]{12}), memorySink);
        $this.checkAllData$1((Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 12), memorySink);
        q.stop();
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private final void testMaxFilePerTriggerValue$1(String value, File x1$2, String testTable$1) {
        Dataset df = this.spark().readStream().option("maxFilesPerTrigger", value).text(x1$2.getCanonicalPath());
        StreamingQueryException e = (StreamingQueryException)((Object)this.intercept((Function0 & Serializable & scala.Serializable)() -> {
            BoxedUnit boxedUnit;
            StreamingQuery q = df.writeStream().format("memory").queryName(testTable$1).start();
            try {
                q.processAllAvailable();
                boxedUnit = BoxedUnit.UNIT;
            }
            finally {
                q.stop();
            }
            return boxedUnit;
        }, ClassTag$.MODULE$.apply(StreamingQueryException.class), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1228)));
        Throwable $org_scalatest_assert_macro_left = e.getCause();
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left, "isInstanceOf", "scala.IllegalArgumentException", $org_scalatest_assert_macro_left instanceof IllegalArgumentException, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1237));
        ((IterableLike)new .colon.colon((Object)"maxFilesPerTrigger", (List)new .colon.colon((Object)value, (List)new .colon.colon((Object)"positive integer", (List)Nil$.MODULE$)))).foreach((Function1 & Serializable & scala.Serializable)s -> {
            String $org_scalatest_assert_macro_left = e.getMessage();
            String $org_scalatest_assert_macro_right = s;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1239));
        });
    }

    public static final /* synthetic */ void $anonfun$new$130(FileStreamSourceSuite $this, String testTable$1, File x0$23) {
        File file = x0$23;
        $this.testMaxFilePerTriggerValue$1("not-a-integer", file, testTable$1);
        $this.testMaxFilePerTriggerValue$1("-1", file, testTable$1);
        $this.testMaxFilePerTriggerValue$1("0", file, testTable$1);
        $this.testMaxFilePerTriggerValue$1("10.1", file, testTable$1);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    /*
     * WARNING - void declaration
     */
    private static final File createFile$2(int data, File src$11, ObjectRef lastFileModTime$2) {
        void var3_3;
        File file = package$.MODULE$.stringToFile(new File(src$11, new StringBuilder(4).append(data).append(".txt").toString()), Integer.toString(data));
        Object object = ((Option)lastFileModTime$2.elem).nonEmpty() ? BoxesRunTime.boxToBoolean((boolean)file.setLastModified(BoxesRunTime.unboxToLong((Object)((Option)lastFileModTime$2.elem).get()) + 1000L)) : BoxedUnit.UNIT;
        lastFileModTime$2.elem = new Some((Object)BoxesRunTime.boxToLong((long)file.lastModified()));
        return var3_3;
    }

    private static final StreamingQuery startQuery$1(Dataset df$4, String checkpoint$1, String targetDir$1) {
        return df$4.writeStream().format("parquet").trigger(Trigger.Once()).option("checkpointLocation", checkpoint$1).start(targetDir$1);
    }

    public static final /* synthetic */ boolean $anonfun$new$135(StreamingQueryProgress x$13) {
        return x$13.numInputRows() != 0L;
    }

    public static final /* synthetic */ String $anonfun$new$137(int x$14) {
        return Integer.toString(x$14);
    }

    public static final /* synthetic */ boolean $anonfun$new$138(StreamingQueryProgress x$15) {
        return x$15.numInputRows() != 0L;
    }

    public static final /* synthetic */ String $anonfun$new$140(int x$16) {
        return Integer.toString(x$16);
    }

    public static final /* synthetic */ void $anonfun$new$134(FileStreamSourceSuite $this, File src, File target) {
        String checkpoint = new File(target, "chk").getCanonicalPath();
        String targetDir = new File(target, "data").getCanonicalPath();
        ObjectRef lastFileModTime = ObjectRef.create((Object)None$.MODULE$);
        FileStreamSourceSuite.createFile$2(1, src, lastFileModTime);
        FileStreamSourceSuite.createFile$2(2, src, lastFileModTime);
        FileStreamSourceSuite.createFile$2(3, src, lastFileModTime);
        Dataset df = $this.spark().readStream().option("maxFilesPerTrigger", 1L).text(src.getCanonicalPath());
        StreamingQuery q = FileStreamSourceSuite.startQuery$1(df, checkpoint, targetDir);
        try {
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(q.awaitTermination(Span$.MODULE$.convertSpanToDuration($this.streamingTimeout()).toMillis()), "q.awaitTermination(time.this.Span.convertSpanToDuration(FileStreamSourceSuite.this.streamingTimeout).toMillis)", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1285));
            int $org_scalatest_assert_macro_left = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])q.recentProgress())).count((Function1 & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToBoolean((boolean)FileStreamSourceSuite.$anonfun$new$135(x$13)));
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1286));
            $this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> (Dataset)$this.sql().apply((Object)new StringBuilder(24).append("SELECT * from parquet.`").append(targetDir).append("`").toString()), (Dataset<Row>)$this.testImplicits().localSeqToDatasetHolder((Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 3).map((Function1 & Serializable & scala.Serializable)x$14 -> FileStreamSourceSuite.$anonfun$new$137(BoxesRunTime.unboxToInt((Object)x$14)), IndexedSeq$.MODULE$.canBuildFrom()), $this.testImplicits().newStringEncoder()).toDF());
        }
        finally {
            q.stop();
        }
        FileStreamSourceSuite.createFile$2(4, src, lastFileModTime);
        FileStreamSourceSuite.createFile$2(5, src, lastFileModTime);
        StreamingQuery q2 = FileStreamSourceSuite.startQuery$1(df, checkpoint, targetDir);
        try {
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(q2.awaitTermination(Span$.MODULE$.convertSpanToDuration($this.streamingTimeout()).toMillis()), "q2.awaitTermination(time.this.Span.convertSpanToDuration(FileStreamSourceSuite.this.streamingTimeout).toMillis)", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1298));
            int $org_scalatest_assert_macro_left = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])q2.recentProgress())).count((Function1 & Serializable & scala.Serializable)x$15 -> BoxesRunTime.boxToBoolean((boolean)FileStreamSourceSuite.$anonfun$new$138(x$15)));
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1299));
            $this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> (Dataset)$this.sql().apply((Object)new StringBuilder(24).append("SELECT * from parquet.`").append(targetDir).append("`").toString()), (Dataset<Row>)$this.testImplicits().localSeqToDatasetHolder((Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 5).map((Function1 & Serializable & scala.Serializable)x$16 -> FileStreamSourceSuite.$anonfun$new$140(BoxesRunTime.unboxToInt((Object)x$16)), IndexedSeq$.MODULE$.canBuildFrom()), $this.testImplicits().newStringEncoder()).toDF());
        }
        finally {
            q2.stop();
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final File createFile$3(int data, File src$12, ObjectRef lastFileModTime$3) {
        void var3_3;
        File file = package$.MODULE$.stringToFile(new File(src$12, new StringBuilder(4).append(data).append(".txt").toString()), Integer.toString(data));
        Object object = ((Option)lastFileModTime$3.elem).nonEmpty() ? BoxesRunTime.boxToBoolean((boolean)file.setLastModified(BoxesRunTime.unboxToLong((Object)((Option)lastFileModTime$3.elem).get()) + 1000L)) : BoxedUnit.UNIT;
        lastFileModTime$3.elem = new Some((Object)BoxesRunTime.boxToLong((long)file.lastModified()));
        return var3_3;
    }

    public static final /* synthetic */ void $anonfun$new$143(Dataset x$17, long x$18) {
    }

    private static final StreamingQuery startTriggerOnceQuery$1(Dataset df$5, String checkpoint$2) {
        return df$5.writeStream().foreachBatch((Function2 & Serializable & scala.Serializable)(x$17, x$18) -> {
            FileStreamSourceSuite.$anonfun$new$143(x$17, BoxesRunTime.unboxToLong((Object)x$18));
            return BoxedUnit.UNIT;
        }).trigger(Trigger.Once()).option("checkpointLocation", checkpoint$2).start();
    }

    public static final /* synthetic */ void $anonfun$new$144(FileStreamSourceSuite $this, IntRef index$1, Dataset df, long x$19) {
        ++index$1.elem;
        $this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> df, Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Integer.toString(index$1.elem)})));
    }

    private final StreamingQuery startTriggerAvailableNowQuery$1(Dataset df$5, IntRef index$1, String checkpoint$2) {
        return df$5.writeStream().foreachBatch((Function2 & Serializable & scala.Serializable)(df, x$19) -> {
            FileStreamSourceSuite.$anonfun$new$144(this, index$1, df, BoxesRunTime.unboxToLong((Object)x$19));
            return BoxedUnit.UNIT;
        }).trigger(Trigger.AvailableNow()).option("checkpointLocation", checkpoint$2).start();
    }

    public static final /* synthetic */ void $anonfun$new$142(FileStreamSourceSuite $this, File src, File target) {
        String checkpoint = new File(target, "chk").getCanonicalPath();
        ObjectRef lastFileModTime = ObjectRef.create((Object)None$.MODULE$);
        FileStreamSourceSuite.createFile$3(1, src, lastFileModTime);
        FileStreamSourceSuite.createFile$3(2, src, lastFileModTime);
        FileStreamSourceSuite.createFile$3(3, src, lastFileModTime);
        Dataset df = $this.spark().readStream().option("maxFilesPerTrigger", 1L).text(src.getCanonicalPath());
        StreamingQuery q = FileStreamSourceSuite.startTriggerOnceQuery$1(df, checkpoint);
        try {
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(q.awaitTermination(Span$.MODULE$.convertSpanToDuration($this.streamingTimeout()).toMillis()), "q.awaitTermination(time.this.Span.convertSpanToDuration(FileStreamSourceSuite.this.streamingTimeout).toMillis)", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1342));
        }
        finally {
            q.stop();
        }
        IntRef index = IntRef.create((int)3);
        FileStreamSourceSuite.createFile$3(4, src, lastFileModTime);
        FileStreamSourceSuite.createFile$3(5, src, lastFileModTime);
        StreamingQuery q2 = $this.startTriggerAvailableNowQuery$1(df, index, checkpoint);
        try {
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(q2.awaitTermination(Span$.MODULE$.convertSpanToDuration($this.streamingTimeout()).toMillis()), "q2.awaitTermination(time.this.Span.convertSpanToDuration(FileStreamSourceSuite.this.streamingTimeout).toMillis)", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1369));
            int $org_scalatest_assert_macro_left = index.elem;
            int $org_scalatest_assert_macro_right = 5;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1370));
        }
        finally {
            q2.stop();
        }
        FileStreamSourceSuite.createFile$3(6, src, lastFileModTime);
        FileStreamSourceSuite.createFile$3(7, src, lastFileModTime);
        StreamingQuery q3 = $this.startTriggerAvailableNowQuery$1(df, index, checkpoint);
        try {
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(q3.awaitTermination(Span$.MODULE$.convertSpanToDuration($this.streamingTimeout()).toMillis()), "q3.awaitTermination(time.this.Span.convertSpanToDuration(FileStreamSourceSuite.this.streamingTimeout).toMillis)", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1381));
            int $org_scalatest_assert_macro_left = index.elem;
            int $org_scalatest_assert_macro_right = 7;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1382));
        }
        finally {
            q3.stop();
        }
    }

    public static final /* synthetic */ void $anonfun$new$147(FileStreamSourceSuite $this, File x0$24, File x1$22) {
        BoxedUnit boxedUnit;
        Tuple2 tuple2 = new Tuple2((Object)x0$24, (Object)x1$22);
        if (tuple2 != null) {
            File src = (File)tuple2._1();
            File tmp = (File)tuple2._2();
            src.mkdirs();
            Dataset df = $this.spark().readStream().format("text").load(src.getCanonicalPath()).map((Function1 & Serializable & scala.Serializable)x$20 -> Predef.any2stringadd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd(x$20), "-x"), $this.testImplicits().newStringEncoder());
            df.explain();
            StreamExecution q = ((StreamingQueryWrapper)df.writeStream().queryName("file_explain").format("memory").start()).streamingQuery();
            try {
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer("No physical plan. Waiting for data.");
                String $org_scalatest_assert_macro_right = q.explainInternal(false);
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1401));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = $this.convertToEqualizer("No physical plan. Waiting for data.");
                String $org_scalatest_assert_macro_right2 = q.explainInternal(true);
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1402));
                File tempFile = Utils$.MODULE$.tempFileWith(new File(tmp, "text"));
                File finalFile = new File(src, tempFile.getName());
                Predef$.MODULE$.require(package$.MODULE$.stringToFile(tempFile, "foo").renameTo(finalFile));
                q.processAllAvailable();
                String explainWithoutExtended = q.explainInternal(false);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = $this.convertToEqualizer(BoxesRunTime.boxToInteger((int)new StringOps(Predef$.MODULE$.augmentString("Relation.*text")).r().findAllMatchIn((CharSequence)explainWithoutExtended).size()));
                int $org_scalatest_assert_macro_right3 = 0;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1412));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = $this.convertToEqualizer(BoxesRunTime.boxToInteger((int)new StringOps(Predef$.MODULE$.augmentString(": Text")).r().findAllMatchIn((CharSequence)explainWithoutExtended).size()));
                int $org_scalatest_assert_macro_right4 = 1;
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1413));
                String explainWithExtended = q.explainInternal(true);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = $this.convertToEqualizer(BoxesRunTime.boxToInteger((int)new StringOps(Predef$.MODULE$.augmentString("Relation.*text")).r().findAllMatchIn((CharSequence)explainWithExtended).size()));
                int $org_scalatest_assert_macro_right5 = 3;
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1418));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = $this.convertToEqualizer(BoxesRunTime.boxToInteger((int)new StringOps(Predef$.MODULE$.augmentString(": Text")).r().findAllMatchIn((CharSequence)explainWithExtended).size()));
                int $org_scalatest_assert_macro_right6 = 1;
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1419));
                boxedUnit = BoxedUnit.UNIT;
            }
            finally {
                q.stop();
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        BoxedUnit boxedUnit2 = boxedUnit;
    }

    public static final /* synthetic */ String $anonfun$new$151(int x$21) {
        return Integer.toString(x$21);
    }

    public static final /* synthetic */ void $anonfun$new$150(FileStreamSourceSuite $this, int numFiles$1, File x0$25, File x1$23) {
        Tuple2 tuple2 = new Tuple2((Object)x0$25, (Object)x1$23);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        File root = (File)tuple2._1();
        File tmp = (File)tuple2._2();
        File src = new File(root, "a=1");
        src.mkdirs();
        ((IterableLike)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), numFiles$1).map((Function1 & Serializable & scala.Serializable)x$21 -> FileStreamSourceSuite.$anonfun$new$151(BoxesRunTime.unboxToInt((Object)x$21)), IndexedSeq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)i -> {
            File tempFile = Utils$.MODULE$.tempFileWith(new File(tmp, "text"));
            File finalFile = new File(src, tempFile.getName());
            return package$.MODULE$.stringToFile(finalFile, i);
        });
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(BoxesRunTime.boxToInteger((int)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])src.listFiles())).size()));
        int $org_scalatest_assert_macro_right = numFiles$1;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1447));
        JavaUniverse $u = scala.reflect.runtime.package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(FileStreamSourceSuite.class.getClassLoader());
        public final class Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator426$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
            }

            public Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator426$1(FileStreamSourceSuite $outer) {
            }
        }
        Dataset files = $this.spark().readStream().text(root.getCanonicalPath()).as($this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator426$1(null))));
        Dataset df = files.filter("1 == 0").groupBy((Seq)Nil$.MODULE$).count();
        $this.testStream(df, OutputMode.Complete(), (Seq<StreamTest.StreamAction>)Predef$.MODULE$.wrapRefArray((Object[])new StreamTest.StreamAction[]{new FileStreamSourceTest.AddTextFileData($this, "0", src, tmp, $this.AddTextFileData().apply$default$4()), $this.CheckAnswer().apply(Predef$.MODULE$.wrapIntArray(new int[]{0}), $this.testImplicits().newIntEncoder())}));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private final boolean verify$1(StreamExecution execution, long batchId, int expectedBatches, int expectedCompactInterval, PrivateMethodTester.PrivateMethod _metadataLog$1) {
        BoxedUnit boxedUnit;
        FileStreamSource fileSource = (FileStreamSource)this.getSourcesFromStreamingQuery(execution).head();
        FileStreamSourceLog metadataLog = (FileStreamSourceLog)this.anyRefToInvoker(fileSource).invokePrivate(_metadataLog$1.apply((Seq)Nil$.MODULE$));
        if (CompactibleFileStreamLog$.MODULE$.isCompactionBatch(batchId, expectedCompactInterval)) {
            Path path = metadataLog.batchIdToPath(batchId);
            String $org_scalatest_assert_macro_left = path.getName();
            String $org_scalatest_assert_macro_right = CompactibleFileStreamLog$.MODULE$.COMPACT_FILE_SUFFIX();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "endsWith", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.endsWith($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"path does not end with compact file suffix", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1480));
            Option entries = metadataLog.get(batchId);
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(entries.isDefined(), "entries.isDefined", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"Entries not defined", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1485));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)((FileStreamSource.FileEntry[])entries.get()).length));
            int $org_scalatest_assert_macro_right2 = ((FileStreamSource.FileEntry[])metadataLog.allFiles()).length;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"clean up check", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1486));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)((FileStreamSource.FileEntry[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])metadataLog.get((Option)None$.MODULE$, (Option)new Some((Object)BoxesRunTime.boxToLong((long)batchId))))).flatMap((Function1 & Serializable & scala.Serializable)x$22 -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])x$22._2())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(FileStreamSource.FileEntry.class)))).length));
            int $org_scalatest_assert_macro_right3 = ((FileStreamSource.FileEntry[])entries.get()).length;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            boxedUnit = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"Length check", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1487));
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps(metadataLog.allFiles())).sortBy((Function1 & Serializable & scala.Serializable)x$23 -> BoxesRunTime.boxToLong((long)x$23.batchId()), (Ordering)Ordering.Long$.MODULE$));
        FileStreamSource.FileEntry[] $org_scalatest_assert_macro_right = (FileStreamSource.FileEntry[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])metadataLog.get((Option)None$.MODULE$, (Option)new Some((Object)BoxesRunTime.boxToLong((long)batchId))))).flatMap((Function1 & Serializable & scala.Serializable)x$24 -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])x$24._2())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(FileStreamSource.FileEntry.class))))).sortBy((Function1 & Serializable & scala.Serializable)x$25 -> BoxesRunTime.boxToLong((long)x$25.batchId()), (Ordering)Ordering.Long$.MODULE$);
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"Batch id mismatch", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1491));
        return this.convertToEqualizer(BoxesRunTime.boxToInteger((int)((FileStreamSource.FileEntry[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])metadataLog.get((Option)None$.MODULE$, (Option)new Some((Object)BoxesRunTime.boxToLong((long)batchId))))).flatMap((Function1 & Serializable & scala.Serializable)x$26 -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])x$26._2())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(FileStreamSource.FileEntry.class)))).length)).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)expectedBatches), Equality$.MODULE$.default());
    }

    public static final /* synthetic */ void $anonfun$new$159(FileStreamSourceSuite $this, PrivateMethodTester.PrivateMethod _metadataLog$1, File x0$26, File x1$24) {
        Tuple2 tuple2 = new Tuple2((Object)x0$26, (Object)x1$24);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        File src = (File)tuple2._1();
        File tmp = (File)tuple2._2();
        $this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.FILE_SOURCE_LOG_COMPACT_INTERVAL().key()), (Object)"2")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Dataset<Row> fileStream = $this.createFileStream("text", src.getCanonicalPath(), $this.createFileStream$default$3(), $this.createFileStream$default$4());
            Dataset filtered = fileStream.filter($this.testImplicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value"}))).$((Seq)Nil$.MODULE$).contains((Object)"keep"));
            Map updateConf = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.FILE_SOURCE_LOG_COMPACT_INTERVAL().key()), (Object)"5")}));
            StreamTest.StreamAction[] streamActionArray = new StreamTest.StreamAction[18];
            streamActionArray[0] = new FileStreamSourceTest.AddTextFileData($this, "drop1\nkeep2\nkeep3", src, tmp, $this.AddTextFileData().apply$default$4());
            streamActionArray[1] = $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"keep2", "keep3"}), $this.testImplicits().newStringEncoder());
            streamActionArray[2] = $this.AssertOnQuery().apply((Function1<StreamExecution, Object>)(Function1 & Serializable & scala.Serializable)x$27 -> BoxesRunTime.boxToBoolean((boolean)$this.verify$1(x$27, 0L, 1, 2, _metadataLog$1)), $this.AssertOnQuery().apply$default$2());
            streamActionArray[3] = new FileStreamSourceTest.AddTextFileData($this, "drop4\nkeep5\nkeep6", src, tmp, $this.AddTextFileData().apply$default$4());
            streamActionArray[4] = $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"keep2", "keep3", "keep5", "keep6"}), $this.testImplicits().newStringEncoder());
            streamActionArray[5] = $this.AssertOnQuery().apply((Function1<StreamExecution, Object>)(Function1 & Serializable & scala.Serializable)x$28 -> BoxesRunTime.boxToBoolean((boolean)$this.verify$1(x$28, 1L, 2, 2, _metadataLog$1)), $this.AssertOnQuery().apply$default$2());
            streamActionArray[6] = new FileStreamSourceTest.AddTextFileData($this, "drop7\nkeep8\nkeep9", src, tmp, $this.AddTextFileData().apply$default$4());
            streamActionArray[7] = $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"keep2", "keep3", "keep5", "keep6", "keep8", "keep9"}), $this.testImplicits().newStringEncoder());
            streamActionArray[8] = $this.AssertOnQuery().apply((Function1<StreamExecution, Object>)(Function1 & Serializable & scala.Serializable)x$29 -> BoxesRunTime.boxToBoolean((boolean)$this.verify$1(x$29, 2L, 3, 2, _metadataLog$1)), $this.AssertOnQuery().apply$default$2());
            streamActionArray[9] = $this.StopStream();
            Map x$5 = updateConf;
            Trigger x$6 = $this.StartStream().apply$default$1();
            Clock x$7 = $this.StartStream().apply$default$2();
            String x$8 = $this.StartStream().apply$default$4();
            streamActionArray[10] = new StreamTest.StartStream($this, x$6, x$7, (Map<String, String>)x$5, x$8);
            streamActionArray[11] = $this.AssertOnQuery().apply((Function1<StreamExecution, Object>)(Function1 & Serializable & scala.Serializable)x$30 -> BoxesRunTime.boxToBoolean((boolean)$this.verify$1(x$30, 2L, 3, 2, _metadataLog$1)), $this.AssertOnQuery().apply$default$2());
            streamActionArray[12] = new FileStreamSourceTest.AddTextFileData($this, "drop10\nkeep11", src, tmp, $this.AddTextFileData().apply$default$4());
            streamActionArray[13] = $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"keep2", "keep3", "keep5", "keep6", "keep8", "keep9", "keep11"}), $this.testImplicits().newStringEncoder());
            streamActionArray[14] = $this.AssertOnQuery().apply((Function1<StreamExecution, Object>)(Function1 & Serializable & scala.Serializable)x$31 -> BoxesRunTime.boxToBoolean((boolean)$this.verify$1(x$31, 3L, 4, 2, _metadataLog$1)), $this.AssertOnQuery().apply$default$2());
            streamActionArray[15] = new FileStreamSourceTest.AddTextFileData($this, "drop12\nkeep13", src, tmp, $this.AddTextFileData().apply$default$4());
            streamActionArray[16] = $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"keep2", "keep3", "keep5", "keep6", "keep8", "keep9", "keep11", "keep13"}), $this.testImplicits().newStringEncoder());
            streamActionArray[17] = $this.AssertOnQuery().apply((Function1<StreamExecution, Object>)(Function1 & Serializable & scala.Serializable)x$32 -> BoxesRunTime.boxToBoolean((boolean)$this.verify$1(x$32, 4L, 5, 2, _metadataLog$1)), $this.AssertOnQuery().apply$default$2());
            $this.testStream(filtered, $this.testStream$default$2(), (Seq<StreamTest.StreamAction>)Predef$.MODULE$.wrapRefArray((Object[])streamActionArray));
        });
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ FileStreamSource.FileEntry $anonfun$new$168(long batchId$1, int count$1, int idx) {
        return new FileStreamSource.FileEntry(new StringBuilder(6).append("path_").append(batchId$1).append("_").append(idx).toString(), 10000L * batchId$1 + (long)count$1, batchId$1);
    }

    private static final FileStreamSource.FileEntry[] createEntries$1(long batchId, int count) {
        return (FileStreamSource.FileEntry[])((TraversableOnce)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), count).map((Function1 & Serializable & scala.Serializable)idx -> FileStreamSourceSuite.$anonfun$new$168(batchId, count, BoxesRunTime.unboxToInt((Object)idx)), IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(FileStreamSource.FileEntry.class));
    }

    public static final /* synthetic */ Assertion $anonfun$new$170(LinkedHashMap fileEntryCache$1, int batchId) {
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(fileEntryCache$1.containsKey(BoxesRunTime.boxToLong((long)batchId)), "fileEntryCache.containsKey(batchId.toLong)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
        return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1543));
    }

    public static final /* synthetic */ Assertion $anonfun$new$171(LinkedHashMap fileEntryCache$1, int batchId) {
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(fileEntryCache$1.containsKey(BoxesRunTime.boxToLong((long)batchId)), "fileEntryCache.containsKey(batchId.toLong)", Prettifier$.MODULE$.default());
        return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1546));
    }

    private static final void verifyBatchAvailabilityInCache$1(LinkedHashMap fileEntryCache, Seq expectNotAvailable, Seq expectAvailable) {
        expectNotAvailable.foreach((Function1 & Serializable & scala.Serializable)batchId -> FileStreamSourceSuite.$anonfun$new$170(fileEntryCache, BoxesRunTime.unboxToInt((Object)batchId)));
        expectAvailable.foreach((Function1 & Serializable & scala.Serializable)batchId -> FileStreamSourceSuite.$anonfun$new$171(fileEntryCache, BoxesRunTime.unboxToInt((Object)batchId)));
    }

    public static final /* synthetic */ void $anonfun$new$172(FileStreamSourceSuite $this, File chk) {
        PrivateMethodTester.PrivateMethod _fileEntryCache = $this.PrivateMethod().apply((Symbol)SymbolLiteral.bootstrap("apply", "fileEntryCache"));
        FileStreamSourceLog metadata = new FileStreamSourceLog(FileStreamSourceLog$.MODULE$.VERSION(), $this.spark(), chk.getCanonicalPath());
        LinkedHashMap fileEntryCache = (LinkedHashMap)$this.anyRefToInvoker(metadata).invokePrivate(_fileEntryCache.apply((Seq)Nil$.MODULE$));
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 4).foreach((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)batchId -> metadata.add((long)batchId, FileStreamSourceSuite.createEntries$1(batchId, 100)));
        FileStreamSource.FileEntry[] allFiles = (FileStreamSource.FileEntry[])metadata.allFiles();
        FileStreamSourceSuite.verifyBatchAvailabilityInCache$1(fileEntryCache, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4})));
        FileStreamSourceLog metadata2 = new FileStreamSourceLog(FileStreamSourceLog$.MODULE$.VERSION(), $this.spark(), chk.getCanonicalPath());
        LinkedHashMap fileEntryCache2 = (LinkedHashMap)$this.anyRefToInvoker(metadata2).invokePrivate(_fileEntryCache.apply((Seq)Nil$.MODULE$));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(metadata2.allFiles());
        FileStreamSource.FileEntry[] $org_scalatest_assert_macro_right = allFiles;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1570));
        FileStreamSourceSuite.verifyBatchAvailabilityInCache$1(fileEntryCache2, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3, 4})), (Seq)Nil$.MODULE$);
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = $this.convertToEqualizer(metadata2.restore());
        FileStreamSource.FileEntry[] $org_scalatest_assert_macro_right2 = allFiles;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1574));
        FileStreamSourceSuite.verifyBatchAvailabilityInCache$1(fileEntryCache2, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4})));
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(5), 5 + FileStreamSourceLog$.MODULE$.PREV_NUM_BATCHES_TO_READ_IN_RESTORE()).foreach((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)batchId -> metadata2.add((long)batchId, FileStreamSourceSuite.createEntries$1(batchId, 100)));
        FileStreamSourceLog metadata3 = new FileStreamSourceLog(FileStreamSourceLog$.MODULE$.VERSION(), $this.spark(), chk.getCanonicalPath());
        LinkedHashMap fileEntryCache3 = (LinkedHashMap)$this.anyRefToInvoker(metadata3).invokePrivate(_fileEntryCache.apply((Seq)Nil$.MODULE$));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = $this.convertToEqualizer(metadata3.restore());
        FileStreamSource.FileEntry[] $org_scalatest_assert_macro_right3 = (FileStreamSource.FileEntry[])metadata2.allFiles();
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1588));
        FileStreamSourceSuite.verifyBatchAvailabilityInCache$1(fileEntryCache3, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3, 4})), (Seq)Nil$.MODULE$);
    }

    public static final /* synthetic */ FileStreamSourceOffset $anonfun$new$179(int x$33) {
        return new FileStreamSourceOffset((long)x$33);
    }

    private final void verify$2(Option startId, int endId, Seq expected, FileStreamSource fileSource$1) {
        Option start = startId.map((Function1 & Serializable & scala.Serializable)x$33 -> FileStreamSourceSuite.$anonfun$new$179(BoxesRunTime.unboxToInt((Object)x$33)));
        FileStreamSourceOffset end = new FileStreamSourceOffset((long)endId);
        this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.UNSUPPORTED_OPERATION_CHECK_ENABLED().key()), (Object)"false")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fileSource$1.getBatch(start, (org.apache.spark.sql.execution.streaming.Offset)end).as(this.testImplicits().newStringEncoder()).collect())).toSeq());
            Seq $org_scalatest_assert_macro_right = expected;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1620));
        });
    }

    public static final /* synthetic */ boolean $anonfun$new$178(FileStreamSourceSuite $this, StreamExecution execution) {
        PrivateMethodTester.PrivateMethod _sources = $this.PrivateMethod().apply((Symbol)SymbolLiteral.bootstrap("apply", "sources"));
        FileStreamSource fileSource = (FileStreamSource)$this.getSourcesFromStreamingQuery(execution).head();
        $this.verify$2((Option)None$.MODULE$, 2, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"keep1", "keep2", "keep3"}), fileSource);
        $this.verify$2((Option)new Some((Object)BoxesRunTime.boxToInteger((int)0)), 1, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"keep2"}), fileSource);
        $this.verify$2((Option)new Some((Object)BoxesRunTime.boxToInteger((int)0)), 2, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"keep2", "keep3"}), fileSource);
        $this.verify$2((Option)new Some((Object)BoxesRunTime.boxToInteger((int)1)), 2, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"keep3"}), fileSource);
        return true;
    }

    public static final /* synthetic */ void $anonfun$new$176(FileStreamSourceSuite $this, File x0$27, File x1$25) {
        Tuple2 tuple2 = new Tuple2((Object)x0$27, (Object)x1$25);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        File src = (File)tuple2._1();
        File tmp = (File)tuple2._2();
        $this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.FILE_SOURCE_LOG_COMPACT_INTERVAL().key()), (Object)"2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.FILE_SOURCE_LOG_CLEANUP_DELAY().key()), (Object)"1")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Dataset<Row> fileStream = $this.createFileStream("text", src.getCanonicalPath(), $this.createFileStream$default$3(), $this.createFileStream$default$4());
            Dataset filtered = fileStream.filter($this.testImplicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value"}))).$((Seq)Nil$.MODULE$).contains((Object)"keep"));
            $this.testStream(filtered, $this.testStream$default$2(), (Seq<StreamTest.StreamAction>)Predef$.MODULE$.wrapRefArray((Object[])new StreamTest.StreamAction[]{new FileStreamSourceTest.AddTextFileData($this, "keep1", src, tmp, $this.AddTextFileData().apply$default$4()), $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"keep1"}), $this.testImplicits().newStringEncoder()), new FileStreamSourceTest.AddTextFileData($this, "keep2", src, tmp, $this.AddTextFileData().apply$default$4()), $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"keep1", "keep2"}), $this.testImplicits().newStringEncoder()), new FileStreamSourceTest.AddTextFileData($this, "keep3", src, tmp, $this.AddTextFileData().apply$default$4()), $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"keep1", "keep2", "keep3"}), $this.testImplicits().newStringEncoder()), $this.AssertOnQuery().apply("check getBatch", (Function1<StreamExecution, Object>)(Function1 & Serializable & scala.Serializable)execution -> BoxesRunTime.boxToBoolean((boolean)FileStreamSourceSuite.$anonfun$new$178($this, execution)))}));
        });
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$new$184(StreamingQueryProgress x$34) {
        return x$34.numInputRows() > 0L;
    }

    public static final /* synthetic */ boolean $anonfun$new$183(FileStreamSourceSuite $this, StreamExecution query) {
        StreamingQueryProgress actualProgress = (StreamingQueryProgress)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])query.recentProgress())).find((Function1 & Serializable & scala.Serializable)x$34 -> BoxesRunTime.boxToBoolean((boolean)FileStreamSourceSuite.$anonfun$new$184(x$34))).getOrElse((Function0 & Serializable & scala.Serializable)() -> scala.sys.package$.MODULE$.error("Could not find records with data."));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(BoxesRunTime.boxToLong((long)actualProgress.numInputRows()));
        int $org_scalatest_assert_macro_right = 1;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1645));
        double $org_scalatest_assert_macro_left2 = actualProgress.sources()[0].processedRowsPerSecond();
        double $org_scalatest_assert_macro_right2 = 0.0;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left2), ">", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 > $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1646));
        return true;
    }

    public static final /* synthetic */ void $anonfun$new$182(FileStreamSourceSuite $this, File x0$28, File x1$26) {
        Tuple2 tuple2 = new Tuple2((Object)x0$28, (Object)x1$26);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        File src = (File)tuple2._1();
        File tmp = (File)tuple2._2();
        Dataset input = $this.spark().readStream().format("text").load(src.getCanonicalPath());
        $this.testStream(input, $this.testStream$default$2(), (Seq<StreamTest.StreamAction>)Predef$.MODULE$.wrapRefArray((Object[])new StreamTest.StreamAction[]{new FileStreamSourceTest.AddTextFileData($this, "100", src, tmp, $this.AddTextFileData().apply$default$4()), $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"100"}), $this.testImplicits().newStringEncoder()), $this.AssertOnQuery().apply((Function1<StreamExecution, Object>)(Function1 & Serializable & scala.Serializable)query -> BoxesRunTime.boxToBoolean((boolean)FileStreamSourceSuite.$anonfun$new$183($this, query)), $this.AssertOnQuery().apply$default$2())}));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$runTwoBatchesAndVerifyResults$3(FileStreamSourceSuite $this, StreamManualClock clock$1, StreamExecution x$37) {
        $this.eventually($this.timeout($this.streamingTimeout()), (Function0 & Serializable & scala.Serializable)() -> {
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(clock$1.isStreamWaitingAt(0L), "clock.isStreamWaitingAt(0L)", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1714));
        }, $this.patienceConfig(), Retrying$.MODULE$.retryingNatureOfT(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1713));
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$runTwoBatchesAndVerifyResults$5(FileStreamSourceSuite $this, StreamManualClock clock$1, StreamExecution x$38) {
        $this.eventually($this.timeout($this.streamingTimeout()), (Function0 & Serializable & scala.Serializable)() -> {
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(clock$1.isStreamWaitingAt(10L), "clock.isStreamWaitingAt(10L)", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1723));
        }, $this.patienceConfig(), Retrying$.MODULE$.retryingNatureOfT(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1722));
        return true;
    }

    public static final /* synthetic */ void $anonfun$new$191(FileStreamSourceSuite $this, File src) {
        File f1 = package$.MODULE$.stringToFile(new File(src, "1.txt"), "1");
        File f2 = package$.MODULE$.stringToFile(new File(src, "2.txt"), "2");
        f2.setLastModified(f1.lastModified() + 1000L);
        $this.runTwoBatchesAndVerifyResults(src, false, "1", "2", $this.runTwoBatchesAndVerifyResults$default$5(), $this.runTwoBatchesAndVerifyResults$default$6(), $this.runTwoBatchesAndVerifyResults$default$7());
        $this.runTwoBatchesAndVerifyResults(src, true, "2", "1", $this.runTwoBatchesAndVerifyResults$default$5(), $this.runTwoBatchesAndVerifyResults$default$6(), $this.runTwoBatchesAndVerifyResults$default$7());
    }

    public static final /* synthetic */ void $anonfun$new$193(FileStreamSourceSuite $this, File src) {
        File f1 = package$.MODULE$.stringToFile(new File(src, "1.txt"), "1");
        File f2 = package$.MODULE$.stringToFile(new File(src, "2.txt"), "2");
        f2.setLastModified(f1.lastModified() + 3600000L);
        $this.runTwoBatchesAndVerifyResults(src, true, "2", "1", (Option<String>)new Some((Object)"1m"), $this.runTwoBatchesAndVerifyResults$default$6(), $this.runTwoBatchesAndVerifyResults$default$7());
    }

    public static final /* synthetic */ void $anonfun$new$198(FileStreamSourceSuite $this, String scheme$1, File temp) {
        $this.spark().conf().set(new StringBuilder(8).append("fs.").append(scheme$1).append(".impl").toString(), ExistsThrowsExceptionFileSystem.class.getName());
        File dir = new File(temp, "dir");
        FileStreamSourceLog metadataLog = new FileStreamSourceLog(FileStreamSourceLog$.MODULE$.VERSION(), $this.spark(), dir.getAbsolutePath());
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(metadataLog.add(0L, (FileStreamSource.FileEntry[])((Object[])new FileStreamSource.FileEntry[]{new FileStreamSource.FileEntry(new StringBuilder(9).append(scheme$1).append(":///file1").toString(), 100L, 0L)})), "metadataLog.add(0L, scala.Array.apply[org.apache.spark.sql.execution.streaming.FileStreamSource.FileEntry](org.apache.spark.sql.execution.streaming.FileStreamSource.FileEntry.apply(scala.StringContext.apply(\"\", \":///file1\").s(scheme), 100L, 0L))((ClassTag.apply[org.apache.spark.sql.execution.streaming.FileStreamSource.FileEntry](classOf[org.apache.spark.sql.execution.streaming.FileStreamSource$$FileEntry]): scala.reflect.ClassTag[org.apache.spark.sql.execution.streaming.FileStreamSource.FileEntry])))", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1836));
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(metadataLog.add(1L, (FileStreamSource.FileEntry[])((Object[])new FileStreamSource.FileEntry[]{new FileStreamSource.FileEntry(new StringBuilder(9).append(scheme$1).append(":///file2").toString(), 200L, 0L)})), "metadataLog.add(1L, scala.Array.apply[org.apache.spark.sql.execution.streaming.FileStreamSource.FileEntry](org.apache.spark.sql.execution.streaming.FileStreamSource.FileEntry.apply(scala.StringContext.apply(\"\", \":///file2\").s(scheme), 200L, 0L))((ClassTag.apply[org.apache.spark.sql.execution.streaming.FileStreamSource.FileEntry](classOf[org.apache.spark.sql.execution.streaming.FileStreamSource$$FileEntry]): scala.reflect.ClassTag[org.apache.spark.sql.execution.streaming.FileStreamSource.FileEntry])))", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1837));
        FileStreamSource newSource = new FileStreamSource($this.spark(), new StringBuilder(4).append(scheme$1).append(":///").toString(), "parquet", StructType$.MODULE$.apply((Seq)Nil$.MODULE$), (Seq)Nil$.MODULE$, dir.getAbsolutePath(), Predef$.MODULE$.Map().empty());
        newSource.getBatch((Option)None$.MODULE$, (org.apache.spark.sql.execution.streaming.Offset)new FileStreamSourceOffset(1L));
    }

    public static final /* synthetic */ boolean $anonfun$new$201(FileStreamSourceTest.AddTextFileData x$39) {
        return x$39.content() != null;
    }

    private final StreamTest.StreamAction addMultiTextFileData$1(String source1Content, String source2Content, File sourceDir1$1, File tmp$9, File sourceDir2$1) {
        Seq actions = (Seq)((TraversableLike)new .colon.colon((Object)new FileStreamSourceTest.AddTextFileData(this, source1Content, sourceDir1$1, tmp$9, this.AddTextFileData().apply$default$4()), (List)new .colon.colon((Object)new FileStreamSourceTest.AddTextFileData(this, source2Content, sourceDir2$1, tmp$9, this.AddTextFileData().apply$default$4()), (List)Nil$.MODULE$))).filter((Function1 & Serializable & scala.Serializable)x$39 -> BoxesRunTime.boxToBoolean((boolean)FileStreamSourceSuite.$anonfun$new$201(x$39)));
        return new StreamTest.StreamProgressLockedActions(this, (Seq<StreamTest.StreamAction>)actions, actions.mkString("[ ", " | ", " ]"));
    }

    public static final /* synthetic */ void $anonfun$new$200(FileStreamSourceSuite $this, File x0$29, File x1$27) {
        Tuple2 tuple2 = new Tuple2((Object)x0$29, (Object)x1$27);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        File dir = (File)tuple2._1();
        File tmp = (File)tuple2._2();
        File sourceDir1 = new File(dir, "source1");
        File sourceDir2 = new File(dir, "source2");
        sourceDir1.mkdirs();
        sourceDir2.mkdirs();
        Dataset<Row> source1 = $this.createFileStream("text", String.valueOf(sourceDir1.getCanonicalPath()), $this.createFileStream$default$3(), $this.createFileStream$default$4());
        Dataset<Row> source2 = $this.createFileStream("text", String.valueOf(sourceDir2.getCanonicalPath()), $this.createFileStream$default$3(), $this.createFileStream$default$4());
        Dataset unioned = source1.union(source2);
        $this.testStream(unioned, $this.testStream$default$2(), (Seq<StreamTest.StreamAction>)Predef$.MODULE$.wrapRefArray((Object[])new StreamTest.StreamAction[]{new StreamTest.StartStream($this, $this.StartStream().apply$default$1(), $this.StartStream().apply$default$2(), $this.StartStream().apply$default$3(), $this.StartStream().apply$default$4()), $this.addMultiTextFileData$1("source1_0", "source2_0", sourceDir1, tmp, sourceDir2), $this.CheckNewAnswer().apply("source1_0", Predef$.MODULE$.wrapRefArray((Object[])new String[]{"source2_0"}), $this.testImplicits().newStringEncoder()), $this.StopStream(), new StreamTest.StartStream($this, $this.StartStream().apply$default$1(), $this.StartStream().apply$default$2(), $this.StartStream().apply$default$3(), $this.StartStream().apply$default$4()), $this.addMultiTextFileData$1("source1_1", null, sourceDir1, tmp, sourceDir2), $this.CheckNewAnswer().apply("source1_1", Predef$.MODULE$.wrapRefArray((Object[])new String[0]), $this.testImplicits().newStringEncoder()), $this.StopStream(), new StreamTest.StartStream($this, $this.StartStream().apply$default$1(), $this.StartStream().apply$default$2(), $this.StartStream().apply$default$3(), $this.StartStream().apply$default$4()), $this.addMultiTextFileData$1(null, "source2_2", sourceDir1, tmp, sourceDir2), $this.CheckNewAnswer().apply("source2_2", Predef$.MODULE$.wrapRefArray((Object[])new String[0]), $this.testImplicits().newStringEncoder()), $this.StopStream(), new StreamTest.StartStream($this, $this.StartStream().apply$default$1(), $this.StartStream().apply$default$2(), $this.StartStream().apply$default$3(), $this.StartStream().apply$default$4()), $this.addMultiTextFileData$1("source1_3", "source2_3", sourceDir1, tmp, sourceDir2), $this.CheckNewAnswer().apply("source1_3", Predef$.MODULE$.wrapRefArray((Object[])new String[]{"source2_3"}), $this.testImplicits().newStringEncoder()), $this.StopStream()}));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$new$203(FileStreamSourceSuite $this, File temp) {
        StructType schema = StructType$.MODULE$.apply((Seq)new .colon.colon((Object)new StructField("foo", (DataType)LongType$.MODULE$, false, StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$));
        StructType nullableSchema = StructType$.MODULE$.apply((Seq)new .colon.colon((Object)new StructField("foo", (DataType)LongType$.MODULE$, true, StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$));
        StructType streamingSchema = $this.spark().readStream().schema(schema).json(temp.getCanonicalPath()).schema();
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(nullableSchema);
        StructType $org_scalatest_assert_macro_right = streamingSchema;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1899));
        StructType batchSchema = $this.spark().read().schema(schema).json(temp.getCanonicalPath()).schema();
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = $this.convertToEqualizer(batchSchema);
        StructType $org_scalatest_assert_macro_right2 = streamingSchema;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1903));
        $this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.FILE_SOURCE_SCHEMA_FORCE_NULLABLE().key()), (Object)"false")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            StructType streamingSchema = $this.spark().readStream().schema(schema).json(temp.getCanonicalPath()).schema();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(schema);
            StructType $org_scalatest_assert_macro_right = streamingSchema;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1908));
        });
    }

    public static final /* synthetic */ boolean $anonfun$new$208(FileStreamSourceSuite $this, File src$16, StreamExecution x$40) {
        $this.assertFileIsNotRemoved(src$16, "keep1");
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$new$209(FileStreamSourceSuite $this, File src$16, StreamExecution x$41) {
        $this.assertFileIsRemoved(src$16, "keep1");
        $this.assertFileIsNotRemoved(src$16, "ke ep2 %");
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$new$210(FileStreamSourceSuite $this, File src$16, StreamExecution x$42) {
        $this.assertFileIsRemoved(src$16, "ke ep2 %");
        $this.assertFileIsNotRemoved(src$16, "keep3");
        return true;
    }

    public static final /* synthetic */ void $anonfun$new$206(FileStreamSourceSuite $this, File x0$30, File x1$28) {
        Tuple2 tuple2 = new Tuple2((Object)x0$30, (Object)x1$28);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        File src = (File)tuple2._1();
        File tmp = (File)tuple2._2();
        $this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.FILE_SOURCE_LOG_COMPACT_INTERVAL().key()), (Object)"2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.FILE_SOURCE_LOG_CLEANUP_DELAY().key()), (Object)"1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.FILE_SOURCE_CLEANER_NUM_THREADS().key()), (Object)"0")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Map option = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"latestFirst"), (Object)"false"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"maxFilesPerTrigger"), (Object)"1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"cleanSource"), (Object)"delete")}));
            String x$9 = "text";
            String x$10 = src.getCanonicalPath();
            Map x$11 = option;
            Option<StructType> x$12 = $this.createFileStream$default$3();
            Dataset<Row> fileStream = $this.createFileStream(x$9, x$10, x$12, (Map<String, String>)x$11);
            Dataset filtered = fileStream.filter($this.testImplicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value"}))).$((Seq)Nil$.MODULE$).contains((Object)"keep"));
            $this.testStream(filtered, $this.testStream$default$2(), (Seq<StreamTest.StreamAction>)Predef$.MODULE$.wrapRefArray((Object[])new StreamTest.StreamAction[]{new FileStreamSourceTest.AddTextFileData($this, "keep1", src, tmp, "keep1"), $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"keep1"}), $this.testImplicits().newStringEncoder()), $this.AssertOnQuery().apply("input file removed", (Function1<StreamExecution, Object>)(Function1 & Serializable & scala.Serializable)x$40 -> BoxesRunTime.boxToBoolean((boolean)FileStreamSourceSuite.$anonfun$new$208($this, src, x$40))), new FileStreamSourceTest.AddTextFileData($this, "keep2", src, tmp, "ke ep2 %"), $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"keep1", "keep2"}), $this.testImplicits().newStringEncoder()), $this.AssertOnQuery().apply("input file removed", (Function1<StreamExecution, Object>)(Function1 & Serializable & scala.Serializable)x$41 -> BoxesRunTime.boxToBoolean((boolean)FileStreamSourceSuite.$anonfun$new$209($this, src, x$41))), new FileStreamSourceTest.AddTextFileData($this, "keep3", src, tmp, "keep3"), $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"keep1", "keep2", "keep3"}), $this.testImplicits().newStringEncoder()), $this.AssertOnQuery().apply("input file renamed", (Function1<StreamExecution, Object>)(Function1 & Serializable & scala.Serializable)x$42 -> BoxesRunTime.boxToBoolean((boolean)FileStreamSourceSuite.$anonfun$new$210($this, src, x$42)))}));
        });
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$new$214(FileStreamSourceSuite $this, File dirForKeep1$1, File expectedMovedDir1$1, StreamExecution x$43) {
        $this.assertFileIsNotMoved(dirForKeep1$1, expectedMovedDir1$1, "keep1");
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$new$215(FileStreamSourceSuite $this, File dirForKeep1$1, File expectedMovedDir1$1, File dirForKeep2$1, File expectedMovedDir2$1, StreamExecution x$44) {
        $this.assertFileIsMoved(dirForKeep1$1, expectedMovedDir1$1, "keep1");
        $this.assertFileIsNotMoved(dirForKeep2$1, expectedMovedDir2$1, "keep2 %");
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$new$216(FileStreamSourceSuite $this, File dirForKeep2$1, File expectedMovedDir2$1, File dirForKeep3$1, File expectedMovedDir3$1, StreamExecution x$45) {
        $this.assertFileIsMoved(dirForKeep2$1, expectedMovedDir2$1, "keep2 %");
        $this.assertFileIsNotMoved(dirForKeep3$1, expectedMovedDir3$1, "keep3");
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$new$217(FileStreamSourceSuite $this, File dirForKeep3$1, File expectedMovedDir3$1, StreamExecution x$46) {
        $this.assertFileIsMoved(dirForKeep3$1, expectedMovedDir3$1, "keep3");
        $this.assertFileIsNotMoved(dirForKeep3$1, expectedMovedDir3$1, "keep4");
        return true;
    }

    public static final /* synthetic */ void $anonfun$new$212(FileStreamSourceSuite $this, File x0$31, File x1$29, File x2$1) {
        Tuple3 tuple3 = new Tuple3((Object)x0$31, (Object)x1$29, (Object)x2$1);
        if (tuple3 == null) {
            throw new MatchError((Object)tuple3);
        }
        File src = (File)tuple3._1();
        File tmp = (File)tuple3._2();
        File archiveDir = (File)tuple3._3();
        $this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.FILE_SOURCE_LOG_COMPACT_INTERVAL().key()), (Object)"2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.FILE_SOURCE_LOG_CLEANUP_DELAY().key()), (Object)"1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.FILE_SOURCE_CLEANER_NUM_THREADS().key()), (Object)"0")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Map option = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"latestFirst"), (Object)"false"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"maxFilesPerTrigger"), (Object)"1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"cleanSource"), (Object)"archive"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sourceArchiveDir"), (Object)archiveDir.getAbsolutePath())}));
            String x$13 = "text";
            String x$14 = new StringBuilder(4).append(src.getCanonicalPath()).append("/*/*").toString();
            Map x$15 = option;
            Option<StructType> x$16 = $this.createFileStream$default$3();
            Dataset<Row> fileStream = $this.createFileStream(x$13, x$14, x$16, (Map<String, String>)x$15);
            Dataset filtered = fileStream.filter($this.testImplicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value"}))).$((Seq)Nil$.MODULE$).contains((Object)"keep"));
            File dirForKeep1 = new File(src, "k %1");
            File dirForKeep2 = new File(dirForKeep1, "k 2");
            File dirForKeep3 = new File(src, "k3");
            File expectedMovedDir1 = new File(new StringBuilder(0).append(archiveDir.getAbsolutePath()).append(dirForKeep1.toURI().getPath()).toString());
            File expectedMovedDir2 = new File(new StringBuilder(0).append(archiveDir.getAbsolutePath()).append(dirForKeep2.toURI().getPath()).toString());
            File expectedMovedDir3 = new File(new StringBuilder(0).append(archiveDir.getAbsolutePath()).append(dirForKeep3.toURI().getPath()).toString());
            $this.testStream(filtered, $this.testStream$default$2(), (Seq<StreamTest.StreamAction>)Predef$.MODULE$.wrapRefArray((Object[])new StreamTest.StreamAction[]{new FileStreamSourceTest.AddTextFileData($this, "keep1", dirForKeep1, tmp, "keep1"), $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"keep1"}), $this.testImplicits().newStringEncoder()), $this.AssertOnQuery().apply("input file archived", (Function1<StreamExecution, Object>)(Function1 & Serializable & scala.Serializable)x$43 -> BoxesRunTime.boxToBoolean((boolean)FileStreamSourceSuite.$anonfun$new$214($this, dirForKeep1, expectedMovedDir1, x$43))), new FileStreamSourceTest.AddTextFileData($this, "keep2", dirForKeep2, tmp, "keep2 %"), $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"keep1", "keep2"}), $this.testImplicits().newStringEncoder()), $this.AssertOnQuery().apply("input file archived", (Function1<StreamExecution, Object>)(Function1 & Serializable & scala.Serializable)x$44 -> BoxesRunTime.boxToBoolean((boolean)FileStreamSourceSuite.$anonfun$new$215($this, dirForKeep1, expectedMovedDir1, dirForKeep2, expectedMovedDir2, x$44))), new FileStreamSourceTest.AddTextFileData($this, "keep3", dirForKeep3, tmp, "keep3"), $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"keep1", "keep2", "keep3"}), $this.testImplicits().newStringEncoder()), $this.AssertOnQuery().apply("input file archived", (Function1<StreamExecution, Object>)(Function1 & Serializable & scala.Serializable)x$45 -> BoxesRunTime.boxToBoolean((boolean)FileStreamSourceSuite.$anonfun$new$216($this, dirForKeep2, expectedMovedDir2, dirForKeep3, expectedMovedDir3, x$45))), new FileStreamSourceTest.AddTextFileData($this, "keep4", dirForKeep3, tmp, "keep4"), $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"keep1", "keep2", "keep3", "keep4"}), $this.testImplicits().newStringEncoder()), $this.AssertOnQuery().apply("input file archived", (Function1<StreamExecution, Object>)(Function1 & Serializable & scala.Serializable)x$46 -> BoxesRunTime.boxToBoolean((boolean)FileStreamSourceSuite.$anonfun$new$217($this, dirForKeep3, expectedMovedDir3, x$46)))}));
        });
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$new$222(Path path) {
        return path.getName().startsWith("keep1");
    }

    public static final /* synthetic */ void $anonfun$new$223(Throwable t) {
        String $org_scalatest_assert_macro_left = t.getMessage();
        String $org_scalatest_assert_macro_right = "Clean up source files is not supported";
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "startsWith", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.startsWith($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2057));
    }

    public static final /* synthetic */ void $anonfun$new$220(FileStreamSourceSuite $this, String cleanOption$1, File x0$32, File x1$30, File x2$2) {
        Tuple3 tuple3 = new Tuple3((Object)x0$32, (Object)x1$30, (Object)x2$2);
        if (tuple3 == null) {
            throw new MatchError((Object)tuple3);
        }
        File src = (File)tuple3._1();
        File tmp = (File)tuple3._2();
        File archiveDir = (File)tuple3._3();
        $this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.FILE_SOURCE_LOG_COMPACT_INTERVAL().key()), (Object)"2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.FILE_SOURCE_LOG_CLEANUP_DELAY().key()), (Object)"1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.FILE_SOURCE_CLEANER_NUM_THREADS().key()), (Object)"0")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Map option = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"latestFirst"), (Object)"false"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"maxFilesPerTrigger"), (Object)"1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"cleanSource"), (Object)cleanOption$1), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sourceArchiveDir"), (Object)archiveDir.getAbsolutePath())}));
            String x$17 = "text";
            String x$18 = src.getCanonicalPath();
            Map x$19 = option;
            Option<StructType> x$20 = $this.createFileStream$default$3();
            Dataset<Row> fileStream = $this.createFileStream(x$17, x$18, x$20, (Map<String, String>)x$19);
            Dataset filtered = fileStream.filter($this.testImplicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value"}))).$((Seq)Nil$.MODULE$).contains((Object)"keep"));
            FileStreamSinkLog sinkLog = new FileStreamSinkLog(FileStreamSinkLog$.MODULE$.VERSION(), $this.spark(), new File(src, FileStreamSink$.MODULE$.metadataDir()).getCanonicalPath(), FileStreamSinkLog$.MODULE$.$lessinit$greater$default$4());
            Configuration hadoopConf = SparkHadoopUtil$.MODULE$.newConfiguration($this.sparkConf());
            Path srcPath = new Path(src.getCanonicalPath());
            FileSystem fileSystem = srcPath.getFileSystem(hadoopConf);
            $this.testStream(filtered, $this.testStream$default$2(), (Seq<StreamTest.StreamAction>)Predef$.MODULE$.wrapRefArray((Object[])new StreamTest.StreamAction[]{new FileStreamSourceTest.AddTextFileData($this, "keep1", src, tmp, "keep1"), new FileStreamSourceTest.AddFilesToFileStreamSinkLog($this, fileSystem, srcPath, sinkLog, 0, (Function1<Path, Object>)(Function1 & Serializable & scala.Serializable)path -> BoxesRunTime.boxToBoolean((boolean)FileStreamSourceSuite.$anonfun$new$222(path))), new StreamTest.ExpectFailure($this, (Function1<Throwable, BoxedUnit>)(Function1 & Serializable & scala.Serializable)t -> {
                FileStreamSourceSuite.$anonfun$new$223(t);
                return BoxedUnit.UNIT;
            }, false, ClassTag$.MODULE$.apply(UnsupportedOperationException.class))}));
        });
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private final void assertThrowIllegalArgumentException$1(Path sourcePattern, Path baseArchivePath, FakeFileSystem fakeFileSystem$1) {
        this.intercept((Function0 & Serializable & scala.Serializable)() -> new FileStreamSource.SourceFileArchiver((FileSystem)fakeFileSystem$1, sourcePattern, (FileSystem)fakeFileSystem$1, baseArchivePath), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2103));
    }

    public static final /* synthetic */ boolean $anonfun$new$232(long batchId$2, FileStreamSource.FileEntry x$53) {
        return x$53.batchId() == batchId$2;
    }

    private final void verifyBatch$1(FileStreamSourceOffset offset, long expectedBatchId, Seq inputFiles, int expectedListingCount, FileStreamSourceLog metadataLog$1, File src$19) {
        long batchId = offset.logOffset();
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToLong((long)batchId));
        long $org_scalatest_assert_macro_right = expectedBatchId;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2192));
        FileStreamSource.FileEntry[] files = (FileStreamSource.FileEntry[])metadataLog$1.get(batchId).getOrElse((Function0 & Serializable & scala.Serializable)() -> (FileStreamSource.FileEntry[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(FileStreamSource.FileEntry.class)));
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])files)).forall((Function1 & Serializable & scala.Serializable)x$53 -> BoxesRunTime.boxToBoolean((boolean)FileStreamSourceSuite.$anonfun$new$232(batchId, x$53))), "scala.Predef.refArrayOps[org.apache.spark.sql.execution.streaming.FileStreamSource.FileEntry](files).forall(((x$53: org.apache.spark.sql.execution.streaming.FileStreamSource.FileEntry) => x$53.batchId.==(batchId)))", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2195));
        String[] actualInputFiles = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])files)).map((Function1 & Serializable & scala.Serializable)p -> new Path(p.path()).toUri().getPath(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        Seq expectedInputFiles = (Seq)((TraversableLike)inputFiles.slice((int)batchId * 10, (int)batchId * 10 + 10)).map((Function1 & Serializable & scala.Serializable)x$54 -> x$54.getCanonicalPath(), Seq$.MODULE$.canBuildFrom());
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(actualInputFiles);
        Seq $org_scalatest_assert_macro_right2 = expectedInputFiles;
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2200));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)expectedListingCount));
        Object $org_scalatest_assert_macro_right3 = CountListingLocalFileSystem$.MODULE$.pathToNumListStatusCalled().get((Object)src$19.getCanonicalPath()).map((Function1 & Serializable & scala.Serializable)x$55 -> BoxesRunTime.boxToLong((long)x$55.get())).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0);
        Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", $org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq($org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2202));
    }

    public static final /* synthetic */ File $anonfun$new$237(FileStreamSourceSuite $this, File src$19, File tmp$13, int idx) {
        File f = $this.createFile(Integer.toString(idx), new File(src$19, Integer.toString(idx)), tmp$13);
        f.setLastModified(idx * 10000);
        return f;
    }

    public static final /* synthetic */ void $anonfun$new$230(FileStreamSourceSuite $this, File x0$33, File x1$31, File x2$3) {
        Tuple3 tuple3 = new Tuple3((Object)x0$33, (Object)x1$31, (Object)x2$3);
        if (tuple3 == null) {
            throw new MatchError((Object)tuple3);
        }
        File src = (File)tuple3._1();
        File meta = (File)tuple3._2();
        File tmp = (File)tuple3._3();
        Map options = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"latestFirst"), (Object)"false"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"maxFilesPerTrigger"), (Object)"10")}));
        String scheme = CountListingLocalFileSystem$.MODULE$.scheme();
        FileStreamSource source = new FileStreamSource($this.spark(), new StringBuilder(8).append(scheme).append(":///").append(src.getCanonicalPath()).append("/*/*").toString(), "text", StructType$.MODULE$.apply((Seq)Nil$.MODULE$), (Seq)Nil$.MODULE$, meta.getCanonicalPath(), options);
        PrivateMethodTester.PrivateMethod _metadataLog = $this.PrivateMethod().apply((Symbol)SymbolLiteral.bootstrap("apply", "metadataLog"));
        FileStreamSourceLog metadataLog = (FileStreamSourceLog)$this.anyRefToInvoker(source).invokePrivate(_metadataLog.apply((Seq)Nil$.MODULE$));
        CountListingLocalFileSystem$.MODULE$.resetCount();
        IndexedSeq inputFiles = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 40).map((Function1 & Serializable & scala.Serializable)idx -> FileStreamSourceSuite.$anonfun$new$237($this, src, tmp, BoxesRunTime.unboxToInt((Object)idx)), IndexedSeq$.MODULE$.canBuildFrom());
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 3).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)batchId -> {
            FileStreamSourceOffset offsetBatch = (FileStreamSourceOffset)source.latestOffset((Offset)new FileStreamSourceOffset(-1L), ReadLimit.maxFiles((int)10));
            $this.verifyBatch$1(offsetBatch, batchId, (Seq)inputFiles, 1, metadataLog, src);
        });
        FileStreamSourceOffset offsetBatch = (FileStreamSourceOffset)source.latestOffset((Offset)new FileStreamSourceOffset(-1L), ReadLimit.maxFiles((int)10));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(BoxesRunTime.boxToInteger((int)4));
        long $org_scalatest_assert_macro_right = offsetBatch.logOffset();
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2227));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = $this.convertToEqualizer(BoxesRunTime.boxToInteger((int)2));
        Object $org_scalatest_assert_macro_right2 = CountListingLocalFileSystem$.MODULE$.pathToNumListStatusCalled().get((Object)src.getCanonicalPath()).map((Function1 & Serializable & scala.Serializable)x$56 -> BoxesRunTime.boxToLong((long)x$56.get())).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0);
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", $org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq($org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2228));
        FileStreamSourceOffset offsetBatch2 = (FileStreamSourceOffset)source.latestOffset((Offset)new FileStreamSourceOffset(-1L), ReadLimit.maxFiles((int)10));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = $this.convertToEqualizer(BoxesRunTime.boxToInteger((int)4));
        long $org_scalatest_assert_macro_right3 = offsetBatch2.logOffset();
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2234));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = $this.convertToEqualizer(BoxesRunTime.boxToInteger((int)3));
        Object $org_scalatest_assert_macro_right4 = CountListingLocalFileSystem$.MODULE$.pathToNumListStatusCalled().get((Object)src.getCanonicalPath()).map((Function1 & Serializable & scala.Serializable)x$57 -> BoxesRunTime.boxToLong((long)x$57.get())).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0);
        Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", $org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq($org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2236));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ File $anonfun$new$246(FileStreamSourceSuite $this, File src$20, File tmp$14, int idx) {
        File f = $this.createFile(Integer.toString(idx), new File(src$20, Integer.toString(idx)), tmp$14);
        f.setLastModified(idx * 10000);
        return f;
    }

    public static final /* synthetic */ void $anonfun$new$245(FileStreamSourceSuite $this, File x0$34, File x1$32, File x2$4) {
        Tuple3 tuple3 = new Tuple3((Object)x0$34, (Object)x1$32, (Object)x2$4);
        if (tuple3 == null) {
            throw new MatchError((Object)tuple3);
        }
        File src = (File)tuple3._1();
        File meta = (File)tuple3._2();
        File tmp = (File)tuple3._3();
        Map options = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"latestFirst"), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"maxFilesPerTrigger"), (Object)"5")}));
        String scheme = CountListingLocalFileSystem$.MODULE$.scheme();
        FileStreamSource source = new FileStreamSource($this.spark(), new StringBuilder(8).append(scheme).append(":///").append(src.getCanonicalPath()).append("/*/*").toString(), "text", StructType$.MODULE$.apply((Seq)Nil$.MODULE$), (Seq)Nil$.MODULE$, meta.getCanonicalPath(), options);
        CountListingLocalFileSystem$.MODULE$.resetCount();
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 19).map((Function1 & Serializable & scala.Serializable)idx -> FileStreamSourceSuite.$anonfun$new$246($this, src, tmp, BoxesRunTime.unboxToInt((Object)idx)), IndexedSeq$.MODULE$.canBuildFrom());
        FileStreamSourceOffset cfr_ignored_0 = (FileStreamSourceOffset)source.latestOffset((Offset)new FileStreamSourceOffset(-1L), ReadLimit.maxFiles((int)5));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(BoxesRunTime.boxToInteger((int)1));
        Object $org_scalatest_assert_macro_right = CountListingLocalFileSystem$.MODULE$.pathToNumListStatusCalled().get((Object)src.getCanonicalPath()).map((Function1 & Serializable & scala.Serializable)x$58 -> BoxesRunTime.boxToLong((long)x$58.get())).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0);
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", $org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq($org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2261));
        FileStreamSourceOffset cfr_ignored_1 = (FileStreamSourceOffset)source.latestOffset((Offset)new FileStreamSourceOffset(-1L), ReadLimit.maxFiles((int)5));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = $this.convertToEqualizer(BoxesRunTime.boxToInteger((int)2));
        Object $org_scalatest_assert_macro_right2 = CountListingLocalFileSystem$.MODULE$.pathToNumListStatusCalled().get((Object)src.getCanonicalPath()).map((Function1 & Serializable & scala.Serializable)x$59 -> BoxesRunTime.boxToLong((long)x$59.get())).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0);
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", $org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq($org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2269));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private static final String formatTime$1(LocalDateTime time) {
        return time.format(DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss"));
    }

    public static final /* synthetic */ void $anonfun$new$252(ObjectRef dsReader$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String k = (String)tuple2._1();
        String v = (String)tuple2._2();
        dsReader$1.elem = ((DataStreamReader)dsReader$1.elem).option(k, v);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$new$253(Throwable t) {
        String $org_scalatest_assert_macro_left = t.getMessage();
        String $org_scalatest_assert_macro_right = "is not allowed in file stream source";
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2293));
    }

    private final void assertOptionIsNotSupported$1(Map options, String path) {
        StructType schema = StructType$.MODULE$.apply((Seq)new .colon.colon((Object)new StructField("a", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$));
        ObjectRef dsReader = ObjectRef.create((Object)this.spark().readStream().format("csv").option("timeZone", "UTC").schema(schema));
        options.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            FileStreamSourceSuite.$anonfun$new$252(dsReader, x0$1);
            return BoxedUnit.UNIT;
        });
        Dataset df = ((DataStreamReader)dsReader.elem).load(path);
        this.testStream(df, this.testStream$default$2(), (Seq<StreamTest.StreamAction>)Predef$.MODULE$.wrapRefArray((Object[])new StreamTest.StreamAction[]{new StreamTest.ExpectFailure(this, (Function1<Throwable, BoxedUnit>)(Function1 & Serializable & scala.Serializable)t -> {
            FileStreamSourceSuite.$anonfun$new$253(t);
            return BoxedUnit.UNIT;
        }, false, ClassTag$.MODULE$.apply(IllegalArgumentException.class))}));
    }

    public static final /* synthetic */ void $anonfun$new$254(FileStreamSourceSuite $this, File dir) {
        LocalDateTime futureTime = LocalDateTime.now(ZoneOffset.UTC).plusYears(1L);
        String formattedFutureTime = FileStreamSourceSuite.formatTime$1(futureTime);
        $this.assertOptionIsNotSupported$1((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"modifiedBefore"), (Object)formattedFutureTime)})), dir.getCanonicalPath());
        LocalDateTime prevTime = LocalDateTime.now(ZoneOffset.UTC).minusYears(1L);
        String formattedPrevTime = FileStreamSourceSuite.formatTime$1(prevTime);
        $this.assertOptionIsNotSupported$1((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"modifiedAfter"), (Object)formattedPrevTime)})), dir.getCanonicalPath());
        $this.assertOptionIsNotSupported$1((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"modifiedBefore"), (Object)formattedFutureTime), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"modifiedAfter"), (Object)formattedPrevTime)})), dir.getCanonicalPath());
    }

    public static final /* synthetic */ void $anonfun$new$257(FileStreamSourceSuite $this, DataType schema$2, File dir) {
        String colName = "col";
        String msg = "can only contain STRING as a key type for a MAP";
        AnalysisException thrown1 = (AnalysisException)((Object)$this.intercept((Function0 & Serializable & scala.Serializable)() -> $this.spark().readStream().schema(StructType$.MODULE$.apply((Seq)new .colon.colon((Object)new StructField(colName, schema$2, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$))).json(dir.getCanonicalPath()).schema(), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2337)));
        String $org_scalatest_assert_macro_left = thrown1.getMessage();
        String $org_scalatest_assert_macro_right = msg;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2340));
    }

    public FileStreamSourceSuite() {
        this.test("FileStreamSource schema: no path", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.STREAMING_SCHEMA_INFERENCE().key()), (Object)"false")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.testError$1());
            this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.STREAMING_SCHEMA_INFERENCE().key()), (Object)"true")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.testError$1());
        }, new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 273));
        this.test("FileStreamSource schema: path doesn't exist (without schema) should throw exception", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)dir -> {
            this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                StructType userSchema = new StructType().add(new StructField("value", (DataType)IntegerType$.MODULE$, StructField$.MODULE$.$lessinit$greater$default$3(), StructField$.MODULE$.$lessinit$greater$default$4()));
                StructType structType = $this.createFileStreamSourceAndGetSchema((Option<String>)None$.MODULE$, (Option<String>)new Some((Object)new File(dir, "1").getAbsolutePath()), (Option<StructType>)None$.MODULE$);
            }, ClassTag$.MODULE$.apply(AnalysisException.class), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 286));
            return BoxedUnit.UNIT;
        }), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 284));
        this.test("FileStreamSource schema: path doesn't exist (with schema) should throw exception", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)dir -> {
            this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                StructType userSchema = new StructType().add(new StructField("value", (DataType)IntegerType$.MODULE$, StructField$.MODULE$.$lessinit$greater$default$3(), StructField$.MODULE$.$lessinit$greater$default$4()));
                StructType structType = $this.createFileStreamSourceAndGetSchema((Option<String>)None$.MODULE$, (Option<String>)new Some((Object)new File(dir, "1").getAbsolutePath()), (Option<StructType>)new Some((Object)userSchema));
            }, ClassTag$.MODULE$.apply(AnalysisException.class), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 296));
            return BoxedUnit.UNIT;
        }), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 294));
        this.test("FileStreamSource schema: text, no existing files, no schema", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)src -> {
            FileStreamSourceSuite.$anonfun$new$12(this, src);
            return BoxedUnit.UNIT;
        }), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 307));
        this.test("FileStreamSource schema: text, existing files, no schema", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)src -> {
            FileStreamSourceSuite.$anonfun$new$14(this, src);
            return BoxedUnit.UNIT;
        }), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 315));
        this.test("FileStreamSource schema: text, existing files, schema", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)src -> {
            FileStreamSourceSuite.$anonfun$new$16(this, src);
            return BoxedUnit.UNIT;
        }), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 324));
        this.test("FileStreamSource schema: orc, existing files, no schema", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)src -> {
            FileStreamSourceSuite.$anonfun$new$18(this, src);
            return BoxedUnit.UNIT;
        }), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 336));
        this.test("FileStreamSource schema: orc, existing files, schema", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)src -> {
            FileStreamSourceSuite.$anonfun$new$23(this, src);
            return BoxedUnit.UNIT;
        }), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 359));
        this.test("FileStreamSource schema: parquet, existing files, no schema", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)src -> {
            FileStreamSourceSuite.$anonfun$new$25(this, src);
            return BoxedUnit.UNIT;
        }), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 372));
        this.test("FileStreamSource schema: parquet, existing files, schema", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)src -> {
            FileStreamSourceSuite.$anonfun$new$30(this, src);
            return BoxedUnit.UNIT;
        }), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 395));
        this.test("FileStreamSource schema: json, no existing files, no schema", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)src -> {
            this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.STREAMING_SCHEMA_INFERENCE().key()), (Object)"true")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                AnalysisException e = (AnalysisException)((Object)((Object)$this.intercept((Function0 & Serializable & scala.Serializable)() -> $this.createFileStreamSourceAndGetSchema((Option<String>)new Some((Object)"json"), (Option<String>)new Some((Object)src.getCanonicalPath()), (Option<StructType>)None$.MODULE$), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 412))));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer("Unable to infer schema for JSON. It must be specified manually.");
                String $org_scalatest_assert_macro_right = e.getMessage();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 416));
            });
            return BoxedUnit.UNIT;
        }), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 408));
        this.test("FileStreamSource schema: json, existing files, no schema", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)src -> {
            FileStreamSourceSuite.$anonfun$new$36(this, src);
            return BoxedUnit.UNIT;
        }), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 421));
        this.test("FileStreamSource schema: json, existing files, schema", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)src -> {
            FileStreamSourceSuite.$anonfun$new$41(this, src);
            return BoxedUnit.UNIT;
        }), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 442));
        this.test("read from text files", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDirs((Function2<File, File, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
            FileStreamSourceSuite.$anonfun$new$43(this, x0$1, x1$1);
            return BoxedUnit.UNIT;
        }), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 454));
        this.test("SPARK-21996 read from text files -- file name has space", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDirs((Function2<File, File, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(x0$2, x1$2) -> {
            FileStreamSourceSuite.$anonfun$new$45(this, x0$2, x1$2);
            return BoxedUnit.UNIT;
        }), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 472));
        this.test("SPARK-21996 read from text files generated by file sink -- file name has space", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String testTableName = "FileStreamSourceTest";
            this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{testTableName}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDirs((Function2<File, File, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(x0$3, x1$3) -> {
                FileStreamSourceSuite.$anonfun$new$48(this, testTableName, x0$3, x1$3);
                return BoxedUnit.UNIT;
            }));
        }, new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 484));
        this.test("Option pathGlobFilter", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String testTableName = "FileStreamSourceTest";
            this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{testTableName}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)output -> {
                FileStreamSourceSuite.$anonfun$new$53(this, testTableName, output);
                return BoxedUnit.UNIT;
            }));
        }, new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 518));
        this.test("SPARK-31935: Hadoop file system config should be effective in data source options", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)dir -> {
            FileStreamSourceSuite.$anonfun$new$56(this, dir);
            return BoxedUnit.UNIT;
        }), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 537));
        this.test("read from textfile", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDirs((Function2<File, File, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(x0$4, x1$4) -> {
            FileStreamSourceSuite.$anonfun$new$60(this, x0$4, x1$4);
            return BoxedUnit.UNIT;
        }), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 549));
        this.test("SPARK-17165 should not track the list of seen files indefinitely", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDirs((Function2<File, File, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(x0$5, x1$5) -> {
            FileStreamSourceSuite.$anonfun$new$63(this, x0$5, x1$5);
            return BoxedUnit.UNIT;
        }), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 567));
        this.test("read from json files", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDirs((Function2<File, File, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(x0$6, x1$6) -> {
            FileStreamSourceSuite.$anonfun$new$67(this, x0$6, x1$6);
            return BoxedUnit.UNIT;
        }), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 603));
        this.test("read from json files with inferring schema", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDirs((Function2<File, File, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(x0$7, x1$7) -> {
            FileStreamSourceSuite.$anonfun$new$69(this, x0$7, x1$7);
            return BoxedUnit.UNIT;
        }), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 630));
        this.test("reading from json files inside partitioned directory", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDirs((Function2<File, File, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(x0$8, x1$8) -> {
            FileStreamSourceSuite.$anonfun$new$72(this, x0$8, x1$8);
            return BoxedUnit.UNIT;
        }), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 651));
        this.test("reading from json files with changing schema", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDirs((Function2<File, File, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(x0$9, x1$9) -> {
            FileStreamSourceSuite.$anonfun$new$75(this, x0$9, x1$9);
            return BoxedUnit.UNIT;
        }), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 673));
        this.test("read from orc files", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDirs((Function2<File, File, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(x0$10, x1$10) -> {
            FileStreamSourceSuite.$anonfun$new$78(this, x0$10, x1$10);
            return BoxedUnit.UNIT;
        }), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 708));
        this.test("read from orc files with changing schema", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDirs((Function2<File, File, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(x0$11, x1$11) -> {
            FileStreamSourceSuite.$anonfun$new$80(this, x0$11, x1$11);
            return BoxedUnit.UNIT;
        }), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 726));
        this.test("read from parquet files", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDirs((Function2<File, File, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(x0$12, x1$12) -> {
            FileStreamSourceSuite.$anonfun$new$83(this, x0$12, x1$12);
            return BoxedUnit.UNIT;
        }), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 761));
        this.test("read from parquet files with changing schema", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDirs((Function2<File, File, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(x0$13, x1$13) -> {
            FileStreamSourceSuite.$anonfun$new$85(this, x0$13, x1$13);
            return BoxedUnit.UNIT;
        }), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 779));
        this.test("read new files in nested directories with globbing", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDirs((Function2<File, File, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(x0$14, x1$14) -> {
            FileStreamSourceSuite.$anonfun$new$88(this, x0$14, x1$14);
            return BoxedUnit.UNIT;
        }), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 815));
        this.test("read new files in partitioned table with globbing, should not read partition data", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDirs((Function2<File, File, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(x0$15, x1$15) -> {
            FileStreamSourceSuite.$anonfun$new$90(this, x0$15, x1$15);
            return BoxedUnit.UNIT;
        }), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 859));
        this.test("read new files in partitioned table without globbing, should read partition data", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDirs((Function2<File, File, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(x0$16, x1$16) -> {
            FileStreamSourceSuite.$anonfun$new$92(this, x0$16, x1$16);
            return BoxedUnit.UNIT;
        }), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 890));
        this.test("read data from outputs of another streaming query", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.FILE_SINK_LOG_COMPACT_INTERVAL().key()), (Object)"3")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDirs((Function2<File, File, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(x0$17, x1$17) -> {
            FileStreamSourceSuite.$anonfun$new$95(this, x0$17, x1$17);
            return BoxedUnit.UNIT;
        })), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 918));
        this.test("SPARK-35565: read data from outputs of another streaming query but ignore its metadata", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.FILE_SINK_LOG_COMPACT_INTERVAL().key()), (Object)"3"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.FILESTREAM_SINK_METADATA_IGNORED().key()), (Object)"true")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDirs((Function2<File, File, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(x0$18, x1$18) -> {
            FileStreamSourceSuite.$anonfun$new$103(this, x0$18, x1$18);
            return BoxedUnit.UNIT;
        })), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 975));
        this.test("start before another streaming query, and read its output", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDirs((Function2<File, File, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(x0$19, x1$19) -> {
            FileStreamSourceSuite.$anonfun$new$110(this, x0$19, x1$19);
            return BoxedUnit.UNIT;
        }), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1044));
        this.test("when schema inference is turned on, should read partition data", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.STREAMING_SCHEMA_INFERENCE().key()), (Object)"true")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDirs((Function2<File, File, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(x0$20, x1$20) -> {
            FileStreamSourceSuite.$anonfun$new$117(this, x0$20, x1$20);
            return BoxedUnit.UNIT;
        })), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1082));
        this.test("fault tolerance", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDirs((Function2<File, File, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(x0$21, x1$21) -> {
            FileStreamSourceSuite.$anonfun$new$119(this, x0$21, x1$21);
            return BoxedUnit.UNIT;
        }), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1118));
        this.test("max files per trigger", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)x0$22 -> {
            FileStreamSourceSuite.$anonfun$new$121(this, x0$22);
            return BoxedUnit.UNIT;
        }), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1136));
        this.testQuietly("max files per trigger - incorrect values", (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String testTable = "maxFilesPerTrigger_test";
            this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{testTable}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)x0$23 -> {
                FileStreamSourceSuite.$anonfun$new$130(this, testTable, x0$23);
                return BoxedUnit.UNIT;
            }));
        });
        this.test("SPARK-30669: maxFilesPerTrigger - ignored when using Trigger.Once", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDirs((Function2<File, File, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(src, target) -> {
            FileStreamSourceSuite.$anonfun$new$134(this, src, target);
            return BoxedUnit.UNIT;
        }), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1251));
        this.test("SPARK-36533: Trigger.AvailableNow - multiple queries with checkpoint", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDirs((Function2<File, File, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(src, target) -> {
            FileStreamSourceSuite.$anonfun$new$142(this, src, target);
            return BoxedUnit.UNIT;
        }), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1307));
        this.test("explain", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDirs((Function2<File, File, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(x0$24, x1$22) -> {
            FileStreamSourceSuite.$anonfun$new$147(this, x0$24, x1$22);
            return BoxedUnit.UNIT;
        }), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1389));
        this.test("SPARK-17372 - write file names to WAL as Array[String]", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            int numFiles = 10000;
            this.spark().sessionState().conf().setConf(SQLConf$.MODULE$.PARALLEL_PARTITION_DISCOVERY_THRESHOLD(), (Object)BoxesRunTime.boxToInteger((int)(numFiles * 2)));
            this.withTempDirs((Function2<File, File, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(x0$25, x1$23) -> {
                FileStreamSourceSuite.$anonfun$new$150(this, numFiles, x0$25, x1$23);
                return BoxedUnit.UNIT;
            });
        }, new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1426));
        this.test("compact interval metadata log", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            PrivateMethodTester.PrivateMethod _sources = this.PrivateMethod().apply((Symbol)SymbolLiteral.bootstrap("apply", "sources"));
            PrivateMethodTester.PrivateMethod _metadataLog = this.PrivateMethod().apply((Symbol)SymbolLiteral.bootstrap("apply", "metadataLog"));
            this.withTempDirs((Function2<File, File, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(x0$26, x1$24) -> {
                FileStreamSourceSuite.$anonfun$new$159(this, _metadataLog, x0$26, x1$24);
                return BoxedUnit.UNIT;
            });
        }, new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1462));
        this.test("restore from file stream source log", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.FILE_SOURCE_LOG_COMPACT_INTERVAL().key()), (Object)"5")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)chk -> {
            FileStreamSourceSuite.$anonfun$new$172(this, chk);
            return BoxedUnit.UNIT;
        })), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1530));
        this.test("get arbitrary batch from FileStreamSource", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDirs((Function2<File, File, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(x0$27, x1$25) -> {
            FileStreamSourceSuite.$anonfun$new$176(this, x0$27, x1$25);
            return BoxedUnit.UNIT;
        }), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1594));
        this.test("input row metrics", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDirs((Function2<File, File, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(x0$28, x1$26) -> {
            FileStreamSourceSuite.$anonfun$new$182(this, x0$28, x1$26);
            return BoxedUnit.UNIT;
        }), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1635));
        this.test("SPARK-18433: Improve DataSource option keys to be more case-insensitive", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            FileStreamOptions options = new FileStreamOptions((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"maxfilespertrigger"), (Object)"1")})));
            Option $org_scalatest_assert_macro_left = options.maxFilesPerTrigger();
            Some $org_scalatest_assert_macro_right = new Some((Object)BoxesRunTime.boxToInteger((int)1));
            Option option = $org_scalatest_assert_macro_left;
            Some some = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(option != null ? !option.equals(some) : some != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1655));
        }, new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1653));
        this.test("FileStreamSource offset - read Spark 2.1.0 offset json format", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            SerializedOffset offset = this.readOffsetFromResource("file-source-offset-version-2.1.0-json.txt");
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(FileStreamSourceOffset$.MODULE$.apply((org.apache.spark.sql.execution.streaming.Offset)offset));
            FileStreamSourceOffset $org_scalatest_assert_macro_right = new FileStreamSourceOffset(345L);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1660));
        }, new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1658));
        this.test("FileStreamSource offset - read Spark 2.1.0 offset long format", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            SerializedOffset offset = this.readOffsetFromResource("file-source-offset-version-2.1.0-long.txt");
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(FileStreamSourceOffset$.MODULE$.apply((org.apache.spark.sql.execution.streaming.Offset)offset));
            FileStreamSourceOffset $org_scalatest_assert_macro_right = new FileStreamSourceOffset(345L);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1665));
        }, new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1663));
        this.test("FileStreamSourceLog - read Spark 2.1.0 log format", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(this.readLogFromResource("file-source-log-version-2.1.0"));
            Seq $org_scalatest_assert_macro_right = (Seq)new .colon.colon((Object)new FileStreamSource.FileEntry("/a/b/0", 1480730949000L, 0L), (List)new .colon.colon((Object)new FileStreamSource.FileEntry("/a/b/1", 1480730950000L, 1L), (List)new .colon.colon((Object)new FileStreamSource.FileEntry("/a/b/2", 1480730950000L, 2L), (List)new .colon.colon((Object)new FileStreamSource.FileEntry("/a/b/3", 1480730950000L, 3L), (List)new .colon.colon((Object)new FileStreamSource.FileEntry("/a/b/4", 1480730951000L, 4L), (List)Nil$.MODULE$)))));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1669));
        }, new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1668));
        this.test("FileStreamSource - latestFirst", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)src -> {
            FileStreamSourceSuite.$anonfun$new$191(this, src);
            return BoxedUnit.UNIT;
        }), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1731));
        this.test("SPARK-19813: Ignore maxFileAge when maxFilesPerTrigger and latestFirst is used", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)src -> {
            FileStreamSourceSuite.$anonfun$new$193(this, src);
            return BoxedUnit.UNIT;
        }), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1746));
        this.test("SeenFilesMap", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            FileStreamSource.SeenFilesMap map = new FileStreamSource.SeenFilesMap(10L, false);
            map.add("a", 5L);
            FileStreamSource.SeenFilesMap $org_scalatest_assert_macro_left = map;
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1762));
            map.purge();
            FileStreamSource.SeenFilesMap $org_scalatest_assert_macro_left2 = map;
            int $org_scalatest_assert_macro_right2 = 1;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left2, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1764));
            map.add("b", 15L);
            FileStreamSource.SeenFilesMap $org_scalatest_assert_macro_left3 = map;
            int $org_scalatest_assert_macro_right3 = 2;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left3, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left3.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1768));
            map.purge();
            FileStreamSource.SeenFilesMap $org_scalatest_assert_macro_left4 = map;
            int $org_scalatest_assert_macro_right4 = 2;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left4, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left4.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1770));
            map.add("c", 16L);
            FileStreamSource.SeenFilesMap $org_scalatest_assert_macro_left5 = map;
            int $org_scalatest_assert_macro_right5 = 3;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left5, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left5.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1774));
            map.purge();
            FileStreamSource.SeenFilesMap $org_scalatest_assert_macro_left6 = map;
            int $org_scalatest_assert_macro_right6 = 2;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left6, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left6.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1776));
            map.add("c", 25L);
            FileStreamSource.SeenFilesMap $org_scalatest_assert_macro_left7 = map;
            int $org_scalatest_assert_macro_right7 = 2;
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left7, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left7.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right7), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1780));
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(map.isNewFile("c", 20L), "map.isNewFile(\"c\", 20L)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1783));
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(map.isNewFile("d", 5L), "map.isNewFile(\"d\", 5L)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1786));
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.simpleMacroBool(map.isNewFile("e", 20L), "map.isNewFile(\"e\", 20L)", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1789));
        }, new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1758));
        this.test("SeenFilesMap with fileNameOnly = true", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            FileStreamSource.SeenFilesMap map = new FileStreamSource.SeenFilesMap(10L, true);
            map.add("file:///a/b/c/d", 5L);
            map.add("file:///a/b/c/e", 5L);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)map.size()));
            int $org_scalatest_assert_macro_right = 2;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1797));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(map.isNewFile("d", 5L), "map.isNewFile(\"d\", 5L)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1799));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(map.isNewFile("file:///d", 5L), "map.isNewFile(\"file:///d\", 5L)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1800));
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(map.isNewFile("file:///x/d", 5L), "map.isNewFile(\"file:///x/d\", 5L)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1801));
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(map.isNewFile("file:///x/y/d", 5L), "map.isNewFile(\"file:///x/y/d\", 5L)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1802));
            map.add("s3:///bucket/d", 5L);
            map.add("s3n:///bucket/d", 5L);
            map.add("s3a:///bucket/d", 5L);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)map.size()));
            int $org_scalatest_assert_macro_right2 = 2;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1807));
        }, new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1792));
        this.test("SeenFilesMap should only consider a file old if it is earlier than last purge time", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            FileStreamSource.SeenFilesMap map = new FileStreamSource.SeenFilesMap(10L, false);
            map.add("a", 20L);
            FileStreamSource.SeenFilesMap $org_scalatest_assert_macro_left = map;
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1814));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(map.isNewFile("b", 9L), "map.isNewFile(\"b\", 9L)", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1817));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(map.isNewFile("b", 10L), "map.isNewFile(\"b\", 10L)", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1818));
            map.purge();
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(map.isNewFile("b", 9L), "map.isNewFile(\"b\", 9L)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1822));
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.simpleMacroBool(map.isNewFile("b", 10L), "map.isNewFile(\"b\", 10L)", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1823));
        }, new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1810));
        this.test("do not recheck that files exist during getBatch", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String scheme = ExistsThrowsExceptionFileSystem$.MODULE$.scheme();
            this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)temp -> {
                FileStreamSourceSuite.$anonfun$new$198(this, scheme, temp);
                return BoxedUnit.UNIT;
            });
        }, new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1826));
        this.test("SPARK-26629: multiple file sources work with restarts when a source does not have data", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDirs((Function2<File, File, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(x0$29, x1$27) -> {
            FileStreamSourceSuite.$anonfun$new$200(this, x0$29, x1$27);
            return BoxedUnit.UNIT;
        }), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1846));
        this.test("SPARK-28651: force streaming file source to be nullable", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)temp -> {
            FileStreamSourceSuite.$anonfun$new$203(this, temp);
            return BoxedUnit.UNIT;
        }), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1894));
        this.test("remove completed files when remove option is enabled", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDirs((Function2<File, File, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(x0$30, x1$28) -> {
            FileStreamSourceSuite.$anonfun$new$206(this, x0$30, x1$28);
            return BoxedUnit.UNIT;
        }), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1913));
        this.test("move completed files to archive directory when archive option is enabled", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withThreeTempDirs((Function3<File, File, File, BoxedUnit>)(Function3 & Serializable & scala.Serializable)(x0$31, x1$29, x2$1) -> {
            FileStreamSourceSuite.$anonfun$new$212(this, x0$31, x1$29, x2$1);
            return BoxedUnit.UNIT;
        }), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1958));
        ((IterableLike)new .colon.colon((Object)"delete", (List)new .colon.colon((Object)"archive", (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)cleanOption -> {
            this.test(new StringBuilder(108).append("Throw UnsupportedOperationException on configuring ").append(cleanOption).append(" when source path").append(" refers the output dir of FileStreamSink").toString(), (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withThreeTempDirs((Function3<File, File, File, BoxedUnit>)(Function3 & Serializable & scala.Serializable)(x0$32, x1$30, x2$2) -> {
                FileStreamSourceSuite.$anonfun$new$220($this, cleanOption, x0$32, x1$30, x2$2);
                return BoxedUnit.UNIT;
            }), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2028));
            return BoxedUnit.UNIT;
        });
        this.test("SourceFileArchiver - fail when base archive path matches source pattern", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            FakeFileSystem fakeFileSystem = new FakeFileSystem(this, "fake");
            Path sourcePatternPath = new Path("/hello*/spar?");
            Path baseArchiveDirPath = new Path("/hello/spark/structured/streaming");
            this.assertThrowIllegalArgumentException$1(sourcePatternPath, baseArchiveDirPath, fakeFileSystem);
            Path sourcePatternPath2 = new Path("/hello*/spar?/structured/streaming");
            Path baseArchiveDirPath2 = new Path("/hello/spark/structured");
            this.assertThrowIllegalArgumentException$1(sourcePatternPath2, baseArchiveDirPath2, fakeFileSystem);
            Path sourcePatternPath3 = new Path("/hello*/spar?/structured/*");
            Path baseArchiveDirPath3 = new Path("/hello/spark/structured/streaming");
            this.assertThrowIllegalArgumentException$1(sourcePatternPath3, baseArchiveDirPath3, fakeFileSystem);
        }, new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2099));
        this.test("SourceFileArchiver - different filesystems between source and archive", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            FakeFileSystem fakeFileSystem = new FakeFileSystem(this, "fake");
            FakeFileSystem fakeFileSystem2 = new FakeFileSystem(this, "fake2");
            Path sourcePatternPath = new Path("/hello*/h{e,f}ll?");
            Path baseArchiveDirPath = new Path("/hello");
            return (IllegalArgumentException)this.intercept((Function0 & Serializable & scala.Serializable)() -> new FileStreamSource.SourceFileArchiver((FileSystem)fakeFileSystem, sourcePatternPath, (FileSystem)fakeFileSystem2, baseArchiveDirPath), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2131));
        }, new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2124));
        this.test("Caches and leverages unread files", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withCountListingLocalFileSystemAsLocalFileSystem((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withThreeTempDirs((Function3<File, File, File, BoxedUnit>)(Function3 & Serializable & scala.Serializable)(x0$33, x1$31, x2$3) -> {
            FileStreamSourceSuite.$anonfun$new$230(this, x0$33, x1$31, x2$3);
            return BoxedUnit.UNIT;
        })), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2176));
        this.test("Don't cache unread files when latestFirst is true", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withCountListingLocalFileSystemAsLocalFileSystem((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withThreeTempDirs((Function3<File, File, File, BoxedUnit>)(Function3 & Serializable & scala.Serializable)(x0$34, x1$32, x2$4) -> {
            FileStreamSourceSuite.$anonfun$new$245(this, x0$34, x1$32, x2$4);
            return BoxedUnit.UNIT;
        })), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2242));
        this.test("SPARK-31962: file stream source shouldn't allow modifiedBefore/modifiedAfter", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)dir -> {
            FileStreamSourceSuite.$anonfun$new$254(this, dir);
            return BoxedUnit.UNIT;
        }), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2275));
        this.test("SPARK-35320: Reading JSON with key type different to String in a map should fail", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((IterableLike)new .colon.colon((Object)MapType$.MODULE$.apply((DataType)IntegerType$.MODULE$, (DataType)StringType$.MODULE$), (List)new .colon.colon((Object)StructType$.MODULE$.apply((Seq)new .colon.colon((Object)new StructField("test", (DataType)MapType$.MODULE$.apply((DataType)IntegerType$.MODULE$, (DataType)StringType$.MODULE$), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$)), (List)new .colon.colon((Object)ArrayType$.MODULE$.apply((DataType)MapType$.MODULE$.apply((DataType)IntegerType$.MODULE$, (DataType)StringType$.MODULE$)), (List)new .colon.colon((Object)MapType$.MODULE$.apply((DataType)StringType$.MODULE$, (DataType)MapType$.MODULE$.apply((DataType)IntegerType$.MODULE$, (DataType)StringType$.MODULE$)), (List)Nil$.MODULE$))))).foreach((Function1 & Serializable & scala.Serializable)schema -> {
            this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)dir -> {
                FileStreamSourceSuite.$anonfun$new$257($this, schema, dir);
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        }), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2326));
    }

    public class FakeFileSystem
    extends FileSystem {
        private final String scheme;
        public final /* synthetic */ FileStreamSourceSuite $outer;

        public boolean exists(Path f) {
            return true;
        }

        public boolean mkdirs(Path f, FsPermission permission) {
            return true;
        }

        public boolean rename(Path src, Path dst) {
            return true;
        }

        public URI getUri() {
            return URI.create(new StringBuilder(4).append(this.scheme).append(":///").toString());
        }

        public FSDataInputStream open(Path f, int bufferSize) {
            throw new NotImplementedError();
        }

        public FSDataOutputStream create(Path f, FsPermission permission, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) {
            throw new NotImplementedError();
        }

        public FSDataOutputStream append(Path f, int bufferSize, Progressable progress) {
            throw new NotImplementedError();
        }

        public boolean delete(Path f, boolean recursive) {
            throw new NotImplementedError();
        }

        public FileStatus[] listStatus(Path f) {
            throw new NotImplementedError();
        }

        public void setWorkingDirectory(Path new_dir) {
            throw new NotImplementedError();
        }

        public Path getWorkingDirectory() {
            return new Path("/somewhere");
        }

        public FileStatus getFileStatus(Path f) {
            throw new NotImplementedError();
        }

        public /* synthetic */ FileStreamSourceSuite org$apache$spark$sql$streaming$FileStreamSourceSuite$FakeFileSystem$$$outer() {
            return this.$outer;
        }

        public FakeFileSystem(FileStreamSourceSuite $outer, String scheme) {
            this.scheme = scheme;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
        }
    }
}

