/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.jdbc;

import java.io.Serializable;
import java.util.Locale;
import org.apache.spark.sql.connector.expressions.aggregate.AggregateFunc;
import org.apache.spark.sql.connector.expressions.aggregate.GeneralAggregateFunc;
import org.apache.spark.sql.jdbc.JdbcDialect;
import org.apache.spark.sql.jdbc.JdbcType;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.collection.Iterator;
import scala.collection.mutable.ArrayOps;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class TeradataDialect$
extends JdbcDialect
implements Product {
    public static TeradataDialect$ MODULE$;

    static {
        new TeradataDialect$();
    }

    @Override
    public boolean canHandle(String url) {
        return url.toLowerCase(Locale.ROOT).startsWith("jdbc:teradata");
    }

    @Override
    public Option<String> compileAggregate(AggregateFunc aggFunction) {
        return super.compileAggregate(aggFunction).orElse((Function0 & Serializable & scala.Serializable)() -> {
            boolean bl = false;
            GeneralAggregateFunc generalAggregateFunc = null;
            AggregateFunc aggregateFunc = aggFunction;
            if (aggregateFunc instanceof GeneralAggregateFunc) {
                bl = true;
                generalAggregateFunc = (GeneralAggregateFunc)aggregateFunc;
                String string = generalAggregateFunc.name();
                String string2 = "VAR_POP";
                if (!(string != null ? !string.equals(string2) : string2 != null)) {
                    Predef$.MODULE$.assert(generalAggregateFunc.children().length == 1);
                    String distinct = generalAggregateFunc.isDistinct() ? "DISTINCT " : "";
                    return new Some((Object)new StringBuilder(9).append("VAR_POP(").append(distinct).append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])generalAggregateFunc.children())).head()).append(")").toString());
                }
            }
            if (bl) {
                String string = generalAggregateFunc.name();
                String string3 = "VAR_SAMP";
                if (!(string != null ? !string.equals(string3) : string3 != null)) {
                    Predef$.MODULE$.assert(generalAggregateFunc.children().length == 1);
                    String distinct = generalAggregateFunc.isDistinct() ? "DISTINCT " : "";
                    return new Some((Object)new StringBuilder(10).append("VAR_SAMP(").append(distinct).append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])generalAggregateFunc.children())).head()).append(")").toString());
                }
            }
            if (bl) {
                String string = generalAggregateFunc.name();
                String string4 = "STDDEV_POP";
                if (!(string != null ? !string.equals(string4) : string4 != null)) {
                    Predef$.MODULE$.assert(generalAggregateFunc.children().length == 1);
                    String distinct = generalAggregateFunc.isDistinct() ? "DISTINCT " : "";
                    return new Some((Object)new StringBuilder(12).append("STDDEV_POP(").append(distinct).append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])generalAggregateFunc.children())).head()).append(")").toString());
                }
            }
            if (bl) {
                String string = generalAggregateFunc.name();
                String string5 = "STDDEV_SAMP";
                if (!(string != null ? !string.equals(string5) : string5 != null)) {
                    Predef$.MODULE$.assert(generalAggregateFunc.children().length == 1);
                    String distinct = generalAggregateFunc.isDistinct() ? "DISTINCT " : "";
                    return new Some((Object)new StringBuilder(13).append("STDDEV_SAMP(").append(distinct).append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])generalAggregateFunc.children())).head()).append(")").toString());
                }
            }
            if (bl) {
                String string = generalAggregateFunc.name();
                String string6 = "COVAR_POP";
                if (!(string != null ? !string.equals(string6) : string6 != null) && !generalAggregateFunc.isDistinct()) {
                    Predef$.MODULE$.assert(generalAggregateFunc.children().length == 2);
                    return new Some((Object)new StringBuilder(13).append("COVAR_POP(").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])generalAggregateFunc.children())).head()).append(", ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])generalAggregateFunc.children())).last()).append(")").toString());
                }
            }
            if (bl) {
                String string = generalAggregateFunc.name();
                String string7 = "COVAR_SAMP";
                if (!(string != null ? !string.equals(string7) : string7 != null) && !generalAggregateFunc.isDistinct()) {
                    Predef$.MODULE$.assert(generalAggregateFunc.children().length == 2);
                    return new Some((Object)new StringBuilder(14).append("COVAR_SAMP(").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])generalAggregateFunc.children())).head()).append(", ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])generalAggregateFunc.children())).last()).append(")").toString());
                }
            }
            if (bl) {
                String string = generalAggregateFunc.name();
                String string8 = "CORR";
                if (!(string != null ? !string.equals(string8) : string8 != null) && !generalAggregateFunc.isDistinct()) {
                    Predef$.MODULE$.assert(generalAggregateFunc.children().length == 2);
                    return new Some((Object)new StringBuilder(8).append("CORR(").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])generalAggregateFunc.children())).head()).append(", ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])generalAggregateFunc.children())).last()).append(")").toString());
                }
            }
            return None$.MODULE$;
        });
    }

    @Override
    public Option<JdbcType> getJDBCType(DataType dt) {
        DataType dataType = dt;
        if (StringType$.MODULE$.equals(dataType)) {
            return new Some((Object)new JdbcType("VARCHAR(255)", 12));
        }
        if (BooleanType$.MODULE$.equals(dataType)) {
            return Option$.MODULE$.apply((Object)new JdbcType("CHAR(1)", 1));
        }
        return None$.MODULE$;
    }

    @Override
    public Option<Object> isCascadingTruncateTable() {
        return new Some((Object)BoxesRunTime.boxToBoolean((boolean)false));
    }

    @Override
    public String getTruncateQuery(String table, Option<Object> cascade) {
        return new StringBuilder(16).append("DELETE FROM ").append(table).append(" ALL").toString();
    }

    @Override
    public Option<Object> getTruncateQuery$default$2() {
        return this.isCascadingTruncateTable();
    }

    @Override
    public String renameTable(String oldTable, String newTable) {
        return new StringBuilder(17).append("RENAME TABLE ").append(oldTable).append(" TO ").append(newTable).toString();
    }

    @Override
    public String getLimitClause(Integer limit) {
        return "";
    }

    public String productPrefix() {
        return "TeradataDialect";
    }

    public int productArity() {
        return 0;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        throw new IndexOutOfBoundsException(Integer.toString(x$1));
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof TeradataDialect$;
    }

    public int hashCode() {
        return -1014754660;
    }

    public String toString() {
        return "TeradataDialect";
    }

    private Object readResolve() {
        return MODULE$;
    }

    private TeradataDialect$() {
        MODULE$ = this;
        Product.$init$((Product)this);
    }
}

