/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.jdbc;

import java.io.Serializable;
import java.sql.SQLException;
import java.util.Locale;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.catalyst.analysis.NonEmptyNamespaceException;
import org.apache.spark.sql.connector.expressions.aggregate.AggregateFunc;
import org.apache.spark.sql.connector.expressions.aggregate.GeneralAggregateFunc;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.jdbc.JdbcDialect;
import org.apache.spark.sql.jdbc.JdbcType;
import org.apache.spark.sql.jdbc.MsSqlServerDialect$SpecificTypes$;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.MetadataBuilder;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.TimestampType$;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.mutable.ArrayOps;
import scala.runtime.BoxesRunTime;

public final class MsSqlServerDialect$
extends JdbcDialect {
    public static MsSqlServerDialect$ MODULE$;

    static {
        new MsSqlServerDialect$();
    }

    @Override
    public boolean canHandle(String url) {
        return url.toLowerCase(Locale.ROOT).startsWith("jdbc:sqlserver");
    }

    @Override
    public Object compileValue(Object value) {
        Object object = value;
        if (object instanceof Boolean) {
            boolean bl = BoxesRunTime.unboxToBoolean((Object)object);
            if (bl) {
                return BoxesRunTime.boxToInteger((int)1);
            }
            return BoxesRunTime.boxToInteger((int)0);
        }
        return super.compileValue(object);
    }

    @Override
    public Option<String> compileAggregate(AggregateFunc aggFunction) {
        return super.compileAggregate(aggFunction).orElse((Function0 & Serializable & scala.Serializable)() -> {
            boolean bl = false;
            GeneralAggregateFunc generalAggregateFunc = null;
            AggregateFunc aggregateFunc = aggFunction;
            if (aggregateFunc instanceof GeneralAggregateFunc) {
                bl = true;
                generalAggregateFunc = (GeneralAggregateFunc)aggregateFunc;
                String string = generalAggregateFunc.name();
                String string2 = "VAR_POP";
                if (!(string != null ? !string.equals(string2) : string2 != null)) {
                    Predef$.MODULE$.assert(generalAggregateFunc.children().length == 1);
                    String distinct = generalAggregateFunc.isDistinct() ? "DISTINCT " : "";
                    return new Some((Object)new StringBuilder(6).append("VARP(").append(distinct).append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])generalAggregateFunc.children())).head()).append(")").toString());
                }
            }
            if (bl) {
                String string = generalAggregateFunc.name();
                String string3 = "VAR_SAMP";
                if (!(string != null ? !string.equals(string3) : string3 != null)) {
                    Predef$.MODULE$.assert(generalAggregateFunc.children().length == 1);
                    String distinct = generalAggregateFunc.isDistinct() ? "DISTINCT " : "";
                    return new Some((Object)new StringBuilder(5).append("VAR(").append(distinct).append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])generalAggregateFunc.children())).head()).append(")").toString());
                }
            }
            if (bl) {
                String string = generalAggregateFunc.name();
                String string4 = "STDDEV_POP";
                if (!(string != null ? !string.equals(string4) : string4 != null)) {
                    Predef$.MODULE$.assert(generalAggregateFunc.children().length == 1);
                    String distinct = generalAggregateFunc.isDistinct() ? "DISTINCT " : "";
                    return new Some((Object)new StringBuilder(8).append("STDEVP(").append(distinct).append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])generalAggregateFunc.children())).head()).append(")").toString());
                }
            }
            if (bl) {
                String string = generalAggregateFunc.name();
                String string5 = "STDDEV_SAMP";
                if (!(string != null ? !string.equals(string5) : string5 != null)) {
                    Predef$.MODULE$.assert(generalAggregateFunc.children().length == 1);
                    String distinct = generalAggregateFunc.isDistinct() ? "DISTINCT " : "";
                    return new Some((Object)new StringBuilder(7).append("STDEV(").append(distinct).append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])generalAggregateFunc.children())).head()).append(")").toString());
                }
            }
            return None$.MODULE$;
        });
    }

    @Override
    public Option<DataType> getCatalystType(int sqlType, String typeName, int size, MetadataBuilder md) {
        if (typeName.contains("datetimeoffset")) {
            return Option$.MODULE$.apply((Object)StringType$.MODULE$);
        }
        if (SQLConf$.MODULE$.get().legacyMsSqlServerNumericMappingEnabled()) {
            return None$.MODULE$;
        }
        int n = sqlType;
        if (5 == n) {
            return new Some((Object)ShortType$.MODULE$);
        }
        if (7 == n) {
            return new Some((Object)FloatType$.MODULE$);
        }
        if (MsSqlServerDialect$SpecificTypes$.MODULE$.GEOMETRY() == n ? true : MsSqlServerDialect$SpecificTypes$.MODULE$.GEOGRAPHY() == n) {
            return new Some((Object)BinaryType$.MODULE$);
        }
        return None$.MODULE$;
    }

    @Override
    public Option<JdbcType> getJDBCType(DataType dt) {
        DataType dataType = dt;
        if (TimestampType$.MODULE$.equals(dataType)) {
            return new Some((Object)new JdbcType("DATETIME", 93));
        }
        if (StringType$.MODULE$.equals(dataType)) {
            return new Some((Object)new JdbcType("NVARCHAR(MAX)", -9));
        }
        if (BooleanType$.MODULE$.equals(dataType)) {
            return new Some((Object)new JdbcType("BIT", -7));
        }
        if (BinaryType$.MODULE$.equals(dataType)) {
            return new Some((Object)new JdbcType("VARBINARY(MAX)", -3));
        }
        if (ShortType$.MODULE$.equals(dataType) && !SQLConf$.MODULE$.get().legacyMsSqlServerNumericMappingEnabled()) {
            return new Some((Object)new JdbcType("SMALLINT", 5));
        }
        return None$.MODULE$;
    }

    @Override
    public Option<Object> isCascadingTruncateTable() {
        return new Some((Object)BoxesRunTime.boxToBoolean((boolean)false));
    }

    @Override
    public String renameTable(String oldTable, String newTable) {
        return new StringBuilder(17).append("EXEC sp_rename ").append(oldTable).append(", ").append(newTable).toString();
    }

    @Override
    public String getAddColumnQuery(String tableName, String columnName, String dataType) {
        return new StringBuilder(18).append("ALTER TABLE ").append(tableName).append(" ADD ").append(this.quoteIdentifier(columnName)).append(" ").append(dataType).toString();
    }

    @Override
    public String getRenameColumnQuery(String tableName, String columnName, String newName, int dbMajorVersion) {
        return new StringBuilder(30).append("EXEC sp_rename '").append(tableName).append(".").append(this.quoteIdentifier(columnName)).append("',").append(" ").append(this.quoteIdentifier(newName)).append(", 'COLUMN'").toString();
    }

    @Override
    public String getUpdateColumnNullabilityQuery(String tableName, String columnName, boolean isNullable) {
        throw QueryExecutionErrors$.MODULE$.unsupportedUpdateColumnNullabilityError();
    }

    @Override
    public String getTableCommentQuery(String table, String comment) {
        throw QueryExecutionErrors$.MODULE$.commentOnTableUnsupportedError();
    }

    @Override
    public String getLimitClause(Integer limit) {
        return "";
    }

    @Override
    public AnalysisException classifyException(String message, Throwable e) {
        Throwable throwable = e;
        if (throwable instanceof SQLException) {
            SQLException sQLException = (SQLException)throwable;
            int n = sQLException.getErrorCode();
            switch (n) {
                case 3729: {
                    throw new NonEmptyNamespaceException(message, (Option)new Some((Object)e));
                }
            }
            return super.classifyException(message, e);
        }
        return super.classifyException(message, e);
    }

    private Object readResolve() {
        return MODULE$;
    }

    private MsSqlServerDialect$() {
        MODULE$ = this;
    }
}

