/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.jdbc;

import java.io.Serializable;
import java.sql.SQLException;
import java.util.Locale;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.catalyst.analysis.NonEmptyNamespaceException;
import org.apache.spark.sql.connector.expressions.aggregate.AggregateFunc;
import org.apache.spark.sql.connector.expressions.aggregate.GeneralAggregateFunc;
import org.apache.spark.sql.jdbc.JdbcDialect;
import org.apache.spark.sql.jdbc.JdbcType;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.MetadataBuilder;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.TimestampType$;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.mutable.ArrayOps;
import scala.runtime.BoxesRunTime;

public final class DB2Dialect$
extends JdbcDialect {
    public static DB2Dialect$ MODULE$;

    static {
        new DB2Dialect$();
    }

    @Override
    public boolean canHandle(String url) {
        return url.toLowerCase(Locale.ROOT).startsWith("jdbc:db2");
    }

    @Override
    public Option<String> compileAggregate(AggregateFunc aggFunction) {
        return super.compileAggregate(aggFunction).orElse((Function0 & Serializable & scala.Serializable)() -> {
            boolean bl = false;
            GeneralAggregateFunc generalAggregateFunc = null;
            AggregateFunc aggregateFunc = aggFunction;
            if (aggregateFunc instanceof GeneralAggregateFunc) {
                bl = true;
                generalAggregateFunc = (GeneralAggregateFunc)aggregateFunc;
                String string = generalAggregateFunc.name();
                String string2 = "VAR_POP";
                if (!(string != null ? !string.equals(string2) : string2 != null)) {
                    Predef$.MODULE$.assert(generalAggregateFunc.children().length == 1);
                    String distinct = generalAggregateFunc.isDistinct() ? "DISTINCT " : "";
                    return new Some((Object)new StringBuilder(10).append("VARIANCE(").append(distinct).append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])generalAggregateFunc.children())).head()).append(")").toString());
                }
            }
            if (bl) {
                String string = generalAggregateFunc.name();
                String string3 = "VAR_SAMP";
                if (!(string != null ? !string.equals(string3) : string3 != null)) {
                    Predef$.MODULE$.assert(generalAggregateFunc.children().length == 1);
                    String distinct = generalAggregateFunc.isDistinct() ? "DISTINCT " : "";
                    return new Some((Object)new StringBuilder(15).append("VARIANCE_SAMP(").append(distinct).append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])generalAggregateFunc.children())).head()).append(")").toString());
                }
            }
            if (bl) {
                String string = generalAggregateFunc.name();
                String string4 = "STDDEV_POP";
                if (!(string != null ? !string.equals(string4) : string4 != null)) {
                    Predef$.MODULE$.assert(generalAggregateFunc.children().length == 1);
                    String distinct = generalAggregateFunc.isDistinct() ? "DISTINCT " : "";
                    return new Some((Object)new StringBuilder(8).append("STDDEV(").append(distinct).append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])generalAggregateFunc.children())).head()).append(")").toString());
                }
            }
            if (bl) {
                String string = generalAggregateFunc.name();
                String string5 = "STDDEV_SAMP";
                if (!(string != null ? !string.equals(string5) : string5 != null)) {
                    Predef$.MODULE$.assert(generalAggregateFunc.children().length == 1);
                    String distinct = generalAggregateFunc.isDistinct() ? "DISTINCT " : "";
                    return new Some((Object)new StringBuilder(13).append("STDDEV_SAMP(").append(distinct).append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])generalAggregateFunc.children())).head()).append(")").toString());
                }
            }
            if (bl) {
                String string = generalAggregateFunc.name();
                String string6 = "COVAR_POP";
                if (!(string != null ? !string.equals(string6) : string6 != null) && !generalAggregateFunc.isDistinct()) {
                    Predef$.MODULE$.assert(generalAggregateFunc.children().length == 2);
                    return new Some((Object)new StringBuilder(14).append("COVARIANCE(").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])generalAggregateFunc.children())).head()).append(", ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])generalAggregateFunc.children())).last()).append(")").toString());
                }
            }
            if (bl) {
                String string = generalAggregateFunc.name();
                String string7 = "COVAR_SAMP";
                if (!(string != null ? !string.equals(string7) : string7 != null) && !generalAggregateFunc.isDistinct()) {
                    Predef$.MODULE$.assert(generalAggregateFunc.children().length == 2);
                    return new Some((Object)new StringBuilder(19).append("COVARIANCE_SAMP(").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])generalAggregateFunc.children())).head()).append(", ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])generalAggregateFunc.children())).last()).append(")").toString());
                }
            }
            return None$.MODULE$;
        });
    }

    @Override
    public Option<DataType> getCatalystType(int sqlType, String typeName, int size, MetadataBuilder md) {
        int n = sqlType;
        switch (n) {
            case 7: {
                return Option$.MODULE$.apply((Object)FloatType$.MODULE$);
            }
            case 1111: {
                String string = typeName;
                if ("DECFLOAT".equals(string)) {
                    return Option$.MODULE$.apply((Object)new DecimalType(38, 18));
                }
                if ("XML".equals(string)) {
                    return Option$.MODULE$.apply((Object)StringType$.MODULE$);
                }
                if (string.startsWith("TIMESTAMP")) {
                    return Option$.MODULE$.apply((Object)TimestampType$.MODULE$);
                }
                return None$.MODULE$;
            }
        }
        return None$.MODULE$;
    }

    @Override
    public Option<JdbcType> getJDBCType(DataType dt) {
        DataType dataType = dt;
        if (StringType$.MODULE$.equals(dataType)) {
            return Option$.MODULE$.apply((Object)new JdbcType("CLOB", 2005));
        }
        if (BooleanType$.MODULE$.equals(dataType)) {
            return Option$.MODULE$.apply((Object)new JdbcType("CHAR(1)", 1));
        }
        if (ShortType$.MODULE$.equals(dataType) ? true : ByteType$.MODULE$.equals(dataType)) {
            return new Some((Object)new JdbcType("SMALLINT", 5));
        }
        return None$.MODULE$;
    }

    @Override
    public Option<Object> isCascadingTruncateTable() {
        return new Some((Object)BoxesRunTime.boxToBoolean((boolean)false));
    }

    @Override
    public String getTruncateQuery(String table, Option<Object> cascade) {
        return new StringBuilder(25).append("TRUNCATE TABLE ").append(table).append(" IMMEDIATE").toString();
    }

    @Override
    public Option<Object> getTruncateQuery$default$2() {
        return this.isCascadingTruncateTable();
    }

    @Override
    public String renameTable(String oldTable, String newTable) {
        return new StringBuilder(17).append("RENAME TABLE ").append(oldTable).append(" TO ").append(newTable).toString();
    }

    @Override
    public String getUpdateColumnTypeQuery(String tableName, String columnName, String newDataType) {
        return new StringBuilder(41).append("ALTER TABLE ").append(tableName).append(" ALTER COLUMN ").append(this.quoteIdentifier(columnName)).append(" SET DATA TYPE ").append(newDataType).toString();
    }

    @Override
    public String getUpdateColumnNullabilityQuery(String tableName, String columnName, boolean isNullable) {
        String nullable = isNullable ? "DROP NOT NULL" : "SET NOT NULL";
        return new StringBuilder(27).append("ALTER TABLE ").append(tableName).append(" ALTER COLUMN ").append(this.quoteIdentifier(columnName)).append(" ").append(nullable).toString();
    }

    @Override
    public String removeSchemaCommentQuery(String schema) {
        return new StringBuilder(24).append("COMMENT ON SCHEMA ").append(this.quoteIdentifier(schema)).append(" IS ''").toString();
    }

    @Override
    public AnalysisException classifyException(String message, Throwable e) {
        Throwable throwable = e;
        if (throwable instanceof SQLException) {
            SQLException sQLException = (SQLException)throwable;
            String string = sQLException.getSQLState();
            if ("42893".equals(string)) {
                throw new NonEmptyNamespaceException(message, (Option)new Some((Object)e));
            }
            return super.classifyException(message, e);
        }
        return super.classifyException(message, e);
    }

    @Override
    public String dropSchema(String schema, boolean cascade) {
        if (cascade) {
            return new StringBuilder(20).append("DROP SCHEMA ").append(this.quoteIdentifier(schema)).append(" CASCADE").toString();
        }
        return new StringBuilder(21).append("DROP SCHEMA ").append(this.quoteIdentifier(schema)).append(" RESTRICT").toString();
    }

    private Object readResolve() {
        return MODULE$;
    }

    private DB2Dialect$() {
        MODULE$ = this;
    }
}

