/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.UUID;
import org.apache.hadoop.fs.Path;
import org.apache.spark.sql.catalyst.analysis.UnsupportedOperationChecker$;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.rules.Rule;
import org.apache.spark.sql.catalyst.streaming.WriteToStream;
import org.apache.spark.sql.catalyst.streaming.WriteToStreamStatement;
import org.apache.spark.sql.connector.catalog.SupportsWrite;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.execution.streaming.CheckpointFileManager;
import org.apache.spark.sql.execution.streaming.CheckpointFileManager$;
import org.apache.spark.sql.execution.streaming.StreamExecution$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.util.Utils$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Tuple2;
import scala.runtime.BooleanRef;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.util.control.NonFatal$;

public final class ResolveWriteToStream$
extends Rule<LogicalPlan> {
    public static ResolveWriteToStream$ MODULE$;

    static {
        new ResolveWriteToStream$();
    }

    public LogicalPlan apply(LogicalPlan plan) {
        return plan.resolveOperators((PartialFunction)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof WriteToStreamStatement) {
                    WriteToStreamStatement writeToStreamStatement = (WriteToStreamStatement)A1;
                    Tuple2<String, Object> tuple2 = ResolveWriteToStream$.MODULE$.resolveCheckpointLocation(writeToStreamStatement);
                    if (tuple2 == null) {
                        throw new MatchError(tuple2);
                    }
                    String resolvedCheckpointLocation = (String)tuple2._1();
                    boolean deleteCheckpointOnStop = tuple2._2$mcZ$sp();
                    Tuple2 tuple22 = new Tuple2((Object)resolvedCheckpointLocation, (Object)BoxesRunTime.boxToBoolean((boolean)deleteCheckpointOnStop));
                    String resolvedCheckpointLocation2 = (String)tuple22._1();
                    boolean deleteCheckpointOnStop2 = tuple22._2$mcZ$sp();
                    if (ResolveWriteToStream$.MODULE$.conf().adaptiveExecutionEnabled()) {
                        ResolveWriteToStream$.MODULE$.logWarning((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(72).append(SQLConf$.MODULE$.ADAPTIVE_EXECUTION_ENABLED().key()).append(" ").append("is not supported in streaming DataFrames/Datasets and will be disabled.").toString());
                    }
                    if (ResolveWriteToStream$.MODULE$.conf().isUnsupportedOperationCheckEnabled()) {
                        if (writeToStreamStatement.sink() instanceof SupportsWrite && writeToStreamStatement.isContinuousTrigger()) {
                            UnsupportedOperationChecker$.MODULE$.checkForContinuous(writeToStreamStatement.inputQuery(), writeToStreamStatement.outputMode());
                        } else {
                            UnsupportedOperationChecker$.MODULE$.checkForStreaming(writeToStreamStatement.inputQuery(), writeToStreamStatement.outputMode());
                        }
                    }
                    return (B1)new WriteToStream((String)writeToStreamStatement.userSpecifiedName().orNull(Predef$.MODULE$.$conforms()), resolvedCheckpointLocation2, writeToStreamStatement.sink(), writeToStreamStatement.outputMode(), deleteCheckpointOnStop2, writeToStreamStatement.inputQuery(), writeToStreamStatement.catalogAndIdent());
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(LogicalPlan x1) {
                LogicalPlan logicalPlan2 = x1;
                return logicalPlan2 instanceof WriteToStreamStatement;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1()}, serializedLambda);
            }
        });
    }

    public Tuple2<String, Object> resolveCheckpointLocation(WriteToStreamStatement s) {
        String legacyCheckpointDir;
        boolean legacyCheckpointDirExists;
        Path checkpointPath;
        BooleanRef deleteCheckpointOnStop = BooleanRef.create((boolean)false);
        String checkpointLocation = (String)s.userSpecifiedCheckpointLocation().map((Function1 & Serializable & scala.Serializable)userSpecified -> new Path(userSpecified).toString()).orElse((Function0 & Serializable & scala.Serializable)() -> MODULE$.conf().checkpointLocation().map((Function1 & Serializable & scala.Serializable)location -> new Path(location, (String)s.userSpecifiedName().getOrElse((Function0 & Serializable & scala.Serializable)() -> UUID.randomUUID().toString())).toString())).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            if (s.useTempCheckpointLocation()) {
                deleteCheckpointOnStop$1.elem = true;
                String x$1 = "temporary";
                String x$2 = Utils$.MODULE$.createTempDir$default$1();
                String tempDir = Utils$.MODULE$.createTempDir(x$2, x$1).getCanonicalPath();
                MODULE$.logWarning((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(235).append("Temporary checkpoint location created which is deleted normally when").append(" the query didn't fail: ").append(tempDir).append(". If it's required to delete it under any").append(" circumstances, please set ").append(SQLConf$.MODULE$.FORCE_DELETE_TEMP_CHECKPOINT_LOCATION().key()).append(" to").append(" true. Important to know deleting temp checkpoint folder is best effort.").toString());
                return tempDir;
            }
            throw QueryCompilationErrors$.MODULE$.checkpointLocationNotSpecifiedError();
        });
        CheckpointFileManager fileManager = CheckpointFileManager$.MODULE$.create(new Path(checkpointLocation), s.hadoopConf());
        if (!s.recoverFromCheckpointLocation() && fileManager.exists(checkpointPath = new Path(checkpointLocation, "offsets"))) {
            throw QueryCompilationErrors$.MODULE$.recoverQueryFromCheckpointUnsupportedError(checkpointPath);
        }
        Path checkpointPath2 = new Path(checkpointLocation);
        if (BoxesRunTime.unboxToBoolean((Object)this.conf().getConf(SQLConf$.MODULE$.STREAMING_CHECKPOINT_ESCAPED_PATH_CHECK_ENABLED())) && StreamExecution$.MODULE$.containsSpecialCharsInPath(checkpointPath2) && (legacyCheckpointDirExists = this.liftedTree1$1(fileManager, legacyCheckpointDir = new Path(new Path(checkpointPath2.toUri().toString()).toUri().toString()).toUri().toString()))) {
            throw QueryExecutionErrors$.MODULE$.legacyCheckpointDirectoryExistsError(checkpointPath2, legacyCheckpointDir);
        }
        Path checkpointDir = fileManager.createCheckpointDirectory();
        String resolvedCheckpointRoot = checkpointDir.toString();
        this.logInfo((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(30).append("Checkpoint root ").append(checkpointLocation).append(" resolved to ").append(resolvedCheckpointRoot).append(".").toString());
        return new Tuple2((Object)resolvedCheckpointRoot, (Object)BoxesRunTime.boxToBoolean((boolean)deleteCheckpointOnStop.elem));
    }

    private final /* synthetic */ boolean liftedTree1$1(CheckpointFileManager fileManager$1, String legacyCheckpointDir$1) {
        boolean bl;
        try {
            bl = fileManager$1.exists(new Path(legacyCheckpointDir$1));
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable e = (Throwable)option.get();
                this.logWarning((Function0 & Serializable & scala.Serializable)() -> e.getMessage(), e);
                bl = false;
            }
            throw throwable;
        }
        return bl;
    }

    private ResolveWriteToStream$() {
        MODULE$ = this;
    }
}

