/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.metric;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.io.Serializable;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.Locale;
import org.apache.spark.SparkContext;
import org.apache.spark.scheduler.SparkListenerEvent;
import org.apache.spark.sql.connector.metric.CustomMetric;
import org.apache.spark.sql.execution.metric.CustomMetrics$;
import org.apache.spark.sql.execution.metric.SQLMetric;
import org.apache.spark.sql.execution.metric.SQLMetric$;
import org.apache.spark.sql.execution.ui.SparkListenerDriverAccumUpdates;
import org.apache.spark.util.AccumulatorContext$;
import org.apache.spark.util.Utils$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple4;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.math.Numeric;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

public final class SQLMetrics$ {
    public static SQLMetrics$ MODULE$;
    private final String SUM_METRIC;
    private final String SIZE_METRIC;
    private final String TIMING_METRIC;
    private final String NS_TIMING_METRIC;
    private final String AVERAGE_METRIC;
    private final int baseForAvgMetric;
    private final Some<String> cachedSQLAccumIdentifier;
    private final LoadingCache<String, Option<String>> metricsCache;
    private final String METRICS_NAME_SUFFIX;

    static {
        new SQLMetrics$();
    }

    private String SUM_METRIC() {
        return this.SUM_METRIC;
    }

    private String SIZE_METRIC() {
        return this.SIZE_METRIC;
    }

    private String TIMING_METRIC() {
        return this.TIMING_METRIC;
    }

    private String NS_TIMING_METRIC() {
        return this.NS_TIMING_METRIC;
    }

    private String AVERAGE_METRIC() {
        return this.AVERAGE_METRIC;
    }

    private int baseForAvgMetric() {
        return this.baseForAvgMetric;
    }

    public Some<String> cachedSQLAccumIdentifier() {
        return this.cachedSQLAccumIdentifier;
    }

    private LoadingCache<String, Option<String>> metricsCache() {
        return this.metricsCache;
    }

    public void setDoubleForAverageMetrics(SQLMetric metric, double v) {
        String string = metric.metricType();
        String string2 = this.AVERAGE_METRIC();
        Predef$.MODULE$.assert(!(string != null ? !string.equals(string2) : string2 != null), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(48).append("Can't set a double to a metric of metrics type: ").append(metric.metricType()).toString());
        metric.set((long)(v * (double)this.baseForAvgMetric()));
    }

    public SQLMetric createMetric(SparkContext sc, String name) {
        SQLMetric acc = new SQLMetric(this.SUM_METRIC(), SQLMetric$.MODULE$.$lessinit$greater$default$2());
        acc.register(sc, (Option)this.metricsCache().get((Object)name), false);
        return acc;
    }

    public SQLMetric createV2CustomMetric(SparkContext sc, CustomMetric customMetric) {
        SQLMetric acc = new SQLMetric(CustomMetrics$.MODULE$.buildV2CustomMetricTypeName(customMetric), SQLMetric$.MODULE$.$lessinit$greater$default$2());
        acc.register(sc, (Option)this.metricsCache().get((Object)customMetric.description()), false);
        return acc;
    }

    public SQLMetric createSizeMetric(SparkContext sc, String name) {
        SQLMetric acc = new SQLMetric(this.SIZE_METRIC(), -1L);
        acc.register(sc, (Option)this.metricsCache().get((Object)name), false);
        return acc;
    }

    public SQLMetric createTimingMetric(SparkContext sc, String name) {
        SQLMetric acc = new SQLMetric(this.TIMING_METRIC(), -1L);
        acc.register(sc, (Option)this.metricsCache().get((Object)name), false);
        return acc;
    }

    public SQLMetric createNanoTimingMetric(SparkContext sc, String name) {
        SQLMetric acc = new SQLMetric(this.NS_TIMING_METRIC(), -1L);
        acc.register(sc, (Option)this.metricsCache().get((Object)name), false);
        return acc;
    }

    public SQLMetric createAverageMetric(SparkContext sc, String name) {
        SQLMetric acc = new SQLMetric(this.AVERAGE_METRIC(), SQLMetric$.MODULE$.$lessinit$greater$default$2());
        acc.register(sc, (Option)this.metricsCache().get((Object)name), false);
        return acc;
    }

    private String toNumberFormat(long value) {
        NumberFormat numberFormat = NumberFormat.getNumberInstance(Locale.US);
        return numberFormat.format((double)value / (double)this.baseForAvgMetric());
    }

    public boolean metricNeedsMax(String metricsType) {
        String string = metricsType;
        String string2 = this.SUM_METRIC();
        return string == null ? string2 != null : !string.equals(string2);
    }

    private String METRICS_NAME_SUFFIX() {
        return this.METRICS_NAME_SUFFIX;
    }

    public String stringValue(String metricsType, long[] values, long[] maxMetrics) {
        Function1 & Serializable & scala.Serializable intersect;
        String taskInfo = new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(maxMetrics)).isEmpty() ? "(driver)" : new StringBuilder(16).append("(stage ").append(maxMetrics[1]).append(".").append(maxMetrics[2]).append(": task ").append(maxMetrics[3]).append(")").toString();
        String string = metricsType;
        String string2 = this.SUM_METRIC();
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            NumberFormat numberFormat = NumberFormat.getIntegerInstance(Locale.US);
            return numberFormat.format(BoxesRunTime.unboxToLong((Object)new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(values)).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)));
        }
        String string3 = metricsType;
        String string4 = this.AVERAGE_METRIC();
        if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
            long[] validValues = (long[])new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(values)).filter((Function1)(JFunction1.mcZJ.sp & Serializable & scala.Serializable)x$1 -> x$1 > 0L);
            if (validValues.length <= 1) {
                return this.toNumberFormat(BoxesRunTime.unboxToLong((Object)new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(validValues)).headOption().getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L)));
            }
            Arrays.sort(validValues);
            Seq seq = (Seq)new .colon.colon((Object)this.toNumberFormat(validValues[0]), (List)new .colon.colon((Object)this.toNumberFormat(validValues[validValues.length / 2]), (List)new .colon.colon((Object)this.toNumberFormat(validValues[validValues.length - 1]), (List)Nil$.MODULE$)));
            Some some = Seq$.MODULE$.unapplySeq(seq);
            if (some.isEmpty() || some.get() == null || ((SeqLike)some.get()).lengthCompare(3) != 0) {
                throw new MatchError((Object)seq);
            }
            String min = (String)((SeqLike)some.get()).apply(0);
            String med = (String)((SeqLike)some.get()).apply(1);
            String max = (String)((SeqLike)some.get()).apply(2);
            Tuple3 tuple3 = new Tuple3((Object)min, (Object)med, (Object)max);
            String min2 = (String)tuple3._1();
            String med2 = (String)tuple3._2();
            String max2 = (String)tuple3._3();
            return new StringBuilder(9).append(this.METRICS_NAME_SUFFIX()).append(":\n(").append(min2).append(", ").append(med2).append(", ").append(max2).append(" ").append(taskInfo).append(")").toString();
        }
        String string5 = metricsType;
        String string6 = this.SIZE_METRIC();
        if (!(string5 != null ? !string5.equals(string6) : string6 != null)) {
            intersect = (Function1 & Serializable & scala.Serializable)size -> Utils$.MODULE$.bytesToString(BoxesRunTime.unboxToLong((Object)size));
        } else {
            String string7 = metricsType;
            String string8 = this.TIMING_METRIC();
            if (!(string7 != null ? !string7.equals(string8) : string8 != null)) {
                intersect = (Function1 & Serializable & scala.Serializable)ms -> Utils$.MODULE$.msDurationToString(BoxesRunTime.unboxToLong((Object)ms));
            } else {
                String string9 = metricsType;
                String string10 = this.NS_TIMING_METRIC();
                if (!(string9 != null ? !string9.equals(string10) : string10 != null)) {
                    intersect = (Function1 & Serializable & scala.Serializable)duration -> Utils$.MODULE$.msDurationToString(new package.DurationLong(package$.MODULE$.DurationLong(BoxesRunTime.unboxToLong((Object)duration))).nanos().toMillis());
                } else {
                    throw new IllegalStateException(new StringBuilder(25).append("unexpected metrics type: ").append(metricsType).toString());
                }
            }
        }
        Function1 & Serializable & scala.Serializable strFormat = intersect;
        long[] validValues = (long[])new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(values)).filter((Function1)(JFunction1.mcZJ.sp & Serializable & scala.Serializable)x$3 -> x$3 >= 0L);
        if (validValues.length <= 1) {
            return (String)strFormat.apply(new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(validValues)).headOption().getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L));
        }
        Arrays.sort(validValues);
        Seq seq = (Seq)new .colon.colon((Object)((String)strFormat.apply(new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(validValues)).sum((Numeric)Numeric.LongIsIntegral$.MODULE$))), (List)new .colon.colon((Object)((String)strFormat.apply((Object)BoxesRunTime.boxToLong((long)validValues[0]))), (List)new .colon.colon((Object)((String)strFormat.apply((Object)BoxesRunTime.boxToLong((long)validValues[validValues.length / 2]))), (List)new .colon.colon((Object)((String)strFormat.apply((Object)BoxesRunTime.boxToLong((long)validValues[validValues.length - 1]))), (List)Nil$.MODULE$))));
        Some some = Seq$.MODULE$.unapplySeq(seq);
        if (some.isEmpty() || some.get() == null || ((SeqLike)some.get()).lengthCompare(4) != 0) {
            throw new MatchError((Object)seq);
        }
        String sum = (String)((SeqLike)some.get()).apply(0);
        String min = (String)((SeqLike)some.get()).apply(1);
        String med = (String)((SeqLike)some.get()).apply(2);
        String max = (String)((SeqLike)some.get()).apply(3);
        Tuple4 tuple4 = new Tuple4((Object)sum, (Object)min, (Object)med, (Object)max);
        String sum2 = (String)tuple4._1();
        String min3 = (String)tuple4._2();
        String med3 = (String)tuple4._3();
        String max3 = (String)tuple4._4();
        return new StringBuilder(15).append("total ").append(this.METRICS_NAME_SUFFIX()).append("\n").append(sum2).append(" (").append(min3).append(", ").append(med3).append(", ").append(max3).append(" ").append(taskInfo).append(")").toString();
    }

    public void postDriverMetricsUpdatedByValue(SparkContext sc, String executionId, Seq<Tuple2<Object, Object>> accumUpdates) {
        if (executionId != null) {
            sc.listenerBus().post((SparkListenerEvent)new SparkListenerDriverAccumUpdates(new StringOps(Predef$.MODULE$.augmentString(executionId)).toLong(), accumUpdates));
            return;
        }
    }

    public void postDriverMetricUpdates(SparkContext sc, String executionId, Seq<SQLMetric> metrics) {
        if (executionId != null) {
            sc.listenerBus().post((SparkListenerEvent)new SparkListenerDriverAccumUpdates(new StringOps(Predef$.MODULE$.augmentString(executionId)).toLong(), (Seq<Tuple2<Object, Object>>)((Seq)metrics.map((Function1 & Serializable & scala.Serializable)m -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)m.id())), (Object)BoxesRunTime.boxToLong((long)m.value())), Seq$.MODULE$.canBuildFrom()))));
            return;
        }
    }

    private SQLMetrics$() {
        MODULE$ = this;
        this.SUM_METRIC = "sum";
        this.SIZE_METRIC = "size";
        this.TIMING_METRIC = "timing";
        this.NS_TIMING_METRIC = "nsTiming";
        this.AVERAGE_METRIC = "average";
        this.baseForAvgMetric = 10;
        this.cachedSQLAccumIdentifier = new Some((Object)AccumulatorContext$.MODULE$.SQL_ACCUM_IDENTIFIER());
        this.metricsCache = CacheBuilder.newBuilder().maximumSize(10000L).build((CacheLoader)new CacheLoader<String, Option<String>>(){

            public Option<String> load(String name) {
                return Option$.MODULE$.apply((Object)name);
            }
        });
        this.METRICS_NAME_SUFFIX = "(min, med, max (stageId: taskId))";
    }
}

