/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.v2;

import java.io.Serializable;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.connector.catalog.CatalogV2Implicits$;
import org.apache.spark.sql.connector.catalog.SupportsRead;
import org.apache.spark.sql.connector.catalog.SupportsWrite;
import org.apache.spark.sql.connector.catalog.TableCapability;
import org.apache.spark.sql.connector.expressions.Transform;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.execution.datasources.DataSource$;
import org.apache.spark.sql.execution.datasources.FileFormat;
import org.apache.spark.sql.execution.datasources.FileStatusCache;
import org.apache.spark.sql.execution.datasources.FileStatusCache$;
import org.apache.spark.sql.execution.datasources.InMemoryFileIndex;
import org.apache.spark.sql.execution.datasources.InMemoryFileIndex$;
import org.apache.spark.sql.execution.datasources.PartitioningAwareFileIndex;
import org.apache.spark.sql.execution.datasources.PartitioningUtils$;
import org.apache.spark.sql.execution.datasources.v2.FileTable$;
import org.apache.spark.sql.execution.streaming.FileStreamSink$;
import org.apache.spark.sql.execution.streaming.MetadataLogFileIndex;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.util.CaseInsensitiveStringMap;
import org.apache.spark.sql.util.SchemaUtils$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005}e!\u0002\f\u0018\u0003\u00031\u0003\u0002C\u001f\u0001\u0005\u0003\u0005\u000b\u0011\u0002 \t\u0011\t\u0003!\u0011!Q\u0001\n\rC\u0001\"\u0013\u0001\u0003\u0002\u0003\u0006IA\u0013\u0005\tA\u0002\u0011\t\u0011)A\u0005C\")1\u000e\u0001C\u0001Y\"A1\u000f\u0001EC\u0002\u0013\u0005A\u000f\u0003\u0005z\u0001!\u0015\r\u0011\"\u0001{\u0011!Y\b\u0001#b\u0001\n\u0003R\b\"\u0002?\u0001\t\u0003j\bbBA\b\u0001\u0011\u0005\u0013\u0011\u0003\u0005\b\u0003;\u0001A\u0011IA\u0010\u0011\u001d\ti\u0003\u0001D\u0001\u0003_Aq!a\u0012\u0001\t\u0003\tI\u0005C\u0004\u0002\\\u00011\t!!\u0018\t\u000f\u0005}\u0003A\"\u0001\u0002b!9\u0011\u0011\u0011\u0001\u0005\n\u0005\ruaBAC/!\u0005\u0011q\u0011\u0004\u0007-]A\t!!#\t\r-\u0014B\u0011AAI\u0011%\t\u0019J\u0005b\u0001\n\u0013\t)\n\u0003\u0005\u0002\u001eJ\u0001\u000b\u0011BAL\u0005%1\u0015\u000e\\3UC\ndWM\u0003\u0002\u00193\u0005\u0011aO\r\u0006\u00035m\t1\u0002Z1uCN|WO]2fg*\u0011A$H\u0001\nKb,7-\u001e;j_:T!AH\u0010\u0002\u0007M\fHN\u0003\u0002!C\u0005)1\u000f]1sW*\u0011!eI\u0001\u0007CB\f7\r[3\u000b\u0003\u0011\n1a\u001c:h\u0007\u0001\u0019R\u0001A\u00140oi\u0002\"\u0001K\u0017\u000e\u0003%R!AK\u0016\u0002\t1\fgn\u001a\u0006\u0002Y\u0005!!.\u0019<b\u0013\tq\u0013F\u0001\u0004PE*,7\r\u001e\t\u0003aUj\u0011!\r\u0006\u0003eM\nqaY1uC2|wM\u0003\u00025;\u0005I1m\u001c8oK\u000e$xN]\u0005\u0003mE\u0012Q\u0001V1cY\u0016\u0004\"\u0001\r\u001d\n\u0005e\n$\u0001D*vaB|'\u000f^:SK\u0006$\u0007C\u0001\u0019<\u0013\ta\u0014GA\u0007TkB\u0004xN\u001d;t/JLG/Z\u0001\rgB\f'o[*fgNLwN\u001c\t\u0003\u007f\u0001k\u0011!H\u0005\u0003\u0003v\u0011Ab\u00159be.\u001cVm]:j_:\fqa\u001c9uS>t7\u000f\u0005\u0002E\u000f6\tQI\u0003\u0002G;\u0005!Q\u000f^5m\u0013\tAUI\u0001\rDCN,\u0017J\\:f]NLG/\u001b<f'R\u0014\u0018N\\4NCB\fQ\u0001]1uQN\u00042aS+Y\u001d\ta%K\u0004\u0002N!6\taJ\u0003\u0002PK\u00051AH]8pizJ\u0011!U\u0001\u0006g\u000e\fG.Y\u0005\u0003'R\u000bq\u0001]1dW\u0006<WMC\u0001R\u0013\t1vKA\u0002TKFT!a\u0015+\u0011\u0005ekfB\u0001.\\!\tiE+\u0003\u0002])\u00061\u0001K]3eK\u001aL!AX0\u0003\rM#(/\u001b8h\u0015\taF+A\nvg\u0016\u00148\u000b]3dS\u001aLW\rZ*dQ\u0016l\u0017\rE\u0002cG\u0016l\u0011\u0001V\u0005\u0003IR\u0013aa\u00149uS>t\u0007C\u00014j\u001b\u00059'B\u00015\u001e\u0003\u0015!\u0018\u0010]3t\u0013\tQwM\u0001\u0006TiJ,8\r\u001e+za\u0016\fa\u0001P5oSRtD#B7paF\u0014\bC\u00018\u0001\u001b\u00059\u0002\"B\u001f\u0006\u0001\u0004q\u0004\"\u0002\"\u0006\u0001\u0004\u0019\u0005\"B%\u0006\u0001\u0004Q\u0005\"\u00021\u0006\u0001\u0004\t\u0017!\u00034jY\u0016Le\u000eZ3y+\u0005)\bC\u0001<x\u001b\u0005I\u0012B\u0001=\u001a\u0005i\u0001\u0016M\u001d;ji&|g.\u001b8h\u0003^\f'/\u001a$jY\u0016Le\u000eZ3y\u0003)!\u0017\r^1TG\",W.Y\u000b\u0002K\u000611o\u00195f[\u0006\fA\u0002]1si&$\u0018n\u001c8j]\u001e$\u0012A \t\u0005E~\f\u0019!C\u0002\u0002\u0002Q\u0013Q!\u0011:sCf\u0004B!!\u0002\u0002\f5\u0011\u0011q\u0001\u0006\u0004\u0003\u0013\u0019\u0014aC3yaJ,7o]5p]NLA!!\u0004\u0002\b\tIAK]1og\u001a|'/\\\u0001\u000baJ|\u0007/\u001a:uS\u0016\u001cHCAA\n!\u0019\t)\"!\u0007Y16\u0011\u0011q\u0003\u0006\u0003\r.JA!a\u0007\u0002\u0018\t\u0019Q*\u00199\u0002\u0019\r\f\u0007/\u00192jY&$\u0018.Z:\u0015\u0005\u0005\u0005\u0002CBA\u000b\u0003G\t9#\u0003\u0003\u0002&\u0005]!aA*fiB\u0019\u0001'!\u000b\n\u0007\u0005-\u0012GA\bUC\ndWmQ1qC\nLG.\u001b;z\u0003-IgNZ3s'\u000eDW-\\1\u0015\u0007\u0005\f\t\u0004C\u0004\u000241\u0001\r!!\u000e\u0002\u000b\u0019LG.Z:\u0011\t-+\u0016q\u0007\t\u0005\u0003s\t\u0019%\u0004\u0002\u0002<)!\u0011QHA \u0003\t17OC\u0002\u0002B\u0005\na\u0001[1e_>\u0004\u0018\u0002BA#\u0003w\u0011!BR5mKN#\u0018\r^;t\u0003A\u0019X\u000f\u001d9peR\u001cH)\u0019;b)f\u0004X\r\u0006\u0003\u0002L\u0005E\u0003c\u00012\u0002N%\u0019\u0011q\n+\u0003\u000f\t{w\u000e\\3b]\"9\u00111K\u0007A\u0002\u0005U\u0013\u0001\u00033bi\u0006$\u0016\u0010]3\u0011\u0007\u0019\f9&C\u0002\u0002Z\u001d\u0014\u0001\u0002R1uCRK\b/Z\u0001\u000bM>\u0014X.\u0019;OC6,W#\u0001-\u0002%\u0019\fG\u000e\u001c2bG.4\u0015\u000e\\3G_Jl\u0017\r^\u000b\u0003\u0003G\u0002D!!\u001a\u0002pA)\u0011,a\u001a\u0002l%\u0019\u0011\u0011N0\u0003\u000b\rc\u0017m]:\u0011\t\u00055\u0014q\u000e\u0007\u0001\t-\t\thDA\u0001\u0002\u0003\u0015\t!a\u001d\u0003\u0007}#\u0013'\u0005\u0003\u0002v\u0005m\u0004c\u00012\u0002x%\u0019\u0011\u0011\u0010+\u0003\u000f9{G\u000f[5oOB\u0019a/! \n\u0007\u0005}\u0014D\u0001\u0006GS2,gi\u001c:nCR\f\u0011b\u001a7pEB\u000bG\u000f[:\u0016\u0005\u0005-\u0013!\u0003$jY\u0016$\u0016M\u00197f!\tq'cE\u0002\u0013\u0003\u0017\u00032AYAG\u0013\r\ty\t\u0016\u0002\u0007\u0003:L(+\u001a4\u0015\u0005\u0005\u001d\u0015\u0001D\"B!\u0006\u0013\u0015\nT%U\u0013\u0016\u001bVCAAL!\u0019\t)\"!'\u0002(%!\u00111TA\f\u0005\u001d)e.^7TKR\fQbQ!Q\u0003\nKE*\u0013+J\u000bN\u0003\u0003")
public abstract class FileTable
implements SupportsRead,
SupportsWrite {
    private PartitioningAwareFileIndex fileIndex;
    private StructType dataSchema;
    private StructType schema;
    private final SparkSession sparkSession;
    private final CaseInsensitiveStringMap options;
    private final Seq<String> paths;
    private final Option<StructType> userSpecifiedSchema;
    private volatile byte bitmap$0;

    private PartitioningAwareFileIndex fileIndex$lzycompute() {
        FileTable fileTable = this;
        synchronized (fileTable) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                PartitioningAwareFileIndex partitioningAwareFileIndex;
                scala.collection.immutable.Map caseSensitiveMap = ((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(this.options.asCaseSensitiveMap()).asScala()).toMap(Predef$.MODULE$.$conforms());
                Configuration hadoopConf = this.sparkSession.sessionState().newHadoopConfWithOptions((scala.collection.immutable.Map<String, String>)caseSensitiveMap);
                if (FileStreamSink$.MODULE$.hasMetadata(this.paths, hadoopConf, this.sparkSession.sessionState().conf())) {
                    partitioningAwareFileIndex = new MetadataLogFileIndex(this.sparkSession, new Path((String)this.paths.head()), (scala.collection.immutable.Map<String, String>)((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter((Map)this.options).asScala()).toMap(Predef$.MODULE$.$conforms()), this.userSpecifiedSchema);
                } else {
                    Seq<String> x$1 = this.paths;
                    Configuration x$2 = hadoopConf;
                    boolean x$3 = true;
                    boolean x$4 = true;
                    boolean x$5 = this.globPaths();
                    Integer x$6 = DataSource$.MODULE$.checkAndGlobPathIfNecessary$default$5();
                    Seq<Path> rootPathsSpecified = DataSource$.MODULE$.checkAndGlobPathIfNecessary(x$1, x$2, x$3, x$4, x$6, x$5);
                    FileStatusCache fileStatusCache = FileStatusCache$.MODULE$.getOrCreate(this.sparkSession);
                    partitioningAwareFileIndex = new InMemoryFileIndex(this.sparkSession, rootPathsSpecified, (scala.collection.immutable.Map<String, String>)caseSensitiveMap, this.userSpecifiedSchema, fileStatusCache, InMemoryFileIndex$.MODULE$.$lessinit$greater$default$6(), InMemoryFileIndex$.MODULE$.$lessinit$greater$default$7());
                }
                this.fileIndex = partitioningAwareFileIndex;
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.fileIndex;
    }

    public PartitioningAwareFileIndex fileIndex() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.fileIndex$lzycompute();
        }
        return this.fileIndex;
    }

    private StructType dataSchema$lzycompute() {
        FileTable fileTable = this;
        synchronized (fileTable) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                StructType schema2 = (StructType)this.userSpecifiedSchema.map((Function1 & Serializable & scala.Serializable)schema -> {
                    StructType partitionSchema = this.fileIndex().partitionSchema();
                    Function2 resolver = $this.sparkSession.sessionState().conf().resolver();
                    return StructType$.MODULE$.apply((Seq)schema.filterNot((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)partitionSchema.exists((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)FileTable.$anonfun$dataSchema$3(resolver$1, f, p))))));
                }).orElse((Function0 & Serializable & scala.Serializable)() -> this.inferSchema(this.fileIndex().allFiles())).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                    throw QueryCompilationErrors$.MODULE$.dataSchemaNotSpecifiedError(this.formatName());
                });
                PartitioningAwareFileIndex partitioningAwareFileIndex = this.fileIndex();
                this.dataSchema = partitioningAwareFileIndex instanceof MetadataLogFileIndex ? schema2 : schema2.asNullable();
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.dataSchema;
    }

    public StructType dataSchema() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.dataSchema$lzycompute();
        }
        return this.dataSchema;
    }

    private StructType schema$lzycompute() {
        FileTable fileTable = this;
        synchronized (fileTable) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                boolean caseSensitive = this.sparkSession.sessionState().conf().caseSensitiveAnalysis();
                SchemaUtils$.MODULE$.checkSchemaColumnNameDuplication((DataType)this.dataSchema(), "in the data schema", caseSensitive);
                this.dataSchema().foreach((Function1 & Serializable & scala.Serializable)field -> {
                    FileTable.$anonfun$schema$1(this, field);
                    return BoxedUnit.UNIT;
                });
                StructType partitionSchema = this.fileIndex().partitionSchema();
                SchemaUtils$.MODULE$.checkSchemaColumnNameDuplication((DataType)partitionSchema, "in the partition schema", caseSensitive);
                scala.collection.immutable.Set partitionNameSet = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])partitionSchema.fields())).map((Function1 & Serializable & scala.Serializable)x$1 -> PartitioningUtils$.MODULE$.getColName((StructField)x$1, caseSensitive), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).toSet();
                StructField[] fields = (StructField[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.dataSchema().fields())).filterNot((Function1 & Serializable & scala.Serializable)field -> BoxesRunTime.boxToBoolean((boolean)FileTable.$anonfun$schema$3(caseSensitive, partitionNameSet, field))))).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])partitionSchema.fields())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(StructField.class)));
                this.schema = new StructType(fields);
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.schema;
    }

    public StructType schema() {
        if ((byte)(this.bitmap$0 & 4) == 0) {
            return this.schema$lzycompute();
        }
        return this.schema;
    }

    public Transform[] partitioning() {
        return CatalogV2Implicits$.MODULE$.PartitionTypeHelper(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.fileIndex().partitionSchema().names())).toSeq()).asTransforms();
    }

    public Map<String, String> properties() {
        return this.options.asCaseSensitiveMap();
    }

    public Set<TableCapability> capabilities() {
        return FileTable$.MODULE$.org$apache$spark$sql$execution$datasources$v2$FileTable$$CAPABILITIES();
    }

    public abstract Option<StructType> inferSchema(Seq<FileStatus> var1);

    public boolean supportsDataType(DataType dataType) {
        return true;
    }

    public abstract String formatName();

    public abstract Class<? extends FileFormat> fallbackFileFormat();

    private boolean globPaths() {
        String entry = this.options.get((Object)DataSource$.MODULE$.GLOB_PATHS_KEY());
        return BoxesRunTime.unboxToBoolean((Object)Option$.MODULE$.apply((Object)entry).map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)FileTable.$anonfun$globPaths$1(x$2))).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> true));
    }

    public static final /* synthetic */ boolean $anonfun$dataSchema$3(Function2 resolver$1, StructField f$1, StructField p) {
        return BoxesRunTime.unboxToBoolean((Object)resolver$1.apply((Object)p.name(), (Object)f$1.name()));
    }

    public static final /* synthetic */ void $anonfun$schema$1(FileTable $this, StructField field) {
        if (!$this.supportsDataType(field.dataType())) {
            throw QueryCompilationErrors$.MODULE$.dataTypeUnsupportedByDataSourceError($this.formatName(), field);
        }
    }

    public static final /* synthetic */ boolean $anonfun$schema$3(boolean caseSensitive$1, scala.collection.immutable.Set partitionNameSet$1, StructField field) {
        String colName = PartitioningUtils$.MODULE$.getColName(field, caseSensitive$1);
        return partitionNameSet$1.contains((Object)colName);
    }

    public static final /* synthetic */ boolean $anonfun$globPaths$1(String x$2) {
        String string = x$2;
        String string2 = "true";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public FileTable(SparkSession sparkSession, CaseInsensitiveStringMap options, Seq<String> paths, Option<StructType> userSpecifiedSchema) {
        this.sparkSession = sparkSession;
        this.options = options;
        this.paths = paths;
        this.userSpecifiedSchema = userSpecifiedSchema;
    }
}

