/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.json;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.google.common.io.ByteStreams;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.spark.input.PortableDataStream;
import org.apache.spark.input.StreamInputFormat;
import org.apache.spark.rdd.BinaryFileRDD;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.json.CreateJacksonParser$;
import org.apache.spark.sql.catalyst.json.JSONOptions;
import org.apache.spark.sql.catalyst.json.JacksonParser;
import org.apache.spark.sql.catalyst.json.JsonInferSchema;
import org.apache.spark.sql.catalyst.util.FailureSafeParser;
import org.apache.spark.sql.execution.SQLExecution$;
import org.apache.spark.sql.execution.datasources.CodecStreams$;
import org.apache.spark.sql.execution.datasources.PartitionedFile;
import org.apache.spark.sql.execution.datasources.json.JsonDataSource;
import org.apache.spark.sql.execution.datasources.json.JsonUtils$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.unsafe.types.UTF8String;
import org.apache.spark.util.Utils$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.math.Ordering;
import scala.reflect.ClassTag$;

public final class MultiLineJsonDataSource$
extends JsonDataSource {
    public static MultiLineJsonDataSource$ MODULE$;
    private final boolean isSplitable;

    static {
        new MultiLineJsonDataSource$();
    }

    @Override
    public boolean isSplitable() {
        return this.isSplitable;
    }

    @Override
    public StructType infer(SparkSession sparkSession, Seq<FileStatus> inputPaths, JSONOptions parsedOptions) {
        RDD<PortableDataStream> json = this.createBaseRdd(sparkSession, inputPaths, parsedOptions);
        RDD<PortableDataStream> sampled = JsonUtils$.MODULE$.sample(json, parsedOptions);
        Function2 parser = (Function2)parsedOptions.encoding().map((Function1 & Serializable & scala.Serializable)enc -> (Function2 & Serializable & scala.Serializable)(x$12, x$13) -> MODULE$.createParser((String)enc, (JsonFactory)x$12, (PortableDataStream)x$13)).getOrElse((Function0 & Serializable & scala.Serializable)() -> (Function2 & Serializable & scala.Serializable)(x$14, x$15) -> MODULE$.createParser((JsonFactory)x$14, (PortableDataStream)x$15));
        return (StructType)SQLExecution$.MODULE$.withSQLConfPropagated(sparkSession, (Function0 & Serializable & scala.Serializable)() -> new JsonInferSchema(parsedOptions).infer(sampled, parser));
    }

    private RDD<PortableDataStream> createBaseRdd(SparkSession sparkSession, Seq<FileStatus> inputPaths, JSONOptions parsedOptions) {
        Seq paths = (Seq)inputPaths.map((Function1 & Serializable & scala.Serializable)x$16 -> x$16.getPath(), Seq$.MODULE$.canBuildFrom());
        Job job = Job.getInstance((Configuration)sparkSession.sessionState().newHadoopConfWithOptions((Map<String, String>)parsedOptions.parameters()));
        Configuration conf = job.getConfiguration();
        String name = paths.mkString(",");
        FileInputFormat.setInputPaths((Job)job, (Path[])((Path[])paths.toArray(ClassTag$.MODULE$.apply(Path.class))));
        return RDD$.MODULE$.rddToPairRDDFunctions(new BinaryFileRDD(sparkSession.sparkContext(), StreamInputFormat.class, String.class, PortableDataStream.class, conf, sparkSession.sparkContext().defaultMinPartitions()).setName(new StringBuilder(10).append("JsonFile: ").append(name).toString()), ClassTag$.MODULE$.apply(String.class), ClassTag$.MODULE$.apply(PortableDataStream.class), (Ordering)Ordering.String$.MODULE$).values();
    }

    private InputStream dataToInputStream(PortableDataStream dataStream) {
        Path path = new Path(dataStream.getPath());
        return CodecStreams$.MODULE$.createInputStreamWithCloseResource(dataStream.getConfiguration(), path);
    }

    private JsonParser createParser(JsonFactory jsonFactory, PortableDataStream stream) {
        return CreateJacksonParser$.MODULE$.inputStream(jsonFactory, this.dataToInputStream(stream));
    }

    private JsonParser createParser(String enc, JsonFactory jsonFactory, PortableDataStream stream) {
        return CreateJacksonParser$.MODULE$.inputStream(enc, jsonFactory, this.dataToInputStream(stream));
    }

    @Override
    public Iterator<InternalRow> readFile(Configuration conf, PartitionedFile file, JacksonParser parser, StructType schema) {
        Function2 streamParser = (Function2)parser.options().encoding().map((Function1 & Serializable & scala.Serializable)enc -> (Function2 & Serializable & scala.Serializable)(x$17, x$18) -> CreateJacksonParser$.MODULE$.inputStream(enc, x$17, x$18)).getOrElse((Function0 & Serializable & scala.Serializable)() -> (Function2 & Serializable & scala.Serializable)(x$19, x$20) -> CreateJacksonParser$.MODULE$.inputStream(x$19, x$20));
        FailureSafeParser safeParser = new FailureSafeParser((Function1 & Serializable & scala.Serializable)input -> parser.parse(input, streamParser, (Function1 & Serializable & scala.Serializable)ignored -> MultiLineJsonDataSource$.partitionedFileString$1(ignored, conf, file)), parser.options().parseMode(), schema, parser.options().columnNameOfCorruptRecord());
        return safeParser.parse((Object)CodecStreams$.MODULE$.createInputStreamWithCloseResource(conf, new Path(new URI(file.filePath()))));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private static final UTF8String partitionedFileString$1(Object ignored, Configuration conf$1, PartitionedFile file$1) {
        return (UTF8String)Utils$.MODULE$.tryWithResource((Function0 & Serializable & scala.Serializable)() -> CodecStreams$.MODULE$.createInputStreamWithCloseResource(conf$1, new Path(new URI(file$1.filePath()))), (Function1 & Serializable & scala.Serializable)inputStream -> UTF8String.fromBytes((byte[])ByteStreams.toByteArray((InputStream)inputStream)));
    }

    private MultiLineJsonDataSource$() {
        MODULE$ = this;
        this.isSplitable = false;
    }
}

