/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.InternalRow$;
import org.apache.spark.sql.catalyst.expressions.And$;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.BoundReference;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.FileSourceMetadataAttribute$;
import org.apache.spark.sql.catalyst.expressions.InterpretedPredicate;
import org.apache.spark.sql.catalyst.expressions.Predicate$;
import org.apache.spark.sql.catalyst.util.CaseInsensitiveMap;
import org.apache.spark.sql.catalyst.util.CaseInsensitiveMap$;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.execution.datasources.FileFormat$;
import org.apache.spark.sql.execution.datasources.FileIndex;
import org.apache.spark.sql.execution.datasources.FileStatusCache;
import org.apache.spark.sql.execution.datasources.PartitionDirectory;
import org.apache.spark.sql.execution.datasources.PartitionPath;
import org.apache.spark.sql.execution.datasources.PartitionSpec;
import org.apache.spark.sql.execution.datasources.PartitionSpec$;
import org.apache.spark.sql.execution.datasources.PartitioningAwareFileIndex$;
import org.apache.spark.sql.execution.datasources.PartitioningUtils$;
import org.apache.spark.sql.execution.datasources.PathFilterFactory$;
import org.apache.spark.sql.execution.datasources.PathFilterStrategy;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenSet;
import scala.collection.Iterable$;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.LinkedHashMap;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;

@ScalaSignature(bytes="\u0006\u0001\u0005}h!\u0002\u0011\"\u0003\u0003q\u0003\u0002C \u0001\u0005\u0003\u0005\u000b\u0011\u0002!\t\u0011\u0011\u0003!\u0011!Q\u0001\n\u0015C\u0001b\u0015\u0001\u0003\u0002\u0003\u0006I\u0001\u0016\u0005\t;\u0002\u0011\t\u0011)A\u0005=\")\u0011\r\u0001C\u0001E\")\u0001\u000e\u0001D\u0001S\")Q\u000e\u0001C!]\"9q\u000e\u0001b\u0001\n#\u0001\bBB=\u0001A\u0003%\u0011\u000fC\u0003{\u0001\u0019E1\u0010C\u0004\u0002\u001c\u00011\t\"!\b\t\u0013\u0005\u001d\u0002A1A\u0005\n\u0005%\u0002\u0002CA\u001e\u0001\u0001\u0006I!a\u000b\t\u0013\u0005u\u0002A1A\u0005\n\u0005}\u0002\u0002CA-\u0001\u0001\u0006I!!\u0011\t\u000f\u0005m\u0003\u0001\"\u0005\u0002^!Q\u0011\u0011\u000e\u0001\t\u0006\u0004%\t\"a\u001b\t\u000f\u00055\u0004\u0001\"\u0011\u0002p!9\u0011q\u0012\u0001\u0005B\u0005E\u0005bBAK\u0001\u0011\u0005\u0013q\u0013\u0005\b\u0003?\u0003A\u0011AAQ\u0011\u0019\t)\u000b\u0001C\tS\"9\u0011q\u0015\u0001\u0005\n\u0005%\u0006bBA]\u0001\u0011%\u00111\u0018\u0005\b\u0003\u0007\u0004A\u0011BAc\u000f\u001d\tY-\tE\u0001\u0003\u001b4a\u0001I\u0011\t\u0002\u0005=\u0007BB1\u001c\t\u0003\t\t\u000eC\u0005\u0002Tn\u0011\r\u0011\"\u0001\u0002V\"A\u0011Q]\u000e!\u0002\u0013\t9\u000eC\u0005\u0002hn\t\n\u0011\"\u0001\u0002j\nQ\u0002+\u0019:uSRLwN\\5oO\u0006;\u0018M]3GS2,\u0017J\u001c3fq*\u0011!eI\u0001\fI\u0006$\u0018m]8ve\u000e,7O\u0003\u0002%K\u0005IQ\r_3dkRLwN\u001c\u0006\u0003M\u001d\n1a]9m\u0015\tA\u0013&A\u0003ta\u0006\u00148N\u0003\u0002+W\u00051\u0011\r]1dQ\u0016T\u0011\u0001L\u0001\u0004_J<7\u0001A\n\u0005\u0001=*\u0014\b\u0005\u00021g5\t\u0011GC\u00013\u0003\u0015\u00198-\u00197b\u0013\t!\u0014G\u0001\u0004B]f\u0014VM\u001a\t\u0003m]j\u0011!I\u0005\u0003q\u0005\u0012\u0011BR5mK&sG-\u001a=\u0011\u0005ijT\"A\u001e\u000b\u0005q:\u0013\u0001C5oi\u0016\u0014h.\u00197\n\u0005yZ$a\u0002'pO\u001eLgnZ\u0001\rgB\f'o[*fgNLwN\u001c\t\u0003\u0003\nk\u0011!J\u0005\u0003\u0007\u0016\u0012Ab\u00159be.\u001cVm]:j_:\f!\u0002]1sC6,G/\u001a:t!\u00111U\n\u0015)\u000f\u0005\u001d[\u0005C\u0001%2\u001b\u0005I%B\u0001&.\u0003\u0019a$o\\8u}%\u0011A*M\u0001\u0007!J,G-\u001a4\n\u00059{%aA'ba*\u0011A*\r\t\u0003\rFK!AU(\u0003\rM#(/\u001b8h\u0003M)8/\u001a:Ta\u0016\u001c\u0017NZ5fIN\u001b\u0007.Z7b!\r\u0001TkV\u0005\u0003-F\u0012aa\u00149uS>t\u0007C\u0001-\\\u001b\u0005I&B\u0001.&\u0003\u0015!\u0018\u0010]3t\u0013\ta\u0016L\u0001\u0006TiJ,8\r\u001e+za\u0016\fqBZ5mKN#\u0018\r^;t\u0007\u0006\u001c\u0007.\u001a\t\u0003m}K!\u0001Y\u0011\u0003\u001f\u0019KG.Z*uCR,8oQ1dQ\u0016\fa\u0001P5oSRtD#B2eK\u001a<\u0007C\u0001\u001c\u0001\u0011\u0015yT\u00011\u0001A\u0011\u0015!U\u00011\u0001F\u0011\u0015\u0019V\u00011\u0001U\u0011\u001diV\u0001%AA\u0002y\u000bQ\u0002]1si&$\u0018n\u001c8Ta\u0016\u001cG#\u00016\u0011\u0005YZ\u0017B\u00017\"\u00055\u0001\u0016M\u001d;ji&|gn\u00159fG\u0006y\u0001/\u0019:uSRLwN\\*dQ\u0016l\u0017-F\u0001X\u0003)A\u0017\rZ8pa\u000e{gNZ\u000b\u0002cB\u0011!o^\u0007\u0002g*\u0011A/^\u0001\u0005G>tgM\u0003\u0002wS\u00051\u0001.\u00193p_BL!\u0001_:\u0003\u001b\r{gNZ5hkJ\fG/[8o\u0003-A\u0017\rZ8pa\u000e{gN\u001a\u0011\u0002\u00131,\u0017M\u001a$jY\u0016\u001cX#\u0001?\u0011\u000fu\f)!!\u0003\u0002\u00165\taPC\u0002\u0000\u0003\u0003\tq!\\;uC\ndWMC\u0002\u0002\u0004E\n!bY8mY\u0016\u001cG/[8o\u0013\r\t9A \u0002\u000e\u0019&t7.\u001a3ICNDW*\u00199\u0011\t\u0005-\u0011\u0011C\u0007\u0003\u0003\u001bQ1!a\u0004v\u0003\t17/\u0003\u0003\u0002\u0014\u00055!\u0001\u0002)bi\"\u0004B!a\u0003\u0002\u0018%!\u0011\u0011DA\u0007\u0005)1\u0015\u000e\\3Ti\u0006$Xo]\u0001\u0017Y\u0016\fg\rR5s)>\u001c\u0005.\u001b7ee\u0016tg)\u001b7fgV\u0011\u0011q\u0004\t\u0007\r6\u000bI!!\t\u0011\u000bA\n\u0019#!\u0006\n\u0007\u0005\u0015\u0012GA\u0003BeJ\f\u00170\u0001\ndCN,\u0017J\\:f]NLG/\u001b<f\u001b\u0006\u0004XCAA\u0016!\u0015\ti#a\u000eQ\u001b\t\tyC\u0003\u0003\u00022\u0005M\u0012\u0001B;uS2T1!!\u000e&\u0003!\u0019\u0017\r^1msN$\u0018\u0002BA\u001d\u0003_\u0011!cQ1tK&s7/\u001a8tSRLg/Z'ba\u0006\u00192-Y:f\u0013:\u001cXM\\:ji&4X-T1qA\u0005Y\u0001/\u0019;i\r&dG/\u001a:t+\t\t\t\u0005\u0005\u0004\u0002D\u00055\u00131\u000b\b\u0005\u0003\u000b\nIED\u0002I\u0003\u000fJ\u0011AM\u0005\u0004\u0003\u0017\n\u0014a\u00029bG.\fw-Z\u0005\u0005\u0003\u001f\n\tFA\u0002TKFT1!a\u00132!\r1\u0014QK\u0005\u0004\u0003/\n#A\u0005)bi\"4\u0015\u000e\u001c;feN#(/\u0019;fOf\fA\u0002]1uQ\u001aKG\u000e^3sg\u0002\n\u0001#\\1uG\"\u0004\u0016\r\u001e5QCR$XM\u001d8\u0015\t\u0005}\u0013Q\r\t\u0004a\u0005\u0005\u0014bAA2c\t9!i\\8mK\u0006t\u0007bBA4!\u0001\u0007\u0011QC\u0001\u0005M&dW-A\nsK\u000e,(o]5wK\u001aKG.\u001a'p_.,\b/\u0006\u0002\u0002`\u0005IA.[:u\r&dWm\u001d\u000b\u0007\u0003c\nI(a#\u0011\r\u0005\r\u0013QJA:!\r1\u0014QO\u0005\u0004\u0003o\n#A\u0005)beRLG/[8o\t&\u0014Xm\u0019;pefDq!a\u001f\u0013\u0001\u0004\ti(\u0001\tqCJ$\u0018\u000e^5p]\u001aKG\u000e^3sgB1\u00111IA'\u0003\u007f\u0002B!!!\u0002\b6\u0011\u00111\u0011\u0006\u0005\u0003\u000b\u000b\u0019$A\u0006fqB\u0014Xm]:j_:\u001c\u0018\u0002BAE\u0003\u0007\u0013!\"\u0012=qe\u0016\u001c8/[8o\u0011\u001d\tiI\u0005a\u0001\u0003{\n1\u0002Z1uC\u001aKG\u000e^3sg\u0006Q\u0011N\u001c9vi\u001aKG.Z:\u0016\u0005\u0005M\u0005\u0003\u0002\u0019\u0002$A\u000b1b]5{K&s')\u001f;fgV\u0011\u0011\u0011\u0014\t\u0004a\u0005m\u0015bAAOc\t!Aj\u001c8h\u0003!\tG\u000e\u001c$jY\u0016\u001cHCAAR!\u0019\t\u0019%!\u0014\u0002\u0016\u0005\t\u0012N\u001c4feB\u000b'\u000f^5uS>t\u0017N\\4\u0002\u001fA\u0014XO\\3QCJ$\u0018\u000e^5p]N$b!a+\u00024\u0006]\u0006CBA\"\u0003\u001b\ni\u000bE\u00027\u0003_K1!!-\"\u00055\u0001\u0016M\u001d;ji&|g\u000eU1uQ\"9\u0011QW\fA\u0002\u0005u\u0014A\u00039sK\u0012L7-\u0019;fg\")\u0001n\u0006a\u0001U\u0006I!-Y:f!\u0006$\bn]\u000b\u0003\u0003{\u0003RARA`\u0003\u0013I1!!1P\u0005\r\u0019V\r^\u0001\u000bSN$\u0015\r^1QCRDG\u0003BA0\u0003\u000fDq!!3\u001a\u0001\u0004\tI!\u0001\u0003qCRD\u0017A\u0007)beRLG/[8oS:<\u0017i^1sK\u001aKG.Z%oI\u0016D\bC\u0001\u001c\u001c'\tYr\u0006\u0006\u0002\u0002N\u0006y!)Q*F?B\u000bE\u000bS0Q\u0003J\u000bU*\u0006\u0002\u0002XB!\u0011\u0011\\Ar\u001b\t\tYN\u0003\u0003\u0002^\u0006}\u0017\u0001\u00027b]\u001eT!!!9\u0002\t)\fg/Y\u0005\u0004%\u0006m\u0017\u0001\u0005\"B'\u0016{\u0006+\u0011+I?B\u000b%+Q'!\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%iU\u0011\u00111\u001e\u0016\u0004=\u000658FAAx!\u0011\t\t0a?\u000e\u0005\u0005M(\u0002BA{\u0003o\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005e\u0018'\u0001\u0006b]:|G/\u0019;j_:LA!!@\u0002t\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3")
public abstract class PartitioningAwareFileIndex
implements FileIndex,
Logging {
    private boolean recursiveFileLookup;
    private final SparkSession sparkSession;
    private final Map<String, String> parameters;
    private final Option<StructType> userSpecifiedSchema;
    private final Configuration hadoopConf;
    private final CaseInsensitiveMap<String> caseInsensitiveMap;
    private final Seq<PathFilterStrategy> pathFilters;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private volatile boolean bitmap$0;

    public static FileStatusCache $lessinit$greater$default$4() {
        return PartitioningAwareFileIndex$.MODULE$.$lessinit$greater$default$4();
    }

    public static String BASE_PATH_PARAM() {
        return PartitioningAwareFileIndex$.MODULE$.BASE_PATH_PARAM();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    @Override
    public Option<Object> metadataOpsTimeNs() {
        return FileIndex.metadataOpsTimeNs$(this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public abstract PartitionSpec partitionSpec();

    @Override
    public StructType partitionSchema() {
        return this.partitionSpec().partitionColumns();
    }

    public Configuration hadoopConf() {
        return this.hadoopConf;
    }

    public abstract LinkedHashMap<Path, FileStatus> leafFiles();

    public abstract Map<Path, FileStatus[]> leafDirToChildrenFiles();

    private CaseInsensitiveMap<String> caseInsensitiveMap() {
        return this.caseInsensitiveMap;
    }

    private Seq<PathFilterStrategy> pathFilters() {
        return this.pathFilters;
    }

    public boolean matchPathPattern(FileStatus file) {
        return this.pathFilters().forall((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.accept(file)));
    }

    private boolean recursiveFileLookup$lzycompute() {
        PartitioningAwareFileIndex partitioningAwareFileIndex = this;
        synchronized (partitioningAwareFileIndex) {
            if (!this.bitmap$0) {
                this.recursiveFileLookup = new StringOps(Predef$.MODULE$.augmentString((String)this.caseInsensitiveMap().getOrElse((Object)"recursiveFileLookup", (Function0 & Serializable & scala.Serializable)() -> "false"))).toBoolean();
                this.bitmap$0 = true;
            }
        }
        return this.recursiveFileLookup;
    }

    public boolean recursiveFileLookup() {
        if (!this.bitmap$0) {
            return this.recursiveFileLookup$lzycompute();
        }
        return this.recursiveFileLookup;
    }

    @Override
    public Seq<PartitionDirectory> listFiles(Seq<Expression> partitionFilters, Seq<Expression> dataFilters) {
        Seq seq;
        Option fileMetadataFilterOpt = ((TraversableOnce)dataFilters.filter((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)PartitioningAwareFileIndex.$anonfun$listFiles$1(f)))).reduceOption((Function2)And$.MODULE$);
        Option boundedFilterMetadataStructOpt = fileMetadataFilterOpt.map((Function1 & Serializable & scala.Serializable)fileMetadataFilter -> {
            DataType metadataStruct = ((Expression)fileMetadataFilter.references().head()).dataType();
            InterpretedPredicate boundedFilter = Predicate$.MODULE$.createInterpreted((Expression)fileMetadataFilter.transform((PartialFunction)new scala.Serializable(null, metadataStruct){
                public static final long serialVersionUID = 0L;
                private final DataType metadataStruct$1;

                public final <A1 extends Expression, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    A1 A1 = x1;
                    if (A1 instanceof AttributeReference) {
                        return (B1)new BoundReference(0, this.metadataStruct$1, true);
                    }
                    return (B1)function1.apply(x1);
                }

                public final boolean isDefinedAt(Expression x1) {
                    Expression expression = x1;
                    return expression instanceof AttributeReference;
                }
                {
                    this.metadataStruct$1 = metadataStruct$1;
                }
            }));
            return new Tuple2((Object)boundedFilter, (Object)metadataStruct);
        });
        if (this.partitionSpec().partitionColumns().isEmpty()) {
            PartitionDirectory partitionDirectory = new PartitionDirectory(InternalRow$.MODULE$.empty(), (Seq<FileStatus>)((Seq)this.allFiles().filter((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)PartitioningAwareFileIndex.$anonfun$listFiles$5(this, boundedFilterMetadataStructOpt, f)))));
            seq = Nil$.MODULE$.$colon$colon((Object)partitionDirectory);
        } else {
            if (this.recursiveFileLookup()) {
                throw new IllegalArgumentException("Datasource with partition do not allow recursive file loading.");
            }
            seq = (Seq)this.prunePartitions(partitionFilters, this.partitionSpec()).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                PartitionPath partitionPath = x0$2;
                if (partitionPath != null) {
                    Nil$ nil$;
                    InternalRow values = partitionPath.values();
                    Path path = partitionPath.path();
                    Option option = this.leafDirToChildrenFiles().get((Object)path);
                    if (option instanceof Some) {
                        Some some = (Some)option;
                        FileStatus[] existingDir = (FileStatus[])some.value();
                        nil$ = Predef$.MODULE$.wrapRefArray((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])existingDir)).filter((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)PartitioningAwareFileIndex.$anonfun$listFiles$7(this, boundedFilterMetadataStructOpt, f))));
                    } else if (None$.MODULE$.equals(option)) {
                        nil$ = Nil$.MODULE$;
                    } else {
                        throw new MatchError((Object)option);
                    }
                    Nil$ files = nil$;
                    return new PartitionDirectory(values, (Seq<FileStatus>)files);
                }
                throw new MatchError((Object)partitionPath);
            }, Seq$.MODULE$.canBuildFrom());
        }
        Seq selectedPartitions = seq;
        this.logTrace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(41).append("Selected files after partition pruning:\n\t").append(selectedPartitions.mkString("\n\t")).toString());
        return selectedPartitions;
    }

    @Override
    public String[] inputFiles() {
        return (String[])((TraversableOnce)this.allFiles().map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.getPath().toUri().toString(), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(String.class));
    }

    @Override
    public long sizeInBytes() {
        return BoxesRunTime.unboxToLong((Object)((TraversableOnce)this.allFiles().map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToLong((long)x$4.getLen()), Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
    }

    public Seq<FileStatus> allFiles() {
        Seq files = this.partitionSpec().partitionColumns().isEmpty() && !this.recursiveFileLookup() ? (Seq)this.rootPaths().flatMap((Function1 & Serializable & scala.Serializable)path -> new ArrayOps.ofRef(PartitioningAwareFileIndex.$anonfun$allFiles$1(this, path)), Seq$.MODULE$.canBuildFrom()) : this.leafFiles().values().toSeq();
        return (Seq)files.filter((Function1 & Serializable & scala.Serializable)file -> BoxesRunTime.boxToBoolean((boolean)this.matchPathPattern(file)));
    }

    public PartitionSpec inferPartitioning() {
        if (this.recursiveFileLookup()) {
            return PartitionSpec$.MODULE$.emptySpec();
        }
        Seq leafDirs = ((MapLike)this.leafDirToChildrenFiles().filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)PartitioningAwareFileIndex.$anonfun$inferPartitioning$1(this, x0$1)))).keys().toSeq();
        CaseInsensitiveMap caseInsensitiveOptions = CaseInsensitiveMap$.MODULE$.apply(this.parameters);
        String timeZoneId = (String)caseInsensitiveOptions.get(DateTimeUtils$.MODULE$.TIMEZONE_OPTION()).getOrElse((Function0 & Serializable & scala.Serializable)() -> $this.sparkSession.sessionState().conf().sessionLocalTimeZone());
        return PartitioningUtils$.MODULE$.parsePartitions((Seq<Path>)leafDirs, this.sparkSession.sessionState().conf().partitionColumnTypeInferenceEnabled(), this.basePaths(), this.userSpecifiedSchema, this.sparkSession.sqlContext().conf().caseSensitiveAnalysis(), this.sparkSession.sqlContext().conf().validatePartitionColumns(), timeZoneId);
    }

    private Seq<PartitionPath> prunePartitions(Seq<Expression> predicates, PartitionSpec partitionSpec) {
        PartitionSpec partitionSpec2 = partitionSpec;
        if (partitionSpec2 == null) {
            throw new MatchError((Object)partitionSpec2);
        }
        StructType partitionColumns = partitionSpec2.partitionColumns();
        Seq<PartitionPath> partitions = partitionSpec2.partitions();
        Tuple2 tuple2 = new Tuple2((Object)partitionColumns, partitions);
        StructType partitionColumns2 = (StructType)tuple2._1();
        Seq partitions2 = (Seq)tuple2._2();
        Set partitionColumnNames = ((TraversableOnce)partitionColumns2.map((Function1 & Serializable & scala.Serializable)x$7 -> x$7.name(), Seq$.MODULE$.canBuildFrom())).toSet();
        Seq partitionPruningPredicates = (Seq)predicates.filter((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)PartitioningAwareFileIndex.$anonfun$prunePartitions$2(partitionColumnNames, x$8)));
        if (partitionPruningPredicates.nonEmpty()) {
            Expression predicate = (Expression)partitionPruningPredicates.reduce((Function2)And$.MODULE$);
            InterpretedPredicate boundPredicate = Predicate$.MODULE$.createInterpreted((Expression)predicate.transform((PartialFunction)new scala.Serializable(null, partitionColumns2){
                public static final long serialVersionUID = 0L;
                private final StructType partitionColumns$1;

                public final <A1 extends Expression, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    A1 A1 = x1;
                    if (A1 instanceof AttributeReference) {
                        AttributeReference attributeReference = (AttributeReference)A1;
                        int index = this.partitionColumns$1.indexWhere((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)$anonfun$2.$anonfun$applyOrElse$1(attributeReference, x$10)));
                        return (B1)new BoundReference(index, this.partitionColumns$1.apply(index).dataType(), true);
                    }
                    return (B1)function1.apply(x1);
                }

                public final boolean isDefinedAt(Expression x1) {
                    Expression expression = x1;
                    return expression instanceof AttributeReference;
                }

                public static final /* synthetic */ boolean $anonfun$applyOrElse$1(AttributeReference x2$1, StructField x$10) {
                    String string = x2$1.name();
                    String string2 = x$10.name();
                    return !(string != null ? !string.equals(string2) : string2 != null);
                }
                {
                    this.partitionColumns$1 = partitionColumns$1;
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1$adapted(org.apache.spark.sql.catalyst.expressions.AttributeReference org.apache.spark.sql.types.StructField )}, serializedLambda);
                }
            }));
            Seq selected = (Seq)partitions2.filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)PartitioningAwareFileIndex.$anonfun$prunePartitions$4(boundPredicate, x0$1)));
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> {
                int total = partitions2.length();
                int selectedSize = selected.length();
                double percentPruned = (1.0 - (double)selectedSize / (double)total) * (double)100;
                return new StringBuilder(49).append("Selected ").append(selectedSize).append(" partitions out of ").append(total).append(", ").append("pruned ").append((Object)(total == 0 ? "0" : new StringBuilder(1).append(percentPruned).append("%").toString())).append(" partitions.").toString();
            });
            return selected;
        }
        return partitions2;
    }

    private Set<Path> basePaths() {
        Option option = this.caseInsensitiveMap().get(PartitioningAwareFileIndex$.MODULE$.BASE_PATH_PARAM()).map((Function1 & Serializable & scala.Serializable)x$11 -> new Path(x$11));
        if (option instanceof Some) {
            Some some = (Some)option;
            Path userDefinedBasePath = (Path)some.value();
            FileSystem fs = userDefinedBasePath.getFileSystem(this.hadoopConf());
            if (!fs.isDirectory(userDefinedBasePath)) {
                throw new IllegalArgumentException(new StringBuilder(29).append("Option '").append(PartitioningAwareFileIndex$.MODULE$.BASE_PATH_PARAM()).append("' must be a directory").toString());
            }
            Path qualifiedBasePath = fs.makeQualified(userDefinedBasePath);
            String qualifiedBasePathStr = qualifiedBasePath.toString();
            this.rootPaths().find((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)PartitioningAwareFileIndex.$anonfun$basePaths$2(fs, qualifiedBasePathStr, x$12))).foreach((Function1 & Serializable & scala.Serializable)rp -> {
                throw new IllegalArgumentException(new StringBuilder(35).append("Wrong basePath ").append(userDefinedBasePath).append(" for the root path: ").append(rp).toString());
            });
            return (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Path[]{qualifiedBasePath}));
        }
        if (None$.MODULE$.equals(option)) {
            return ((TraversableOnce)this.rootPaths().map((Function1 & Serializable & scala.Serializable)path -> {
                Path qualifiedPath = path.getFileSystem(this.hadoopConf()).makeQualified(path);
                if (this.leafFiles().contains((Object)qualifiedPath)) {
                    return qualifiedPath.getParent();
                }
                return qualifiedPath;
            }, Seq$.MODULE$.canBuildFrom())).toSet();
        }
        throw new MatchError((Object)option);
    }

    private boolean isDataPath(Path path) {
        String name = path.getName();
        return (!name.startsWith("_") || name.contains("=")) && !name.startsWith(".");
    }

    private final boolean isNonEmptyFile$1(FileStatus f) {
        return this.isDataPath(f.getPath()) && f.getLen() > 0L;
    }

    public static final /* synthetic */ boolean $anonfun$listFiles$2(Attribute x0$1) {
        AttributeReference attributeReference;
        Option option;
        Attribute attribute = x0$1;
        return attribute instanceof AttributeReference && !(option = FileSourceMetadataAttribute$.MODULE$.unapply(attributeReference = (AttributeReference)attribute)).isEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$listFiles$1(Expression f) {
        return f.references().nonEmpty() && f.references().forall((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)PartitioningAwareFileIndex.$anonfun$listFiles$2(x0$1)));
    }

    public static final /* synthetic */ boolean $anonfun$listFiles$4(FileStatus f$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            InterpretedPredicate boundedFilter = (InterpretedPredicate)tuple2._1();
            DataType metadataStruct = (DataType)tuple2._2();
            InternalRow row = InternalRow$.MODULE$.fromSeq((Seq)new .colon.colon((Object)FileFormat$.MODULE$.createMetadataInternalRow((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])((StructType)metadataStruct).names()), f$1.getPath(), f$1.getLen(), f$1.getModificationTime()), (List)Nil$.MODULE$));
            return boundedFilter.eval(row);
        }
        throw new MatchError((Object)tuple2);
    }

    private static final boolean matchFileMetadataPredicate$1(FileStatus f, Option boundedFilterMetadataStructOpt$1) {
        return boundedFilterMetadataStructOpt$1.forall((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)PartitioningAwareFileIndex.$anonfun$listFiles$4(f, x0$1)));
    }

    public static final /* synthetic */ boolean $anonfun$listFiles$5(PartitioningAwareFileIndex $this, Option boundedFilterMetadataStructOpt$1, FileStatus f) {
        return $this.isNonEmptyFile$1(f) && PartitioningAwareFileIndex.matchFileMetadataPredicate$1(f, boundedFilterMetadataStructOpt$1);
    }

    public static final /* synthetic */ boolean $anonfun$listFiles$7(PartitioningAwareFileIndex $this, Option boundedFilterMetadataStructOpt$1, FileStatus f) {
        return $this.matchPathPattern(f) && $this.isNonEmptyFile$1(f) && PartitioningAwareFileIndex.matchFileMetadataPredicate$1(f, boundedFilterMetadataStructOpt$1);
    }

    public static final /* synthetic */ Object[] $anonfun$allFiles$1(PartitioningAwareFileIndex $this, Path path) {
        FileSystem fs = path.getFileSystem($this.hadoopConf());
        Path qualifiedPathPre = fs.makeQualified(path);
        Path qualifiedPath = qualifiedPathPre.isRoot() && !qualifiedPathPre.isAbsolute() ? new Path(qualifiedPathPre, "/") : qualifiedPathPre;
        Path resolvedPath = FileUtil.checkPathForSymlink((Path)qualifiedPath, (Configuration)$this.hadoopConf()).path;
        return Predef$.MODULE$.refArrayOps((Object[])$this.leafDirToChildrenFiles().get((Object)resolvedPath).orElse((Function0 & Serializable & scala.Serializable)() -> $this.leafFiles().get((Object)resolvedPath).map((Function1 & Serializable & scala.Serializable)x$5 -> (FileStatus[])((Object[])new FileStatus[]{x$5}))).getOrElse((Function0 & Serializable & scala.Serializable)() -> (FileStatus[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(FileStatus.class))));
    }

    public static final /* synthetic */ boolean $anonfun$inferPartitioning$1(PartitioningAwareFileIndex $this, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            FileStatus[] files = (FileStatus[])tuple2._2();
            return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])files)).exists((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)$this.isDataPath(f.getPath())));
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$prunePartitions$2(Set partitionColumnNames$1, Expression x$8) {
        return ((TraversableOnce)x$8.references().map((Function1 & Serializable & scala.Serializable)x$9 -> x$9.name(), Iterable$.MODULE$.canBuildFrom())).toSet().subsetOf((GenSet)partitionColumnNames$1);
    }

    public static final /* synthetic */ boolean $anonfun$prunePartitions$4(InterpretedPredicate boundPredicate$1, PartitionPath x0$1) {
        PartitionPath partitionPath = x0$1;
        if (partitionPath != null) {
            InternalRow values = partitionPath.values();
            return boundPredicate$1.eval(values);
        }
        throw new MatchError((Object)partitionPath);
    }

    public static final /* synthetic */ boolean $anonfun$basePaths$3(char x$13) {
        return x$13 == '/';
    }

    public static final /* synthetic */ boolean $anonfun$basePaths$4(char x$14) {
        return x$14 == '/';
    }

    public static final /* synthetic */ boolean $anonfun$basePaths$2(FileSystem fs$1, String qualifiedBasePathStr$1, Path x$12) {
        return !((String)new StringOps(Predef$.MODULE$.augmentString(fs$1.makeQualified(x$12).toString())).filterNot((Function1 & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToBoolean((boolean)PartitioningAwareFileIndex.$anonfun$basePaths$3(BoxesRunTime.unboxToChar((Object)x$13))))).startsWith((String)new StringOps(Predef$.MODULE$.augmentString(qualifiedBasePathStr$1)).filterNot((Function1 & Serializable & scala.Serializable)x$14 -> BoxesRunTime.boxToBoolean((boolean)PartitioningAwareFileIndex.$anonfun$basePaths$4(BoxesRunTime.unboxToChar((Object)x$14)))));
    }

    public PartitioningAwareFileIndex(SparkSession sparkSession, Map<String, String> parameters, Option<StructType> userSpecifiedSchema, FileStatusCache fileStatusCache) {
        this.sparkSession = sparkSession;
        this.parameters = parameters;
        this.userSpecifiedSchema = userSpecifiedSchema;
        FileIndex.$init$(this);
        Logging.$init$((Logging)this);
        this.hadoopConf = sparkSession.sessionState().newHadoopConfWithOptions(parameters);
        this.caseInsensitiveMap = CaseInsensitiveMap$.MODULE$.apply(parameters);
        this.pathFilters = PathFilterFactory$.MODULE$.create(this.caseInsensitiveMap());
    }
}

