/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.command;

import java.io.Serializable;
import java.time.ZoneId;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.analysis.UnresolvedAttribute;
import org.apache.spark.sql.catalyst.catalog.CatalogColumnStat$;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.SessionCatalog;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeSet;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.catalyst.plans.logical.Command;
import org.apache.spark.sql.catalyst.plans.logical.Histogram;
import org.apache.spark.sql.catalyst.plans.logical.HistogramBin;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Statistics;
import org.apache.spark.sql.catalyst.trees.LeafLike;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.catalyst.util.CaseInsensitiveMap$;
import org.apache.spark.sql.catalyst.util.CharVarcharUtils$;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.execution.command.DescribeColumnCommand$;
import org.apache.spark.sql.execution.command.LeafRunnableCommand;
import org.apache.spark.sql.execution.command.RunnableCommand;
import org.apache.spark.sql.execution.metric.SQLMetric;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.TimestampType$;
import scala.Array$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.IndexedSeq;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\u0005Uh\u0001B\u0010!\u00016B\u0001\"\u0012\u0001\u0003\u0016\u0004%\tA\u0012\u0005\t\u0017\u0002\u0011\t\u0012)A\u0005\u000f\"AA\n\u0001BK\u0002\u0013\u0005Q\n\u0003\u0005c\u0001\tE\t\u0015!\u0003O\u0011!\u0019\u0007A!f\u0001\n\u0003!\u0007\u0002\u00035\u0001\u0005#\u0005\u000b\u0011B3\t\u0011%\u0004!Q3A\u0005B)D\u0001B\u001d\u0001\u0003\u0012\u0003\u0006Ia\u001b\u0005\u0006g\u0002!\t\u0001\u001e\u0005\u0006u\u0002!\te\u001f\u0005\b\u0003\u001b\u0001A\u0011BA\b\u0011\u001d\tI\u0003\u0001C\u0005\u0003WA\u0011\"a\u000e\u0001\u0003\u0003%\t!!\u000f\t\u0013\u0005\r\u0003!%A\u0005\u0002\u0005\u0015\u0003\"CA.\u0001E\u0005I\u0011AA/\u0011%\t\t\u0007AI\u0001\n\u0003\t\u0019\u0007C\u0005\u0002h\u0001\t\n\u0011\"\u0001\u0002j!I\u0011Q\u000e\u0001\u0002\u0002\u0013\u0005\u0013q\u000e\u0005\n\u0003\u007f\u0002\u0011\u0011!C\u0001\u0003\u0003C\u0011\"!#\u0001\u0003\u0003%\t!a#\t\u0013\u0005]\u0005!!A\u0005B\u0005e\u0005\"CAT\u0001\u0005\u0005I\u0011AAU\u0011%\ti\u000bAA\u0001\n\u0003\nykB\u0005\u00024\u0002\n\t\u0011#\u0001\u00026\u001aAq\u0004IA\u0001\u0012\u0003\t9\f\u0003\u0004t3\u0011\u0005\u0011Q\u0019\u0005\n\u0003\u000fL\u0012\u0011!C#\u0003\u0013D\u0011\"a3\u001a\u0003\u0003%\t)!4\t\u0013\u0005]\u0017$!A\u0005\u0002\u0006e\u0007\"CAv3\u0005\u0005I\u0011BAw\u0005U!Um]2sS\n,7i\u001c7v[:\u001cu.\\7b]\u0012T!!\t\u0012\u0002\u000f\r|W.\\1oI*\u00111\u0005J\u0001\nKb,7-\u001e;j_:T!!\n\u0014\u0002\u0007M\fHN\u0003\u0002(Q\u0005)1\u000f]1sW*\u0011\u0011FK\u0001\u0007CB\f7\r[3\u000b\u0003-\n1a\u001c:h\u0007\u0001\u0019R\u0001\u0001\u00189y\t\u0003\"a\f\u001c\u000e\u0003AR!!\r\u001a\u0002\u000f1|w-[2bY*\u00111\u0007N\u0001\u0006a2\fgn\u001d\u0006\u0003k\u0011\n\u0001bY1uC2L8\u000f^\u0005\u0003oA\u00121\u0002T8hS\u000e\fG\u000e\u00157b]B\u0011\u0011HO\u0007\u0002A%\u00111\b\t\u0002\u0014\u0019\u0016\fgMU;o]\u0006\u0014G.Z\"p[6\fg\u000e\u001a\t\u0003{\u0001k\u0011A\u0010\u0006\u0002\u007f\u0005)1oY1mC&\u0011\u0011I\u0010\u0002\b!J|G-^2u!\ti4)\u0003\u0002E}\ta1+\u001a:jC2L'0\u00192mK\u0006)A/\u00192mKV\tq\t\u0005\u0002I\u00136\tA'\u0003\u0002Ki\tyA+\u00192mK&#WM\u001c;jM&,'/\u0001\u0004uC\ndW\rI\u0001\rG>dg*Y7f!\u0006\u0014Ho]\u000b\u0002\u001dB\u0019qj\u0016.\u000f\u0005A+fBA)U\u001b\u0005\u0011&BA*-\u0003\u0019a$o\\8u}%\tq(\u0003\u0002W}\u00059\u0001/Y2lC\u001e,\u0017B\u0001-Z\u0005\r\u0019V-\u001d\u0006\u0003-z\u0002\"aW0\u000f\u0005qk\u0006CA)?\u0013\tqf(\u0001\u0004Qe\u0016$WMZ\u0005\u0003A\u0006\u0014aa\u0015;sS:<'B\u00010?\u00035\u0019w\u000e\u001c(b[\u0016\u0004\u0016M\u001d;tA\u0005Q\u0011n]#yi\u0016tG-\u001a3\u0016\u0003\u0015\u0004\"!\u00104\n\u0005\u001dt$a\u0002\"p_2,\u0017M\\\u0001\fSN,\u0005\u0010^3oI\u0016$\u0007%\u0001\u0004pkR\u0004X\u000f^\u000b\u0002WB\u0019qj\u00167\u0011\u00055\u0004X\"\u00018\u000b\u0005=$\u0014aC3yaJ,7o]5p]NL!!\u001d8\u0003\u0013\u0005#HO]5ckR,\u0017aB8viB,H\u000fI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000bU4x\u000f_=\u0011\u0005e\u0002\u0001\"B#\n\u0001\u00049\u0005\"\u0002'\n\u0001\u0004q\u0005\"B2\n\u0001\u0004)\u0007\"B5\n\u0001\u0004Y\u0017a\u0001:v]R\u0019A0a\u0001\u0011\u0007=;V\u0010\u0005\u0002\u007f\u007f6\tA%C\u0002\u0002\u0002\u0011\u00121AU8x\u0011\u001d\t)A\u0003a\u0001\u0003\u000f\tAb\u001d9be.\u001cVm]:j_:\u00042A`A\u0005\u0013\r\tY\u0001\n\u0002\r'B\f'o[*fgNLwN\\\u0001\u001ai>TvN\\3Bo\u0006\u0014X-\u0012=uKJt\u0017\r\\*ue&tw\rF\u0004[\u0003#\t)\"!\u0007\t\r\u0005M1\u00021\u0001[\u0003!1\u0018\r\\;f'R\u0014\bBBA\f\u0017\u0001\u0007!,\u0001\u0003oC6,\u0007bBA\u000e\u0017\u0001\u0007\u0011QD\u0001\tI\u0006$\u0018\rV=qKB!\u0011qDA\u0013\u001b\t\t\tCC\u0002\u0002$\u0011\nQ\u0001^=qKNLA!a\n\u0002\"\tAA)\u0019;b)f\u0004X-\u0001\u000biSN$xn\u001a:b[\u0012+7o\u0019:jaRLwN\u001c\u000b\u0004y\u00065\u0002bBA\u0018\u0019\u0001\u0007\u0011\u0011G\u0001\nQ&\u001cHo\\4sC6\u00042aLA\u001a\u0013\r\t)\u0004\r\u0002\n\u0011&\u001cHo\\4sC6\fAaY8qsRIQ/a\u000f\u0002>\u0005}\u0012\u0011\t\u0005\b\u000b6\u0001\n\u00111\u0001H\u0011\u001daU\u0002%AA\u00029CqaY\u0007\u0011\u0002\u0003\u0007Q\rC\u0004j\u001bA\u0005\t\u0019A6\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u0011q\t\u0016\u0004\u000f\u0006%3FAA&!\u0011\ti%a\u0016\u000e\u0005\u0005=#\u0002BA)\u0003'\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005Uc(\u0001\u0006b]:|G/\u0019;j_:LA!!\u0017\u0002P\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%eU\u0011\u0011q\f\u0016\u0004\u001d\u0006%\u0013AD2paf$C-\u001a4bk2$HeM\u000b\u0003\u0003KR3!ZA%\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIQ*\"!a\u001b+\u0007-\fI%A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0003c\u0002B!a\u001d\u0002~5\u0011\u0011Q\u000f\u0006\u0005\u0003o\nI(\u0001\u0003mC:<'BAA>\u0003\u0011Q\u0017M^1\n\u0007\u0001\f)(\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0006\u0002\u0002\u0004B\u0019Q(!\"\n\u0007\u0005\u001deHA\u0002J]R\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0002\u000e\u0006M\u0005cA\u001f\u0002\u0010&\u0019\u0011\u0011\u0013 \u0003\u0007\u0005s\u0017\u0010C\u0005\u0002\u0016R\t\t\u00111\u0001\u0002\u0004\u0006\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"!a'\u0011\r\u0005u\u00151UAG\u001b\t\tyJC\u0002\u0002\"z\n!bY8mY\u0016\u001cG/[8o\u0013\u0011\t)+a(\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0004K\u0006-\u0006\"CAK-\u0005\u0005\t\u0019AAG\u0003\u0019)\u0017/^1mgR\u0019Q-!-\t\u0013\u0005Uu#!AA\u0002\u00055\u0015!\u0006#fg\u000e\u0014\u0018NY3D_2,XN\\\"p[6\fg\u000e\u001a\t\u0003se\u0019B!GA]\u0005BI\u00111XAa\u000f:+7.^\u0007\u0003\u0003{S1!a0?\u0003\u001d\u0011XO\u001c;j[\u0016LA!a1\u0002>\n\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\u001c\u001b\u0015\u0005\u0005U\u0016\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u0005E\u0014!B1qa2LH#C;\u0002P\u0006E\u00171[Ak\u0011\u0015)E\u00041\u0001H\u0011\u0015aE\u00041\u0001O\u0011\u0015\u0019G\u00041\u0001f\u0011\u0015IG\u00041\u0001l\u0003\u001d)h.\u00199qYf$B!a7\u0002hB)Q(!8\u0002b&\u0019\u0011q\u001c \u0003\r=\u0003H/[8o!\u001di\u00141]$OK.L1!!:?\u0005\u0019!V\u000f\u001d7fi!A\u0011\u0011^\u000f\u0002\u0002\u0003\u0007Q/A\u0002yIA\n1B]3bIJ+7o\u001c7wKR\u0011\u0011q\u001e\t\u0005\u0003g\n\t0\u0003\u0003\u0002t\u0006U$AB(cU\u0016\u001cG\u000f")
public class DescribeColumnCommand
extends LogicalPlan
implements LeafRunnableCommand,
scala.Serializable {
    private final TableIdentifier table;
    private final Seq<String> colNameParts;
    private final boolean isExtended;
    private final Seq<Attribute> output;
    private Map<String, SQLMetric> metrics;
    private final Seq<Enumeration.Value> nodePatterns;
    private volatile boolean bitmap$0;

    public static Option<Tuple4<TableIdentifier, Seq<String>, Object, Seq<Attribute>>> unapply(DescribeColumnCommand describeColumnCommand) {
        return DescribeColumnCommand$.MODULE$.unapply(describeColumnCommand);
    }

    public static Function1<Tuple4<TableIdentifier, Seq<String>, Object, Seq<Attribute>>, DescribeColumnCommand> tupled() {
        return DescribeColumnCommand$.MODULE$.tupled();
    }

    public static Function1<TableIdentifier, Function1<Seq<String>, Function1<Object, Function1<Seq<Attribute>, DescribeColumnCommand>>>> curried() {
        return DescribeColumnCommand$.MODULE$.curried();
    }

    @Override
    public final Seq<LogicalPlan> children() {
        return LeafLike.children$((LeafLike)this);
    }

    public final TreeNode mapChildren(Function1 f) {
        return LeafLike.mapChildren$((LeafLike)this, (Function1)f);
    }

    public final TreeNode withNewChildrenInternal(IndexedSeq newChildren) {
        return LeafLike.withNewChildrenInternal$((LeafLike)this, (IndexedSeq)newChildren);
    }

    public AttributeSet producedAttributes() {
        return Command.producedAttributes$((Command)this);
    }

    public Statistics stats() {
        return Command.stats$((Command)this);
    }

    private Map<String, SQLMetric> metrics$lzycompute() {
        DescribeColumnCommand describeColumnCommand = this;
        synchronized (describeColumnCommand) {
            if (!this.bitmap$0) {
                this.metrics = RunnableCommand.metrics$(this);
                this.bitmap$0 = true;
            }
        }
        return this.metrics;
    }

    @Override
    public Map<String, SQLMetric> metrics() {
        if (!this.bitmap$0) {
            return this.metrics$lzycompute();
        }
        return this.metrics;
    }

    public final Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    public final void org$apache$spark$sql$catalyst$plans$logical$Command$_setter_$nodePatterns_$eq(Seq<Enumeration.Value> x$1) {
        this.nodePatterns = x$1;
    }

    public TableIdentifier table() {
        return this.table;
    }

    public Seq<String> colNameParts() {
        return this.colNameParts;
    }

    public boolean isExtended() {
        return this.isExtended;
    }

    public Seq<Attribute> output() {
        return this.output;
    }

    @Override
    public Seq<Row> run(SparkSession sparkSession) {
        BoxedUnit boxedUnit;
        SessionCatalog catalog = sparkSession.sessionState().catalog();
        Function2 resolver = sparkSession.sessionState().conf().resolver();
        LogicalPlan relation = sparkSession.table(this.table()).queryExecution().analyzed();
        String colName = new UnresolvedAttribute(this.colNameParts()).name();
        NamedExpression field = (NamedExpression)relation.resolve(this.colNameParts(), resolver).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw QueryCompilationErrors$.MODULE$.columnDoesNotExistError(colName);
        });
        if (!(field instanceof Attribute)) {
            throw QueryCompilationErrors$.MODULE$.commandNotSupportNestedColumnError("DESC TABLE COLUMN", colName);
        }
        CatalogTable catalogTable = catalog.getTempViewOrPermanentTableMetadata(this.table());
        Map colStatsMap = (Map)catalogTable.stats().map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.colStats()).getOrElse((Function0 & Serializable & scala.Serializable)() -> Predef$.MODULE$.Map().empty());
        Map colStats = this.conf().caseSensitiveAnalysis() ? colStatsMap : CaseInsensitiveMap$.MODULE$.apply(colStatsMap);
        Option cs = colStats.get((Object)field.name());
        None$ comment = field.metadata().contains("comment") ? Option$.MODULE$.apply((Object)field.metadata().getString("comment")) : None$.MODULE$;
        String dataType = ((DataType)CharVarcharUtils$.MODULE$.getRawType(field.metadata()).getOrElse((Function0 & Serializable & scala.Serializable)() -> ((Expression)field).dataType())).catalogString();
        ArrayBuffer buffer = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"col_name", field.name()})), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"data_type", dataType})), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"comment", comment.getOrElse((Function0 & Serializable & scala.Serializable)() -> "NULL")}))}));
        if (this.isExtended()) {
            buffer.$plus$eq((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"min", cs.flatMap((Function1 & Serializable & scala.Serializable)x$7 -> x$7.min().map((Function1 & Serializable & scala.Serializable)x$8 -> this.toZoneAwareExternalString((String)x$8, field.name(), ((Expression)field).dataType()))).getOrElse((Function0 & Serializable & scala.Serializable)() -> "NULL")})));
            buffer.$plus$eq((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"max", cs.flatMap((Function1 & Serializable & scala.Serializable)x$9 -> x$9.max().map((Function1 & Serializable & scala.Serializable)x$10 -> this.toZoneAwareExternalString((String)x$10, field.name(), ((Expression)field).dataType()))).getOrElse((Function0 & Serializable & scala.Serializable)() -> "NULL")})));
            buffer.$plus$eq((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"num_nulls", cs.flatMap((Function1 & Serializable & scala.Serializable)x$11 -> x$11.nullCount().map((Function1 & Serializable & scala.Serializable)x$12 -> x$12.toString())).getOrElse((Function0 & Serializable & scala.Serializable)() -> "NULL")})));
            buffer.$plus$eq((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"distinct_count", cs.flatMap((Function1 & Serializable & scala.Serializable)x$13 -> x$13.distinctCount().map((Function1 & Serializable & scala.Serializable)x$14 -> x$14.toString())).getOrElse((Function0 & Serializable & scala.Serializable)() -> "NULL")})));
            buffer.$plus$eq((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"avg_col_len", cs.flatMap((Function1 & Serializable & scala.Serializable)x$15 -> x$15.avgLen().map((Function1 & Serializable & scala.Serializable)x$16 -> DescribeColumnCommand.$anonfun$run$32(BoxesRunTime.unboxToLong((Object)x$16)))).getOrElse((Function0 & Serializable & scala.Serializable)() -> "NULL")})));
            buffer.$plus$eq((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"max_col_len", cs.flatMap((Function1 & Serializable & scala.Serializable)x$17 -> x$17.maxLen().map((Function1 & Serializable & scala.Serializable)x$18 -> DescribeColumnCommand.$anonfun$run$35(BoxesRunTime.unboxToLong((Object)x$18)))).getOrElse((Function0 & Serializable & scala.Serializable)() -> "NULL")})));
            Option histDesc = cs.flatMap((Function1 & Serializable & scala.Serializable)c -> c.histogram().map((Function1 & Serializable & scala.Serializable)hist -> this.histogramDescription((Histogram)hist)));
            boxedUnit = buffer.$plus$plus$eq((TraversableOnce)histDesc.getOrElse((Function0 & Serializable & scala.Serializable)() -> (Seq)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"histogram", "NULL"})), (List)Nil$.MODULE$)));
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return buffer.toSeq();
    }

    private String toZoneAwareExternalString(String valueStr, String name, DataType dataType) {
        DataType dataType2 = dataType;
        if (TimestampType$.MODULE$.equals(dataType2)) {
            Object internalValue = CatalogColumnStat$.MODULE$.fromExternalString(valueStr, name, dataType, CatalogColumnStat$.MODULE$.VERSION());
            ZoneId curZoneId = DateTimeUtils$.MODULE$.getZoneId(SQLConf$.MODULE$.get().sessionLocalTimeZone());
            return CatalogColumnStat$.MODULE$.getTimestampFormatter(false, "yyyy-MM-dd HH:mm:ss.SSSSSS Z", curZoneId).format(BoxesRunTime.unboxToLong((Object)internalValue));
        }
        return valueStr;
    }

    private Seq<Row> histogramDescription(Histogram histogram) {
        Row header = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"histogram", new StringBuilder(23).append("height: ").append(histogram.height()).append(", num_of_bins: ").append(histogram.bins().length).toString()}));
        Row[] bins = (Row[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])histogram.bins())).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                HistogramBin bin = (HistogramBin)tuple2._1();
                int index = tuple2._2$mcI$sp();
                return Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new StringBuilder(4).append("bin_").append(index).toString(), new StringBuilder(46).append("lower_bound: ").append(bin.lo()).append(", upper_bound: ").append(bin.hi()).append(", distinct_count: ").append(bin.ndv()).toString()}));
            }
            throw new MatchError((Object)tuple2);
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Row.class)));
        Row row = header;
        return (Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])bins)).$plus$colon((Object)row, Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()));
    }

    public DescribeColumnCommand copy(TableIdentifier table, Seq<String> colNameParts, boolean isExtended, Seq<Attribute> output) {
        return new DescribeColumnCommand(table, colNameParts, isExtended, output);
    }

    public TableIdentifier copy$default$1() {
        return this.table();
    }

    public Seq<String> copy$default$2() {
        return this.colNameParts();
    }

    public boolean copy$default$3() {
        return this.isExtended();
    }

    public Seq<Attribute> copy$default$4() {
        return this.output();
    }

    public String productPrefix() {
        return "DescribeColumnCommand";
    }

    public int productArity() {
        return 4;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.table();
            }
            case 1: {
                return this.colNameParts();
            }
            case 2: {
                return BoxesRunTime.boxToBoolean((boolean)this.isExtended());
            }
            case 3: {
                return this.output();
            }
        }
        throw new IndexOutOfBoundsException(Integer.toString(x$1));
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof DescribeColumnCommand;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof DescribeColumnCommand)) return false;
        boolean bl = true;
        if (!bl) return false;
        DescribeColumnCommand describeColumnCommand = (DescribeColumnCommand)x$1;
        TableIdentifier tableIdentifier = this.table();
        TableIdentifier tableIdentifier2 = describeColumnCommand.table();
        if (tableIdentifier == null) {
            if (tableIdentifier2 != null) {
                return false;
            }
        } else if (!tableIdentifier.equals(tableIdentifier2)) return false;
        Seq<String> seq = this.colNameParts();
        Seq<String> seq2 = describeColumnCommand.colNameParts();
        if (seq == null) {
            if (seq2 != null) {
                return false;
            }
        } else if (!seq.equals(seq2)) return false;
        if (this.isExtended() != describeColumnCommand.isExtended()) return false;
        Seq<Attribute> seq3 = this.output();
        Seq<Attribute> seq4 = describeColumnCommand.output();
        if (seq3 == null) {
            if (seq4 != null) {
                return false;
            }
        } else if (!seq3.equals(seq4)) return false;
        if (!describeColumnCommand.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ String $anonfun$run$32(long x$16) {
        return Long.toString(x$16);
    }

    public static final /* synthetic */ String $anonfun$run$35(long x$18) {
        return Long.toString(x$18);
    }

    public DescribeColumnCommand(TableIdentifier table, Seq<String> colNameParts, boolean isExtended, Seq<Attribute> output) {
        this.table = table;
        this.colNameParts = colNameParts;
        this.isExtended = isExtended;
        this.output = output;
        Command.$init$((Command)this);
        RunnableCommand.$init$(this);
        LeafLike.$init$((LeafLike)this);
    }
}

