/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.command;

import java.io.Serializable;
import java.util.Locale;
import org.apache.hadoop.fs.Path;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType$;
import org.apache.spark.sql.catalyst.catalog.HiveTableRelation;
import org.apache.spark.sql.catalyst.catalog.HiveTableRelation$;
import org.apache.spark.sql.catalyst.catalog.SessionCatalog;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.execution.datasources.DataSource$;
import org.apache.spark.sql.execution.datasources.DataSourceUtils$;
import org.apache.spark.sql.execution.datasources.FileFormat;
import org.apache.spark.sql.execution.datasources.HadoopFsRelation;
import org.apache.spark.sql.execution.datasources.LogicalRelation;
import org.apache.spark.sql.execution.datasources.v2.FileDataSourceV2;
import org.apache.spark.sql.internal.HiveSerDe;
import org.apache.spark.sql.internal.HiveSerDe$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.sources.BaseRelation;
import org.apache.spark.sql.types.AnsiIntervalType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class DDLUtils$
implements Logging {
    public static DDLUtils$ MODULE$;
    private final String HIVE_PROVIDER;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new DDLUtils$();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String HIVE_PROVIDER() {
        return this.HIVE_PROVIDER;
    }

    public boolean isHiveTable(CatalogTable table) {
        return this.isHiveTable((Option<String>)table.provider());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isHiveTable(Option<String> provider) {
        if (!provider.isDefined()) return false;
        String string = ((String)provider.get()).toLowerCase(Locale.ROOT);
        String string2 = this.HIVE_PROVIDER();
        if (string != null) {
            if (!string.equals(string2)) return false;
            return true;
        }
        if (string2 == null) return true;
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isDatasourceTable(CatalogTable table) {
        if (!table.provider().isDefined()) return false;
        String string = ((String)table.provider().get()).toLowerCase(Locale.ROOT);
        String string2 = this.HIVE_PROVIDER();
        if (string == null) {
            if (string2 == null) return false;
            return true;
        } else if (string.equals(string2)) return false;
        return true;
    }

    public HiveTableRelation readHiveTable(CatalogTable table) {
        return new HiveTableRelation(table, table.dataSchema().asNullable().toAttributes(), table.partitionSchema().asNullable().toAttributes(), HiveTableRelation$.MODULE$.apply$default$4(), HiveTableRelation$.MODULE$.apply$default$5());
    }

    public void verifyPartitionProviderIsHive(SparkSession spark, CatalogTable table, String action) {
        String tableName = table.identifier().table();
        if (!spark.sqlContext().conf().manageFilesourcePartitions() && this.isDatasourceTable(table)) {
            throw QueryCompilationErrors$.MODULE$.actionNotAllowedOnTableWithFilesourcePartitionManagementDisabledError(action, tableName);
        }
        if (!table.tracksPartitionsInCatalog() && this.isDatasourceTable(table)) {
            throw QueryCompilationErrors$.MODULE$.actionNotAllowedOnTableSincePartitionMetadataNotStoredError(action, tableName);
        }
    }

    public void verifyAlterTableType(SessionCatalog catalog, CatalogTable tableMetadata, boolean isView) {
        if (!catalog.isTempView(tableMetadata.identifier())) {
            CatalogTableType catalogTableType = tableMetadata.tableType();
            CatalogTableType catalogTableType2 = CatalogTableType$.MODULE$.VIEW();
            CatalogTableType catalogTableType3 = catalogTableType;
            if (!(catalogTableType2 != null ? !catalogTableType2.equals(catalogTableType3) : catalogTableType3 != null) && !isView) {
                throw QueryCompilationErrors$.MODULE$.cannotAlterViewWithAlterTableError();
            }
            CatalogTableType catalogTableType4 = catalogTableType;
            CatalogTableType catalogTableType5 = CatalogTableType$.MODULE$.VIEW();
            if ((catalogTableType4 == null ? catalogTableType5 != null : !catalogTableType4.equals(catalogTableType5)) && isView) {
                throw QueryCompilationErrors$.MODULE$.cannotAlterTableWithAlterViewError();
            }
            return;
        }
    }

    public void checkTableColumns(CatalogTable table) {
        this.checkTableColumns(table, table.dataSchema());
    }

    public void checkTableColumns(CatalogTable table, StructType schema) {
        table.provider().foreach((Function1 & Serializable & scala.Serializable)x$11 -> {
            DDLUtils$.$anonfun$checkTableColumns$1(table, schema, x$11);
            return BoxedUnit.UNIT;
        });
    }

    public void checkDataColNames(String provider, StructType schema) {
        Object source;
        Object obj;
        try {
            obj = DataSource$.MODULE$.lookupDataSource(provider, SQLConf$.MODULE$.get()).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Throwable e) {
            this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(58).append("Failed to find data source: ").append(provider).append(" when check data column names.").toString(), e);
            return;
        }
        Object obj2 = source = obj;
        if (obj2 instanceof FileFormat) {
            FileFormat fileFormat = (FileFormat)obj2;
            DataSourceUtils$.MODULE$.checkFieldNames(fileFormat, schema);
            return;
        }
        if (obj2 instanceof FileDataSourceV2) {
            FileDataSourceV2 fileDataSourceV2 = (FileDataSourceV2)obj2;
            DataSourceUtils$.MODULE$.checkFieldNames(fileDataSourceV2.fallbackFileFormat().newInstance(), schema);
            return;
        }
    }

    public void verifyNotReadPath(LogicalPlan query, Path outputPath) {
        Seq inputPaths = (Seq)query.collect((PartialFunction)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                LogicalRelation logicalRelation;
                BaseRelation r;
                A1 A1 = x1;
                if (A1 instanceof LogicalRelation && (r = (logicalRelation = (LogicalRelation)A1).relation()) instanceof HadoopFsRelation) {
                    HadoopFsRelation hadoopFsRelation = (HadoopFsRelation)r;
                    return (B1)hadoopFsRelation.location().rootPaths();
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(LogicalPlan x1) {
                LogicalRelation logicalRelation;
                BaseRelation r;
                LogicalPlan logicalPlan2 = x1;
                return logicalPlan2 instanceof LogicalRelation && (r = (logicalRelation = (LogicalRelation)logicalPlan2).relation()) instanceof HadoopFsRelation;
            }
        }).flatten((Function1)Predef$.MODULE$.$conforms());
        if (inputPaths.contains((Object)outputPath)) {
            throw QueryCompilationErrors$.MODULE$.cannotOverwritePathBeingReadFromError();
        }
    }

    public static final /* synthetic */ boolean $anonfun$checkTableColumns$2(StructField x$12) {
        return x$12.dataType() instanceof AnsiIntervalType;
    }

    public static final /* synthetic */ void $anonfun$checkTableColumns$1(CatalogTable table$7, StructType schema$2, String x$11) {
        String string;
        block9: {
            Option serde;
            block11: {
                block10: {
                    string = x$11.toLowerCase(Locale.ROOT);
                    String string2 = MODULE$.HIVE_PROVIDER();
                    String string3 = string;
                    if (string2 != null ? !string2.equals(string3) : string3 != null) break block9;
                    serde = table$7.storage().serde();
                    if (schema$2.exists((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)DDLUtils$.$anonfun$checkTableColumns$2(x$12)))) {
                        throw QueryExecutionErrors$.MODULE$.hiveTableWithAnsiIntervalsError(table$7.identifier().toString());
                    }
                    Option option = serde;
                    Option<String> option2 = ((HiveSerDe)HiveSerDe$.MODULE$.sourceToSerDe("orc").get()).serde();
                    if (!(option != null ? !option.equals(option2) : option2 != null)) {
                        MODULE$.checkDataColNames("orc", schema$2);
                        return;
                    }
                    Option option3 = serde;
                    Option<String> option4 = ((HiveSerDe)HiveSerDe$.MODULE$.sourceToSerDe("parquet").get()).serde();
                    if (!(option3 == null ? option4 != null : !option3.equals(option4))) break block10;
                    Option option5 = serde;
                    Some some = new Some((Object)"parquet.hive.serde.ParquetHiveSerDe");
                    if (!(option5 == null ? some != null : !option5.equals(some))) break block10;
                    Option option6 = serde;
                    Some some2 = new Some((Object)"org.apache.hadoop.hive.ql.io.parquet.serde.ParquetHiveSerDe");
                    if (option6 != null ? !option6.equals(some2) : some2 != null) break block11;
                }
                MODULE$.checkDataColNames("parquet", schema$2);
                return;
            }
            Option option = serde;
            Option<String> option7 = ((HiveSerDe)HiveSerDe$.MODULE$.sourceToSerDe("avro").get()).serde();
            if (!(option != null ? !option.equals(option7) : option7 != null)) {
                MODULE$.checkDataColNames("avro", schema$2);
                return;
            }
            return;
        }
        if ("parquet".equals(string)) {
            MODULE$.checkDataColNames("parquet", schema$2);
            return;
        }
        if ("orc".equals(string)) {
            MODULE$.checkDataColNames("orc", schema$2);
            return;
        }
        if ("avro".equals(string)) {
            MODULE$.checkDataColNames("avro", schema$2);
            return;
        }
    }

    private DDLUtils$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
        this.HIVE_PROVIDER = "hive";
    }
}

