/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.command;

import java.io.Serializable;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.SessionCatalog;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeSet;
import org.apache.spark.sql.catalyst.plans.logical.Command;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Statistics;
import org.apache.spark.sql.catalyst.trees.LeafLike;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.execution.command.AlterTableChangeColumnCommand$;
import org.apache.spark.sql.execution.command.DDLUtils$;
import org.apache.spark.sql.execution.command.LeafRunnableCommand;
import org.apache.spark.sql.execution.command.RunnableCommand;
import org.apache.spark.sql.execution.metric.SQLMetric;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import scala.Array$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Product;
import scala.Tuple3;
import scala.collection.IndexedSeq;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\t-a\u0001B\u000f\u001f\u0001.B\u0001b\u0011\u0001\u0003\u0016\u0004%\t\u0001\u0012\u0005\t\u0013\u0002\u0011\t\u0012)A\u0005\u000b\"A!\n\u0001BK\u0002\u0013\u00051\n\u0003\u0005X\u0001\tE\t\u0015!\u0003M\u0011!A\u0006A!f\u0001\n\u0003I\u0006\u0002\u00031\u0001\u0005#\u0005\u000b\u0011\u0002.\t\u000b\u0005\u0004A\u0011\u00012\t\u000b\u001d\u0004A\u0011\t5\t\u000bm\u0004A\u0011\u0002?\t\u000f\u0005U\u0002\u0001\"\u0003\u00028!9\u0011q\t\u0001\u0005\n\u0005%\u0003\"CA.\u0001\u0005\u0005I\u0011AA/\u0011%\t)\u0007AI\u0001\n\u0003\t9\u0007C\u0005\u0002~\u0001\t\n\u0011\"\u0001\u0002\u0000!I\u00111\u0011\u0001\u0012\u0002\u0013\u0005\u0011Q\u0011\u0005\n\u0003\u0013\u0003\u0011\u0011!C!\u0003\u0017C\u0011\"a'\u0001\u0003\u0003%\t!!(\t\u0013\u0005\u0015\u0006!!A\u0005\u0002\u0005\u001d\u0006\"CAZ\u0001\u0005\u0005I\u0011IA[\u0011%\t\u0019\rAA\u0001\n\u0003\t)\rC\u0005\u0002J\u0002\t\t\u0011\"\u0011\u0002L\u001eI\u0011q\u001a\u0010\u0002\u0002#\u0005\u0011\u0011\u001b\u0004\t;y\t\t\u0011#\u0001\u0002T\"1\u0011m\u0006C\u0001\u0003CD\u0011\"a9\u0018\u0003\u0003%)%!:\t\u0013\u0005\u001dx#!A\u0005\u0002\u0006%\b\"CAy/\u0005\u0005I\u0011QAz\u0011%\u0011\taFA\u0001\n\u0013\u0011\u0019AA\u000fBYR,'\u000fV1cY\u0016\u001c\u0005.\u00198hK\u000e{G.^7o\u0007>lW.\u00198e\u0015\ty\u0002%A\u0004d_6l\u0017M\u001c3\u000b\u0005\u0005\u0012\u0013!C3yK\u000e,H/[8o\u0015\t\u0019C%A\u0002tc2T!!\n\u0014\u0002\u000bM\u0004\u0018M]6\u000b\u0005\u001dB\u0013AB1qC\u000eDWMC\u0001*\u0003\ry'oZ\u0002\u0001'\u0015\u0001AF\u000e\u001eA!\tiC'D\u0001/\u0015\ty\u0003'A\u0004m_\u001eL7-\u00197\u000b\u0005E\u0012\u0014!\u00029mC:\u001c(BA\u001a#\u0003!\u0019\u0017\r^1msN$\u0018BA\u001b/\u0005-aunZ5dC2\u0004F.\u00198\u0011\u0005]BT\"\u0001\u0010\n\u0005er\"a\u0005'fC\u001a\u0014VO\u001c8bE2,7i\\7nC:$\u0007CA\u001e?\u001b\u0005a$\"A\u001f\u0002\u000bM\u001c\u0017\r\\1\n\u0005}b$a\u0002)s_\u0012,8\r\u001e\t\u0003w\u0005K!A\u0011\u001f\u0003\u0019M+'/[1mSj\f'\r\\3\u0002\u0013Q\f'\r\\3OC6,W#A#\u0011\u0005\u0019;U\"\u0001\u001a\n\u0005!\u0013$a\u0004+bE2,\u0017\nZ3oi&4\u0017.\u001a:\u0002\u0015Q\f'\r\\3OC6,\u0007%\u0001\u0006d_2,XN\u001c(b[\u0016,\u0012\u0001\u0014\t\u0003\u001bRs!A\u0014*\u0011\u0005=cT\"\u0001)\u000b\u0005ES\u0013A\u0002\u001fs_>$h(\u0003\u0002Ty\u00051\u0001K]3eK\u001aL!!\u0016,\u0003\rM#(/\u001b8h\u0015\t\u0019F(A\u0006d_2,XN\u001c(b[\u0016\u0004\u0013!\u00038fo\u000e{G.^7o+\u0005Q\u0006CA._\u001b\u0005a&BA/#\u0003\u0015!\u0018\u0010]3t\u0013\tyFLA\u0006TiJ,8\r\u001e$jK2$\u0017A\u00038fo\u000e{G.^7oA\u00051A(\u001b8jiz\"Ba\u00193fMB\u0011q\u0007\u0001\u0005\u0006\u0007\u001e\u0001\r!\u0012\u0005\u0006\u0015\u001e\u0001\r\u0001\u0014\u0005\u00061\u001e\u0001\rAW\u0001\u0004eVtGCA5w!\rQwN\u001d\b\u0003W6t!a\u00147\n\u0003uJ!A\u001c\u001f\u0002\u000fA\f7m[1hK&\u0011\u0001/\u001d\u0002\u0004'\u0016\f(B\u00018=!\t\u0019H/D\u0001#\u0013\t)(EA\u0002S_^DQa\u001e\u0005A\u0002a\fAb\u001d9be.\u001cVm]:j_:\u0004\"a]=\n\u0005i\u0014#\u0001D*qCJ\\7+Z:tS>t\u0017\u0001\u00054j]\u0012\u001cu\u000e\\;n]\nKh*Y7f)\u0019QV0!\u0002\u0002\n!)a0\u0003a\u0001\u007f\u000611o\u00195f[\u0006\u00042aWA\u0001\u0013\r\t\u0019\u0001\u0018\u0002\u000b'R\u0014Xo\u0019;UsB,\u0007BBA\u0004\u0013\u0001\u0007A*\u0001\u0003oC6,\u0007bBA\u0006\u0013\u0001\u0007\u0011QB\u0001\te\u0016\u001cx\u000e\u001c<feB!\u0011qBA\u0018\u001d\u0011\t\t\"a\u000b\u000f\t\u0005M\u0011q\u0005\b\u0005\u0003+\t)C\u0004\u0003\u0002\u0018\u0005\rb\u0002BA\r\u0003CqA!a\u0007\u0002 9\u0019q*!\b\n\u0003%J!a\n\u0015\n\u0005\u00152\u0013BA\u0012%\u0013\t\u0019$%C\u0002\u0002*I\n\u0001\"\u00198bYf\u001c\u0018n]\u0005\u0004]\u00065\"bAA\u0015e%!\u0011\u0011GA\u001a\u0005!\u0011Vm]8mm\u0016\u0014(b\u00018\u0002.\u0005Q\u0011\r\u001a3D_6lWM\u001c;\u0015\u000bi\u000bI$!\u0010\t\r\u0005m\"\u00021\u0001[\u0003\u0019\u0019w\u000e\\;n]\"9\u0011q\b\u0006A\u0002\u0005\u0005\u0013aB2p[6,g\u000e\u001e\t\u0005w\u0005\rC*C\u0002\u0002Fq\u0012aa\u00149uS>t\u0017aC2pYVlg.R9vC2$\u0002\"a\u0013\u0002R\u0005U\u0013\u0011\f\t\u0004w\u00055\u0013bAA(y\t9!i\\8mK\u0006t\u0007BBA*\u0017\u0001\u0007!,A\u0003gS\u0016dG\r\u0003\u0004\u0002X-\u0001\rAW\u0001\u0006_RDWM\u001d\u0005\b\u0003\u0017Y\u0001\u0019AA\u0007\u0003\u0011\u0019w\u000e]=\u0015\u000f\r\fy&!\u0019\u0002d!91\t\u0004I\u0001\u0002\u0004)\u0005b\u0002&\r!\u0003\u0005\r\u0001\u0014\u0005\b12\u0001\n\u00111\u0001[\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"!!\u001b+\u0007\u0015\u000bYg\u000b\u0002\u0002nA!\u0011qNA=\u001b\t\t\tH\u0003\u0003\u0002t\u0005U\u0014!C;oG\",7m[3e\u0015\r\t9\bP\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA>\u0003c\u0012\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII*\"!!!+\u00071\u000bY'\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\u0005\u001d%f\u0001.\u0002l\u0005i\u0001O]8ek\u000e$\bK]3gSb,\"!!$\u0011\t\u0005=\u0015\u0011T\u0007\u0003\u0003#SA!a%\u0002\u0016\u0006!A.\u00198h\u0015\t\t9*\u0001\u0003kCZ\f\u0017bA+\u0002\u0012\u0006a\u0001O]8ek\u000e$\u0018I]5usV\u0011\u0011q\u0014\t\u0004w\u0005\u0005\u0016bAARy\t\u0019\u0011J\u001c;\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!\u0011\u0011VAX!\rY\u00141V\u0005\u0004\u0003[c$aA!os\"I\u0011\u0011\u0017\n\u0002\u0002\u0003\u0007\u0011qT\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u0005]\u0006CBA]\u0003\u007f\u000bI+\u0004\u0002\u0002<*\u0019\u0011Q\u0018\u001f\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002B\u0006m&\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$B!a\u0013\u0002H\"I\u0011\u0011\u0017\u000b\u0002\u0002\u0003\u0007\u0011\u0011V\u0001\u0007KF,\u0018\r\\:\u0015\t\u0005-\u0013Q\u001a\u0005\n\u0003c+\u0012\u0011!a\u0001\u0003S\u000bQ$\u00117uKJ$\u0016M\u00197f\u0007\"\fgnZ3D_2,XN\\\"p[6\fg\u000e\u001a\t\u0003o]\u0019BaFAk\u0001BA\u0011q[Ao\u000b2S6-\u0004\u0002\u0002Z*\u0019\u00111\u001c\u001f\u0002\u000fI,h\u000e^5nK&!\u0011q\\Am\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|gn\r\u000b\u0003\u0003#\f\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0003\u001b\u000bQ!\u00199qYf$raYAv\u0003[\fy\u000fC\u0003D5\u0001\u0007Q\tC\u0003K5\u0001\u0007A\nC\u0003Y5\u0001\u0007!,A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\u0005U\u0018Q \t\u0006w\u0005\r\u0013q\u001f\t\u0007w\u0005eX\t\u0014.\n\u0007\u0005mHH\u0001\u0004UkBdWm\r\u0005\t\u0003\u007f\\\u0012\u0011!a\u0001G\u0006\u0019\u0001\u0010\n\u0019\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0005\u000b\u0001B!a$\u0003\b%!!\u0011BAI\u0005\u0019y%M[3di\u0002")
public class AlterTableChangeColumnCommand
extends LogicalPlan
implements LeafRunnableCommand,
scala.Serializable {
    private final TableIdentifier tableName;
    private final String columnName;
    private final StructField newColumn;
    private Map<String, SQLMetric> metrics;
    private final Seq<Enumeration.Value> nodePatterns;
    private volatile boolean bitmap$0;

    public static Option<Tuple3<TableIdentifier, String, StructField>> unapply(AlterTableChangeColumnCommand alterTableChangeColumnCommand) {
        return AlterTableChangeColumnCommand$.MODULE$.unapply(alterTableChangeColumnCommand);
    }

    public static Function1<Tuple3<TableIdentifier, String, StructField>, AlterTableChangeColumnCommand> tupled() {
        return AlterTableChangeColumnCommand$.MODULE$.tupled();
    }

    public static Function1<TableIdentifier, Function1<String, Function1<StructField, AlterTableChangeColumnCommand>>> curried() {
        return AlterTableChangeColumnCommand$.MODULE$.curried();
    }

    @Override
    public final Seq<LogicalPlan> children() {
        return LeafLike.children$((LeafLike)this);
    }

    public final TreeNode mapChildren(Function1 f) {
        return LeafLike.mapChildren$((LeafLike)this, (Function1)f);
    }

    public final TreeNode withNewChildrenInternal(IndexedSeq newChildren) {
        return LeafLike.withNewChildrenInternal$((LeafLike)this, (IndexedSeq)newChildren);
    }

    public Seq<Attribute> output() {
        return Command.output$((Command)this);
    }

    public AttributeSet producedAttributes() {
        return Command.producedAttributes$((Command)this);
    }

    public Statistics stats() {
        return Command.stats$((Command)this);
    }

    private Map<String, SQLMetric> metrics$lzycompute() {
        AlterTableChangeColumnCommand alterTableChangeColumnCommand = this;
        synchronized (alterTableChangeColumnCommand) {
            if (!this.bitmap$0) {
                this.metrics = RunnableCommand.metrics$(this);
                this.bitmap$0 = true;
            }
        }
        return this.metrics;
    }

    @Override
    public Map<String, SQLMetric> metrics() {
        if (!this.bitmap$0) {
            return this.metrics$lzycompute();
        }
        return this.metrics;
    }

    public final Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    public final void org$apache$spark$sql$catalyst$plans$logical$Command$_setter_$nodePatterns_$eq(Seq<Enumeration.Value> x$1) {
        this.nodePatterns = x$1;
    }

    public TableIdentifier tableName() {
        return this.tableName;
    }

    public String columnName() {
        return this.columnName;
    }

    public StructField newColumn() {
        return this.newColumn;
    }

    @Override
    public Seq<Row> run(SparkSession sparkSession) {
        SessionCatalog catalog = sparkSession.sessionState().catalog();
        CatalogTable table = catalog.getTableRawMetadata(this.tableName());
        Function2 resolver = sparkSession.sessionState().conf().resolver();
        DDLUtils$.MODULE$.verifyAlterTableType(catalog, table, false);
        StructField originColumn = this.findColumnByName(table.dataSchema(), this.columnName(), (Function2<String, String, Object>)resolver);
        if (!this.columnEqual(originColumn, this.newColumn(), (Function2<String, String, Object>)resolver)) {
            throw QueryCompilationErrors$.MODULE$.alterTableChangeColumnNotSupportedForColumnTypeError(originColumn, this.newColumn());
        }
        StructField[] newDataSchema = (StructField[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])table.dataSchema().fields())).map((Function1 & Serializable & scala.Serializable)field -> {
            String string = field.name();
            String string2 = originColumn.name();
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                return this.addComment((StructField)field, (Option<String>)this.newColumn().getComment());
            }
            return field;
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(StructField.class)));
        catalog.alterTableDataSchema(this.tableName(), new StructType(newDataSchema));
        return (Seq)Nil$.MODULE$;
    }

    private StructField findColumnByName(StructType schema, String name, Function2<String, String, Object> resolver) {
        return (StructField)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])schema.fields())).collectFirst((PartialFunction)new scala.Serializable(null, resolver, name){
            public static final long serialVersionUID = 0L;
            private final Function2 resolver$1;
            private final String name$1;

            public final <A1 extends StructField, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (BoxesRunTime.unboxToBoolean((Object)this.resolver$1.apply((Object)A1.name(), (Object)this.name$1))) {
                    return (B1)A1;
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(StructField x1) {
                StructField structField = x1;
                return BoxesRunTime.unboxToBoolean((Object)this.resolver$1.apply((Object)structField.name(), (Object)this.name$1));
            }
            {
                this.resolver$1 = resolver$1;
                this.name$1 = name$1;
            }
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw QueryCompilationErrors$.MODULE$.cannotFindColumnError(name, schema.fieldNames());
        });
    }

    private StructField addComment(StructField column, Option<String> comment2) {
        return (StructField)comment2.map((Function1 & Serializable & scala.Serializable)comment -> column.withComment(comment)).getOrElse((Function0 & Serializable & scala.Serializable)() -> column);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean columnEqual(StructField field, StructField other, Function2<String, String, Object> resolver) {
        if (!BoxesRunTime.unboxToBoolean((Object)resolver.apply((Object)field.name(), (Object)other.name()))) return false;
        DataType dataType = field.dataType();
        DataType dataType2 = other.dataType();
        if (dataType != null) {
            if (!dataType.equals(dataType2)) return false;
            return true;
        }
        if (dataType2 == null) return true;
        return false;
    }

    public AlterTableChangeColumnCommand copy(TableIdentifier tableName, String columnName, StructField newColumn) {
        return new AlterTableChangeColumnCommand(tableName, columnName, newColumn);
    }

    public TableIdentifier copy$default$1() {
        return this.tableName();
    }

    public String copy$default$2() {
        return this.columnName();
    }

    public StructField copy$default$3() {
        return this.newColumn();
    }

    public String productPrefix() {
        return "AlterTableChangeColumnCommand";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.tableName();
            }
            case 1: {
                return this.columnName();
            }
            case 2: {
                return this.newColumn();
            }
        }
        throw new IndexOutOfBoundsException(Integer.toString(x$1));
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof AlterTableChangeColumnCommand;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof AlterTableChangeColumnCommand)) return false;
        boolean bl = true;
        if (!bl) return false;
        AlterTableChangeColumnCommand alterTableChangeColumnCommand = (AlterTableChangeColumnCommand)x$1;
        TableIdentifier tableIdentifier = this.tableName();
        TableIdentifier tableIdentifier2 = alterTableChangeColumnCommand.tableName();
        if (tableIdentifier == null) {
            if (tableIdentifier2 != null) {
                return false;
            }
        } else if (!tableIdentifier.equals(tableIdentifier2)) return false;
        String string = this.columnName();
        String string2 = alterTableChangeColumnCommand.columnName();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        StructField structField = this.newColumn();
        StructField structField2 = alterTableChangeColumnCommand.newColumn();
        if (structField == null) {
            if (structField2 != null) {
                return false;
            }
        } else if (!structField.equals(structField2)) return false;
        if (!alterTableChangeColumnCommand.canEqual(this)) return false;
        return true;
    }

    public AlterTableChangeColumnCommand(TableIdentifier tableName, String columnName, StructField newColumn) {
        this.tableName = tableName;
        this.columnName = columnName;
        this.newColumn = newColumn;
        Command.$init$((Command)this);
        RunnableCommand.$init$(this);
        LeafLike.$init$((LeafLike)this);
    }
}

