/*
 * Decompiled with CFR 0.152.
 */
package test.org.apache.spark.sql;

import com.google.common.primitives.Ints;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.RowFactory;
import org.apache.spark.sql.api.java.UDF2;
import org.apache.spark.sql.expressions.UserDefinedFunction;
import org.apache.spark.sql.functions;
import org.apache.spark.sql.test.TestSparkSession;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.util.sketch.BloomFilter;
import org.apache.spark.util.sketch.CountMinSketch;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import scala.collection.JavaConverters;
import scala.collection.Seq;

public class JavaDataFrameSuite {
    private transient TestSparkSession spark;
    private transient JavaSparkContext jsc;
    private static final Comparator<Row> crosstabRowComparator = (row1, row2) -> {
        String item1 = row1.getString(0);
        String item2 = row2.getString(0);
        return item1.compareTo(item2);
    };

    @Before
    public void setUp() {
        this.spark = new TestSparkSession();
        this.jsc = new JavaSparkContext(this.spark.sparkContext());
        this.spark.loadTestData();
    }

    @After
    public void tearDown() {
        this.spark.stop();
        this.spark = null;
    }

    @Test
    public void testExecution() {
        Dataset df = this.spark.table("testData").filter("key = 1");
        Assert.assertEquals((Object)1, (Object)((Row)df.select("key", new String[0]).collectAsList().get(0)).get(0));
    }

    @Test
    public void testCollectAndTake() {
        Dataset df = this.spark.table("testData").filter("key = 1 or key = 2 or key = 3");
        Assert.assertEquals((long)3L, (long)df.select("key", new String[0]).collectAsList().size());
        Assert.assertEquals((long)2L, (long)df.select("key", new String[0]).takeAsList(2).size());
    }

    @Test
    public void testVarargMethods() {
        Dataset df = this.spark.table("testData");
        df.toDF(new String[]{"key1", "value1"});
        df.select("key", new String[]{"value"});
        df.select(new Column[]{functions.col((String)"key"), functions.col((String)"value")});
        df.selectExpr(new String[]{"key", "value + 1"});
        df.sort("key", new String[]{"value"});
        df.sort(new Column[]{functions.col((String)"key"), functions.col((String)"value")});
        df.orderBy("key", new String[]{"value"});
        df.orderBy(new Column[]{functions.col((String)"key"), functions.col((String)"value")});
        df.groupBy("key", new String[]{"value"}).agg(functions.col((String)"key"), new Column[]{functions.col((String)"value"), functions.sum((String)"value")});
        df.groupBy(new Column[]{functions.col((String)"key"), functions.col((String)"value")}).agg(functions.col((String)"key"), new Column[]{functions.col((String)"value"), functions.sum((String)"value")});
        df.agg(functions.first((String)"key"), new Column[]{functions.sum((String)"value")});
        df.groupBy(new Column[0]).avg(new String[]{"key"});
        df.groupBy(new Column[0]).mean(new String[]{"key"});
        df.groupBy(new Column[0]).max(new String[]{"key"});
        df.groupBy(new Column[0]).min(new String[]{"key"});
        df.groupBy(new Column[0]).sum(new String[]{"key"});
        df.groupBy(new Column[0]).agg(functions.countDistinct((String)"key", (String[])new String[]{"value"}), new Column[0]);
        df.groupBy(new Column[0]).agg(functions.count_distinct((Column)functions.col((String)"key"), (Column[])new Column[]{functions.col((String)"value")}), new Column[0]);
        df.select(new Column[]{functions.coalesce((Column[])new Column[]{functions.col((String)"key")})});
        Dataset df2 = this.spark.table("testData2");
        df2.select(new Column[]{functions.exp((String)"a"), functions.exp((String)"b")});
        df2.select(new Column[]{functions.exp((Column)functions.log((String)"a"))});
        df2.select(new Column[]{functions.pow((String)"a", (String)"a"), functions.pow((String)"b", (double)2.0)});
        df2.select(new Column[]{functions.pow((Column)functions.col((String)"a"), (Column)functions.col((String)"b")), functions.exp((String)"b")});
        df2.select(new Column[]{functions.sin((String)"a"), functions.acos((String)"b")});
        df2.select(new Column[]{functions.rand(), functions.acos((String)"b")});
        df2.select(new Column[]{functions.col((String)"*"), functions.randn((long)5L)});
    }

    @Ignore
    public void testShow() {
        Dataset df = this.spark.table("testData");
        df.show();
        df.show(1000);
    }

    void validateDataFrameWithBeans(Bean bean, Dataset<Row> df) {
        StructType schema = df.schema();
        Assert.assertEquals((Object)new StructField("a", (DataType)DoubleType$.MODULE$, false, Metadata.empty()), (Object)schema.apply("a"));
        Assert.assertEquals((Object)new StructField("b", (DataType)new ArrayType((DataType)IntegerType$.MODULE$, true), true, Metadata.empty()), (Object)schema.apply("b"));
        ArrayType valueType = new ArrayType(DataTypes.IntegerType, false);
        MapType mapType = new MapType(DataTypes.StringType, (DataType)valueType, true);
        Assert.assertEquals((Object)new StructField("c", (DataType)mapType, true, Metadata.empty()), (Object)schema.apply("c"));
        Assert.assertEquals((Object)new StructField("d", (DataType)new ArrayType(DataTypes.StringType, true), true, Metadata.empty()), (Object)schema.apply("d"));
        Assert.assertEquals((Object)new StructField("e", (DataType)DataTypes.createDecimalType((int)38, (int)0), true, Metadata.empty()), (Object)schema.apply("e"));
        StructType nestedBeanType = DataTypes.createStructType(Collections.singletonList(new StructField("a", (DataType)IntegerType$.MODULE$, false, Metadata.empty())));
        Assert.assertEquals((Object)new StructField("f", (DataType)nestedBeanType, true, Metadata.empty()), (Object)schema.apply("f"));
        Assert.assertEquals((Object)new StructField("g", (DataType)nestedBeanType, true, Metadata.empty()), (Object)schema.apply("g"));
        Row first = (Row)df.select("a", new String[]{"b", "c", "d", "e", "f", "g"}).first();
        Assert.assertEquals((double)bean.getA(), (double)first.getDouble(0), (double)0.0);
        Seq result = (Seq)first.getAs(1);
        Assert.assertEquals((long)bean.getB().length, (long)result.length());
        for (int i = 0; i < result.length(); ++i) {
            Assert.assertEquals((Object)bean.getB()[i], (Object)result.apply(i));
        }
        Seq outputBuffer = (Seq)first.getJavaMap(2).get("hello");
        Assert.assertArrayEquals((int[])bean.getC().get("hello"), (int[])Ints.toArray((Collection)((Collection)JavaConverters.seqAsJavaListConverter((Seq)outputBuffer).asJava())));
        Seq d = (Seq)first.getAs(3);
        Assert.assertEquals((long)bean.getD().size(), (long)d.length());
        for (int i = 0; i < d.length(); ++i) {
            Assert.assertEquals((Object)bean.getD().get(i), (Object)d.apply(i));
        }
        Assert.assertEquals((Object)new BigDecimal(bean.getE()), (Object)first.getDecimal(4));
        Row nested = first.getStruct(5);
        Assert.assertEquals((long)bean.getF().getA(), (long)nested.getInt(0));
        Assert.assertTrue((boolean)first.isNullAt(6));
    }

    @Test
    public void testCreateDataFrameFromLocalJavaBeans() {
        Bean bean = new Bean();
        List<Bean> data = Arrays.asList(bean);
        Dataset df = this.spark.createDataFrame(data, Bean.class);
        this.validateDataFrameWithBeans(bean, (Dataset<Row>)df);
    }

    @Test
    public void testCreateDataFrameFromJavaBeans() {
        Bean bean = new Bean();
        JavaRDD rdd = this.jsc.parallelize(Arrays.asList(bean));
        Dataset df = this.spark.createDataFrame(rdd, Bean.class);
        this.validateDataFrameWithBeans(bean, (Dataset<Row>)df);
    }

    @Test
    public void testCreateDataFromFromList() {
        StructType schema = DataTypes.createStructType(Arrays.asList(DataTypes.createStructField((String)"i", (DataType)DataTypes.IntegerType, (boolean)true)));
        List<Row> rows = Arrays.asList(RowFactory.create((Object[])new Object[]{0}));
        Dataset df = this.spark.createDataFrame(rows, schema);
        List result = df.collectAsList();
        Assert.assertEquals((long)1L, (long)result.size());
    }

    @Test
    public void testCreateStructTypeFromList() {
        ArrayList<StructField> fields1 = new ArrayList<StructField>();
        fields1.add(new StructField("id", DataTypes.StringType, true, Metadata.empty()));
        StructType schema1 = StructType$.MODULE$.apply(fields1);
        Assert.assertEquals((long)0L, (long)schema1.fieldIndex("id"));
        List<StructField> fields2 = Arrays.asList(new StructField("id", DataTypes.StringType, true, Metadata.empty()));
        StructType schema2 = StructType$.MODULE$.apply(fields2);
        Assert.assertEquals((long)0L, (long)schema2.fieldIndex("id"));
    }

    @Test
    public void testCrosstab() {
        Dataset df = this.spark.table("testData2");
        Dataset crosstab = df.stat().crosstab("a", "b");
        String[] columnNames = crosstab.schema().fieldNames();
        Assert.assertEquals((Object)"a_b", (Object)columnNames[0]);
        Assert.assertEquals((Object)"1", (Object)columnNames[1]);
        Assert.assertEquals((Object)"2", (Object)columnNames[2]);
        List rows = crosstab.collectAsList();
        rows.sort(crosstabRowComparator);
        Integer count = 1;
        for (Row row : rows) {
            Assert.assertEquals((Object)row.get(0).toString(), (Object)count.toString());
            Assert.assertEquals((long)1L, (long)row.getLong(1));
            Assert.assertEquals((long)1L, (long)row.getLong(2));
            Integer n = count;
            Integer n2 = count = Integer.valueOf(count + 1);
        }
    }

    @Test
    public void testFrequentItems() {
        Dataset df = this.spark.table("testData2");
        String[] cols = new String[]{"a"};
        Dataset results = df.stat().freqItems(cols, 0.2);
        Assert.assertTrue((boolean)((Row)results.collectAsList().get(0)).getSeq(0).contains((Object)1));
    }

    @Test
    public void testCorrelation() {
        Dataset df = this.spark.table("testData2");
        Double pearsonCorr = df.stat().corr("a", "b", "pearson");
        Assert.assertTrue((Math.abs(pearsonCorr) < 1.0E-6 ? 1 : 0) != 0);
    }

    @Test
    public void testCovariance() {
        Dataset df = this.spark.table("testData2");
        Double result = df.stat().cov("a", "b");
        Assert.assertTrue((Math.abs(result) < 1.0E-6 ? 1 : 0) != 0);
    }

    @Test
    public void testSampleBy() {
        Dataset df = this.spark.range(0L, 100L, 1L, 2).select(new Column[]{functions.col((String)"id").mod((Object)3).as("key")});
        Dataset sampled = df.stat().sampleBy("key", Map.of(0, 0.1, 1, 0.2), 0L);
        List actual = sampled.groupBy("key", new String[0]).count().orderBy("key", new String[0]).collectAsList();
        Assert.assertEquals((long)0L, (long)((Row)actual.get(0)).getLong(0));
        Assert.assertTrue((0L <= ((Row)actual.get(0)).getLong(1) && ((Row)actual.get(0)).getLong(1) <= 8L ? 1 : 0) != 0);
        Assert.assertEquals((long)1L, (long)((Row)actual.get(1)).getLong(0));
        Assert.assertTrue((2L <= ((Row)actual.get(1)).getLong(1) && ((Row)actual.get(1)).getLong(1) <= 13L ? 1 : 0) != 0);
    }

    @Test
    public void testwithColumns() {
        Dataset df = this.spark.table("testData2");
        HashMap<String, Column> colMaps = new HashMap<String, Column>();
        colMaps.put("a1", functions.col((String)"a"));
        colMaps.put("b1", functions.col((String)"b"));
        StructType expected = df.withColumn("a1", functions.col((String)"a")).withColumn("b1", functions.col((String)"b")).schema();
        StructType actual = df.withColumns(colMaps).schema();
        Assert.assertEquals((Object)expected, (Object)actual);
        Assert.assertArrayEquals((Object[])actual.fieldNames(), (Object[])new String[]{"a", "b", "a1", "b1"});
    }

    @Test
    public void testSampleByColumn() {
        Dataset df = this.spark.range(0L, 100L, 1L, 2).select(new Column[]{functions.col((String)"id").mod((Object)3).as("key")});
        Dataset sampled = df.stat().sampleBy(functions.col((String)"key"), Map.of(0, 0.1, 1, 0.2), 0L);
        List actual = sampled.groupBy("key", new String[0]).count().orderBy("key", new String[0]).collectAsList();
        Assert.assertEquals((long)0L, (long)((Row)actual.get(0)).getLong(0));
        Assert.assertTrue((0L <= ((Row)actual.get(0)).getLong(1) && ((Row)actual.get(0)).getLong(1) <= 8L ? 1 : 0) != 0);
        Assert.assertEquals((long)1L, (long)((Row)actual.get(1)).getLong(0));
        Assert.assertTrue((2L <= ((Row)actual.get(1)).getLong(1) && ((Row)actual.get(1)).getLong(1) <= 13L ? 1 : 0) != 0);
    }

    @Test
    public void pivot() {
        Dataset df = this.spark.table("courseSales");
        List actual = df.groupBy("year", new String[0]).pivot("course", Arrays.asList("dotNET", "Java")).agg(functions.sum((String)"earnings"), new Column[0]).orderBy("year", new String[0]).collectAsList();
        Assert.assertEquals((long)2012L, (long)((Row)actual.get(0)).getInt(0));
        Assert.assertEquals((double)15000.0, (double)((Row)actual.get(0)).getDouble(1), (double)0.01);
        Assert.assertEquals((double)20000.0, (double)((Row)actual.get(0)).getDouble(2), (double)0.01);
        Assert.assertEquals((long)2013L, (long)((Row)actual.get(1)).getInt(0));
        Assert.assertEquals((double)48000.0, (double)((Row)actual.get(1)).getDouble(1), (double)0.01);
        Assert.assertEquals((double)30000.0, (double)((Row)actual.get(1)).getDouble(2), (double)0.01);
    }

    @Test
    public void pivotColumnValues() {
        Dataset df = this.spark.table("courseSales");
        List actual = df.groupBy("year", new String[0]).pivot(functions.col((String)"course"), Arrays.asList(functions.lit((Object)"dotNET"), functions.lit((Object)"Java"))).agg(functions.sum((String)"earnings"), new Column[0]).orderBy("year", new String[0]).collectAsList();
        Assert.assertEquals((long)2012L, (long)((Row)actual.get(0)).getInt(0));
        Assert.assertEquals((double)15000.0, (double)((Row)actual.get(0)).getDouble(1), (double)0.01);
        Assert.assertEquals((double)20000.0, (double)((Row)actual.get(0)).getDouble(2), (double)0.01);
        Assert.assertEquals((long)2013L, (long)((Row)actual.get(1)).getInt(0));
        Assert.assertEquals((double)48000.0, (double)((Row)actual.get(1)).getDouble(1), (double)0.01);
        Assert.assertEquals((double)30000.0, (double)((Row)actual.get(1)).getDouble(2), (double)0.01);
    }

    private String getResource(String resource) {
        try {
            URL url = Thread.currentThread().getContextClassLoader().getResource(resource);
            return url.toURI().getPath();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    @Test
    public void testGenericLoad() {
        Dataset df1 = this.spark.read().format("text").load(this.getResource("test-data/text-suite.txt"));
        Assert.assertEquals((long)4L, (long)df1.count());
        Dataset df2 = this.spark.read().format("text").load(new String[]{this.getResource("test-data/text-suite.txt"), this.getResource("test-data/text-suite2.txt")});
        Assert.assertEquals((long)5L, (long)df2.count());
    }

    @Test
    public void testTextLoad() {
        Dataset ds1 = this.spark.read().textFile(this.getResource("test-data/text-suite.txt"));
        Assert.assertEquals((long)4L, (long)ds1.count());
        Dataset ds2 = this.spark.read().textFile(new String[]{this.getResource("test-data/text-suite.txt"), this.getResource("test-data/text-suite2.txt")});
        Assert.assertEquals((long)5L, (long)ds2.count());
    }

    @Test
    public void testCountMinSketch() {
        Dataset df = this.spark.range(1000L);
        CountMinSketch sketch1 = df.stat().countMinSketch("id", 10, 20, 42);
        Assert.assertEquals((long)1000L, (long)sketch1.totalCount());
        Assert.assertEquals((long)10L, (long)sketch1.depth());
        Assert.assertEquals((long)20L, (long)sketch1.width());
        CountMinSketch sketch2 = df.stat().countMinSketch(functions.col((String)"id"), 10, 20, 42);
        Assert.assertEquals((long)1000L, (long)sketch2.totalCount());
        Assert.assertEquals((long)10L, (long)sketch2.depth());
        Assert.assertEquals((long)20L, (long)sketch2.width());
        CountMinSketch sketch3 = df.stat().countMinSketch("id", 0.001, 0.99, 42);
        Assert.assertEquals((long)1000L, (long)sketch3.totalCount());
        Assert.assertEquals((double)0.001, (double)sketch3.relativeError(), (double)1.0E-4);
        Assert.assertEquals((double)0.99, (double)sketch3.confidence(), (double)0.005);
        CountMinSketch sketch4 = df.stat().countMinSketch(functions.col((String)"id"), 0.001, 0.99, 42);
        Assert.assertEquals((long)1000L, (long)sketch4.totalCount());
        Assert.assertEquals((double)0.001, (double)sketch4.relativeError(), (double)1.0E-4);
        Assert.assertEquals((double)0.99, (double)sketch4.confidence(), (double)0.005);
    }

    @Test
    public void testBloomFilter() {
        Dataset df = this.spark.range(1000L);
        BloomFilter filter1 = df.stat().bloomFilter("id", 1000L, 0.03);
        Assert.assertTrue((filter1.expectedFpp() - 0.03 < 0.001 ? 1 : 0) != 0);
        for (int i = 0; i < 1000; ++i) {
            Assert.assertTrue((boolean)filter1.mightContain((Object)i));
        }
        BloomFilter filter2 = df.stat().bloomFilter(functions.col((String)"id").multiply((Object)3), 1000L, 0.03);
        Assert.assertTrue((filter2.expectedFpp() - 0.03 < 0.001 ? 1 : 0) != 0);
        for (int i = 0; i < 1000; ++i) {
            Assert.assertTrue((boolean)filter2.mightContain((Object)(i * 3)));
        }
        BloomFilter filter3 = df.stat().bloomFilter("id", 1000L, 320L);
        Assert.assertEquals((long)320L, (long)filter3.bitSize());
        for (int i = 0; i < 1000; ++i) {
            Assert.assertTrue((boolean)filter3.mightContain((Object)i));
        }
        BloomFilter filter4 = df.stat().bloomFilter(functions.col((String)"id").multiply((Object)3), 1000L, 320L);
        Assert.assertEquals((long)320L, (long)filter4.bitSize());
        for (int i = 0; i < 1000; ++i) {
            Assert.assertTrue((boolean)filter4.mightContain((Object)(i * 3)));
        }
    }

    @Test
    public void testBeanWithoutGetter() {
        BeanWithoutGetter bean = new BeanWithoutGetter();
        List<BeanWithoutGetter> data = Arrays.asList(bean);
        Dataset df = this.spark.createDataFrame(data, BeanWithoutGetter.class);
        Assert.assertEquals((long)0L, (long)df.schema().length());
        Assert.assertEquals((long)1L, (long)df.collectAsList().size());
    }

    @Test
    public void testJsonRDDToDataFrame() {
        JavaRDD rdd = this.jsc.parallelize(Arrays.asList("{\"a\": 2}"));
        Dataset df = this.spark.read().json(rdd);
        Assert.assertEquals((long)1L, (long)df.count());
        Assert.assertEquals((long)2L, (long)((Row)df.collectAsList().get(0)).getLong(0));
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testCircularReferenceBean() {
        CircularReference1Bean bean = new CircularReference1Bean();
        this.spark.createDataFrame(Arrays.asList(bean), CircularReference1Bean.class);
    }

    @Test
    public void testUDF() {
        UserDefinedFunction foo = functions.udf((UDF2 & Serializable)(i, s) -> i.toString() + s, (DataType)DataTypes.StringType);
        Dataset df = this.spark.table("testData").select(new Column[]{foo.apply(new Column[]{functions.col((String)"key"), functions.col((String)"value")})});
        Object[] result = (String[])df.collectAsList().stream().map(row -> row.getString(0)).toArray(String[]::new);
        Object[] expected = (String[])this.spark.table("testData").collectAsList().stream().map(row -> row.get(0).toString() + row.getString(1)).toArray(String[]::new);
        Assert.assertArrayEquals((Object[])expected, (Object[])result);
    }

    public class CircularReference2Bean
    implements Serializable {
        private CircularReference1Bean child;

        public CircularReference1Bean getChild() {
            return this.child;
        }

        public void setChild(CircularReference1Bean child) {
            this.child = child;
        }
    }

    public class CircularReference1Bean
    implements Serializable {
        private CircularReference2Bean child;

        public CircularReference2Bean getChild() {
            return this.child;
        }

        public void setChild(CircularReference2Bean child) {
            this.child = child;
        }
    }

    public static class BeanWithoutGetter
    implements Serializable {
        private String a;

        public void setA(String a) {
            this.a = a;
        }
    }

    public static class Bean
    implements Serializable {
        private double a = 0.0;
        private Integer[] b = new Integer[]{0, 1};
        private Map<String, int[]> c = Map.of("hello", new int[]{1, 2});
        private List<String> d = Arrays.asList("floppy", "disk");
        private BigInteger e = new BigInteger("1234567");
        private NestedBean f = new NestedBean();
        private NestedBean g = null;

        public double getA() {
            return this.a;
        }

        public Integer[] getB() {
            return this.b;
        }

        public Map<String, int[]> getC() {
            return this.c;
        }

        public List<String> getD() {
            return this.d;
        }

        public BigInteger getE() {
            return this.e;
        }

        public NestedBean getF() {
            return this.f;
        }

        public NestedBean getG() {
            return this.g;
        }

        public static class NestedBean
        implements Serializable {
            private int a = 1;

            public int getA() {
                return this.a;
            }
        }
    }
}

