/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.command;

import java.io.Serializable;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.QueryTest$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.execution.CachedData;
import org.apache.spark.sql.execution.command.DDLCommandTestUtils;
import org.apache.spark.storage.StorageLevel;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEquals;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001E3q!\u0002\u0004\u0011\u0002\u0007\u00051\u0003C\u0003\u001d\u0001\u0011\u0005Q\u0004C\u0004\b\u0001\t\u0007I\u0011\t\u0013\t\u00175\u0002\u0001\u0013aA\u0001\u0002\u0013%af\u0013\u0005\f[\u0001\u0001\n1!A\u0001\n\u0013i\u0005KA\rBYR,'\u000fV1cY\u0016\u0014VM\\1nKN+\u0018\u000e^3CCN,'BA\u0004\t\u0003\u001d\u0019w.\\7b]\u0012T!!\u0003\u0006\u0002\u0013\u0015DXmY;uS>t'BA\u0006\r\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003\u001b9\tQa\u001d9be.T!a\u0004\t\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\t\u0012aA8sO\u000e\u00011c\u0001\u0001\u00151A\u0011QCF\u0007\u0002\u0015%\u0011qC\u0003\u0002\n#V,'/\u001f+fgR\u0004\"!\u0007\u000e\u000e\u0003\u0019I!a\u0007\u0004\u0003'\u0011#EjQ8n[\u0006tG\rV3tiV#\u0018\u000e\\:\u0002\r\u0011Jg.\u001b;%)\u0005q\u0002CA\u0010#\u001b\u0005\u0001#\"A\u0011\u0002\u000bM\u001c\u0017\r\\1\n\u0005\r\u0002#\u0001B+oSR,\u0012!\n\t\u0003M-j\u0011a\n\u0006\u0003Q%\nA\u0001\\1oO*\t!&\u0001\u0003kCZ\f\u0017B\u0001\u0017(\u0005\u0019\u0019FO]5oO\u0006\t2/\u001e9fe\u0012\u001a\u0007.Z2l\u0003:\u001cx/\u001a:\u0015\u0007yy3\b\u0003\u00041\u0007\u0011\u0005\r!M\u0001\u0003I\u001a\u00042a\b\u001a5\u0013\t\u0019\u0004E\u0001\u0005=Eft\u0017-\\3?!\t)\u0004H\u0004\u0002\u0016m%\u0011qGC\u0001\ba\u0006\u001c7.Y4f\u0013\tI$HA\u0005ECR\fgI]1nK*\u0011qG\u0003\u0005\u0006y\r\u0001\r!P\u0001\u000fKb\u0004Xm\u0019;fI\u0006s7o^3s!\rqT\t\u0013\b\u0003\u007f\u0011s!\u0001Q\"\u000e\u0003\u0005S!A\u0011\n\u0002\rq\u0012xn\u001c;?\u0013\u0005\t\u0013BA\u001c!\u0013\t1uIA\u0002TKFT!a\u000e\u0011\u0011\u0005UI\u0015B\u0001&\u000b\u0005\r\u0011vn^\u0005\u0003\u0019Z\t1b\u00195fG.\fen]<feR\u0019aDT(\t\rA\"A\u00111\u00012\u0011\u0015aD\u00011\u0001I\u0013\tae\u0003")
public interface AlterTableRenameSuiteBase
extends DDLCommandTestUtils {
    public void org$apache$spark$sql$execution$command$AlterTableRenameSuiteBase$_setter_$command_$eq(String var1);

    public /* synthetic */ void org$apache$spark$sql$execution$command$AlterTableRenameSuiteBase$$super$checkAnswer(Function0 var1, Seq var2);

    public /* synthetic */ void org$apache$spark$sql$execution$command$AlterTableRenameSuiteBase$$super$checkAnswer(Function0 var1, Row var2);

    @Override
    public String command();

    public static /* synthetic */ void $anonfun$$init$$2(AlterTableRenameSuiteBase $this, String dst) {
        String src = dst.replace("dst", "src");
        $this.sql().apply((Object)new StringBuilder(23).append("CREATE TABLE ").append(src).append(" (c0 INT) ").append($this.defaultUsing()).toString());
        $this.sql().apply((Object)new StringBuilder(21).append("INSERT INTO ").append(src).append(" SELECT 0").toString());
        $this.sql().apply((Object)new StringBuilder(33).append("ALTER TABLE ").append(src).append(" RENAME TO ns.dst_tbl").toString());
        $this.checkTables("ns", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"dst_tbl"}));
        QueryTest$.MODULE$.checkAnswer((Dataset<Row>)((Dataset)$this.sql().apply((Object)new StringBuilder(15).append("SELECT c0 FROM ").append(dst).toString())), (Seq<Row>)((Seq)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)0)})), (List)Nil$.MODULE$)), QueryTest$.MODULE$.checkAnswer$default$3());
    }

    public static /* synthetic */ void $anonfun$$init$$6(AlterTableRenameSuiteBase $this, String dst) {
        String src = dst.replace("dst", "src");
        $this.sql().apply((Object)new StringBuilder(23).append("CREATE TABLE ").append(src).append(" (c0 INT) ").append($this.defaultUsing()).toString());
        $this.sql().apply((Object)new StringBuilder(21).append("INSERT INTO ").append(src).append(" SELECT 0").toString());
        $this.sql().apply((Object)new StringBuilder(30).append("ALTER TABLE ").append(src).append(" RENAME TO dst_tbl").toString());
        $this.checkTables("ns", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"dst_tbl"}));
        QueryTest$.MODULE$.checkAnswer((Dataset<Row>)((Dataset)$this.sql().apply((Object)new StringBuilder(15).append("SELECT c0 FROM ").append(dst).toString())), (Seq<Row>)((Seq)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)0)})), (List)Nil$.MODULE$)), QueryTest$.MODULE$.checkAnswer$default$3());
    }

    private StorageLevel getStorageLevel$1(String tableName) {
        Dataset table = this.spark().table(tableName);
        CachedData cachedData = (CachedData)this.spark().sharedState().cacheManager().lookupCachedData(table).get();
        return cachedData.cachedRepresentation().cacheBuilder().storageLevel();
    }

    public static /* synthetic */ void $anonfun$$init$$8(AlterTableRenameSuiteBase $this, String dst) {
        String src = dst.replace("dst", "src");
        $this.sql().apply((Object)new StringBuilder(23).append("CREATE TABLE ").append(src).append(" (c0 INT) ").append($this.defaultUsing()).toString());
        $this.sql().apply((Object)new StringBuilder(21).append("INSERT INTO ").append(src).append(" SELECT 0").toString());
        $this.sql().apply((Object)new StringBuilder(50).append("CACHE TABLE ").append(src).append(" OPTIONS('storageLevel' 'MEMORY_ONLY')").toString());
        StorageLevel oldStorageLevel = $this.getStorageLevel$1(src);
        $this.sql().apply((Object)new StringBuilder(33).append("ALTER TABLE ").append(src).append(" RENAME TO ns.dst_tbl").toString());
        QueryTest$.MODULE$.checkAnswer((Dataset<Row>)((Dataset)$this.sql().apply((Object)new StringBuilder(15).append("SELECT c0 FROM ").append(dst).toString())), (Seq<Row>)((Seq)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)0)})), (List)Nil$.MODULE$)), QueryTest$.MODULE$.checkAnswer$default$3());
        StorageLevel newStorageLevel = $this.getStorageLevel$1(dst);
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = ((TripleEquals)$this).convertToEqualizer((Object)oldStorageLevel);
        StorageLevel $org_scalatest_assert_macro_right = newStorageLevel;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableRenameSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 84));
    }

    public static /* synthetic */ void $anonfun$$init$$10(AlterTableRenameSuiteBase $this, String students) {
        $this.sql().apply((Object)new StringBuilder(37).append("CREATE TABLE ").append(students).append(" (age INT, name STRING) ").append($this.defaultUsing()).toString());
        $this.sql().apply((Object)new StringBuilder(29).append("INSERT INTO ").append(students).append(" SELECT 19, 'Ana'").toString());
        $this.spark().catalog().cacheTable(students);
        Seq expected = (Seq)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)19), "Ana"})), (List)Nil$.MODULE$);
        QueryTest$.MODULE$.checkAnswer((Dataset<Row>)$this.spark().table(students), (Seq<Row>)expected, QueryTest$.MODULE$.checkAnswer$default$3());
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool($this.spark().catalog().isCached(students), "AlterTableRenameSuiteBase.this.spark.catalog.isCached(students)", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"bad test: table was not cached in the first place", Prettifier$.MODULE$.default(), new Position("AlterTableRenameSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 96));
        String teachers = new StringBuilder(12).append($this.catalog()).append(".ns.teachers").toString();
        $this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{teachers}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            $this.sql().apply((Object)new StringBuilder(34).append("ALTER TABLE ").append(students).append(" RENAME TO ns.teachers").toString());
            $this.sql().apply((Object)new StringBuilder(37).append("CREATE TABLE ").append(students).append(" (age INT, name STRING) ").append($this.defaultUsing()).toString());
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool($this.spark().catalog().isCached(students), "AlterTableRenameSuiteBase.this.spark.catalog.isCached(students)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableRenameSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 105));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool($this.spark().catalog().isCached(teachers), "AlterTableRenameSuiteBase.this.spark.catalog.isCached(teachers)", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableRenameSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 106));
            Object[] $org_scalatest_assert_macro_left = Predef$.MODULE$.refArrayOps((Object[])$this.spark().table(students).collect());
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.unaryMacroBool((Object)new ArrayOps.ofRef($org_scalatest_assert_macro_left), "isEmpty", new ArrayOps.ofRef($org_scalatest_assert_macro_left).isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableRenameSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 107));
            QueryTest$.MODULE$.checkAnswer((Dataset<Row>)$this.spark().table(teachers), (Seq<Row>)expected, QueryTest$.MODULE$.checkAnswer$default$3());
        });
    }

    public static /* synthetic */ void $anonfun$$init$$13(AlterTableRenameSuiteBase $this, String dst) {
        String src = dst.replace("dst", "src");
        $this.sql().apply((Object)new StringBuilder(23).append("CREATE TABLE ").append(src).append(" (c0 INT) ").append($this.defaultUsing()).toString());
        $this.sql().apply((Object)new StringBuilder(21).append("INSERT INTO ").append(src).append(" SELECT 0").toString());
        $this.sql().apply((Object)new StringBuilder(7).append("USE ").append($this.catalog()).append(".ns").toString());
        $this.sql().apply((Object)"ALTER TABLE src_tbl RENAME TO dst_tbl");
        $this.checkTables("ns", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"dst_tbl"}));
        $this.org$apache$spark$sql$execution$command$AlterTableRenameSuiteBase$$super$checkAnswer((Function0 & Serializable & scala.Serializable)() -> (Dataset)$this.sql().apply((Object)new StringBuilder(15).append("SELECT c0 FROM ").append(dst).toString()), (Seq)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)0)})), (List)Nil$.MODULE$));
    }

    public static /* synthetic */ void $anonfun$$init$$16(AlterTableRenameSuiteBase $this, String dst) {
        String src = dst.replace("dst", "src");
        $this.sql().apply((Object)new StringBuilder(48).append("CREATE TABLE ").append(src).append(" (i int, j int) ").append($this.defaultUsing()).append(" partitioned by (j)").toString());
        $this.sql().apply((Object)new StringBuilder(44).append("insert into table ").append(src).append(" partition(j=2) values (1)").toString());
        $this.sql().apply((Object)new StringBuilder(33).append("ALTER TABLE ").append(src).append(" RENAME TO ns.dst_tbl").toString());
        $this.org$apache$spark$sql$execution$command$AlterTableRenameSuiteBase$$super$checkAnswer((Function0 & Serializable & scala.Serializable)() -> $this.spark().table(dst), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)2)})));
    }

    public static /* synthetic */ void $anonfun$$init$$19(AlterTableRenameSuiteBase $this, String t) {
        $this.sql().apply((Object)new StringBuilder(26).append("CREATE TABLE ").append(t).append("_Old (i int) ").append($this.defaultUsing()).toString());
        $this.sql().apply((Object)new StringBuilder(64).append("ALTER TABLE ").append(t).append("_Old RENAME TO CaseUpperCaseLower.CaseUpperCaseLower").toString());
        Dataset $org_scalatest_assert_macro_left = $this.spark().table(t);
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableRenameSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 144));
    }

    public static void $init$(AlterTableRenameSuiteBase $this) {
        $this.org$apache$spark$sql$execution$command$AlterTableRenameSuiteBase$_setter_$command_$eq("ALTER TABLE .. RENAME");
        $this.test("rename a table in a database/namespace", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.withNamespaceAndTable("ns", "dst_tbl", $this.withNamespaceAndTable$default$3(), (Function1<String, BoxedUnit>)(Function1 & Serializable & scala.Serializable)dst -> {
            AlterTableRenameSuiteBase.$anonfun$$init$$2($this, dst);
            return BoxedUnit.UNIT;
        }), new Position("AlterTableRenameSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 37));
        $this.test("table to rename does not exist", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            String errMsg;
            String $org_scalatest_assert_macro_left = errMsg = ((AnalysisException)((Object)((Object)((Assertions)$this).intercept((Function0 & Serializable & scala.Serializable)() -> (Dataset)$this.sql().apply((Object)new StringBuilder(50).append("ALTER TABLE ").append($this.catalog()).append(".dbx.does_not_exist RENAME TO dbx.tab2").toString()), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("AlterTableRenameSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 50))))).getMessage();
            String $org_scalatest_assert_macro_right = "Table or view not found";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("AlterTableRenameSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 53));
        }, new Position("AlterTableRenameSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 49));
        $this.test("omit namespace in the destination table", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.withNamespaceAndTable("ns", "dst_tbl", $this.withNamespaceAndTable$default$3(), (Function1<String, BoxedUnit>)(Function1 & Serializable & scala.Serializable)dst -> {
            AlterTableRenameSuiteBase.$anonfun$$init$$6($this, dst);
            return BoxedUnit.UNIT;
        }), new Position("AlterTableRenameSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 56));
        $this.test("SPARK-33786: Cache's storage level should be respected when a table name is altered", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.withNamespaceAndTable("ns", "dst_tbl", $this.withNamespaceAndTable$default$3(), (Function1<String, BoxedUnit>)(Function1 & Serializable & scala.Serializable)dst -> {
            AlterTableRenameSuiteBase.$anonfun$$init$$8($this, dst);
            return BoxedUnit.UNIT;
        }), new Position("AlterTableRenameSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 68));
        $this.test("rename cached table", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.withNamespaceAndTable("ns", "students", $this.withNamespaceAndTable$default$3(), (Function1<String, BoxedUnit>)(Function1 & Serializable & scala.Serializable)students -> {
            AlterTableRenameSuiteBase.$anonfun$$init$$10($this, students);
            return BoxedUnit.UNIT;
        }), new Position("AlterTableRenameSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 88));
        $this.test("rename without explicitly specifying database", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            BoxedUnit boxedUnit;
            try {
                $this.withNamespaceAndTable("ns", "dst_tbl", $this.withNamespaceAndTable$default$3(), (Function1<String, BoxedUnit>)(Function1 & Serializable & scala.Serializable)dst -> {
                    AlterTableRenameSuiteBase.$anonfun$$init$$13($this, dst);
                    return BoxedUnit.UNIT;
                });
                boxedUnit = BoxedUnit.UNIT;
            }
            finally {
                $this.spark().sessionState().catalogManager().reset();
            }
            return boxedUnit;
        }, new Position("AlterTableRenameSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 113));
        $this.test("SPARK-37963: preserve partition info", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.withNamespaceAndTable("ns", "dst_tbl", $this.withNamespaceAndTable$default$3(), (Function1<String, BoxedUnit>)(Function1 & Serializable & scala.Serializable)dst -> {
            AlterTableRenameSuiteBase.$anonfun$$init$$16($this, dst);
            return BoxedUnit.UNIT;
        }), new Position("AlterTableRenameSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 130));
        $this.test("SPARK-38587: use formatted names", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.withNamespaceAndTable("CaseUpperCaseLower", "CaseUpperCaseLower", $this.withNamespaceAndTable$default$3(), (Function1<String, BoxedUnit>)(Function1 & Serializable & scala.Serializable)t -> {
            AlterTableRenameSuiteBase.$anonfun$$init$$19($this, t);
            return BoxedUnit.UNIT;
        }), new Position("AlterTableRenameSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 140));
    }
}

