/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connector;

import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.catalyst.InternalRow$;
import org.apache.spark.sql.catalyst.expressions.TransformExpression;
import org.apache.spark.sql.catalyst.expressions.TransformExpression$;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.physical.ClusteredDistribution;
import org.apache.spark.sql.catalyst.plans.physical.ClusteredDistribution$;
import org.apache.spark.sql.catalyst.plans.physical.KeyGroupedPartitioning$;
import org.apache.spark.sql.catalyst.plans.physical.Partitioning;
import org.apache.spark.sql.catalyst.plans.physical.SinglePartition$;
import org.apache.spark.sql.catalyst.plans.physical.UnknownPartitioning;
import org.apache.spark.sql.catalyst.plans.physical.UnspecifiedDistribution$;
import org.apache.spark.sql.connector.DistributionAndOrderingSuiteBase;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.InMemoryTableCatalog;
import org.apache.spark.sql.connector.catalog.functions.BoundFunction;
import org.apache.spark.sql.connector.catalog.functions.BucketFunction$;
import org.apache.spark.sql.connector.catalog.functions.UnboundBucketFunction$;
import org.apache.spark.sql.connector.catalog.functions.UnboundDaysFunction$;
import org.apache.spark.sql.connector.catalog.functions.UnboundYearsFunction$;
import org.apache.spark.sql.connector.catalog.functions.YearsFunction$;
import org.apache.spark.sql.connector.distributions.Distribution;
import org.apache.spark.sql.connector.distributions.Distributions;
import org.apache.spark.sql.connector.expressions.Expressions;
import org.apache.spark.sql.connector.expressions.SortOrder;
import org.apache.spark.sql.connector.expressions.Transform;
import org.apache.spark.sql.execution.SparkPlan;
import org.apache.spark.sql.execution.datasources.v2.BatchScanExec;
import org.apache.spark.sql.execution.datasources.v2.DataSourceV2ScanRelation;
import org.apache.spark.sql.execution.exchange.ShuffleExchangeExec;
import org.apache.spark.sql.execution.joins.SortMergeJoinExec;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampType$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import org.scalatest.compatible.Assertion;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005h\u0001B\u0013'\u0001EBQA\u000e\u0001\u0005\u0002]Bq!\u000f\u0001A\u0002\u0013%!\bC\u0004B\u0001\u0001\u0007I\u0011\u0002\"\t\r!\u0003\u0001\u0015)\u0003<\u0011\u001dI\u0005\u00011A\u0005\n)CqA\u0014\u0001A\u0002\u0013%q\n\u0003\u0004R\u0001\u0001\u0006Ka\u0013\u0005\u0006%\u0002!\te\u0015\u0005\u0006)\u0002!\te\u0015\u0005\b+\u0002\u0011\r\u0011\"\u0003W\u0011\u0019Q\u0007\u0001)A\u0005/\"91\u000e\u0001b\u0001\n\u0013a\u0007BB7\u0001A\u0003%q\fC\u0004o\u0001\t\u0007I\u0011B8\t\rY\u0004\u0001\u0015!\u0003q\u0011\u00159\b\u0001\"\u0003y\u0011\u001d\t9\u0004\u0001C\u0005\u0003sA\u0011\"a\u0019\u0001#\u0003%I!!\u001a\t\u0011\u0005m\u0004A1A\u0005\n1Dq!! \u0001A\u0003%q\f\u0003\u0005\u0002\u0000\u0001\u0011\r\u0011\"\u0003p\u0011\u001d\t\t\t\u0001Q\u0001\nAD\u0001\"a!\u0001\u0005\u0004%I\u0001\u001c\u0005\b\u0003\u000b\u0003\u0001\u0015!\u0003`\u0011!\t9\t\u0001b\u0001\n\u0013y\u0007bBAE\u0001\u0001\u0006I\u0001\u001d\u0005\b\u0003\u0017\u0003A\u0011BAG\u0011\u001d\t\t\u000b\u0001C\u0005\u0003GC\u0001\"!5\u0001\u0005\u0004%I\u0001\u001c\u0005\b\u0003'\u0004\u0001\u0015!\u0003`\u0011!\t)\u000e\u0001b\u0001\n\u0013y\u0007bBAl\u0001\u0001\u0006I\u0001\u001d\u0005\t\u00033\u0004!\u0019!C\u0005Y\"9\u00111\u001c\u0001!\u0002\u0013y\u0006\u0002CAo\u0001\t\u0007I\u0011B8\t\u000f\u0005}\u0007\u0001)A\u0005a\nY2*Z=He>,\b/\u001a3QCJ$\u0018\u000e^5p]&twmU;ji\u0016T!a\n\u0015\u0002\u0013\r|gN\\3di>\u0014(BA\u0015+\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003W1\nQa\u001d9be.T!!\f\u0018\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005y\u0013aA8sO\u000e\u00011C\u0001\u00013!\t\u0019D'D\u0001'\u0013\t)dE\u0001\u0011ESN$(/\u001b2vi&|g.\u00118e\u001fJ$WM]5oON+\u0018\u000e^3CCN,\u0017A\u0002\u001fj]&$h\bF\u00019!\t\u0019\u0004!\u0001\u000epe&<\u0017N\\1m-J\u0012UoY6fi&tw-\u00128bE2,G-F\u0001<!\tat(D\u0001>\u0015\u0005q\u0014!B:dC2\f\u0017B\u0001!>\u0005\u001d\u0011un\u001c7fC:\fad\u001c:jO&t\u0017\r\u001c,3\u0005V\u001c7.\u001a;j]\u001e,e.\u00192mK\u0012|F%Z9\u0015\u0005\r3\u0005C\u0001\u001fE\u0013\t)UH\u0001\u0003V]&$\bbB$\u0004\u0003\u0003\u0005\raO\u0001\u0004q\u0012\n\u0014aG8sS\u001eLg.\u00197We\t+8m[3uS:<WI\\1cY\u0016$\u0007%\u0001\u0012pe&<\u0017N\\1m\u0003V$xN\u0011:pC\u0012\u001c\u0017m\u001d;K_&tG\u000b\u001b:fg\"|G\u000eZ\u000b\u0002\u0017B\u0011A\bT\u0005\u0003\u001bv\u0012A\u0001T8oO\u00061sN]5hS:\fG.Q;u_\n\u0013x.\u00193dCN$(j\\5o)\"\u0014Xm\u001d5pY\u0012|F%Z9\u0015\u0005\r\u0003\u0006bB$\u0007\u0003\u0003\u0005\raS\u0001$_JLw-\u001b8bY\u0006+Ho\u001c\"s_\u0006$7-Y:u\u0015>Lg\u000e\u00165sKNDw\u000e\u001c3!\u0003%\u0011WMZ8sK\u0006cG\u000eF\u0001D\u0003!\tg\r^3s\u00032d\u0017AC3naRL\bK]8qgV\tq\u000b\u0005\u0003Y;~{V\"A-\u000b\u0005i[\u0016\u0001B;uS2T\u0011\u0001X\u0001\u0005U\u00064\u0018-\u0003\u0002_3\n\u0019Q*\u00199\u0011\u0005\u0001<gBA1f!\t\u0011W(D\u0001d\u0015\t!\u0007'\u0001\u0004=e>|GOP\u0005\u0003Mv\na\u0001\u0015:fI\u00164\u0017B\u00015j\u0005\u0019\u0019FO]5oO*\u0011a-P\u0001\fK6\u0004H/\u001f)s_B\u001c\b%A\u0003uC\ndW-F\u0001`\u0003\u0019!\u0018M\u00197fA\u000511o\u00195f[\u0006,\u0012\u0001\u001d\t\u0003cRl\u0011A\u001d\u0006\u0003g\"\nQ\u0001^=qKNL!!\u001e:\u0003\u0015M#(/^2u)f\u0004X-A\u0004tG\",W.\u0019\u0011\u0002\u001d\rDWmY6Rk\u0016\u0014\u0018\u0010\u00157b]R11)_A\u000b\u0003[AQA\u001f\tA\u0002m\f!\u0001\u001a4\u0011\u0007q\fyAD\u0002~\u0003\u0017q1A`A\u0005\u001d\ry\u0018q\u0001\b\u0005\u0003\u0003\t)AD\u0002c\u0003\u0007I\u0011aL\u0005\u0003[9J!a\u000b\u0017\n\u0005%R\u0013bAA\u0007Q\u00059\u0001/Y2lC\u001e,\u0017\u0002BA\t\u0003'\u0011\u0011\u0002R1uC\u001a\u0013\u0018-\\3\u000b\u0007\u00055\u0001\u0006C\u0004\u0002\u0018A\u0001\r!!\u0007\u0002\u0019\u0011L7\u000f\u001e:jEV$\u0018n\u001c8\u0011\t\u0005m\u0011\u0011F\u0007\u0003\u0003;QA!a\b\u0002\"\u0005A\u0001\u000f[=tS\u000e\fGN\u0003\u0003\u0002$\u0005\u0015\u0012!\u00029mC:\u001c(bAA\u0014Q\u0005A1-\u0019;bYf\u001cH/\u0003\u0003\u0002,\u0005u!\u0001\u0004#jgR\u0014\u0018NY;uS>t\u0007bBA\u0018!\u0001\u0007\u0011\u0011G\u0001\ra\u0006\u0014H/\u001b;j_:Lgn\u001a\t\u0005\u00037\t\u0019$\u0003\u0003\u00026\u0005u!\u0001\u0004)beRLG/[8oS:<\u0017aC2sK\u0006$X\rV1cY\u0016$\u0012bQA\u001e\u0003{\ty$!\u0016\t\u000b-\f\u0002\u0019A0\t\u000b9\f\u0002\u0019\u00019\t\u000f\u0005\u0005\u0013\u00031\u0001\u0002D\u0005Q\u0001/\u0019:uSRLwN\\:\u0011\u000bq\n)%!\u0013\n\u0007\u0005\u001dSHA\u0003BeJ\f\u0017\u0010\u0005\u0003\u0002L\u0005ESBAA'\u0015\r\tyEJ\u0001\fKb\u0004(/Z:tS>t7/\u0003\u0003\u0002T\u00055#!\u0003+sC:\u001chm\u001c:n\u0011%\t9&\u0005I\u0001\u0002\u0004\tI&A\u0004dCR\fGn\\4\u0011\t\u0005m\u0013qL\u0007\u0003\u0003;R1!a\u0016'\u0013\u0011\t\t'!\u0018\u0003)%sW*Z7pef$\u0016M\u00197f\u0007\u0006$\u0018\r\\8h\u0003U\u0019'/Z1uKR\u000b'\r\\3%I\u00164\u0017-\u001e7uIQ*\"!a\u001a+\t\u0005e\u0013\u0011N\u0016\u0003\u0003W\u0002B!!\u001c\u0002x5\u0011\u0011q\u000e\u0006\u0005\u0003c\n\u0019(A\u0005v]\u000eDWmY6fI*\u0019\u0011QO\u001f\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002z\u0005=$!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006I1-^:u_6,'o]\u0001\u000bGV\u001cHo\\7feN\u0004\u0013\u0001E2vgR|W.\u001a:t?N\u001c\u0007.Z7b\u0003E\u0019Wo\u001d;p[\u0016\u00148oX:dQ\u0016l\u0017\rI\u0001\u0007_J$WM]:\u0002\u000f=\u0014H-\u001a:tA\u0005iqN\u001d3feN|6o\u00195f[\u0006\fab\u001c:eKJ\u001cxl]2iK6\f\u0007%\u0001\u000euKN$x+\u001b;i\u0007V\u001cHo\\7feN\fe\u000eZ(sI\u0016\u00148\u000fF\u0004D\u0003\u001f\u000b\u0019*a&\t\u000f\u0005E5\u00041\u0001\u0002D\u0005!2-^:u_6,'o]0qCJ$\u0018\u000e^5p]NDq!!&\u001c\u0001\u0004\t\u0019%A\tpe\u0012,'o]0qCJ$\u0018\u000e^5p]NDq!!'\u001c\u0001\u0004\tY*A\rfqB,7\r^3e\u001dVlwJZ*ik\u001a4G.Z#yK\u000e\u001c\bc\u0001\u001f\u0002\u001e&\u0019\u0011qT\u001f\u0003\u0007%sG/A\bd_2dWm\u0019;TQV4g\r\\3t)\u0011\t)+!2\u0011\r\u0005\u001d\u0016qVA[\u001d\u0011\tI+!,\u000f\u0007\t\fY+C\u0001?\u0013\r\ti!P\u0005\u0005\u0003c\u000b\u0019LA\u0002TKFT1!!\u0004>!\u0011\t9,!1\u000e\u0005\u0005e&\u0002BA^\u0003{\u000b\u0001\"\u001a=dQ\u0006tw-\u001a\u0006\u0004\u0003\u007fC\u0013!C3yK\u000e,H/[8o\u0013\u0011\t\u0019-!/\u0003'MCWO\u001a4mK\u0016C8\r[1oO\u0016,\u00050Z2\t\u000f\u0005\u001dG\u00041\u0001\u0002J\u0006!\u0001\u000f\\1o!\u0011\tY-!4\u000e\u0005\u0005u\u0016\u0002BAh\u0003{\u0013\u0011b\u00159be.\u0004F.\u00198\u0002\u000b%$X-\\:\u0002\r%$X-\\:!\u00031IG/Z7t?N\u001c\u0007.Z7b\u00035IG/Z7t?N\u001c\u0007.Z7bA\u0005I\u0001/\u001e:dQ\u0006\u001cXm]\u0001\u000baV\u00148\r[1tKN\u0004\u0013\u0001\u00059ve\u000eD\u0017m]3t?N\u001c\u0007.Z7b\u0003E\u0001XO]2iCN,7oX:dQ\u0016l\u0017\r\t")
public class KeyGroupedPartitioningSuite
extends DistributionAndOrderingSuiteBase {
    private boolean originalV2BucketingEnabled = false;
    private long originalAutoBroadcastJoinThreshold = -1L;
    private final Map<String, String> emptyProps;
    private final String table;
    private final StructType schema;
    private final String customers;
    private final StructType customers_schema;
    private final String orders;
    private final StructType orders_schema;
    private final String items;
    private final StructType items_schema;
    private final String purchases;
    private final StructType purchases_schema;

    private boolean originalV2BucketingEnabled() {
        return this.originalV2BucketingEnabled;
    }

    private void originalV2BucketingEnabled_$eq(boolean x$1) {
        this.originalV2BucketingEnabled = x$1;
    }

    private long originalAutoBroadcastJoinThreshold() {
        return this.originalAutoBroadcastJoinThreshold;
    }

    private void originalAutoBroadcastJoinThreshold_$eq(long x$1) {
        this.originalAutoBroadcastJoinThreshold = x$1;
    }

    @Override
    public void beforeAll() {
        super.beforeAll();
        this.originalV2BucketingEnabled_$eq(BoxesRunTime.unboxToBoolean((Object)this.conf().getConf(SQLConf$.MODULE$.V2_BUCKETING_ENABLED())));
        this.conf().setConf(SQLConf$.MODULE$.V2_BUCKETING_ENABLED(), (Object)BoxesRunTime.boxToBoolean((boolean)true));
        this.originalAutoBroadcastJoinThreshold_$eq(BoxesRunTime.unboxToLong((Object)this.conf().getConf(SQLConf$.MODULE$.AUTO_BROADCASTJOIN_THRESHOLD())));
        this.conf().setConf(SQLConf$.MODULE$.AUTO_BROADCASTJOIN_THRESHOLD(), (Object)BoxesRunTime.boxToLong((long)-1L));
    }

    @Override
    public void afterAll() {
        try {
            super.afterAll();
        }
        finally {
            this.conf().setConf(SQLConf$.MODULE$.V2_BUCKETING_ENABLED(), (Object)BoxesRunTime.boxToBoolean((boolean)this.originalV2BucketingEnabled()));
            this.conf().setConf(SQLConf$.MODULE$.AUTO_BROADCASTJOIN_THRESHOLD(), (Object)BoxesRunTime.boxToLong((long)this.originalAutoBroadcastJoinThreshold()));
        }
    }

    private Map<String, String> emptyProps() {
        return this.emptyProps;
    }

    private String table() {
        return this.table;
    }

    private StructType schema() {
        return this.schema;
    }

    private void checkQueryPlan(Dataset<Row> df, org.apache.spark.sql.catalyst.plans.physical.Distribution distribution, Partitioning partitioning) {
        Partitioning expectedPartitioning;
        Assertion assertion;
        DataSourceV2ScanRelation relation = (DataSourceV2ScanRelation)df.queryExecution().optimizedPlan().collect((PartialFunction)new scala.Serializable(null){
            public static final long serialVersionUID = 0L;

            public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                DataSourceV2ScanRelation dataSourceV2ScanRelation;
                A1 A1 = x1;
                Object object = A1 instanceof DataSourceV2ScanRelation ? (dataSourceV2ScanRelation = (DataSourceV2ScanRelation)A1) : function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(LogicalPlan x1) {
                LogicalPlan logicalPlan = x1;
                boolean bl = logicalPlan instanceof DataSourceV2ScanRelation;
                return bl;
            }
        }).head();
        org.apache.spark.sql.catalyst.plans.physical.Distribution distribution2 = this.resolveDistribution(distribution, relation);
        if (distribution2 instanceof ClusteredDistribution) {
            Bool bool;
            ClusteredDistribution clusteredDistribution = (ClusteredDistribution)distribution2;
            Seq clustering = clusteredDistribution.clustering();
            Bool $org_scalatest_assert_macro_left = Bool$.MODULE$.simpleMacroBool(relation.keyGroupedPartitioning().isDefined(), "relation.keyGroupedPartitioning.isDefined", Prettifier$.MODULE$.default());
            if ($org_scalatest_assert_macro_left.value()) {
                Seq $org_scalatest_assert_macro_left2 = (Seq)relation.keyGroupedPartitioning().get();
                Seq $org_scalatest_assert_macro_right = clustering;
                Seq seq = $org_scalatest_assert_macro_left2;
                Seq seq2 = $org_scalatest_assert_macro_right;
                bool = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right, !(seq != null ? !seq.equals(seq2) : seq2 != null), Prettifier$.MODULE$.default());
            } else {
                bool = Bool$.MODULE$.simpleMacroBool(false, "", Prettifier$.MODULE$.default());
            }
            Bool $org_scalatest_assert_macro_right = bool;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "&&", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$amp$amp((Function0 & Serializable & scala.Serializable)() -> $org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            assertion = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("KeyGroupedPartitioningSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 197));
        } else {
            Option $org_scalatest_assert_macro_left = relation.keyGroupedPartitioning();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default());
            assertion = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("KeyGroupedPartitioningSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 200));
        }
        BatchScanExec scan = (BatchScanExec)this.collect(df.queryExecution().executedPlan(), new scala.Serializable(null){
            public static final long serialVersionUID = 0L;

            public final <A1 extends SparkPlan, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                BatchScanExec batchScanExec;
                A1 A1 = x2;
                Object object = A1 instanceof BatchScanExec ? (batchScanExec = (BatchScanExec)A1) : function1.apply(x2);
                return (B1)object;
            }

            public final boolean isDefinedAt(SparkPlan x2) {
                SparkPlan sparkPlan2 = x2;
                boolean bl = sparkPlan2 instanceof BatchScanExec;
                return bl;
            }
        }).head();
        Partitioning $org_scalatest_assert_macro_left = expectedPartitioning = this.resolvePartitioning(partitioning, scan);
        Partitioning $org_scalatest_assert_macro_right = scan.outputPartitioning();
        Partitioning partitioning2 = $org_scalatest_assert_macro_left;
        Partitioning partitioning3 = $org_scalatest_assert_macro_right;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(partitioning2 != null ? !partitioning2.equals(partitioning3) : partitioning3 != null), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("KeyGroupedPartitioningSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 209));
    }

    private void createTable(String table, StructType schema, Transform[] partitions, InMemoryTableCatalog catalog) {
        catalog.createTable(Identifier.of((String[])((String[])((Object[])new String[]{"ns"})), (String)table), schema, partitions, this.emptyProps(), (Distribution)Distributions.unspecified(), (SortOrder[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(SortOrder.class)), (Option)None$.MODULE$);
    }

    private InMemoryTableCatalog createTable$default$4() {
        return this.catalog();
    }

    private String customers() {
        return this.customers;
    }

    private StructType customers_schema() {
        return this.customers_schema;
    }

    private String orders() {
        return this.orders;
    }

    private StructType orders_schema() {
        return this.orders_schema;
    }

    private void testWithCustomersAndOrders(Transform[] customers_partitions, Transform[] orders_partitions, int expectedNumOfShuffleExecs) {
        Seq<ShuffleExchangeExec> shuffles;
        this.createTable(this.customers(), this.customers_schema(), customers_partitions, this.createTable$default$4());
        this.sql().apply((Object)new StringBuilder(77).append("INSERT INTO testcat.ns.").append(this.customers()).append(" VALUES ").append("('aaa', 10, 1), ('bbb', 20, 2), ('ccc', 30, 3)").toString());
        this.createTable(this.orders(), this.orders_schema(), orders_partitions, this.createTable$default$4());
        this.sql().apply((Object)new StringBuilder(102).append("INSERT INTO testcat.ns.").append(this.orders()).append(" VALUES ").append("(100.0, 1), (200.0, 1), (150.0, 2), (250.0, 2), (350.0, 2), (400.50, 3)").toString());
        Dataset df = (Dataset)this.sql().apply((Object)new StringBuilder(156).append("SELECT customer_name, customer_age, order_amount ").append("FROM testcat.ns.").append(this.customers()).append(" c JOIN testcat.ns.").append(this.orders()).append(" o ").append("ON c.customer_id = o.customer_id ORDER BY c.customer_id, order_amount").toString());
        Seq<ShuffleExchangeExec> $org_scalatest_assert_macro_left = shuffles = this.collectShuffles(df.queryExecution().executedPlan());
        int $org_scalatest_assert_macro_right = expectedNumOfShuffleExecs;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool($org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("KeyGroupedPartitioningSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 249));
        this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> df, (Seq<Row>)((Seq)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"aaa", BoxesRunTime.boxToInteger((int)10), BoxesRunTime.boxToDouble((double)100.0)})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"aaa", BoxesRunTime.boxToInteger((int)10), BoxesRunTime.boxToDouble((double)200.0)})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"bbb", BoxesRunTime.boxToInteger((int)20), BoxesRunTime.boxToDouble((double)150.0)})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"bbb", BoxesRunTime.boxToInteger((int)20), BoxesRunTime.boxToDouble((double)250.0)})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"bbb", BoxesRunTime.boxToInteger((int)20), BoxesRunTime.boxToDouble((double)350.0)})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"ccc", BoxesRunTime.boxToInteger((int)30), BoxesRunTime.boxToDouble((double)400.5)})), (List)Nil$.MODULE$))))))));
    }

    private Seq<ShuffleExchangeExec> collectShuffles(SparkPlan plan) {
        return (Seq)this.collect(plan, new scala.Serializable(null){
            public static final long serialVersionUID = 0L;

            public final <A1 extends SparkPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                SortMergeJoinExec sortMergeJoinExec;
                A1 A1 = x1;
                Object object = A1 instanceof SortMergeJoinExec ? (sortMergeJoinExec = (SortMergeJoinExec)A1) : function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(SparkPlan x1) {
                SparkPlan sparkPlan2 = x1;
                boolean bl = sparkPlan2 instanceof SortMergeJoinExec;
                return bl;
            }
        }).flatMap((Function1 & Serializable & scala.Serializable)smj -> this.collect((SparkPlan)smj, new scala.Serializable(null){
            public static final long serialVersionUID = 0L;

            public final <A1 extends SparkPlan, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                ShuffleExchangeExec shuffleExchangeExec;
                A1 A1 = x2;
                Object object = A1 instanceof ShuffleExchangeExec ? (shuffleExchangeExec = (ShuffleExchangeExec)A1) : function1.apply(x2);
                return (B1)object;
            }

            public final boolean isDefinedAt(SparkPlan x2) {
                SparkPlan sparkPlan2 = x2;
                boolean bl = sparkPlan2 instanceof ShuffleExchangeExec;
                return bl;
            }
        }), Seq$.MODULE$.canBuildFrom());
    }

    private String items() {
        return this.items;
    }

    private StructType items_schema() {
        return this.items_schema;
    }

    private String purchases() {
        return this.purchases;
    }

    private StructType purchases_schema() {
        return this.purchases_schema;
    }

    public KeyGroupedPartitioningSuite() {
        this.before((Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((IterableLike)new .colon.colon((Object)UnboundYearsFunction$.MODULE$, (List)new .colon.colon((Object)UnboundDaysFunction$.MODULE$, (List)new .colon.colon((Object)UnboundBucketFunction$.MODULE$, (List)Nil$.MODULE$)))).foreach((Function1 & Serializable & scala.Serializable)f -> this.catalog().createFunction(Identifier.of((String[])((String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class))), (String)f.name()), f)), new Position("KeyGroupedPartitioningSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 61));
        this.after((Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.catalog().clearTables();
            this.catalog().clearFunctions();
        }, new Position("KeyGroupedPartitioningSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 67));
        this.emptyProps = Collections.emptyMap();
        this.table = "tbl";
        this.schema = new StructType().add("id", (DataType)IntegerType$.MODULE$).add("data", (DataType)StringType$.MODULE$).add("ts", (DataType)TimestampType$.MODULE$);
        this.test("clustered distribution: output partitioning should be KeyGroupedPartitioning", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Transform[] partitions = (Transform[])((Object[])new Transform[]{Expressions.years((String)"ts")});
            this.createTable(this.table(), this.schema(), partitions, this.createTable$default$4());
            this.sql().apply((Object)new StringBuilder(164).append("INSERT INTO testcat.ns.").append(this.table()).append(" VALUES ").append("(0, 'aaa', CAST('2022-01-01' AS timestamp)), ").append("(1, 'bbb', CAST('2021-01-01' AS timestamp)), ").append("(2, 'ccc', CAST('2020-01-01' AS timestamp))").toString());
            Dataset df = (Dataset)this.sql().apply((Object)new StringBuilder(44).append("SELECT count(*) FROM testcat.ns.").append(this.table()).append(" GROUP BY ts").toString());
            ClusteredDistribution catalystDistribution = new ClusteredDistribution((Seq)new .colon.colon((Object)new TransformExpression((BoundFunction)YearsFunction$.MODULE$, (Seq)new .colon.colon((Object)this.attr("ts"), (List)Nil$.MODULE$), TransformExpression$.MODULE$.apply$default$3()), (List)Nil$.MODULE$), ClusteredDistribution$.MODULE$.apply$default$2(), ClusteredDistribution$.MODULE$.apply$default$3());
            Seq partitionValues = (Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{50, 51, 52}))).map((Function1 & Serializable & scala.Serializable)v -> InternalRow$.MODULE$.fromSeq((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{BoxesRunTime.unboxToInt((Object)v)}))), Seq$.MODULE$.canBuildFrom());
            this.checkQueryPlan((Dataset<Row>)df, (org.apache.spark.sql.catalyst.plans.physical.Distribution)catalystDistribution, (Partitioning)KeyGroupedPartitioning$.MODULE$.apply(catalystDistribution.clustering(), partitionValues));
            df = (Dataset)this.sql().apply((Object)new StringBuilder(48).append("SELECT count(*) FROM testcat.ns.").append(this.table()).append(" GROUP BY id, ts").toString());
            this.checkQueryPlan((Dataset<Row>)df, (org.apache.spark.sql.catalyst.plans.physical.Distribution)catalystDistribution, (Partitioning)KeyGroupedPartitioning$.MODULE$.apply(catalystDistribution.clustering(), partitionValues));
        }, new Position("KeyGroupedPartitioningSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 81));
        this.test("non-clustered distribution: no partition", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Transform[] partitions = (Transform[])((Object[])new Transform[]{Expressions.bucket((int)32, (String[])new String[]{"ts"})});
            this.createTable(this.table(), this.schema(), partitions, this.createTable$default$4());
            Dataset df = (Dataset)this.sql().apply((Object)new StringBuilder(25).append("SELECT * FROM testcat.ns.").append(this.table()).toString());
            ClusteredDistribution distribution = new ClusteredDistribution((Seq)new .colon.colon((Object)new TransformExpression((BoundFunction)BucketFunction$.MODULE$, (Seq)new .colon.colon((Object)this.attr("ts"), (List)Nil$.MODULE$), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)32))), (List)Nil$.MODULE$), ClusteredDistribution$.MODULE$.apply$default$2(), ClusteredDistribution$.MODULE$.apply$default$3());
            this.checkQueryPlan((Dataset<Row>)df, (org.apache.spark.sql.catalyst.plans.physical.Distribution)distribution, (Partitioning)new UnknownPartitioning(0));
        }, new Position("KeyGroupedPartitioningSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 105));
        this.test("non-clustered distribution: single partition", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Transform[] partitions = (Transform[])((Object[])new Transform[]{Expressions.bucket((int)32, (String[])new String[]{"ts"})});
            this.createTable(this.table(), this.schema(), partitions, this.createTable$default$4());
            this.sql().apply((Object)new StringBuilder(74).append("INSERT INTO testcat.ns.").append(this.table()).append(" VALUES (0, 'aaa', CAST('2020-01-01' AS timestamp))").toString());
            Dataset df = (Dataset)this.sql().apply((Object)new StringBuilder(25).append("SELECT * FROM testcat.ns.").append(this.table()).toString());
            ClusteredDistribution distribution = new ClusteredDistribution((Seq)new .colon.colon((Object)new TransformExpression((BoundFunction)BucketFunction$.MODULE$, (Seq)new .colon.colon((Object)this.attr("ts"), (List)Nil$.MODULE$), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)32))), (List)Nil$.MODULE$), ClusteredDistribution$.MODULE$.apply$default$2(), ClusteredDistribution$.MODULE$.apply$default$3());
            this.checkQueryPlan((Dataset<Row>)df, (org.apache.spark.sql.catalyst.plans.physical.Distribution)distribution, (Partitioning)SinglePartition$.MODULE$);
        }, new Position("KeyGroupedPartitioningSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 116));
        this.test("non-clustered distribution: no V2 catalog", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            BoxedUnit boxedUnit;
            this.spark().conf().set("spark.sql.catalog.testcat2", InMemoryTableCatalog.class.getName());
            InMemoryTableCatalog nonFunctionCatalog = (InMemoryTableCatalog)this.spark().sessionState().catalogManager().catalog("testcat2");
            Transform[] partitions = (Transform[])((Object[])new Transform[]{Expressions.bucket((int)32, (String[])new String[]{"ts"})});
            this.createTable(this.table(), this.schema(), partitions, nonFunctionCatalog);
            this.sql().apply((Object)new StringBuilder(165).append("INSERT INTO testcat2.ns.").append(this.table()).append(" VALUES ").append("(0, 'aaa', CAST('2022-01-01' AS timestamp)), ").append("(1, 'bbb', CAST('2021-01-01' AS timestamp)), ").append("(2, 'ccc', CAST('2020-01-01' AS timestamp))").toString());
            Dataset df = (Dataset)this.sql().apply((Object)new StringBuilder(26).append("SELECT * FROM testcat2.ns.").append(this.table()).toString());
            UnspecifiedDistribution$ distribution = UnspecifiedDistribution$.MODULE$;
            try {
                this.checkQueryPlan((Dataset<Row>)df, (org.apache.spark.sql.catalyst.plans.physical.Distribution)distribution, (Partitioning)new UnknownPartitioning(0));
                boxedUnit = BoxedUnit.UNIT;
            }
            finally {
                this.spark().conf().unset("spark.sql.catalog.testcat2");
            }
            return boxedUnit;
        }, new Position("KeyGroupedPartitioningSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 128));
        this.test("non-clustered distribution: no V2 function provided", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.catalog().clearFunctions();
            Transform[] partitions = (Transform[])((Object[])new Transform[]{Expressions.bucket((int)32, (String[])new String[]{"ts"})});
            this.createTable(this.table(), this.schema(), partitions, this.createTable$default$4());
            this.sql().apply((Object)new StringBuilder(164).append("INSERT INTO testcat.ns.").append(this.table()).append(" VALUES ").append("(0, 'aaa', CAST('2022-01-01' AS timestamp)), ").append("(1, 'bbb', CAST('2021-01-01' AS timestamp)), ").append("(2, 'ccc', CAST('2020-01-01' AS timestamp))").toString());
            Dataset df = (Dataset)this.sql().apply((Object)new StringBuilder(25).append("SELECT * FROM testcat.ns.").append(this.table()).toString());
            UnspecifiedDistribution$ distribution = UnspecifiedDistribution$.MODULE$;
            this.checkQueryPlan((Dataset<Row>)df, (org.apache.spark.sql.catalyst.plans.physical.Distribution)distribution, (Partitioning)new UnknownPartitioning(0));
        }, new Position("KeyGroupedPartitioningSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 149));
        this.test("non-clustered distribution: V2 bucketing disabled", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.V2_BUCKETING_ENABLED().key()), (Object)"false")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Transform[] partitions = (Transform[])((Object[])new Transform[]{Expressions.bucket((int)32, (String[])new String[]{"ts"})});
            this.createTable(this.table(), this.schema(), partitions, this.createTable$default$4());
            this.sql().apply((Object)new StringBuilder(164).append("INSERT INTO testcat.ns.").append(this.table()).append(" VALUES ").append("(0, 'aaa', CAST('2022-01-01' AS timestamp)), ").append("(1, 'bbb', CAST('2021-01-01' AS timestamp)), ").append("(2, 'ccc', CAST('2020-01-01' AS timestamp))").toString());
            Dataset df = (Dataset)this.sql().apply((Object)new StringBuilder(25).append("SELECT * FROM testcat.ns.").append(this.table()).toString());
            ClusteredDistribution distribution = new ClusteredDistribution((Seq)new .colon.colon((Object)new TransformExpression((BoundFunction)BucketFunction$.MODULE$, (Seq)new .colon.colon((Object)this.attr("ts"), (List)Nil$.MODULE$), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)32))), (List)Nil$.MODULE$), ClusteredDistribution$.MODULE$.apply$default$2(), ClusteredDistribution$.MODULE$.apply$default$3());
            this.checkQueryPlan((Dataset<Row>)df, (org.apache.spark.sql.catalyst.plans.physical.Distribution)distribution, (Partitioning)new UnknownPartitioning(0));
        }), new Position("KeyGroupedPartitioningSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 165));
        this.customers = "customers";
        this.customers_schema = new StructType().add("customer_name", (DataType)StringType$.MODULE$).add("customer_age", (DataType)IntegerType$.MODULE$).add("customer_id", (DataType)LongType$.MODULE$);
        this.orders = "orders";
        this.orders_schema = new StructType().add("order_amount", (DataType)DoubleType$.MODULE$).add("customer_id", (DataType)LongType$.MODULE$);
        this.test("partitioned join: exact distribution (same number of buckets) from both sides", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Transform[] customers_partitions = (Transform[])((Object[])new Transform[]{Expressions.bucket((int)4, (String[])new String[]{"customer_id"})});
            Transform[] orders_partitions = (Transform[])((Object[])new Transform[]{Expressions.bucket((int)4, (String[])new String[]{"customer_id"})});
            this.testWithCustomersAndOrders(customers_partitions, orders_partitions, 0);
        }, new Position("KeyGroupedPartitioningSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 266));
        this.test("partitioned join: number of buckets mismatch should trigger shuffle", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Transform[] customers_partitions = (Transform[])((Object[])new Transform[]{Expressions.bucket((int)4, (String[])new String[]{"customer_id"})});
            Transform[] orders_partitions = (Transform[])((Object[])new Transform[]{Expressions.bucket((int)2, (String[])new String[]{"customer_id"})});
            this.testWithCustomersAndOrders(customers_partitions, orders_partitions, 2);
        }, new Position("KeyGroupedPartitioningSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 273));
        this.test("partitioned join: only one side reports partitioning", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Transform[] customers_partitions = (Transform[])((Object[])new Transform[]{Expressions.bucket((int)4, (String[])new String[]{"customer_id"})});
            Transform[] orders_partitions = (Transform[])((Object[])new Transform[]{Expressions.bucket((int)2, (String[])new String[]{"customer_id"})});
            this.testWithCustomersAndOrders(customers_partitions, orders_partitions, 2);
        }, new Position("KeyGroupedPartitioningSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 281));
        this.items = "items";
        this.items_schema = new StructType().add("id", (DataType)LongType$.MODULE$).add("name", (DataType)StringType$.MODULE$).add("price", (DataType)FloatType$.MODULE$).add("arrive_time", (DataType)TimestampType$.MODULE$);
        this.purchases = "purchases";
        this.purchases_schema = new StructType().add("item_id", (DataType)LongType$.MODULE$).add("price", (DataType)FloatType$.MODULE$).add("time", (DataType)TimestampType$.MODULE$);
        this.test("partitioned join: join with two partition keys and matching & sorted partitions", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Seq<ShuffleExchangeExec> shuffles;
            Transform[] items_partitions = (Transform[])((Object[])new Transform[]{Expressions.bucket((int)8, (String[])new String[]{"id"}), Expressions.days((String)"arrive_time")});
            this.createTable(this.items(), this.items_schema(), items_partitions, this.createTable$default$4());
            this.sql().apply((Object)new StringBuilder(279).append("INSERT INTO testcat.ns.").append(this.items()).append(" VALUES ").append("(1, 'aa', 40.0, cast('2020-01-01' as timestamp)), ").append("(1, 'aa', 41.0, cast('2020-01-15' as timestamp)), ").append("(2, 'bb', 10.0, cast('2020-01-01' as timestamp)), ").append("(2, 'bb', 10.5, cast('2020-01-01' as timestamp)), ").append("(3, 'cc', 15.5, cast('2020-02-01' as timestamp))").toString());
            Transform[] purchases_partitions = (Transform[])((Object[])new Transform[]{Expressions.bucket((int)8, (String[])new String[]{"item_id"}), Expressions.days((String)"time")});
            this.createTable(this.purchases(), this.purchases_schema(), purchases_partitions, this.createTable$default$4());
            this.sql().apply((Object)new StringBuilder(249).append("INSERT INTO testcat.ns.").append(this.purchases()).append(" VALUES ").append("(1, 42.0, cast('2020-01-01' as timestamp)), ").append("(1, 44.0, cast('2020-01-15' as timestamp)), ").append("(1, 45.0, cast('2020-01-15' as timestamp)), ").append("(2, 11.0, cast('2020-01-01' as timestamp)), ").append("(3, 19.5, cast('2020-02-01' as timestamp))").toString());
            Dataset df = (Dataset)this.sql().apply((Object)new StringBuilder(190).append("SELECT id, name, i.price as purchase_price, p.price as sale_price ").append("FROM testcat.ns.").append(this.items()).append(" i JOIN testcat.ns.").append(this.purchases()).append(" p ").append("ON i.id = p.item_id AND i.arrive_time = p.time ORDER BY id, purchase_price, sale_price").toString());
            Seq<ShuffleExchangeExec> $org_scalatest_assert_macro_left = shuffles = this.collectShuffles(df.queryExecution().executedPlan());
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool($org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"should not add shuffle for both sides of the join", Prettifier$.MODULE$.default(), new Position("KeyGroupedPartitioningSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 325));
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> df, (Seq<Row>)((Seq)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "aa", BoxesRunTime.boxToDouble((double)40.0), BoxesRunTime.boxToDouble((double)42.0)})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "aa", BoxesRunTime.boxToDouble((double)41.0), BoxesRunTime.boxToDouble((double)44.0)})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "aa", BoxesRunTime.boxToDouble((double)41.0), BoxesRunTime.boxToDouble((double)45.0)})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "bb", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToDouble((double)11.0)})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "bb", BoxesRunTime.boxToDouble((double)10.5), BoxesRunTime.boxToDouble((double)11.0)})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "cc", BoxesRunTime.boxToDouble((double)15.5), BoxesRunTime.boxToDouble((double)19.5)})), (List)Nil$.MODULE$))))))));
        }, new Position("KeyGroupedPartitioningSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 301));
        this.test("partitioned join: join with two partition keys and unsorted partitions", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Seq<ShuffleExchangeExec> shuffles;
            Transform[] items_partitions = (Transform[])((Object[])new Transform[]{Expressions.bucket((int)8, (String[])new String[]{"id"}), Expressions.days((String)"arrive_time")});
            this.createTable(this.items(), this.items_schema(), items_partitions, this.createTable$default$4());
            this.sql().apply((Object)new StringBuilder(279).append("INSERT INTO testcat.ns.").append(this.items()).append(" VALUES ").append("(3, 'cc', 15.5, cast('2020-02-01' as timestamp)), ").append("(1, 'aa', 40.0, cast('2020-01-01' as timestamp)), ").append("(1, 'aa', 41.0, cast('2020-01-15' as timestamp)), ").append("(2, 'bb', 10.0, cast('2020-01-01' as timestamp)), ").append("(2, 'bb', 10.5, cast('2020-01-01' as timestamp))").toString());
            Transform[] purchases_partitions = (Transform[])((Object[])new Transform[]{Expressions.bucket((int)8, (String[])new String[]{"item_id"}), Expressions.days((String)"time")});
            this.createTable(this.purchases(), this.purchases_schema(), purchases_partitions, this.createTable$default$4());
            this.sql().apply((Object)new StringBuilder(249).append("INSERT INTO testcat.ns.").append(this.purchases()).append(" VALUES ").append("(2, 11.0, cast('2020-01-01' as timestamp)), ").append("(1, 42.0, cast('2020-01-01' as timestamp)), ").append("(1, 44.0, cast('2020-01-15' as timestamp)), ").append("(1, 45.0, cast('2020-01-15' as timestamp)), ").append("(3, 19.5, cast('2020-02-01' as timestamp))").toString());
            Dataset df = (Dataset)this.sql().apply((Object)new StringBuilder(190).append("SELECT id, name, i.price as purchase_price, p.price as sale_price ").append("FROM testcat.ns.").append(this.items()).append(" i JOIN testcat.ns.").append(this.purchases()).append(" p ").append("ON i.id = p.item_id AND i.arrive_time = p.time ORDER BY id, purchase_price, sale_price").toString());
            Seq<ShuffleExchangeExec> $org_scalatest_assert_macro_left = shuffles = this.collectShuffles(df.queryExecution().executedPlan());
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool($org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"should not add shuffle for both sides of the join", Prettifier$.MODULE$.default(), new Position("KeyGroupedPartitioningSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 356));
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> df, (Seq<Row>)((Seq)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "aa", BoxesRunTime.boxToDouble((double)40.0), BoxesRunTime.boxToDouble((double)42.0)})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "aa", BoxesRunTime.boxToDouble((double)41.0), BoxesRunTime.boxToDouble((double)44.0)})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "aa", BoxesRunTime.boxToDouble((double)41.0), BoxesRunTime.boxToDouble((double)45.0)})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "bb", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToDouble((double)11.0)})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "bb", BoxesRunTime.boxToDouble((double)10.5), BoxesRunTime.boxToDouble((double)11.0)})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "cc", BoxesRunTime.boxToDouble((double)15.5), BoxesRunTime.boxToDouble((double)19.5)})), (List)Nil$.MODULE$))))))));
        }, new Position("KeyGroupedPartitioningSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 332));
        this.test("partitioned join: join with two partition keys and different # of partition keys", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            Seq<ShuffleExchangeExec> shuffles;
            Transform[] items_partitions = (Transform[])((Object[])new Transform[]{Expressions.bucket((int)8, (String[])new String[]{"id"}), Expressions.days((String)"arrive_time")});
            this.createTable(this.items(), this.items_schema(), items_partitions, this.createTable$default$4());
            this.sql().apply((Object)new StringBuilder(179).append("INSERT INTO testcat.ns.").append(this.items()).append(" VALUES ").append("(1, 'aa', 40.0, cast('2020-01-01' as timestamp)), ").append("(2, 'bb', 10.0, cast('2020-01-01' as timestamp)), ").append("(3, 'cc', 15.5, cast('2020-02-01' as timestamp))").toString());
            Transform[] purchases_partitions = (Transform[])((Object[])new Transform[]{Expressions.bucket((int)8, (String[])new String[]{"item_id"}), Expressions.days((String)"time")});
            this.createTable(this.purchases(), this.purchases_schema(), purchases_partitions, this.createTable$default$4());
            this.sql().apply((Object)new StringBuilder(117).append("INSERT INTO testcat.ns.").append(this.purchases()).append(" VALUES ").append("(1, 42.0, cast('2020-01-01' as timestamp)), ").append("(2, 11.0, cast('2020-01-01' as timestamp))").toString());
            Dataset df = (Dataset)this.sql().apply((Object)new StringBuilder(190).append("SELECT id, name, i.price as purchase_price, p.price as sale_price ").append("FROM testcat.ns.").append(this.items()).append(" i JOIN testcat.ns.").append(this.purchases()).append(" p ").append("ON i.id = p.item_id AND i.arrive_time = p.time ORDER BY id, purchase_price, sale_price").toString());
            Seq<ShuffleExchangeExec> $org_scalatest_assert_macro_left = shuffles = this.collectShuffles(df.queryExecution().executedPlan());
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool($org_scalatest_assert_macro_left, "nonEmpty", $org_scalatest_assert_macro_left.nonEmpty(), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"should add shuffle when partition keys mismatch", Prettifier$.MODULE$.default(), new Position("KeyGroupedPartitioningSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 383));
        }, new Position("KeyGroupedPartitioningSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 363));
        this.test("data source partitioning + dynamic partition filtering", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.AUTO_BROADCASTJOIN_THRESHOLD().key()), (Object)"10MB"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ADAPTIVE_EXECUTION_ENABLED().key()), (Object)"false"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.DYNAMIC_PARTITION_PRUNING_ENABLED().key()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.DYNAMIC_PARTITION_PRUNING_REUSE_BROADCAST_ONLY().key()), (Object)"false"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.DYNAMIC_PARTITION_PRUNING_FALLBACK_FILTER_RATIO().key()), (Object)"10")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Seq<ShuffleExchangeExec> shuffles;
            Transform[] items_partitions = (Transform[])((Object[])new Transform[]{Expressions.identity((String)"id")});
            this.createTable(this.items(), this.items_schema(), items_partitions, this.createTable$default$4());
            this.sql().apply((Object)new StringBuilder(279).append("INSERT INTO testcat.ns.").append(this.items()).append(" VALUES ").append("(1, 'aa', 40.0, cast('2020-01-01' as timestamp)), ").append("(1, 'aa', 41.0, cast('2020-01-15' as timestamp)), ").append("(2, 'bb', 10.0, cast('2020-01-01' as timestamp)), ").append("(2, 'bb', 10.5, cast('2020-01-01' as timestamp)), ").append("(3, 'cc', 15.5, cast('2020-02-01' as timestamp))").toString());
            Transform[] purchases_partitions = (Transform[])((Object[])new Transform[]{Expressions.identity((String)"item_id")});
            this.createTable(this.purchases(), this.purchases_schema(), purchases_partitions, this.createTable$default$4());
            this.sql().apply((Object)new StringBuilder(249).append("INSERT INTO testcat.ns.").append(this.purchases()).append(" VALUES ").append("(1, 42.0, cast('2020-01-01' as timestamp)), ").append("(1, 44.0, cast('2020-01-15' as timestamp)), ").append("(1, 45.0, cast('2020-01-15' as timestamp)), ").append("(2, 11.0, cast('2020-01-01' as timestamp)), ").append("(3, 19.5, cast('2020-02-01' as timestamp))").toString());
            ObjectRef df = ObjectRef.create((Object)((Dataset)this.sql().apply((Object)new StringBuilder(95).append("SELECT sum(p.price) from testcat.ns.").append(this.items()).append(" i, testcat.ns.").append(this.purchases()).append(" p WHERE ").append("i.id = p.item_id AND i.price > 40.0").toString())));
            Exception e = (Exception)this.intercept((Function0 & Serializable & scala.Serializable)() -> (Row[])((Dataset)df$4.elem).collect(), ClassTag$.MODULE$.apply(Exception.class), new Position("KeyGroupedPartitioningSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 414));
            String $org_scalatest_assert_macro_left = e.getMessage();
            String $org_scalatest_assert_macro_right = "number of unique partition values";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("KeyGroupedPartitioningSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 415));
            df.elem = (Dataset)this.sql().apply((Object)new StringBuilder(96).append("SELECT sum(p.price) from testcat.ns.").append(this.items()).append(" i, testcat.ns.").append(this.purchases()).append(" p WHERE ").append("i.id = p.item_id AND i.price >= 10.0").toString());
            Seq<ShuffleExchangeExec> $org_scalatest_assert_macro_left2 = shuffles = this.collectShuffles(((Dataset)df.elem).queryExecution().executedPlan());
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.unaryMacroBool($org_scalatest_assert_macro_left2, "isEmpty", $org_scalatest_assert_macro_left2.isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"should not add shuffle for both sides of the join", Prettifier$.MODULE$.default(), new Position("KeyGroupedPartitioningSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 421));
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> (Dataset)df$4.elem, (Seq<Row>)((Seq)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)303.5)})), (List)Nil$.MODULE$)));
        }), new Position("KeyGroupedPartitioningSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 386));
    }
}

